/* DownloadCellRenderer.c generated by valac 0.56.17, the Vala compiler
 * generated from DownloadCellRenderer.vala, do not modify */

/*
    DownloadCellRenderer.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_PADDING 4
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE 32
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER (steadyflow_ui_download_cell_renderer_get_type ())
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRenderer))
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRendererClass))
#define STEADYFLOW_UI_IS_DOWNLOAD_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER))
#define STEADYFLOW_UI_IS_DOWNLOAD_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER))
#define STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRendererClass))

typedef struct _SteadyflowUIDownloadCellRenderer SteadyflowUIDownloadCellRenderer;
typedef struct _SteadyflowUIDownloadCellRendererClass SteadyflowUIDownloadCellRendererClass;
typedef struct _SteadyflowUIDownloadCellRendererPrivate SteadyflowUIDownloadCellRendererPrivate;

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE (steadyflow_core_idownload_file_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE))
#define STEADYFLOW_CORE_IDOWNLOAD_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFileIface))

typedef struct _SteadyflowCoreIDownloadFile SteadyflowCoreIDownloadFile;
typedef struct _SteadyflowCoreIDownloadFileIface SteadyflowCoreIDownloadFileIface;
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR
} SteadyflowCoreIDownloadFileStatus;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS (steadyflow_core_idownload_file_status_get_type ())
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_DO_NOTHING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND
} SteadyflowCoreIDownloadFileFinishAction;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION (steadyflow_core_idownload_file_finish_action_get_type ())
enum  {
	STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_0_PROPERTY,
	STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_FILE_PROPERTY,
	STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_NUM_PROPERTIES
};
static GParamSpec* steadyflow_ui_download_cell_renderer_properties[STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SteadyflowUIDownloadCellRenderer {
	GtkCellRenderer parent_instance;
	SteadyflowUIDownloadCellRendererPrivate * priv;
};

struct _SteadyflowUIDownloadCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _SteadyflowCoreIDownloadFileIface {
	GTypeInterface parent_iface;
	void (*start) (SteadyflowCoreIDownloadFile* self, gboolean resume);
	void (*pause) (SteadyflowCoreIDownloadFile* self);
	void (*serialize) (SteadyflowCoreIDownloadFile* self, GKeyFile* file);
	SteadyflowCoreIDownloadFileStatus (*get_status) (SteadyflowCoreIDownloadFile* self);
	gint (*get_uid) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_url) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_name) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_basename) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_size) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_downloaded_size) (SteadyflowCoreIDownloadFile* self);
	gint (*get_speed) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_icon_name) (SteadyflowCoreIDownloadFile* self);
	SteadyflowCoreIDownloadFileFinishAction (*get_finish_action) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_finish_command) (SteadyflowCoreIDownloadFile* self);
	GError* (*get_error) (SteadyflowCoreIDownloadFile* self);
};

struct _SteadyflowUIDownloadCellRendererPrivate {
	SteadyflowCoreIDownloadFile* _file;
	GtkCellRendererPixbuf* icon_renderer;
	GtkCellRendererText* text_over_renderer;
	GtkCellRendererText* text_under_renderer;
	GtkCellRendererProgress* progress_renderer;
	GTimer* timer;
	GeeMap* pirates_treasure;
};

static gint SteadyflowUIDownloadCellRenderer_private_offset;
static gpointer steadyflow_ui_download_cell_renderer_parent_class = NULL;

VALA_EXTERN GType steadyflow_ui_download_cell_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowUIDownloadCellRenderer, g_object_unref)
VALA_EXTERN GType steadyflow_core_idownload_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_finish_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadFile, g_object_unref)
static GdkPixbuf* steadyflow_ui_download_cell_renderer_get_pixbuf (SteadyflowUIDownloadCellRenderer* self,
                                                            const gchar* icon_name);
VALA_EXTERN SteadyflowUIDownloadCellRenderer* steadyflow_ui_download_cell_renderer_new (void);
VALA_EXTERN SteadyflowUIDownloadCellRenderer* steadyflow_ui_download_cell_renderer_construct (GType object_type);
static void steadyflow_ui_download_cell_renderer_real_get_size (GtkCellRenderer* base,
                                                         GtkWidget* widget,
                                                         GdkRectangle* cell_area,
                                                         gint* x_offset,
                                                         gint* y_offset,
                                                         gint* width,
                                                         gint* height);
static void steadyflow_ui_download_cell_renderer_real_render (GtkCellRenderer* base,
                                                       cairo_t* cr,
                                                       GtkWidget* widget,
                                                       GdkRectangle* background_area,
                                                       GdkRectangle* cell,
                                                       GtkCellRendererState flags);
static gchar* steadyflow_ui_download_cell_renderer_get_time_remaining (SteadyflowUIDownloadCellRenderer* self,
                                                                gint64 file_size,
                                                                gint64 downloaded_size,
                                                                gint64 speed);
static gchar* steadyflow_ui_download_cell_renderer_format_file_size (SteadyflowUIDownloadCellRenderer* self,
                                                              guint64 size);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_ui_download_cell_renderer_get_file (SteadyflowUIDownloadCellRenderer* self);
VALA_EXTERN void steadyflow_ui_download_cell_renderer_set_file (SteadyflowUIDownloadCellRenderer* self,
                                                    SteadyflowCoreIDownloadFile* value);
VALA_EXTERN gint64 steadyflow_core_idownload_file_get_size (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN SteadyflowCoreIDownloadFileStatus steadyflow_core_idownload_file_get_status (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gint64 steadyflow_core_idownload_file_get_downloaded_size (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_local_basename (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gint steadyflow_core_idownload_file_get_speed (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN GError* steadyflow_core_idownload_file_get_error (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_icon_name (SteadyflowCoreIDownloadFile* self);
static void steadyflow_ui_download_cell_renderer_finalize (GObject * obj);
static GType steadyflow_ui_download_cell_renderer_get_type_once (void);
static void _vala_steadyflow_ui_download_cell_renderer_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_steadyflow_ui_download_cell_renderer_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
steadyflow_ui_download_cell_renderer_get_instance_private (SteadyflowUIDownloadCellRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, SteadyflowUIDownloadCellRenderer_private_offset);
}

static GdkPixbuf*
steadyflow_ui_download_cell_renderer_get_pixbuf (SteadyflowUIDownloadCellRenderer* self,
                                                 const gchar* icon_name)
{
	GdkPixbuf* pixbuf = NULL;
	GeeMap* _tmp0_;
	GeeMap* _tmp11_;
	GdkPixbuf* _tmp12_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	pixbuf = NULL;
	if (icon_name == NULL) {
		result = NULL;
		_g_object_unref0 (pixbuf);
		return result;
	}
	_tmp0_ = self->priv->pirates_treasure;
	if (gee_map_has_key (_tmp0_, icon_name)) {
		GeeMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->pirates_treasure;
		_tmp2_ = gee_map_get (_tmp1_, icon_name);
		result = (GdkPixbuf*) _tmp2_;
		_g_object_unref0 (pixbuf);
		return result;
	}
	{
		GdkPixbuf* _tmp3_ = NULL;
		GtkIconTheme* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp4_ = gtk_icon_theme_get_default ();
		_tmp5_ = gtk_icon_theme_load_icon (_tmp4_, icon_name, STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE, 0, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp6_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		{
			GdkPixbuf* _tmp7_ = NULL;
			GtkIconTheme* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp8_ = gtk_icon_theme_get_default ();
			_tmp9_ = gtk_icon_theme_load_icon (_tmp8_, GTK_STOCK_FILE, STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE, 0, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp10_;
			_g_object_unref0 (_tmp7_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			_g_object_unref0 (pixbuf);
			pixbuf = NULL;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = self->priv->pirates_treasure;
	_tmp12_ = pixbuf;
	gee_map_set (_tmp11_, icon_name, _tmp12_);
	result = pixbuf;
	return result;
}

SteadyflowUIDownloadCellRenderer*
steadyflow_ui_download_cell_renderer_construct (GType object_type)
{
	SteadyflowUIDownloadCellRenderer * self = NULL;
	GeeHashMap* _tmp0_;
	GtkCellRendererPixbuf* _tmp1_;
	GtkCellRendererText* _tmp2_;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererProgress* _tmp4_;
	GTimer* _tmp5_;
	GTimer* _tmp6_;
	self = (SteadyflowUIDownloadCellRenderer*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->pirates_treasure);
	self->priv->pirates_treasure = (GeeMap*) _tmp0_;
	_tmp1_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->icon_renderer);
	self->priv->icon_renderer = _tmp1_;
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->text_over_renderer);
	self->priv->text_over_renderer = _tmp2_;
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->text_under_renderer);
	self->priv->text_under_renderer = _tmp3_;
	_tmp4_ = (GtkCellRendererProgress*) gtk_cell_renderer_progress_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->progress_renderer);
	self->priv->progress_renderer = _tmp4_;
	_tmp5_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp5_;
	_tmp6_ = self->priv->timer;
	g_timer_start (_tmp6_);
	return self;
}

SteadyflowUIDownloadCellRenderer*
steadyflow_ui_download_cell_renderer_new (void)
{
	return steadyflow_ui_download_cell_renderer_construct (STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER);
}

static void
steadyflow_ui_download_cell_renderer_real_get_size (GtkCellRenderer* base,
                                                    GtkWidget* widget,
                                                    GdkRectangle* cell_area,
                                                    gint* x_offset,
                                                    gint* y_offset,
                                                    gint* width,
                                                    gint* height)
{
	SteadyflowUIDownloadCellRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint textheight_over = 0;
	gint textheight_under = 0;
	GtkCellRendererText* _tmp0_;
	gint _tmp1_ = 0;
	GtkCellRendererText* _tmp2_;
	gint _tmp3_ = 0;
	GtkCellRendererProgress* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	self = (SteadyflowUIDownloadCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->text_over_renderer;
	gtk_cell_renderer_get_size ((GtkCellRenderer*) _tmp0_, widget, NULL, NULL, NULL, NULL, &_tmp1_);
	textheight_over = _tmp1_;
	_tmp2_ = self->priv->text_under_renderer;
	gtk_cell_renderer_get_size ((GtkCellRenderer*) _tmp2_, widget, NULL, NULL, NULL, NULL, &_tmp3_);
	textheight_under = _tmp3_;
	_tmp4_ = self->priv->progress_renderer;
	gtk_cell_renderer_get_size ((GtkCellRenderer*) _tmp4_, widget, cell_area, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	_vala_x_offset = _tmp5_;
	_vala_y_offset = _tmp6_;
	_vala_width = _tmp7_;
	_vala_height = _tmp8_;
	_vala_height = (((2 * STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_PADDING) + textheight_over) + _vala_height) + textheight_under;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
steadyflow_ui_download_cell_renderer_real_render (GtkCellRenderer* base,
                                                  cairo_t* cr,
                                                  GtkWidget* widget,
                                                  GdkRectangle* background_area,
                                                  GdkRectangle* cell,
                                                  GtkCellRendererState flags)
{
	SteadyflowUIDownloadCellRenderer * self;
	gint textheight_over = 0;
	gint textheight_under = 0;
	gint progressheight = 0;
	gint x = 0;
	GdkRectangle _tmp0_;
	gint y = 0;
	GdkRectangle _tmp1_;
	gint width = 0;
	GdkRectangle _tmp2_;
	GtkCellRendererText* _tmp3_;
	gint _tmp4_ = 0;
	GtkCellRendererText* _tmp5_;
	gint _tmp6_ = 0;
	GtkCellRendererProgress* _tmp7_;
	gint _tmp8_ = 0;
	GdkRectangle icon_rect = {0};
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_ = {0};
	GdkRectangle text_over_rect = {0};
	GdkRectangle _tmp13_ = {0};
	GdkRectangle progress_rect = {0};
	GdkRectangle _tmp14_;
	GdkRectangle _tmp15_ = {0};
	GdkRectangle text_under_rect = {0};
	GdkRectangle _tmp16_;
	GdkRectangle _tmp17_;
	GdkRectangle _tmp18_ = {0};
	GtkCellRendererPixbuf* _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	GtkCellRendererText* _tmp22_;
	GdkRectangle _tmp23_;
	GdkRectangle _tmp24_;
	GtkCellRendererProgress* _tmp25_;
	GdkRectangle _tmp26_;
	GdkRectangle _tmp27_;
	GtkCellRendererText* _tmp28_;
	GdkRectangle _tmp29_;
	GdkRectangle _tmp30_;
	self = (SteadyflowUIDownloadCellRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell != NULL);
	_tmp0_ = *cell;
	x = (_tmp0_.x + (2 * STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_PADDING)) + STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE;
	_tmp1_ = *cell;
	y = _tmp1_.y + STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_PADDING;
	_tmp2_ = *cell;
	width = (_tmp2_.width - x) - STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_PADDING;
	_tmp3_ = self->priv->text_over_renderer;
	gtk_cell_renderer_get_size ((GtkCellRenderer*) _tmp3_, widget, NULL, NULL, NULL, NULL, &_tmp4_);
	textheight_over = _tmp4_;
	_tmp5_ = self->priv->text_under_renderer;
	gtk_cell_renderer_get_size ((GtkCellRenderer*) _tmp5_, widget, NULL, NULL, NULL, NULL, &_tmp6_);
	textheight_under = _tmp6_;
	_tmp7_ = self->priv->progress_renderer;
	gtk_cell_renderer_get_size ((GtkCellRenderer*) _tmp7_, widget, NULL, NULL, NULL, NULL, &_tmp8_);
	progressheight = _tmp8_;
	_tmp9_ = *cell;
	_tmp10_ = *cell;
	_tmp11_ = *cell;
	memset (&_tmp12_, 0, sizeof (GdkRectangle));
	_tmp12_.x = _tmp9_.x + STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_PADDING;
	_tmp12_.y = _tmp10_.y + ((_tmp11_.height - STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE) / 2);
	_tmp12_.width = STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE;
	_tmp12_.height = STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_ICON_SIZE;
	icon_rect = _tmp12_;
	memset (&_tmp13_, 0, sizeof (GdkRectangle));
	_tmp13_.x = x;
	_tmp13_.y = y;
	_tmp13_.width = width;
	_tmp13_.height = textheight_over;
	text_over_rect = _tmp13_;
	_tmp14_ = text_over_rect;
	memset (&_tmp15_, 0, sizeof (GdkRectangle));
	_tmp15_.x = x;
	_tmp15_.y = y + _tmp14_.height;
	_tmp15_.width = width;
	_tmp15_.height = progressheight;
	progress_rect = _tmp15_;
	_tmp16_ = progress_rect;
	_tmp17_ = progress_rect;
	memset (&_tmp18_, 0, sizeof (GdkRectangle));
	_tmp18_.x = x;
	_tmp18_.y = _tmp16_.y + _tmp17_.height;
	_tmp18_.width = width;
	_tmp18_.height = textheight_under;
	text_under_rect = _tmp18_;
	_tmp19_ = self->priv->icon_renderer;
	_tmp20_ = icon_rect;
	_tmp21_ = icon_rect;
	gtk_cell_renderer_render ((GtkCellRenderer*) _tmp19_, cr, widget, &_tmp20_, &_tmp21_, flags);
	_tmp22_ = self->priv->text_over_renderer;
	_tmp23_ = text_over_rect;
	_tmp24_ = text_over_rect;
	gtk_cell_renderer_render ((GtkCellRenderer*) _tmp22_, cr, widget, &_tmp23_, &_tmp24_, flags);
	_tmp25_ = self->priv->progress_renderer;
	_tmp26_ = progress_rect;
	_tmp27_ = progress_rect;
	gtk_cell_renderer_render ((GtkCellRenderer*) _tmp25_, cr, widget, &_tmp26_, &_tmp27_, flags);
	_tmp28_ = self->priv->text_under_renderer;
	_tmp29_ = text_under_rect;
	_tmp30_ = text_under_rect;
	gtk_cell_renderer_render ((GtkCellRenderer*) _tmp28_, cr, widget, &_tmp29_, &_tmp30_, flags);
}

static gchar*
steadyflow_ui_download_cell_renderer_get_time_remaining (SteadyflowUIDownloadCellRenderer* self,
                                                         gint64 file_size,
                                                         gint64 downloaded_size,
                                                         gint64 speed)
{
	gint64 size_remaining = 0LL;
	gint64 seconds = 0LL;
	gint64 minutes = 0LL;
	gint64 hours = 0LL;
	gint64 days = 0LL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (speed <= ((gint64) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("unknown time remaining"));
		result = _tmp0_;
		return result;
	}
	if (file_size <= downloaded_size) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("a few seconds remaining"));
		result = _tmp1_;
		return result;
	}
	size_remaining = file_size - downloaded_size;
	seconds = size_remaining / speed;
	if (seconds < ((gint64) 60)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf (ngettext ("%d second remaining", "%d seconds remaining", (gulong) ((gint) seconds)), (gint) seconds);
		result = _tmp2_;
		return result;
	}
	minutes = seconds / 60;
	if (minutes < ((gint64) 60)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup_printf (ngettext ("%d minute remaining", "%d minutes remaining", (gulong) ((gint) minutes)), (gint) minutes);
		result = _tmp3_;
		return result;
	}
	hours = minutes / 60;
	minutes = minutes % 60;
	if (hours < ((gint64) 24)) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = g_strdup_printf (ngettext ("%d hour", "%d hours", (gulong) ((gint) hours)), (gint) hours);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf (ngettext ("%s, %d minute remaining", "%s, %d minutes remaining", (gulong) ((gint) minutes)), _tmp5_, (gint) minutes);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	}
	days = hours / 24;
	hours = hours % 24;
	_tmp8_ = g_strdup_printf (ngettext ("%d day", "%d days", (gulong) ((gint) days)), (gint) days);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (ngettext ("%s, %d hour remaining", "%s, %d hour remaining", (gulong) ((gint) hours)), _tmp9_, (gint) hours);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	result = _tmp11_;
	return result;
}

static gchar*
steadyflow_ui_download_cell_renderer_format_file_size (SteadyflowUIDownloadCellRenderer* self,
                                                       guint64 size)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_format_size_full (size, G_FORMAT_SIZE_IEC_UNITS);
	result = _tmp0_;
	return result;
}

SteadyflowCoreIDownloadFile*
steadyflow_ui_download_cell_renderer_get_file (SteadyflowUIDownloadCellRenderer* self)
{
	SteadyflowCoreIDownloadFile* result;
	SteadyflowCoreIDownloadFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
steadyflow_ui_download_cell_renderer_set_file (SteadyflowUIDownloadCellRenderer* self,
                                               SteadyflowCoreIDownloadFile* value)
{
	SteadyflowCoreIDownloadFile* _tmp0_;
	SteadyflowCoreIDownloadFile* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	GtkCellRendererText* _tmp46_;
	SteadyflowCoreIDownloadFile* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	SteadyflowCoreIDownloadFile* _tmp52_;
	SteadyflowCoreIDownloadFileStatus _tmp53_;
	SteadyflowCoreIDownloadFileStatus _tmp54_;
	GtkCellRendererPixbuf* _tmp95_;
	SteadyflowCoreIDownloadFile* _tmp96_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	GdkPixbuf* _tmp99_;
	GdkPixbuf* _tmp100_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
	_tmp1_ = self->priv->_file;
	_tmp2_ = steadyflow_core_idownload_file_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((gint64) 0)) {
		SteadyflowCoreIDownloadFile* _tmp4_;
		SteadyflowCoreIDownloadFileStatus _tmp5_;
		SteadyflowCoreIDownloadFileStatus _tmp6_;
		gint _tmp10_ = 0;
		SteadyflowCoreIDownloadFile* _tmp11_;
		SteadyflowCoreIDownloadFileStatus _tmp12_;
		SteadyflowCoreIDownloadFileStatus _tmp13_;
		GtkCellRendererProgress* _tmp14_;
		GtkCellRendererProgress* _tmp15_;
		SteadyflowCoreIDownloadFile* _tmp16_;
		gint64 _tmp17_;
		gint64 _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp4_ = self->priv->_file;
		_tmp5_ = steadyflow_core_idownload_file_get_status (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING) {
			GtkCellRendererProgress* _tmp7_;
			_tmp7_ = self->priv->progress_renderer;
			g_object_set (_tmp7_, "pulse", -1, NULL);
		} else {
			GtkCellRendererProgress* _tmp8_;
			GTimer* _tmp9_;
			_tmp8_ = self->priv->progress_renderer;
			_tmp9_ = self->priv->timer;
			g_object_set (_tmp8_, "pulse", (((gint) ((guint) (g_timer_elapsed (_tmp9_, NULL) * 5))) % 100000) + 1, NULL);
		}
		_tmp11_ = self->priv->_file;
		_tmp12_ = steadyflow_core_idownload_file_get_status (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED) {
			_tmp10_ = 100;
		} else {
			_tmp10_ = 0;
		}
		_tmp14_ = self->priv->progress_renderer;
		g_object_set (_tmp14_, "value", _tmp10_, NULL);
		_tmp15_ = self->priv->progress_renderer;
		_tmp16_ = self->priv->_file;
		_tmp17_ = steadyflow_core_idownload_file_get_downloaded_size (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = steadyflow_ui_download_cell_renderer_format_file_size (self, (guint64) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf (_ ("%s downloaded"), _tmp20_);
		_tmp22_ = _tmp21_;
		g_object_set (_tmp15_, "text", _tmp22_, NULL);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
	} else {
		GtkCellRendererProgress* _tmp23_;
		gint progress = 0;
		SteadyflowCoreIDownloadFile* _tmp24_;
		gint64 _tmp25_;
		gint64 _tmp26_;
		SteadyflowCoreIDownloadFile* _tmp27_;
		gint64 _tmp28_;
		gint64 _tmp29_;
		GtkCellRendererProgress* _tmp30_;
		GtkCellRendererProgress* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		SteadyflowCoreIDownloadFile* _tmp34_;
		gint64 _tmp35_;
		gint64 _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		SteadyflowCoreIDownloadFile* _tmp39_;
		gint64 _tmp40_;
		gint64 _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp23_ = self->priv->progress_renderer;
		g_object_set (_tmp23_, "pulse", -1, NULL);
		_tmp24_ = self->priv->_file;
		_tmp25_ = steadyflow_core_idownload_file_get_downloaded_size (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_file;
		_tmp28_ = steadyflow_core_idownload_file_get_size (_tmp27_);
		_tmp29_ = _tmp28_;
		progress = (gint) ((((gdouble) _tmp26_) / _tmp29_) * 100);
		_tmp30_ = self->priv->progress_renderer;
		g_object_set (_tmp30_, "value", progress, NULL);
		_tmp31_ = self->priv->progress_renderer;
		_tmp32_ = g_strconcat (_ ("%s of %s downloaded"), " (%d%%)", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->_file;
		_tmp35_ = steadyflow_core_idownload_file_get_downloaded_size (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = steadyflow_ui_download_cell_renderer_format_file_size (self, (guint64) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = self->priv->_file;
		_tmp40_ = steadyflow_core_idownload_file_get_size (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = steadyflow_ui_download_cell_renderer_format_file_size (self, (guint64) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf (_tmp33_, _tmp38_, _tmp43_, progress);
		_tmp45_ = _tmp44_;
		g_object_set (_tmp31_, "text", _tmp45_, NULL);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp33_);
	}
	_tmp46_ = self->priv->text_over_renderer;
	_tmp47_ = self->priv->_file;
	_tmp48_ = steadyflow_core_idownload_file_get_local_basename (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_markup_printf_escaped ("<span weight='bold' size='larger'>%s</span>", _tmp49_);
	_tmp51_ = _tmp50_;
	g_object_set (_tmp46_, "markup", _tmp51_, NULL);
	_g_free0 (_tmp51_);
	_tmp52_ = self->priv->_file;
	_tmp53_ = steadyflow_core_idownload_file_get_status (_tmp52_);
	_tmp54_ = _tmp53_;
	switch (_tmp54_) {
		case STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING:
		{
			gchar* time_str = NULL;
			SteadyflowCoreIDownloadFile* _tmp55_;
			gint64 _tmp56_;
			gint64 _tmp57_;
			SteadyflowCoreIDownloadFile* _tmp58_;
			gint64 _tmp59_;
			gint64 _tmp60_;
			SteadyflowCoreIDownloadFile* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			gchar* _tmp64_;
			GtkCellRendererText* _tmp65_;
			SteadyflowCoreIDownloadFile* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			_tmp55_ = self->priv->_file;
			_tmp56_ = steadyflow_core_idownload_file_get_size (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = self->priv->_file;
			_tmp59_ = steadyflow_core_idownload_file_get_downloaded_size (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = self->priv->_file;
			_tmp62_ = steadyflow_core_idownload_file_get_speed (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = steadyflow_ui_download_cell_renderer_get_time_remaining (self, _tmp57_, _tmp60_, (gint64) _tmp63_);
			time_str = _tmp64_;
			_tmp65_ = self->priv->text_under_renderer;
			_tmp66_ = self->priv->_file;
			_tmp67_ = steadyflow_core_idownload_file_get_speed (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = steadyflow_ui_download_cell_renderer_format_file_size (self, (guint64) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strdup_printf (_ ("Downloading at speed %s/s"), _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = time_str;
			_tmp74_ = g_strdup_printf (" (%s)", _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strconcat (_tmp72_, _tmp75_, NULL);
			_tmp77_ = _tmp76_;
			g_object_set (_tmp65_, "text", _tmp77_, NULL);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			_g_free0 (time_str);
			break;
		}
		case STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING:
		{
			GtkCellRendererText* _tmp78_;
			_tmp78_ = self->priv->text_under_renderer;
			g_object_set (_tmp78_, "text", _ ("Connecting..."), NULL);
			break;
		}
		case STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED:
		{
			GtkCellRendererText* _tmp79_;
			_tmp79_ = self->priv->text_under_renderer;
			g_object_set (_tmp79_, "text", _ ("Download paused"), NULL);
			break;
		}
		case STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED:
		{
			GtkCellRendererText* _tmp80_;
			_tmp80_ = self->priv->text_under_renderer;
			g_object_set (_tmp80_, "text", _ ("Download finished"), NULL);
			break;
		}
		case STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR:
		{
			gchar* text = NULL;
			gchar* _tmp81_;
			SteadyflowCoreIDownloadFile* _tmp82_;
			GError* _tmp83_;
			GError* _tmp84_;
			GtkCellRendererText* _tmp93_;
			const gchar* _tmp94_;
			_tmp81_ = g_strdup (_ ("Download stopped: network error"));
			text = _tmp81_;
			_tmp82_ = self->priv->_file;
			_tmp83_ = steadyflow_core_idownload_file_get_error (_tmp82_);
			_tmp84_ = _tmp83_;
			if (_tmp84_ != NULL) {
				const gchar* _tmp85_;
				SteadyflowCoreIDownloadFile* _tmp86_;
				GError* _tmp87_;
				GError* _tmp88_;
				const gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				_tmp85_ = text;
				_tmp86_ = self->priv->_file;
				_tmp87_ = steadyflow_core_idownload_file_get_error (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = _tmp88_->message;
				_tmp90_ = g_strdup_printf (" (%s)", _tmp89_);
				_tmp91_ = _tmp90_;
				_tmp92_ = g_strconcat (_tmp85_, _tmp91_, NULL);
				_g_free0 (text);
				text = _tmp92_;
				_g_free0 (_tmp91_);
			}
			_tmp93_ = self->priv->text_under_renderer;
			_tmp94_ = text;
			g_object_set (_tmp93_, "text", _tmp94_, NULL);
			_g_free0 (text);
			break;
		}
		default:
		break;
	}
	_tmp95_ = self->priv->icon_renderer;
	_tmp96_ = self->priv->_file;
	_tmp97_ = steadyflow_core_idownload_file_get_icon_name (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = steadyflow_ui_download_cell_renderer_get_pixbuf (self, _tmp98_);
	_tmp100_ = _tmp99_;
	g_object_set (_tmp95_, "pixbuf", _tmp100_, NULL);
	_g_object_unref0 (_tmp100_);
	g_object_notify_by_pspec ((GObject *) self, steadyflow_ui_download_cell_renderer_properties[STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_FILE_PROPERTY]);
}

static void
steadyflow_ui_download_cell_renderer_class_init (SteadyflowUIDownloadCellRendererClass * klass,
                                                 gpointer klass_data)
{
	steadyflow_ui_download_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SteadyflowUIDownloadCellRenderer_private_offset);
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) steadyflow_ui_download_cell_renderer_real_get_size;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) steadyflow_ui_download_cell_renderer_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_steadyflow_ui_download_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_steadyflow_ui_download_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = steadyflow_ui_download_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_FILE_PROPERTY, steadyflow_ui_download_cell_renderer_properties[STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
steadyflow_ui_download_cell_renderer_instance_init (SteadyflowUIDownloadCellRenderer * self,
                                                    gpointer klass)
{
	self->priv = steadyflow_ui_download_cell_renderer_get_instance_private (self);
}

static void
steadyflow_ui_download_cell_renderer_finalize (GObject * obj)
{
	SteadyflowUIDownloadCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRenderer);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->icon_renderer);
	_g_object_unref0 (self->priv->text_over_renderer);
	_g_object_unref0 (self->priv->text_under_renderer);
	_g_object_unref0 (self->priv->progress_renderer);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->pirates_treasure);
	G_OBJECT_CLASS (steadyflow_ui_download_cell_renderer_parent_class)->finalize (obj);
}

static GType
steadyflow_ui_download_cell_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SteadyflowUIDownloadCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) steadyflow_ui_download_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SteadyflowUIDownloadCellRenderer), 0, (GInstanceInitFunc) steadyflow_ui_download_cell_renderer_instance_init, NULL };
	GType steadyflow_ui_download_cell_renderer_type_id;
	steadyflow_ui_download_cell_renderer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "SteadyflowUIDownloadCellRenderer", &g_define_type_info, 0);
	SteadyflowUIDownloadCellRenderer_private_offset = g_type_add_instance_private (steadyflow_ui_download_cell_renderer_type_id, sizeof (SteadyflowUIDownloadCellRendererPrivate));
	return steadyflow_ui_download_cell_renderer_type_id;
}

GType
steadyflow_ui_download_cell_renderer_get_type (void)
{
	static volatile gsize steadyflow_ui_download_cell_renderer_type_id__once = 0;
	if (g_once_init_enter (&steadyflow_ui_download_cell_renderer_type_id__once)) {
		GType steadyflow_ui_download_cell_renderer_type_id;
		steadyflow_ui_download_cell_renderer_type_id = steadyflow_ui_download_cell_renderer_get_type_once ();
		g_once_init_leave (&steadyflow_ui_download_cell_renderer_type_id__once, steadyflow_ui_download_cell_renderer_type_id);
	}
	return steadyflow_ui_download_cell_renderer_type_id__once;
}

static void
_vala_steadyflow_ui_download_cell_renderer_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	SteadyflowUIDownloadCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRenderer);
	switch (property_id) {
		case STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_FILE_PROPERTY:
		g_value_set_object (value, steadyflow_ui_download_cell_renderer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_steadyflow_ui_download_cell_renderer_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	SteadyflowUIDownloadCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STEADYFLOW_UI_TYPE_DOWNLOAD_CELL_RENDERER, SteadyflowUIDownloadCellRenderer);
	switch (property_id) {
		case STEADYFLOW_UI_DOWNLOAD_CELL_RENDERER_FILE_PROPERTY:
		steadyflow_ui_download_cell_renderer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

