/* book.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <webp/encode.h>
#include <webp/mux.h>
#include <glib/gi18n-lib.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*ProgressionCallback) (gdouble fraction, gpointer user_data);
typedef enum  {
	FLIP_EVERY_SECOND_Even = 1,
	FLIP_EVERY_SECOND_Odd = 0
} FlipEverySecond;

#define TYPE_FLIP_EVERY_SECOND (flip_every_second_get_type ())

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
enum  {
	BOOK_0_PROPERTY,
	BOOK_N_PAGES_PROPERTY,
	BOOK_NUM_PROPERTIES
};
static GParamSpec* book_properties[BOOK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BOOK_SAVER (book_saver_get_type ())
#define BOOK_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_SAVER, BookSaver))
#define BOOK_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_SAVER, BookSaverClass))
#define IS_BOOK_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_SAVER))
#define IS_BOOK_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_SAVER))
#define BOOK_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_SAVER, BookSaverClass))

typedef struct _BookSaver BookSaver;
typedef struct _BookSaverClass BookSaverClass;
#define _book_saver_unref0(var) ((var == NULL) ? NULL : (var = (book_saver_unref (var), NULL)))
typedef struct _BookSaveAsyncData BookSaveAsyncData;
typedef struct _BookPostprocessAsyncData BookPostprocessAsyncData;
enum  {
	BOOK_PAGE_ADDED_SIGNAL,
	BOOK_PAGE_REMOVED_SIGNAL,
	BOOK_REORDERED_SIGNAL,
	BOOK_CLEARED_SIGNAL,
	BOOK_CHANGED_SIGNAL,
	BOOK_NUM_SIGNALS
};
static guint book_signals[BOOK_NUM_SIGNALS] = {0};
typedef struct _BookSaverPrivate BookSaverPrivate;

#define TYPE_WRITE_TASK (write_task_get_type ())
#define WRITE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WRITE_TASK, WriteTask))
#define WRITE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WRITE_TASK, WriteTaskClass))
#define IS_WRITE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WRITE_TASK))
#define IS_WRITE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WRITE_TASK))
#define WRITE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WRITE_TASK, WriteTaskClass))

typedef struct _WriteTask WriteTask;
typedef struct _WriteTaskClass WriteTaskClass;

#define TYPE_ENCODE_TASK (encode_task_get_type ())
#define ENCODE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCODE_TASK, EncodeTask))
#define ENCODE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCODE_TASK, EncodeTaskClass))
#define IS_ENCODE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCODE_TASK))
#define IS_ENCODE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCODE_TASK))
#define ENCODE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCODE_TASK, EncodeTaskClass))

typedef struct _EncodeTask EncodeTask;
typedef struct _EncodeTaskClass EncodeTaskClass;

#define TYPE_POSTPROCESSOR (postprocessor_get_type ())
#define POSTPROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSTPROCESSOR, Postprocessor))
#define POSTPROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSTPROCESSOR, PostprocessorClass))
#define IS_POSTPROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSTPROCESSOR))
#define IS_POSTPROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSTPROCESSOR))
#define POSTPROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSTPROCESSOR, PostprocessorClass))

typedef struct _Postprocessor Postprocessor;
typedef struct _PostprocessorClass PostprocessorClass;
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _postprocessor_unref0(var) ((var == NULL) ? NULL : (var = (postprocessor_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _EncodeTaskPrivate EncodeTaskPrivate;
#define _encode_task_unref0(var) ((var == NULL) ? NULL : (var = (encode_task_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BookSaverSaveAsyncData BookSaverSaveAsyncData;
typedef struct _BookSaverPostprocessAsyncData BookSaverPostprocessAsyncData;
typedef struct _WriteTaskPrivate WriteTaskPrivate;
#define _write_task_unref0(var) ((var == NULL) ? NULL : (var = (write_task_unref (var), NULL)))
#define _WebPMuxDelete0(var) ((var == NULL) ? NULL : (var = (WebPMuxDelete (var), NULL)))

#define TYPE_WRITE_TASK_PDF (write_task_pdf_get_type ())
#define WRITE_TASK_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WRITE_TASK_PDF, WriteTaskPDF))
#define WRITE_TASK_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WRITE_TASK_PDF, WriteTaskPDFClass))
#define IS_WRITE_TASK_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WRITE_TASK_PDF))
#define IS_WRITE_TASK_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WRITE_TASK_PDF))
#define WRITE_TASK_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WRITE_TASK_PDF, WriteTaskPDFClass))

typedef struct _WriteTaskPDF WriteTaskPDF;
typedef struct _WriteTaskPDFClass WriteTaskPDFClass;
typedef struct _WriteTaskPDFPrivate WriteTaskPDFPrivate;

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _PDFWriterPrivate PDFWriterPrivate;
typedef struct _ParamSpecBookSaver ParamSpecBookSaver;
typedef struct _ParamSpecEncodeTask ParamSpecEncodeTask;
typedef struct _ParamSpecWriteTask ParamSpecWriteTask;
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Book {
	GObject parent_instance;
	BookPrivate * priv;
};

struct _BookClass {
	GObjectClass parent_class;
};

struct _BookPrivate {
	GList* pages;
};

struct _BookSaveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Book* self;
	gchar* mime_type;
	gint quality;
	GFile* file;
	ProgressionCallback progress_cb;
	gpointer progress_cb_target;
	GCancellable* cancellable;
	BookSaver* book_saver;
	BookSaver* _tmp0_;
	GError* _inner_error0_;
};

struct _BookPostprocessAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Book* self;
	gchar* mime_type;
	GFile* file;
	gboolean postproc_enabled;
	gchar* postproc_script;
	gchar* postproc_arguments;
	gboolean postproc_keep_original;
	BookSaver* book_saver;
	BookSaver* _tmp0_;
	GError* _inner_error0_;
};

struct _BookSaver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookSaverPrivate * priv;
};

struct _BookSaverClass {
	GTypeClass parent_class;
	void (*finalize) (BookSaver *self);
};

struct _BookSaverPrivate {
	guint n_pages;
	gint quality;
	GFile* file;
	ProgressionCallback progression_callback;
	gpointer progression_callback_target;
	gdouble progression;
	GMutex progression_mutex;
	GCancellable* cancellable;
	GAsyncQueue* write_queue;
	GThreadPool* encoder;
	GSourceFunc save_async_callback;
	gpointer save_async_callback_target;
	GDestroyNotify save_async_callback_target_destroy_notify;
	Postprocessor* postprocessor;
};

struct _EncodeTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EncodeTaskPrivate * priv;
	gint number;
	Page* page;
};

struct _EncodeTaskClass {
	GTypeClass parent_class;
	void (*finalize) (EncodeTask *self);
};

struct _BookSaverSaveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BookSaver* self;
	Book* book;
	gchar* mime_type;
	gint quality;
	GFile* file;
	ProgressionCallback progression_callback;
	gpointer progression_callback_target;
	GCancellable* cancellable;
	GTimer* timer;
	GTimer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GFile* _tmp3_;
	GCancellable* _tmp4_;
	GAsyncQueue* _tmp5_;
	GFunc encode_delegate;
	gpointer encode_delegate_target;
	GDestroyNotify encode_delegate_target_destroy_notify;
	const gchar* _tmp6_;
	GQuark _tmp8_;
	GThreadPool* _tmp9_;
	GFunc _tmp10_;
	gpointer _tmp10__target;
	GThreadPool* _tmp11_;
	GThreadPool* _tmp12_;
	GThread* writer;
	const gchar* _tmp13_;
	GQuark _tmp15_;
	GThread* _tmp16_;
	GThread* _tmp17_;
	GThread* _tmp18_;
	gint i;
	gboolean _tmp19_;
	gint _tmp20_;
	EncodeTask* encode_task;
	EncodeTask* _tmp21_;
	EncodeTask* _tmp22_;
	EncodeTask* _tmp23_;
	Page* _tmp24_;
	GThreadPool* _tmp25_;
	EncodeTask* _tmp26_;
	GError* _error_;
	GThread* _tmp27_;
	gpointer _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	GTimer* _tmp32_;
	GTimer* _tmp33_;
	GError* _inner_error0_;
};

struct _BookSaverPostprocessAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BookSaver* self;
	gchar* mime_type;
	GFile* file;
	gboolean postproc_enabled;
	gchar* postproc_script;
	gchar* postproc_arguments;
	gboolean postproc_keep_original;
	gboolean _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GTimer* timer;
	GTimer* _tmp3_;
	gint return_code;
	Postprocessor* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	GTimer* _tmp8_;
	GTimer* _tmp9_;
	GError* _inner_error0_;
};

struct _WriteTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WriteTaskPrivate * priv;
	gint number;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GError* error;
};

struct _WriteTaskClass {
	GTypeClass parent_class;
	void (*finalize) (WriteTask *self);
};

struct _WriteTaskPDF {
	WriteTask parent_instance;
	WriteTaskPDFPrivate * priv;
	gint width;
	gint height;
	gchar* color_space;
	gint depth;
	gchar* filter;
	gint dpi;
};

struct _WriteTaskPDFClass {
	WriteTaskClass parent_class;
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	guint* object_offsets;
	gint object_offsets_length1;
	gint _object_offsets_size_;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBookSaver {
	GParamSpec parent_instance;
};

struct _ParamSpecEncodeTask {
	GParamSpec parent_instance;
};

struct _ParamSpecWriteTask {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

static gint Book_private_offset;
static gpointer book_parent_class = NULL;
static gint BookSaver_private_offset;
static gpointer book_saver_parent_class = NULL;
static gpointer encode_task_parent_class = NULL;
static gpointer write_task_parent_class = NULL;
static gpointer write_task_pdf_parent_class = NULL;
static gint PDFWriter_private_offset;
static gpointer pdf_writer_parent_class = NULL;

VALA_EXTERN GType flip_every_second_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
static void book_page_changed_cb (Book* self,
                           Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender,
                                                gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender,
                                              gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN Book* book_new (void);
VALA_EXTERN Book* book_construct (GType object_type);
VALA_EXTERN void book_clear (Book* self);
VALA_EXTERN void book_append_page (Book* self,
                       Page* page);
VALA_EXTERN void book_move_page (Book* self,
                     Page* page,
                     guint location);
VALA_EXTERN void book_reverse (Book* self);
VALA_EXTERN void book_combine_sides (Book* self);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN void book_flip_every_second (Book* self,
                             FlipEverySecond flip);
VALA_EXTERN void page_rotate_left (Page* self);
VALA_EXTERN void book_combine_sides_reverse (Book* self);
VALA_EXTERN void book_delete_page (Book* self,
                       Page* page);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN guint book_get_page_index (Book* self,
                           Page* page);
static void book_save_async_data_free (gpointer _data);
VALA_EXTERN void book_save_async (Book* self,
                      const gchar* mime_type,
                      gint quality,
                      GFile* file,
                      ProgressionCallback progress_cb,
                      gpointer progress_cb_target,
                      GCancellable* cancellable,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_);
VALA_EXTERN void book_save_finish (Book* self,
                       GAsyncResult* _res_,
                       GError** error);
static gboolean book_save_async_co (BookSaveAsyncData* _data_);
VALA_EXTERN gpointer book_saver_ref (gpointer instance);
VALA_EXTERN void book_saver_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_book_saver (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_book_saver (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_book_saver (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_book_saver (const GValue* value);
VALA_EXTERN GType book_saver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookSaver, book_saver_unref)
VALA_EXTERN BookSaver* book_saver_new (void);
VALA_EXTERN BookSaver* book_saver_construct (GType object_type);
VALA_EXTERN void book_saver_save_async (BookSaver* self,
                            Book* book,
                            const gchar* mime_type,
                            gint quality,
                            GFile* file,
                            ProgressionCallback progression_callback,
                            gpointer progression_callback_target,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN void book_saver_save_finish (BookSaver* self,
                             GAsyncResult* _res_,
                             GError** error);
static void book_save_async_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_);
static void book_postprocess_async_data_free (gpointer _data);
VALA_EXTERN void book_postprocess_async (Book* self,
                             const gchar* mime_type,
                             GFile* file,
                             gboolean postproc_enabled,
                             const gchar* postproc_script,
                             const gchar* postproc_arguments,
                             gboolean postproc_keep_original,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void book_postprocess_finish (Book* self,
                              GAsyncResult* _res_,
                              GError** error);
static gboolean book_postprocess_async_co (BookPostprocessAsyncData* _data_);
VALA_EXTERN void book_saver_postprocess_async (BookSaver* self,
                                   const gchar* mime_type,
                                   GFile* file,
                                   gboolean postproc_enabled,
                                   const gchar* postproc_script,
                                   const gchar* postproc_arguments,
                                   gboolean postproc_keep_original,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void book_saver_postprocess_finish (BookSaver* self,
                                    GAsyncResult* _res_,
                                    GError** error);
static void book_postprocess_async_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void book_finalize (GObject * obj);
static GType book_get_type_once (void);
static void _vala_book_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
VALA_EXTERN gpointer write_task_ref (gpointer instance);
VALA_EXTERN void write_task_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_write_task (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_write_task (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_write_task (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_write_task (const GValue* value);
VALA_EXTERN GType write_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WriteTask, write_task_unref)
VALA_EXTERN gpointer encode_task_ref (gpointer instance);
VALA_EXTERN void encode_task_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_encode_task (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_encode_task (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_encode_task (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_encode_task (const GValue* value);
VALA_EXTERN GType encode_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EncodeTask, encode_task_unref)
VALA_EXTERN gpointer postprocessor_ref (gpointer instance);
VALA_EXTERN void postprocessor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_postprocessor (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_postprocessor (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_postprocessor (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_postprocessor (const GValue* value);
VALA_EXTERN GType postprocessor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Postprocessor, postprocessor_unref)
VALA_EXTERN Postprocessor* postprocessor_new (void);
VALA_EXTERN Postprocessor* postprocessor_construct (GType object_type);
static void book_saver_save_async_data_free (gpointer _data);
static gboolean book_saver_save_async_co (BookSaverSaveAsyncData* _data_);
static gboolean _book_saver_save_async_co_gsource_func (gpointer self);
static void _write_task_unref0_ (gpointer var);
static void ___lambda5_ (BookSaver* self,
                  gdouble fraction);
static void ____lambda5__progression_callback (gdouble fraction,
                                        gpointer self);
static void book_saver_encode_jpeg (BookSaver* self,
                             EncodeTask* encode_task);
static void _book_saver_encode_jpeg_gfunc (gpointer data,
                                    gpointer self);
static void book_saver_encode_png (BookSaver* self,
                            EncodeTask* encode_task);
static void _book_saver_encode_png_gfunc (gpointer data,
                                   gpointer self);
static void book_saver_encode_webp (BookSaver* self,
                             EncodeTask* encode_task);
static void _book_saver_encode_webp_gfunc (gpointer data,
                                    gpointer self);
static void book_saver_encode_pdf (BookSaver* self,
                            EncodeTask* encode_task);
static void _book_saver_encode_pdf_gfunc (gpointer data,
                                   gpointer self);
static GError* book_saver_write_multifile (BookSaver* self);
static gpointer _book_saver_write_multifile_gthread_func (gpointer self);
static GError* book_saver_write_pdf (BookSaver* self);
static gpointer _book_saver_write_pdf_gthread_func (gpointer self);
static GError* ___lambda8_ (BookSaver* self);
static gpointer ____lambda8__gthread_func (gpointer self);
VALA_EXTERN EncodeTask* encode_task_new (void);
VALA_EXTERN EncodeTask* encode_task_construct (GType object_type);
static void book_saver_postprocess_async_data_free (gpointer _data);
static gboolean book_saver_postprocess_async_co (BookSaverPostprocessAsyncData* _data_);
VALA_EXTERN gint postprocessor_process (Postprocessor* self,
                            const gchar* script,
                            const gchar* mime_type,
                            gboolean keep_original,
                            const gchar* source_file,
                            const gchar* arguments,
                            GError** error);
VALA_EXTERN gchar* page_get_icc_data_encoded (Page* self);
VALA_EXTERN WriteTask* write_task_new (void);
VALA_EXTERN WriteTask* write_task_construct (GType object_type);
VALA_EXTERN GdkPixbuf* page_get_image (Page* self,
                           gboolean apply_crop);
VALA_EXTERN gint page_get_dpi (Page* self);
static void book_saver_update_progression (BookSaver* self);
static const char* _web_p_mux_error_to_string (WebPMuxError value);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
VALA_EXTERN gboolean page_get_is_color (Page* self);
VALA_EXTERN gint page_get_depth (Page* self);
VALA_EXTERN GType write_task_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WriteTaskPDF, write_task_unref)
VALA_EXTERN WriteTaskPDF* write_task_pdf_new (void);
VALA_EXTERN WriteTaskPDF* write_task_pdf_construct (GType object_type);
static guint8* book_saver_compress_jpeg (GdkPixbuf* image,
                                  gint quality,
                                  gint dpi,
                                  gint* result_length1,
                                  GError** error);
static guint8* book_saver_compress_zlib (guint8* data,
                                  gint data_length1,
                                  guint max_size,
                                  gint* result_length1);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup4 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup5 (guint8* self,
                          gssize length);
static void book_saver_finished_saving (BookSaver* self);
VALA_EXTERN GFile* make_indexed_file (const gchar* uri,
                          guint i,
                          guint n_pages);
VALA_EXTERN gpointer pdf_writer_ref (gpointer instance);
VALA_EXTERN void pdf_writer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_pdf_writer (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_pdf_writer (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_pdf_writer (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_pdf_writer (const GValue* value);
VALA_EXTERN GType pdf_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PDFWriter, pdf_writer_unref)
VALA_EXTERN PDFWriter* pdf_writer_new (GFileOutputStream* stream);
VALA_EXTERN PDFWriter* pdf_writer_construct (GType object_type,
                                 GFileOutputStream* stream);
VALA_EXTERN guint pdf_writer_add_object (PDFWriter* self);
VALA_EXTERN void pdf_writer_write_string (PDFWriter* self,
                              const gchar* text);
VALA_EXTERN void pdf_writer_start_object (PDFWriter* self,
                              guint index);
static inline void _g_queue_free__write_task_unref0_ (GQueue* self);
static gint _______lambda7_ (BookSaver* self,
                      WriteTaskPDF* a,
                      WriteTaskPDF* b);
static gint ________lambda7__gcompare_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
VALA_EXTERN void pdf_writer_write (PDFWriter* self,
                       guint8* data,
                       gint data_length1);
VALA_EXTERN gint pdf_writer_next_empty_object (PDFWriter* self,
                                   gint start);
static gboolean __lambda6_ (BookSaver* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void book_saver_finalize (BookSaver * obj);
static GType book_saver_get_type_once (void);
static void encode_task_finalize (EncodeTask * obj);
static GType encode_task_get_type_once (void);
static void write_task_finalize (WriteTask * obj);
static GType write_task_get_type_once (void);
static void write_task_pdf_finalize (WriteTask * obj);
static GType write_task_pdf_get_type_once (void);
static void pdf_writer_finalize (PDFWriter * obj);
static GType pdf_writer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
flip_every_second_get_type_once (void)
{
	static const GEnumValue values[] = {{FLIP_EVERY_SECOND_Even, "FLIP_EVERY_SECOND_Even", "even"}, {FLIP_EVERY_SECOND_Odd, "FLIP_EVERY_SECOND_Odd", "odd"}, {0, NULL, NULL}};
	GType flip_every_second_type_id;
	flip_every_second_type_id = g_enum_register_static ("FlipEverySecond", values);
	return flip_every_second_type_id;
}

GType
flip_every_second_get_type (void)
{
	static volatile gsize flip_every_second_type_id__once = 0;
	if (g_once_init_enter (&flip_every_second_type_id__once)) {
		GType flip_every_second_type_id;
		flip_every_second_type_id = flip_every_second_get_type_once ();
		g_once_init_leave (&flip_every_second_type_id__once, flip_every_second_type_id);
	}
	return flip_every_second_type_id__once;
}

static inline gpointer
book_get_instance_private (Book* self)
{
	return G_STRUCT_MEMBER_P (self, Book_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_book_page_changed_cb_page_pixels_changed (Page* _sender,
                                           gpointer self)
{
	book_page_changed_cb ((Book*) self, _sender);
}

static void
_book_page_changed_cb_page_crop_changed (Page* _sender,
                                         gpointer self)
{
	book_page_changed_cb ((Book*) self, _sender);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

Book*
book_construct (GType object_type)
{
	Book * self = NULL;
	self = (Book*) g_object_new (object_type, NULL);
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	self->priv->pages = NULL;
	return self;
}

Book*
book_new (void)
{
	return book_construct (TYPE_BOOK);
}

void
book_clear (Book* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_;
			Page* page = NULL;
			_tmp1_ = _g_object_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_;
				guint _tmp3_;
				Page* _tmp4_;
				guint _tmp5_;
				_tmp2_ = page;
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
				_tmp4_ = page;
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
				_g_object_unref0 (page);
			}
		}
	}
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	self->priv->pages = NULL;
	g_signal_emit (self, book_signals[BOOK_CLEARED_SIGNAL], 0);
}

static void
book_page_changed_cb (Book* self,
                      Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
}

void
book_append_page (Book* self,
                  Page* page)
{
	Page* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_signal_connect_object (page, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self, 0);
	g_signal_connect_object (page, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self, 0);
	_tmp0_ = _g_object_ref0 (page);
	self->priv->pages = g_list_append (self->priv->pages, _tmp0_);
	g_signal_emit (self, book_signals[BOOK_PAGE_ADDED_SIGNAL], 0, page);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
book_move_page (Book* self,
                Page* page,
                guint location)
{
	Page* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	self->priv->pages = vala_g_list_remove_full (self->priv->pages, page, _g_object_unref0_);
	_tmp0_ = _g_object_ref0 (page);
	self->priv->pages = g_list_insert (self->priv->pages, _tmp0_, (gint) location);
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
}

void
book_reverse (Book* self)
{
	GList* new_pages = NULL;
	GList* _tmp0_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	new_pages = NULL;
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_;
			Page* page = NULL;
			_tmp1_ = _g_object_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_;
				Page* _tmp3_;
				_tmp2_ = page;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				new_pages = g_list_prepend (new_pages, _tmp3_);
				_g_object_unref0 (page);
			}
		}
	}
	_tmp4_ = new_pages;
	new_pages = NULL;
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	self->priv->pages = _tmp4_;
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__g_object_unref0_ (new_pages), NULL));
}

void
book_combine_sides (Book* self)
{
	guint n_front = 0U;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GList* new_pages = NULL;
	GList* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_get_n_pages (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = book_get_n_pages (self);
	_tmp3_ = _tmp2_;
	n_front = _tmp1_ - (_tmp3_ / 2);
	new_pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint _tmp6_;
				guint _tmp7_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = book_get_n_pages (self);
				_tmp7_ = _tmp6_;
				if (!(((guint) i) < _tmp7_)) {
					break;
				}
				if ((i % 2) == 0) {
					GList* _tmp8_;
					gconstpointer _tmp9_;
					Page* _tmp10_;
					_tmp8_ = self->priv->pages;
					_tmp9_ = g_list_nth_data (_tmp8_, (guint) (i / 2));
					_tmp10_ = _g_object_ref0 ((Page*) _tmp9_);
					new_pages = g_list_append (new_pages, _tmp10_);
				} else {
					GList* _tmp11_;
					gconstpointer _tmp12_;
					Page* _tmp13_;
					_tmp11_ = self->priv->pages;
					_tmp12_ = g_list_nth_data (_tmp11_, n_front + (i / 2));
					_tmp13_ = _g_object_ref0 ((Page*) _tmp12_);
					new_pages = g_list_append (new_pages, _tmp13_);
				}
			}
		}
	}
	_tmp14_ = new_pages;
	new_pages = NULL;
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	self->priv->pages = _tmp14_;
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__g_object_unref0_ (new_pages), NULL));
}

void
book_flip_every_second (Book* self,
                        FlipEverySecond flip)
{
	GList* new_pages = NULL;
	GList* _tmp13_;
	g_return_if_fail (self != NULL);
	new_pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				Page* page = NULL;
				GList* _tmp4_;
				gconstpointer _tmp5_;
				Page* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = book_get_n_pages (self);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->pages;
				_tmp5_ = g_list_nth_data (_tmp4_, (guint) i);
				_tmp6_ = _g_object_ref0 ((Page*) _tmp5_);
				page = _tmp6_;
				if ((i % 2) == ((gint) flip)) {
					Page* _tmp7_;
					Page* _tmp8_;
					Page* _tmp9_;
					Page* _tmp10_;
					_tmp7_ = page;
					page_rotate_left (_tmp7_);
					_tmp8_ = page;
					page_rotate_left (_tmp8_);
					_tmp9_ = page;
					_tmp10_ = _g_object_ref0 (_tmp9_);
					new_pages = g_list_append (new_pages, _tmp10_);
				} else {
					Page* _tmp11_;
					Page* _tmp12_;
					_tmp11_ = page;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					new_pages = g_list_append (new_pages, _tmp12_);
				}
				_g_object_unref0 (page);
			}
		}
	}
	_tmp13_ = new_pages;
	new_pages = NULL;
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	self->priv->pages = _tmp13_;
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__g_object_unref0_ (new_pages), NULL));
}

void
book_combine_sides_reverse (Book* self)
{
	GList* new_pages = NULL;
	GList* _tmp12_;
	g_return_if_fail (self != NULL);
	new_pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = book_get_n_pages (self);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < _tmp3_)) {
					break;
				}
				if ((i % 2) == 0) {
					GList* _tmp4_;
					gconstpointer _tmp5_;
					Page* _tmp6_;
					_tmp4_ = self->priv->pages;
					_tmp5_ = g_list_nth_data (_tmp4_, (guint) (i / 2));
					_tmp6_ = _g_object_ref0 ((Page*) _tmp5_);
					new_pages = g_list_append (new_pages, _tmp6_);
				} else {
					GList* _tmp7_;
					guint _tmp8_;
					guint _tmp9_;
					gconstpointer _tmp10_;
					Page* _tmp11_;
					_tmp7_ = self->priv->pages;
					_tmp8_ = book_get_n_pages (self);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_list_nth_data (_tmp7_, (_tmp9_ - 1) - (i / 2));
					_tmp11_ = _g_object_ref0 ((Page*) _tmp10_);
					new_pages = g_list_append (new_pages, _tmp11_);
				}
			}
		}
	}
	_tmp12_ = new_pages;
	new_pages = NULL;
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	self->priv->pages = _tmp12_;
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__g_object_unref0_ (new_pages), NULL));
}

void
book_delete_page (Book* self,
                  Page* page)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
	self->priv->pages = vala_g_list_remove_full (self->priv->pages, page, _g_object_unref0_);
	g_signal_emit (self, book_signals[BOOK_PAGE_REMOVED_SIGNAL], 0, page);
	g_signal_emit (self, book_signals[BOOK_CHANGED_SIGNAL], 0);
}

Page*
book_get_page (Book* self,
               gint page_number)
{
	GList* _tmp1_;
	gconstpointer _tmp2_;
	Page* _tmp3_;
	Page* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (page_number < 0) {
		GList* _tmp0_;
		_tmp0_ = self->priv->pages;
		page_number = ((gint) g_list_length (_tmp0_)) + page_number;
	}
	_tmp1_ = self->priv->pages;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) page_number);
	_tmp3_ = _g_object_ref0 ((Page*) _tmp2_);
	result = _tmp3_;
	return result;
}

guint
book_get_page_index (Book* self,
                     Page* page)
{
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (page != NULL, 0U);
	_tmp0_ = self->priv->pages;
	result = (guint) g_list_index (_tmp0_, page);
	return result;
}

static void
book_save_async_data_free (gpointer _data)
{
	BookSaveAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->mime_type);
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BookSaveAsyncData, _data_);
}

void
book_save_async (Book* self,
                 const gchar* mime_type,
                 gint quality,
                 GFile* file,
                 ProgressionCallback progress_cb,
                 gpointer progress_cb_target,
                 GCancellable* cancellable,
                 GAsyncReadyCallback _callback_,
                 gpointer _user_data_)
{
	BookSaveAsyncData* _data_;
	Book* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (BookSaveAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, book_save_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (mime_type);
	_g_free0 (_data_->mime_type);
	_data_->mime_type = _tmp1_;
	_data_->quality = quality;
	_tmp2_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_data_->progress_cb = progress_cb;
	_data_->progress_cb_target = progress_cb_target;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	book_save_async_co (_data_);
}

void
book_save_finish (Book* self,
                  GAsyncResult* _res_,
                  GError** error)
{
	BookSaveAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
book_save_async_ready (GObject* source_object,
                       GAsyncResult* _res_,
                       gpointer _user_data_)
{
	BookSaveAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	book_save_async_co (_data_);
}

static gboolean
book_save_async_co (BookSaveAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = book_saver_new ();
	_data_->book_saver = _data_->_tmp0_;
	_data_->_state_ = 1;
	book_saver_save_async (_data_->book_saver, _data_->self, _data_->mime_type, _data_->quality, _data_->file, _data_->progress_cb, _data_->progress_cb_target, _data_->cancellable, book_save_async_ready, _data_);
	return FALSE;
	_state_1:
	book_saver_save_finish (_data_->book_saver, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_book_saver_unref0 (_data_->book_saver);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_book_saver_unref0 (_data_->book_saver);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
book_postprocess_async_data_free (gpointer _data)
{
	BookPostprocessAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->mime_type);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->postproc_script);
	_g_free0 (_data_->postproc_arguments);
	_g_object_unref0 (_data_->self);
	g_slice_free (BookPostprocessAsyncData, _data_);
}

void
book_postprocess_async (Book* self,
                        const gchar* mime_type,
                        GFile* file,
                        gboolean postproc_enabled,
                        const gchar* postproc_script,
                        const gchar* postproc_arguments,
                        gboolean postproc_keep_original,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	BookPostprocessAsyncData* _data_;
	Book* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (postproc_script != NULL);
	g_return_if_fail (postproc_arguments != NULL);
	_data_ = g_slice_new0 (BookPostprocessAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, book_postprocess_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (mime_type);
	_g_free0 (_data_->mime_type);
	_data_->mime_type = _tmp1_;
	_tmp2_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_data_->postproc_enabled = postproc_enabled;
	_tmp3_ = g_strdup (postproc_script);
	_g_free0 (_data_->postproc_script);
	_data_->postproc_script = _tmp3_;
	_tmp4_ = g_strdup (postproc_arguments);
	_g_free0 (_data_->postproc_arguments);
	_data_->postproc_arguments = _tmp4_;
	_data_->postproc_keep_original = postproc_keep_original;
	book_postprocess_async_co (_data_);
}

void
book_postprocess_finish (Book* self,
                         GAsyncResult* _res_,
                         GError** error)
{
	BookPostprocessAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
book_postprocess_async_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	BookPostprocessAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	book_postprocess_async_co (_data_);
}

static gboolean
book_postprocess_async_co (BookPostprocessAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = book_saver_new ();
	_data_->book_saver = _data_->_tmp0_;
	_data_->_state_ = 1;
	book_saver_postprocess_async (_data_->book_saver, _data_->mime_type, _data_->file, _data_->postproc_enabled, _data_->postproc_script, _data_->postproc_arguments, _data_->postproc_keep_original, book_postprocess_async_ready, _data_);
	return FALSE;
	_state_1:
	book_saver_postprocess_finish (_data_->book_saver, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_book_saver_unref0 (_data_->book_saver);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_book_saver_unref0 (_data_->book_saver);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

guint
book_get_n_pages (Book* self)
{
	guint result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pages;
	result = g_list_length (_tmp0_);
	return result;
}

static void
book_class_init (BookClass * klass,
                 gpointer klass_data)
{
	book_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Book_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_book_get_property;
	G_OBJECT_CLASS (klass)->finalize = book_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_N_PAGES_PROPERTY, book_properties[BOOK_N_PAGES_PROPERTY] = g_param_spec_uint ("n-pages", "n-pages", "n-pages", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	book_signals[BOOK_PAGE_ADDED_SIGNAL] = g_signal_new ("page-added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PAGE);
	book_signals[BOOK_PAGE_REMOVED_SIGNAL] = g_signal_new ("page-removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PAGE);
	book_signals[BOOK_REORDERED_SIGNAL] = g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	book_signals[BOOK_CLEARED_SIGNAL] = g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	book_signals[BOOK_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
book_instance_init (Book * self,
                    gpointer klass)
{
	self->priv = book_get_instance_private (self);
}

static void
book_finalize (GObject * obj)
{
	Book * self;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_;
			Page* page = NULL;
			_tmp1_ = _g_object_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_;
				guint _tmp3_;
				Page* _tmp4_;
				guint _tmp5_;
				_tmp2_ = page;
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
				_tmp4_ = page;
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
				_g_object_unref0 (page);
			}
		}
	}
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__g_object_unref0_ (self->priv->pages), NULL));
	G_OBJECT_CLASS (book_parent_class)->finalize (obj);
}

static GType
book_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, NULL };
	GType book_type_id;
	book_type_id = g_type_register_static (G_TYPE_OBJECT, "Book", &g_define_type_info, 0);
	Book_private_offset = g_type_add_instance_private (book_type_id, sizeof (BookPrivate));
	return book_type_id;
}

GType
book_get_type (void)
{
	static volatile gsize book_type_id__once = 0;
	if (g_once_init_enter (&book_type_id__once)) {
		GType book_type_id;
		book_type_id = book_get_type_once ();
		g_once_init_leave (&book_type_id__once, book_type_id);
	}
	return book_type_id__once;
}

static void
_vala_book_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Book * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK, Book);
	switch (property_id) {
		case BOOK_N_PAGES_PROPERTY:
		g_value_set_uint (value, book_get_n_pages (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
book_saver_get_instance_private (BookSaver* self)
{
	return G_STRUCT_MEMBER_P (self, BookSaver_private_offset);
}

static void
book_saver_save_async_data_free (gpointer _data)
{
	BookSaverSaveAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->book);
	_g_free0 (_data_->mime_type);
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_book_saver_unref0 (_data_->self);
	g_slice_free (BookSaverSaveAsyncData, _data_);
}

static gpointer
_book_saver_ref0 (gpointer self)
{
	return self ? book_saver_ref (self) : NULL;
}

void
book_saver_save_async (BookSaver* self,
                       Book* book,
                       const gchar* mime_type,
                       gint quality,
                       GFile* file,
                       ProgressionCallback progression_callback,
                       gpointer progression_callback_target,
                       GCancellable* cancellable,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	BookSaverSaveAsyncData* _data_;
	BookSaver* _tmp0_;
	Book* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (BookSaverSaveAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, book_saver_save_async_data_free);
	_tmp0_ = _book_saver_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (book);
	_g_object_unref0 (_data_->book);
	_data_->book = _tmp1_;
	_tmp2_ = g_strdup (mime_type);
	_g_free0 (_data_->mime_type);
	_data_->mime_type = _tmp2_;
	_data_->quality = quality;
	_tmp3_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp3_;
	_data_->progression_callback = progression_callback;
	_data_->progression_callback_target = progression_callback_target;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	book_saver_save_async_co (_data_);
}

void
book_saver_save_finish (BookSaver* self,
                        GAsyncResult* _res_,
                        GError** error)
{
	BookSaverSaveAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
_book_saver_save_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = book_saver_save_async_co (self);
	return result;
}

static void
_write_task_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (write_task_unref (var), NULL));
}

static void
___lambda5_ (BookSaver* self,
             gdouble fraction)
{
	g_debug ("book.vala:218: Save progression: %f%%", fraction * 100.0);
}

static void
____lambda5__progression_callback (gdouble fraction,
                                   gpointer self)
{
	___lambda5_ ((BookSaver*) self, fraction);
}

static void
_book_saver_encode_jpeg_gfunc (gpointer data,
                               gpointer self)
{
	book_saver_encode_jpeg ((BookSaver*) self, (EncodeTask*) data);
}

static void
_book_saver_encode_png_gfunc (gpointer data,
                              gpointer self)
{
	book_saver_encode_png ((BookSaver*) self, (EncodeTask*) data);
}

static void
_book_saver_encode_webp_gfunc (gpointer data,
                               gpointer self)
{
	book_saver_encode_webp ((BookSaver*) self, (EncodeTask*) data);
}

static void
_book_saver_encode_pdf_gfunc (gpointer data,
                              gpointer self)
{
	book_saver_encode_pdf ((BookSaver*) self, (EncodeTask*) data);
}

static gpointer
_book_saver_write_multifile_gthread_func (gpointer self)
{
	gpointer result;
	result = book_saver_write_multifile ((BookSaver*) self);
	book_saver_unref (self);
	return result;
}

static gpointer
_book_saver_write_pdf_gthread_func (gpointer self)
{
	gpointer result;
	result = book_saver_write_pdf ((BookSaver*) self);
	book_saver_unref (self);
	return result;
}

static GError*
___lambda8_ (BookSaver* self)
{
	GError* result;
	result = NULL;
	return result;
}

static gpointer
____lambda8__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda8_ ((BookSaver*) self);
	book_saver_unref (self);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
book_saver_save_async_co (BookSaverSaveAsyncData* _data_)
{
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	static GQuark _tmp7_label2 = 0;
	static GQuark _tmp7_label3 = 0;
	static GQuark _tmp14_label0 = 0;
	static GQuark _tmp14_label1 = 0;
	static GQuark _tmp14_label2 = 0;
	static GQuark _tmp14_label3 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	_data_->_tmp1_ = book_get_n_pages (_data_->book);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->self->priv->n_pages = _data_->_tmp2_;
	_data_->self->priv->quality = _data_->quality;
	_data_->_tmp3_ = _g_object_ref0 (_data_->file);
	_g_object_unref0 (_data_->self->priv->file);
	_data_->self->priv->file = _data_->_tmp3_;
	_data_->_tmp4_ = _g_object_ref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp4_;
	(_data_->self->priv->save_async_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->save_async_callback_target_destroy_notify (_data_->self->priv->save_async_callback_target), NULL);
	_data_->self->priv->save_async_callback = NULL;
	_data_->self->priv->save_async_callback_target = NULL;
	_data_->self->priv->save_async_callback_target_destroy_notify = NULL;
	_data_->self->priv->save_async_callback = _book_saver_save_async_co_gsource_func;
	_data_->self->priv->save_async_callback_target = _data_;
	_data_->self->priv->save_async_callback_target_destroy_notify = NULL;
	_data_->_tmp5_ = g_async_queue_new_full (_write_task_unref0_);
	_g_async_queue_unref0 (_data_->self->priv->write_queue);
	_data_->self->priv->write_queue = _data_->_tmp5_;
	_data_->self->priv->progression = (gdouble) 0;
	_vala_clear_GMutex (&_data_->self->priv->progression_mutex);
	g_mutex_init (&_data_->self->priv->progression_mutex);
	if (_data_->progression_callback == NULL) {
		_data_->self->priv->progression_callback = ____lambda5__progression_callback;
		_data_->self->priv->progression_callback_target = _data_->self;
	} else {
		_data_->self->priv->progression_callback = _data_->progression_callback;
		_data_->self->priv->progression_callback_target = _data_->progression_callback_target;
	}
	_data_->encode_delegate = NULL;
	_data_->encode_delegate_target = NULL;
	_data_->encode_delegate_target_destroy_notify = NULL;
	_data_->_tmp8_ = 0U;
	_data_->_tmp6_ = _data_->mime_type;
	_data_->_tmp8_ = (NULL == _data_->_tmp6_) ? 0 : g_quark_from_string (_data_->_tmp6_);
	if (_data_->_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("image/jpeg")))) {
		switch (0) {
			default:
			{
				(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
				_data_->encode_delegate = NULL;
				_data_->encode_delegate_target = NULL;
				_data_->encode_delegate_target_destroy_notify = NULL;
				_data_->encode_delegate = _book_saver_encode_jpeg_gfunc;
				_data_->encode_delegate_target = book_saver_ref (_data_->self);
				_data_->encode_delegate_target_destroy_notify = book_saver_unref;
				break;
			}
		}
	} else if (_data_->_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("image/png")))) {
		switch (0) {
			default:
			{
				(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
				_data_->encode_delegate = NULL;
				_data_->encode_delegate_target = NULL;
				_data_->encode_delegate_target_destroy_notify = NULL;
				_data_->encode_delegate = _book_saver_encode_png_gfunc;
				_data_->encode_delegate_target = book_saver_ref (_data_->self);
				_data_->encode_delegate_target_destroy_notify = book_saver_unref;
				break;
			}
		}
	} else if (_data_->_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("image/webp")))) {
		switch (0) {
			default:
			{
				(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
				_data_->encode_delegate = NULL;
				_data_->encode_delegate_target = NULL;
				_data_->encode_delegate_target_destroy_notify = NULL;
				_data_->encode_delegate = _book_saver_encode_webp_gfunc;
				_data_->encode_delegate_target = book_saver_ref (_data_->self);
				_data_->encode_delegate_target_destroy_notify = book_saver_unref;
				break;
			}
		}
	} else if (_data_->_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("application/pdf")))) {
		switch (0) {
			default:
			{
				(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
				_data_->encode_delegate = NULL;
				_data_->encode_delegate_target = NULL;
				_data_->encode_delegate_target_destroy_notify = NULL;
				_data_->encode_delegate = _book_saver_encode_pdf_gfunc;
				_data_->encode_delegate_target = book_saver_ref (_data_->self);
				_data_->encode_delegate_target_destroy_notify = book_saver_unref;
				break;
			}
		}
	}
	_data_->_tmp10_ = _data_->encode_delegate;
	_data_->_tmp10__target = _data_->encode_delegate_target;
	_data_->_tmp11_ = g_thread_pool_new (_data_->_tmp10_, _data_->_tmp10__target, (gint) g_get_num_processors (), FALSE, &_data_->_inner_error0_);
	_data_->_tmp9_ = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
		_data_->encode_delegate = NULL;
		_data_->encode_delegate_target = NULL;
		_data_->encode_delegate_target_destroy_notify = NULL;
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->_tmp9_;
	_data_->_tmp9_ = NULL;
	_g_thread_pool_free0 (_data_->self->priv->encoder);
	_data_->self->priv->encoder = _data_->_tmp12_;
	_data_->_tmp15_ = 0U;
	_data_->_tmp13_ = _data_->mime_type;
	_data_->_tmp15_ = (NULL == _data_->_tmp13_) ? 0 : g_quark_from_string (_data_->_tmp13_);
	if (((_data_->_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("image/jpeg")))) || (_data_->_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("image/png"))))) || (_data_->_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("image/webp"))))) {
		switch (0) {
			default:
			{
				_data_->_tmp16_ = g_thread_new (NULL, _book_saver_write_multifile_gthread_func, book_saver_ref (_data_->self));
				_g_thread_unref0 (_data_->writer);
				_data_->writer = _data_->_tmp16_;
				break;
			}
		}
	} else if (_data_->_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("application/pdf")))) {
		switch (0) {
			default:
			{
				_data_->_tmp17_ = g_thread_new (NULL, _book_saver_write_pdf_gthread_func, book_saver_ref (_data_->self));
				_g_thread_unref0 (_data_->writer);
				_data_->writer = _data_->_tmp17_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_data_->_tmp18_ = g_thread_new (NULL, ____lambda8__gthread_func, book_saver_ref (_data_->self));
				_g_thread_unref0 (_data_->writer);
				_data_->writer = _data_->_tmp18_;
				break;
			}
		}
	}
	{
		_data_->i = 0;
		{
			_data_->_tmp19_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp19_) {
					_data_->_tmp20_ = _data_->i;
					_data_->i = _data_->_tmp20_ + 1;
				}
				_data_->_tmp19_ = FALSE;
				if (!(((guint) _data_->i) < _data_->self->priv->n_pages)) {
					break;
				}
				_data_->_tmp21_ = encode_task_new ();
				_data_->encode_task = _data_->_tmp21_;
				_data_->_tmp22_ = _data_->encode_task;
				_data_->_tmp22_->number = _data_->i;
				_data_->_tmp23_ = _data_->encode_task;
				_data_->_tmp24_ = book_get_page (_data_->book, _data_->i);
				_g_object_unref0 (_data_->_tmp23_->page);
				_data_->_tmp23_->page = _data_->_tmp24_;
				_data_->_tmp25_ = _data_->self->priv->encoder;
				_data_->_tmp26_ = _data_->encode_task;
				_data_->encode_task = NULL;
				g_thread_pool_push (_data_->_tmp25_, _data_->_tmp26_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_encode_task_unref0 (_data_->encode_task);
					_g_thread_unref0 (_data_->writer);
					_g_thread_pool_free0 (_data_->_tmp9_);
					(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
					_data_->encode_delegate = NULL;
					_data_->encode_delegate_target = NULL;
					_data_->encode_delegate_target_destroy_notify = NULL;
					_g_timer_destroy0 (_data_->timer);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_encode_task_unref0 (_data_->encode_task);
			}
		}
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp27_ = _data_->writer;
	_data_->writer = NULL;
	_data_->_tmp28_ = g_thread_join (_data_->_tmp27_);
	_data_->_error_ = (GError*) _data_->_tmp28_;
	_data_->_tmp29_ = _data_->_error_;
	if (_data_->_tmp29_ != NULL) {
		_data_->_tmp30_ = _data_->_error_;
		_data_->_tmp31_ = _g_error_copy0 (_data_->_tmp30_);
		_data_->_inner_error0_ = _data_->_tmp31_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->_error_);
		_g_thread_unref0 (_data_->writer);
		_g_thread_pool_free0 (_data_->_tmp9_);
		(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
		_data_->encode_delegate = NULL;
		_data_->encode_delegate_target = NULL;
		_data_->encode_delegate_target_destroy_notify = NULL;
		_g_timer_destroy0 (_data_->timer);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->timer;
	g_timer_stop (_data_->_tmp32_);
	_data_->_tmp33_ = _data_->timer;
	g_debug ("book.vala:282: Save time: %f seconds", g_timer_elapsed (_data_->_tmp33_, NULL));
	_g_error_free0 (_data_->_error_);
	_g_thread_unref0 (_data_->writer);
	_g_thread_pool_free0 (_data_->_tmp9_);
	(_data_->encode_delegate_target_destroy_notify == NULL) ? NULL : (_data_->encode_delegate_target_destroy_notify (_data_->encode_delegate_target), NULL);
	_data_->encode_delegate = NULL;
	_data_->encode_delegate_target = NULL;
	_data_->encode_delegate_target_destroy_notify = NULL;
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
book_saver_postprocess_async_data_free (gpointer _data)
{
	BookSaverPostprocessAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->mime_type);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->postproc_script);
	_g_free0 (_data_->postproc_arguments);
	_book_saver_unref0 (_data_->self);
	g_slice_free (BookSaverPostprocessAsyncData, _data_);
}

void
book_saver_postprocess_async (BookSaver* self,
                              const gchar* mime_type,
                              GFile* file,
                              gboolean postproc_enabled,
                              const gchar* postproc_script,
                              const gchar* postproc_arguments,
                              gboolean postproc_keep_original,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BookSaverPostprocessAsyncData* _data_;
	BookSaver* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (postproc_script != NULL);
	g_return_if_fail (postproc_arguments != NULL);
	_data_ = g_slice_new0 (BookSaverPostprocessAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, book_saver_postprocess_async_data_free);
	_tmp0_ = _book_saver_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (mime_type);
	_g_free0 (_data_->mime_type);
	_data_->mime_type = _tmp1_;
	_tmp2_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_data_->postproc_enabled = postproc_enabled;
	_tmp3_ = g_strdup (postproc_script);
	_g_free0 (_data_->postproc_script);
	_data_->postproc_script = _tmp3_;
	_tmp4_ = g_strdup (postproc_arguments);
	_g_free0 (_data_->postproc_arguments);
	_data_->postproc_arguments = _tmp4_;
	_data_->postproc_keep_original = postproc_keep_original;
	book_saver_postprocess_async_co (_data_);
}

void
book_saver_postprocess_finish (BookSaver* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	BookSaverPostprocessAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
book_saver_postprocess_async_co (BookSaverPostprocessAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->postproc_enabled) {
		_data_->_tmp1_ = strlen (_data_->postproc_script);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp0_ = _data_->_tmp2_ != 0;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp3_ = g_timer_new ();
		_data_->timer = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->postprocessor;
		_data_->_tmp5_ = g_file_get_path (_data_->file);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = postprocessor_process (_data_->_tmp4_, _data_->postproc_script, _data_->mime_type, _data_->postproc_keep_original, _data_->_tmp6_, _data_->postproc_arguments, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp6_);
		_data_->return_code = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_timer_destroy0 (_data_->timer);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->return_code != 0) {
			g_warning ("book.vala:298: Postprocessing script execution failed. ");
		}
		_data_->_tmp8_ = _data_->timer;
		g_timer_stop (_data_->_tmp8_);
		_data_->_tmp9_ = _data_->timer;
		g_debug ("book.vala:301: Postprocessing time: %f seconds", g_timer_elapsed (_data_->_tmp9_, NULL));
		_g_timer_destroy0 (_data_->timer);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
book_saver_encode_png (BookSaver* self,
                       EncodeTask* encode_task)
{
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	gchar* icc_data = NULL;
	Page* _tmp2_;
	gchar* _tmp3_;
	WriteTask* write_task = NULL;
	WriteTask* _tmp4_;
	GdkPixbuf* image = NULL;
	Page* _tmp5_;
	GdkPixbuf* _tmp6_;
	gchar** keys = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint keys_length1;
	gint _keys_size_;
	gchar** values = NULL;
	Page* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	Page* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp22_;
	WriteTask* _tmp33_;
	GAsyncQueue* _tmp34_;
	WriteTask* _tmp35_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (encode_task != NULL);
	_tmp0_ = encode_task->page;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_icc_data_encoded (_tmp2_);
	icc_data = _tmp3_;
	_tmp4_ = write_task_new ();
	write_task = _tmp4_;
	_tmp5_ = page;
	_tmp6_ = page_get_image (_tmp5_, TRUE);
	image = _tmp6_;
	_tmp7_ = g_strdup ("x-dpi");
	_tmp8_ = g_strdup ("y-dpi");
	_tmp9_ = g_strdup ("icc-profile");
	_tmp10_ = g_new0 (gchar*, 4 + 1);
	_tmp10_[0] = _tmp7_;
	_tmp10_[1] = _tmp8_;
	_tmp10_[2] = _tmp9_;
	_tmp10_[3] = NULL;
	keys = _tmp10_;
	keys_length1 = 4;
	_keys_size_ = keys_length1;
	_tmp11_ = page;
	_tmp12_ = page_get_dpi (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%d", _tmp13_);
	_tmp15_ = page;
	_tmp16_ = page_get_dpi (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf ("%d", _tmp17_);
	_tmp19_ = icc_data;
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = g_new0 (gchar*, 4 + 1);
	_tmp21_[0] = _tmp14_;
	_tmp21_[1] = _tmp18_;
	_tmp21_[2] = _tmp20_;
	_tmp21_[3] = NULL;
	values = _tmp21_;
	values_length1 = 4;
	_values_size_ = values_length1;
	_tmp22_ = icc_data;
	if (_tmp22_ == NULL) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp23_ = keys;
		_tmp23__length1 = keys_length1;
		_g_free0 (_tmp23_[2]);
		_tmp23_[2] = NULL;
	}
	{
		GdkPixbuf* _tmp24_;
		WriteTask* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		guint8* _tmp28_ = NULL;
		gsize _tmp29_ = 0;
		_tmp24_ = image;
		_tmp25_ = write_task;
		_tmp26_ = keys;
		_tmp26__length1 = keys_length1;
		_tmp27_ = values;
		_tmp27__length1 = values_length1;
		gdk_pixbuf_save_to_bufferv (_tmp24_, &_tmp28_, &_tmp29_, "png", _tmp26_, _tmp27_, &_inner_error0_);
		_tmp25_->data = (g_free (_tmp25_->data), NULL);
		_tmp25_->data = _tmp28_;
		_tmp25_->data_length1 = _tmp29_;
		_tmp25_->_data_size_ = _tmp25_->data_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		WriteTask* _tmp30_;
		GError* _tmp31_;
		GError* _tmp32_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = write_task;
		_tmp31_ = _error_;
		_tmp32_ = _g_error_copy0 (_tmp31_);
		_g_error_free0 (_tmp30_->error);
		_tmp30_->error = _tmp32_;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (image);
		_write_task_unref0 (write_task);
		_g_free0 (icc_data);
		_g_object_unref0 (page);
		_encode_task_unref0 (encode_task);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp33_ = write_task;
	_tmp33_->number = encode_task->number;
	_tmp34_ = self->priv->write_queue;
	_tmp35_ = write_task;
	write_task = NULL;
	g_async_queue_push (_tmp34_, _tmp35_);
	book_saver_update_progression (self);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (image);
	_write_task_unref0 (write_task);
	_g_free0 (icc_data);
	_g_object_unref0 (page);
	_encode_task_unref0 (encode_task);
}

static void
book_saver_encode_jpeg (BookSaver* self,
                        EncodeTask* encode_task)
{
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	gchar* icc_data = NULL;
	Page* _tmp2_;
	gchar* _tmp3_;
	WriteTask* write_task = NULL;
	WriteTask* _tmp4_;
	GdkPixbuf* image = NULL;
	Page* _tmp5_;
	GdkPixbuf* _tmp6_;
	gchar** keys = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint keys_length1;
	gint _keys_size_;
	gchar** values = NULL;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	Page* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp24_;
	WriteTask* _tmp35_;
	GAsyncQueue* _tmp36_;
	WriteTask* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (encode_task != NULL);
	_tmp0_ = encode_task->page;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_icc_data_encoded (_tmp2_);
	icc_data = _tmp3_;
	_tmp4_ = write_task_new ();
	write_task = _tmp4_;
	_tmp5_ = page;
	_tmp6_ = page_get_image (_tmp5_, TRUE);
	image = _tmp6_;
	_tmp7_ = g_strdup ("x-dpi");
	_tmp8_ = g_strdup ("y-dpi");
	_tmp9_ = g_strdup ("quality");
	_tmp10_ = g_strdup ("icc-profile");
	_tmp11_ = g_new0 (gchar*, 5 + 1);
	_tmp11_[0] = _tmp7_;
	_tmp11_[1] = _tmp8_;
	_tmp11_[2] = _tmp9_;
	_tmp11_[3] = _tmp10_;
	_tmp11_[4] = NULL;
	keys = _tmp11_;
	keys_length1 = 5;
	_keys_size_ = keys_length1;
	_tmp12_ = page;
	_tmp13_ = page_get_dpi (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%d", _tmp14_);
	_tmp16_ = page;
	_tmp17_ = page_get_dpi (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%d", _tmp18_);
	_tmp20_ = g_strdup_printf ("%d", self->priv->quality);
	_tmp21_ = icc_data;
	_tmp22_ = g_strdup (_tmp21_);
	_tmp23_ = g_new0 (gchar*, 5 + 1);
	_tmp23_[0] = _tmp15_;
	_tmp23_[1] = _tmp19_;
	_tmp23_[2] = _tmp20_;
	_tmp23_[3] = _tmp22_;
	_tmp23_[4] = NULL;
	values = _tmp23_;
	values_length1 = 5;
	_values_size_ = values_length1;
	_tmp24_ = icc_data;
	if (_tmp24_ == NULL) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp25_ = keys;
		_tmp25__length1 = keys_length1;
		_g_free0 (_tmp25_[3]);
		_tmp25_[3] = NULL;
	}
	{
		GdkPixbuf* _tmp26_;
		WriteTask* _tmp27_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar** _tmp29_;
		gint _tmp29__length1;
		guint8* _tmp30_ = NULL;
		gsize _tmp31_ = 0;
		_tmp26_ = image;
		_tmp27_ = write_task;
		_tmp28_ = keys;
		_tmp28__length1 = keys_length1;
		_tmp29_ = values;
		_tmp29__length1 = values_length1;
		gdk_pixbuf_save_to_bufferv (_tmp26_, &_tmp30_, &_tmp31_, "jpeg", _tmp28_, _tmp29_, &_inner_error0_);
		_tmp27_->data = (g_free (_tmp27_->data), NULL);
		_tmp27_->data = _tmp30_;
		_tmp27_->data_length1 = _tmp31_;
		_tmp27_->_data_size_ = _tmp27_->data_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		WriteTask* _tmp32_;
		GError* _tmp33_;
		GError* _tmp34_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = write_task;
		_tmp33_ = _error_;
		_tmp34_ = _g_error_copy0 (_tmp33_);
		_g_error_free0 (_tmp32_->error);
		_tmp32_->error = _tmp34_;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (image);
		_write_task_unref0 (write_task);
		_g_free0 (icc_data);
		_g_object_unref0 (page);
		_encode_task_unref0 (encode_task);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp35_ = write_task;
	_tmp35_->number = encode_task->number;
	_tmp36_ = self->priv->write_queue;
	_tmp37_ = write_task;
	write_task = NULL;
	g_async_queue_push (_tmp36_, _tmp37_);
	book_saver_update_progression (self);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (image);
	_write_task_unref0 (write_task);
	_g_free0 (icc_data);
	_g_object_unref0 (page);
	_encode_task_unref0 (encode_task);
}

static guint8*
vala_encode_rgb (guint8* rgb,
                 gint rgb_length1,
                 gint width,
                 gint height,
                 gint stride,
                 gfloat quality_factor,
                 gint* result_length1)
{
	guint8* output = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	gsize length = 0UL;
	guint8* _tmp0_ = NULL;
	gsize _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* result;
	_tmp1_ = WebPEncodeRGB (rgb, width, height, stride, quality_factor, &_tmp0_);
	output = (g_free (output), NULL);
	output = _tmp0_;
	output_length1 = -1;
	_output_size_ = output_length1;
	length = _tmp1_;
	output_length1 = (gint) length;
	_tmp2_ = output;
	_tmp2__length1 = output_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static WebPMuxError
vala_set_image (WebPMux* self,
                guint8* bitstream,
                gint bitstream_length1,
                gboolean copy_data)
{
	WebPData data = {0};
	WebPData _tmp0_ = {0};
	WebPData _tmp1_;
	WebPMuxError result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_.bytes = bitstream;
	_tmp0_.size = (gsize) bitstream_length1;
	data = _tmp0_;
	_tmp1_ = data;
	result = WebPMuxSetImage (self, &_tmp1_, copy_data);
	 (&data);
	return result;
}

static const char*
_web_p_mux_error_to_string (WebPMuxError value)
{
	switch (value) {
		case WEBP_MUX_OK:
		return "WEBP_MUX_OK";
		case WEBP_MUX_NOT_FOUND:
		return "WEBP_MUX_NOT_FOUND";
		case WEBP_MUX_INVALID_ARGUMENT:
		return "WEBP_MUX_INVALID_ARGUMENT";
		case WEBP_MUX_BAD_DATA:
		return "WEBP_MUX_BAD_DATA";
		case WEBP_MUX_MEMORY_ERROR:
		return "WEBP_MUX_MEMORY_ERROR";
		case WEBP_MUX_NOT_ENOUGH_DATA:
		return "WEBP_MUX_NOT_ENOUGH_DATA";
	}
	return NULL;
}

static WebPMuxError
vala_set_chunk (WebPMux* self,
                const gchar* fourcc,
                guint8* chunk_data,
                gint chunk_data_length1,
                gboolean copy_data)
{
	gint _tmp0_;
	gint _tmp1_;
	WebPData data = {0};
	WebPData _tmp2_ = {0};
	WebPData _tmp3_;
	WebPMuxError result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (fourcc != NULL, 0);
	_tmp0_ = strlen (fourcc);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ == 4, "fourcc.length == 4", 0);
	_tmp2_.bytes = chunk_data;
	_tmp2_.size = (gsize) chunk_data_length1;
	data = _tmp2_;
	_tmp3_ = data;
	result = WebPMuxSetChunk (self, (guchar*) fourcc, &_tmp3_, copy_data);
	 (&data);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static WebPMuxError
vala_assemble (WebPMux* self,
               guint8** assembled_data,
               gint* assembled_data_length1)
{
	guint8* _vala_assembled_data = NULL;
	gint _vala_assembled_data_length1 = 0;
	WebPData data = {0};
	WebPMuxError mux_error = 0;
	guint8* out_array = NULL;
	gint out_array_length1 = 0;
	gint _out_array_size_ = 0;
	WebPData _tmp0_ = {0};
	WebPMuxError _tmp1_;
	WebPData _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	WebPData _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	WebPMuxError result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = WebPMuxAssemble (self, &_tmp0_);
	 (&data);
	data = _tmp0_;
	mux_error = _tmp1_;
	_tmp2_ = data;
	_tmp3_ = _tmp2_.bytes;
	_tmp3__length1 = -1;
	out_array = _tmp3_;
	out_array_length1 = _tmp3__length1;
	_out_array_size_ = out_array_length1;
	_tmp4_ = data;
	out_array_length1 = (gint) _tmp4_.size;
	_tmp5_ = (out_array != NULL) ? _vala_array_dup2 (out_array, out_array_length1) : out_array;
	_tmp5__length1 = out_array_length1;
	_vala_assembled_data = (g_free (_vala_assembled_data), NULL);
	_vala_assembled_data = _tmp5_;
	_vala_assembled_data_length1 = _tmp5__length1;
	result = mux_error;
	 (&data);
	if (assembled_data) {
		*assembled_data = _vala_assembled_data;
	} else {
		_vala_assembled_data = (g_free (_vala_assembled_data), NULL);
	}
	if (assembled_data_length1) {
		*assembled_data_length1 = _vala_assembled_data_length1;
	}
	return result;
}

static void
book_saver_encode_webp (BookSaver* self,
                        EncodeTask* encode_task)
{
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	gchar* icc_data = NULL;
	Page* _tmp2_;
	gchar* _tmp3_;
	WriteTask* write_task = NULL;
	WriteTask* _tmp4_;
	GdkPixbuf* image = NULL;
	Page* _tmp5_;
	GdkPixbuf* _tmp6_;
	guint8* webp_data = NULL;
	GdkPixbuf* _tmp7_;
	guint8* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	gint _tmp12_ = 0;
	guint8* _tmp13_;
	gint webp_data_length1;
	gint _webp_data_size_;
	WebPMuxError mux_error = 0;
	WebPMux* mux = NULL;
	WebPMux* _tmp14_;
	guint8* output = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	WebPMux* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	WebPMux* _tmp25_;
	guint8* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	WebPMuxError _tmp28_;
	const gchar* _tmp29_;
	WriteTask* _tmp34_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	WriteTask* _tmp36_;
	GAsyncQueue* _tmp37_;
	WriteTask* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (encode_task != NULL);
	_tmp0_ = encode_task->page;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_icc_data_encoded (_tmp2_);
	icc_data = _tmp3_;
	_tmp4_ = write_task_new ();
	write_task = _tmp4_;
	_tmp5_ = page;
	_tmp6_ = page_get_image (_tmp5_, TRUE);
	image = _tmp6_;
	_tmp7_ = image;
	_tmp8_ = gdk_pixbuf_get_pixels (_tmp7_);
	_tmp9_ = image;
	_tmp10_ = image;
	_tmp11_ = image;
	_tmp13_ = vala_encode_rgb (_tmp8_, (gint) -1, gdk_pixbuf_get_width (_tmp9_), gdk_pixbuf_get_height (_tmp10_), gdk_pixbuf_get_rowstride (_tmp11_), (gfloat) self->priv->quality, &_tmp12_);
	webp_data = _tmp13_;
	webp_data_length1 = _tmp12_;
	_webp_data_size_ = webp_data_length1;
	_tmp14_ = WebPMuxNew ();
	mux = _tmp14_;
	_tmp15_ = mux;
	_tmp16_ = webp_data;
	_tmp16__length1 = webp_data_length1;
	mux_error = vala_set_image (_tmp15_, _tmp16_, (gint) _tmp16__length1, FALSE);
	_tmp17_ = _web_p_mux_error_to_string (mux_error);
	g_debug ("book.vala:379: mux.set_image: %s", _tmp17_);
	_tmp18_ = icc_data;
	if (_tmp18_ != NULL) {
		WebPMux* _tmp19_;
		const gchar* _tmp20_;
		guint8* _tmp21_;
		gint _tmp21__length1;
		gint _tmp22_ = 0;
		guint8* _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		_tmp19_ = mux;
		_tmp20_ = icc_data;
		_tmp21_ = string_get_data (_tmp20_, &_tmp22_);
		_tmp21__length1 = _tmp22_;
		_tmp23_ = _tmp21_;
		_tmp23__length1 = _tmp21__length1;
		mux_error = vala_set_chunk (_tmp19_, "ICCP", _tmp23_, (gint) _tmp23__length1, FALSE);
		_tmp24_ = _web_p_mux_error_to_string (mux_error);
		g_debug ("book.vala:384: mux.set_chunk: %s", _tmp24_);
		if (mux_error != WEBP_MUX_OK) {
			g_warning ("book.vala:386: icc profile data not saved with page %i", encode_task->number);
		}
	}
	_tmp25_ = mux;
	_tmp28_ = vala_assemble (_tmp25_, &_tmp26_, &_tmp27_);
	output = (g_free (output), NULL);
	output = _tmp26_;
	output_length1 = _tmp27_;
	_output_size_ = output_length1;
	mux_error = _tmp28_;
	_tmp29_ = _web_p_mux_error_to_string (mux_error);
	g_debug ("book.vala:390: mux.assemble: %s", _tmp29_);
	if (mux_error != WEBP_MUX_OK) {
		WriteTask* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GError* _tmp33_;
		_tmp30_ = write_task;
		_tmp31_ = g_strdup_printf (_ ("Unable to encode page %i"), encode_task->number);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp32_);
		_g_error_free0 (_tmp30_->error);
		_tmp30_->error = _tmp33_;
		_g_free0 (_tmp32_);
	}
	_tmp34_ = write_task;
	_tmp35_ = output;
	_tmp35__length1 = output_length1;
	output = NULL;
	output_length1 = 0;
	_tmp34_->data = (g_free (_tmp34_->data), NULL);
	_tmp34_->data = _tmp35_;
	_tmp34_->data_length1 = _tmp35__length1;
	_tmp34_->_data_size_ = _tmp34_->data_length1;
	_tmp36_ = write_task;
	_tmp36_->number = encode_task->number;
	_tmp37_ = self->priv->write_queue;
	_tmp38_ = write_task;
	write_task = NULL;
	g_async_queue_push (_tmp37_, _tmp38_);
	book_saver_update_progression (self);
	output = (g_free (output), NULL);
	_WebPMuxDelete0 (mux);
	webp_data = (g_free (webp_data), NULL);
	_g_object_unref0 (image);
	_write_task_unref0 (write_task);
	_g_free0 (icc_data);
	_g_object_unref0 (page);
	_encode_task_unref0 (encode_task);
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup4 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup5 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gpointer
_write_task_ref0 (gpointer self)
{
	return self ? write_task_ref (self) : NULL;
}

static void
book_saver_encode_pdf (BookSaver* self,
                       EncodeTask* encode_task)
{
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	GdkPixbuf* image = NULL;
	Page* _tmp2_;
	GdkPixbuf* _tmp3_;
	gint width = 0;
	GdkPixbuf* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint height = 0;
	GdkPixbuf* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	guint8* pixels = NULL;
	GdkPixbuf* _tmp10_;
	guint8* _tmp11_;
	gint pixels_length1;
	gint _pixels_size_;
	gint depth = 0;
	gchar* color_space = NULL;
	gchar* _tmp12_;
	gchar* filter = NULL;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	Page* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	WriteTaskPDF* write_task = NULL;
	WriteTaskPDF* _tmp84_;
	guint8* jpeg_data = NULL;
	gint jpeg_data_length1;
	gint _jpeg_data_size_;
	guint8* zlib_data = NULL;
	guint8* _tmp95_;
	gint _tmp95__length1;
	guint8* _tmp96_;
	gint _tmp96__length1;
	gint _tmp97_ = 0;
	guint8* _tmp98_;
	gint zlib_data_length1;
	gint _zlib_data_size_;
	guint8* _tmp99_;
	gint _tmp99__length1;
	guint8* _tmp107_;
	gint _tmp107__length1;
	guint8* _tmp108_;
	gint _tmp108__length1;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	Page* _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	GAsyncQueue* _tmp116_;
	WriteTask* _tmp117_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (encode_task != NULL);
	_tmp0_ = encode_task->page;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_image (_tmp2_, TRUE);
	image = _tmp3_;
	_tmp4_ = image;
	_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
	_tmp6_ = _tmp5_;
	width = _tmp6_;
	_tmp7_ = image;
	_tmp8_ = gdk_pixbuf_get_height (_tmp7_);
	_tmp9_ = _tmp8_;
	height = _tmp9_;
	_tmp10_ = image;
	_tmp11_ = gdk_pixbuf_get_pixels (_tmp10_);
	pixels = _tmp11_;
	pixels_length1 = -1;
	_pixels_size_ = pixels_length1;
	depth = 8;
	_tmp12_ = g_strdup ("DeviceRGB");
	color_space = _tmp12_;
	filter = NULL;
	_tmp13_ = page;
	_tmp14_ = page_get_is_color (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		gchar* _tmp16_;
		gint data_length = 0;
		guint8* _tmp17_;
		depth = 8;
		_tmp16_ = g_strdup ("DeviceRGB");
		_g_free0 (color_space);
		color_space = _tmp16_;
		data_length = (height * width) * 3;
		_tmp17_ = g_new0 (guint8, data_length);
		data = (g_free (data), NULL);
		data = _tmp17_;
		data_length1 = data_length;
		_data_size_ = data_length1;
		{
			gint row = 0;
			row = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint in_offset = 0;
					GdkPixbuf* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint out_offset = 0;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = row;
						row = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(row < height)) {
						break;
					}
					_tmp20_ = image;
					_tmp21_ = gdk_pixbuf_get_rowstride (_tmp20_);
					_tmp22_ = _tmp21_;
					in_offset = row * _tmp22_;
					out_offset = (row * width) * 3;
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp23_ = FALSE;
							_tmp23_ = TRUE;
							while (TRUE) {
								gint in_o = 0;
								gint out_o = 0;
								guint8* _tmp25_;
								gint _tmp25__length1;
								guint8* _tmp26_;
								gint _tmp26__length1;
								guint8 _tmp27_;
								guint8* _tmp28_;
								gint _tmp28__length1;
								guint8* _tmp29_;
								gint _tmp29__length1;
								guint8 _tmp30_;
								guint8* _tmp31_;
								gint _tmp31__length1;
								guint8* _tmp32_;
								gint _tmp32__length1;
								guint8 _tmp33_;
								if (!_tmp23_) {
									gint _tmp24_;
									_tmp24_ = x;
									x = _tmp24_ + 1;
								}
								_tmp23_ = FALSE;
								if (!(x < width)) {
									break;
								}
								in_o = in_offset + (x * 3);
								out_o = out_offset + (x * 3);
								_tmp25_ = data;
								_tmp25__length1 = data_length1;
								_tmp26_ = pixels;
								_tmp26__length1 = pixels_length1;
								_tmp27_ = _tmp26_[in_o];
								_tmp25_[out_o] = _tmp27_;
								_tmp28_ = data;
								_tmp28__length1 = data_length1;
								_tmp29_ = pixels;
								_tmp29__length1 = pixels_length1;
								_tmp30_ = _tmp29_[in_o + 1];
								_tmp28_[out_o + 1] = _tmp30_;
								_tmp31_ = data;
								_tmp31__length1 = data_length1;
								_tmp32_ = pixels;
								_tmp32__length1 = pixels_length1;
								_tmp33_ = _tmp32_[in_o + 2];
								_tmp31_[out_o + 2] = _tmp33_;
							}
						}
					}
				}
			}
		}
	} else {
		Page* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp34_ = page;
		_tmp35_ = page_get_depth (_tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp36_ == 2) {
			gint shift_count = 0;
			gchar* _tmp37_;
			gint data_length = 0;
			guint8* _tmp38_;
			gint offset = 0;
			shift_count = 6;
			depth = 2;
			_tmp37_ = g_strdup ("DeviceGray");
			_g_free0 (color_space);
			color_space = _tmp37_;
			data_length = height * (((width * 2) + 7) / 8);
			_tmp38_ = g_new0 (guint8, data_length);
			data = (g_free (data), NULL);
			data = _tmp38_;
			data_length1 = data_length;
			_data_size_ = data_length1;
			offset = 0;
			{
				gint row = 0;
				row = 0;
				{
					gboolean _tmp39_ = FALSE;
					_tmp39_ = TRUE;
					while (TRUE) {
						gint in_offset = 0;
						GdkPixbuf* _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						if (!_tmp39_) {
							gint _tmp40_;
							_tmp40_ = row;
							row = _tmp40_ + 1;
						}
						_tmp39_ = FALSE;
						if (!(row < height)) {
							break;
						}
						if (shift_count != 6) {
							gint _tmp41_;
							_tmp41_ = offset;
							offset = _tmp41_ + 1;
							shift_count = 6;
						}
						_tmp42_ = image;
						_tmp43_ = gdk_pixbuf_get_rowstride (_tmp42_);
						_tmp44_ = _tmp43_;
						in_offset = row * _tmp44_;
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp45_ = FALSE;
								_tmp45_ = TRUE;
								while (TRUE) {
									guint8 p = 0U;
									guint8* _tmp48_;
									gint _tmp48__length1;
									guint8 _tmp49_;
									if (!_tmp45_) {
										gint _tmp46_;
										_tmp46_ = x;
										x = _tmp46_ + 1;
									}
									_tmp45_ = FALSE;
									if (!(x < width)) {
										break;
									}
									if (shift_count == 6) {
										guint8* _tmp47_;
										gint _tmp47__length1;
										_tmp47_ = data;
										_tmp47__length1 = data_length1;
										_tmp47_[offset] = (guint8) 0;
									}
									_tmp48_ = pixels;
									_tmp48__length1 = pixels_length1;
									_tmp49_ = _tmp48_[in_offset + (x * 3)];
									p = _tmp49_;
									if (((gint) p) >= 192) {
										guint8* _tmp50_;
										gint _tmp50__length1;
										_tmp50_ = data;
										_tmp50__length1 = data_length1;
										_tmp50_[offset] |= (guint8) (3 << shift_count);
									} else {
										if (((gint) p) >= 128) {
											guint8* _tmp51_;
											gint _tmp51__length1;
											_tmp51_ = data;
											_tmp51__length1 = data_length1;
											_tmp51_[offset] |= (guint8) (2 << shift_count);
										} else {
											if (((gint) p) >= 64) {
												guint8* _tmp52_;
												gint _tmp52__length1;
												_tmp52_ = data;
												_tmp52__length1 = data_length1;
												_tmp52_[offset] |= (guint8) (1 << shift_count);
											}
										}
									}
									if (shift_count == 0) {
										gint _tmp53_;
										_tmp53_ = offset;
										offset = _tmp53_ + 1;
										shift_count = 6;
									} else {
										shift_count -= 2;
									}
								}
							}
						}
					}
				}
			}
		} else {
			Page* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			_tmp54_ = page;
			_tmp55_ = page_get_depth (_tmp54_);
			_tmp56_ = _tmp55_;
			if (_tmp56_ == 1) {
				gint mask = 0;
				gchar* _tmp57_;
				gint data_length = 0;
				guint8* _tmp58_;
				gint offset = 0;
				mask = 0x80;
				depth = 1;
				_tmp57_ = g_strdup ("DeviceGray");
				_g_free0 (color_space);
				color_space = _tmp57_;
				data_length = height * ((width + 7) / 8);
				_tmp58_ = g_new0 (guint8, data_length);
				data = (g_free (data), NULL);
				data = _tmp58_;
				data_length1 = data_length;
				_data_size_ = data_length1;
				offset = 0;
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp59_ = FALSE;
						_tmp59_ = TRUE;
						while (TRUE) {
							gint in_offset = 0;
							GdkPixbuf* _tmp62_;
							gint _tmp63_;
							gint _tmp64_;
							if (!_tmp59_) {
								gint _tmp60_;
								_tmp60_ = row;
								row = _tmp60_ + 1;
							}
							_tmp59_ = FALSE;
							if (!(row < height)) {
								break;
							}
							if (mask != 0x80) {
								gint _tmp61_;
								_tmp61_ = offset;
								offset = _tmp61_ + 1;
								mask = 0x80;
							}
							_tmp62_ = image;
							_tmp63_ = gdk_pixbuf_get_rowstride (_tmp62_);
							_tmp64_ = _tmp63_;
							in_offset = row * _tmp64_;
							{
								gint x = 0;
								x = 0;
								{
									gboolean _tmp65_ = FALSE;
									_tmp65_ = TRUE;
									while (TRUE) {
										guint8* _tmp68_;
										gint _tmp68__length1;
										guint8 _tmp69_;
										if (!_tmp65_) {
											gint _tmp66_;
											_tmp66_ = x;
											x = _tmp66_ + 1;
										}
										_tmp65_ = FALSE;
										if (!(x < width)) {
											break;
										}
										if (mask == 0x80) {
											guint8* _tmp67_;
											gint _tmp67__length1;
											_tmp67_ = data;
											_tmp67__length1 = data_length1;
											_tmp67_[offset] = (guint8) 0;
										}
										_tmp68_ = pixels;
										_tmp68__length1 = pixels_length1;
										_tmp69_ = _tmp68_[in_offset + (x * 3)];
										if (((gint) _tmp69_) != 0) {
											guint8* _tmp70_;
											gint _tmp70__length1;
											_tmp70_ = data;
											_tmp70__length1 = data_length1;
											_tmp70_[offset] |= (guint8) mask;
										}
										mask >>= 1;
										if (mask == 0) {
											gint _tmp71_;
											_tmp71_ = offset;
											offset = _tmp71_ + 1;
											mask = 0x80;
										}
									}
								}
							}
						}
					}
				}
			} else {
				gchar* _tmp72_;
				gint data_length = 0;
				guint8* _tmp73_;
				depth = 8;
				_tmp72_ = g_strdup ("DeviceGray");
				_g_free0 (color_space);
				color_space = _tmp72_;
				data_length = height * width;
				_tmp73_ = g_new0 (guint8, data_length);
				data = (g_free (data), NULL);
				data = _tmp73_;
				data_length1 = data_length;
				_data_size_ = data_length1;
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp74_ = FALSE;
						_tmp74_ = TRUE;
						while (TRUE) {
							gint in_offset = 0;
							GdkPixbuf* _tmp76_;
							gint _tmp77_;
							gint _tmp78_;
							gint out_offset = 0;
							if (!_tmp74_) {
								gint _tmp75_;
								_tmp75_ = row;
								row = _tmp75_ + 1;
							}
							_tmp74_ = FALSE;
							if (!(row < height)) {
								break;
							}
							_tmp76_ = image;
							_tmp77_ = gdk_pixbuf_get_rowstride (_tmp76_);
							_tmp78_ = _tmp77_;
							in_offset = row * _tmp78_;
							out_offset = row * width;
							{
								gint x = 0;
								x = 0;
								{
									gboolean _tmp79_ = FALSE;
									_tmp79_ = TRUE;
									while (TRUE) {
										guint8* _tmp81_;
										gint _tmp81__length1;
										guint8* _tmp82_;
										gint _tmp82__length1;
										guint8 _tmp83_;
										if (!_tmp79_) {
											gint _tmp80_;
											_tmp80_ = x;
											x = _tmp80_ + 1;
										}
										_tmp79_ = FALSE;
										if (!(x < width)) {
											break;
										}
										_tmp81_ = data;
										_tmp81__length1 = data_length1;
										_tmp82_ = pixels;
										_tmp82__length1 = pixels_length1;
										_tmp83_ = _tmp82_[in_offset + (x * 3)];
										_tmp81_[out_offset + x] = _tmp83_;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp84_ = write_task_pdf_new ();
	write_task = _tmp84_;
	jpeg_data = NULL;
	jpeg_data_length1 = 0;
	_jpeg_data_size_ = jpeg_data_length1;
	{
		guint8* _tmp85_ = NULL;
		GdkPixbuf* _tmp86_;
		Page* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _tmp90_ = 0;
		guint8* _tmp91_;
		gint _tmp85__length1;
		gint __tmp85__size_;
		guint8* _tmp92_;
		gint _tmp92__length1;
		_tmp86_ = image;
		_tmp87_ = page;
		_tmp88_ = page_get_dpi (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp91_ = book_saver_compress_jpeg (_tmp86_, self->priv->quality, _tmp89_, &_tmp90_, &_inner_error0_);
		_tmp85_ = _tmp91_;
		_tmp85__length1 = _tmp90_;
		__tmp85__size_ = _tmp85__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp92_ = _tmp85_;
		_tmp92__length1 = _tmp85__length1;
		_tmp85_ = NULL;
		_tmp85__length1 = 0;
		jpeg_data = (g_free (jpeg_data), NULL);
		jpeg_data = _tmp92_;
		jpeg_data_length1 = _tmp92__length1;
		_jpeg_data_size_ = jpeg_data_length1;
		_tmp85_ = (g_free (_tmp85_), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp93_;
		GError* _tmp94_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp93_ = _error_;
		_tmp94_ = _g_error_copy0 (_tmp93_);
		_g_error_free0 (((WriteTask*) write_task)->error);
		((WriteTask*) write_task)->error = _tmp94_;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		jpeg_data = (g_free (jpeg_data), NULL);
		_write_task_unref0 (write_task);
		data = (g_free (data), NULL);
		_g_free0 (filter);
		_g_free0 (color_space);
		_g_object_unref0 (image);
		_g_object_unref0 (page);
		_encode_task_unref0 (encode_task);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp95_ = data;
	_tmp95__length1 = data_length1;
	_tmp96_ = jpeg_data;
	_tmp96__length1 = jpeg_data_length1;
	_tmp98_ = book_saver_compress_zlib (_tmp95_, (gint) _tmp95__length1, (guint) _tmp96__length1, &_tmp97_);
	zlib_data = _tmp98_;
	zlib_data_length1 = _tmp97_;
	_zlib_data_size_ = zlib_data_length1;
	_tmp99_ = zlib_data;
	_tmp99__length1 = zlib_data_length1;
	if (_tmp99_ != NULL) {
		gchar* _tmp100_;
		guint8* _tmp101_;
		gint _tmp101__length1;
		guint8* _tmp102_;
		gint _tmp102__length1;
		_tmp100_ = g_strdup ("FlateDecode");
		_g_free0 (filter);
		filter = _tmp100_;
		_tmp101_ = zlib_data;
		_tmp101__length1 = zlib_data_length1;
		_tmp102_ = (_tmp101_ != NULL) ? _vala_array_dup3 (_tmp101_, _tmp101__length1) : _tmp101_;
		_tmp102__length1 = _tmp101__length1;
		data = (g_free (data), NULL);
		data = _tmp102_;
		data_length1 = _tmp102__length1;
		_data_size_ = data_length1;
	} else {
		gchar* _tmp103_;
		gchar* _tmp104_;
		guint8* _tmp105_;
		gint _tmp105__length1;
		guint8* _tmp106_;
		gint _tmp106__length1;
		depth = 8;
		_tmp103_ = g_strdup ("DeviceRGB");
		_g_free0 (color_space);
		color_space = _tmp103_;
		_tmp104_ = g_strdup ("DCTDecode");
		_g_free0 (filter);
		filter = _tmp104_;
		_tmp105_ = jpeg_data;
		_tmp105__length1 = jpeg_data_length1;
		_tmp106_ = (_tmp105_ != NULL) ? _vala_array_dup4 (_tmp105_, _tmp105__length1) : _tmp105_;
		_tmp106__length1 = _tmp105__length1;
		data = (g_free (data), NULL);
		data = _tmp106_;
		data_length1 = _tmp106__length1;
		_data_size_ = data_length1;
	}
	((WriteTask*) write_task)->number = encode_task->number;
	_tmp107_ = data;
	_tmp107__length1 = data_length1;
	_tmp108_ = (_tmp107_ != NULL) ? _vala_array_dup5 (_tmp107_, _tmp107__length1) : _tmp107_;
	_tmp108__length1 = _tmp107__length1;
	((WriteTask*) write_task)->data = (g_free (((WriteTask*) write_task)->data), NULL);
	((WriteTask*) write_task)->data = _tmp108_;
	((WriteTask*) write_task)->data_length1 = _tmp108__length1;
	((WriteTask*) write_task)->_data_size_ = ((WriteTask*) write_task)->data_length1;
	write_task->width = width;
	write_task->height = height;
	_tmp109_ = color_space;
	_tmp110_ = g_strdup (_tmp109_);
	_g_free0 (write_task->color_space);
	write_task->color_space = _tmp110_;
	write_task->depth = depth;
	_tmp111_ = filter;
	_tmp112_ = g_strdup (_tmp111_);
	_g_free0 (write_task->filter);
	write_task->filter = _tmp112_;
	_tmp113_ = page;
	_tmp114_ = page_get_dpi (_tmp113_);
	_tmp115_ = _tmp114_;
	write_task->dpi = _tmp115_;
	_tmp116_ = self->priv->write_queue;
	_tmp117_ = _write_task_ref0 ((WriteTask*) write_task);
	g_async_queue_push (_tmp116_, _tmp117_);
	book_saver_update_progression (self);
	zlib_data = (g_free (zlib_data), NULL);
	jpeg_data = (g_free (jpeg_data), NULL);
	_write_task_unref0 (write_task);
	data = (g_free (data), NULL);
	_g_free0 (filter);
	_g_free0 (color_space);
	_g_object_unref0 (image);
	_g_object_unref0 (page);
	_encode_task_unref0 (encode_task);
}

static GError*
book_saver_write_multifile (BookSaver* self)
{
	GError* _inner_error0_ = NULL;
	GError* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GCancellable* _tmp2_;
				WriteTask* write_task = NULL;
				GAsyncQueue* _tmp3_;
				gpointer _tmp4_;
				WriteTask* _tmp5_;
				GError* _tmp6_;
				GFile* indexed_file = NULL;
				GFile* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				WriteTask* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < self->priv->n_pages)) {
					break;
				}
				_tmp2_ = self->priv->cancellable;
				if (g_cancellable_is_cancelled (_tmp2_)) {
					book_saver_finished_saving (self);
					result = NULL;
					return result;
				}
				_tmp3_ = self->priv->write_queue;
				_tmp4_ = g_async_queue_pop (_tmp3_);
				write_task = (WriteTask*) _tmp4_;
				_tmp5_ = write_task;
				_tmp6_ = _tmp5_->error;
				if (_tmp6_ != NULL) {
					WriteTask* _tmp7_;
					GError* _tmp8_;
					GError* _tmp9_;
					book_saver_finished_saving (self);
					_tmp7_ = write_task;
					_tmp8_ = _tmp7_->error;
					_tmp9_ = _g_error_copy0 (_tmp8_);
					result = _tmp9_;
					_write_task_unref0 (write_task);
					return result;
				}
				_tmp10_ = self->priv->file;
				_tmp11_ = g_file_get_uri (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = write_task;
				_tmp14_ = make_indexed_file (_tmp12_, (guint) _tmp13_->number, self->priv->n_pages);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp12_);
				indexed_file = _tmp15_;
				{
					GFileOutputStream* stream = NULL;
					GFile* _tmp16_;
					GFileOutputStream* _tmp17_;
					GFileOutputStream* _tmp18_;
					WriteTask* _tmp19_;
					guint8* _tmp20_;
					gint _tmp20__length1;
					_tmp16_ = indexed_file;
					_tmp17_ = g_file_replace (_tmp16_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
					stream = _tmp17_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp18_ = stream;
					_tmp19_ = write_task;
					_tmp20_ = _tmp19_->data;
					_tmp20__length1 = _tmp19_->data_length1;
					g_output_stream_write_all ((GOutputStream*) _tmp18_, _tmp20_, (gsize) _tmp20__length1, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (stream);
						goto __catch0_g_error;
					}
					_g_object_unref0 (stream);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					book_saver_finished_saving (self);
					result = _error_;
					_g_object_unref0 (indexed_file);
					_write_task_unref0 (write_task);
					return result;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (indexed_file);
					_write_task_unref0 (write_task);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_object_unref0 (indexed_file);
				_write_task_unref0 (write_task);
			}
		}
	}
	book_saver_update_progression (self);
	book_saver_finished_saving (self);
	result = NULL;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static inline void
_g_queue_free__write_task_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _write_task_unref0_);
}

static gint
_______lambda7_ (BookSaver* self,
                 WriteTaskPDF* a,
                 WriteTaskPDF* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = ((WriteTask*) a)->number - ((WriteTask*) b)->number;
	return result;
}

static gint
________lambda7__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self)
{
	gint result;
	result = _______lambda7_ ((BookSaver*) self, (WriteTaskPDF*) a, (WriteTaskPDF*) b);
	return result;
}

static GError*
book_saver_write_pdf (BookSaver* self)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	GFileOutputStream* stream = NULL;
	PDFWriter* writer = NULL;
	GFileOutputStream* _tmp11_;
	PDFWriter* _tmp12_;
	guint catalog_number = 0U;
	PDFWriter* _tmp13_;
	guint metadata_number = 0U;
	PDFWriter* _tmp14_;
	guint pages_number = 0U;
	PDFWriter* _tmp15_;
	guint info_number = 0U;
	PDFWriter* _tmp16_;
	guint* page_numbers = NULL;
	guint* _tmp17_;
	gint page_numbers_length1;
	gint _page_numbers_size_;
	guint* page_image_numbers = NULL;
	guint* _tmp18_;
	gint page_image_numbers_length1;
	gint _page_image_numbers_size_;
	guint* page_content_numbers = NULL;
	guint* _tmp19_;
	gint page_content_numbers_length1;
	gint _page_content_numbers_size_;
	guint struct_tree_root_number = 0U;
	PDFWriter* _tmp28_;
	PDFWriter* _tmp29_;
	PDFWriter* _tmp30_;
	PDFWriter* _tmp31_;
	PDFWriter* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	PDFWriter* _tmp35_;
	PDFWriter* _tmp36_;
	PDFWriter* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	PDFWriter* _tmp40_;
	PDFWriter* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	PDFWriter* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	PDFWriter* _tmp47_;
	PDFWriter* _tmp48_;
	GDateTime* now = NULL;
	GDateTime* _tmp49_;
	gchar* date_string = NULL;
	GDateTime* _tmp50_;
	gchar* _tmp51_;
	gchar* metadata = NULL;
	gchar* _tmp52_;
	gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	PDFWriter* _tmp59_;
	PDFWriter* _tmp60_;
	PDFWriter* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	PDFWriter* _tmp64_;
	PDFWriter* _tmp65_;
	PDFWriter* _tmp66_;
	PDFWriter* _tmp67_;
	const gchar* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	PDFWriter* _tmp73_;
	PDFWriter* _tmp74_;
	PDFWriter* _tmp75_;
	const gchar* _tmp76_;
	PDFWriter* _tmp77_;
	PDFWriter* _tmp78_;
	PDFWriter* _tmp79_;
	PDFWriter* _tmp80_;
	PDFWriter* _tmp81_;
	PDFWriter* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	PDFWriter* _tmp85_;
	PDFWriter* _tmp86_;
	PDFWriter* _tmp87_;
	PDFWriter* _tmp95_;
	PDFWriter* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	PDFWriter* _tmp99_;
	PDFWriter* _tmp100_;
	GQueue* tasks_in_standby = NULL;
	GQueue* _tmp101_;
	PDFWriter* _tmp250_;
	PDFWriter* _tmp251_;
	PDFWriter* _tmp252_;
	gchar* _tmp253_;
	gchar* _tmp254_;
	PDFWriter* _tmp255_;
	PDFWriter* _tmp256_;
	gchar* _tmp257_;
	gchar* _tmp258_;
	PDFWriter* _tmp259_;
	PDFWriter* _tmp260_;
	PDFWriter* _tmp261_;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp262_;
	PDFWriter* _tmp263_;
	PDFWriter* _tmp264_;
	PDFWriter* _tmp265_;
	guint* _tmp266_;
	gint _tmp266__length1;
	gchar* _tmp267_;
	gchar* _tmp268_;
	PDFWriter* _tmp269_;
	PDFWriter* _tmp270_;
	gchar* _tmp271_;
	gchar* _tmp272_;
	PDFWriter* _tmp290_;
	PDFWriter* _tmp291_;
	PDFWriter* _tmp292_;
	PDFWriter* _tmp293_;
	PDFWriter* _tmp294_;
	guint* _tmp295_;
	gint _tmp295__length1;
	gchar* _tmp296_;
	gchar* _tmp297_;
	PDFWriter* _tmp298_;
	gchar* _tmp299_;
	gchar* _tmp300_;
	PDFWriter* _tmp301_;
	gchar* _tmp302_;
	gchar* _tmp303_;
	PDFWriter* _tmp304_;
	const gchar* _tmp305_;
	const gchar* _tmp306_;
	gchar* _tmp307_;
	gchar* _tmp308_;
	PDFWriter* _tmp309_;
	PDFWriter* _tmp310_;
	PDFWriter* _tmp311_;
	gchar* _tmp312_;
	gchar* _tmp313_;
	PDFWriter* _tmp314_;
	GError* _inner_error0_ = NULL;
	GError* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	id = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 4)) {
					break;
				}
				_tmp3_ = id;
				_tmp4_ = g_strdup_printf ("%08x", (guint) g_random_int ());
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
				_g_free0 (id);
				id = _tmp6_;
				_g_free0 (_tmp5_);
			}
		}
	}
	stream = NULL;
	{
		GFileOutputStream* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileOutputStream* _tmp9_;
		GFileOutputStream* _tmp10_;
		_tmp8_ = self->priv->file;
		_tmp9_ = g_file_replace (_tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (stream);
		stream = _tmp10_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		book_saver_finished_saving (self);
		result = _error_;
		_g_object_unref0 (stream);
		_g_free0 (id);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (stream);
		_g_free0 (id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = stream;
	_tmp12_ = pdf_writer_new (_tmp11_);
	writer = _tmp12_;
	_tmp13_ = writer;
	catalog_number = pdf_writer_add_object (_tmp13_);
	_tmp14_ = writer;
	metadata_number = pdf_writer_add_object (_tmp14_);
	_tmp15_ = writer;
	pages_number = pdf_writer_add_object (_tmp15_);
	_tmp16_ = writer;
	info_number = pdf_writer_add_object (_tmp16_);
	_tmp17_ = g_new0 (guint, self->priv->n_pages);
	page_numbers = _tmp17_;
	page_numbers_length1 = self->priv->n_pages;
	_page_numbers_size_ = page_numbers_length1;
	_tmp18_ = g_new0 (guint, self->priv->n_pages);
	page_image_numbers = _tmp18_;
	page_image_numbers_length1 = self->priv->n_pages;
	_page_image_numbers_size_ = page_image_numbers_length1;
	_tmp19_ = g_new0 (guint, self->priv->n_pages);
	page_content_numbers = _tmp19_;
	page_content_numbers_length1 = self->priv->n_pages;
	_page_content_numbers_size_ = page_content_numbers_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				guint* _tmp22_;
				gint _tmp22__length1;
				PDFWriter* _tmp23_;
				guint* _tmp24_;
				gint _tmp24__length1;
				PDFWriter* _tmp25_;
				guint* _tmp26_;
				gint _tmp26__length1;
				PDFWriter* _tmp27_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				if (!(((guint) i) < self->priv->n_pages)) {
					break;
				}
				_tmp22_ = page_numbers;
				_tmp22__length1 = page_numbers_length1;
				_tmp23_ = writer;
				_tmp22_[i] = pdf_writer_add_object (_tmp23_);
				_tmp24_ = page_image_numbers;
				_tmp24__length1 = page_image_numbers_length1;
				_tmp25_ = writer;
				_tmp24_[i] = pdf_writer_add_object (_tmp25_);
				_tmp26_ = page_content_numbers;
				_tmp26__length1 = page_content_numbers_length1;
				_tmp27_ = writer;
				_tmp26_[i] = pdf_writer_add_object (_tmp27_);
			}
		}
	}
	_tmp28_ = writer;
	struct_tree_root_number = pdf_writer_add_object (_tmp28_);
	_tmp29_ = writer;
	pdf_writer_write_string (_tmp29_, "%PDF-1.3\n");
	_tmp30_ = writer;
	pdf_writer_write_string (_tmp30_, "%\xe2\xe3\xcf\xd3\n");
	_tmp31_ = writer;
	pdf_writer_start_object (_tmp31_, catalog_number);
	_tmp32_ = writer;
	_tmp33_ = g_strdup_printf ("%u 0 obj\n", catalog_number);
	_tmp34_ = _tmp33_;
	pdf_writer_write_string (_tmp32_, _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = writer;
	pdf_writer_write_string (_tmp35_, "<<\n");
	_tmp36_ = writer;
	pdf_writer_write_string (_tmp36_, "/Type /Catalog\n");
	_tmp37_ = writer;
	_tmp38_ = g_strdup_printf ("/Metadata %u 0 R\n", metadata_number);
	_tmp39_ = _tmp38_;
	pdf_writer_write_string (_tmp37_, _tmp39_);
	_g_free0 (_tmp39_);
	_tmp40_ = writer;
	pdf_writer_write_string (_tmp40_, "/MarkInfo << /Marked true >>\n");
	_tmp41_ = writer;
	_tmp42_ = g_strdup_printf ("/StructTreeRoot %u 0 R\n", struct_tree_root_number);
	_tmp43_ = _tmp42_;
	pdf_writer_write_string (_tmp41_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = writer;
	_tmp45_ = g_strdup_printf ("/Pages %u 0 R\n", pages_number);
	_tmp46_ = _tmp45_;
	pdf_writer_write_string (_tmp44_, _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = writer;
	pdf_writer_write_string (_tmp47_, ">>\n");
	_tmp48_ = writer;
	pdf_writer_write_string (_tmp48_, "endobj\n");
	_tmp49_ = g_date_time_new_now_local ();
	now = _tmp49_;
	_tmp50_ = now;
	_tmp51_ = g_date_time_format (_tmp50_, "%FT%H:%M:%S%:z");
	date_string = _tmp51_;
	_tmp52_ = g_unichar_to_string ((gunichar) 0xFEFF);
	_tmp53_ = _tmp52_;
	_tmp54_ = date_string;
	_tmp55_ = date_string;
	_tmp56_ = date_string;
	_tmp57_ = g_strdup_printf ("<?xpacket begin=\"%s\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n" \
"<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n" \
"         xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n" \
"  <rdf:Description rdf:about=\"\"\n" \
"                   xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\"\n" \
"                   xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n" \
"    <pdfaid:part>1</pdfaid:part>\n" \
"    <pdfaid:conformance>A</pdfaid:conformance>\n" \
"    <xmp:CreatorTool>Simple Scan %s</xmp:CreatorTool>\n" \
"    <xmp:CreateDate>%s</xmp:CreateDate>\n" \
"    <xmp:ModifyDate>%s</xmp:ModifyDate>\n" \
"    <xmp:MetadataDate>%s</xmp:MetadataDate>\n" \
"  </rdf:Description>\n" \
"</rdf:RDF>\n" \
"<?xpacket end=\"w\"?>", _tmp53_, VERSION, _tmp54_, _tmp55_, _tmp56_);
	_tmp58_ = _tmp57_;
	_g_free0 (_tmp53_);
	metadata = _tmp58_;
	_tmp59_ = writer;
	pdf_writer_write_string (_tmp59_, "\n");
	_tmp60_ = writer;
	pdf_writer_start_object (_tmp60_, metadata_number);
	_tmp61_ = writer;
	_tmp62_ = g_strdup_printf ("%u 0 obj\n", metadata_number);
	_tmp63_ = _tmp62_;
	pdf_writer_write_string (_tmp61_, _tmp63_);
	_g_free0 (_tmp63_);
	_tmp64_ = writer;
	pdf_writer_write_string (_tmp64_, "<<\n");
	_tmp65_ = writer;
	pdf_writer_write_string (_tmp65_, "/Type /Metadata\n");
	_tmp66_ = writer;
	pdf_writer_write_string (_tmp66_, "/Subtype /XML\n");
	_tmp67_ = writer;
	_tmp68_ = metadata;
	_tmp69_ = strlen (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_strdup_printf ("/Length %u\n", (guint) _tmp70_);
	_tmp72_ = _tmp71_;
	pdf_writer_write_string (_tmp67_, _tmp72_);
	_g_free0 (_tmp72_);
	_tmp73_ = writer;
	pdf_writer_write_string (_tmp73_, ">>\n");
	_tmp74_ = writer;
	pdf_writer_write_string (_tmp74_, "stream\n");
	_tmp75_ = writer;
	_tmp76_ = metadata;
	pdf_writer_write_string (_tmp75_, _tmp76_);
	_tmp77_ = writer;
	pdf_writer_write_string (_tmp77_, "\n");
	_tmp78_ = writer;
	pdf_writer_write_string (_tmp78_, "endstream\n");
	_tmp79_ = writer;
	pdf_writer_write_string (_tmp79_, "endobj\n");
	_tmp80_ = writer;
	pdf_writer_write_string (_tmp80_, "\n");
	_tmp81_ = writer;
	pdf_writer_start_object (_tmp81_, pages_number);
	_tmp82_ = writer;
	_tmp83_ = g_strdup_printf ("%u 0 obj\n", pages_number);
	_tmp84_ = _tmp83_;
	pdf_writer_write_string (_tmp82_, _tmp84_);
	_g_free0 (_tmp84_);
	_tmp85_ = writer;
	pdf_writer_write_string (_tmp85_, "<<\n");
	_tmp86_ = writer;
	pdf_writer_write_string (_tmp86_, "/Type /Pages\n");
	_tmp87_ = writer;
	pdf_writer_write_string (_tmp87_, "/Kids [");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp88_ = FALSE;
			_tmp88_ = TRUE;
			while (TRUE) {
				PDFWriter* _tmp90_;
				guint* _tmp91_;
				gint _tmp91__length1;
				guint _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				if (!_tmp88_) {
					gint _tmp89_;
					_tmp89_ = i;
					i = _tmp89_ + 1;
				}
				_tmp88_ = FALSE;
				if (!(((guint) i) < self->priv->n_pages)) {
					break;
				}
				_tmp90_ = writer;
				_tmp91_ = page_numbers;
				_tmp91__length1 = page_numbers_length1;
				_tmp92_ = _tmp91_[i];
				_tmp93_ = g_strdup_printf (" %u 0 R", _tmp92_);
				_tmp94_ = _tmp93_;
				pdf_writer_write_string (_tmp90_, _tmp94_);
				_g_free0 (_tmp94_);
			}
		}
	}
	_tmp95_ = writer;
	pdf_writer_write_string (_tmp95_, " ]\n");
	_tmp96_ = writer;
	_tmp97_ = g_strdup_printf ("/Count %u\n", self->priv->n_pages);
	_tmp98_ = _tmp97_;
	pdf_writer_write_string (_tmp96_, _tmp98_);
	_g_free0 (_tmp98_);
	_tmp99_ = writer;
	pdf_writer_write_string (_tmp99_, ">>\n");
	_tmp100_ = writer;
	pdf_writer_write_string (_tmp100_, "endobj\n");
	_tmp101_ = g_queue_new ();
	tasks_in_standby = _tmp101_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp102_ = FALSE;
			_tmp102_ = TRUE;
			while (TRUE) {
				GCancellable* _tmp104_;
				WriteTaskPDF* write_task = NULL;
				GQueue* _tmp105_;
				gconstpointer _tmp106_;
				WriteTaskPDF* _tmp107_;
				gboolean _tmp108_ = FALSE;
				WriteTaskPDF* _tmp109_;
				gdouble page_width = 0.0;
				WriteTaskPDF* _tmp125_;
				WriteTaskPDF* _tmp126_;
				gdouble page_height = 0.0;
				WriteTaskPDF* _tmp127_;
				WriteTaskPDF* _tmp128_;
				gchar* width_buffer = NULL;
				gchar* _tmp129_;
				gint width_buffer_length1;
				gint _width_buffer_size_;
				gchar* height_buffer = NULL;
				gchar* _tmp130_;
				gint height_buffer_length1;
				gint _height_buffer_size_;
				PDFWriter* _tmp131_;
				PDFWriter* _tmp132_;
				guint* _tmp133_;
				gint _tmp133__length1;
				guint _tmp134_;
				PDFWriter* _tmp135_;
				guint* _tmp136_;
				gint _tmp136__length1;
				guint _tmp137_;
				gchar* _tmp138_;
				gchar* _tmp139_;
				PDFWriter* _tmp140_;
				PDFWriter* _tmp141_;
				PDFWriter* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				PDFWriter* _tmp145_;
				guint* _tmp146_;
				gint _tmp146__length1;
				guint _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				PDFWriter* _tmp150_;
				gchar* _tmp151_;
				gint _tmp151__length1;
				const gchar* _tmp152_;
				gchar* _tmp153_;
				gint _tmp153__length1;
				const gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				PDFWriter* _tmp157_;
				guint* _tmp158_;
				gint _tmp158__length1;
				guint _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				PDFWriter* _tmp162_;
				PDFWriter* _tmp163_;
				PDFWriter* _tmp164_;
				PDFWriter* _tmp165_;
				guint* _tmp166_;
				gint _tmp166__length1;
				guint _tmp167_;
				PDFWriter* _tmp168_;
				guint* _tmp169_;
				gint _tmp169__length1;
				guint _tmp170_;
				gchar* _tmp171_;
				gchar* _tmp172_;
				PDFWriter* _tmp173_;
				PDFWriter* _tmp174_;
				PDFWriter* _tmp175_;
				PDFWriter* _tmp176_;
				WriteTaskPDF* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				PDFWriter* _tmp180_;
				WriteTaskPDF* _tmp181_;
				gchar* _tmp182_;
				gchar* _tmp183_;
				PDFWriter* _tmp184_;
				WriteTaskPDF* _tmp185_;
				const gchar* _tmp186_;
				gchar* _tmp187_;
				gchar* _tmp188_;
				PDFWriter* _tmp189_;
				WriteTaskPDF* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				PDFWriter* _tmp193_;
				WriteTaskPDF* _tmp194_;
				guint8* _tmp195_;
				gint _tmp195__length1;
				gchar* _tmp196_;
				gchar* _tmp197_;
				WriteTaskPDF* _tmp198_;
				const gchar* _tmp199_;
				PDFWriter* _tmp205_;
				PDFWriter* _tmp206_;
				PDFWriter* _tmp207_;
				WriteTaskPDF* _tmp208_;
				guint8* _tmp209_;
				gint _tmp209__length1;
				PDFWriter* _tmp210_;
				PDFWriter* _tmp211_;
				PDFWriter* _tmp212_;
				PDFWriter* _tmp213_;
				PDFWriter* _tmp214_;
				PDFWriter* _tmp215_;
				gchar* _tmp216_;
				gchar* _tmp217_;
				PDFWriter* _tmp218_;
				PDFWriter* _tmp219_;
				PDFWriter* _tmp220_;
				PDFWriter* _tmp221_;
				gchar* command = NULL;
				gchar* _tmp222_;
				gint _tmp222__length1;
				const gchar* _tmp223_;
				gchar* _tmp224_;
				gint _tmp224__length1;
				const gchar* _tmp225_;
				gchar* _tmp226_;
				PDFWriter* _tmp227_;
				PDFWriter* _tmp228_;
				guint* _tmp229_;
				gint _tmp229__length1;
				guint _tmp230_;
				PDFWriter* _tmp231_;
				guint* _tmp232_;
				gint _tmp232__length1;
				guint _tmp233_;
				gchar* _tmp234_;
				gchar* _tmp235_;
				PDFWriter* _tmp236_;
				PDFWriter* _tmp237_;
				const gchar* _tmp238_;
				gint _tmp239_;
				gint _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				PDFWriter* _tmp243_;
				PDFWriter* _tmp244_;
				PDFWriter* _tmp245_;
				const gchar* _tmp246_;
				PDFWriter* _tmp247_;
				PDFWriter* _tmp248_;
				PDFWriter* _tmp249_;
				if (!_tmp102_) {
					gint _tmp103_;
					_tmp103_ = i;
					i = _tmp103_ + 1;
				}
				_tmp102_ = FALSE;
				if (!(((guint) i) < self->priv->n_pages)) {
					break;
				}
				_tmp104_ = self->priv->cancellable;
				if (g_cancellable_is_cancelled (_tmp104_)) {
					book_saver_finished_saving (self);
					result = NULL;
					(tasks_in_standby == NULL) ? NULL : (tasks_in_standby = (_g_queue_free__write_task_unref0_ (tasks_in_standby), NULL));
					_g_free0 (metadata);
					_g_free0 (date_string);
					_g_date_time_unref0 (now);
					page_content_numbers = (g_free (page_content_numbers), NULL);
					page_image_numbers = (g_free (page_image_numbers), NULL);
					page_numbers = (g_free (page_numbers), NULL);
					_pdf_writer_unref0 (writer);
					_g_object_unref0 (stream);
					_g_free0 (id);
					return result;
				}
				_tmp105_ = tasks_in_standby;
				_tmp106_ = g_queue_peek_head (_tmp105_);
				_tmp107_ = _write_task_ref0 ((WriteTaskPDF*) _tmp106_);
				write_task = _tmp107_;
				_tmp109_ = write_task;
				if (_tmp109_ != NULL) {
					WriteTaskPDF* _tmp110_;
					_tmp110_ = write_task;
					_tmp108_ = ((WriteTask*) _tmp110_)->number == i;
				} else {
					_tmp108_ = FALSE;
				}
				if (_tmp108_) {
					GQueue* _tmp111_;
					gpointer _tmp112_;
					WriteTaskPDF* _tmp113_;
					_tmp111_ = tasks_in_standby;
					_tmp112_ = g_queue_pop_head (_tmp111_);
					_tmp113_ = (WriteTaskPDF*) _tmp112_;
					_write_task_unref0 (_tmp113_);
				} else {
					while (TRUE) {
						GAsyncQueue* _tmp114_;
						gpointer _tmp115_;
						WriteTaskPDF* _tmp116_;
						GError* _tmp117_;
						WriteTaskPDF* _tmp121_;
						GQueue* _tmp122_;
						WriteTaskPDF* _tmp123_;
						WriteTaskPDF* _tmp124_;
						_tmp114_ = self->priv->write_queue;
						_tmp115_ = g_async_queue_pop (_tmp114_);
						_write_task_unref0 (write_task);
						write_task = G_TYPE_CHECK_INSTANCE_CAST ((WriteTask*) _tmp115_, TYPE_WRITE_TASK_PDF, WriteTaskPDF);
						_tmp116_ = write_task;
						_tmp117_ = ((WriteTask*) _tmp116_)->error;
						if (_tmp117_ != NULL) {
							WriteTaskPDF* _tmp118_;
							GError* _tmp119_;
							GError* _tmp120_;
							book_saver_finished_saving (self);
							_tmp118_ = write_task;
							_tmp119_ = ((WriteTask*) _tmp118_)->error;
							_tmp120_ = _g_error_copy0 (_tmp119_);
							result = _tmp120_;
							_write_task_unref0 (write_task);
							(tasks_in_standby == NULL) ? NULL : (tasks_in_standby = (_g_queue_free__write_task_unref0_ (tasks_in_standby), NULL));
							_g_free0 (metadata);
							_g_free0 (date_string);
							_g_date_time_unref0 (now);
							page_content_numbers = (g_free (page_content_numbers), NULL);
							page_image_numbers = (g_free (page_image_numbers), NULL);
							page_numbers = (g_free (page_numbers), NULL);
							_pdf_writer_unref0 (writer);
							_g_object_unref0 (stream);
							_g_free0 (id);
							return result;
						}
						_tmp121_ = write_task;
						if (((WriteTask*) _tmp121_)->number == i) {
							break;
						}
						_tmp122_ = tasks_in_standby;
						_tmp123_ = write_task;
						_tmp124_ = _write_task_ref0 (_tmp123_);
						g_queue_insert_sorted (_tmp122_, _tmp124_, ________lambda7__gcompare_data_func, self);
					}
				}
				_tmp125_ = write_task;
				_tmp126_ = write_task;
				page_width = (_tmp125_->width * 72.0) / _tmp126_->dpi;
				_tmp127_ = write_task;
				_tmp128_ = write_task;
				page_height = (_tmp127_->height * 72.0) / _tmp128_->dpi;
				_tmp129_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				width_buffer = _tmp129_;
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_width_buffer_size_ = width_buffer_length1;
				_tmp130_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				height_buffer = _tmp130_;
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_height_buffer_size_ = height_buffer_length1;
				_tmp131_ = writer;
				pdf_writer_write_string (_tmp131_, "\n");
				_tmp132_ = writer;
				_tmp133_ = page_numbers;
				_tmp133__length1 = page_numbers_length1;
				_tmp134_ = _tmp133_[i];
				pdf_writer_start_object (_tmp132_, _tmp134_);
				_tmp135_ = writer;
				_tmp136_ = page_numbers;
				_tmp136__length1 = page_numbers_length1;
				_tmp137_ = _tmp136_[i];
				_tmp138_ = g_strdup_printf ("%u 0 obj\n", _tmp137_);
				_tmp139_ = _tmp138_;
				pdf_writer_write_string (_tmp135_, _tmp139_);
				_g_free0 (_tmp139_);
				_tmp140_ = writer;
				pdf_writer_write_string (_tmp140_, "<<\n");
				_tmp141_ = writer;
				pdf_writer_write_string (_tmp141_, "/Type /Page\n");
				_tmp142_ = writer;
				_tmp143_ = g_strdup_printf ("/Parent %u 0 R\n", pages_number);
				_tmp144_ = _tmp143_;
				pdf_writer_write_string (_tmp142_, _tmp144_);
				_g_free0 (_tmp144_);
				_tmp145_ = writer;
				_tmp146_ = page_image_numbers;
				_tmp146__length1 = page_image_numbers_length1;
				_tmp147_ = _tmp146_[i];
				_tmp148_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", i, _tmp147_);
				_tmp149_ = _tmp148_;
				pdf_writer_write_string (_tmp145_, _tmp149_);
				_g_free0 (_tmp149_);
				_tmp150_ = writer;
				_tmp151_ = width_buffer;
				_tmp151__length1 = width_buffer_length1;
				_tmp152_ = g_ascii_formatd (_tmp151_, (gint) _tmp151__length1, "%.2f", page_width);
				_tmp153_ = height_buffer;
				_tmp153__length1 = height_buffer_length1;
				_tmp154_ = g_ascii_formatd (_tmp153_, (gint) _tmp153__length1, "%.2f", page_height);
				_tmp155_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp152_, _tmp154_);
				_tmp156_ = _tmp155_;
				pdf_writer_write_string (_tmp150_, _tmp156_);
				_g_free0 (_tmp156_);
				_tmp157_ = writer;
				_tmp158_ = page_content_numbers;
				_tmp158__length1 = page_content_numbers_length1;
				_tmp159_ = _tmp158_[i];
				_tmp160_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp159_);
				_tmp161_ = _tmp160_;
				pdf_writer_write_string (_tmp157_, _tmp161_);
				_g_free0 (_tmp161_);
				_tmp162_ = writer;
				pdf_writer_write_string (_tmp162_, ">>\n");
				_tmp163_ = writer;
				pdf_writer_write_string (_tmp163_, "endobj\n");
				_tmp164_ = writer;
				pdf_writer_write_string (_tmp164_, "\n");
				_tmp165_ = writer;
				_tmp166_ = page_image_numbers;
				_tmp166__length1 = page_image_numbers_length1;
				_tmp167_ = _tmp166_[i];
				pdf_writer_start_object (_tmp165_, _tmp167_);
				_tmp168_ = writer;
				_tmp169_ = page_image_numbers;
				_tmp169__length1 = page_image_numbers_length1;
				_tmp170_ = _tmp169_[i];
				_tmp171_ = g_strdup_printf ("%u 0 obj\n", _tmp170_);
				_tmp172_ = _tmp171_;
				pdf_writer_write_string (_tmp168_, _tmp172_);
				_g_free0 (_tmp172_);
				_tmp173_ = writer;
				pdf_writer_write_string (_tmp173_, "<<\n");
				_tmp174_ = writer;
				pdf_writer_write_string (_tmp174_, "/Type /XObject\n");
				_tmp175_ = writer;
				pdf_writer_write_string (_tmp175_, "/Subtype /Image\n");
				_tmp176_ = writer;
				_tmp177_ = write_task;
				_tmp178_ = g_strdup_printf ("/Width %d\n", _tmp177_->width);
				_tmp179_ = _tmp178_;
				pdf_writer_write_string (_tmp176_, _tmp179_);
				_g_free0 (_tmp179_);
				_tmp180_ = writer;
				_tmp181_ = write_task;
				_tmp182_ = g_strdup_printf ("/Height %d\n", _tmp181_->height);
				_tmp183_ = _tmp182_;
				pdf_writer_write_string (_tmp180_, _tmp183_);
				_g_free0 (_tmp183_);
				_tmp184_ = writer;
				_tmp185_ = write_task;
				_tmp186_ = _tmp185_->color_space;
				_tmp187_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp186_);
				_tmp188_ = _tmp187_;
				pdf_writer_write_string (_tmp184_, _tmp188_);
				_g_free0 (_tmp188_);
				_tmp189_ = writer;
				_tmp190_ = write_task;
				_tmp191_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp190_->depth);
				_tmp192_ = _tmp191_;
				pdf_writer_write_string (_tmp189_, _tmp192_);
				_g_free0 (_tmp192_);
				_tmp193_ = writer;
				_tmp194_ = write_task;
				_tmp195_ = ((WriteTask*) _tmp194_)->data;
				_tmp195__length1 = ((WriteTask*) _tmp194_)->data_length1;
				_tmp196_ = g_strdup_printf ("/Length %d\n", _tmp195__length1);
				_tmp197_ = _tmp196_;
				pdf_writer_write_string (_tmp193_, _tmp197_);
				_g_free0 (_tmp197_);
				_tmp198_ = write_task;
				_tmp199_ = _tmp198_->filter;
				if (_tmp199_ != NULL) {
					PDFWriter* _tmp200_;
					WriteTaskPDF* _tmp201_;
					const gchar* _tmp202_;
					gchar* _tmp203_;
					gchar* _tmp204_;
					_tmp200_ = writer;
					_tmp201_ = write_task;
					_tmp202_ = _tmp201_->filter;
					_tmp203_ = g_strdup_printf ("/Filter /%s\n", _tmp202_);
					_tmp204_ = _tmp203_;
					pdf_writer_write_string (_tmp200_, _tmp204_);
					_g_free0 (_tmp204_);
				}
				_tmp205_ = writer;
				pdf_writer_write_string (_tmp205_, ">>\n");
				_tmp206_ = writer;
				pdf_writer_write_string (_tmp206_, "stream\n");
				_tmp207_ = writer;
				_tmp208_ = write_task;
				_tmp209_ = ((WriteTask*) _tmp208_)->data;
				_tmp209__length1 = ((WriteTask*) _tmp208_)->data_length1;
				pdf_writer_write (_tmp207_, _tmp209_, (gint) _tmp209__length1);
				_tmp210_ = writer;
				pdf_writer_write_string (_tmp210_, "\n");
				_tmp211_ = writer;
				pdf_writer_write_string (_tmp211_, "endstream\n");
				_tmp212_ = writer;
				pdf_writer_write_string (_tmp212_, "endobj\n");
				_tmp213_ = writer;
				pdf_writer_write_string (_tmp213_, "\n");
				_tmp214_ = writer;
				pdf_writer_start_object (_tmp214_, struct_tree_root_number);
				_tmp215_ = writer;
				_tmp216_ = g_strdup_printf ("%u 0 obj\n", struct_tree_root_number);
				_tmp217_ = _tmp216_;
				pdf_writer_write_string (_tmp215_, _tmp217_);
				_g_free0 (_tmp217_);
				_tmp218_ = writer;
				pdf_writer_write_string (_tmp218_, "<<\n");
				_tmp219_ = writer;
				pdf_writer_write_string (_tmp219_, "/Type /StructTreeRoot\n");
				_tmp220_ = writer;
				pdf_writer_write_string (_tmp220_, ">>\n");
				_tmp221_ = writer;
				pdf_writer_write_string (_tmp221_, "endobj\n");
				_tmp222_ = width_buffer;
				_tmp222__length1 = width_buffer_length1;
				_tmp223_ = g_ascii_formatd (_tmp222_, (gint) _tmp222__length1, "%f", page_width);
				_tmp224_ = height_buffer;
				_tmp224__length1 = height_buffer_length1;
				_tmp225_ = g_ascii_formatd (_tmp224_, (gint) _tmp224__length1, "%f", page_height);
				_tmp226_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp223_, _tmp225_, i);
				command = _tmp226_;
				_tmp227_ = writer;
				pdf_writer_write_string (_tmp227_, "\n");
				_tmp228_ = writer;
				_tmp229_ = page_content_numbers;
				_tmp229__length1 = page_content_numbers_length1;
				_tmp230_ = _tmp229_[i];
				pdf_writer_start_object (_tmp228_, _tmp230_);
				_tmp231_ = writer;
				_tmp232_ = page_content_numbers;
				_tmp232__length1 = page_content_numbers_length1;
				_tmp233_ = _tmp232_[i];
				_tmp234_ = g_strdup_printf ("%u 0 obj\n", _tmp233_);
				_tmp235_ = _tmp234_;
				pdf_writer_write_string (_tmp231_, _tmp235_);
				_g_free0 (_tmp235_);
				_tmp236_ = writer;
				pdf_writer_write_string (_tmp236_, "<<\n");
				_tmp237_ = writer;
				_tmp238_ = command;
				_tmp239_ = strlen (_tmp238_);
				_tmp240_ = _tmp239_;
				_tmp241_ = g_strdup_printf ("/Length %d\n", _tmp240_);
				_tmp242_ = _tmp241_;
				pdf_writer_write_string (_tmp237_, _tmp242_);
				_g_free0 (_tmp242_);
				_tmp243_ = writer;
				pdf_writer_write_string (_tmp243_, ">>\n");
				_tmp244_ = writer;
				pdf_writer_write_string (_tmp244_, "stream\n");
				_tmp245_ = writer;
				_tmp246_ = command;
				pdf_writer_write_string (_tmp245_, _tmp246_);
				_tmp247_ = writer;
				pdf_writer_write_string (_tmp247_, "\n");
				_tmp248_ = writer;
				pdf_writer_write_string (_tmp248_, "endstream\n");
				_tmp249_ = writer;
				pdf_writer_write_string (_tmp249_, "endobj\n");
				_g_free0 (command);
				height_buffer = (g_free (height_buffer), NULL);
				width_buffer = (g_free (width_buffer), NULL);
				_write_task_unref0 (write_task);
			}
		}
	}
	_tmp250_ = writer;
	pdf_writer_write_string (_tmp250_, "\n");
	_tmp251_ = writer;
	pdf_writer_start_object (_tmp251_, info_number);
	_tmp252_ = writer;
	_tmp253_ = g_strdup_printf ("%u 0 obj\n", info_number);
	_tmp254_ = _tmp253_;
	pdf_writer_write_string (_tmp252_, _tmp254_);
	_g_free0 (_tmp254_);
	_tmp255_ = writer;
	pdf_writer_write_string (_tmp255_, "<<\n");
	_tmp256_ = writer;
	_tmp257_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
	_tmp258_ = _tmp257_;
	pdf_writer_write_string (_tmp256_, _tmp258_);
	_g_free0 (_tmp258_);
	_tmp259_ = writer;
	pdf_writer_write_string (_tmp259_, ">>\n");
	_tmp260_ = writer;
	pdf_writer_write_string (_tmp260_, "endobj\n");
	_tmp261_ = writer;
	pdf_writer_write_string (_tmp261_, "\n");
	_tmp262_ = writer;
	xref_offset = _tmp262_->offset;
	_tmp263_ = writer;
	pdf_writer_write_string (_tmp263_, "xref\n");
	_tmp264_ = writer;
	_tmp265_ = writer;
	_tmp266_ = _tmp265_->object_offsets;
	_tmp266__length1 = _tmp265_->object_offsets_length1;
	_tmp267_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp266__length1 + 1));
	_tmp268_ = _tmp267_;
	pdf_writer_write_string (_tmp264_, _tmp268_);
	_g_free0 (_tmp268_);
	_tmp269_ = writer;
	_tmp270_ = writer;
	_tmp271_ = g_strdup_printf ("%010zu 65535 f \n", (gsize) pdf_writer_next_empty_object (_tmp270_, 0));
	_tmp272_ = _tmp271_;
	pdf_writer_write_string (_tmp269_, _tmp272_);
	_g_free0 (_tmp272_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp273_ = FALSE;
			_tmp273_ = TRUE;
			while (TRUE) {
				PDFWriter* _tmp275_;
				guint* _tmp276_;
				gint _tmp276__length1;
				PDFWriter* _tmp277_;
				guint* _tmp278_;
				gint _tmp278__length1;
				guint _tmp279_;
				if (!_tmp273_) {
					gint _tmp274_;
					_tmp274_ = i;
					i = _tmp274_ + 1;
				}
				_tmp273_ = FALSE;
				_tmp275_ = writer;
				_tmp276_ = _tmp275_->object_offsets;
				_tmp276__length1 = _tmp275_->object_offsets_length1;
				if (!(i < _tmp276__length1)) {
					break;
				}
				_tmp277_ = writer;
				_tmp278_ = _tmp277_->object_offsets;
				_tmp278__length1 = _tmp277_->object_offsets_length1;
				_tmp279_ = _tmp278_[i];
				if (_tmp279_ == ((guint) 0)) {
					PDFWriter* _tmp280_;
					PDFWriter* _tmp281_;
					gchar* _tmp282_;
					gchar* _tmp283_;
					_tmp280_ = writer;
					_tmp281_ = writer;
					_tmp282_ = g_strdup_printf ("%010zu 65535 f \n", (gsize) pdf_writer_next_empty_object (_tmp281_, i + 1));
					_tmp283_ = _tmp282_;
					pdf_writer_write_string (_tmp280_, _tmp283_);
					_g_free0 (_tmp283_);
				} else {
					PDFWriter* _tmp284_;
					PDFWriter* _tmp285_;
					guint* _tmp286_;
					gint _tmp286__length1;
					guint _tmp287_;
					gchar* _tmp288_;
					gchar* _tmp289_;
					_tmp284_ = writer;
					_tmp285_ = writer;
					_tmp286_ = _tmp285_->object_offsets;
					_tmp286__length1 = _tmp285_->object_offsets_length1;
					_tmp287_ = _tmp286_[i];
					_tmp288_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp287_);
					_tmp289_ = _tmp288_;
					pdf_writer_write_string (_tmp284_, _tmp289_);
					_g_free0 (_tmp289_);
				}
			}
		}
	}
	_tmp290_ = writer;
	pdf_writer_write_string (_tmp290_, "\n");
	_tmp291_ = writer;
	pdf_writer_write_string (_tmp291_, "trailer\n");
	_tmp292_ = writer;
	pdf_writer_write_string (_tmp292_, "<<\n");
	_tmp293_ = writer;
	_tmp294_ = writer;
	_tmp295_ = _tmp294_->object_offsets;
	_tmp295__length1 = _tmp294_->object_offsets_length1;
	_tmp296_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp295__length1 + 1));
	_tmp297_ = _tmp296_;
	pdf_writer_write_string (_tmp293_, _tmp297_);
	_g_free0 (_tmp297_);
	_tmp298_ = writer;
	_tmp299_ = g_strdup_printf ("/Info %u 0 R\n", info_number);
	_tmp300_ = _tmp299_;
	pdf_writer_write_string (_tmp298_, _tmp300_);
	_g_free0 (_tmp300_);
	_tmp301_ = writer;
	_tmp302_ = g_strdup_printf ("/Root %u 0 R\n", catalog_number);
	_tmp303_ = _tmp302_;
	pdf_writer_write_string (_tmp301_, _tmp303_);
	_g_free0 (_tmp303_);
	_tmp304_ = writer;
	_tmp305_ = id;
	_tmp306_ = id;
	_tmp307_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp305_, _tmp306_);
	_tmp308_ = _tmp307_;
	pdf_writer_write_string (_tmp304_, _tmp308_);
	_g_free0 (_tmp308_);
	_tmp309_ = writer;
	pdf_writer_write_string (_tmp309_, ">>\n");
	_tmp310_ = writer;
	pdf_writer_write_string (_tmp310_, "startxref\n");
	_tmp311_ = writer;
	_tmp312_ = g_strdup_printf ("%zu\n", xref_offset);
	_tmp313_ = _tmp312_;
	pdf_writer_write_string (_tmp311_, _tmp313_);
	_g_free0 (_tmp313_);
	_tmp314_ = writer;
	pdf_writer_write_string (_tmp314_, "%%EOF\n");
	book_saver_update_progression (self);
	book_saver_finished_saving (self);
	result = NULL;
	(tasks_in_standby == NULL) ? NULL : (tasks_in_standby = (_g_queue_free__write_task_unref0_ (tasks_in_standby), NULL));
	_g_free0 (metadata);
	_g_free0 (date_string);
	_g_date_time_unref0 (now);
	page_content_numbers = (g_free (page_content_numbers), NULL);
	page_image_numbers = (g_free (page_image_numbers), NULL);
	page_numbers = (g_free (page_numbers), NULL);
	_pdf_writer_unref0 (writer);
	_g_object_unref0 (stream);
	_g_free0 (id);
	return result;
}

static gboolean
__lambda6_ (BookSaver* self)
{
	ProgressionCallback _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	_tmp0_ = self->priv->progression_callback;
	_tmp0__target = self->priv->progression_callback_target;
	_tmp0_ (self->priv->progression, _tmp0__target);
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((BookSaver*) self);
	return result;
}

static void
book_saver_update_progression (BookSaver* self)
{
	gdouble step = 0.0;
	g_return_if_fail (self != NULL);
	step = 1.0 / ((gdouble) (self->priv->n_pages + 1));
	g_mutex_lock (&self->priv->progression_mutex);
	self->priv->progression = self->priv->progression + step;
	g_mutex_unlock (&self->priv->progression_mutex);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, book_saver_ref (self), book_saver_unref);
}

static void
vala__g_thread_pool_free_wrapper (GThreadPool* pool,
                                  gboolean immediate,
                                  gboolean wait)
{
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
	_tmp0_ = pool;
	pool = NULL;
	ptr = _tmp0_;
	_tmp1_ = ptr;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_;
		_tmp2_ = ptr;
		g_thread_pool_free ((GThreadPool*) _tmp2_, immediate, wait);
	}
	_g_thread_pool_free0 (pool);
}

static void
book_saver_finished_saving (BookSaver* self)
{
	GThreadPool* _tmp0_;
	GSourceFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->encoder;
	self->priv->encoder = NULL;
	vala__g_thread_pool_free_wrapper (_tmp0_, TRUE, TRUE);
	_tmp1_ = self->priv->save_async_callback;
	_tmp1__target = self->priv->save_async_callback_target;
	_tmp1__target_destroy_notify = self->priv->save_async_callback_target_destroy_notify;
	self->priv->save_async_callback = NULL;
	self->priv->save_async_callback_target = NULL;
	self->priv->save_async_callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
}

static guint8*
book_saver_compress_zlib (guint8* data,
                          gint data_length1,
                          guint max_size,
                          gint* result_length1)
{
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_;
	gint out_data_length1;
	gint _out_data_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint n_written = 0U;
	guint8* _tmp6_;
	gint _tmp6__length1;
	z_stream _tmp7_;
	gint _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* result;
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
	_tmp0_ = g_new0 (guint8, max_size);
	out_data = _tmp0_;
	out_data_length1 = max_size;
	_out_data_size_ = out_data_length1;
	stream.next_in = data;
	stream.avail_in = data_length1;
	_tmp1_ = out_data;
	_tmp1__length1 = out_data_length1;
	stream.next_out = _tmp1_;
	stream.avail_out = _tmp1__length1;
	while (TRUE) {
		z_stream _tmp2_;
		z_stream _tmp3_;
		_tmp2_ = stream;
		if (_tmp2_.avail_in == ((guint) 0)) {
			break;
		}
		_tmp3_ = stream;
		if (_tmp3_.avail_out == ((guint) 0)) {
			guint8* _tmp4_;
			gint _tmp4__length1;
			_tmp4_ = NULL;
			_tmp4__length1 = 0;
			if (result_length1) {
				*result_length1 = _tmp4__length1;
			}
			result = _tmp4_;
			out_data = (g_free (out_data), NULL);
			deflateEnd (&stream);
			return result;
		}
		if (deflate (&stream, (gint) Z_FINISH) == ((gint) Z_STREAM_ERROR)) {
			guint8* _tmp5_;
			gint _tmp5__length1;
			_tmp5_ = NULL;
			_tmp5__length1 = 0;
			if (result_length1) {
				*result_length1 = _tmp5__length1;
			}
			result = _tmp5_;
			out_data = (g_free (out_data), NULL);
			deflateEnd (&stream);
			return result;
		}
	}
	_tmp6_ = out_data;
	_tmp6__length1 = out_data_length1;
	_tmp7_ = stream;
	n_written = _tmp6__length1 - _tmp7_.avail_out;
	_tmp8_ = (gint) n_written;
	out_data = g_renew (guint8, out_data, (gint) n_written);
	(_tmp8_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp8_ - out_data_length1)) : NULL;
	out_data_length1 = _tmp8_;
	_out_data_size_ = _tmp8_;
	_tmp9_ = out_data;
	_tmp9__length1 = out_data_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	deflateEnd (&stream);
	return result;
}

static guint8*
book_saver_compress_jpeg (GdkPixbuf* image,
                          gint quality,
                          gint dpi,
                          gint* result_length1,
                          GError** error)
{
	guint8* jpeg_data = NULL;
	gint jpeg_data_length1 = 0;
	gint _jpeg_data_size_ = 0;
	gchar** keys = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint keys_length1;
	gint _keys_size_;
	gchar** values = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint values_length1;
	gint _values_size_;
	guint8* _tmp8_ = NULL;
	gsize _tmp9_ = 0;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (image != NULL, NULL);
	_tmp0_ = g_strdup ("quality");
	_tmp1_ = g_strdup ("x-dpi");
	_tmp2_ = g_strdup ("y-dpi");
	_tmp3_ = g_new0 (gchar*, 4 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	_tmp3_[3] = NULL;
	keys = _tmp3_;
	keys_length1 = 4;
	_keys_size_ = keys_length1;
	_tmp4_ = g_strdup_printf ("%d", quality);
	_tmp5_ = g_strdup_printf ("%d", dpi);
	_tmp6_ = g_strdup_printf ("%d", dpi);
	_tmp7_ = g_new0 (gchar*, 4 + 1);
	_tmp7_[0] = _tmp4_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	_tmp7_[3] = NULL;
	values = _tmp7_;
	values_length1 = 4;
	_values_size_ = values_length1;
	gdk_pixbuf_save_to_bufferv (image, &_tmp8_, &_tmp9_, "jpeg", keys, values, &_inner_error0_);
	jpeg_data = (g_free (jpeg_data), NULL);
	jpeg_data = _tmp8_;
	jpeg_data_length1 = _tmp9_;
	_jpeg_data_size_ = jpeg_data_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		jpeg_data = (g_free (jpeg_data), NULL);
		return NULL;
	}
	_tmp10_ = jpeg_data;
	_tmp10__length1 = jpeg_data_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

BookSaver*
book_saver_construct (GType object_type)
{
	BookSaver* self = NULL;
	self = (BookSaver*) g_type_create_instance (object_type);
	return self;
}

BookSaver*
book_saver_new (void)
{
	return book_saver_construct (TYPE_BOOK_SAVER);
}

static void
value_book_saver_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_book_saver_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		book_saver_unref (value->data[0].v_pointer);
	}
}

static void
value_book_saver_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = book_saver_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_book_saver_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_book_saver_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BookSaver * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = book_saver_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_book_saver_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	BookSaver ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = book_saver_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_book_saver (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecBookSaver* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK_SAVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_book_saver (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK_SAVER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_book_saver (GValue* value,
                      gpointer v_object)
{
	BookSaver * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK_SAVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK_SAVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		book_saver_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_saver_unref (old);
	}
}

void
value_take_book_saver (GValue* value,
                       gpointer v_object)
{
	BookSaver * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK_SAVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK_SAVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_saver_unref (old);
	}
}

static void
book_saver_class_init (BookSaverClass * klass,
                       gpointer klass_data)
{
	book_saver_parent_class = g_type_class_peek_parent (klass);
	((BookSaverClass *) klass)->finalize = book_saver_finalize;
	g_type_class_adjust_private_offset (klass, &BookSaver_private_offset);
}

static void
book_saver_instance_init (BookSaver * self,
                          gpointer klass)
{
	Postprocessor* _tmp0_;
	self->priv = book_saver_get_instance_private (self);
	_tmp0_ = postprocessor_new ();
	self->priv->postprocessor = _tmp0_;
	self->ref_count = 1;
}

static void
book_saver_finalize (BookSaver * obj)
{
	BookSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK_SAVER, BookSaver);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_vala_clear_GMutex (&self->priv->progression_mutex);
	_g_object_unref0 (self->priv->cancellable);
	_g_async_queue_unref0 (self->priv->write_queue);
	_g_thread_pool_free0 (self->priv->encoder);
	(self->priv->save_async_callback_target_destroy_notify == NULL) ? NULL : (self->priv->save_async_callback_target_destroy_notify (self->priv->save_async_callback_target), NULL);
	self->priv->save_async_callback = NULL;
	self->priv->save_async_callback_target = NULL;
	self->priv->save_async_callback_target_destroy_notify = NULL;
	_postprocessor_unref0 (self->priv->postprocessor);
}

static GType
book_saver_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_book_saver_init, value_book_saver_free_value, value_book_saver_copy_value, value_book_saver_peek_pointer, "p", value_book_saver_collect_value, "p", value_book_saver_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookSaver), 0, (GInstanceInitFunc) book_saver_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType book_saver_type_id;
	book_saver_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookSaver", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BookSaver_private_offset = g_type_add_instance_private (book_saver_type_id, sizeof (BookSaverPrivate));
	return book_saver_type_id;
}

GType
book_saver_get_type (void)
{
	static volatile gsize book_saver_type_id__once = 0;
	if (g_once_init_enter (&book_saver_type_id__once)) {
		GType book_saver_type_id;
		book_saver_type_id = book_saver_get_type_once ();
		g_once_init_leave (&book_saver_type_id__once, book_saver_type_id);
	}
	return book_saver_type_id__once;
}

gpointer
book_saver_ref (gpointer instance)
{
	BookSaver * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
book_saver_unref (gpointer instance)
{
	BookSaver * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOOK_SAVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

EncodeTask*
encode_task_construct (GType object_type)
{
	EncodeTask* self = NULL;
	self = (EncodeTask*) g_type_create_instance (object_type);
	return self;
}

EncodeTask*
encode_task_new (void)
{
	return encode_task_construct (TYPE_ENCODE_TASK);
}

static void
value_encode_task_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_encode_task_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		encode_task_unref (value->data[0].v_pointer);
	}
}

static void
value_encode_task_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = encode_task_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_encode_task_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_encode_task_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		EncodeTask * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = encode_task_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_encode_task_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	EncodeTask ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = encode_task_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_encode_task (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecEncodeTask* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCODE_TASK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_encode_task (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCODE_TASK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_encode_task (GValue* value,
                       gpointer v_object)
{
	EncodeTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCODE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCODE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		encode_task_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		encode_task_unref (old);
	}
}

void
value_take_encode_task (GValue* value,
                        gpointer v_object)
{
	EncodeTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCODE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCODE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		encode_task_unref (old);
	}
}

static void
encode_task_class_init (EncodeTaskClass * klass,
                        gpointer klass_data)
{
	encode_task_parent_class = g_type_class_peek_parent (klass);
	((EncodeTaskClass *) klass)->finalize = encode_task_finalize;
}

static void
encode_task_instance_init (EncodeTask * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
encode_task_finalize (EncodeTask * obj)
{
	EncodeTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCODE_TASK, EncodeTask);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->page);
}

static GType
encode_task_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_encode_task_init, value_encode_task_free_value, value_encode_task_copy_value, value_encode_task_peek_pointer, "p", value_encode_task_collect_value, "p", value_encode_task_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EncodeTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) encode_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EncodeTask), 0, (GInstanceInitFunc) encode_task_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType encode_task_type_id;
	encode_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EncodeTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return encode_task_type_id;
}

GType
encode_task_get_type (void)
{
	static volatile gsize encode_task_type_id__once = 0;
	if (g_once_init_enter (&encode_task_type_id__once)) {
		GType encode_task_type_id;
		encode_task_type_id = encode_task_get_type_once ();
		g_once_init_leave (&encode_task_type_id__once, encode_task_type_id);
	}
	return encode_task_type_id__once;
}

gpointer
encode_task_ref (gpointer instance)
{
	EncodeTask * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
encode_task_unref (gpointer instance)
{
	EncodeTask * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ENCODE_TASK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

WriteTask*
write_task_construct (GType object_type)
{
	WriteTask* self = NULL;
	self = (WriteTask*) g_type_create_instance (object_type);
	return self;
}

WriteTask*
write_task_new (void)
{
	return write_task_construct (TYPE_WRITE_TASK);
}

static void
value_write_task_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_write_task_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		write_task_unref (value->data[0].v_pointer);
	}
}

static void
value_write_task_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = write_task_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_write_task_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_write_task_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		WriteTask * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = write_task_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_write_task_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	WriteTask ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = write_task_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_write_task (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecWriteTask* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_WRITE_TASK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_write_task (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WRITE_TASK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_write_task (GValue* value,
                      gpointer v_object)
{
	WriteTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WRITE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WRITE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		write_task_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		write_task_unref (old);
	}
}

void
value_take_write_task (GValue* value,
                       gpointer v_object)
{
	WriteTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WRITE_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WRITE_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		write_task_unref (old);
	}
}

static void
write_task_class_init (WriteTaskClass * klass,
                       gpointer klass_data)
{
	write_task_parent_class = g_type_class_peek_parent (klass);
	((WriteTaskClass *) klass)->finalize = write_task_finalize;
}

static void
write_task_instance_init (WriteTask * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
write_task_finalize (WriteTask * obj)
{
	WriteTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WRITE_TASK, WriteTask);
	g_signal_handlers_destroy (self);
	self->data = (g_free (self->data), NULL);
	_g_error_free0 (self->error);
}

static GType
write_task_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_write_task_init, value_write_task_free_value, value_write_task_copy_value, value_write_task_peek_pointer, "p", value_write_task_collect_value, "p", value_write_task_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (WriteTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) write_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WriteTask), 0, (GInstanceInitFunc) write_task_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType write_task_type_id;
	write_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "WriteTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return write_task_type_id;
}

GType
write_task_get_type (void)
{
	static volatile gsize write_task_type_id__once = 0;
	if (g_once_init_enter (&write_task_type_id__once)) {
		GType write_task_type_id;
		write_task_type_id = write_task_get_type_once ();
		g_once_init_leave (&write_task_type_id__once, write_task_type_id);
	}
	return write_task_type_id__once;
}

gpointer
write_task_ref (gpointer instance)
{
	WriteTask * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
write_task_unref (gpointer instance)
{
	WriteTask * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		WRITE_TASK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

WriteTaskPDF*
write_task_pdf_construct (GType object_type)
{
	WriteTaskPDF* self = NULL;
	self = (WriteTaskPDF*) write_task_construct (object_type);
	return self;
}

WriteTaskPDF*
write_task_pdf_new (void)
{
	return write_task_pdf_construct (TYPE_WRITE_TASK_PDF);
}

static void
write_task_pdf_class_init (WriteTaskPDFClass * klass,
                           gpointer klass_data)
{
	write_task_pdf_parent_class = g_type_class_peek_parent (klass);
	((WriteTaskClass *) klass)->finalize = write_task_pdf_finalize;
}

static void
write_task_pdf_instance_init (WriteTaskPDF * self,
                              gpointer klass)
{
}

static void
write_task_pdf_finalize (WriteTask * obj)
{
	WriteTaskPDF * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WRITE_TASK_PDF, WriteTaskPDF);
	_g_free0 (self->color_space);
	_g_free0 (self->filter);
	WRITE_TASK_CLASS (write_task_pdf_parent_class)->finalize (obj);
}

static GType
write_task_pdf_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WriteTaskPDFClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) write_task_pdf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WriteTaskPDF), 0, (GInstanceInitFunc) write_task_pdf_instance_init, NULL };
	GType write_task_pdf_type_id;
	write_task_pdf_type_id = g_type_register_static (TYPE_WRITE_TASK, "WriteTaskPDF", &g_define_type_info, 0);
	return write_task_pdf_type_id;
}

GType
write_task_pdf_get_type (void)
{
	static volatile gsize write_task_pdf_type_id__once = 0;
	if (g_once_init_enter (&write_task_pdf_type_id__once)) {
		GType write_task_pdf_type_id;
		write_task_pdf_type_id = write_task_pdf_get_type_once ();
		g_once_init_leave (&write_task_pdf_type_id__once, write_task_pdf_type_id);
	}
	return write_task_pdf_type_id__once;
}

static inline gpointer
pdf_writer_get_instance_private (PDFWriter* self)
{
	return G_STRUCT_MEMBER_P (self, PDFWriter_private_offset);
}

PDFWriter*
pdf_writer_construct (GType object_type,
                      GFileOutputStream* stream)
{
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	guint* _tmp1_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PDFWriter*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp0_;
	_tmp1_ = g_new0 (guint, 0);
	self->object_offsets = (g_free (self->object_offsets), NULL);
	self->object_offsets = _tmp1_;
	self->object_offsets_length1 = 0;
	self->_object_offsets_size_ = self->object_offsets_length1;
	return self;
}

PDFWriter*
pdf_writer_new (GFileOutputStream* stream)
{
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
}

void
pdf_writer_write (PDFWriter* self,
                  guint8* data,
                  gint data_length1)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileOutputStream* _tmp0_;
		_tmp0_ = self->priv->stream;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, data, (gsize) data_length1, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("book.vala:962: Error writing PDF: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->offset = self->offset + data_length1;
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

void
pdf_writer_write_string (PDFWriter* self,
                         const gchar* text)
{
	gint _tmp0_ = 0;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = string_to_utf8 (text, &_tmp0_);
	_tmp2_ = (guint8*) _tmp1_;
	_tmp2__length1 = (_tmp0_ * sizeof (gchar)) / sizeof (guint8);
	pdf_writer_write (self, _tmp2_, (gint) ((_tmp0_ * sizeof (gchar)) / sizeof (guint8)));
	_tmp2_ = (g_free (_tmp2_), NULL);
}

guint
pdf_writer_add_object (PDFWriter* self)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint index = 0;
	guint* _tmp2_;
	gint _tmp2__length1;
	guint* _tmp3_;
	gint _tmp3__length1;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->object_offsets;
	_tmp0__length1 = self->object_offsets_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->object_offsets = g_renew (guint, self->object_offsets, _tmp0__length1 + 1);
	(_tmp1_ > self->object_offsets_length1) ? memset (self->object_offsets + self->object_offsets_length1, 0, sizeof (guint) * (_tmp1_ - self->object_offsets_length1)) : NULL;
	self->object_offsets_length1 = _tmp1_;
	self->_object_offsets_size_ = _tmp1_;
	_tmp2_ = self->object_offsets;
	_tmp2__length1 = self->object_offsets_length1;
	index = _tmp2__length1 - 1;
	_tmp3_ = self->object_offsets;
	_tmp3__length1 = self->object_offsets_length1;
	_tmp3_[index] = (guint) 0;
	result = (guint) (index + 1);
	return result;
}

void
pdf_writer_start_object (PDFWriter* self,
                         guint index)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->object_offsets;
	_tmp0__length1 = self->object_offsets_length1;
	_tmp0_[index - 1] = (guint) self->offset;
}

gint
pdf_writer_next_empty_object (PDFWriter* self,
                              gint start)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = start;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint* _tmp2_;
				gint _tmp2__length1;
				guint* _tmp3_;
				gint _tmp3__length1;
				guint _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->object_offsets;
				_tmp2__length1 = self->object_offsets_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->object_offsets;
				_tmp3__length1 = self->object_offsets_length1;
				_tmp4_ = _tmp3_[i];
				if (_tmp4_ == ((guint) 0)) {
					result = i + 1;
					return result;
				}
			}
		}
	}
	result = 0;
	return result;
}

static void
value_pdf_writer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_pdf_writer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pdf_writer_unref (value->data[0].v_pointer);
	}
}

static void
value_pdf_writer_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_pdf_writer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_pdf_writer_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PDFWriter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pdf_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_pdf_writer_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	PDFWriter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_pdf_writer (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecPDFWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_pdf_writer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_pdf_writer (GValue* value,
                      gpointer v_object)
{
	PDFWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pdf_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}

void
value_take_pdf_writer (GValue* value,
                       gpointer v_object)
{
	PDFWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}

static void
pdf_writer_class_init (PDFWriterClass * klass,
                       gpointer klass_data)
{
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
	((PDFWriterClass *) klass)->finalize = pdf_writer_finalize;
	g_type_class_adjust_private_offset (klass, &PDFWriter_private_offset);
}

static void
pdf_writer_instance_init (PDFWriter * self,
                          gpointer klass)
{
	self->priv = pdf_writer_get_instance_private (self);
	self->offset = (gsize) 0;
	self->ref_count = 1;
}

static void
pdf_writer_finalize (PDFWriter * obj)
{
	PDFWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
	g_signal_handlers_destroy (self);
	self->object_offsets = (g_free (self->object_offsets), NULL);
	_g_object_unref0 (self->priv->stream);
}

static GType
pdf_writer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pdf_writer_type_id;
	pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PDFWriter_private_offset = g_type_add_instance_private (pdf_writer_type_id, sizeof (PDFWriterPrivate));
	return pdf_writer_type_id;
}

GType
pdf_writer_get_type (void)
{
	static volatile gsize pdf_writer_type_id__once = 0;
	if (g_once_init_enter (&pdf_writer_type_id__once)) {
		GType pdf_writer_type_id;
		pdf_writer_type_id = pdf_writer_get_type_once ();
		g_once_init_leave (&pdf_writer_type_id__once, pdf_writer_type_id);
	}
	return pdf_writer_type_id__once;
}

gpointer
pdf_writer_ref (gpointer instance)
{
	PDFWriter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pdf_writer_unref (gpointer instance)
{
	PDFWriter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PDF_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

GFile*
make_indexed_file (const gchar* uri,
                   guint i,
                   guint n_pages)
{
	gchar* basename = NULL;
	gchar* _tmp1_;
	gchar* prefix = NULL;
	gchar* _tmp2_;
	gchar* suffix = NULL;
	gchar* _tmp3_;
	gint extension_index = 0;
	const gchar* _tmp4_;
	gint width = 0;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* number_format = NULL;
	gchar* _tmp21_;
	gchar* filename = NULL;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	GFile* _tmp34_;
	GFile* result;
	g_return_val_if_fail (uri != NULL, NULL);
	if (n_pages == ((guint) 1)) {
		GFile* _tmp0_;
		_tmp0_ = g_file_new_for_uri (uri);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_path_get_basename (uri);
	basename = _tmp1_;
	_tmp2_ = g_strdup (uri);
	prefix = _tmp2_;
	_tmp3_ = g_strdup ("");
	suffix = _tmp3_;
	_tmp4_ = basename;
	extension_index = string_last_index_of_char (_tmp4_, (gunichar) '.', 0);
	if (extension_index >= 0) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		_tmp5_ = basename;
		_tmp6_ = basename;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp5_, (glong) extension_index, (glong) _tmp8_);
		_g_free0 (suffix);
		suffix = _tmp9_;
		_tmp10_ = strlen (uri);
		_tmp11_ = _tmp10_;
		_tmp12_ = suffix;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_slice (uri, (glong) 0, (glong) (_tmp11_ - _tmp14_));
		_g_free0 (prefix);
		prefix = _tmp15_;
	}
	_tmp16_ = g_strdup_printf ("%u", n_pages);
	_tmp17_ = _tmp16_;
	_tmp18_ = strlen (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp17_);
	width = _tmp20_;
	_tmp21_ = g_strdup_printf ("%%0%dd", width);
	number_format = _tmp21_;
	_tmp22_ = prefix;
	_tmp23_ = g_strconcat (_tmp22_, "-", NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = number_format;
	_tmp26_ = g_strdup_printf (_tmp25_, i + 1);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = suffix;
	_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	filename = _tmp32_;
	_tmp33_ = filename;
	_tmp34_ = g_file_new_for_uri (_tmp33_);
	result = _tmp34_;
	_g_free0 (filename);
	_g_free0 (number_format);
	_g_free0 (suffix);
	_g_free0 (prefix);
	_g_free0 (basename);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

