/* CameraBranch.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CameraBranch.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gphoto2/gphoto2-camera.h>
#include <shotwell-gphoto-helper.h>

#define RESOURCES_ICON_CAMERAS "camera-photo-symbolic"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BRANCH (sidebar_branch_get_type ())
#define SIDEBAR_BRANCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BRANCH, SidebarBranch))
#define SIDEBAR_BRANCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BRANCH, SidebarBranchClass))
#define SIDEBAR_IS_BRANCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BRANCH))
#define SIDEBAR_IS_BRANCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BRANCH))
#define SIDEBAR_BRANCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BRANCH, SidebarBranchClass))

typedef struct _SidebarBranch SidebarBranch;
typedef struct _SidebarBranchClass SidebarBranchClass;
typedef struct _SidebarBranchPrivate SidebarBranchPrivate;

#define CAMERA_TYPE_BRANCH (camera_branch_get_type ())
#define CAMERA_BRANCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_TYPE_BRANCH, CameraBranch))
#define CAMERA_BRANCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_TYPE_BRANCH, CameraBranchClass))
#define CAMERA_IS_BRANCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_TYPE_BRANCH))
#define CAMERA_IS_BRANCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_TYPE_BRANCH))
#define CAMERA_BRANCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_TYPE_BRANCH, CameraBranchClass))

typedef struct _CameraBranch CameraBranch;
typedef struct _CameraBranchClass CameraBranchClass;
typedef struct _CameraBranchPrivate CameraBranchPrivate;

#define TYPE_DISCOVERED_CAMERA (discovered_camera_get_type ())
#define DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCamera))
#define DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))
#define IS_DISCOVERED_CAMERA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISCOVERED_CAMERA))
#define IS_DISCOVERED_CAMERA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISCOVERED_CAMERA))
#define DISCOVERED_CAMERA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISCOVERED_CAMERA, DiscoveredCameraClass))

typedef struct _DiscoveredCamera DiscoveredCamera;
typedef struct _DiscoveredCameraClass DiscoveredCameraClass;

#define SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY (sidebar_simple_page_entry_get_type ())
#define SIDEBAR_SIMPLE_PAGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, SidebarSimplePageEntry))
#define SIDEBAR_SIMPLE_PAGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, SidebarSimplePageEntryClass))
#define SIDEBAR_IS_SIMPLE_PAGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY))
#define SIDEBAR_IS_SIMPLE_PAGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY))
#define SIDEBAR_SIMPLE_PAGE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, SidebarSimplePageEntryClass))

typedef struct _SidebarSimplePageEntry SidebarSimplePageEntry;
typedef struct _SidebarSimplePageEntryClass SidebarSimplePageEntryClass;

#define CAMERA_TYPE_SIDEBAR_ENTRY (camera_sidebar_entry_get_type ())
#define CAMERA_SIDEBAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntry))
#define CAMERA_SIDEBAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntryClass))
#define CAMERA_IS_SIDEBAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_TYPE_SIDEBAR_ENTRY))
#define CAMERA_IS_SIDEBAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_TYPE_SIDEBAR_ENTRY))
#define CAMERA_SIDEBAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntryClass))

typedef struct _CameraSidebarEntry CameraSidebarEntry;
typedef struct _CameraSidebarEntryClass CameraSidebarEntryClass;
enum  {
	CAMERA_BRANCH_0_PROPERTY,
	CAMERA_BRANCH_NUM_PROPERTIES
};
static GParamSpec* camera_branch_properties[CAMERA_BRANCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SIDEBAR_TYPE_GROUPING (sidebar_grouping_get_type ())
#define SIDEBAR_GROUPING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_GROUPING, SidebarGrouping))
#define SIDEBAR_GROUPING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_GROUPING, SidebarGroupingClass))
#define SIDEBAR_IS_GROUPING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_GROUPING))
#define SIDEBAR_IS_GROUPING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_GROUPING))
#define SIDEBAR_GROUPING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_GROUPING, SidebarGroupingClass))

typedef struct _SidebarGrouping SidebarGrouping;
typedef struct _SidebarGroupingClass SidebarGroupingClass;

#define SIDEBAR_TYPE_HEADER (sidebar_header_get_type ())
#define SIDEBAR_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_HEADER, SidebarHeader))
#define SIDEBAR_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_HEADER, SidebarHeaderClass))
#define SIDEBAR_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_HEADER))
#define SIDEBAR_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_HEADER))
#define SIDEBAR_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_HEADER, SidebarHeaderClass))

typedef struct _SidebarHeader SidebarHeader;
typedef struct _SidebarHeaderClass SidebarHeaderClass;

#define CAMERA_TYPE_HEADER (camera_header_get_type ())
#define CAMERA_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_TYPE_HEADER, CameraHeader))
#define CAMERA_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_TYPE_HEADER, CameraHeaderClass))
#define CAMERA_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_TYPE_HEADER))
#define CAMERA_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_TYPE_HEADER))
#define CAMERA_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_TYPE_HEADER, CameraHeaderClass))

typedef struct _CameraHeader CameraHeader;
typedef struct _CameraHeaderClass CameraHeaderClass;

#define SIDEBAR_TYPE_ENTRY (sidebar_entry_get_type ())
#define SIDEBAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ENTRY, SidebarEntry))
#define SIDEBAR_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ENTRY))
#define SIDEBAR_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_ENTRY, SidebarEntryIface))

typedef struct _SidebarEntry SidebarEntry;
typedef struct _SidebarEntryIface SidebarEntryIface;

#define SIDEBAR_TYPE_TREE (sidebar_tree_get_type ())
#define SIDEBAR_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_TREE, SidebarTree))
#define SIDEBAR_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_TREE, SidebarTreeClass))
#define SIDEBAR_IS_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_TREE))
#define SIDEBAR_IS_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_TREE))
#define SIDEBAR_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_TREE, SidebarTreeClass))

typedef struct _SidebarTree SidebarTree;
typedef struct _SidebarTreeClass SidebarTreeClass;
typedef enum  {
	SIDEBAR_BRANCH_OPTIONS_NONE = 0,
	SIDEBAR_BRANCH_OPTIONS_HIDE_IF_EMPTY = 1 << 0,
	SIDEBAR_BRANCH_OPTIONS_AUTO_OPEN_ON_NEW_CHILD = 1 << 1,
	SIDEBAR_BRANCH_OPTIONS_STARTUP_EXPAND_TO_FIRST_CHILD = 1 << 2,
	SIDEBAR_BRANCH_OPTIONS_STARTUP_OPEN_GROUPING = 1 << 3
} SidebarBranchOptions;

#define SIDEBAR_BRANCH_TYPE_OPTIONS (sidebar_branch_options_get_type ())

#define TYPE_CAMERA_TABLE (camera_table_get_type ())
#define CAMERA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CAMERA_TABLE, CameraTable))
#define CAMERA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CAMERA_TABLE, CameraTableClass))
#define IS_CAMERA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CAMERA_TABLE))
#define IS_CAMERA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CAMERA_TABLE))
#define CAMERA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CAMERA_TABLE, CameraTableClass))

typedef struct _CameraTable CameraTable;
typedef struct _CameraTableClass CameraTableClass;
#define _camera_table_unref0(var) ((var == NULL) ? NULL : (var = (camera_table_unref (var), NULL)))
#define _discovered_camera_unref0(var) ((var == NULL) ? NULL : (var = (discovered_camera_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SIDEBAR_TYPE_EXPANDABLE_ENTRY (sidebar_expandable_entry_get_type ())
#define SIDEBAR_EXPANDABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_EXPANDABLE_ENTRY, SidebarExpandableEntry))
#define SIDEBAR_IS_EXPANDABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_EXPANDABLE_ENTRY))
#define SIDEBAR_EXPANDABLE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_EXPANDABLE_ENTRY, SidebarExpandableEntryIface))

typedef struct _SidebarExpandableEntry SidebarExpandableEntry;
typedef struct _SidebarExpandableEntryIface SidebarExpandableEntryIface;

#define SIDEBAR_TYPE_RENAMEABLE_ENTRY (sidebar_renameable_entry_get_type ())
#define SIDEBAR_RENAMEABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntry))
#define SIDEBAR_IS_RENAMEABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_RENAMEABLE_ENTRY))
#define SIDEBAR_RENAMEABLE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntryIface))

typedef struct _SidebarRenameableEntry SidebarRenameableEntry;
typedef struct _SidebarRenameableEntryIface SidebarRenameableEntryIface;
typedef struct _SidebarGroupingPrivate SidebarGroupingPrivate;

#define SIDEBAR_TYPE_EMPHASIZABLE_ENTRY (sidebar_emphasizable_entry_get_type ())
#define SIDEBAR_EMPHASIZABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_EMPHASIZABLE_ENTRY, SidebarEmphasizableEntry))
#define SIDEBAR_IS_EMPHASIZABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_EMPHASIZABLE_ENTRY))
#define SIDEBAR_EMPHASIZABLE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_EMPHASIZABLE_ENTRY, SidebarEmphasizableEntryIface))

typedef struct _SidebarEmphasizableEntry SidebarEmphasizableEntry;
typedef struct _SidebarEmphasizableEntryIface SidebarEmphasizableEntryIface;
typedef struct _SidebarHeaderPrivate SidebarHeaderPrivate;
typedef struct _CameraHeaderPrivate CameraHeaderPrivate;
enum  {
	CAMERA_HEADER_0_PROPERTY,
	CAMERA_HEADER_NUM_PROPERTIES
};
static GParamSpec* camera_header_properties[CAMERA_HEADER_NUM_PROPERTIES];

#define SIDEBAR_TYPE_SELECTABLE_ENTRY (sidebar_selectable_entry_get_type ())
#define SIDEBAR_SELECTABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_SELECTABLE_ENTRY, SidebarSelectableEntry))
#define SIDEBAR_IS_SELECTABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_SELECTABLE_ENTRY))
#define SIDEBAR_SELECTABLE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_SELECTABLE_ENTRY, SidebarSelectableEntryIface))

typedef struct _SidebarSelectableEntry SidebarSelectableEntry;
typedef struct _SidebarSelectableEntryIface SidebarSelectableEntryIface;

#define SIDEBAR_TYPE_PAGE_REPRESENTATIVE (sidebar_page_representative_get_type ())
#define SIDEBAR_PAGE_REPRESENTATIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_PAGE_REPRESENTATIVE, SidebarPageRepresentative))
#define SIDEBAR_IS_PAGE_REPRESENTATIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_PAGE_REPRESENTATIVE))
#define SIDEBAR_PAGE_REPRESENTATIVE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_PAGE_REPRESENTATIVE, SidebarPageRepresentativeIface))

typedef struct _SidebarPageRepresentative SidebarPageRepresentative;
typedef struct _SidebarPageRepresentativeIface SidebarPageRepresentativeIface;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define SIDEBAR_TYPE_CONTEXTABLE (sidebar_contextable_get_type ())
#define SIDEBAR_CONTEXTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_CONTEXTABLE, SidebarContextable))
#define SIDEBAR_IS_CONTEXTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_CONTEXTABLE))
#define SIDEBAR_CONTEXTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SIDEBAR_TYPE_CONTEXTABLE, SidebarContextableIface))

typedef struct _SidebarContextable SidebarContextable;
typedef struct _SidebarContextableIface SidebarContextableIface;
typedef struct _SidebarSimplePageEntryPrivate SidebarSimplePageEntryPrivate;
typedef struct _CameraSidebarEntryPrivate CameraSidebarEntryPrivate;
enum  {
	CAMERA_SIDEBAR_ENTRY_0_PROPERTY,
	CAMERA_SIDEBAR_ENTRY_NUM_PROPERTIES
};
static GParamSpec* camera_sidebar_entry_properties[CAMERA_SIDEBAR_ENTRY_NUM_PROPERTIES];
typedef struct _DiscoveredCameraPrivate DiscoveredCameraPrivate;

#define TYPE_CHECKERBOARD_PAGE (checkerboard_page_get_type ())
#define CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPage))
#define CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))
#define IS_CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_PAGE))
#define IS_CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_PAGE))
#define CHECKERBOARD_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))

typedef struct _CheckerboardPage CheckerboardPage;
typedef struct _CheckerboardPageClass CheckerboardPageClass;

#define TYPE_IMPORT_PAGE (import_page_get_type ())
#define IMPORT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_PAGE, ImportPage))
#define IMPORT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_PAGE, ImportPageClass))
#define IS_IMPORT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_PAGE))
#define IS_IMPORT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_PAGE))
#define IMPORT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_PAGE, ImportPageClass))

typedef struct _ImportPage ImportPage;
typedef struct _ImportPageClass ImportPageClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SidebarBranch {
	GObject parent_instance;
	SidebarBranchPrivate * priv;
};

struct _SidebarBranchClass {
	GObjectClass parent_class;
};

struct _CameraBranch {
	SidebarBranch parent_instance;
	CameraBranchPrivate * priv;
};

struct _CameraBranchClass {
	SidebarBranchClass parent_class;
};

struct _CameraBranchPrivate {
	GeeHashMap* camera_map;
};

struct _SidebarEntryIface {
	GTypeInterface parent_iface;
	gchar* (*get_sidebar_name) (SidebarEntry* self);
	gchar* (*get_sidebar_tooltip) (SidebarEntry* self);
	gchar* (*get_sidebar_icon) (SidebarEntry* self);
	gchar* (*to_string) (SidebarEntry* self);
	void (*grafted) (SidebarEntry* self, SidebarTree* tree);
	void (*pruned) (SidebarEntry* self, SidebarTree* tree);
};

struct _SidebarExpandableEntryIface {
	GTypeInterface parent_iface;
	gboolean (*expand_on_select) (SidebarExpandableEntry* self);
};

struct _SidebarRenameableEntryIface {
	GTypeInterface parent_iface;
	void (*rename) (SidebarRenameableEntry* self, const gchar* new_name);
	gboolean (*is_user_renameable) (SidebarRenameableEntry* self);
};

struct _SidebarGrouping {
	GObject parent_instance;
	SidebarGroupingPrivate * priv;
};

struct _SidebarGroupingClass {
	GObjectClass parent_class;
};

struct _SidebarEmphasizableEntryIface {
	GTypeInterface parent_iface;
	gboolean (*is_emphasized) (SidebarEmphasizableEntry* self);
};

struct _SidebarHeader {
	SidebarGrouping parent_instance;
	SidebarHeaderPrivate * priv;
};

struct _SidebarHeaderClass {
	SidebarGroupingClass parent_class;
};

struct _CameraHeader {
	SidebarHeader parent_instance;
	CameraHeaderPrivate * priv;
};

struct _CameraHeaderClass {
	SidebarHeaderClass parent_class;
};

struct _SidebarSelectableEntryIface {
	GTypeInterface parent_iface;
};

struct _SidebarPageRepresentativeIface {
	GTypeInterface parent_iface;
	gboolean (*has_page) (SidebarPageRepresentative* self);
	Page* (*get_page) (SidebarPageRepresentative* self);
};

struct _SidebarContextableIface {
	GTypeInterface parent_iface;
	GtkMenu* (*get_sidebar_context_menu) (SidebarContextable* self, GdkEventButton* event);
};

struct _SidebarSimplePageEntry {
	GObject parent_instance;
	SidebarSimplePageEntryPrivate * priv;
};

struct _SidebarSimplePageEntryClass {
	GObjectClass parent_class;
	gchar* (*get_sidebar_name) (SidebarSimplePageEntry* self);
	gchar* (*get_sidebar_tooltip) (SidebarSimplePageEntry* self);
	gchar* (*get_sidebar_icon) (SidebarSimplePageEntry* self);
	gchar* (*to_string) (SidebarSimplePageEntry* self);
	Page* (*create_page) (SidebarSimplePageEntry* self);
};

struct _CameraSidebarEntry {
	SidebarSimplePageEntry parent_instance;
	CameraSidebarEntryPrivate * priv;
};

struct _CameraSidebarEntryClass {
	SidebarSimplePageEntryClass parent_class;
};

struct _CameraSidebarEntryPrivate {
	DiscoveredCamera* camera;
	gchar* uri;
};

struct _DiscoveredCamera {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DiscoveredCameraPrivate * priv;
	Camera* gcamera;
	gchar* uri;
	gchar* display_name;
	gchar* icon;
};

struct _DiscoveredCameraClass {
	GTypeClass parent_class;
	void (*finalize) (DiscoveredCamera *self);
};

static gint CameraBranch_private_offset;
static gpointer camera_branch_parent_class = NULL;
VALA_EXTERN gchar* camera_branch_cameras_icon;
gchar* camera_branch_cameras_icon = NULL;
static gpointer camera_header_parent_class = NULL;
static gint CameraSidebarEntry_private_offset;
static gpointer camera_sidebar_entry_parent_class = NULL;

VALA_EXTERN GType sidebar_branch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBranch, g_object_unref)
VALA_EXTERN GType camera_branch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraBranch, g_object_unref)
VALA_EXTERN gpointer discovered_camera_ref (gpointer instance);
VALA_EXTERN void discovered_camera_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_discovered_camera (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_discovered_camera (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_discovered_camera (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_discovered_camera (const GValue* value);
VALA_EXTERN GType discovered_camera_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DiscoveredCamera, discovered_camera_unref)
VALA_EXTERN GType sidebar_simple_page_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarSimplePageEntry, g_object_unref)
VALA_EXTERN GType camera_sidebar_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraSidebarEntry, g_object_unref)
VALA_EXTERN CameraBranch* camera_branch_new (void);
VALA_EXTERN CameraBranch* camera_branch_construct (GType object_type);
VALA_EXTERN CameraHeader* camera_header_new (void);
VALA_EXTERN CameraHeader* camera_header_construct (GType object_type);
VALA_EXTERN GType sidebar_grouping_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarGrouping, g_object_unref)
VALA_EXTERN GType sidebar_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarHeader, g_object_unref)
VALA_EXTERN GType camera_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraHeader, g_object_unref)
VALA_EXTERN GType sidebar_tree_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarTree, g_object_unref)
VALA_EXTERN GType sidebar_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarEntry, g_object_unref)
VALA_EXTERN GType sidebar_branch_options_get_type (void) G_GNUC_CONST ;
static gint camera_branch_camera_comparator (SidebarEntry* a,
                                      SidebarEntry* b);
static gint _camera_branch_camera_comparator_gcompare_func (gconstpointer a,
                                                     gconstpointer b);
VALA_EXTERN SidebarBranch* sidebar_branch_new (SidebarEntry* root,
                                   SidebarBranchOptions options,
                                   GCompareFunc default_comparator,
                                   GCompareFunc root_comparator);
VALA_EXTERN SidebarBranch* sidebar_branch_construct (GType object_type,
                                         SidebarEntry* root,
                                         SidebarBranchOptions options,
                                         GCompareFunc default_comparator,
                                         GCompareFunc root_comparator);
VALA_EXTERN gpointer camera_table_ref (gpointer instance);
VALA_EXTERN void camera_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_camera_table (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_camera_table (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_camera_table (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_camera_table (const GValue* value);
VALA_EXTERN GType camera_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraTable, camera_table_unref)
VALA_EXTERN CameraTable* camera_table_get_instance (void);
VALA_EXTERN GeeIterable* camera_table_get_cameras (CameraTable* self);
static void camera_branch_add_camera (CameraBranch* self,
                               DiscoveredCamera* camera);
static void camera_branch_on_camera_added (CameraBranch* self,
                                    DiscoveredCamera* camera);
static void _camera_branch_on_camera_added_camera_table_camera_added (CameraTable* _sender,
                                                               DiscoveredCamera* camera,
                                                               gpointer self);
static void camera_branch_on_camera_removed (CameraBranch* self,
                                      DiscoveredCamera* camera);
static void _camera_branch_on_camera_removed_camera_table_camera_removed (CameraTable* _sender,
                                                                   DiscoveredCamera* camera,
                                                                   gpointer self);
VALA_EXTERN void camera_branch_init (void);
VALA_EXTERN void camera_branch_terminate (void);
VALA_EXTERN gchar* sidebar_entry_get_sidebar_name (SidebarEntry* self);
VALA_EXTERN gchar* camera_sidebar_entry_get_uri (CameraSidebarEntry* self);
VALA_EXTERN CameraSidebarEntry* camera_branch_get_entry_for_camera (CameraBranch* self,
                                                        DiscoveredCamera* camera);
static void camera_branch_remove_camera (CameraBranch* self,
                                  DiscoveredCamera* camera);
VALA_EXTERN CameraSidebarEntry* camera_sidebar_entry_new (DiscoveredCamera* camera);
VALA_EXTERN CameraSidebarEntry* camera_sidebar_entry_construct (GType object_type,
                                                    DiscoveredCamera* camera);
VALA_EXTERN void sidebar_branch_graft (SidebarBranch* self,
                           SidebarEntry* parent,
                           SidebarEntry* entry,
                           GCompareFunc comparator);
VALA_EXTERN SidebarEntry* sidebar_branch_get_root (SidebarBranch* self);
VALA_EXTERN void sidebar_branch_prune (SidebarBranch* self,
                           SidebarEntry* entry);
static void camera_branch_finalize (GObject * obj);
static GType camera_branch_get_type_once (void);
VALA_EXTERN GType sidebar_expandable_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType sidebar_renameable_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType sidebar_emphasizable_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SidebarHeader* sidebar_header_new (const gchar* name,
                                   const gchar* tooltip,
                                   gboolean emphasized);
VALA_EXTERN SidebarHeader* sidebar_header_construct (GType object_type,
                                         const gchar* name,
                                         const gchar* tooltip,
                                         gboolean emphasized);
static GType camera_header_get_type_once (void);
VALA_EXTERN GType sidebar_selectable_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType sidebar_page_representative_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType sidebar_contextable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarContextable, g_object_unref)
VALA_EXTERN gchar* sidebar_simple_page_entry_get_sidebar_name (SidebarSimplePageEntry* self);
VALA_EXTERN gchar* sidebar_simple_page_entry_get_sidebar_icon (SidebarSimplePageEntry* self);
VALA_EXTERN Page* sidebar_simple_page_entry_create_page (SidebarSimplePageEntry* self);
VALA_EXTERN SidebarSimplePageEntry* sidebar_simple_page_entry_construct (GType object_type);
static gchar* camera_sidebar_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static gchar* camera_sidebar_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static Page* camera_sidebar_entry_real_create_page (SidebarSimplePageEntry* base);
VALA_EXTERN ImportPage* import_page_new (DiscoveredCamera* dcamera);
VALA_EXTERN ImportPage* import_page_construct (GType object_type,
                                   DiscoveredCamera* dcamera);
VALA_EXTERN GType checkerboard_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardPage, g_object_unref)
VALA_EXTERN GType import_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImportPage, g_object_unref)
static void camera_sidebar_entry_finalize (GObject * obj);
static GType camera_sidebar_entry_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
camera_branch_get_instance_private (CameraBranch* self)
{
	return G_STRUCT_MEMBER_P (self, CameraBranch_private_offset);
}

static gint
_camera_branch_camera_comparator_gcompare_func (gconstpointer a,
                                                gconstpointer b)
{
	gint result;
	result = camera_branch_camera_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static void
_camera_branch_on_camera_added_camera_table_camera_added (CameraTable* _sender,
                                                          DiscoveredCamera* camera,
                                                          gpointer self)
{
	camera_branch_on_camera_added ((CameraBranch*) self, camera);
}

static void
_camera_branch_on_camera_removed_camera_table_camera_removed (CameraTable* _sender,
                                                              DiscoveredCamera* camera,
                                                              gpointer self)
{
	camera_branch_on_camera_removed ((CameraBranch*) self, camera);
}

CameraBranch*
camera_branch_construct (GType object_type)
{
	CameraBranch * self = NULL;
	CameraHeader* _tmp0_;
	CameraHeader* _tmp1_;
	CameraTable* _tmp12_;
	CameraTable* _tmp13_;
	CameraTable* _tmp14_;
	CameraTable* _tmp15_;
	_tmp0_ = camera_header_new ();
	_tmp1_ = _tmp0_;
	self = (CameraBranch*) sidebar_branch_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SIDEBAR_TYPE_ENTRY, SidebarEntry), SIDEBAR_BRANCH_OPTIONS_HIDE_IF_EMPTY | SIDEBAR_BRANCH_OPTIONS_AUTO_OPEN_ON_NEW_CHILD, _camera_branch_camera_comparator_gcompare_func, NULL);
	_g_object_unref0 (_tmp1_);
	{
		GeeIterator* _camera_it = NULL;
		CameraTable* _tmp2_;
		CameraTable* _tmp3_;
		GeeIterable* _tmp4_;
		GeeIterable* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = camera_table_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = camera_table_get_cameras (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_camera_table_unref0 (_tmp3_);
		_camera_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			DiscoveredCamera* camera = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			DiscoveredCamera* _tmp11_;
			_tmp8_ = _camera_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _camera_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			camera = (DiscoveredCamera*) _tmp10_;
			_tmp11_ = camera;
			camera_branch_add_camera (self, _tmp11_);
			_discovered_camera_unref0 (camera);
		}
		_g_object_unref0 (_camera_it);
	}
	_tmp12_ = camera_table_get_instance ();
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "camera-added", (GCallback) _camera_branch_on_camera_added_camera_table_camera_added, self, 0);
	_camera_table_unref0 (_tmp13_);
	_tmp14_ = camera_table_get_instance ();
	_tmp15_ = _tmp14_;
	g_signal_connect_object (_tmp15_, "camera-removed", (GCallback) _camera_branch_on_camera_removed_camera_table_camera_removed, self, 0);
	_camera_table_unref0 (_tmp15_);
	return self;
}

CameraBranch*
camera_branch_new (void)
{
	return camera_branch_construct (CAMERA_TYPE_BRANCH);
}

void
camera_branch_init (void)
{
}

void
camera_branch_terminate (void)
{
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
camera_branch_camera_comparator (SidebarEntry* a,
                                 SidebarEntry* b)
{
	gint ret = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (a), 0);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (b), 0);
	if (a == b) {
		result = 0;
		return result;
	}
	_tmp0_ = sidebar_entry_get_sidebar_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_entry_get_sidebar_name (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	ret = _tmp4_;
	if (ret == 0) {
		CameraSidebarEntry* cam_a = NULL;
		CameraSidebarEntry* _tmp5_;
		CameraSidebarEntry* cam_b = NULL;
		CameraSidebarEntry* _tmp6_;
		gboolean _tmp7_ = FALSE;
		CameraSidebarEntry* _tmp8_;
		CameraSidebarEntry* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		CameraSidebarEntry* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp5_ = _g_object_ref0 (CAMERA_IS_SIDEBAR_ENTRY (a) ? ((CameraSidebarEntry*) a) : NULL);
		cam_a = _tmp5_;
		_tmp6_ = _g_object_ref0 (CAMERA_IS_SIDEBAR_ENTRY (b) ? ((CameraSidebarEntry*) b) : NULL);
		cam_b = _tmp6_;
		_tmp8_ = cam_a;
		if (_tmp8_ != NULL) {
			CameraSidebarEntry* _tmp9_;
			_tmp9_ = cam_b;
			_tmp7_ = _tmp9_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		_vala_assert (_tmp7_, "cam_a != null && cam_b != null");
		_tmp10_ = cam_a;
		_tmp11_ = camera_sidebar_entry_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = cam_b;
		_tmp14_ = camera_sidebar_entry_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		ret = g_utf8_collate (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (cam_b);
		_g_object_unref0 (cam_a);
	}
	result = ret;
	return result;
}

CameraSidebarEntry*
camera_branch_get_entry_for_camera (CameraBranch* self,
                                    DiscoveredCamera* camera)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	CameraSidebarEntry* result;
	g_return_val_if_fail (CAMERA_IS_BRANCH (self), NULL);
	g_return_val_if_fail (IS_DISCOVERED_CAMERA (camera), NULL);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), camera);
	result = (CameraSidebarEntry*) _tmp1_;
	return result;
}

static void
camera_branch_on_camera_added (CameraBranch* self,
                               DiscoveredCamera* camera)
{
	g_return_if_fail (CAMERA_IS_BRANCH (self));
	g_return_if_fail (IS_DISCOVERED_CAMERA (camera));
	camera_branch_add_camera (self, camera);
}

static void
camera_branch_on_camera_removed (CameraBranch* self,
                                 DiscoveredCamera* camera)
{
	g_return_if_fail (CAMERA_IS_BRANCH (self));
	g_return_if_fail (IS_DISCOVERED_CAMERA (camera));
	camera_branch_remove_camera (self, camera);
}

static void
camera_branch_add_camera (CameraBranch* self,
                          DiscoveredCamera* camera)
{
	GeeHashMap* _tmp0_;
	CameraSidebarEntry* entry = NULL;
	CameraSidebarEntry* _tmp1_;
	GeeHashMap* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarEntry* _tmp4_;
	g_return_if_fail (CAMERA_IS_BRANCH (self));
	g_return_if_fail (IS_DISCOVERED_CAMERA (camera));
	_tmp0_ = self->priv->camera_map;
	_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), camera), "!camera_map.has_key(camera)");
	_tmp1_ = camera_sidebar_entry_new (camera);
	entry = _tmp1_;
	_tmp2_ = self->priv->camera_map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), camera, entry);
	_tmp3_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	_tmp4_ = _tmp3_;
	sidebar_branch_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (entry, SIDEBAR_TYPE_ENTRY, SidebarEntry), NULL);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (entry);
}

static void
camera_branch_remove_camera (CameraBranch* self,
                             DiscoveredCamera* camera)
{
	GeeHashMap* _tmp0_;
	CameraSidebarEntry* entry = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp3_;
	g_return_if_fail (CAMERA_IS_BRANCH (self));
	g_return_if_fail (IS_DISCOVERED_CAMERA (camera));
	_tmp0_ = self->priv->camera_map;
	_vala_assert (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), camera), "camera_map.has_key(camera)");
	_tmp1_ = self->priv->camera_map;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), camera);
	entry = (CameraSidebarEntry*) _tmp2_;
	_vala_assert (entry != NULL, "entry != null");
	_tmp3_ = self->priv->camera_map;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), camera, NULL);
	_vala_assert (removed, "removed");
	sidebar_branch_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_TYPE_CHECK_INSTANCE_CAST (entry, SIDEBAR_TYPE_ENTRY, SidebarEntry));
	_g_object_unref0 (entry);
}

static void
camera_branch_class_init (CameraBranchClass * klass,
                          gpointer klass_data)
{
	gchar* _tmp0_;
	camera_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CameraBranch_private_offset);
	G_OBJECT_CLASS (klass)->finalize = camera_branch_finalize;
	_tmp0_ = g_strdup (RESOURCES_ICON_CAMERAS);
	camera_branch_cameras_icon = _tmp0_;
}

static void
camera_branch_instance_init (CameraBranch * self,
                             gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = camera_branch_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_DISCOVERED_CAMERA, (GBoxedCopyFunc) discovered_camera_ref, (GDestroyNotify) discovered_camera_unref, CAMERA_TYPE_SIDEBAR_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->camera_map = _tmp0_;
}

static void
camera_branch_finalize (GObject * obj)
{
	CameraBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAMERA_TYPE_BRANCH, CameraBranch);
	_g_object_unref0 (self->priv->camera_map);
	G_OBJECT_CLASS (camera_branch_parent_class)->finalize (obj);
}

static GType
camera_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraBranch), 0, (GInstanceInitFunc) camera_branch_instance_init, NULL };
	GType camera_branch_type_id;
	camera_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "CameraBranch", &g_define_type_info, 0);
	CameraBranch_private_offset = g_type_add_instance_private (camera_branch_type_id, sizeof (CameraBranchPrivate));
	return camera_branch_type_id;
}

GType
camera_branch_get_type (void)
{
	static volatile gsize camera_branch_type_id__once = 0;
	if (g_once_init_enter (&camera_branch_type_id__once)) {
		GType camera_branch_type_id;
		camera_branch_type_id = camera_branch_get_type_once ();
		g_once_init_leave (&camera_branch_type_id__once, camera_branch_type_id);
	}
	return camera_branch_type_id__once;
}

CameraHeader*
camera_header_construct (GType object_type)
{
	CameraHeader * self = NULL;
	self = (CameraHeader*) sidebar_header_construct (object_type, _ ("Cameras"), _ ("List of all discovered camera devices"), TRUE);
	return self;
}

CameraHeader*
camera_header_new (void)
{
	return camera_header_construct (CAMERA_TYPE_HEADER);
}

static void
camera_header_class_init (CameraHeaderClass * klass,
                          gpointer klass_data)
{
	camera_header_parent_class = g_type_class_peek_parent (klass);
}

static void
camera_header_instance_init (CameraHeader * self,
                             gpointer klass)
{
}

static GType
camera_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraHeader), 0, (GInstanceInitFunc) camera_header_instance_init, NULL };
	GType camera_header_type_id;
	camera_header_type_id = g_type_register_static (SIDEBAR_TYPE_HEADER, "CameraHeader", &g_define_type_info, 0);
	return camera_header_type_id;
}

GType
camera_header_get_type (void)
{
	static volatile gsize camera_header_type_id__once = 0;
	if (g_once_init_enter (&camera_header_type_id__once)) {
		GType camera_header_type_id;
		camera_header_type_id = camera_header_get_type_once ();
		g_once_init_leave (&camera_header_type_id__once, camera_header_type_id);
	}
	return camera_header_type_id__once;
}

static inline gpointer
camera_sidebar_entry_get_instance_private (CameraSidebarEntry* self)
{
	return G_STRUCT_MEMBER_P (self, CameraSidebarEntry_private_offset);
}

static gpointer
_discovered_camera_ref0 (gpointer self)
{
	return self ? discovered_camera_ref (self) : NULL;
}

CameraSidebarEntry*
camera_sidebar_entry_construct (GType object_type,
                                DiscoveredCamera* camera)
{
	CameraSidebarEntry * self = NULL;
	DiscoveredCamera* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (IS_DISCOVERED_CAMERA (camera), NULL);
	self = (CameraSidebarEntry*) sidebar_simple_page_entry_construct (object_type);
	_tmp0_ = _discovered_camera_ref0 (camera);
	_discovered_camera_unref0 (self->priv->camera);
	self->priv->camera = _tmp0_;
	_tmp1_ = camera->uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp2_;
	return self;
}

CameraSidebarEntry*
camera_sidebar_entry_new (DiscoveredCamera* camera)
{
	return camera_sidebar_entry_construct (CAMERA_TYPE_SIDEBAR_ENTRY, camera);
}

static gchar*
camera_sidebar_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	CameraSidebarEntry * self;
	const gchar* _tmp0_ = NULL;
	DiscoveredCamera* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntry);
	_tmp1_ = self->priv->camera;
	_tmp2_ = _tmp1_->display_name;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = _ ("Camera");
	}
	_tmp3_ = g_strdup (_tmp0_);
	result = _tmp3_;
	return result;
}

static gchar*
camera_sidebar_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	CameraSidebarEntry * self;
	const gchar* _tmp0_ = NULL;
	DiscoveredCamera* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntry);
	_tmp1_ = self->priv->camera;
	_tmp2_ = _tmp1_->icon;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = camera_branch_cameras_icon;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	result = _tmp4_;
	return result;
}

static Page*
camera_sidebar_entry_real_create_page (SidebarSimplePageEntry* base)
{
	CameraSidebarEntry * self;
	DiscoveredCamera* _tmp0_;
	ImportPage* _tmp1_;
	Page* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntry);
	_tmp0_ = self->priv->camera;
	_tmp1_ = import_page_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PAGE, Page);
	return result;
}

gchar*
camera_sidebar_entry_get_uri (CameraSidebarEntry* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (CAMERA_IS_SIDEBAR_ENTRY (self), NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
camera_sidebar_entry_class_init (CameraSidebarEntryClass * klass,
                                 gpointer klass_data)
{
	camera_sidebar_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CameraSidebarEntry_private_offset);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) camera_sidebar_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (gchar* (*) (SidebarSimplePageEntry*)) camera_sidebar_entry_real_get_sidebar_icon;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) camera_sidebar_entry_real_create_page;
	G_OBJECT_CLASS (klass)->finalize = camera_sidebar_entry_finalize;
}

static void
camera_sidebar_entry_instance_init (CameraSidebarEntry * self,
                                    gpointer klass)
{
	self->priv = camera_sidebar_entry_get_instance_private (self);
}

static void
camera_sidebar_entry_finalize (GObject * obj)
{
	CameraSidebarEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAMERA_TYPE_SIDEBAR_ENTRY, CameraSidebarEntry);
	_discovered_camera_unref0 (self->priv->camera);
	_g_free0 (self->priv->uri);
	G_OBJECT_CLASS (camera_sidebar_entry_parent_class)->finalize (obj);
}

static GType
camera_sidebar_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraSidebarEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_sidebar_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraSidebarEntry), 0, (GInstanceInitFunc) camera_sidebar_entry_instance_init, NULL };
	GType camera_sidebar_entry_type_id;
	camera_sidebar_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "CameraSidebarEntry", &g_define_type_info, 0);
	CameraSidebarEntry_private_offset = g_type_add_instance_private (camera_sidebar_entry_type_id, sizeof (CameraSidebarEntryPrivate));
	return camera_sidebar_entry_type_id;
}

GType
camera_sidebar_entry_get_type (void)
{
	static volatile gsize camera_sidebar_entry_type_id__once = 0;
	if (g_once_init_enter (&camera_sidebar_entry_type_id__once)) {
		GType camera_sidebar_entry_type_id;
		camera_sidebar_entry_type_id = camera_sidebar_entry_get_type_once ();
		g_once_init_leave (&camera_sidebar_entry_type_id__once, camera_sidebar_entry_type_id);
	}
	return camera_sidebar_entry_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

