#ifndef __SOURCE4_LIB_SOCKET_NETIF_PROTO_H__
#define __SOURCE4_LIB_SOCKET_NETIF_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/lib/socket/interface.c  */


/**
load the list of network interfaces
**/
void load_interface_list(TALLOC_CTX *mem_ctx, struct loadparm_context *lp_ctx, struct interface **local_interfaces);

/**
  how many interfaces do we have
  **/
int iface_list_count(struct interface *ifaces);

/**
  return IP of the Nth interface
  **/
const char *iface_list_n_ip(struct interface *ifaces, int n);

/**
  return the first IPv4 interface address we have registered
  **/
const char *iface_list_first_v4(struct interface *ifaces);

/**
   check if an interface is IPv4
  **/
bool iface_list_n_is_v4(struct interface *ifaces, int n);

/**
  return bcast of the Nth interface
  **/
const char *iface_list_n_bcast(struct interface *ifaces, int n);

/**
  return netmask of the Nth interface
  **/
const char *iface_list_n_netmask(struct interface *ifaces, int n);

/**
  return the local IP address that best matches a destination IP, or
  our first interface if none match
*/
const char *iface_list_best_ip(struct interface *ifaces, const char *dest);

/**
  return true if an IP is one one of our local networks
*/
bool iface_list_is_local(struct interface *ifaces, const char *dest);

/**
  return true if a IP matches a IP/netmask pair
*/
bool iface_list_same_net(const char *ip1, const char *ip2, const char *netmask);

/**
   return the list of wildcard interfaces
   this will include the IPv4 0.0.0.0, and may include IPv6 ::
*/
char **iface_list_wildcard(TALLOC_CTX *mem_ctx);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_LIB_SOCKET_NETIF_PROTO_H__ */

