/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_secrets
#define _PIDL_HEADER_secrets

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_secrets
#define _HEADER_secrets

struct TRUSTED_DOM_PASS {
	uint32_t uni_name_len;/* [value(strlen_m_term(uni_name))] */
	const char *uni_name;/* [charset(UTF16)] */
	uint32_t pass_len;/* [value(strlen(pass))] */
	const char * pass;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	time_t mod_time;
	struct dom_sid domain_sid;
}/* [flag(LIBNDR_FLAG_NOALIGN),public] */;

struct lsa_secret {
	DATA_BLOB *secret_current;/* [unique] */
	NTTIME secret_current_lastchange;
	DATA_BLOB *secret_old;/* [unique] */
	NTTIME secret_old_lastchange;
	struct security_descriptor *sd;/* [unique] */
}/* [public] */;

struct secrets_domain_info1_kerberos_key {
	uint32_t keytype;
	uint32_t iteration_count;
	DATA_BLOB value;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
};

struct secrets_domain_info1_password {
	NTTIME change_time;
	const char *change_server;/* [charset(UTF16)] */
	DATA_BLOB cleartext_blob;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
	struct samr_Password nt_hash;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
	const char *salt_data;/* [charset(UTF16),unique] */
	uint32_t default_iteration_count;
	uint16_t num_keys;
	struct secrets_domain_info1_kerberos_key *keys;
};

struct secrets_domain_info1_change {
	NTSTATUS local_status;
	NTSTATUS remote_status;
	NTTIME change_time;
	const char *change_server;/* [charset(UTF16)] */
	struct secrets_domain_info1_password *password;/* [ref] */
};

struct secrets_domain_info1 {
	uint64_t reserved_flags;/* [value(0)] */
	NTTIME join_time;
	const char *computer_name;/* [charset(UTF16)] */
	const char *account_name;/* [charset(UTF16)] */
	enum netr_SchannelType secure_channel_type;
	struct lsa_DnsDomainInfo domain_info;
	uint32_t trust_flags;
	enum lsa_TrustType trust_type;
	uint32_t trust_attributes;
	struct lsa_ForestTrustInformation *reserved_routing;/* [unique,value(NULL)] */
	uint32_t supported_enc_types;
	const char *salt_principal;/* [charset(UTF16),unique] */
	NTTIME password_last_change;
	uint64_t password_changes;
	struct secrets_domain_info1_change *next_change;/* [unique] */
	struct secrets_domain_info1_password *password;/* [ref] */
	struct secrets_domain_info1_password *old_password;/* [unique] */
	struct secrets_domain_info1_password *older_password;/* [unique] */
}/* [public] */;

enum secrets_domain_info_version
#ifndef USE_UINT_ENUMS
 {
	SECRETS_DOMAIN_INFO_VERSION_1=(int)(0x00000001)
}
#else
 { __do_not_use_enum_secrets_domain_info_version=INT_MAX}
#define SECRETS_DOMAIN_INFO_VERSION_1 ( 0x00000001 )
#endif
;

union secrets_domain_infoU {
	struct secrets_domain_info1 *info1;/* [case(SECRETS_DOMAIN_INFO_VERSION_1),unique] */
};

struct secrets_domain_infoB {
	enum secrets_domain_info_version version;
	uint32_t reserved;/* [value(0)] */
	union secrets_domain_infoU info;/* [switch_is(version)] */
}/* [public] */;

#endif /* _HEADER_secrets */
#endif /* _PIDL_HEADER_secrets */
