/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_samr.h"
#include "bin/default/librpc/gen_ndr/ndr_samr_c.h"

/* samr - client functions generated by pidl */

struct dcerpc_samr_Connect_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Connect *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect_r_done, req);

	return req;
}

static void dcerpc_samr_Connect_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Connect_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Connect_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Connect *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Connect_state {
	struct samr_Connect orig;
	struct samr_Connect tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    uint16_t *_system_name /* [in] [unique] */,
					    uint32_t _access_mask /* [in]  */,
					    struct policy_handle *_connect_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_Connect_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Connect_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect_done, req);
	return req;
}

static void dcerpc_samr_Connect_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Connect_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Connect_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.connect_handle = *state->tmp.out.connect_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct dcerpc_samr_Connect_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     uint16_t *_system_name /* [in] [unique] */,
			     uint32_t _access_mask /* [in]  */,
			     struct policy_handle *_connect_handle /* [out] [ref] */,
			     NTSTATUS *result)
{
	struct samr_Connect r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Connect_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_connect_handle = *r.out.connect_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_Close_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Close_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Close_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Close *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Close_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Close_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CLOSE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Close_r_done, req);

	return req;
}

static void dcerpc_samr_Close_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Close_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Close_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Close_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Close_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Close *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CLOSE, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Close_state {
	struct samr_Close orig;
	struct samr_Close tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Close_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Close_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Close_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Close_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_Close_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Close_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Close_done, req);
	return req;
}

static void dcerpc_samr_Close_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Close_state *state = tevent_req_data(
		req, struct dcerpc_samr_Close_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Close_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Close_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				NTSTATUS *result)
{
	struct dcerpc_samr_Close_state *state = tevent_req_data(
		req, struct dcerpc_samr_Close_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Close(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   struct policy_handle *_handle /* [in,out] [ref] */,
			   NTSTATUS *result)
{
	struct samr_Close r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Close_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETSECURITY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetSecurity_r_done, req);

	return req;
}

static void dcerpc_samr_SetSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetSecurity_state {
	struct samr_SetSecurity orig;
	struct samr_SetSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetSecurity_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _sec_info /* [in]  */,
						struct sec_desc_buf *_sdbuf /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;
	state->orig.in.sdbuf = _sdbuf;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetSecurity_done, req);
	return req;
}

static void dcerpc_samr_SetSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetSecurity_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetSecurity_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_samr_SetSecurity_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetSecurity(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t _sec_info /* [in]  */,
				 struct sec_desc_buf *_sdbuf /* [in] [ref] */,
				 NTSTATUS *result)
{
	struct samr_SetSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sec_info = _sec_info;
	r.in.sdbuf = _sdbuf;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QuerySecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QuerySecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QuerySecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QuerySecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QuerySecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QuerySecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QuerySecurity_r_done, req);

	return req;
}

static void dcerpc_samr_QuerySecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QuerySecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QuerySecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QuerySecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QuerySecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QuerySecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QuerySecurity_state {
	struct samr_QuerySecurity orig;
	struct samr_QuerySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QuerySecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QuerySecurity_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  uint32_t _sec_info /* [in]  */,
						  struct sec_desc_buf **_sdbuf /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QuerySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QuerySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;

	/* Out parameters */
	state->orig.out.sdbuf = _sdbuf;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QuerySecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QuerySecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QuerySecurity_done, req);
	return req;
}

static void dcerpc_samr_QuerySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QuerySecurity_state *state = tevent_req_data(
		req, struct dcerpc_samr_QuerySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QuerySecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sdbuf = *state->tmp.out.sdbuf;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QuerySecurity_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_samr_QuerySecurity_state *state = tevent_req_data(
		req, struct dcerpc_samr_QuerySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QuerySecurity(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   uint32_t _sec_info /* [in]  */,
				   struct sec_desc_buf **_sdbuf /* [out] [ref] */,
				   NTSTATUS *result)
{
	struct samr_QuerySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.sec_info = _sec_info;

	/* Out parameters */
	r.out.sdbuf = _sdbuf;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QuerySecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sdbuf = *r.out.sdbuf;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_Shutdown_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Shutdown_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Shutdown_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Shutdown *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Shutdown_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Shutdown_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SHUTDOWN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Shutdown_r_done, req);

	return req;
}

static void dcerpc_samr_Shutdown_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Shutdown_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Shutdown_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Shutdown_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Shutdown_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Shutdown *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SHUTDOWN, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Shutdown_state {
	struct samr_Shutdown orig;
	struct samr_Shutdown tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Shutdown_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Shutdown_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct policy_handle *_connect_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Shutdown_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Shutdown_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connect_handle = _connect_handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Shutdown_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Shutdown_done, req);
	return req;
}

static void dcerpc_samr_Shutdown_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Shutdown_state *state = tevent_req_data(
		req, struct dcerpc_samr_Shutdown_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Shutdown_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Shutdown_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_Shutdown_state *state = tevent_req_data(
		req, struct dcerpc_samr_Shutdown_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Shutdown(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *_connect_handle /* [in] [ref] */,
			      NTSTATUS *result)
{
	struct samr_Shutdown r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = _connect_handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Shutdown_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_LookupDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_LookupDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_LookupDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_LookupDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_LookupDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_LookupDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_LOOKUPDOMAIN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_LookupDomain_r_done, req);

	return req;
}

static void dcerpc_samr_LookupDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_LookupDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_LookupDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_LookupDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_LookupDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_LookupDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_LOOKUPDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_samr_LookupDomain_state {
	struct samr_LookupDomain orig;
	struct samr_LookupDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_LookupDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_LookupDomain_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_connect_handle /* [in] [ref] */,
						 struct lsa_String *_domain_name /* [in] [ref] */,
						 struct dom_sid2 **_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_LookupDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_LookupDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connect_handle = _connect_handle;
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_LookupDomain_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_LookupDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_LookupDomain_done, req);
	return req;
}

static void dcerpc_samr_LookupDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_LookupDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_LookupDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_LookupDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_LookupDomain_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_samr_LookupDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_LookupDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_LookupDomain(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_connect_handle /* [in] [ref] */,
				  struct lsa_String *_domain_name /* [in] [ref] */,
				  struct dom_sid2 **_sid /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct samr_LookupDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = _connect_handle;
	r.in.domain_name = _domain_name;

	/* Out parameters */
	r.out.sid = _sid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_LookupDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sid = *r.out.sid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_EnumDomains_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomains_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomains_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_EnumDomains *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomains_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomains_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomains_r_done, req);

	return req;
}

static void dcerpc_samr_EnumDomains_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomains_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_EnumDomains_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_EnumDomains_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomains_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_EnumDomains *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_EnumDomains_state {
	struct samr_EnumDomains orig;
	struct samr_EnumDomains tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomains_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomains_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_connect_handle /* [in] [ref] */,
						uint32_t *_resume_handle /* [in,out] [ref] */,
						struct samr_SamArray **_sam /* [out] [ref] */,
						uint32_t _buf_size /* [in]  */,
						uint32_t *_num_entries /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomains_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomains_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connect_handle = _connect_handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.buf_size = _buf_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.sam = _sam;
	state->orig.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_EnumDomains_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_EnumDomains_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomains_done, req);
	return req;
}

static void dcerpc_samr_EnumDomains_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_EnumDomains_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomains_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_EnumDomains_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.sam = *state->tmp.out.sam;
	*state->orig.out.num_entries = *state->tmp.out.num_entries;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomains_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_samr_EnumDomains_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomains_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomains(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_connect_handle /* [in] [ref] */,
				 uint32_t *_resume_handle /* [in,out] [ref] */,
				 struct samr_SamArray **_sam /* [out] [ref] */,
				 uint32_t _buf_size /* [in]  */,
				 uint32_t *_num_entries /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct samr_EnumDomains r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = _connect_handle;
	r.in.resume_handle = _resume_handle;
	r.in.buf_size = _buf_size;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.sam = _sam;
	r.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_EnumDomains_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_sam = *r.out.sam;
	*_num_entries = *r.out.num_entries;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_OpenDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_OpenDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENDOMAIN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenDomain_r_done, req);

	return req;
}

static void dcerpc_samr_OpenDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_OpenDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_OpenDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_OpenDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_samr_OpenDomain_state {
	struct samr_OpenDomain orig;
	struct samr_OpenDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenDomain_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_connect_handle /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       struct dom_sid2 *_sid /* [in] [ref] */,
					       struct policy_handle *_domain_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connect_handle = _connect_handle;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.domain_handle = _domain_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_OpenDomain_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_OpenDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenDomain_done, req);
	return req;
}

static void dcerpc_samr_OpenDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_OpenDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_OpenDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domain_handle = *state->tmp.out.domain_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenDomain_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_samr_OpenDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenDomain(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_connect_handle /* [in] [ref] */,
				uint32_t _access_mask /* [in]  */,
				struct dom_sid2 *_sid /* [in] [ref] */,
				struct policy_handle *_domain_handle /* [out] [ref] */,
				NTSTATUS *result)
{
	struct samr_OpenDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = _connect_handle;
	r.in.access_mask = _access_mask;
	r.in.sid = _sid;

	/* Out parameters */
	r.out.domain_handle = _domain_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_OpenDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domain_handle = *r.out.domain_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryDomainInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDomainInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDomainInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryDomainInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDomainInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDomainInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDOMAININFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDomainInfo_r_done, req);

	return req;
}

static void dcerpc_samr_QueryDomainInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDomainInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryDomainInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryDomainInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDomainInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryDomainInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDOMAININFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryDomainInfo_state {
	struct samr_QueryDomainInfo orig;
	struct samr_QueryDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDomainInfo_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_domain_handle /* [in] [ref] */,
						    enum samr_DomainInfoClass _level /* [in]  */,
						    union samr_DomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryDomainInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryDomainInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDomainInfo_done, req);
	return req;
}

static void dcerpc_samr_QueryDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryDomainInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDomainInfo_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_samr_QueryDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDomainInfo(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_domain_handle /* [in] [ref] */,
				     enum samr_DomainInfoClass _level /* [in]  */,
				     union samr_DomainInfo **_info /* [out] [ref,switch_is(level)] */,
				     NTSTATUS *result)
{
	struct samr_QueryDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryDomainInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetDomainInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetDomainInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetDomainInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetDomainInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetDomainInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetDomainInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETDOMAININFO, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetDomainInfo_r_done, req);

	return req;
}

static void dcerpc_samr_SetDomainInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetDomainInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetDomainInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetDomainInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetDomainInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetDomainInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETDOMAININFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetDomainInfo_state {
	struct samr_SetDomainInfo orig;
	struct samr_SetDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetDomainInfo_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_domain_handle /* [in] [ref] */,
						  enum samr_DomainInfoClass _level /* [in]  */,
						  union samr_DomainInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetDomainInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetDomainInfo_done, req);
	return req;
}

static void dcerpc_samr_SetDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetDomainInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetDomainInfo_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_samr_SetDomainInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetDomainInfo(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_domain_handle /* [in] [ref] */,
				   enum samr_DomainInfoClass _level /* [in]  */,
				   union samr_DomainInfo *_info /* [in] [ref,switch_is(level)] */,
				   NTSTATUS *result)
{
	struct samr_SetDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetDomainInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_CreateDomainGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateDomainGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateDomainGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_CreateDomainGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateDomainGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateDomainGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEDOMAINGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateDomainGroup_r_done, req);

	return req;
}

static void dcerpc_samr_CreateDomainGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateDomainGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_CreateDomainGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_CreateDomainGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateDomainGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_CreateDomainGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEDOMAINGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_samr_CreateDomainGroup_state {
	struct samr_CreateDomainGroup orig;
	struct samr_CreateDomainGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateDomainGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateDomainGroup_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_domain_handle /* [in] [ref] */,
						      struct lsa_String *_name /* [in] [ref] */,
						      uint32_t _access_mask /* [in]  */,
						      struct policy_handle *_group_handle /* [out] [ref] */,
						      uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateDomainGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateDomainGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.group_handle = _group_handle;
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_CreateDomainGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_CreateDomainGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateDomainGroup_done, req);
	return req;
}

static void dcerpc_samr_CreateDomainGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_CreateDomainGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateDomainGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_CreateDomainGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.group_handle = *state->tmp.out.group_handle;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateDomainGroup_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_CreateDomainGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateDomainGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateDomainGroup(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_domain_handle /* [in] [ref] */,
				       struct lsa_String *_name /* [in] [ref] */,
				       uint32_t _access_mask /* [in]  */,
				       struct policy_handle *_group_handle /* [out] [ref] */,
				       uint32_t *_rid /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct samr_CreateDomainGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.name = _name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.group_handle = _group_handle;
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_CreateDomainGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_group_handle = *r.out.group_handle;
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_EnumDomainGroups_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomainGroups_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomainGroups_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_EnumDomainGroups *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomainGroups_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomainGroups_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINGROUPS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomainGroups_r_done, req);

	return req;
}

static void dcerpc_samr_EnumDomainGroups_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomainGroups_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_EnumDomainGroups_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_EnumDomainGroups_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomainGroups_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_EnumDomainGroups *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINGROUPS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_EnumDomainGroups_state {
	struct samr_EnumDomainGroups orig;
	struct samr_EnumDomainGroups tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomainGroups_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomainGroups_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_domain_handle /* [in] [ref] */,
						     uint32_t *_resume_handle /* [in,out] [ref] */,
						     struct samr_SamArray **_sam /* [out] [ref] */,
						     uint32_t _max_size /* [in]  */,
						     uint32_t *_num_entries /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomainGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomainGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.sam = _sam;
	state->orig.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_EnumDomainGroups_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_EnumDomainGroups_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomainGroups_done, req);
	return req;
}

static void dcerpc_samr_EnumDomainGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_EnumDomainGroups_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomainGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_EnumDomainGroups_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.sam = *state->tmp.out.sam;
	*state->orig.out.num_entries = *state->tmp.out.num_entries;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomainGroups_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_samr_EnumDomainGroups_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomainGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomainGroups(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_domain_handle /* [in] [ref] */,
				      uint32_t *_resume_handle /* [in,out] [ref] */,
				      struct samr_SamArray **_sam /* [out] [ref] */,
				      uint32_t _max_size /* [in]  */,
				      uint32_t *_num_entries /* [out] [ref] */,
				      NTSTATUS *result)
{
	struct samr_EnumDomainGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.resume_handle = _resume_handle;
	r.in.max_size = _max_size;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.sam = _sam;
	r.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_EnumDomainGroups_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_sam = *r.out.sam;
	*_num_entries = *r.out.num_entries;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_CreateUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_CreateUser *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEUSER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateUser_r_done, req);

	return req;
}

static void dcerpc_samr_CreateUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_CreateUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_CreateUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_CreateUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEUSER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_CreateUser_state {
	struct samr_CreateUser orig;
	struct samr_CreateUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateUser_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_domain_handle /* [in] [ref] */,
					       struct lsa_String *_account_name /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_user_handle /* [out] [ref] */,
					       uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.account_name = _account_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.user_handle = _user_handle;
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_CreateUser_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_CreateUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateUser_done, req);
	return req;
}

static void dcerpc_samr_CreateUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_CreateUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_CreateUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.user_handle = *state->tmp.out.user_handle;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateUser_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_samr_CreateUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateUser(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_domain_handle /* [in] [ref] */,
				struct lsa_String *_account_name /* [in] [ref] */,
				uint32_t _access_mask /* [in]  */,
				struct policy_handle *_user_handle /* [out] [ref] */,
				uint32_t *_rid /* [out] [ref] */,
				NTSTATUS *result)
{
	struct samr_CreateUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.account_name = _account_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.user_handle = _user_handle;
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_CreateUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_user_handle = *r.out.user_handle;
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_EnumDomainUsers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomainUsers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomainUsers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_EnumDomainUsers *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomainUsers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomainUsers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINUSERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomainUsers_r_done, req);

	return req;
}

static void dcerpc_samr_EnumDomainUsers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomainUsers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_EnumDomainUsers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_EnumDomainUsers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomainUsers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_EnumDomainUsers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINUSERS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_EnumDomainUsers_state {
	struct samr_EnumDomainUsers orig;
	struct samr_EnumDomainUsers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomainUsers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomainUsers_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_domain_handle /* [in] [ref] */,
						    uint32_t *_resume_handle /* [in,out] [ref] */,
						    uint32_t _acct_flags /* [in]  */,
						    struct samr_SamArray **_sam /* [out] [ref] */,
						    uint32_t _max_size /* [in]  */,
						    uint32_t *_num_entries /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomainUsers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomainUsers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.acct_flags = _acct_flags;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.sam = _sam;
	state->orig.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_EnumDomainUsers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_EnumDomainUsers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomainUsers_done, req);
	return req;
}

static void dcerpc_samr_EnumDomainUsers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_EnumDomainUsers_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomainUsers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_EnumDomainUsers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.sam = *state->tmp.out.sam;
	*state->orig.out.num_entries = *state->tmp.out.num_entries;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomainUsers_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_samr_EnumDomainUsers_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomainUsers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomainUsers(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_domain_handle /* [in] [ref] */,
				     uint32_t *_resume_handle /* [in,out] [ref] */,
				     uint32_t _acct_flags /* [in]  */,
				     struct samr_SamArray **_sam /* [out] [ref] */,
				     uint32_t _max_size /* [in]  */,
				     uint32_t *_num_entries /* [out] [ref] */,
				     NTSTATUS *result)
{
	struct samr_EnumDomainUsers r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.resume_handle = _resume_handle;
	r.in.acct_flags = _acct_flags;
	r.in.max_size = _max_size;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.sam = _sam;
	r.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_EnumDomainUsers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_sam = *r.out.sam;
	*_num_entries = *r.out.num_entries;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_CreateDomAlias_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateDomAlias_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateDomAlias_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_CreateDomAlias *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateDomAlias_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateDomAlias_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEDOMALIAS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateDomAlias_r_done, req);

	return req;
}

static void dcerpc_samr_CreateDomAlias_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateDomAlias_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_CreateDomAlias_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_CreateDomAlias_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateDomAlias_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_CreateDomAlias *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEDOMALIAS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_CreateDomAlias_state {
	struct samr_CreateDomAlias orig;
	struct samr_CreateDomAlias tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateDomAlias_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateDomAlias_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_domain_handle /* [in] [ref] */,
						   struct lsa_String *_alias_name /* [in] [ref] */,
						   uint32_t _access_mask /* [in]  */,
						   struct policy_handle *_alias_handle /* [out] [ref] */,
						   uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateDomAlias_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateDomAlias_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.alias_name = _alias_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.alias_handle = _alias_handle;
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_CreateDomAlias_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_CreateDomAlias_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateDomAlias_done, req);
	return req;
}

static void dcerpc_samr_CreateDomAlias_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_CreateDomAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateDomAlias_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_CreateDomAlias_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.alias_handle = *state->tmp.out.alias_handle;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateDomAlias_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_CreateDomAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateDomAlias_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateDomAlias(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_domain_handle /* [in] [ref] */,
				    struct lsa_String *_alias_name /* [in] [ref] */,
				    uint32_t _access_mask /* [in]  */,
				    struct policy_handle *_alias_handle /* [out] [ref] */,
				    uint32_t *_rid /* [out] [ref] */,
				    NTSTATUS *result)
{
	struct samr_CreateDomAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.alias_name = _alias_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.alias_handle = _alias_handle;
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_CreateDomAlias_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_alias_handle = *r.out.alias_handle;
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_EnumDomainAliases_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomainAliases_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomainAliases_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_EnumDomainAliases *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomainAliases_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomainAliases_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINALIASES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomainAliases_r_done, req);

	return req;
}

static void dcerpc_samr_EnumDomainAliases_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomainAliases_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_EnumDomainAliases_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_EnumDomainAliases_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomainAliases_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_EnumDomainAliases *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ENUMDOMAINALIASES, mem_ctx, r);

	return status;
}

struct dcerpc_samr_EnumDomainAliases_state {
	struct samr_EnumDomainAliases orig;
	struct samr_EnumDomainAliases tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_EnumDomainAliases_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_EnumDomainAliases_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_domain_handle /* [in] [ref] */,
						      uint32_t *_resume_handle /* [in,out] [ref] */,
						      struct samr_SamArray **_sam /* [out] [ref] */,
						      uint32_t _max_size /* [in]  */,
						      uint32_t *_num_entries /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_EnumDomainAliases_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_EnumDomainAliases_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.sam = _sam;
	state->orig.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_EnumDomainAliases_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_EnumDomainAliases_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_EnumDomainAliases_done, req);
	return req;
}

static void dcerpc_samr_EnumDomainAliases_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_EnumDomainAliases_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomainAliases_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_EnumDomainAliases_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.sam = *state->tmp.out.sam;
	*state->orig.out.num_entries = *state->tmp.out.num_entries;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_EnumDomainAliases_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_EnumDomainAliases_state *state = tevent_req_data(
		req, struct dcerpc_samr_EnumDomainAliases_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_EnumDomainAliases(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_domain_handle /* [in] [ref] */,
				       uint32_t *_resume_handle /* [in,out] [ref] */,
				       struct samr_SamArray **_sam /* [out] [ref] */,
				       uint32_t _max_size /* [in]  */,
				       uint32_t *_num_entries /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct samr_EnumDomainAliases r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.resume_handle = _resume_handle;
	r.in.max_size = _max_size;

	/* Out parameters */
	r.out.resume_handle = _resume_handle;
	r.out.sam = _sam;
	r.out.num_entries = _num_entries;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_EnumDomainAliases_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_resume_handle = *r.out.resume_handle;
	*_sam = *r.out.sam;
	*_num_entries = *r.out.num_entries;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetAliasMembership_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetAliasMembership_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetAliasMembership_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetAliasMembership *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetAliasMembership_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetAliasMembership_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETALIASMEMBERSHIP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetAliasMembership_r_done, req);

	return req;
}

static void dcerpc_samr_GetAliasMembership_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetAliasMembership_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetAliasMembership_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetAliasMembership_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetAliasMembership_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetAliasMembership *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETALIASMEMBERSHIP, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetAliasMembership_state {
	struct samr_GetAliasMembership orig;
	struct samr_GetAliasMembership tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetAliasMembership_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetAliasMembership_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_domain_handle /* [in] [ref] */,
						       struct lsa_SidArray *_sids /* [in] [ref] */,
						       struct samr_Ids *_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetAliasMembership_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetAliasMembership_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.sids = _sids;

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetAliasMembership_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetAliasMembership_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetAliasMembership_done, req);
	return req;
}

static void dcerpc_samr_GetAliasMembership_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetAliasMembership_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetAliasMembership_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetAliasMembership_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetAliasMembership_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_samr_GetAliasMembership_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetAliasMembership_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetAliasMembership(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_domain_handle /* [in] [ref] */,
					struct lsa_SidArray *_sids /* [in] [ref] */,
					struct samr_Ids *_rids /* [out] [ref] */,
					NTSTATUS *result)
{
	struct samr_GetAliasMembership r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.sids = _sids;

	/* Out parameters */
	r.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetAliasMembership_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_LookupNames_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_LookupNames_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_LookupNames_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_LookupNames *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_LookupNames_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_LookupNames_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_LOOKUPNAMES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_LookupNames_r_done, req);

	return req;
}

static void dcerpc_samr_LookupNames_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_LookupNames_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_LookupNames_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_LookupNames_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_LookupNames_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_LookupNames *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_LOOKUPNAMES, mem_ctx, r);

	return status;
}

struct dcerpc_samr_LookupNames_state {
	struct samr_LookupNames orig;
	struct samr_LookupNames tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_LookupNames_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_LookupNames_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_domain_handle /* [in] [ref] */,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [length_is(num_names),size_is(1000)] */,
						struct samr_Ids *_rids /* [out] [ref] */,
						struct samr_Ids *_types /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_LookupNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_LookupNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;

	/* Out parameters */
	state->orig.out.rids = _rids;
	state->orig.out.types = _types;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_LookupNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_LookupNames_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_LookupNames_done, req);
	return req;
}

static void dcerpc_samr_LookupNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_LookupNames_state *state = tevent_req_data(
		req, struct dcerpc_samr_LookupNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_LookupNames_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;
	*state->orig.out.types = *state->tmp.out.types;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_LookupNames_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_samr_LookupNames_state *state = tevent_req_data(
		req, struct dcerpc_samr_LookupNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_LookupNames(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_domain_handle /* [in] [ref] */,
				 uint32_t _num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *_names /* [in] [length_is(num_names),size_is(1000)] */,
				 struct samr_Ids *_rids /* [out] [ref] */,
				 struct samr_Ids *_types /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct samr_LookupNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.num_names = _num_names;
	r.in.names = _names;

	/* Out parameters */
	r.out.rids = _rids;
	r.out.types = _types;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_LookupNames_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;
	*_types = *r.out.types;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_LookupRids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_LookupRids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_LookupRids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_LookupRids *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_LookupRids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_LookupRids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_LOOKUPRIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_LookupRids_r_done, req);

	return req;
}

static void dcerpc_samr_LookupRids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_LookupRids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_LookupRids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_LookupRids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_LookupRids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_LookupRids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_LOOKUPRIDS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_LookupRids_state {
	struct samr_LookupRids orig;
	struct samr_LookupRids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_LookupRids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_LookupRids_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_domain_handle /* [in] [ref] */,
					       uint32_t _num_rids /* [in] [range(0,1000)] */,
					       uint32_t *_rids /* [in] [length_is(num_rids),size_is(1000)] */,
					       struct lsa_Strings *_names /* [out] [ref] */,
					       struct samr_Ids *_types /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_LookupRids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_LookupRids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.num_rids = _num_rids;
	state->orig.in.rids = _rids;

	/* Out parameters */
	state->orig.out.names = _names;
	state->orig.out.types = _types;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_LookupRids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_LookupRids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_LookupRids_done, req);
	return req;
}

static void dcerpc_samr_LookupRids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_LookupRids_state *state = tevent_req_data(
		req, struct dcerpc_samr_LookupRids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_LookupRids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.types = *state->tmp.out.types;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_LookupRids_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_samr_LookupRids_state *state = tevent_req_data(
		req, struct dcerpc_samr_LookupRids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_LookupRids(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_domain_handle /* [in] [ref] */,
				uint32_t _num_rids /* [in] [range(0,1000)] */,
				uint32_t *_rids /* [in] [length_is(num_rids),size_is(1000)] */,
				struct lsa_Strings *_names /* [out] [ref] */,
				struct samr_Ids *_types /* [out] [ref] */,
				NTSTATUS *result)
{
	struct samr_LookupRids r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.num_rids = _num_rids;
	r.in.rids = _rids;

	/* Out parameters */
	r.out.names = _names;
	r.out.types = _types;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_LookupRids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_names = *r.out.names;
	*_types = *r.out.types;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_OpenGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_OpenGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenGroup_r_done, req);

	return req;
}

static void dcerpc_samr_OpenGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_OpenGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_OpenGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_OpenGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_samr_OpenGroup_state {
	struct samr_OpenGroup orig;
	struct samr_OpenGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenGroup_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_domain_handle /* [in] [ref] */,
					      uint32_t _access_mask /* [in]  */,
					      uint32_t _rid /* [in]  */,
					      struct policy_handle *_group_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.rid = _rid;

	/* Out parameters */
	state->orig.out.group_handle = _group_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_OpenGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_OpenGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenGroup_done, req);
	return req;
}

static void dcerpc_samr_OpenGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_OpenGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_OpenGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.group_handle = *state->tmp.out.group_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenGroup_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_samr_OpenGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenGroup(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_domain_handle /* [in] [ref] */,
			       uint32_t _access_mask /* [in]  */,
			       uint32_t _rid /* [in]  */,
			       struct policy_handle *_group_handle /* [out] [ref] */,
			       NTSTATUS *result)
{
	struct samr_OpenGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.access_mask = _access_mask;
	r.in.rid = _rid;

	/* Out parameters */
	r.out.group_handle = _group_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_OpenGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_group_handle = *r.out.group_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryGroupInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryGroupInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryGroupInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryGroupInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryGroupInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryGroupInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYGROUPINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryGroupInfo_r_done, req);

	return req;
}

static void dcerpc_samr_QueryGroupInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryGroupInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryGroupInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryGroupInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryGroupInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryGroupInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYGROUPINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryGroupInfo_state {
	struct samr_QueryGroupInfo orig;
	struct samr_QueryGroupInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryGroupInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryGroupInfo_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_group_handle /* [in] [ref] */,
						   enum samr_GroupInfoEnum _level /* [in]  */,
						   union samr_GroupInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryGroupInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryGroupInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryGroupInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryGroupInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryGroupInfo_done, req);
	return req;
}

static void dcerpc_samr_QueryGroupInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryGroupInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryGroupInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryGroupInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryGroupInfo_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_QueryGroupInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryGroupInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryGroupInfo(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_group_handle /* [in] [ref] */,
				    enum samr_GroupInfoEnum _level /* [in]  */,
				    union samr_GroupInfo **_info /* [out] [ref,switch_is(level)] */,
				    NTSTATUS *result)
{
	struct samr_QueryGroupInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryGroupInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetGroupInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetGroupInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetGroupInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetGroupInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetGroupInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetGroupInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETGROUPINFO, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetGroupInfo_r_done, req);

	return req;
}

static void dcerpc_samr_SetGroupInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetGroupInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetGroupInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetGroupInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetGroupInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetGroupInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETGROUPINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetGroupInfo_state {
	struct samr_SetGroupInfo orig;
	struct samr_SetGroupInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetGroupInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetGroupInfo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_group_handle /* [in] [ref] */,
						 enum samr_GroupInfoEnum _level /* [in]  */,
						 union samr_GroupInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetGroupInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetGroupInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetGroupInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetGroupInfo_done, req);
	return req;
}

static void dcerpc_samr_SetGroupInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetGroupInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetGroupInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetGroupInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetGroupInfo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_samr_SetGroupInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetGroupInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetGroupInfo(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_group_handle /* [in] [ref] */,
				  enum samr_GroupInfoEnum _level /* [in]  */,
				  union samr_GroupInfo *_info /* [in] [ref,switch_is(level)] */,
				  NTSTATUS *result)
{
	struct samr_SetGroupInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetGroupInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_AddGroupMember_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_AddGroupMember_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_AddGroupMember_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_AddGroupMember *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_AddGroupMember_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_AddGroupMember_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ADDGROUPMEMBER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_AddGroupMember_r_done, req);

	return req;
}

static void dcerpc_samr_AddGroupMember_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_AddGroupMember_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_AddGroupMember_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_AddGroupMember_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_AddGroupMember_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_AddGroupMember *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ADDGROUPMEMBER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_AddGroupMember_state {
	struct samr_AddGroupMember orig;
	struct samr_AddGroupMember tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_AddGroupMember_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_AddGroupMember_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_group_handle /* [in] [ref] */,
						   uint32_t _rid /* [in]  */,
						   uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_samr_AddGroupMember_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_AddGroupMember_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;
	state->orig.in.rid = _rid;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_AddGroupMember_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_AddGroupMember_done, req);
	return req;
}

static void dcerpc_samr_AddGroupMember_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_AddGroupMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_AddGroupMember_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_AddGroupMember_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_AddGroupMember_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_AddGroupMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_AddGroupMember_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_AddGroupMember(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_group_handle /* [in] [ref] */,
				    uint32_t _rid /* [in]  */,
				    uint32_t _flags /* [in]  */,
				    NTSTATUS *result)
{
	struct samr_AddGroupMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;
	r.in.rid = _rid;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_AddGroupMember_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_DeleteDomainGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteDomainGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteDomainGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_DeleteDomainGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteDomainGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteDomainGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEDOMAINGROUP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteDomainGroup_r_done, req);

	return req;
}

static void dcerpc_samr_DeleteDomainGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteDomainGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_DeleteDomainGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_DeleteDomainGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteDomainGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_DeleteDomainGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEDOMAINGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_samr_DeleteDomainGroup_state {
	struct samr_DeleteDomainGroup orig;
	struct samr_DeleteDomainGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteDomainGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteDomainGroup_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_group_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteDomainGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteDomainGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;

	/* Out parameters */
	state->orig.out.group_handle = _group_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_DeleteDomainGroup_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_DeleteDomainGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteDomainGroup_done, req);
	return req;
}

static void dcerpc_samr_DeleteDomainGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_DeleteDomainGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteDomainGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_DeleteDomainGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.group_handle = *state->tmp.out.group_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteDomainGroup_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_DeleteDomainGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteDomainGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteDomainGroup(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_group_handle /* [in,out] [ref] */,
				       NTSTATUS *result)
{
	struct samr_DeleteDomainGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;

	/* Out parameters */
	r.out.group_handle = _group_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_DeleteDomainGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_group_handle = *r.out.group_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_DeleteGroupMember_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteGroupMember_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteGroupMember_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_DeleteGroupMember *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteGroupMember_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteGroupMember_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEGROUPMEMBER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteGroupMember_r_done, req);

	return req;
}

static void dcerpc_samr_DeleteGroupMember_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteGroupMember_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_DeleteGroupMember_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_DeleteGroupMember_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteGroupMember_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_DeleteGroupMember *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEGROUPMEMBER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_DeleteGroupMember_state {
	struct samr_DeleteGroupMember orig;
	struct samr_DeleteGroupMember tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteGroupMember_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteGroupMember_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_group_handle /* [in] [ref] */,
						      uint32_t _rid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteGroupMember_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteGroupMember_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;
	state->orig.in.rid = _rid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_DeleteGroupMember_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteGroupMember_done, req);
	return req;
}

static void dcerpc_samr_DeleteGroupMember_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_DeleteGroupMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteGroupMember_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_DeleteGroupMember_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteGroupMember_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_DeleteGroupMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteGroupMember_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteGroupMember(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_group_handle /* [in] [ref] */,
				       uint32_t _rid /* [in]  */,
				       NTSTATUS *result)
{
	struct samr_DeleteGroupMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;
	r.in.rid = _rid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_DeleteGroupMember_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryGroupMember_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryGroupMember_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryGroupMember_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryGroupMember *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryGroupMember_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryGroupMember_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYGROUPMEMBER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryGroupMember_r_done, req);

	return req;
}

static void dcerpc_samr_QueryGroupMember_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryGroupMember_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryGroupMember_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryGroupMember_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryGroupMember_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryGroupMember *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYGROUPMEMBER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryGroupMember_state {
	struct samr_QueryGroupMember orig;
	struct samr_QueryGroupMember tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryGroupMember_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryGroupMember_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_group_handle /* [in] [ref] */,
						     struct samr_RidAttrArray **_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryGroupMember_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryGroupMember_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryGroupMember_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryGroupMember_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryGroupMember_done, req);
	return req;
}

static void dcerpc_samr_QueryGroupMember_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryGroupMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryGroupMember_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryGroupMember_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryGroupMember_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_samr_QueryGroupMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryGroupMember_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryGroupMember(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_group_handle /* [in] [ref] */,
				      struct samr_RidAttrArray **_rids /* [out] [ref] */,
				      NTSTATUS *result)
{
	struct samr_QueryGroupMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;

	/* Out parameters */
	r.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryGroupMember_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetMemberAttributesOfGroup_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetMemberAttributesOfGroup_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetMemberAttributesOfGroup_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetMemberAttributesOfGroup *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetMemberAttributesOfGroup_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetMemberAttributesOfGroup_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETMEMBERATTRIBUTESOFGROUP, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetMemberAttributesOfGroup_r_done, req);

	return req;
}

static void dcerpc_samr_SetMemberAttributesOfGroup_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetMemberAttributesOfGroup_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetMemberAttributesOfGroup_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetMemberAttributesOfGroup_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetMemberAttributesOfGroup_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetMemberAttributesOfGroup *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETMEMBERATTRIBUTESOFGROUP, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetMemberAttributesOfGroup_state {
	struct samr_SetMemberAttributesOfGroup orig;
	struct samr_SetMemberAttributesOfGroup tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetMemberAttributesOfGroup_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetMemberAttributesOfGroup_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_group_handle /* [in] [ref] */,
							       uint32_t _unknown1 /* [in]  */,
							       uint32_t _unknown2 /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetMemberAttributesOfGroup_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetMemberAttributesOfGroup_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.group_handle = _group_handle;
	state->orig.in.unknown1 = _unknown1;
	state->orig.in.unknown2 = _unknown2;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetMemberAttributesOfGroup_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetMemberAttributesOfGroup_done, req);
	return req;
}

static void dcerpc_samr_SetMemberAttributesOfGroup_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetMemberAttributesOfGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetMemberAttributesOfGroup_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetMemberAttributesOfGroup_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetMemberAttributesOfGroup_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_samr_SetMemberAttributesOfGroup_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetMemberAttributesOfGroup_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetMemberAttributesOfGroup(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_group_handle /* [in] [ref] */,
						uint32_t _unknown1 /* [in]  */,
						uint32_t _unknown2 /* [in]  */,
						NTSTATUS *result)
{
	struct samr_SetMemberAttributesOfGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = _group_handle;
	r.in.unknown1 = _unknown1;
	r.in.unknown2 = _unknown2;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetMemberAttributesOfGroup_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_OpenAlias_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenAlias_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenAlias_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_OpenAlias *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenAlias_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenAlias_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENALIAS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenAlias_r_done, req);

	return req;
}

static void dcerpc_samr_OpenAlias_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenAlias_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_OpenAlias_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_OpenAlias_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenAlias_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_OpenAlias *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENALIAS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_OpenAlias_state {
	struct samr_OpenAlias orig;
	struct samr_OpenAlias tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenAlias_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenAlias_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_domain_handle /* [in] [ref] */,
					      uint32_t _access_mask /* [in]  */,
					      uint32_t _rid /* [in]  */,
					      struct policy_handle *_alias_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenAlias_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenAlias_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.rid = _rid;

	/* Out parameters */
	state->orig.out.alias_handle = _alias_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_OpenAlias_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_OpenAlias_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenAlias_done, req);
	return req;
}

static void dcerpc_samr_OpenAlias_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_OpenAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenAlias_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_OpenAlias_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.alias_handle = *state->tmp.out.alias_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenAlias_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_samr_OpenAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenAlias_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenAlias(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_domain_handle /* [in] [ref] */,
			       uint32_t _access_mask /* [in]  */,
			       uint32_t _rid /* [in]  */,
			       struct policy_handle *_alias_handle /* [out] [ref] */,
			       NTSTATUS *result)
{
	struct samr_OpenAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.access_mask = _access_mask;
	r.in.rid = _rid;

	/* Out parameters */
	r.out.alias_handle = _alias_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_OpenAlias_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_alias_handle = *r.out.alias_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryAliasInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryAliasInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryAliasInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryAliasInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryAliasInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryAliasInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYALIASINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryAliasInfo_r_done, req);

	return req;
}

static void dcerpc_samr_QueryAliasInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryAliasInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryAliasInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryAliasInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryAliasInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryAliasInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYALIASINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryAliasInfo_state {
	struct samr_QueryAliasInfo orig;
	struct samr_QueryAliasInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryAliasInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryAliasInfo_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_alias_handle /* [in] [ref] */,
						   enum samr_AliasInfoEnum _level /* [in]  */,
						   union samr_AliasInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryAliasInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryAliasInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryAliasInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryAliasInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryAliasInfo_done, req);
	return req;
}

static void dcerpc_samr_QueryAliasInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryAliasInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryAliasInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryAliasInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryAliasInfo_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_QueryAliasInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryAliasInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryAliasInfo(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_alias_handle /* [in] [ref] */,
				    enum samr_AliasInfoEnum _level /* [in]  */,
				    union samr_AliasInfo **_info /* [out] [ref,switch_is(level)] */,
				    NTSTATUS *result)
{
	struct samr_QueryAliasInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryAliasInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetAliasInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetAliasInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetAliasInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetAliasInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetAliasInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetAliasInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETALIASINFO, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetAliasInfo_r_done, req);

	return req;
}

static void dcerpc_samr_SetAliasInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetAliasInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetAliasInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetAliasInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetAliasInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetAliasInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETALIASINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetAliasInfo_state {
	struct samr_SetAliasInfo orig;
	struct samr_SetAliasInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetAliasInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetAliasInfo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_alias_handle /* [in] [ref] */,
						 enum samr_AliasInfoEnum _level /* [in]  */,
						 union samr_AliasInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetAliasInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetAliasInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetAliasInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetAliasInfo_done, req);
	return req;
}

static void dcerpc_samr_SetAliasInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetAliasInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetAliasInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetAliasInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetAliasInfo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_samr_SetAliasInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetAliasInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetAliasInfo(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_alias_handle /* [in] [ref] */,
				  enum samr_AliasInfoEnum _level /* [in]  */,
				  union samr_AliasInfo *_info /* [in] [ref,switch_is(level)] */,
				  NTSTATUS *result)
{
	struct samr_SetAliasInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetAliasInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_DeleteDomAlias_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteDomAlias_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteDomAlias_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_DeleteDomAlias *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteDomAlias_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteDomAlias_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEDOMALIAS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteDomAlias_r_done, req);

	return req;
}

static void dcerpc_samr_DeleteDomAlias_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteDomAlias_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_DeleteDomAlias_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_DeleteDomAlias_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteDomAlias_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_DeleteDomAlias *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEDOMALIAS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_DeleteDomAlias_state {
	struct samr_DeleteDomAlias orig;
	struct samr_DeleteDomAlias tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteDomAlias_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteDomAlias_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_alias_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteDomAlias_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteDomAlias_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;

	/* Out parameters */
	state->orig.out.alias_handle = _alias_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_DeleteDomAlias_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_DeleteDomAlias_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteDomAlias_done, req);
	return req;
}

static void dcerpc_samr_DeleteDomAlias_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_DeleteDomAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteDomAlias_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_DeleteDomAlias_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.alias_handle = *state->tmp.out.alias_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteDomAlias_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_DeleteDomAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteDomAlias_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteDomAlias(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_alias_handle /* [in,out] [ref] */,
				    NTSTATUS *result)
{
	struct samr_DeleteDomAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;

	/* Out parameters */
	r.out.alias_handle = _alias_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_DeleteDomAlias_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_alias_handle = *r.out.alias_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_AddAliasMember_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_AddAliasMember_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_AddAliasMember_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_AddAliasMember *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_AddAliasMember_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_AddAliasMember_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ADDALIASMEMBER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_AddAliasMember_r_done, req);

	return req;
}

static void dcerpc_samr_AddAliasMember_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_AddAliasMember_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_AddAliasMember_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_AddAliasMember_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_AddAliasMember_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_AddAliasMember *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ADDALIASMEMBER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_AddAliasMember_state {
	struct samr_AddAliasMember orig;
	struct samr_AddAliasMember tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_AddAliasMember_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_AddAliasMember_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_alias_handle /* [in] [ref] */,
						   struct dom_sid2 *_sid /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_AddAliasMember_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_AddAliasMember_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;
	state->orig.in.sid = _sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_AddAliasMember_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_AddAliasMember_done, req);
	return req;
}

static void dcerpc_samr_AddAliasMember_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_AddAliasMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_AddAliasMember_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_AddAliasMember_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_AddAliasMember_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_AddAliasMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_AddAliasMember_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_AddAliasMember(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_alias_handle /* [in] [ref] */,
				    struct dom_sid2 *_sid /* [in] [ref] */,
				    NTSTATUS *result)
{
	struct samr_AddAliasMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;
	r.in.sid = _sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_AddAliasMember_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_DeleteAliasMember_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteAliasMember_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteAliasMember_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_DeleteAliasMember *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteAliasMember_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteAliasMember_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEALIASMEMBER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteAliasMember_r_done, req);

	return req;
}

static void dcerpc_samr_DeleteAliasMember_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteAliasMember_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_DeleteAliasMember_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_DeleteAliasMember_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteAliasMember_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_DeleteAliasMember *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEALIASMEMBER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_DeleteAliasMember_state {
	struct samr_DeleteAliasMember orig;
	struct samr_DeleteAliasMember tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteAliasMember_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteAliasMember_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_alias_handle /* [in] [ref] */,
						      struct dom_sid2 *_sid /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteAliasMember_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteAliasMember_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;
	state->orig.in.sid = _sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_DeleteAliasMember_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteAliasMember_done, req);
	return req;
}

static void dcerpc_samr_DeleteAliasMember_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_DeleteAliasMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteAliasMember_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_DeleteAliasMember_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteAliasMember_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_DeleteAliasMember_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteAliasMember_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteAliasMember(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_alias_handle /* [in] [ref] */,
				       struct dom_sid2 *_sid /* [in] [ref] */,
				       NTSTATUS *result)
{
	struct samr_DeleteAliasMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;
	r.in.sid = _sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_DeleteAliasMember_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetMembersInAlias_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetMembersInAlias_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetMembersInAlias_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetMembersInAlias *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetMembersInAlias_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetMembersInAlias_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETMEMBERSINALIAS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetMembersInAlias_r_done, req);

	return req;
}

static void dcerpc_samr_GetMembersInAlias_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetMembersInAlias_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetMembersInAlias_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetMembersInAlias_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetMembersInAlias_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetMembersInAlias *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETMEMBERSINALIAS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetMembersInAlias_state {
	struct samr_GetMembersInAlias orig;
	struct samr_GetMembersInAlias tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetMembersInAlias_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetMembersInAlias_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_alias_handle /* [in] [ref] */,
						      struct lsa_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetMembersInAlias_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetMembersInAlias_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetMembersInAlias_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetMembersInAlias_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetMembersInAlias_done, req);
	return req;
}

static void dcerpc_samr_GetMembersInAlias_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetMembersInAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetMembersInAlias_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetMembersInAlias_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetMembersInAlias_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_GetMembersInAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetMembersInAlias_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetMembersInAlias(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_alias_handle /* [in] [ref] */,
				       struct lsa_SidArray *_sids /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct samr_GetMembersInAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;

	/* Out parameters */
	r.out.sids = _sids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetMembersInAlias_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sids = *r.out.sids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_OpenUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_OpenUser *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENUSER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenUser_r_done, req);

	return req;
}

static void dcerpc_samr_OpenUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_OpenUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_OpenUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_OpenUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OPENUSER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_OpenUser_state {
	struct samr_OpenUser orig;
	struct samr_OpenUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OpenUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OpenUser_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct policy_handle *_domain_handle /* [in] [ref] */,
					     uint32_t _access_mask /* [in]  */,
					     uint32_t _rid /* [in]  */,
					     struct policy_handle *_user_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_OpenUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OpenUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.rid = _rid;

	/* Out parameters */
	state->orig.out.user_handle = _user_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_OpenUser_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_OpenUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OpenUser_done, req);
	return req;
}

static void dcerpc_samr_OpenUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_OpenUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_OpenUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.user_handle = *state->tmp.out.user_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OpenUser_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_OpenUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_OpenUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OpenUser(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *_domain_handle /* [in] [ref] */,
			      uint32_t _access_mask /* [in]  */,
			      uint32_t _rid /* [in]  */,
			      struct policy_handle *_user_handle /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct samr_OpenUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.access_mask = _access_mask;
	r.in.rid = _rid;

	/* Out parameters */
	r.out.user_handle = _user_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_OpenUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_user_handle = *r.out.user_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_DeleteUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_DeleteUser *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEUSER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteUser_r_done, req);

	return req;
}

static void dcerpc_samr_DeleteUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_DeleteUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_DeleteUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_DeleteUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_DELETEUSER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_DeleteUser_state {
	struct samr_DeleteUser orig;
	struct samr_DeleteUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_DeleteUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_DeleteUser_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_user_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_DeleteUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_DeleteUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;

	/* Out parameters */
	state->orig.out.user_handle = _user_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_DeleteUser_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_DeleteUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_DeleteUser_done, req);
	return req;
}

static void dcerpc_samr_DeleteUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_DeleteUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_DeleteUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.user_handle = *state->tmp.out.user_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_DeleteUser_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_samr_DeleteUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_DeleteUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_DeleteUser(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_user_handle /* [in,out] [ref] */,
				NTSTATUS *result)
{
	struct samr_DeleteUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;

	/* Out parameters */
	r.out.user_handle = _user_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_DeleteUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_user_handle = *r.out.user_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryUserInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryUserInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryUserInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryUserInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryUserInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryUserInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYUSERINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryUserInfo_r_done, req);

	return req;
}

static void dcerpc_samr_QueryUserInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryUserInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryUserInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryUserInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryUserInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryUserInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYUSERINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryUserInfo_state {
	struct samr_QueryUserInfo orig;
	struct samr_QueryUserInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryUserInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryUserInfo_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_user_handle /* [in] [ref] */,
						  enum samr_UserInfoLevel _level /* [in]  */,
						  union samr_UserInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryUserInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryUserInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryUserInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryUserInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryUserInfo_done, req);
	return req;
}

static void dcerpc_samr_QueryUserInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryUserInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryUserInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryUserInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryUserInfo_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_samr_QueryUserInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryUserInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryUserInfo(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_user_handle /* [in] [ref] */,
				   enum samr_UserInfoLevel _level /* [in]  */,
				   union samr_UserInfo **_info /* [out] [ref,switch_is(level)] */,
				   NTSTATUS *result)
{
	struct samr_QueryUserInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryUserInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetUserInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetUserInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetUserInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetUserInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetUserInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetUserInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETUSERINFO, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetUserInfo_r_done, req);

	return req;
}

static void dcerpc_samr_SetUserInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetUserInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetUserInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetUserInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetUserInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetUserInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETUSERINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetUserInfo_state {
	struct samr_SetUserInfo orig;
	struct samr_SetUserInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetUserInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetUserInfo_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_user_handle /* [in] [ref] */,
						enum samr_UserInfoLevel _level /* [in]  */,
						union samr_UserInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetUserInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetUserInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetUserInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetUserInfo_done, req);
	return req;
}

static void dcerpc_samr_SetUserInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetUserInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetUserInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetUserInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetUserInfo_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_samr_SetUserInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetUserInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetUserInfo(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_user_handle /* [in] [ref] */,
				 enum samr_UserInfoLevel _level /* [in]  */,
				 union samr_UserInfo *_info /* [in] [ref,switch_is(level)] */,
				 NTSTATUS *result)
{
	struct samr_SetUserInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetUserInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_ChangePasswordUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_ChangePasswordUser *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser_r_done, req);

	return req;
}

static void dcerpc_samr_ChangePasswordUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_ChangePasswordUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_ChangePasswordUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_ChangePasswordUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_ChangePasswordUser_state {
	struct samr_ChangePasswordUser orig;
	struct samr_ChangePasswordUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_user_handle /* [in] [ref] */,
						       uint8_t _lm_present /* [in]  */,
						       struct samr_Password *_old_lm_crypted /* [in] [unique] */,
						       struct samr_Password *_new_lm_crypted /* [in] [unique] */,
						       uint8_t _nt_present /* [in]  */,
						       struct samr_Password *_old_nt_crypted /* [in] [unique] */,
						       struct samr_Password *_new_nt_crypted /* [in] [unique] */,
						       uint8_t _cross1_present /* [in]  */,
						       struct samr_Password *_nt_cross /* [in] [unique] */,
						       uint8_t _cross2_present /* [in]  */,
						       struct samr_Password *_lm_cross /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;
	state->orig.in.lm_present = _lm_present;
	state->orig.in.old_lm_crypted = _old_lm_crypted;
	state->orig.in.new_lm_crypted = _new_lm_crypted;
	state->orig.in.nt_present = _nt_present;
	state->orig.in.old_nt_crypted = _old_nt_crypted;
	state->orig.in.new_nt_crypted = _new_nt_crypted;
	state->orig.in.cross1_present = _cross1_present;
	state->orig.in.nt_cross = _nt_cross;
	state->orig.in.cross2_present = _cross2_present;
	state->orig.in.lm_cross = _lm_cross;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_ChangePasswordUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser_done, req);
	return req;
}

static void dcerpc_samr_ChangePasswordUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_ChangePasswordUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_ChangePasswordUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_samr_ChangePasswordUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_user_handle /* [in] [ref] */,
					uint8_t _lm_present /* [in]  */,
					struct samr_Password *_old_lm_crypted /* [in] [unique] */,
					struct samr_Password *_new_lm_crypted /* [in] [unique] */,
					uint8_t _nt_present /* [in]  */,
					struct samr_Password *_old_nt_crypted /* [in] [unique] */,
					struct samr_Password *_new_nt_crypted /* [in] [unique] */,
					uint8_t _cross1_present /* [in]  */,
					struct samr_Password *_nt_cross /* [in] [unique] */,
					uint8_t _cross2_present /* [in]  */,
					struct samr_Password *_lm_cross /* [in] [unique] */,
					NTSTATUS *result)
{
	struct samr_ChangePasswordUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;
	r.in.lm_present = _lm_present;
	r.in.old_lm_crypted = _old_lm_crypted;
	r.in.new_lm_crypted = _new_lm_crypted;
	r.in.nt_present = _nt_present;
	r.in.old_nt_crypted = _old_nt_crypted;
	r.in.new_nt_crypted = _new_nt_crypted;
	r.in.cross1_present = _cross1_present;
	r.in.nt_cross = _nt_cross;
	r.in.cross2_present = _cross2_present;
	r.in.lm_cross = _lm_cross;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_ChangePasswordUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetGroupsForUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetGroupsForUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetGroupsForUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetGroupsForUser *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetGroupsForUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetGroupsForUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETGROUPSFORUSER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetGroupsForUser_r_done, req);

	return req;
}

static void dcerpc_samr_GetGroupsForUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetGroupsForUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetGroupsForUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetGroupsForUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetGroupsForUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetGroupsForUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETGROUPSFORUSER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetGroupsForUser_state {
	struct samr_GetGroupsForUser orig;
	struct samr_GetGroupsForUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetGroupsForUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetGroupsForUser_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_user_handle /* [in] [ref] */,
						     struct samr_RidWithAttributeArray **_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetGroupsForUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetGroupsForUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetGroupsForUser_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetGroupsForUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetGroupsForUser_done, req);
	return req;
}

static void dcerpc_samr_GetGroupsForUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetGroupsForUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetGroupsForUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetGroupsForUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetGroupsForUser_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_samr_GetGroupsForUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetGroupsForUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetGroupsForUser(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_user_handle /* [in] [ref] */,
				      struct samr_RidWithAttributeArray **_rids /* [out] [ref] */,
				      NTSTATUS *result)
{
	struct samr_GetGroupsForUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;

	/* Out parameters */
	r.out.rids = _rids;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetGroupsForUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryDisplayInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDisplayInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDisplayInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryDisplayInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDisplayInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDisplayInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDISPLAYINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDisplayInfo_r_done, req);

	return req;
}

static void dcerpc_samr_QueryDisplayInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDisplayInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryDisplayInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryDisplayInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDisplayInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryDisplayInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDISPLAYINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryDisplayInfo_state {
	struct samr_QueryDisplayInfo orig;
	struct samr_QueryDisplayInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDisplayInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDisplayInfo_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_domain_handle /* [in] [ref] */,
						     uint16_t _level /* [in]  */,
						     uint32_t _start_idx /* [in]  */,
						     uint32_t _max_entries /* [in]  */,
						     uint32_t _buf_size /* [in]  */,
						     uint32_t *_total_size /* [out] [ref] */,
						     uint32_t *_returned_size /* [out] [ref] */,
						     union samr_DispInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDisplayInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDisplayInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;
	state->orig.in.start_idx = _start_idx;
	state->orig.in.max_entries = _max_entries;
	state->orig.in.buf_size = _buf_size;

	/* Out parameters */
	state->orig.out.total_size = _total_size;
	state->orig.out.returned_size = _returned_size;
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryDisplayInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryDisplayInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDisplayInfo_done, req);
	return req;
}

static void dcerpc_samr_QueryDisplayInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryDisplayInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDisplayInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryDisplayInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.total_size = *state->tmp.out.total_size;
	*state->orig.out.returned_size = *state->tmp.out.returned_size;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDisplayInfo_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_samr_QueryDisplayInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDisplayInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDisplayInfo(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_domain_handle /* [in] [ref] */,
				      uint16_t _level /* [in]  */,
				      uint32_t _start_idx /* [in]  */,
				      uint32_t _max_entries /* [in]  */,
				      uint32_t _buf_size /* [in]  */,
				      uint32_t *_total_size /* [out] [ref] */,
				      uint32_t *_returned_size /* [out] [ref] */,
				      union samr_DispInfo *_info /* [out] [ref,switch_is(level)] */,
				      NTSTATUS *result)
{
	struct samr_QueryDisplayInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;
	r.in.start_idx = _start_idx;
	r.in.max_entries = _max_entries;
	r.in.buf_size = _buf_size;

	/* Out parameters */
	r.out.total_size = _total_size;
	r.out.returned_size = _returned_size;
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryDisplayInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_total_size = *r.out.total_size;
	*_returned_size = *r.out.returned_size;
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetDisplayEnumerationIndex_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetDisplayEnumerationIndex_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetDisplayEnumerationIndex_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetDisplayEnumerationIndex *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetDisplayEnumerationIndex_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetDisplayEnumerationIndex_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETDISPLAYENUMERATIONINDEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetDisplayEnumerationIndex_r_done, req);

	return req;
}

static void dcerpc_samr_GetDisplayEnumerationIndex_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetDisplayEnumerationIndex_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetDisplayEnumerationIndex_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetDisplayEnumerationIndex *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETDISPLAYENUMERATIONINDEX, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetDisplayEnumerationIndex_state {
	struct samr_GetDisplayEnumerationIndex orig;
	struct samr_GetDisplayEnumerationIndex tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetDisplayEnumerationIndex_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetDisplayEnumerationIndex_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_domain_handle /* [in] [ref] */,
							       uint16_t _level /* [in]  */,
							       struct lsa_String *_name /* [in] [ref] */,
							       uint32_t *_idx /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetDisplayEnumerationIndex_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetDisplayEnumerationIndex_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.idx = _idx;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetDisplayEnumerationIndex_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetDisplayEnumerationIndex_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetDisplayEnumerationIndex_done, req);
	return req;
}

static void dcerpc_samr_GetDisplayEnumerationIndex_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetDisplayEnumerationIndex_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetDisplayEnumerationIndex_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetDisplayEnumerationIndex_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.idx = *state->tmp.out.idx;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_samr_GetDisplayEnumerationIndex_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetDisplayEnumerationIndex_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_domain_handle /* [in] [ref] */,
						uint16_t _level /* [in]  */,
						struct lsa_String *_name /* [in] [ref] */,
						uint32_t *_idx /* [out] [ref] */,
						NTSTATUS *result)
{
	struct samr_GetDisplayEnumerationIndex r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;
	r.in.name = _name;

	/* Out parameters */
	r.out.idx = _idx;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetDisplayEnumerationIndex_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_idx = *r.out.idx;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_TestPrivateFunctionsDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_TestPrivateFunctionsDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_TestPrivateFunctionsDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_TestPrivateFunctionsDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_TestPrivateFunctionsDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_TestPrivateFunctionsDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_TESTPRIVATEFUNCTIONSDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_TestPrivateFunctionsDomain_r_done, req);

	return req;
}

static void dcerpc_samr_TestPrivateFunctionsDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_TestPrivateFunctionsDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_TestPrivateFunctionsDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_TestPrivateFunctionsDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_TESTPRIVATEFUNCTIONSDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_samr_TestPrivateFunctionsDomain_state {
	struct samr_TestPrivateFunctionsDomain orig;
	struct samr_TestPrivateFunctionsDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_TestPrivateFunctionsDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_TestPrivateFunctionsDomain_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_domain_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_TestPrivateFunctionsDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_TestPrivateFunctionsDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_TestPrivateFunctionsDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_TestPrivateFunctionsDomain_done, req);
	return req;
}

static void dcerpc_samr_TestPrivateFunctionsDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_TestPrivateFunctionsDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_TestPrivateFunctionsDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_TestPrivateFunctionsDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsDomain_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct dcerpc_samr_TestPrivateFunctionsDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_TestPrivateFunctionsDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsDomain(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_domain_handle /* [in] [ref] */,
						NTSTATUS *result)
{
	struct samr_TestPrivateFunctionsDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_TestPrivateFunctionsDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_TestPrivateFunctionsUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_TestPrivateFunctionsUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_TestPrivateFunctionsUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_TestPrivateFunctionsUser *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_TestPrivateFunctionsUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_TestPrivateFunctionsUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_TESTPRIVATEFUNCTIONSUSER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_TestPrivateFunctionsUser_r_done, req);

	return req;
}

static void dcerpc_samr_TestPrivateFunctionsUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_TestPrivateFunctionsUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_TestPrivateFunctionsUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_TestPrivateFunctionsUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_TESTPRIVATEFUNCTIONSUSER, mem_ctx, r);

	return status;
}

struct dcerpc_samr_TestPrivateFunctionsUser_state {
	struct samr_TestPrivateFunctionsUser orig;
	struct samr_TestPrivateFunctionsUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_TestPrivateFunctionsUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_TestPrivateFunctionsUser_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_user_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_TestPrivateFunctionsUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_TestPrivateFunctionsUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_TestPrivateFunctionsUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_TestPrivateFunctionsUser_done, req);
	return req;
}

static void dcerpc_samr_TestPrivateFunctionsUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_TestPrivateFunctionsUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_TestPrivateFunctionsUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_TestPrivateFunctionsUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsUser_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct dcerpc_samr_TestPrivateFunctionsUser_state *state = tevent_req_data(
		req, struct dcerpc_samr_TestPrivateFunctionsUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_TestPrivateFunctionsUser(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_user_handle /* [in] [ref] */,
					      NTSTATUS *result)
{
	struct samr_TestPrivateFunctionsUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_TestPrivateFunctionsUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetUserPwInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetUserPwInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetUserPwInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetUserPwInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetUserPwInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetUserPwInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETUSERPWINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetUserPwInfo_r_done, req);

	return req;
}

static void dcerpc_samr_GetUserPwInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetUserPwInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetUserPwInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetUserPwInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetUserPwInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetUserPwInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETUSERPWINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetUserPwInfo_state {
	struct samr_GetUserPwInfo orig;
	struct samr_GetUserPwInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetUserPwInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetUserPwInfo_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_user_handle /* [in] [ref] */,
						  struct samr_PwInfo *_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetUserPwInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetUserPwInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetUserPwInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetUserPwInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetUserPwInfo_done, req);
	return req;
}

static void dcerpc_samr_GetUserPwInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetUserPwInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetUserPwInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetUserPwInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetUserPwInfo_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_samr_GetUserPwInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetUserPwInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetUserPwInfo(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_user_handle /* [in] [ref] */,
				   struct samr_PwInfo *_info /* [out] [ref] */,
				   NTSTATUS *result)
{
	struct samr_GetUserPwInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetUserPwInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_RemoveMemberFromForeignDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_RemoveMemberFromForeignDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_RemoveMemberFromForeignDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_RemoveMemberFromForeignDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_RemoveMemberFromForeignDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_RemoveMemberFromForeignDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_RemoveMemberFromForeignDomain_r_done, req);

	return req;
}

static void dcerpc_samr_RemoveMemberFromForeignDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_RemoveMemberFromForeignDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_RemoveMemberFromForeignDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_RemoveMemberFromForeignDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_RemoveMemberFromForeignDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_RemoveMemberFromForeignDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_samr_RemoveMemberFromForeignDomain_state {
	struct samr_RemoveMemberFromForeignDomain orig;
	struct samr_RemoveMemberFromForeignDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_RemoveMemberFromForeignDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_RemoveMemberFromForeignDomain_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct dcerpc_binding_handle *h,
								  struct policy_handle *_domain_handle /* [in] [ref] */,
								  struct dom_sid2 *_sid /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_RemoveMemberFromForeignDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_RemoveMemberFromForeignDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.sid = _sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_RemoveMemberFromForeignDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_RemoveMemberFromForeignDomain_done, req);
	return req;
}

static void dcerpc_samr_RemoveMemberFromForeignDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_RemoveMemberFromForeignDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_RemoveMemberFromForeignDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_RemoveMemberFromForeignDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_RemoveMemberFromForeignDomain_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							NTSTATUS *result)
{
	struct dcerpc_samr_RemoveMemberFromForeignDomain_state *state = tevent_req_data(
		req, struct dcerpc_samr_RemoveMemberFromForeignDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_RemoveMemberFromForeignDomain(struct dcerpc_binding_handle *h,
						   TALLOC_CTX *mem_ctx,
						   struct policy_handle *_domain_handle /* [in] [ref] */,
						   struct dom_sid2 *_sid /* [in] [ref] */,
						   NTSTATUS *result)
{
	struct samr_RemoveMemberFromForeignDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.sid = _sid;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_RemoveMemberFromForeignDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryDomainInfo2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDomainInfo2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDomainInfo2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryDomainInfo2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDomainInfo2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDomainInfo2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDOMAININFO2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDomainInfo2_r_done, req);

	return req;
}

static void dcerpc_samr_QueryDomainInfo2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDomainInfo2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryDomainInfo2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryDomainInfo2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDomainInfo2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryDomainInfo2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDOMAININFO2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryDomainInfo2_state {
	struct samr_QueryDomainInfo2 orig;
	struct samr_QueryDomainInfo2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDomainInfo2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDomainInfo2_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_domain_handle /* [in] [ref] */,
						     enum samr_DomainInfoClass _level /* [in]  */,
						     union samr_DomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDomainInfo2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDomainInfo2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryDomainInfo2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryDomainInfo2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDomainInfo2_done, req);
	return req;
}

static void dcerpc_samr_QueryDomainInfo2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryDomainInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDomainInfo2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryDomainInfo2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDomainInfo2_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_samr_QueryDomainInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDomainInfo2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDomainInfo2(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_domain_handle /* [in] [ref] */,
				      enum samr_DomainInfoClass _level /* [in]  */,
				      union samr_DomainInfo **_info /* [out] [ref,switch_is(level)] */,
				      NTSTATUS *result)
{
	struct samr_QueryDomainInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryDomainInfo2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryUserInfo2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryUserInfo2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryUserInfo2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryUserInfo2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryUserInfo2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryUserInfo2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYUSERINFO2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryUserInfo2_r_done, req);

	return req;
}

static void dcerpc_samr_QueryUserInfo2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryUserInfo2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryUserInfo2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryUserInfo2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryUserInfo2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryUserInfo2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYUSERINFO2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryUserInfo2_state {
	struct samr_QueryUserInfo2 orig;
	struct samr_QueryUserInfo2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryUserInfo2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryUserInfo2_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_user_handle /* [in] [ref] */,
						   enum samr_UserInfoLevel _level /* [in]  */,
						   union samr_UserInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryUserInfo2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryUserInfo2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryUserInfo2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryUserInfo2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryUserInfo2_done, req);
	return req;
}

static void dcerpc_samr_QueryUserInfo2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryUserInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryUserInfo2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryUserInfo2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryUserInfo2_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_samr_QueryUserInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryUserInfo2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryUserInfo2(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_user_handle /* [in] [ref] */,
				    enum samr_UserInfoLevel _level /* [in]  */,
				    union samr_UserInfo **_info /* [out] [ref,switch_is(level)] */,
				    NTSTATUS *result)
{
	struct samr_QueryUserInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryUserInfo2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryDisplayInfo2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDisplayInfo2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDisplayInfo2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryDisplayInfo2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDisplayInfo2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDisplayInfo2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDISPLAYINFO2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDisplayInfo2_r_done, req);

	return req;
}

static void dcerpc_samr_QueryDisplayInfo2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDisplayInfo2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryDisplayInfo2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryDisplayInfo2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDisplayInfo2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryDisplayInfo2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDISPLAYINFO2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryDisplayInfo2_state {
	struct samr_QueryDisplayInfo2 orig;
	struct samr_QueryDisplayInfo2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDisplayInfo2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDisplayInfo2_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_domain_handle /* [in] [ref] */,
						      uint16_t _level /* [in]  */,
						      uint32_t _start_idx /* [in]  */,
						      uint32_t _max_entries /* [in]  */,
						      uint32_t _buf_size /* [in]  */,
						      uint32_t *_total_size /* [out] [ref] */,
						      uint32_t *_returned_size /* [out] [ref] */,
						      union samr_DispInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDisplayInfo2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDisplayInfo2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;
	state->orig.in.start_idx = _start_idx;
	state->orig.in.max_entries = _max_entries;
	state->orig.in.buf_size = _buf_size;

	/* Out parameters */
	state->orig.out.total_size = _total_size;
	state->orig.out.returned_size = _returned_size;
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryDisplayInfo2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryDisplayInfo2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDisplayInfo2_done, req);
	return req;
}

static void dcerpc_samr_QueryDisplayInfo2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryDisplayInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDisplayInfo2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryDisplayInfo2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.total_size = *state->tmp.out.total_size;
	*state->orig.out.returned_size = *state->tmp.out.returned_size;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDisplayInfo2_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_QueryDisplayInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDisplayInfo2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDisplayInfo2(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_domain_handle /* [in] [ref] */,
				       uint16_t _level /* [in]  */,
				       uint32_t _start_idx /* [in]  */,
				       uint32_t _max_entries /* [in]  */,
				       uint32_t _buf_size /* [in]  */,
				       uint32_t *_total_size /* [out] [ref] */,
				       uint32_t *_returned_size /* [out] [ref] */,
				       union samr_DispInfo *_info /* [out] [ref,switch_is(level)] */,
				       NTSTATUS *result)
{
	struct samr_QueryDisplayInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;
	r.in.start_idx = _start_idx;
	r.in.max_entries = _max_entries;
	r.in.buf_size = _buf_size;

	/* Out parameters */
	r.out.total_size = _total_size;
	r.out.returned_size = _returned_size;
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryDisplayInfo2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_total_size = *r.out.total_size;
	*_returned_size = *r.out.returned_size;
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetDisplayEnumerationIndex2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetDisplayEnumerationIndex2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetDisplayEnumerationIndex2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetDisplayEnumerationIndex2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetDisplayEnumerationIndex2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetDisplayEnumerationIndex2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETDISPLAYENUMERATIONINDEX2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetDisplayEnumerationIndex2_r_done, req);

	return req;
}

static void dcerpc_samr_GetDisplayEnumerationIndex2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetDisplayEnumerationIndex2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetDisplayEnumerationIndex2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetDisplayEnumerationIndex2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETDISPLAYENUMERATIONINDEX2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetDisplayEnumerationIndex2_state {
	struct samr_GetDisplayEnumerationIndex2 orig;
	struct samr_GetDisplayEnumerationIndex2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetDisplayEnumerationIndex2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetDisplayEnumerationIndex2_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								struct policy_handle *_domain_handle /* [in] [ref] */,
								uint16_t _level /* [in]  */,
								struct lsa_String *_name /* [in] [ref] */,
								uint32_t *_idx /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetDisplayEnumerationIndex2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetDisplayEnumerationIndex2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.idx = _idx;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetDisplayEnumerationIndex2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetDisplayEnumerationIndex2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetDisplayEnumerationIndex2_done, req);
	return req;
}

static void dcerpc_samr_GetDisplayEnumerationIndex2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetDisplayEnumerationIndex2_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetDisplayEnumerationIndex2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetDisplayEnumerationIndex2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.idx = *state->tmp.out.idx;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex2_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      NTSTATUS *result)
{
	struct dcerpc_samr_GetDisplayEnumerationIndex2_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetDisplayEnumerationIndex2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetDisplayEnumerationIndex2(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *_domain_handle /* [in] [ref] */,
						 uint16_t _level /* [in]  */,
						 struct lsa_String *_name /* [in] [ref] */,
						 uint32_t *_idx /* [out] [ref] */,
						 NTSTATUS *result)
{
	struct samr_GetDisplayEnumerationIndex2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;
	r.in.name = _name;

	/* Out parameters */
	r.out.idx = _idx;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetDisplayEnumerationIndex2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_idx = *r.out.idx;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_CreateUser2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateUser2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateUser2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_CreateUser2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateUser2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateUser2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEUSER2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateUser2_r_done, req);

	return req;
}

static void dcerpc_samr_CreateUser2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateUser2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_CreateUser2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_CreateUser2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateUser2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_CreateUser2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CREATEUSER2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_CreateUser2_state {
	struct samr_CreateUser2 orig;
	struct samr_CreateUser2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_CreateUser2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_CreateUser2_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_domain_handle /* [in] [ref] */,
						struct lsa_String *_account_name /* [in] [ref] */,
						uint32_t _acct_flags /* [in]  */,
						uint32_t _access_mask /* [in]  */,
						struct policy_handle *_user_handle /* [out] [ref] */,
						uint32_t *_access_granted /* [out] [ref] */,
						uint32_t *_rid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_CreateUser2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_CreateUser2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.account_name = _account_name;
	state->orig.in.acct_flags = _acct_flags;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.user_handle = _user_handle;
	state->orig.out.access_granted = _access_granted;
	state->orig.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_CreateUser2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_CreateUser2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_CreateUser2_done, req);
	return req;
}

static void dcerpc_samr_CreateUser2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_CreateUser2_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateUser2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_CreateUser2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.user_handle = *state->tmp.out.user_handle;
	*state->orig.out.access_granted = *state->tmp.out.access_granted;
	*state->orig.out.rid = *state->tmp.out.rid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_CreateUser2_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_samr_CreateUser2_state *state = tevent_req_data(
		req, struct dcerpc_samr_CreateUser2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_CreateUser2(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_domain_handle /* [in] [ref] */,
				 struct lsa_String *_account_name /* [in] [ref] */,
				 uint32_t _acct_flags /* [in]  */,
				 uint32_t _access_mask /* [in]  */,
				 struct policy_handle *_user_handle /* [out] [ref] */,
				 uint32_t *_access_granted /* [out] [ref] */,
				 uint32_t *_rid /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct samr_CreateUser2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.account_name = _account_name;
	r.in.acct_flags = _acct_flags;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.user_handle = _user_handle;
	r.out.access_granted = _access_granted;
	r.out.rid = _rid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_CreateUser2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_user_handle = *r.out.user_handle;
	*_access_granted = *r.out.access_granted;
	*_rid = *r.out.rid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_QueryDisplayInfo3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDisplayInfo3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDisplayInfo3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_QueryDisplayInfo3 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDisplayInfo3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDisplayInfo3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDISPLAYINFO3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDisplayInfo3_r_done, req);

	return req;
}

static void dcerpc_samr_QueryDisplayInfo3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDisplayInfo3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_QueryDisplayInfo3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_QueryDisplayInfo3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDisplayInfo3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_QueryDisplayInfo3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_QUERYDISPLAYINFO3, mem_ctx, r);

	return status;
}

struct dcerpc_samr_QueryDisplayInfo3_state {
	struct samr_QueryDisplayInfo3 orig;
	struct samr_QueryDisplayInfo3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_QueryDisplayInfo3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_QueryDisplayInfo3_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_domain_handle /* [in] [ref] */,
						      uint16_t _level /* [in]  */,
						      uint32_t _start_idx /* [in]  */,
						      uint32_t _max_entries /* [in]  */,
						      uint32_t _buf_size /* [in]  */,
						      uint32_t *_total_size /* [out] [ref] */,
						      uint32_t *_returned_size /* [out] [ref] */,
						      union samr_DispInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_QueryDisplayInfo3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_QueryDisplayInfo3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.level = _level;
	state->orig.in.start_idx = _start_idx;
	state->orig.in.max_entries = _max_entries;
	state->orig.in.buf_size = _buf_size;

	/* Out parameters */
	state->orig.out.total_size = _total_size;
	state->orig.out.returned_size = _returned_size;
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_QueryDisplayInfo3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_QueryDisplayInfo3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_QueryDisplayInfo3_done, req);
	return req;
}

static void dcerpc_samr_QueryDisplayInfo3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_QueryDisplayInfo3_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDisplayInfo3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_QueryDisplayInfo3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.total_size = *state->tmp.out.total_size;
	*state->orig.out.returned_size = *state->tmp.out.returned_size;
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_QueryDisplayInfo3_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_samr_QueryDisplayInfo3_state *state = tevent_req_data(
		req, struct dcerpc_samr_QueryDisplayInfo3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_QueryDisplayInfo3(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_domain_handle /* [in] [ref] */,
				       uint16_t _level /* [in]  */,
				       uint32_t _start_idx /* [in]  */,
				       uint32_t _max_entries /* [in]  */,
				       uint32_t _buf_size /* [in]  */,
				       uint32_t *_total_size /* [out] [ref] */,
				       uint32_t *_returned_size /* [out] [ref] */,
				       union samr_DispInfo *_info /* [out] [ref,switch_is(level)] */,
				       NTSTATUS *result)
{
	struct samr_QueryDisplayInfo3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.level = _level;
	r.in.start_idx = _start_idx;
	r.in.max_entries = _max_entries;
	r.in.buf_size = _buf_size;

	/* Out parameters */
	r.out.total_size = _total_size;
	r.out.returned_size = _returned_size;
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_QueryDisplayInfo3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_total_size = *r.out.total_size;
	*_returned_size = *r.out.returned_size;
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_AddMultipleMembersToAlias_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_AddMultipleMembersToAlias_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_AddMultipleMembersToAlias_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_AddMultipleMembersToAlias *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_AddMultipleMembersToAlias_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_AddMultipleMembersToAlias_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ADDMULTIPLEMEMBERSTOALIAS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_AddMultipleMembersToAlias_r_done, req);

	return req;
}

static void dcerpc_samr_AddMultipleMembersToAlias_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_AddMultipleMembersToAlias_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_AddMultipleMembersToAlias_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_AddMultipleMembersToAlias_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_AddMultipleMembersToAlias_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_AddMultipleMembersToAlias *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_ADDMULTIPLEMEMBERSTOALIAS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_AddMultipleMembersToAlias_state {
	struct samr_AddMultipleMembersToAlias orig;
	struct samr_AddMultipleMembersToAlias tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_AddMultipleMembersToAlias_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_AddMultipleMembersToAlias_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_alias_handle /* [in] [ref] */,
							      struct lsa_SidArray *_sids /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_AddMultipleMembersToAlias_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_AddMultipleMembersToAlias_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;
	state->orig.in.sids = _sids;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_AddMultipleMembersToAlias_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_AddMultipleMembersToAlias_done, req);
	return req;
}

static void dcerpc_samr_AddMultipleMembersToAlias_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_AddMultipleMembersToAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_AddMultipleMembersToAlias_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_AddMultipleMembersToAlias_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_AddMultipleMembersToAlias_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct dcerpc_samr_AddMultipleMembersToAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_AddMultipleMembersToAlias_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_AddMultipleMembersToAlias(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_alias_handle /* [in] [ref] */,
					       struct lsa_SidArray *_sids /* [in] [ref] */,
					       NTSTATUS *result)
{
	struct samr_AddMultipleMembersToAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;
	r.in.sids = _sids;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_AddMultipleMembersToAlias_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_RemoveMultipleMembersFromAlias_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_RemoveMultipleMembersFromAlias_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_RemoveMultipleMembersFromAlias_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_RemoveMultipleMembersFromAlias *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_RemoveMultipleMembersFromAlias_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_RemoveMultipleMembersFromAlias_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_RemoveMultipleMembersFromAlias_r_done, req);

	return req;
}

static void dcerpc_samr_RemoveMultipleMembersFromAlias_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_RemoveMultipleMembersFromAlias_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_RemoveMultipleMembersFromAlias_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_RemoveMultipleMembersFromAlias_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_RemoveMultipleMembersFromAlias_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_RemoveMultipleMembersFromAlias *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS, mem_ctx, r);

	return status;
}

struct dcerpc_samr_RemoveMultipleMembersFromAlias_state {
	struct samr_RemoveMultipleMembersFromAlias orig;
	struct samr_RemoveMultipleMembersFromAlias tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_RemoveMultipleMembersFromAlias_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_RemoveMultipleMembersFromAlias_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   struct policy_handle *_alias_handle /* [in] [ref] */,
								   struct lsa_SidArray *_sids /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_RemoveMultipleMembersFromAlias_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_RemoveMultipleMembersFromAlias_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.alias_handle = _alias_handle;
	state->orig.in.sids = _sids;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_RemoveMultipleMembersFromAlias_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_RemoveMultipleMembersFromAlias_done, req);
	return req;
}

static void dcerpc_samr_RemoveMultipleMembersFromAlias_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_RemoveMultipleMembersFromAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_RemoveMultipleMembersFromAlias_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_RemoveMultipleMembersFromAlias_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_RemoveMultipleMembersFromAlias_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 NTSTATUS *result)
{
	struct dcerpc_samr_RemoveMultipleMembersFromAlias_state *state = tevent_req_data(
		req, struct dcerpc_samr_RemoveMultipleMembersFromAlias_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_RemoveMultipleMembersFromAlias(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    struct policy_handle *_alias_handle /* [in] [ref] */,
						    struct lsa_SidArray *_sids /* [in] [ref] */,
						    NTSTATUS *result)
{
	struct samr_RemoveMultipleMembersFromAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = _alias_handle;
	r.in.sids = _sids;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_RemoveMultipleMembersFromAlias_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_OemChangePasswordUser2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OemChangePasswordUser2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OemChangePasswordUser2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_OemChangePasswordUser2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_OemChangePasswordUser2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OemChangePasswordUser2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OEMCHANGEPASSWORDUSER2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OemChangePasswordUser2_r_done, req);

	return req;
}

static void dcerpc_samr_OemChangePasswordUser2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OemChangePasswordUser2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_OemChangePasswordUser2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_OemChangePasswordUser2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OemChangePasswordUser2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_OemChangePasswordUser2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_OEMCHANGEPASSWORDUSER2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_OemChangePasswordUser2_state {
	struct samr_OemChangePasswordUser2 orig;
	struct samr_OemChangePasswordUser2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_OemChangePasswordUser2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_OemChangePasswordUser2_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct lsa_AsciiString *_server /* [in] [unique] */,
							   struct lsa_AsciiString *_account /* [in] [ref] */,
							   struct samr_CryptPassword *_password /* [in] [unique] */,
							   struct samr_Password *_hash /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_OemChangePasswordUser2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_OemChangePasswordUser2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.account = _account;
	state->orig.in.password = _password;
	state->orig.in.hash = _hash;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_OemChangePasswordUser2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_OemChangePasswordUser2_done, req);
	return req;
}

static void dcerpc_samr_OemChangePasswordUser2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_OemChangePasswordUser2_state *state = tevent_req_data(
		req, struct dcerpc_samr_OemChangePasswordUser2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_OemChangePasswordUser2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_OemChangePasswordUser2_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct dcerpc_samr_OemChangePasswordUser2_state *state = tevent_req_data(
		req, struct dcerpc_samr_OemChangePasswordUser2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_OemChangePasswordUser2(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct lsa_AsciiString *_server /* [in] [unique] */,
					    struct lsa_AsciiString *_account /* [in] [ref] */,
					    struct samr_CryptPassword *_password /* [in] [unique] */,
					    struct samr_Password *_hash /* [in] [unique] */,
					    NTSTATUS *result)
{
	struct samr_OemChangePasswordUser2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.account = _account;
	r.in.password = _password;
	r.in.hash = _hash;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_OemChangePasswordUser2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_ChangePasswordUser2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_ChangePasswordUser2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser2_r_done, req);

	return req;
}

static void dcerpc_samr_ChangePasswordUser2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_ChangePasswordUser2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_ChangePasswordUser2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_ChangePasswordUser2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_ChangePasswordUser2_state {
	struct samr_ChangePasswordUser2 orig;
	struct samr_ChangePasswordUser2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser2_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct lsa_String *_server /* [in] [unique] */,
							struct lsa_String *_account /* [in] [ref] */,
							struct samr_CryptPassword *_nt_password /* [in] [unique] */,
							struct samr_Password *_nt_verifier /* [in] [unique] */,
							uint8_t _lm_change /* [in]  */,
							struct samr_CryptPassword *_lm_password /* [in] [unique] */,
							struct samr_Password *_lm_verifier /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.account = _account;
	state->orig.in.nt_password = _nt_password;
	state->orig.in.nt_verifier = _nt_verifier;
	state->orig.in.lm_change = _lm_change;
	state->orig.in.lm_password = _lm_password;
	state->orig.in.lm_verifier = _lm_verifier;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_ChangePasswordUser2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser2_done, req);
	return req;
}

static void dcerpc_samr_ChangePasswordUser2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_ChangePasswordUser2_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_ChangePasswordUser2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser2_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_samr_ChangePasswordUser2_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser2(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct lsa_String *_server /* [in] [unique] */,
					 struct lsa_String *_account /* [in] [ref] */,
					 struct samr_CryptPassword *_nt_password /* [in] [unique] */,
					 struct samr_Password *_nt_verifier /* [in] [unique] */,
					 uint8_t _lm_change /* [in]  */,
					 struct samr_CryptPassword *_lm_password /* [in] [unique] */,
					 struct samr_Password *_lm_verifier /* [in] [unique] */,
					 NTSTATUS *result)
{
	struct samr_ChangePasswordUser2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.account = _account;
	r.in.nt_password = _nt_password;
	r.in.nt_verifier = _nt_verifier;
	r.in.lm_change = _lm_change;
	r.in.lm_password = _lm_password;
	r.in.lm_verifier = _lm_verifier;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_ChangePasswordUser2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetDomPwInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetDomPwInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetDomPwInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetDomPwInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetDomPwInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetDomPwInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETDOMPWINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetDomPwInfo_r_done, req);

	return req;
}

static void dcerpc_samr_GetDomPwInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetDomPwInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetDomPwInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetDomPwInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetDomPwInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetDomPwInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETDOMPWINFO, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetDomPwInfo_state {
	struct samr_GetDomPwInfo orig;
	struct samr_GetDomPwInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetDomPwInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetDomPwInfo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct lsa_String *_domain_name /* [in] [unique] */,
						 struct samr_PwInfo *_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetDomPwInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetDomPwInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetDomPwInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetDomPwInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetDomPwInfo_done, req);
	return req;
}

static void dcerpc_samr_GetDomPwInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetDomPwInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetDomPwInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetDomPwInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetDomPwInfo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_samr_GetDomPwInfo_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetDomPwInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetDomPwInfo(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct lsa_String *_domain_name /* [in] [unique] */,
				  struct samr_PwInfo *_info /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct samr_GetDomPwInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetDomPwInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_Connect2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Connect2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect2_r_done, req);

	return req;
}

static void dcerpc_samr_Connect2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Connect2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Connect2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Connect2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Connect2_state {
	struct samr_Connect2 orig;
	struct samr_Connect2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect2_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_system_name /* [in] [charset(UTF16),unique] */,
					     uint32_t _access_mask /* [in]  */,
					     struct policy_handle *_connect_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_Connect2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Connect2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect2_done, req);
	return req;
}

static void dcerpc_samr_Connect2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Connect2_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Connect2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.connect_handle = *state->tmp.out.connect_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect2_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_Connect2_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect2(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_system_name /* [in] [charset(UTF16),unique] */,
			      uint32_t _access_mask /* [in]  */,
			      struct policy_handle *_connect_handle /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct samr_Connect2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Connect2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_connect_handle = *r.out.connect_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetUserInfo2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetUserInfo2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetUserInfo2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetUserInfo2 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetUserInfo2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetUserInfo2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETUSERINFO2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetUserInfo2_r_done, req);

	return req;
}

static void dcerpc_samr_SetUserInfo2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetUserInfo2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetUserInfo2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetUserInfo2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetUserInfo2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetUserInfo2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETUSERINFO2, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetUserInfo2_state {
	struct samr_SetUserInfo2 orig;
	struct samr_SetUserInfo2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetUserInfo2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetUserInfo2_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_user_handle /* [in] [ref] */,
						 enum samr_UserInfoLevel _level /* [in]  */,
						 union samr_UserInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetUserInfo2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetUserInfo2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_handle = _user_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetUserInfo2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetUserInfo2_done, req);
	return req;
}

static void dcerpc_samr_SetUserInfo2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetUserInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetUserInfo2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetUserInfo2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetUserInfo2_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_samr_SetUserInfo2_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetUserInfo2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetUserInfo2(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_user_handle /* [in] [ref] */,
				  enum samr_UserInfoLevel _level /* [in]  */,
				  union samr_UserInfo *_info /* [in] [ref,switch_is(level)] */,
				  NTSTATUS *result)
{
	struct samr_SetUserInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = _user_handle;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetUserInfo2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetBootKeyInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetBootKeyInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetBootKeyInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetBootKeyInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetBootKeyInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetBootKeyInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETBOOTKEYINFORMATION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetBootKeyInformation_r_done, req);

	return req;
}

static void dcerpc_samr_SetBootKeyInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetBootKeyInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetBootKeyInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetBootKeyInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetBootKeyInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetBootKeyInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETBOOTKEYINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetBootKeyInformation_state {
	struct samr_SetBootKeyInformation orig;
	struct samr_SetBootKeyInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetBootKeyInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetBootKeyInformation_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_connect_handle /* [in] [ref] */,
							  uint32_t _unknown1 /* [in]  */,
							  uint32_t _unknown2 /* [in]  */,
							  uint32_t _unknown3 /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetBootKeyInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetBootKeyInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connect_handle = _connect_handle;
	state->orig.in.unknown1 = _unknown1;
	state->orig.in.unknown2 = _unknown2;
	state->orig.in.unknown3 = _unknown3;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetBootKeyInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetBootKeyInformation_done, req);
	return req;
}

static void dcerpc_samr_SetBootKeyInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetBootKeyInformation_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetBootKeyInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetBootKeyInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetBootKeyInformation_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_samr_SetBootKeyInformation_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetBootKeyInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetBootKeyInformation(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_connect_handle /* [in] [ref] */,
					   uint32_t _unknown1 /* [in]  */,
					   uint32_t _unknown2 /* [in]  */,
					   uint32_t _unknown3 /* [in]  */,
					   NTSTATUS *result)
{
	struct samr_SetBootKeyInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = _connect_handle;
	r.in.unknown1 = _unknown1;
	r.in.unknown2 = _unknown2;
	r.in.unknown3 = _unknown3;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetBootKeyInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_GetBootKeyInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetBootKeyInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetBootKeyInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_GetBootKeyInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetBootKeyInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetBootKeyInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETBOOTKEYINFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetBootKeyInformation_r_done, req);

	return req;
}

static void dcerpc_samr_GetBootKeyInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetBootKeyInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_GetBootKeyInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_GetBootKeyInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetBootKeyInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_GetBootKeyInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_GETBOOTKEYINFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_samr_GetBootKeyInformation_state {
	struct samr_GetBootKeyInformation orig;
	struct samr_GetBootKeyInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_GetBootKeyInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_GetBootKeyInformation_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_domain_handle /* [in] [ref] */,
							  uint32_t *_unknown /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_GetBootKeyInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_GetBootKeyInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;

	/* Out parameters */
	state->orig.out.unknown = _unknown;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_GetBootKeyInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_GetBootKeyInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_GetBootKeyInformation_done, req);
	return req;
}

static void dcerpc_samr_GetBootKeyInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_GetBootKeyInformation_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetBootKeyInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_GetBootKeyInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.unknown = *state->tmp.out.unknown;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_GetBootKeyInformation_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_samr_GetBootKeyInformation_state *state = tevent_req_data(
		req, struct dcerpc_samr_GetBootKeyInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_GetBootKeyInformation(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_domain_handle /* [in] [ref] */,
					   uint32_t *_unknown /* [out] [ref] */,
					   NTSTATUS *result)
{
	struct samr_GetBootKeyInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;

	/* Out parameters */
	r.out.unknown = _unknown;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_GetBootKeyInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_unknown = *r.out.unknown;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_Connect3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Connect3 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect3_r_done, req);

	return req;
}

static void dcerpc_samr_Connect3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Connect3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Connect3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Connect3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT3, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Connect3_state {
	struct samr_Connect3 orig;
	struct samr_Connect3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect3_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_system_name /* [in] [charset(UTF16),unique] */,
					     uint32_t _unknown /* [in]  */,
					     uint32_t _access_mask /* [in]  */,
					     struct policy_handle *_connect_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.unknown = _unknown;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_Connect3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Connect3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect3_done, req);
	return req;
}

static void dcerpc_samr_Connect3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Connect3_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Connect3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.connect_handle = *state->tmp.out.connect_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect3_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_Connect3_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect3(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_system_name /* [in] [charset(UTF16),unique] */,
			      uint32_t _unknown /* [in]  */,
			      uint32_t _access_mask /* [in]  */,
			      struct policy_handle *_connect_handle /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct samr_Connect3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.unknown = _unknown;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Connect3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_connect_handle = *r.out.connect_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_Connect4_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect4_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect4_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Connect4 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect4_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect4_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT4, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect4_r_done, req);

	return req;
}

static void dcerpc_samr_Connect4_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect4_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Connect4_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Connect4_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect4_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Connect4 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT4, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Connect4_state {
	struct samr_Connect4 orig;
	struct samr_Connect4 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect4_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect4_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_system_name /* [in] [charset(UTF16),unique] */,
					     enum samr_ConnectVersion _client_version /* [in]  */,
					     uint32_t _access_mask /* [in]  */,
					     struct policy_handle *_connect_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect4_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect4_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.client_version = _client_version;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_Connect4_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Connect4_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect4_done, req);
	return req;
}

static void dcerpc_samr_Connect4_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Connect4_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect4_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Connect4_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.connect_handle = *state->tmp.out.connect_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect4_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_Connect4_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect4_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect4(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_system_name /* [in] [charset(UTF16),unique] */,
			      enum samr_ConnectVersion _client_version /* [in]  */,
			      uint32_t _access_mask /* [in]  */,
			      struct policy_handle *_connect_handle /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct samr_Connect4 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.client_version = _client_version;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Connect4_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_connect_handle = *r.out.connect_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_ChangePasswordUser3_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser3_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser3_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_ChangePasswordUser3 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser3_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser3_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER3, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser3_r_done, req);

	return req;
}

static void dcerpc_samr_ChangePasswordUser3_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser3_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_ChangePasswordUser3_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_ChangePasswordUser3_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser3_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_ChangePasswordUser3 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER3, mem_ctx, r);

	return status;
}

struct dcerpc_samr_ChangePasswordUser3_state {
	struct samr_ChangePasswordUser3 orig;
	struct samr_ChangePasswordUser3 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser3_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser3_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct lsa_String *_server /* [in] [unique] */,
							struct lsa_String *_account /* [in] [ref] */,
							struct samr_CryptPassword *_nt_password /* [in] [unique] */,
							struct samr_Password *_nt_verifier /* [in] [unique] */,
							uint8_t _lm_change /* [in]  */,
							struct samr_CryptPassword *_lm_password /* [in] [unique] */,
							struct samr_Password *_lm_verifier /* [in] [unique] */,
							struct samr_CryptPassword *_password3 /* [in] [unique] */,
							struct samr_DomInfo1 **_dominfo /* [out] [ref] */,
							struct userPwdChangeFailureInformation **_reject /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.account = _account;
	state->orig.in.nt_password = _nt_password;
	state->orig.in.nt_verifier = _nt_verifier;
	state->orig.in.lm_change = _lm_change;
	state->orig.in.lm_password = _lm_password;
	state->orig.in.lm_verifier = _lm_verifier;
	state->orig.in.password3 = _password3;

	/* Out parameters */
	state->orig.out.dominfo = _dominfo;
	state->orig.out.reject = _reject;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_ChangePasswordUser3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_ChangePasswordUser3_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser3_done, req);
	return req;
}

static void dcerpc_samr_ChangePasswordUser3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_ChangePasswordUser3_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_ChangePasswordUser3_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dominfo = *state->tmp.out.dominfo;
	*state->orig.out.reject = *state->tmp.out.reject;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser3_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_samr_ChangePasswordUser3_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser3(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct lsa_String *_server /* [in] [unique] */,
					 struct lsa_String *_account /* [in] [ref] */,
					 struct samr_CryptPassword *_nt_password /* [in] [unique] */,
					 struct samr_Password *_nt_verifier /* [in] [unique] */,
					 uint8_t _lm_change /* [in]  */,
					 struct samr_CryptPassword *_lm_password /* [in] [unique] */,
					 struct samr_Password *_lm_verifier /* [in] [unique] */,
					 struct samr_CryptPassword *_password3 /* [in] [unique] */,
					 struct samr_DomInfo1 **_dominfo /* [out] [ref] */,
					 struct userPwdChangeFailureInformation **_reject /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct samr_ChangePasswordUser3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.account = _account;
	r.in.nt_password = _nt_password;
	r.in.nt_verifier = _nt_verifier;
	r.in.lm_change = _lm_change;
	r.in.lm_password = _lm_password;
	r.in.lm_verifier = _lm_verifier;
	r.in.password3 = _password3;

	/* Out parameters */
	r.out.dominfo = _dominfo;
	r.out.reject = _reject;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_ChangePasswordUser3_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dominfo = *r.out.dominfo;
	*_reject = *r.out.reject;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_Connect5_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect5_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect5_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_Connect5 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect5_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect5_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT5, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect5_r_done, req);

	return req;
}

static void dcerpc_samr_Connect5_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect5_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_Connect5_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_Connect5_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect5_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_Connect5 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CONNECT5, mem_ctx, r);

	return status;
}

struct dcerpc_samr_Connect5_state {
	struct samr_Connect5 orig;
	struct samr_Connect5 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_Connect5_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_Connect5_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_system_name /* [in] [charset(UTF16),unique] */,
					     uint32_t _access_mask /* [in]  */,
					     uint32_t _level_in /* [in]  */,
					     union samr_ConnectInfo *_info_in /* [in] [ref,switch_is(level_in)] */,
					     uint32_t *_level_out /* [out] [ref] */,
					     union samr_ConnectInfo *_info_out /* [out] [ref,switch_is(*level_out)] */,
					     struct policy_handle *_connect_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_Connect5_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_Connect5_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.level_in = _level_in;
	state->orig.in.info_in = _info_in;

	/* Out parameters */
	state->orig.out.level_out = _level_out;
	state->orig.out.info_out = _info_out;
	state->orig.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_Connect5_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_Connect5_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_Connect5_done, req);
	return req;
}

static void dcerpc_samr_Connect5_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_Connect5_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect5_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_Connect5_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.level_out = *state->tmp.out.level_out;
	*state->orig.out.info_out = *state->tmp.out.info_out;
	*state->orig.out.connect_handle = *state->tmp.out.connect_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_Connect5_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_Connect5_state *state = tevent_req_data(
		req, struct dcerpc_samr_Connect5_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_Connect5(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_system_name /* [in] [charset(UTF16),unique] */,
			      uint32_t _access_mask /* [in]  */,
			      uint32_t _level_in /* [in]  */,
			      union samr_ConnectInfo *_info_in /* [in] [ref,switch_is(level_in)] */,
			      uint32_t *_level_out /* [out] [ref] */,
			      union samr_ConnectInfo *_info_out /* [out] [ref,switch_is(*level_out)] */,
			      struct policy_handle *_connect_handle /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct samr_Connect5 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = _system_name;
	r.in.access_mask = _access_mask;
	r.in.level_in = _level_in;
	r.in.info_in = _info_in;

	/* Out parameters */
	r.out.level_out = _level_out;
	r.out.info_out = _info_out;
	r.out.connect_handle = _connect_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_Connect5_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_level_out = *r.out.level_out;
	*_info_out = *r.out.info_out;
	*_connect_handle = *r.out.connect_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_RidToSid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_RidToSid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_RidToSid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_RidToSid *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_RidToSid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_RidToSid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_RIDTOSID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_RidToSid_r_done, req);

	return req;
}

static void dcerpc_samr_RidToSid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_RidToSid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_RidToSid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_RidToSid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_RidToSid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_RidToSid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_RIDTOSID, mem_ctx, r);

	return status;
}

struct dcerpc_samr_RidToSid_state {
	struct samr_RidToSid orig;
	struct samr_RidToSid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_RidToSid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_RidToSid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct policy_handle *_domain_handle /* [in] [ref] */,
					     uint32_t _rid /* [in]  */,
					     struct dom_sid2 **_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_RidToSid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_RidToSid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_handle = _domain_handle;
	state->orig.in.rid = _rid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_RidToSid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_RidToSid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_RidToSid_done, req);
	return req;
}

static void dcerpc_samr_RidToSid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_RidToSid_state *state = tevent_req_data(
		req, struct dcerpc_samr_RidToSid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_RidToSid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_RidToSid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_samr_RidToSid_state *state = tevent_req_data(
		req, struct dcerpc_samr_RidToSid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_RidToSid(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *_domain_handle /* [in] [ref] */,
			      uint32_t _rid /* [in]  */,
			      struct dom_sid2 **_sid /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct samr_RidToSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = _domain_handle;
	r.in.rid = _rid;

	/* Out parameters */
	r.out.sid = _sid;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_RidToSid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sid = *r.out.sid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_SetDsrmPassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetDsrmPassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetDsrmPassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_SetDsrmPassword *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetDsrmPassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetDsrmPassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETDSRMPASSWORD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetDsrmPassword_r_done, req);

	return req;
}

static void dcerpc_samr_SetDsrmPassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetDsrmPassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_SetDsrmPassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_SetDsrmPassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetDsrmPassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_SetDsrmPassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_SETDSRMPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_samr_SetDsrmPassword_state {
	struct samr_SetDsrmPassword orig;
	struct samr_SetDsrmPassword tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_SetDsrmPassword_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_SetDsrmPassword_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct lsa_String *_name /* [in] [unique] */,
						    uint32_t _unknown /* [in]  */,
						    struct samr_Password *_hash /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_SetDsrmPassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_SetDsrmPassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.name = _name;
	state->orig.in.unknown = _unknown;
	state->orig.in.hash = _hash;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_SetDsrmPassword_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_SetDsrmPassword_done, req);
	return req;
}

static void dcerpc_samr_SetDsrmPassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_SetDsrmPassword_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetDsrmPassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_SetDsrmPassword_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_SetDsrmPassword_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_samr_SetDsrmPassword_state *state = tevent_req_data(
		req, struct dcerpc_samr_SetDsrmPassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_SetDsrmPassword(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct lsa_String *_name /* [in] [unique] */,
				     uint32_t _unknown /* [in]  */,
				     struct samr_Password *_hash /* [in] [unique] */,
				     NTSTATUS *result)
{
	struct samr_SetDsrmPassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.name = _name;
	r.in.unknown = _unknown;
	r.in.hash = _hash;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_SetDsrmPassword_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_ValidatePassword_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ValidatePassword_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ValidatePassword_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_ValidatePassword *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_ValidatePassword_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ValidatePassword_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_VALIDATEPASSWORD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ValidatePassword_r_done, req);

	return req;
}

static void dcerpc_samr_ValidatePassword_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ValidatePassword_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_ValidatePassword_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_ValidatePassword_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ValidatePassword_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_ValidatePassword *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_VALIDATEPASSWORD, mem_ctx, r);

	return status;
}

struct dcerpc_samr_ValidatePassword_state {
	struct samr_ValidatePassword orig;
	struct samr_ValidatePassword tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ValidatePassword_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ValidatePassword_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     enum samr_ValidatePasswordLevel _level /* [in]  */,
						     union samr_ValidatePasswordReq *_req /* [in] [ref,switch_is(level)] */,
						     union samr_ValidatePasswordRep **_rep /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_ValidatePassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ValidatePassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.level = _level;
	state->orig.in.req = _req;

	/* Out parameters */
	state->orig.out.rep = _rep;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_samr_ValidatePassword_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_ValidatePassword_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ValidatePassword_done, req);
	return req;
}

static void dcerpc_samr_ValidatePassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_ValidatePassword_state *state = tevent_req_data(
		req, struct dcerpc_samr_ValidatePassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_ValidatePassword_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rep = *state->tmp.out.rep;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ValidatePassword_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct dcerpc_samr_ValidatePassword_state *state = tevent_req_data(
		req, struct dcerpc_samr_ValidatePassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ValidatePassword(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      enum samr_ValidatePasswordLevel _level /* [in]  */,
				      union samr_ValidatePasswordReq *_req /* [in] [ref,switch_is(level)] */,
				      union samr_ValidatePasswordRep **_rep /* [out] [ref,switch_is(level)] */,
				      NTSTATUS *result)
{
	struct samr_ValidatePassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.level = _level;
	r.in.req = _req;

	/* Out parameters */
	r.out.rep = _rep;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_ValidatePassword_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rep = *r.out.rep;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_samr_ChangePasswordUser4_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser4_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser4_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samr_ChangePasswordUser4 *r)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser4_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser4_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER4, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser4_r_done, req);

	return req;
}

static void dcerpc_samr_ChangePasswordUser4_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser4_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samr_ChangePasswordUser4_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samr_ChangePasswordUser4_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser4_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samr_ChangePasswordUser4 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_samr,
			NDR_SAMR_CHANGEPASSWORDUSER4, mem_ctx, r);

	return status;
}

struct dcerpc_samr_ChangePasswordUser4_state {
	struct samr_ChangePasswordUser4 orig;
	struct samr_ChangePasswordUser4 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samr_ChangePasswordUser4_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samr_ChangePasswordUser4_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct lsa_String *_server /* [in] [unique] */,
							struct lsa_String *_account /* [in] [ref] */,
							struct samr_EncryptedPasswordAES *_password /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_samr_ChangePasswordUser4_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samr_ChangePasswordUser4_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.account = _account;
	state->orig.in.password = _password;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samr_ChangePasswordUser4_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samr_ChangePasswordUser4_done, req);
	return req;
}

static void dcerpc_samr_ChangePasswordUser4_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samr_ChangePasswordUser4_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser4_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samr_ChangePasswordUser4_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samr_ChangePasswordUser4_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_samr_ChangePasswordUser4_state *state = tevent_req_data(
		req, struct dcerpc_samr_ChangePasswordUser4_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samr_ChangePasswordUser4(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct lsa_String *_server /* [in] [unique] */,
					 struct lsa_String *_account /* [in] [ref] */,
					 struct samr_EncryptedPasswordAES *_password /* [in] [ref] */,
					 NTSTATUS *result)
{
	struct samr_ChangePasswordUser4 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.account = _account;
	r.in.password = _password;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_samr_ChangePasswordUser4_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

