/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 350 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
#include <qvector.h>
#include <qopengl.h>
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3900.cpp"



extern "C" {static void assign_QVector_3900(void *, Py_ssize_t, void *);}
static void assign_QVector_3900(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVector< ::GLuint64> *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVector< ::GLuint64> *>(sipSrc);
}


extern "C" {static void *array_QVector_3900(Py_ssize_t);}
static void *array_QVector_3900(Py_ssize_t sipNrElem)
{
    return new ::QVector< ::GLuint64>[sipNrElem];
}


extern "C" {static void *copy_QVector_3900(const void *, Py_ssize_t);}
static void *copy_QVector_3900(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVector< ::GLuint64>(reinterpret_cast<const ::QVector< ::GLuint64> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QVector_3900(void *, int);}
static void release_QVector_3900(void *sipCppV, int)
{
    ::QVector< ::GLuint64> *sipCpp = reinterpret_cast< ::QVector< ::GLuint64> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QVector_3900(PyObject *, void **, int *, PyObject *);}
static int convertTo_QVector_3900(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QVector< ::GLuint64> **sipCppPtr = reinterpret_cast< ::QVector< ::GLuint64> **>(sipCppPtrV);

#line 380 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QVector<GLuint64> *qv = new QVector<GLuint64>;

    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyErr_Clear();
        unsigned PY_LONG_LONG val = PyLong_AsUnsignedLongLongMask(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        qv->append(val);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 140 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3900.cpp"
}


extern "C" {static PyObject *convertFrom_QVector_3900(void *, PyObject *);}
static PyObject *convertFrom_QVector_3900(void *sipCppV, PyObject *)
{
    ::QVector< ::GLuint64> *sipCpp = reinterpret_cast< ::QVector< ::GLuint64> *>(sipCppV);

#line 355 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        // Convert to a Python long to make sure it doesn't get interpreted as
        // a signed value.
        PyObject *pobj = PyLong_FromUnsignedLongLong(sipCpp->value(i));

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 172 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3900.cpp"
}


sipMappedTypeDef sipTypeDef_QtGui_QVector_3900 = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_18658,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QVector_3900,
    array_QVector_3900,
    copy_QVector_3900,
    release_QVector_3900,
    convertTo_QVector_3900,
    convertFrom_QVector_3900
};
