/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 146 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 41 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 44 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 252 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 47 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 240 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 50 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 53 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 56 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 59 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 62 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 149 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 65 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 68 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qthread.sip"
#include <qthread.h>
#line 71 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 74 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qregexp.sip"
#include <qregexp.h>
#line 77 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 80 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
#line 32 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
// This is needed by the tr() handwritten implementation.
#include <qcoreapplication.h>


// These are the helper functions for QObject::findChild() and
// QObject::findChildren.

// Wrap the given type in a 1-tuple.
static PyObject *qtcore_type_to_tuple(PyObject *type)
{
    PyObject *tuple = PyTuple_New(1);

    if (tuple)
    {
        Py_INCREF(type);
        PyTuple_SetItem(tuple, 0, type);
    }

    return tuple;
}


// Check all elements of a given tuple are type objects and return a new
// reference to the tuple if so.
static PyObject *qtcore_check_tuple_types(PyObject *types)
{
    for (Py_ssize_t i = 0; i < PyTuple_Size(types); ++i)
        if (!PyObject_TypeCheck(PyTuple_GetItem(types, i), &PyType_Type))
        {
            PyErr_SetString(PyExc_TypeError,
                    "all elements of the types argument must be type objects");
            return 0;
        }

    Py_INCREF(types);
    return types;
}


// Do the main work of finding a child.
static PyObject *qtcore_do_find_child(const QObject *parent, PyObject *types, const QString &name, Qt::FindChildOptions options)
{
    const QObjectList &children = parent->children();
    int i;

    for (i = 0; i < children.size(); ++i)
    {
        QObject *obj = children.at(i);
        PyObject *pyo = sipConvertFromType(obj, sipType_QObject, 0);

        if (!pyo)
            return 0;

        // Allow for proxies.
        QObject *resolved = reinterpret_cast<QObject *>(sipGetAddress((sipSimpleWrapper *)pyo));

        if (name.isNull() || resolved->objectName() == name)
            for (Py_ssize_t t = 0; t < PyTuple_Size(types); ++t)
                if (PyType_IsSubtype(Py_TYPE(pyo), (PyTypeObject *)PyTuple_GetItem(types, t)))
                    return pyo;

        Py_DECREF(pyo);
    }

    if (options == Qt::FindChildrenRecursively)
        for (i = 0; i < children.size(); ++i)
        {
            PyObject *pyo = qtcore_do_find_child(children.at(i), types, name, options);

            if (pyo != Py_None)
                return pyo;

            Py_DECREF(pyo);
        }

    Py_INCREF(Py_None);
    return Py_None;
}


// Find a child that is one of a number of types and with an optional name.
static PyObject *qtcore_FindChild(const QObject *parent, PyObject *types, const QString &name, Qt::FindChildOptions options)
{
    // Check that the types checking was successful.
    if (!types)
        return 0;

    PyObject *child = qtcore_do_find_child(parent, types, name, options);

    Py_DECREF(types);

    return child;
}


// Do the main work of finding the children with a string name.
static bool qtcore_do_find_children(const QObject *parent, PyObject *types, const QString &name, Qt::FindChildOptions options, PyObject *list)
{
    const QObjectList &children = parent->children();
    int i;

    for (i = 0; i < children.size(); ++i)
    {
        QObject *obj = children.at(i);
        PyObject *pyo = sipConvertFromType(obj, sipType_QObject, 0);

        if (!pyo)
            return false;

        // Allow for proxies.
        QObject *resolved = reinterpret_cast<QObject *>(sipGetAddress((sipSimpleWrapper *)pyo));

        if (name.isNull() || resolved->objectName() == name)
            for (Py_ssize_t t = 0; t < PyTuple_Size(types); ++t)
                if (PyType_IsSubtype(Py_TYPE(pyo), (PyTypeObject *)PyTuple_GetItem(types, t)))
                    if (PyList_Append(list, pyo) < 0)
                    {
                        Py_DECREF(pyo);
                        return false;
                    }

        Py_DECREF(pyo);

        if (options == Qt::FindChildrenRecursively)
        {
            bool ok = qtcore_do_find_children(obj, types, name, options, list);

            if (!ok)
                return false;
        }
    }

    return true;
}


// Find a child that is one of a number of types and with an optional string
// name.
static PyObject *qtcore_FindChildren(const QObject *parent, PyObject *types, const QString &name, Qt::FindChildOptions options)
{
    // Check that the types checking was successful.
    if (!types)
        return 0;

    PyObject *list = PyList_New(0);

    if (list)
        if (!qtcore_do_find_children(parent, types, name, options, list))
            Py_DECREF(list);

    Py_DECREF(types);

    return list;
}


// Do the main work of finding the children with a QRegExp name.
static bool qtcore_do_find_children(const QObject *parent, PyObject *types, const QRegExp &re, Qt::FindChildOptions options, PyObject *list)
{
    const QObjectList &children = parent->children();
    int i;

    for (i = 0; i < children.size(); ++i)
    {
        QObject *obj = children.at(i);
        PyObject *pyo = sipConvertFromType(obj, sipType_QObject, 0);

        if (!pyo)
            return false;

        if (re.indexIn(obj->objectName()) >= 0)
            for (Py_ssize_t t = 0; t < PyTuple_Size(types); ++t)
                if (PyType_IsSubtype(Py_TYPE(pyo), (PyTypeObject *)PyTuple_GetItem(types, t)))
                    if (PyList_Append(list, pyo) < 0)
                    {
                        Py_DECREF(pyo);
                        return false;
                    }

        Py_DECREF(pyo);

        if (options == Qt::FindChildrenRecursively)
        {
            bool ok = qtcore_do_find_children(obj, types, re, options, list);

            if (!ok)
                return false;
        }
    }

    return true;
}


// Find a child that is one of a number of types and with an optional QRegExp
// name.
static PyObject *qtcore_FindChildren(const QObject *parent, PyObject *types, const QRegExp &re, Qt::FindChildOptions options)
{
    // Check that the types checking was successful.
    if (!types)
        return 0;

    PyObject *list = PyList_New(0);

    if (list)
        if (!qtcore_do_find_children(parent, types, re, options, list))
            Py_DECREF(list);

    Py_DECREF(types);

    return list;
}


// Do the main work of finding the children with a QRegularExpression name.
static bool qtcore_do_find_children(const QObject *parent, PyObject *types, const QRegularExpression &re, Qt::FindChildOptions options, PyObject *list)
{
    const QObjectList &children = parent->children();
    int i;

    for (i = 0; i < children.size(); ++i)
    {
        QObject *obj = children.at(i);
        PyObject *pyo = sipConvertFromType(obj, sipType_QObject, 0);

        if (!pyo)
            return false;

        QRegularExpressionMatch m = re.match(obj->objectName());
        
        if (m.hasMatch())
            for (Py_ssize_t t = 0; t < PyTuple_Size(types); ++t)
                if (PyType_IsSubtype(Py_TYPE(pyo), (PyTypeObject *)PyTuple_GetItem(types, t)))
                    if (PyList_Append(list, pyo) < 0)
                    {
                        Py_DECREF(pyo);
                        return false;
                    }

        Py_DECREF(pyo);

        if (options == Qt::FindChildrenRecursively)
        {
            bool ok = qtcore_do_find_children(obj, types, re, options, list);

            if (!ok)
                return false;
        }
    }

    return true;
}


// Find a child that is one of a number of types and with an optional
// QRegularExpression name.
static PyObject *qtcore_FindChildren(const QObject *parent, PyObject *types, const QRegularExpression &re, Qt::FindChildOptions options)
{
    // Check that the types checking was successful.
    if (!types)
        return 0;

    PyObject *list = PyList_New(0);

    if (list)
        if (!qtcore_do_find_children(parent, types, re, options, list))
            Py_DECREF(list);

    Py_DECREF(types);

    return list;
}
#line 354 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"


class sipQObject : public ::QObject
{
public:
    sipQObject(::QObject*);
    virtual ~sipQObject();

    int qt_metacall(QMetaObject::Call, int, void **) SIP_OVERRIDE;
    void *qt_metacast(const char *) SIP_OVERRIDE;
    const QMetaObject *metaObject() const SIP_OVERRIDE;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void disconnectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void connectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void customEvent(::QEvent*) SIP_OVERRIDE;
    void childEvent(::QChildEvent*) SIP_OVERRIDE;
    void timerEvent(::QTimerEvent*) SIP_OVERRIDE;
    bool eventFilter(::QObject*, ::QEvent*) SIP_OVERRIDE;
    bool event(::QEvent*) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQObject(const sipQObject &);
    sipQObject &operator = (const sipQObject &);

    char sipPyMethods[7];
};

sipQObject::sipQObject(::QObject*a0): ::QObject(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQObject::~sipQObject()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

const QMetaObject *sipQObject::metaObject() const
{
    if (sipGetInterpreter())
        return QObject::d_ptr->metaObject ? QObject::d_ptr->dynamicMetaObject() : sip_QtCore_qt_metaobject(sipPySelf, sipType_QObject);

    return ::QObject::metaObject();
}

int sipQObject::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    _id = ::QObject::qt_metacall(_c, _id, _a);

    if (_id >= 0)
    {
        SIP_BLOCK_THREADS
        _id = sip_QtCore_qt_metacall(sipPySelf, sipType_QObject, _c, _id, _a);
        SIP_UNBLOCK_THREADS
    }

    return _id;
}

void *sipQObject::qt_metacast(const char *_clname)
{
    void *sipCpp;

    return (sip_QtCore_qt_metacast(sipPySelf, sipType_QObject, _clname, &sipCpp) ? sipCpp : ::QObject::qt_metacast(_clname));
}

void sipQObject::disconnectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_disconnectNotify);

    if (!sipMeth)
    {
        ::QObject::disconnectNotify(a0);
        return;
    }

    extern void sipVH_QtCore_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH_QtCore_5(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0);
}

void sipQObject::connectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_connectNotify);

    if (!sipMeth)
    {
        ::QObject::connectNotify(a0);
        return;
    }

    extern void sipVH_QtCore_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH_QtCore_5(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0);
}

void sipQObject::customEvent(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_customEvent);

    if (!sipMeth)
    {
        ::QObject::customEvent(a0);
        return;
    }

    extern void sipVH_QtCore_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    sipVH_QtCore_4(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0);
}

void sipQObject::childEvent(::QChildEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_childEvent);

    if (!sipMeth)
    {
        ::QObject::childEvent(a0);
        return;
    }

    extern void sipVH_QtCore_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QChildEvent*);

    sipVH_QtCore_3(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0);
}

void sipQObject::timerEvent(::QTimerEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_timerEvent);

    if (!sipMeth)
    {
        ::QObject::timerEvent(a0);
        return;
    }

    extern void sipVH_QtCore_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QTimerEvent*);

    sipVH_QtCore_2(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0);
}

bool sipQObject::eventFilter(::QObject*a0, ::QEvent*a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_eventFilter);

    if (!sipMeth)
        return ::QObject::eventFilter(a0, a1);

    extern bool sipVH_QtCore_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QObject*, ::QEvent*);

    return sipVH_QtCore_1(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0, a1);
}

bool sipQObject::event(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_event);

    if (!sipMeth)
        return ::QObject::event(a0);

    extern bool sipVH_QtCore_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    return sipVH_QtCore_0(sipGILState, sipVEH_QtCore_PyQt5, sipPySelf, sipMeth, a0);
}


PyDoc_STRVAR(doc_QObject_metaObject, "metaObject(self) -> QMetaObject|None");

extern "C" {static PyObject *meth_QObject_metaObject(PyObject *, PyObject *);}
static PyObject *meth_QObject_metaObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            const ::QMetaObject*sipRes;

            sipRes = sipCpp->metaObject();

            return sipConvertFromType(const_cast< ::QMetaObject *>(sipRes), sipType_QMetaObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_metaObject, doc_QObject_metaObject);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_pyqtConfigure, "QObject.pyqtConfigure(...)\n"
"\n"
"Each keyword argument is either the name of a Qt property or a Qt signal.\n"
"For properties the property is set to the given value which should be of an\n"
"appropriate type.\n"
"For signals the signal is connected to the given value which should be a\n"
"callable.");

extern "C" {static PyObject *meth_QObject_pyqtConfigure(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QObject_pyqtConfigure(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
#line 444 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        return qpycore_pyqtconfigure(sipSelf, sipArgs, sipKwds);
#line 589 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
}


PyDoc_STRVAR(doc_QObject___getattr__, "__getattr__(self, name: str) -> Any");

extern "C" {static PyObject *meth_QObject___getattr__(PyObject *, PyObject *);}
static PyObject *meth_QObject___getattr__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BA8", &sipSelf, sipType_QObject, &sipCpp, &a0Keep, &a0))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 449 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qpycore_qobject_getattr(sipCpp, sipSelf, a0);
#line 611 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            Py_DECREF(a0Keep);

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName___getattr__, doc_QObject___getattr__);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_event, "event(self, a0: QEvent|None) -> bool");

extern "C" {static PyObject *meth_QObject_event(PyObject *, PyObject *);}
static PyObject *meth_QObject_event(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QEvent* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QEvent, &a0))
        {
            bool sipRes;

            sipRes = (sipSelfWasArg ? sipCpp->::QObject::event(a0) : sipCpp->event(a0));

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_event, doc_QObject_event);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_eventFilter, "eventFilter(self, a0: QObject|None, a1: QEvent|None) -> bool");

extern "C" {static PyObject *meth_QObject_eventFilter(PyObject *, PyObject *);}
static PyObject *meth_QObject_eventFilter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QObject* a0;
        ::QEvent* a1;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8J8", &sipSelf, sipType_QObject, &sipCpp, sipType_QObject, &a0, sipType_QEvent, &a1))
        {
            bool sipRes;

            sipRes = (sipSelfWasArg ? sipCpp->::QObject::eventFilter(a0, a1) : sipCpp->eventFilter(a0, a1));

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_eventFilter, doc_QObject_eventFilter);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_tr, "tr(self, sourceText: str, disambiguation: str = None, n: int = -1) -> str");

extern "C" {static PyObject *meth_QObject_tr(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QObject_tr(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const char* a1 = 0;
        PyObject *a1Keep = 0;
        int a2 = -1;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_disambiguation,
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BA8|AAi", &sipSelf, sipType_QObject, &sipCpp, &a0Keep, &a0, &a1Keep, &a1, &a2))
        {
            ::QString*sipRes = 0;

#line 456 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        // Note that tr() is really a static method.  We pretend it isn't so we can use
        // self to get hold of the class name.
        
        sipRes = new QString(QCoreApplication::translate(sipPyTypeName(Py_TYPE(sipSelf)), a0, a1, a2));
#line 711 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            Py_DECREF(a0Keep);
            Py_XDECREF(a1Keep);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_tr, doc_QObject_tr);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_findChild, "findChild(self, type: type[QObjectT], name: str|None = '', options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> QObjectT\n"
"findChild(self, types: tuple[type[QObjectT], ...], name: str|None = '', options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> QObjectT");

extern "C" {static PyObject *meth_QObject_findChild(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QObject_findChild(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_name,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BT|J1J1", &sipSelf, sipType_QObject, &sipCpp, &PyType_Type, &a0, sipType_QString, &a1, &a1State, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 464 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChild(sipCpp, qtcore_type_to_tuple(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 759 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
        PyObject * a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_name,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BT|J1J1", &sipSelf, sipType_QObject, &sipCpp, &PyTuple_Type, &a0, sipType_QString, &a1, &a1State, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 472 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChild(sipCpp, qtcore_check_tuple_types(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 796 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_findChild, doc_QObject_findChild);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_findChildren, "findChildren(self, type: type[QObjectT], name: str|None = '', options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> list[QObjectT]\n"
"findChildren(self, types: tuple[type[QObjectT], ...], name: str|None = '', options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> list[QObjectT]\n"
"findChildren(self, type: type[QObjectT], regExp: QRegExp, options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> list[QObjectT]\n"
"findChildren(self, types: tuple[type[QObjectT], ...], regExp: QRegExp, options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> list[QObjectT]\n"
"findChildren(self, type: type[QObjectT], re: QRegularExpression, options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> list[QObjectT]\n"
"findChildren(self, types: tuple[type[QObjectT], ...], re: QRegularExpression, options: Qt.FindChildOptions|Qt.FindChildOption = Qt.FindChildrenRecursively) -> list[QObjectT]");

extern "C" {static PyObject *meth_QObject_findChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QObject_findChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_name,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BT|J1J1", &sipSelf, sipType_QObject, &sipCpp, &PyType_Type, &a0, sipType_QString, &a1, &a1State, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 480 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChildren(sipCpp, qtcore_type_to_tuple(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 851 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
        PyObject * a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_name,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BT|J1J1", &sipSelf, sipType_QObject, &sipCpp, &PyTuple_Type, &a0, sipType_QString, &a1, &a1State, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 488 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChildren(sipCpp, qtcore_check_tuple_types(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 888 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
        PyObject * a0;
        const ::QRegExp* a1;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BTJ9|J1", &sipSelf, sipType_QObject, &sipCpp, &PyType_Type, &a0, sipType_QRegExp, &a1, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 496 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChildren(sipCpp, qtcore_type_to_tuple(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 923 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
        PyObject * a0;
        const ::QRegExp* a1;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BTJ9|J1", &sipSelf, sipType_QObject, &sipCpp, &PyTuple_Type, &a0, sipType_QRegExp, &a1, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 504 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChildren(sipCpp, qtcore_check_tuple_types(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 957 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
        PyObject * a0;
        const ::QRegularExpression* a1;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BTJ9|J1", &sipSelf, sipType_QObject, &sipCpp, &PyType_Type, &a0, sipType_QRegularExpression, &a1, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 512 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChildren(sipCpp, qtcore_type_to_tuple(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 991 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
        PyObject * a0;
        const ::QRegularExpression* a1;
        ::Qt::FindChildOptions a2def = Qt::FindChildrenRecursively;
        ::Qt::FindChildOptions* a2 = &a2def;
        int a2State = 0;
        const ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BTJ9|J1", &sipSelf, sipType_QObject, &sipCpp, &PyTuple_Type, &a0, sipType_QRegularExpression, &a1, sipType_Qt_FindChildOptions, &a2, &a2State))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 520 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qtcore_FindChildren(sipCpp, qtcore_check_tuple_types(a0), *a1, *a2);
        
        if (!sipRes)
            sipIsErr = 1;
#line 1025 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
            sipReleaseType(a2, sipType_Qt_FindChildOptions, a2State);

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_findChildren, doc_QObject_findChildren);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_objectName, "objectName(self) -> str");

extern "C" {static PyObject *meth_QObject_objectName(PyObject *, PyObject *);}
static PyObject *meth_QObject_objectName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->objectName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_objectName, doc_QObject_objectName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_setObjectName, "setObjectName(self, name: str|None)");

extern "C" {static PyObject *meth_QObject_setObjectName(PyObject *, PyObject *);}
static PyObject *meth_QObject_setObjectName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QObject, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setObjectName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_setObjectName, doc_QObject_setObjectName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_isWidgetType, "isWidgetType(self) -> bool");

extern "C" {static PyObject *meth_QObject_isWidgetType(PyObject *, PyObject *);}
static PyObject *meth_QObject_isWidgetType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isWidgetType();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_isWidgetType, doc_QObject_isWidgetType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_isWindowType, "isWindowType(self) -> bool");

extern "C" {static PyObject *meth_QObject_isWindowType(PyObject *, PyObject *);}
static PyObject *meth_QObject_isWindowType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isWindowType();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_isWindowType, doc_QObject_isWindowType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_signalsBlocked, "signalsBlocked(self) -> bool");

extern "C" {static PyObject *meth_QObject_signalsBlocked(PyObject *, PyObject *);}
static PyObject *meth_QObject_signalsBlocked(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->signalsBlocked();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_signalsBlocked, doc_QObject_signalsBlocked);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_blockSignals, "blockSignals(self, b: bool) -> bool");

extern "C" {static PyObject *meth_QObject_blockSignals(PyObject *, PyObject *);}
static PyObject *meth_QObject_blockSignals(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QObject, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->blockSignals(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_blockSignals, doc_QObject_blockSignals);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_thread, "thread(self) -> QThread|None");

extern "C" {static PyObject *meth_QObject_thread(PyObject *, PyObject *);}
static PyObject *meth_QObject_thread(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            ::QThread*sipRes;

            sipRes = sipCpp->thread();

            return sipConvertFromType(sipRes, sipType_QThread, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_thread, doc_QObject_thread);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_moveToThread, "moveToThread(self, thread: QThread|None)");

extern "C" {static PyObject *meth_QObject_moveToThread(PyObject *, PyObject *);}
static PyObject *meth_QObject_moveToThread(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QThread* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QThread, &a0))
        {
            sipCpp->moveToThread(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_moveToThread, doc_QObject_moveToThread);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_startTimer, "startTimer(self, interval: int, timerType: Qt.TimerType = Qt.CoarseTimer) -> int");

extern "C" {static PyObject *meth_QObject_startTimer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QObject_startTimer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::Qt::TimerType a1 = Qt::CoarseTimer;
        ::QObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_timerType,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|E", &sipSelf, sipType_QObject, &sipCpp, &a0, sipType_Qt_TimerType, &a1))
        {
            int sipRes;

            sipRes = sipCpp->startTimer(a0, a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_startTimer, doc_QObject_startTimer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_killTimer, "killTimer(self, id: int)");

extern "C" {static PyObject *meth_QObject_killTimer(PyObject *, PyObject *);}
static PyObject *meth_QObject_killTimer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QObject, &sipCpp, &a0))
        {
            sipCpp->killTimer(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_killTimer, doc_QObject_killTimer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_children, "children(self) -> list[QObject]");

extern "C" {static PyObject *meth_QObject_children(PyObject *, PyObject *);}
static PyObject *meth_QObject_children(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            ::QObjectList*sipRes;

            sipRes = new ::QObjectList(sipCpp->children());

            return sipConvertFromNewType(sipRes, sipType_QList_0101QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_children, doc_QObject_children);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_setParent, "setParent(self, a0: QObject|None)");

extern "C" {static PyObject *meth_QObject_setParent(PyObject *, PyObject *);}
static PyObject *meth_QObject_setParent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject* a0;
        sipWrapper *sipOwner = SIP_NULLPTR;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJH", &sipSelf, sipType_QObject, &sipCpp, sipType_QObject, &a0, &sipOwner))
        {
            sipCpp->setParent(a0);

            if (sipOwner)
                sipTransferTo(sipSelf, (PyObject *)sipOwner);
            else
                sipTransferBack(sipSelf);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_setParent, doc_QObject_setParent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_installEventFilter, "installEventFilter(self, a0: QObject|None)");

extern "C" {static PyObject *meth_QObject_installEventFilter(PyObject *, PyObject *);}
static PyObject *meth_QObject_installEventFilter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QObject, &a0))
        {
            sipCpp->installEventFilter(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_installEventFilter, doc_QObject_installEventFilter);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_removeEventFilter, "removeEventFilter(self, a0: QObject|None)");

extern "C" {static PyObject *meth_QObject_removeEventFilter(PyObject *, PyObject *);}
static PyObject *meth_QObject_removeEventFilter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QObject, &a0))
        {
            sipCpp->removeEventFilter(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_removeEventFilter, doc_QObject_removeEventFilter);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_dumpObjectInfo, "dumpObjectInfo(self)");

extern "C" {static PyObject *meth_QObject_dumpObjectInfo(PyObject *, PyObject *);}
static PyObject *meth_QObject_dumpObjectInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            sipCpp->dumpObjectInfo();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_dumpObjectInfo, doc_QObject_dumpObjectInfo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_dumpObjectTree, "dumpObjectTree(self)");

extern "C" {static PyObject *meth_QObject_dumpObjectTree(PyObject *, PyObject *);}
static PyObject *meth_QObject_dumpObjectTree(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            sipCpp->dumpObjectTree();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_dumpObjectTree, doc_QObject_dumpObjectTree);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_dynamicPropertyNames, "dynamicPropertyNames(self) -> list[QByteArray]");

extern "C" {static PyObject *meth_QObject_dynamicPropertyNames(PyObject *, PyObject *);}
static PyObject *meth_QObject_dynamicPropertyNames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(sipCpp->dynamicPropertyNames());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_dynamicPropertyNames, doc_QObject_dynamicPropertyNames);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_setProperty, "setProperty(self, name: str, value: Any) -> bool");

extern "C" {static PyObject *meth_QObject_setProperty(PyObject *, PyObject *);}
static PyObject *meth_QObject_setProperty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QVariant* a1;
        int a1State = 0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAAJ1", &sipSelf, sipType_QObject, &sipCpp, &a0Keep, &a0, sipType_QVariant, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->setProperty(a0, *a1);
            Py_DECREF(a0Keep);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_setProperty, doc_QObject_setProperty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_property, "property(self, name: str) -> Any");

extern "C" {static PyObject *meth_QObject_property(PyObject *, PyObject *);}
static PyObject *meth_QObject_property(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QObject, &sipCpp, &a0Keep, &a0))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->property(a0));
            Py_DECREF(a0Keep);

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_property, doc_QObject_property);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_parent, "parent(self) -> QObject|None");

extern "C" {static PyObject *meth_QObject_parent(PyObject *, PyObject *);}
static PyObject *meth_QObject_parent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            ::QObject*sipRes;

            sipRes = sipCpp->parent();

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_parent, doc_QObject_parent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_inherits, "inherits(self, classname: str) -> bool");

extern "C" {static PyObject *meth_QObject_inherits(PyObject *, PyObject *);}
static PyObject *meth_QObject_inherits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        PyObject *a0Keep;
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BAA", &sipSelf, sipType_QObject, &sipCpp, &a0Keep, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->inherits(a0);
            Py_DECREF(a0Keep);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_inherits, doc_QObject_inherits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_deleteLater, "deleteLater(self)");

extern "C" {static PyObject *meth_QObject_deleteLater(PyObject *, PyObject *);}
static PyObject *meth_QObject_deleteLater(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            sipCpp->deleteLater();

            sipTransferTo(sipSelf, SIP_NULLPTR);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_deleteLater, doc_QObject_deleteLater);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_sender, "sender(self) -> QObject|None");

extern "C" {static PyObject *meth_QObject_sender(PyObject *, PyObject *);}
static PyObject *meth_QObject_sender(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QObject, &sipCpp))
        {
            ::QObject*sipRes = 0;

#line 570 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        // sender() must be called without the GIL to avoid possible deadlocks between
        // the GIL and Qt's internal thread data mutex.
        
        Py_BEGIN_ALLOW_THREADS
        
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        sipRes = sipCpp->sender();
        #else
        sipRes = sipCpp->sipProtect_sender();
        #endif
        
        Py_END_ALLOW_THREADS
        
        if (!sipRes)
        {
            typedef QObject *(*qtcore_qobject_sender_t)();
        
            static qtcore_qobject_sender_t qtcore_qobject_sender = 0;
        
            if (!qtcore_qobject_sender)
            {
                qtcore_qobject_sender = (qtcore_qobject_sender_t)sipImportSymbol("qtcore_qobject_sender");
                Q_ASSERT(qtcore_qobject_sender);
            }
        
            sipRes = qtcore_qobject_sender();
        }
#line 1682 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_sender, doc_QObject_sender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_receivers, "receivers(self, signal: PYQT_SIGNAL) -> int");

extern "C" {static PyObject *meth_QObject_receivers(PyObject *, PyObject *);}
static PyObject *meth_QObject_receivers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pP0", &sipSelf, sipType_QObject, &sipCpp, &a0))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 601 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        // We need to handle the signal object.  Import the helper if it hasn't already
        // been done.
        typedef sipErrorState (*pyqt5_get_signal_signature_t)(PyObject *, const QObject *, const QByteArray &);
        
        static pyqt5_get_signal_signature_t pyqt5_get_signal_signature = 0;
        
        if (!pyqt5_get_signal_signature)
        {
            pyqt5_get_signal_signature = (pyqt5_get_signal_signature_t)sipImportSymbol("pyqt5_get_signal_signature");
            Q_ASSERT(pyqt5_get_signal_signature);
        }
        
        QByteArray signal_signature;
            
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        if ((sipError = pyqt5_get_signal_signature(a0, sipCpp, signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->receivers(signal_signature.constData());
        }
        #else
        if ((sipError = pyqt5_get_signal_signature(a0, static_cast<const QObject *>(sipCpp), signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->sipProtect_receivers(signal_signature.constData());
        }
        #endif
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(0, a0);
        }
#line 1740 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_receivers, doc_QObject_receivers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_timerEvent, "timerEvent(self, a0: QTimerEvent|None)");

extern "C" {static PyObject *meth_QObject_timerEvent(PyObject *, PyObject *);}
static PyObject *meth_QObject_timerEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QTimerEvent* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QTimerEvent, &a0))
        {
            (sipSelfWasArg ? sipCpp->::QObject::timerEvent(a0) : sipCpp->timerEvent(a0));

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_timerEvent, doc_QObject_timerEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_childEvent, "childEvent(self, a0: QChildEvent|None)");

extern "C" {static PyObject *meth_QObject_childEvent(PyObject *, PyObject *);}
static PyObject *meth_QObject_childEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QChildEvent* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QChildEvent, &a0))
        {
            (sipSelfWasArg ? sipCpp->::QObject::childEvent(a0) : sipCpp->childEvent(a0));

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_childEvent, doc_QObject_childEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_customEvent, "customEvent(self, a0: QEvent|None)");

extern "C" {static PyObject *meth_QObject_customEvent(PyObject *, PyObject *);}
static PyObject *meth_QObject_customEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QEvent* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pJ8", &sipSelf, sipType_QObject, &sipCpp, sipType_QEvent, &a0))
        {
            (sipSelfWasArg ? sipCpp->::QObject::customEvent(a0) : sipCpp->customEvent(a0));

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_customEvent, doc_QObject_customEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_connectNotify, "connectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QObject_connectNotify(PyObject *, PyObject *);}
static PyObject *meth_QObject_connectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pJ9", &sipSelf, sipType_QObject, &sipCpp, sipType_QMetaMethod, &a0))
        {
            (sipSelfWasArg ? sipCpp->::QObject::connectNotify(*a0) : sipCpp->connectNotify(*a0));

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_connectNotify, doc_QObject_connectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_disconnectNotify, "disconnectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QObject_disconnectNotify(PyObject *, PyObject *);}
static PyObject *meth_QObject_disconnectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pJ9", &sipSelf, sipType_QObject, &sipCpp, sipType_QMetaMethod, &a0))
        {
            (sipSelfWasArg ? sipCpp->::QObject::disconnectNotify(*a0) : sipCpp->disconnectNotify(*a0));

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_disconnectNotify, doc_QObject_disconnectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_senderSignalIndex, "senderSignalIndex(self) -> int");

extern "C" {static PyObject *meth_QObject_senderSignalIndex(PyObject *, PyObject *);}
static PyObject *meth_QObject_senderSignalIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->senderSignalIndex();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_senderSignalIndex, doc_QObject_senderSignalIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_isSignalConnected, "isSignalConnected(self, signal: QMetaMethod) -> bool");

extern "C" {static PyObject *meth_QObject_isSignalConnected(PyObject *, PyObject *);}
static PyObject *meth_QObject_isSignalConnected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaMethod* a0;
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pJ9", &sipSelf, sipType_QObject, &sipCpp, sipType_QMetaMethod, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->isSignalConnected(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_isSignalConnected, doc_QObject_isSignalConnected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QObject_disconnect, "disconnect(a0: QMetaObject.Connection) -> bool\n"
"disconnect(self)");

extern "C" {static PyObject *meth_QObject_disconnect(PyObject *, PyObject *);}
static PyObject *meth_QObject_disconnect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaObject::Connection* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9", sipType_QMetaObject_Connection, &a0))
        {
            bool sipRes;

            sipRes = ::QObject::disconnect(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QObject, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 644 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipRes = qpycore_qobject_disconnect(sipCpp);
#line 1978 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_disconnect, doc_QObject_disconnect);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QObject(void *, int);}
static void release_QObject(void *sipCppV, int)
{
    ::QObject *sipCpp = reinterpret_cast< ::QObject *>(sipCppV);

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();
}


extern "C" {static int traverse_QObject(void *, visitproc, void *);}
static int traverse_QObject(void *sipCppV, visitproc sipVisit, void *sipArg)
{
    ::QObject *sipCpp = reinterpret_cast< ::QObject *>(sipCppV);
    int sipRes;

#line 413 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
    // Traverse any saved slots we might be connected to.
    sipRes = qpycore_visitSlotProxies(sipCpp, sipVisit, sipArg);
#line 2012 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

    return sipRes;
}


extern "C" {static int clear_QObject(void *);}
static int clear_QObject(void *sipCppV)
{
    ::QObject *sipCpp = reinterpret_cast< ::QObject *>(sipCppV);
    int sipRes;

#line 418 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
    // Clear any saved slots we might be connected to.
    sipRes = qpycore_clearSlotProxies(sipCpp);
#line 2027 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

    return sipRes;
}


extern "C" {static int final_QObject(PyObject *, void *, PyObject *, PyObject **);}
static int final_QObject(PyObject *sipSelf, void *sipCppV, PyObject *sipKwds, PyObject **sipUnused)
{
    ::QObject *sipCpp = reinterpret_cast< ::QObject *>(sipCppV);

#line 307 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
    return qpycore_qobject_finalisation(sipSelf, sipCpp, sipKwds, sipUnused);
#line 2040 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"
}


extern "C" {static void *array_QObject(Py_ssize_t);}
static void *array_QObject(Py_ssize_t sipNrElem)
{
    return new ::QObject[sipNrElem];
}


extern "C" {static void array_delete_QObject(void *);}
static void array_delete_QObject(void *sipCpp)
{
    delete[] reinterpret_cast< ::QObject *>(sipCpp);
}


extern "C" {static void dealloc_QObject(sipSimpleWrapper *);}
static void dealloc_QObject(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQObject *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QObject(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QObject(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QObject(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **sipOwner, PyObject **sipParseErr)
{
    sipQObject *sipCpp = SIP_NULLPTR;

    {
        ::QObject* a0 = 0;

        static const char *sipKwdList[] = {
            sipName_parent,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|JH", sipType_QObject, &a0, sipOwner))
        {
            sipCpp = new sipQObject(a0);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QObject[] = {
    {sipName___getattr__, meth_QObject___getattr__, METH_VARARGS, doc_QObject___getattr__},
    {sipName_blockSignals, meth_QObject_blockSignals, METH_VARARGS, doc_QObject_blockSignals},
    {sipName_childEvent, meth_QObject_childEvent, METH_VARARGS, doc_QObject_childEvent},
    {sipName_children, meth_QObject_children, METH_VARARGS, doc_QObject_children},
    {sipName_connectNotify, meth_QObject_connectNotify, METH_VARARGS, doc_QObject_connectNotify},
    {sipName_customEvent, meth_QObject_customEvent, METH_VARARGS, doc_QObject_customEvent},
    {sipName_deleteLater, meth_QObject_deleteLater, METH_VARARGS, doc_QObject_deleteLater},
    {sipName_disconnect, meth_QObject_disconnect, METH_VARARGS, doc_QObject_disconnect},
    {sipName_disconnectNotify, meth_QObject_disconnectNotify, METH_VARARGS, doc_QObject_disconnectNotify},
    {sipName_dumpObjectInfo, meth_QObject_dumpObjectInfo, METH_VARARGS, doc_QObject_dumpObjectInfo},
    {sipName_dumpObjectTree, meth_QObject_dumpObjectTree, METH_VARARGS, doc_QObject_dumpObjectTree},
    {sipName_dynamicPropertyNames, meth_QObject_dynamicPropertyNames, METH_VARARGS, doc_QObject_dynamicPropertyNames},
    {sipName_event, meth_QObject_event, METH_VARARGS, doc_QObject_event},
    {sipName_eventFilter, meth_QObject_eventFilter, METH_VARARGS, doc_QObject_eventFilter},
    {sipName_findChild, SIP_MLMETH_CAST(meth_QObject_findChild), METH_VARARGS|METH_KEYWORDS, doc_QObject_findChild},
    {sipName_findChildren, SIP_MLMETH_CAST(meth_QObject_findChildren), METH_VARARGS|METH_KEYWORDS, doc_QObject_findChildren},
    {sipName_inherits, meth_QObject_inherits, METH_VARARGS, doc_QObject_inherits},
    {sipName_installEventFilter, meth_QObject_installEventFilter, METH_VARARGS, doc_QObject_installEventFilter},
    {sipName_isSignalConnected, meth_QObject_isSignalConnected, METH_VARARGS, doc_QObject_isSignalConnected},
    {sipName_isWidgetType, meth_QObject_isWidgetType, METH_VARARGS, doc_QObject_isWidgetType},
    {sipName_isWindowType, meth_QObject_isWindowType, METH_VARARGS, doc_QObject_isWindowType},
    {sipName_killTimer, meth_QObject_killTimer, METH_VARARGS, doc_QObject_killTimer},
    {sipName_metaObject, meth_QObject_metaObject, METH_VARARGS, doc_QObject_metaObject},
    {sipName_moveToThread, meth_QObject_moveToThread, METH_VARARGS, doc_QObject_moveToThread},
    {sipName_objectName, meth_QObject_objectName, METH_VARARGS, doc_QObject_objectName},
    {sipName_parent, meth_QObject_parent, METH_VARARGS, doc_QObject_parent},
    {sipName_property, meth_QObject_property, METH_VARARGS, doc_QObject_property},
    {sipName_pyqtConfigure, SIP_MLMETH_CAST(meth_QObject_pyqtConfigure), METH_VARARGS|METH_KEYWORDS, doc_QObject_pyqtConfigure},
    {sipName_receivers, meth_QObject_receivers, METH_VARARGS, doc_QObject_receivers},
    {sipName_removeEventFilter, meth_QObject_removeEventFilter, METH_VARARGS, doc_QObject_removeEventFilter},
    {sipName_sender, meth_QObject_sender, METH_VARARGS, doc_QObject_sender},
    {sipName_senderSignalIndex, meth_QObject_senderSignalIndex, METH_VARARGS, doc_QObject_senderSignalIndex},
    {sipName_setObjectName, meth_QObject_setObjectName, METH_VARARGS, doc_QObject_setObjectName},
    {sipName_setParent, meth_QObject_setParent, METH_VARARGS, doc_QObject_setParent},
    {sipName_setProperty, meth_QObject_setProperty, METH_VARARGS, doc_QObject_setProperty},
    {sipName_signalsBlocked, meth_QObject_signalsBlocked, METH_VARARGS, doc_QObject_signalsBlocked},
    {sipName_startTimer, SIP_MLMETH_CAST(meth_QObject_startTimer), METH_VARARGS|METH_KEYWORDS, doc_QObject_startTimer},
    {sipName_thread, meth_QObject_thread, METH_VARARGS, doc_QObject_thread},
    {sipName_timerEvent, meth_QObject_timerEvent, METH_VARARGS, doc_QObject_timerEvent},
    {sipName_tr, SIP_MLMETH_CAST(meth_QObject_tr), METH_VARARGS|METH_KEYWORDS, doc_QObject_tr}
};


extern "C" {static PyObject *varget_QObject_staticMetaObject(void *, PyObject *, PyObject *);}
static PyObject *varget_QObject_staticMetaObject(void *, PyObject *, PyObject *sipPyType)
{
    PyObject *sipPy;

#line 425 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
        sipPy = qpycore_qobject_staticmetaobject(sipPyType);
#line 2148 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQObject.cpp"

    return sipPy;
}

sipVariableDef variables_QObject[] = {
    {ClassVariable, sipName_staticMetaObject, (PyMethodDef *)varget_QObject_staticMetaObject, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QObject, "\1QObject(parent: QObject|None = None)");


extern "C" {static int emit_QObject_destroyed(void *, PyObject *);}

static int emit_QObject_destroyed(void *sipCppV, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    ::QObject *sipCpp = reinterpret_cast< ::QObject *>(sipCppV);

    {
        ::QObject* a0 = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "|J8", sipType_QObject, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->destroyed(a0);
            Py_END_ALLOW_THREADS


            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QObject, sipName_destroyed, SIP_NULLPTR);

    return -1;
}


/* Define this type's signals. */
static const pyqt5QtSignal signals_QObject[] = {
    {"objectNameChanged(QString)", "\1objectNameChanged(self, objectName: str|None)", SIP_NULLPTR, SIP_NULLPTR},
    {"destroyed(QObject*)", "\1destroyed(self, object: QObject|None = None)", SIP_NULLPTR, emit_QObject_destroyed},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt5ClassPluginDef plugin_QObject = {
    &::QObject::staticMetaObject,
    0,
    signals_QObject,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QObject = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_NONLAZY|SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QObject,
        SIP_NULLPTR,
        &plugin_QObject,
    },
    {
        sipNameNr_QObject,
        {0, 0, 1},
        40, methods_QObject,
        0, SIP_NULLPTR,
        1, variables_QObject,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QObject,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QObject,
    traverse_QObject,
    clear_QObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QObject,
    SIP_NULLPTR,
    array_QObject,
    SIP_NULLPTR,
    release_QObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    final_QObject,
    SIP_NULLPTR,
    array_delete_QObject,
    sizeof (::QObject),
};
