#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#ifdef _MSC_VER
#define LZMA_API_STATIC
#endif
#include <lzma.h>
#include <stdlib.h>
void _pylzma_stream_init(lzma_stream *strm) {
    lzma_stream tmp = LZMA_STREAM_INIT; // macro from lzma.h
    *strm = tmp;
}

uint32_t _pylzma_block_header_size_decode(uint32_t b) {
    return lzma_block_header_size_decode(b); // macro from lzma.h
}


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 144), // _Bool()(int)
/*  1 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_block *, lzma_allocator *, uint8_t const *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 147), // lzma_block *
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 146), // lzma_allocator *
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 161), // uint8_t const *
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_block *, uint64_t)
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_filter *, lzma_allocator *, uint8_t const *, size_t)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 149), // lzma_filter *
/* 14 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_filter const *, uint8_t *)
/* 19 */ _CFFI_OP(_CFFI_OP_POINTER, 149), // lzma_filter const *
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 161), // uint8_t *
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_index * *, uint64_t *, lzma_allocator *, uint8_t const *, size_t *, size_t)
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 31), // lzma_index * *
/* 24 */ _CFFI_OP(_CFFI_OP_POINTER, 10), // uint64_t *
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 16), // size_t *
/* 28 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_index *, lzma_index *, lzma_allocator *)
/* 31 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // lzma_index *
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_index *, uint64_t)
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_index_iter *, int)
/* 40 */ _CFFI_OP(_CFFI_OP_POINTER, 151), // lzma_index_iter *
/* 41 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_index_iter *, uint64_t)
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 45 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_options_lzma *, uint32_t)
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 155), // lzma_options_lzma *
/* 49 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, int)
/* 52 */ _CFFI_OP(_CFFI_OP_POINTER, 157), // lzma_stream *
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, lzma_block *)
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, lzma_filter const *)
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, lzma_filter const *, int)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 66 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, lzma_options_lzma *)
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, uint32_t, int)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 74 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 75 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, uint64_t)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 79 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream *, uint64_t, uint32_t)
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 83 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 84 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream const *)
/* 87 */ _CFFI_OP(_CFFI_OP_POINTER, 157), // lzma_stream const *
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream_flags *, uint8_t const *)
/* 90 */ _CFFI_OP(_CFFI_OP_POINTER, 158), // lzma_stream_flags *
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(lzma_stream_flags const *, lzma_stream_flags const *)
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 158), // lzma_stream_flags const *
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // int()(uint32_t *, lzma_filter const *)
/* 98 */ _CFFI_OP(_CFFI_OP_POINTER, 49), // uint32_t *
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 31), // lzma_index *()(lzma_allocator *)
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 31), // lzma_index *()(lzma_index const *, lzma_allocator *)
/* 105 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // lzma_index const *
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint64_t()(lzma_index const *)
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 105),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 115), // void *()(size_t)
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 115), // void *()(void *, size_t)
/* 115 */ _CFFI_OP(_CFFI_OP_POINTER, 165), // void *
/* 116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 115), // void *()(void *, size_t, size_t)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 120 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 121 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 165), // void()(lzma_index *, lzma_allocator *)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 165), // void()(lzma_index_iter *, lzma_index const *)
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 105),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 165), // void()(lzma_stream *)
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 165), // void()(uint32_t)
/* 135 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 165), // void()(void *)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 165), // void()(void *, void *)
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 115),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 145 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // lzma_action
/* 146 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // lzma_allocator
/* 147 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // lzma_block
/* 148 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // lzma_check
/* 149 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // lzma_filter
/* 150 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // lzma_index
/* 151 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // lzma_index_iter
/* 152 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // lzma_index_iter_mode
/* 153 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // lzma_options_bcj
/* 154 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // lzma_options_delta
/* 155 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // lzma_options_lzma
/* 156 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // lzma_ret
/* 157 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // lzma_stream
/* 158 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // lzma_stream_flags
/* 159 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct $1
/* 160 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct $2
/* 161 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 162 */ _CFFI_OP(_CFFI_OP_POINTER, 118), // void *(*)(void *, size_t, size_t)
/* 163 */ _CFFI_OP(_CFFI_OP_POINTER, 165), // void const *
/* 164 */ _CFFI_OP(_CFFI_OP_POINTER, 140), // void(*)(void *, void *)
/* 165 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_LZMA_RUN(unsigned long long *o)
{
  int n = (LZMA_RUN) <= 0;
  *o = (unsigned long long)((LZMA_RUN) | 0);  /* check that LZMA_RUN is an integer */
  return n;
}

static int _cffi_const_LZMA_FINISH(unsigned long long *o)
{
  int n = (LZMA_FINISH) <= 0;
  *o = (unsigned long long)((LZMA_FINISH) | 0);  /* check that LZMA_FINISH is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_allocator(lzma_allocator *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void *(* *tmp)(void *, size_t, size_t) = &p->alloc; (void)tmp; }
  { void(* *tmp)(void *, void *) = &p->free; (void)tmp; }
  { void * *tmp = &p->opaque; (void)tmp; }
}
struct _cffi_align_typedef_lzma_allocator { char x; lzma_allocator y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_block(lzma_block *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'lzma_block.version' is an integer */
  (void)((p->header_size) | 0);  /* check that 'lzma_block.header_size' is an integer */
  (void)((p->check) | 0);  /* check that 'lzma_block.check' is an integer */
  (void)((p->compressed_size) | 0);  /* check that 'lzma_block.compressed_size' is an integer */
  { lzma_filter * *tmp = &p->filters; (void)tmp; }
}
struct _cffi_align_typedef_lzma_block { char x; lzma_block y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_filter(lzma_filter *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->id) | 0);  /* check that 'lzma_filter.id' is an integer */
  { void * *tmp = &p->options; (void)tmp; }
}
struct _cffi_align_typedef_lzma_filter { char x; lzma_filter y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_index_iter(lzma_index_iter *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  /* cannot generate 'struct $1' in field 'stream': unknown type name */
  /* cannot generate 'struct $2' in field 'block': unknown type name */
}
struct _cffi_align_typedef_lzma_index_iter { char x; lzma_index_iter y; };

static int _cffi_const_LZMA_INDEX_ITER_ANY(unsigned long long *o)
{
  int n = (LZMA_INDEX_ITER_ANY) <= 0;
  *o = (unsigned long long)((LZMA_INDEX_ITER_ANY) | 0);  /* check that LZMA_INDEX_ITER_ANY is an integer */
  return n;
}

static int _cffi_const_LZMA_INDEX_ITER_STREAM(unsigned long long *o)
{
  int n = (LZMA_INDEX_ITER_STREAM) <= 0;
  *o = (unsigned long long)((LZMA_INDEX_ITER_STREAM) | 0);  /* check that LZMA_INDEX_ITER_STREAM is an integer */
  return n;
}

static int _cffi_const_LZMA_INDEX_ITER_BLOCK(unsigned long long *o)
{
  int n = (LZMA_INDEX_ITER_BLOCK) <= 0;
  *o = (unsigned long long)((LZMA_INDEX_ITER_BLOCK) | 0);  /* check that LZMA_INDEX_ITER_BLOCK is an integer */
  return n;
}

static int _cffi_const_LZMA_INDEX_ITER_NONEMPTY_BLOCK(unsigned long long *o)
{
  int n = (LZMA_INDEX_ITER_NONEMPTY_BLOCK) <= 0;
  *o = (unsigned long long)((LZMA_INDEX_ITER_NONEMPTY_BLOCK) | 0);  /* check that LZMA_INDEX_ITER_NONEMPTY_BLOCK is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_options_bcj(lzma_options_bcj *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->start_offset) | 0);  /* check that 'lzma_options_bcj.start_offset' is an integer */
}
struct _cffi_align_typedef_lzma_options_bcj { char x; lzma_options_bcj y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_options_delta(lzma_options_delta *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->type) | 0);  /* check that 'lzma_options_delta.type' is an integer */
  (void)((p->dist) | 0);  /* check that 'lzma_options_delta.dist' is an integer */
}
struct _cffi_align_typedef_lzma_options_delta { char x; lzma_options_delta y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_options_lzma(lzma_options_lzma *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->dict_size) | 0);  /* check that 'lzma_options_lzma.dict_size' is an integer */
  (void)((p->lc) | 0);  /* check that 'lzma_options_lzma.lc' is an integer */
  (void)((p->lp) | 0);  /* check that 'lzma_options_lzma.lp' is an integer */
  (void)((p->pb) | 0);  /* check that 'lzma_options_lzma.pb' is an integer */
  (void)((p->mode) | 0);  /* check that 'lzma_options_lzma.mode' is an integer */
  (void)((p->nice_len) | 0);  /* check that 'lzma_options_lzma.nice_len' is an integer */
  (void)((p->mf) | 0);  /* check that 'lzma_options_lzma.mf' is an integer */
  (void)((p->depth) | 0);  /* check that 'lzma_options_lzma.depth' is an integer */
}
struct _cffi_align_typedef_lzma_options_lzma { char x; lzma_options_lzma y; };

static int _cffi_const_LZMA_OK(unsigned long long *o)
{
  int n = (LZMA_OK) <= 0;
  *o = (unsigned long long)((LZMA_OK) | 0);  /* check that LZMA_OK is an integer */
  return n;
}

static int _cffi_const_LZMA_STREAM_END(unsigned long long *o)
{
  int n = (LZMA_STREAM_END) <= 0;
  *o = (unsigned long long)((LZMA_STREAM_END) | 0);  /* check that LZMA_STREAM_END is an integer */
  return n;
}

static int _cffi_const_LZMA_NO_CHECK(unsigned long long *o)
{
  int n = (LZMA_NO_CHECK) <= 0;
  *o = (unsigned long long)((LZMA_NO_CHECK) | 0);  /* check that LZMA_NO_CHECK is an integer */
  return n;
}

static int _cffi_const_LZMA_UNSUPPORTED_CHECK(unsigned long long *o)
{
  int n = (LZMA_UNSUPPORTED_CHECK) <= 0;
  *o = (unsigned long long)((LZMA_UNSUPPORTED_CHECK) | 0);  /* check that LZMA_UNSUPPORTED_CHECK is an integer */
  return n;
}

static int _cffi_const_LZMA_GET_CHECK(unsigned long long *o)
{
  int n = (LZMA_GET_CHECK) <= 0;
  *o = (unsigned long long)((LZMA_GET_CHECK) | 0);  /* check that LZMA_GET_CHECK is an integer */
  return n;
}

static int _cffi_const_LZMA_MEM_ERROR(unsigned long long *o)
{
  int n = (LZMA_MEM_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_MEM_ERROR) | 0);  /* check that LZMA_MEM_ERROR is an integer */
  return n;
}

static int _cffi_const_LZMA_MEMLIMIT_ERROR(unsigned long long *o)
{
  int n = (LZMA_MEMLIMIT_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_MEMLIMIT_ERROR) | 0);  /* check that LZMA_MEMLIMIT_ERROR is an integer */
  return n;
}

static int _cffi_const_LZMA_FORMAT_ERROR(unsigned long long *o)
{
  int n = (LZMA_FORMAT_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_FORMAT_ERROR) | 0);  /* check that LZMA_FORMAT_ERROR is an integer */
  return n;
}

static int _cffi_const_LZMA_OPTIONS_ERROR(unsigned long long *o)
{
  int n = (LZMA_OPTIONS_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_OPTIONS_ERROR) | 0);  /* check that LZMA_OPTIONS_ERROR is an integer */
  return n;
}

static int _cffi_const_LZMA_DATA_ERROR(unsigned long long *o)
{
  int n = (LZMA_DATA_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_DATA_ERROR) | 0);  /* check that LZMA_DATA_ERROR is an integer */
  return n;
}

static int _cffi_const_LZMA_BUF_ERROR(unsigned long long *o)
{
  int n = (LZMA_BUF_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_BUF_ERROR) | 0);  /* check that LZMA_BUF_ERROR is an integer */
  return n;
}

static int _cffi_const_LZMA_PROG_ERROR(unsigned long long *o)
{
  int n = (LZMA_PROG_ERROR) <= 0;
  *o = (unsigned long long)((LZMA_PROG_ERROR) | 0);  /* check that LZMA_PROG_ERROR is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_stream(lzma_stream *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { uint8_t const * *tmp = &p->next_in; (void)tmp; }
  (void)((p->avail_in) | 0);  /* check that 'lzma_stream.avail_in' is an integer */
  (void)((p->total_in) | 0);  /* check that 'lzma_stream.total_in' is an integer */
  { uint8_t * *tmp = &p->next_out; (void)tmp; }
  (void)((p->avail_out) | 0);  /* check that 'lzma_stream.avail_out' is an integer */
  (void)((p->total_out) | 0);  /* check that 'lzma_stream.total_out' is an integer */
}
struct _cffi_align_typedef_lzma_stream { char x; lzma_stream y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_lzma_stream_flags(lzma_stream_flags *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'lzma_stream_flags.version' is an integer */
  (void)((p->backward_size) | 0);  /* check that 'lzma_stream_flags.backward_size' is an integer */
  (void)((p->check) | 0);  /* check that 'lzma_stream_flags.check' is an integer */
}
struct _cffi_align_typedef_lzma_stream_flags { char x; lzma_stream_flags y; };

static void _cffi_d__pylzma_block_header_size_decode(uint32_t x0)
{
  _pylzma_block_header_size_decode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__pylzma_block_header_size_decode(PyObject *self, PyObject *arg0)
{
  uint32_t x0;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _pylzma_block_header_size_decode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__pylzma_block_header_size_decode _cffi_d__pylzma_block_header_size_decode
#endif

static void _cffi_d__pylzma_stream_init(lzma_stream * x0)
{
  _pylzma_stream_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__pylzma_stream_init(PyObject *self, PyObject *arg0)
{
  lzma_stream * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _pylzma_stream_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__pylzma_stream_init _cffi_d__pylzma_stream_init
#endif

static void _cffi_d_free(void * x0)
{
  free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_free _cffi_d_free
#endif

static int _cffi_d_lzma_alone_decoder(lzma_stream * x0, uint64_t x1)
{
  return lzma_alone_decoder(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_alone_decoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_alone_decoder", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_alone_decoder(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_alone_decoder _cffi_d_lzma_alone_decoder
#endif

static int _cffi_d_lzma_alone_encoder(lzma_stream * x0, lzma_options_lzma * x1)
{
  return lzma_alone_encoder(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_alone_encoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  lzma_options_lzma * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_alone_encoder", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_options_lzma *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_alone_encoder(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_alone_encoder _cffi_d_lzma_alone_encoder
#endif

static int _cffi_d_lzma_auto_decoder(lzma_stream * x0, uint64_t x1, uint32_t x2)
{
  return lzma_auto_decoder(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_auto_decoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  uint64_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "lzma_auto_decoder", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_auto_decoder(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_auto_decoder _cffi_d_lzma_auto_decoder
#endif

static int _cffi_d_lzma_block_compressed_size(lzma_block * x0, uint64_t x1)
{
  return lzma_block_compressed_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_block_compressed_size(PyObject *self, PyObject *args)
{
  lzma_block * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_block_compressed_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_block *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_block_compressed_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_block_compressed_size _cffi_d_lzma_block_compressed_size
#endif

static int _cffi_d_lzma_block_decoder(lzma_stream * x0, lzma_block * x1)
{
  return lzma_block_decoder(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_block_decoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  lzma_block * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_block_decoder", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_block *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_block_decoder(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_block_decoder _cffi_d_lzma_block_decoder
#endif

static int _cffi_d_lzma_block_header_decode(lzma_block * x0, lzma_allocator * x1, uint8_t const * x2)
{
  return lzma_block_header_decode(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_block_header_decode(PyObject *self, PyObject *args)
{
  lzma_block * x0;
  lzma_allocator * x1;
  uint8_t const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "lzma_block_header_decode", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_block *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_block_header_decode(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_block_header_decode _cffi_d_lzma_block_header_decode
#endif

static _Bool _cffi_d_lzma_check_is_supported(int x0)
{
  return lzma_check_is_supported(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_check_is_supported(PyObject *self, PyObject *arg0)
{
  int x0;
  _Bool result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_check_is_supported(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  return pyresult;
}
#else
#  define _cffi_f_lzma_check_is_supported _cffi_d_lzma_check_is_supported
#endif

static int _cffi_d_lzma_code(lzma_stream * x0, int x1)
{
  return lzma_code(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_code(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_code", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_code(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_code _cffi_d_lzma_code
#endif

static int _cffi_d_lzma_easy_encoder(lzma_stream * x0, uint32_t x1, int x2)
{
  return lzma_easy_encoder(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_easy_encoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  uint32_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "lzma_easy_encoder", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_easy_encoder(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_easy_encoder _cffi_d_lzma_easy_encoder
#endif

static void _cffi_d_lzma_end(lzma_stream * x0)
{
  lzma_end(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_end(PyObject *self, PyObject *arg0)
{
  lzma_stream * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { lzma_end(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_lzma_end _cffi_d_lzma_end
#endif

static int _cffi_d_lzma_get_check(lzma_stream const * x0)
{
  return lzma_get_check(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_get_check(PyObject *self, PyObject *arg0)
{
  lzma_stream const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_get_check(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_get_check _cffi_d_lzma_get_check
#endif

static uint64_t _cffi_d_lzma_index_block_count(lzma_index const * x0)
{
  return lzma_index_block_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_block_count(PyObject *self, PyObject *arg0)
{
  lzma_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_block_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_block_count _cffi_d_lzma_index_block_count
#endif

static int _cffi_d_lzma_index_buffer_decode(lzma_index * * x0, uint64_t * x1, lzma_allocator * x2, uint8_t const * x3, size_t * x4, size_t x5)
{
  return lzma_index_buffer_decode(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_buffer_decode(PyObject *self, PyObject *args)
{
  lzma_index * * x0;
  uint64_t * x1;
  lzma_allocator * x2;
  uint8_t const * x3;
  size_t * x4;
  size_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "lzma_index_buffer_decode", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_buffer_decode(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_buffer_decode _cffi_d_lzma_index_buffer_decode
#endif

static int _cffi_d_lzma_index_cat(lzma_index * x0, lzma_index * x1, lzma_allocator * x2)
{
  return lzma_index_cat(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_cat(PyObject *self, PyObject *args)
{
  lzma_index * x0;
  lzma_index * x1;
  lzma_allocator * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "lzma_index_cat", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_cat(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_cat _cffi_d_lzma_index_cat
#endif

static lzma_index * _cffi_d_lzma_index_dup(lzma_index const * x0, lzma_allocator * x1)
{
  return lzma_index_dup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_dup(PyObject *self, PyObject *args)
{
  lzma_index const * x0;
  lzma_allocator * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  lzma_index * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_index_dup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_dup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(31));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_dup _cffi_d_lzma_index_dup
#endif

static void _cffi_d_lzma_index_end(lzma_index * x0, lzma_allocator * x1)
{
  lzma_index_end(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_end(PyObject *self, PyObject *args)
{
  lzma_index * x0;
  lzma_allocator * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_index_end", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { lzma_index_end(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_lzma_index_end _cffi_d_lzma_index_end
#endif

static lzma_index * _cffi_d_lzma_index_init(lzma_allocator * x0)
{
  return lzma_index_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_init(PyObject *self, PyObject *arg0)
{
  lzma_allocator * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  lzma_index * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(31));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_init _cffi_d_lzma_index_init
#endif

static void _cffi_d_lzma_index_iter_init(lzma_index_iter * x0, lzma_index const * x1)
{
  lzma_index_iter_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_iter_init(PyObject *self, PyObject *args)
{
  lzma_index_iter * x0;
  lzma_index const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_index_iter_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { lzma_index_iter_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_lzma_index_iter_init _cffi_d_lzma_index_iter_init
#endif

static int _cffi_d_lzma_index_iter_locate(lzma_index_iter * x0, uint64_t x1)
{
  return lzma_index_iter_locate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_iter_locate(PyObject *self, PyObject *args)
{
  lzma_index_iter * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_index_iter_locate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_iter_locate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_iter_locate _cffi_d_lzma_index_iter_locate
#endif

static int _cffi_d_lzma_index_iter_next(lzma_index_iter * x0, int x1)
{
  return lzma_index_iter_next(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_iter_next(PyObject *self, PyObject *args)
{
  lzma_index_iter * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_index_iter_next", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_iter_next(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_iter_next _cffi_d_lzma_index_iter_next
#endif

static uint64_t _cffi_d_lzma_index_size(lzma_index const * x0)
{
  return lzma_index_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_size(PyObject *self, PyObject *arg0)
{
  lzma_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_size _cffi_d_lzma_index_size
#endif

static int _cffi_d_lzma_index_stream_padding(lzma_index * x0, uint64_t x1)
{
  return lzma_index_stream_padding(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_stream_padding(PyObject *self, PyObject *args)
{
  lzma_index * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_index_stream_padding", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_stream_padding(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_stream_padding _cffi_d_lzma_index_stream_padding
#endif

static uint64_t _cffi_d_lzma_index_stream_size(lzma_index const * x0)
{
  return lzma_index_stream_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_stream_size(PyObject *self, PyObject *arg0)
{
  lzma_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_stream_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_stream_size _cffi_d_lzma_index_stream_size
#endif

static uint64_t _cffi_d_lzma_index_total_size(lzma_index const * x0)
{
  return lzma_index_total_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_total_size(PyObject *self, PyObject *arg0)
{
  lzma_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_total_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_total_size _cffi_d_lzma_index_total_size
#endif

static uint64_t _cffi_d_lzma_index_uncompressed_size(lzma_index const * x0)
{
  return lzma_index_uncompressed_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_index_uncompressed_size(PyObject *self, PyObject *arg0)
{
  lzma_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(105), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(105), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_index_uncompressed_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_index_uncompressed_size _cffi_d_lzma_index_uncompressed_size
#endif

static int _cffi_d_lzma_lzma_preset(lzma_options_lzma * x0, uint32_t x1)
{
  return lzma_lzma_preset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_lzma_preset(PyObject *self, PyObject *args)
{
  lzma_options_lzma * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_lzma_preset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_options_lzma *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_lzma_preset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_lzma_preset _cffi_d_lzma_lzma_preset
#endif

static int _cffi_d_lzma_properties_decode(lzma_filter * x0, lzma_allocator * x1, uint8_t const * x2, size_t x3)
{
  return lzma_properties_decode(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_properties_decode(PyObject *self, PyObject *args)
{
  lzma_filter * x0;
  lzma_allocator * x1;
  uint8_t const * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "lzma_properties_decode", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_filter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_properties_decode(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_properties_decode _cffi_d_lzma_properties_decode
#endif

static int _cffi_d_lzma_properties_encode(lzma_filter const * x0, uint8_t * x1)
{
  return lzma_properties_encode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_properties_encode(PyObject *self, PyObject *args)
{
  lzma_filter const * x0;
  uint8_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_properties_encode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_filter const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_properties_encode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_properties_encode _cffi_d_lzma_properties_encode
#endif

static int _cffi_d_lzma_properties_size(uint32_t * x0, lzma_filter const * x1)
{
  return lzma_properties_size(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_properties_size(PyObject *self, PyObject *args)
{
  uint32_t * x0;
  lzma_filter const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_properties_size", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_filter const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_properties_size(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_properties_size _cffi_d_lzma_properties_size
#endif

static int _cffi_d_lzma_raw_decoder(lzma_stream * x0, lzma_filter const * x1)
{
  return lzma_raw_decoder(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_raw_decoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  lzma_filter const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_raw_decoder", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_filter const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_raw_decoder(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_raw_decoder _cffi_d_lzma_raw_decoder
#endif

static int _cffi_d_lzma_raw_encoder(lzma_stream * x0, lzma_filter const * x1)
{
  return lzma_raw_encoder(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_raw_encoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  lzma_filter const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_raw_encoder", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_filter const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_raw_encoder(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_raw_encoder _cffi_d_lzma_raw_encoder
#endif

static int _cffi_d_lzma_stream_decoder(lzma_stream * x0, uint64_t x1, uint32_t x2)
{
  return lzma_stream_decoder(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_stream_decoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  uint64_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "lzma_stream_decoder", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_stream_decoder(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_stream_decoder _cffi_d_lzma_stream_decoder
#endif

static int _cffi_d_lzma_stream_encoder(lzma_stream * x0, lzma_filter const * x1, int x2)
{
  return lzma_stream_encoder(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_stream_encoder(PyObject *self, PyObject *args)
{
  lzma_stream * x0;
  lzma_filter const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "lzma_stream_encoder", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(19), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_filter const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(19), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_stream_encoder(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_stream_encoder _cffi_d_lzma_stream_encoder
#endif

static int _cffi_d_lzma_stream_flags_compare(lzma_stream_flags const * x0, lzma_stream_flags const * x1)
{
  return lzma_stream_flags_compare(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_stream_flags_compare(PyObject *self, PyObject *args)
{
  lzma_stream_flags const * x0;
  lzma_stream_flags const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_stream_flags_compare", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream_flags const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (lzma_stream_flags const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_stream_flags_compare(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_stream_flags_compare _cffi_d_lzma_stream_flags_compare
#endif

static int _cffi_d_lzma_stream_footer_decode(lzma_stream_flags * x0, uint8_t const * x1)
{
  return lzma_stream_footer_decode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_stream_footer_decode(PyObject *self, PyObject *args)
{
  lzma_stream_flags * x0;
  uint8_t const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_stream_footer_decode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(90), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream_flags *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(90), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_stream_footer_decode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_stream_footer_decode _cffi_d_lzma_stream_footer_decode
#endif

static int _cffi_d_lzma_stream_header_decode(lzma_stream_flags * x0, uint8_t const * x1)
{
  return lzma_stream_header_decode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_lzma_stream_header_decode(PyObject *self, PyObject *args)
{
  lzma_stream_flags * x0;
  uint8_t const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "lzma_stream_header_decode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(90), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (lzma_stream_flags *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(90), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = lzma_stream_header_decode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_lzma_stream_header_decode _cffi_d_lzma_stream_header_decode
#endif

static void * _cffi_d_malloc(size_t x0)
{
  return malloc(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_malloc(PyObject *self, PyObject *arg0)
{
  size_t x0;
  void * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = malloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(115));
  return pyresult;
}
#else
#  define _cffi_f_malloc _cffi_d_malloc
#endif

static void * _cffi_d_realloc(void * x0, size_t x1)
{
  return realloc(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_realloc(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "realloc", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(115), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(115), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = realloc(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(115));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_realloc _cffi_d_realloc
#endif

static int _cffi_const_LZMA_CHECK_CRC32(unsigned long long *o)
{
  int n = (LZMA_CHECK_CRC32) <= 0;
  *o = (unsigned long long)((LZMA_CHECK_CRC32) | 0);  /* check that LZMA_CHECK_CRC32 is an integer */
  return n;
}

static int _cffi_const_LZMA_CHECK_CRC64(unsigned long long *o)
{
  int n = (LZMA_CHECK_CRC64) <= 0;
  *o = (unsigned long long)((LZMA_CHECK_CRC64) | 0);  /* check that LZMA_CHECK_CRC64 is an integer */
  return n;
}

static int _cffi_const_LZMA_CHECK_ID_MAX(unsigned long long *o)
{
  int n = (LZMA_CHECK_ID_MAX) <= 0;
  *o = (unsigned long long)((LZMA_CHECK_ID_MAX) | 0);  /* check that LZMA_CHECK_ID_MAX is an integer */
  return n;
}

static int _cffi_const_LZMA_CHECK_NONE(unsigned long long *o)
{
  int n = (LZMA_CHECK_NONE) <= 0;
  *o = (unsigned long long)((LZMA_CHECK_NONE) | 0);  /* check that LZMA_CHECK_NONE is an integer */
  return n;
}

static int _cffi_const_LZMA_CHECK_SHA256(unsigned long long *o)
{
  int n = (LZMA_CHECK_SHA256) <= 0;
  *o = (unsigned long long)((LZMA_CHECK_SHA256) | 0);  /* check that LZMA_CHECK_SHA256 is an integer */
  return n;
}

static int _cffi_const_LZMA_CONCATENATED(unsigned long long *o)
{
  int n = (LZMA_CONCATENATED) <= 0;
  *o = (unsigned long long)((LZMA_CONCATENATED) | 0);  /* check that LZMA_CONCATENATED is an integer */
  return n;
}

static int _cffi_const_LZMA_DELTA_TYPE_BYTE(unsigned long long *o)
{
  int n = (LZMA_DELTA_TYPE_BYTE) <= 0;
  *o = (unsigned long long)((LZMA_DELTA_TYPE_BYTE) | 0);  /* check that LZMA_DELTA_TYPE_BYTE is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTERS_MAX(unsigned long long *o)
{
  int n = (LZMA_FILTERS_MAX) <= 0;
  *o = (unsigned long long)((LZMA_FILTERS_MAX) | 0);  /* check that LZMA_FILTERS_MAX is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_ARM(unsigned long long *o)
{
  int n = (LZMA_FILTER_ARM) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_ARM) | 0);  /* check that LZMA_FILTER_ARM is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_ARMTHUMB(unsigned long long *o)
{
  int n = (LZMA_FILTER_ARMTHUMB) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_ARMTHUMB) | 0);  /* check that LZMA_FILTER_ARMTHUMB is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_DELTA(unsigned long long *o)
{
  int n = (LZMA_FILTER_DELTA) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_DELTA) | 0);  /* check that LZMA_FILTER_DELTA is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_IA64(unsigned long long *o)
{
  int n = (LZMA_FILTER_IA64) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_IA64) | 0);  /* check that LZMA_FILTER_IA64 is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_LZMA1(unsigned long long *o)
{
  int n = (LZMA_FILTER_LZMA1) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_LZMA1) | 0);  /* check that LZMA_FILTER_LZMA1 is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_LZMA2(unsigned long long *o)
{
  int n = (LZMA_FILTER_LZMA2) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_LZMA2) | 0);  /* check that LZMA_FILTER_LZMA2 is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_POWERPC(unsigned long long *o)
{
  int n = (LZMA_FILTER_POWERPC) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_POWERPC) | 0);  /* check that LZMA_FILTER_POWERPC is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_SPARC(unsigned long long *o)
{
  int n = (LZMA_FILTER_SPARC) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_SPARC) | 0);  /* check that LZMA_FILTER_SPARC is an integer */
  return n;
}

static int _cffi_const_LZMA_FILTER_X86(unsigned long long *o)
{
  int n = (LZMA_FILTER_X86) <= 0;
  *o = (unsigned long long)((LZMA_FILTER_X86) | 0);  /* check that LZMA_FILTER_X86 is an integer */
  return n;
}

static int _cffi_const_LZMA_MF_BT2(unsigned long long *o)
{
  int n = (LZMA_MF_BT2) <= 0;
  *o = (unsigned long long)((LZMA_MF_BT2) | 0);  /* check that LZMA_MF_BT2 is an integer */
  return n;
}

static int _cffi_const_LZMA_MF_BT3(unsigned long long *o)
{
  int n = (LZMA_MF_BT3) <= 0;
  *o = (unsigned long long)((LZMA_MF_BT3) | 0);  /* check that LZMA_MF_BT3 is an integer */
  return n;
}

static int _cffi_const_LZMA_MF_BT4(unsigned long long *o)
{
  int n = (LZMA_MF_BT4) <= 0;
  *o = (unsigned long long)((LZMA_MF_BT4) | 0);  /* check that LZMA_MF_BT4 is an integer */
  return n;
}

static int _cffi_const_LZMA_MF_HC3(unsigned long long *o)
{
  int n = (LZMA_MF_HC3) <= 0;
  *o = (unsigned long long)((LZMA_MF_HC3) | 0);  /* check that LZMA_MF_HC3 is an integer */
  return n;
}

static int _cffi_const_LZMA_MF_HC4(unsigned long long *o)
{
  int n = (LZMA_MF_HC4) <= 0;
  *o = (unsigned long long)((LZMA_MF_HC4) | 0);  /* check that LZMA_MF_HC4 is an integer */
  return n;
}

static int _cffi_const_LZMA_MODE_FAST(unsigned long long *o)
{
  int n = (LZMA_MODE_FAST) <= 0;
  *o = (unsigned long long)((LZMA_MODE_FAST) | 0);  /* check that LZMA_MODE_FAST is an integer */
  return n;
}

static int _cffi_const_LZMA_MODE_NORMAL(unsigned long long *o)
{
  int n = (LZMA_MODE_NORMAL) <= 0;
  *o = (unsigned long long)((LZMA_MODE_NORMAL) | 0);  /* check that LZMA_MODE_NORMAL is an integer */
  return n;
}

static int _cffi_const_LZMA_PRESET_DEFAULT(unsigned long long *o)
{
  int n = (LZMA_PRESET_DEFAULT) <= 0;
  *o = (unsigned long long)((LZMA_PRESET_DEFAULT) | 0);  /* check that LZMA_PRESET_DEFAULT is an integer */
  return n;
}

static int _cffi_const_LZMA_PRESET_EXTREME(unsigned long long *o)
{
  int n = (LZMA_PRESET_EXTREME) <= 0;
  *o = (unsigned long long)((LZMA_PRESET_EXTREME) | 0);  /* check that LZMA_PRESET_EXTREME is an integer */
  return n;
}

static int _cffi_const_LZMA_STREAM_HEADER_SIZE(unsigned long long *o)
{
  int n = (LZMA_STREAM_HEADER_SIZE) <= 0;
  *o = (unsigned long long)((LZMA_STREAM_HEADER_SIZE) | 0);  /* check that LZMA_STREAM_HEADER_SIZE is an integer */
  return n;
}

static int _cffi_const_LZMA_TELL_ANY_CHECK(unsigned long long *o)
{
  int n = (LZMA_TELL_ANY_CHECK) <= 0;
  *o = (unsigned long long)((LZMA_TELL_ANY_CHECK) | 0);  /* check that LZMA_TELL_ANY_CHECK is an integer */
  return n;
}

static int _cffi_const_LZMA_TELL_NO_CHECK(unsigned long long *o)
{
  int n = (LZMA_TELL_NO_CHECK) <= 0;
  *o = (unsigned long long)((LZMA_TELL_NO_CHECK) | 0);  /* check that LZMA_TELL_NO_CHECK is an integer */
  return n;
}

static int _cffi_const_LZMA_VLI_UNKNOWN(unsigned long long *o)
{
  int n = (LZMA_VLI_UNKNOWN) <= 0;
  *o = (unsigned long long)((LZMA_VLI_UNKNOWN) | 0);  /* check that LZMA_VLI_UNKNOWN is an integer */
  return n;
}

static int _cffi_const_UINT64_MAX(unsigned long long *o)
{
  int n = (UINT64_MAX) <= 0;
  *o = (unsigned long long)((UINT64_MAX) | 0);  /* check that UINT64_MAX is an integer */
  return n;
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "LZMA_BUF_ERROR", (void *)_cffi_const_LZMA_BUF_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_CHECK_CRC32", (void *)_cffi_const_LZMA_CHECK_CRC32, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_CHECK_CRC64", (void *)_cffi_const_LZMA_CHECK_CRC64, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_CHECK_ID_MAX", (void *)_cffi_const_LZMA_CHECK_ID_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_CHECK_NONE", (void *)_cffi_const_LZMA_CHECK_NONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_CHECK_SHA256", (void *)_cffi_const_LZMA_CHECK_SHA256, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_CONCATENATED", (void *)_cffi_const_LZMA_CONCATENATED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_DATA_ERROR", (void *)_cffi_const_LZMA_DATA_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_DELTA_TYPE_BYTE", (void *)_cffi_const_LZMA_DELTA_TYPE_BYTE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTERS_MAX", (void *)_cffi_const_LZMA_FILTERS_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_ARM", (void *)_cffi_const_LZMA_FILTER_ARM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_ARMTHUMB", (void *)_cffi_const_LZMA_FILTER_ARMTHUMB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_DELTA", (void *)_cffi_const_LZMA_FILTER_DELTA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_IA64", (void *)_cffi_const_LZMA_FILTER_IA64, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_LZMA1", (void *)_cffi_const_LZMA_FILTER_LZMA1, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_LZMA2", (void *)_cffi_const_LZMA_FILTER_LZMA2, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_POWERPC", (void *)_cffi_const_LZMA_FILTER_POWERPC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_SPARC", (void *)_cffi_const_LZMA_FILTER_SPARC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FILTER_X86", (void *)_cffi_const_LZMA_FILTER_X86, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_FINISH", (void *)_cffi_const_LZMA_FINISH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_FORMAT_ERROR", (void *)_cffi_const_LZMA_FORMAT_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_GET_CHECK", (void *)_cffi_const_LZMA_GET_CHECK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_INDEX_ITER_ANY", (void *)_cffi_const_LZMA_INDEX_ITER_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_INDEX_ITER_BLOCK", (void *)_cffi_const_LZMA_INDEX_ITER_BLOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_INDEX_ITER_NONEMPTY_BLOCK", (void *)_cffi_const_LZMA_INDEX_ITER_NONEMPTY_BLOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_INDEX_ITER_STREAM", (void *)_cffi_const_LZMA_INDEX_ITER_STREAM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_MEMLIMIT_ERROR", (void *)_cffi_const_LZMA_MEMLIMIT_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_MEM_ERROR", (void *)_cffi_const_LZMA_MEM_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_MF_BT2", (void *)_cffi_const_LZMA_MF_BT2, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_MF_BT3", (void *)_cffi_const_LZMA_MF_BT3, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_MF_BT4", (void *)_cffi_const_LZMA_MF_BT4, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_MF_HC3", (void *)_cffi_const_LZMA_MF_HC3, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_MF_HC4", (void *)_cffi_const_LZMA_MF_HC4, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_MODE_FAST", (void *)_cffi_const_LZMA_MODE_FAST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_MODE_NORMAL", (void *)_cffi_const_LZMA_MODE_NORMAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_NO_CHECK", (void *)_cffi_const_LZMA_NO_CHECK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_OK", (void *)_cffi_const_LZMA_OK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_OPTIONS_ERROR", (void *)_cffi_const_LZMA_OPTIONS_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_PRESET_DEFAULT", (void *)_cffi_const_LZMA_PRESET_DEFAULT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_PRESET_EXTREME", (void *)_cffi_const_LZMA_PRESET_EXTREME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_PROG_ERROR", (void *)_cffi_const_LZMA_PROG_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_RUN", (void *)_cffi_const_LZMA_RUN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_STREAM_END", (void *)_cffi_const_LZMA_STREAM_END, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_STREAM_HEADER_SIZE", (void *)_cffi_const_LZMA_STREAM_HEADER_SIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_TELL_ANY_CHECK", (void *)_cffi_const_LZMA_TELL_ANY_CHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_TELL_NO_CHECK", (void *)_cffi_const_LZMA_TELL_NO_CHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LZMA_UNSUPPORTED_CHECK", (void *)_cffi_const_LZMA_UNSUPPORTED_CHECK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LZMA_VLI_UNKNOWN", (void *)_cffi_const_LZMA_VLI_UNKNOWN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "UINT64_MAX", (void *)_cffi_const_UINT64_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_pylzma_block_header_size_decode", (void *)_cffi_f__pylzma_block_header_size_decode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 134), (void *)_cffi_d__pylzma_block_header_size_decode },
  { "_pylzma_stream_init", (void *)_cffi_f__pylzma_stream_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 131), (void *)_cffi_d__pylzma_stream_init },
  { "free", (void *)_cffi_f_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 137), (void *)_cffi_d_free },
  { "lzma_alone_decoder", (void *)_cffi_f_lzma_alone_decoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_lzma_alone_decoder },
  { "lzma_alone_encoder", (void *)_cffi_f_lzma_alone_encoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 68), (void *)_cffi_d_lzma_alone_encoder },
  { "lzma_auto_decoder", (void *)_cffi_f_lzma_auto_decoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_lzma_auto_decoder },
  { "lzma_block_compressed_size", (void *)_cffi_f_lzma_block_compressed_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_lzma_block_compressed_size },
  { "lzma_block_decoder", (void *)_cffi_f_lzma_block_decoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 55), (void *)_cffi_d_lzma_block_decoder },
  { "lzma_block_header_decode", (void *)_cffi_f_lzma_block_header_decode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_lzma_block_header_decode },
  { "lzma_check_is_supported", (void *)_cffi_f_lzma_check_is_supported, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_lzma_check_is_supported },
  { "lzma_code", (void *)_cffi_f_lzma_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 51), (void *)_cffi_d_lzma_code },
  { "lzma_easy_encoder", (void *)_cffi_f_lzma_easy_encoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_lzma_easy_encoder },
  { "lzma_end", (void *)_cffi_f_lzma_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 131), (void *)_cffi_d_lzma_end },
  { "lzma_get_check", (void *)_cffi_f_lzma_get_check, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_lzma_get_check },
  { "lzma_index_block_count", (void *)_cffi_f_lzma_index_block_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_lzma_index_block_count },
  { "lzma_index_buffer_decode", (void *)_cffi_f_lzma_index_buffer_decode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 22), (void *)_cffi_d_lzma_index_buffer_decode },
  { "lzma_index_cat", (void *)_cffi_f_lzma_index_cat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 30), (void *)_cffi_d_lzma_index_cat },
  { "lzma_index_dup", (void *)_cffi_f_lzma_index_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_lzma_index_dup },
  { "lzma_index_end", (void *)_cffi_f_lzma_index_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_lzma_index_end },
  { "lzma_index_init", (void *)_cffi_f_lzma_index_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 101), (void *)_cffi_d_lzma_index_init },
  { "lzma_index_iter_init", (void *)_cffi_f_lzma_index_iter_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 127), (void *)_cffi_d_lzma_index_iter_init },
  { "lzma_index_iter_locate", (void *)_cffi_f_lzma_index_iter_locate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 43), (void *)_cffi_d_lzma_index_iter_locate },
  { "lzma_index_iter_next", (void *)_cffi_f_lzma_index_iter_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 39), (void *)_cffi_d_lzma_index_iter_next },
  { "lzma_index_size", (void *)_cffi_f_lzma_index_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_lzma_index_size },
  { "lzma_index_stream_padding", (void *)_cffi_f_lzma_index_stream_padding, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 35), (void *)_cffi_d_lzma_index_stream_padding },
  { "lzma_index_stream_size", (void *)_cffi_f_lzma_index_stream_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_lzma_index_stream_size },
  { "lzma_index_total_size", (void *)_cffi_f_lzma_index_total_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_lzma_index_total_size },
  { "lzma_index_uncompressed_size", (void *)_cffi_f_lzma_index_uncompressed_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_lzma_index_uncompressed_size },
  { "lzma_lzma_preset", (void *)_cffi_f_lzma_lzma_preset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_lzma_lzma_preset },
  { "lzma_properties_decode", (void *)_cffi_f_lzma_properties_decode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_lzma_properties_decode },
  { "lzma_properties_encode", (void *)_cffi_f_lzma_properties_encode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 18), (void *)_cffi_d_lzma_properties_encode },
  { "lzma_properties_size", (void *)_cffi_f_lzma_properties_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_lzma_properties_size },
  { "lzma_raw_decoder", (void *)_cffi_f_lzma_raw_decoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 59), (void *)_cffi_d_lzma_raw_decoder },
  { "lzma_raw_encoder", (void *)_cffi_f_lzma_raw_encoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 59), (void *)_cffi_d_lzma_raw_encoder },
  { "lzma_stream_decoder", (void *)_cffi_f_lzma_stream_decoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_lzma_stream_decoder },
  { "lzma_stream_encoder", (void *)_cffi_f_lzma_stream_encoder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_lzma_stream_encoder },
  { "lzma_stream_flags_compare", (void *)_cffi_f_lzma_stream_flags_compare, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 93), (void *)_cffi_d_lzma_stream_flags_compare },
  { "lzma_stream_footer_decode", (void *)_cffi_f_lzma_stream_footer_decode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 89), (void *)_cffi_d_lzma_stream_footer_decode },
  { "lzma_stream_header_decode", (void *)_cffi_f_lzma_stream_header_decode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 89), (void *)_cffi_d_lzma_stream_header_decode },
  { "malloc", (void *)_cffi_f_malloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d_malloc },
  { "realloc", (void *)_cffi_f_realloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_realloc },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "alloc", offsetof(lzma_allocator, alloc),
             sizeof(((lzma_allocator *)0)->alloc),
             _CFFI_OP(_CFFI_OP_NOOP, 162) },
  { "free", offsetof(lzma_allocator, free),
            sizeof(((lzma_allocator *)0)->free),
            _CFFI_OP(_CFFI_OP_NOOP, 164) },
  { "opaque", offsetof(lzma_allocator, opaque),
              sizeof(((lzma_allocator *)0)->opaque),
              _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "version", offsetof(lzma_block, version),
               sizeof(((lzma_block *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "header_size", offsetof(lzma_block, header_size),
                   sizeof(((lzma_block *)0)->header_size),
                   _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "check", offsetof(lzma_block, check),
             sizeof(((lzma_block *)0)->check),
             _CFFI_OP(_CFFI_OP_NOOP, 1) },
  { "compressed_size", offsetof(lzma_block, compressed_size),
                       sizeof(((lzma_block *)0)->compressed_size),
                       _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "filters", offsetof(lzma_block, filters),
               sizeof(((lzma_block *)0)->filters),
               _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "id", offsetof(lzma_filter, id),
          sizeof(((lzma_filter *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "options", offsetof(lzma_filter, options),
               sizeof(((lzma_filter *)0)->options),
               _CFFI_OP(_CFFI_OP_NOOP, 115) },
  { "stream", offsetof(lzma_index_iter, stream),
              sizeof(((lzma_index_iter *)0)->stream),
              _CFFI_OP(_CFFI_OP_NOOP, 159) },
  { "block", offsetof(lzma_index_iter, block),
             sizeof(((lzma_index_iter *)0)->block),
             _CFFI_OP(_CFFI_OP_NOOP, 160) },
  { "start_offset", offsetof(lzma_options_bcj, start_offset),
                    sizeof(((lzma_options_bcj *)0)->start_offset),
                    _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "type", offsetof(lzma_options_delta, type),
            sizeof(((lzma_options_delta *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 1) },
  { "dist", offsetof(lzma_options_delta, dist),
            sizeof(((lzma_options_delta *)0)->dist),
            _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "dict_size", offsetof(lzma_options_lzma, dict_size),
                 sizeof(((lzma_options_lzma *)0)->dict_size),
                 _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "lc", offsetof(lzma_options_lzma, lc),
          sizeof(((lzma_options_lzma *)0)->lc),
          _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "lp", offsetof(lzma_options_lzma, lp),
          sizeof(((lzma_options_lzma *)0)->lp),
          _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "pb", offsetof(lzma_options_lzma, pb),
          sizeof(((lzma_options_lzma *)0)->pb),
          _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "mode", offsetof(lzma_options_lzma, mode),
            sizeof(((lzma_options_lzma *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 1) },
  { "nice_len", offsetof(lzma_options_lzma, nice_len),
                sizeof(((lzma_options_lzma *)0)->nice_len),
                _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "mf", offsetof(lzma_options_lzma, mf),
          sizeof(((lzma_options_lzma *)0)->mf),
          _CFFI_OP(_CFFI_OP_NOOP, 1) },
  { "depth", offsetof(lzma_options_lzma, depth),
             sizeof(((lzma_options_lzma *)0)->depth),
             _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "next_in", offsetof(lzma_stream, next_in),
               sizeof(((lzma_stream *)0)->next_in),
               _CFFI_OP(_CFFI_OP_NOOP, 6) },
  { "avail_in", offsetof(lzma_stream, avail_in),
                sizeof(((lzma_stream *)0)->avail_in),
                _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "total_in", offsetof(lzma_stream, total_in),
                sizeof(((lzma_stream *)0)->total_in),
                _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "next_out", offsetof(lzma_stream, next_out),
                sizeof(((lzma_stream *)0)->next_out),
                _CFFI_OP(_CFFI_OP_NOOP, 20) },
  { "avail_out", offsetof(lzma_stream, avail_out),
                 sizeof(((lzma_stream *)0)->avail_out),
                 _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "total_out", offsetof(lzma_stream, total_out),
                 sizeof(((lzma_stream *)0)->total_out),
                 _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "version", offsetof(lzma_stream_flags, version),
               sizeof(((lzma_stream_flags *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "backward_size", offsetof(lzma_stream_flags, backward_size),
                     sizeof(((lzma_stream_flags *)0)->backward_size),
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "check", offsetof(lzma_stream_flags, check),
             sizeof(((lzma_stream_flags *)0)->check),
             _CFFI_OP(_CFFI_OP_NOOP, 1) },
  { "flags", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 94) },
  { "reserved_ptr1", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "reserved_ptr2", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "reserved_ptr3", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "number", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "block_count", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "compressed_offset", (size_t)-1,
                         (size_t)-1,
                         _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "uncompressed_offset", (size_t)-1,
                           (size_t)-1,
                           _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "compressed_size", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "uncompressed_size", (size_t)-1,
                         (size_t)-1,
                         _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "padding", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli1", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli2", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli3", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli4", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "number_in_file", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "compressed_file_offset", (size_t)-1,
                              (size_t)-1,
                              _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "uncompressed_file_offset", (size_t)-1,
                                (size_t)-1,
                                _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "number_in_stream", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "compressed_stream_offset", (size_t)-1,
                                (size_t)-1,
                                _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "uncompressed_stream_offset", (size_t)-1,
                                  (size_t)-1,
                                  _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "uncompressed_size", (size_t)-1,
                         (size_t)-1,
                         _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "unpadded_size", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "total_size", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli1", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli2", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli3", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_vli4", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "reserved_ptr1", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "reserved_ptr2", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "reserved_ptr3", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
  { "reserved_ptr4", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 163) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 159, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 32, 15 /* unnamed */ },
  { "$2", 160, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 47, 17 /* unnamed */ },
  { "$lzma_allocator", 146, 0,
    sizeof(lzma_allocator), offsetof(struct _cffi_align_typedef_lzma_allocator, y), 0, 3 },
  { "$lzma_block", 147, 0,
    sizeof(lzma_block), offsetof(struct _cffi_align_typedef_lzma_block, y), 3, 5 },
  { "$lzma_filter", 149, 0,
    sizeof(lzma_filter), offsetof(struct _cffi_align_typedef_lzma_filter, y), 8, 2 },
  { "$lzma_index", 150, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$lzma_index_iter", 151, 0,
    sizeof(lzma_index_iter), offsetof(struct _cffi_align_typedef_lzma_index_iter, y), 10, 2 },
  { "$lzma_options_bcj", 153, 0,
    sizeof(lzma_options_bcj), offsetof(struct _cffi_align_typedef_lzma_options_bcj, y), 12, 1 },
  { "$lzma_options_delta", 154, 0,
    sizeof(lzma_options_delta), offsetof(struct _cffi_align_typedef_lzma_options_delta, y), 13, 2 },
  { "$lzma_options_lzma", 155, 0,
    sizeof(lzma_options_lzma), offsetof(struct _cffi_align_typedef_lzma_options_lzma, y), 15, 8 },
  { "$lzma_stream", 157, 0,
    sizeof(lzma_stream), offsetof(struct _cffi_align_typedef_lzma_stream, y), 23, 6 },
  { "$lzma_stream_flags", 158, 0,
    sizeof(lzma_stream_flags), offsetof(struct _cffi_align_typedef_lzma_stream_flags, y), 29, 3 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$lzma_action", 145, _cffi_prim_int(sizeof(lzma_action), ((lzma_action)-1) <= 0),
    "LZMA_RUN,LZMA_FINISH" },
  { "$lzma_check", 148, _cffi_prim_int(sizeof(lzma_check), ((lzma_check)-1) <= 0),
    "" },
  { "$lzma_index_iter_mode", 152, _cffi_prim_int(sizeof(lzma_index_iter_mode), ((lzma_index_iter_mode)-1) <= 0),
    "LZMA_INDEX_ITER_ANY,LZMA_INDEX_ITER_STREAM,LZMA_INDEX_ITER_BLOCK,LZMA_INDEX_ITER_NONEMPTY_BLOCK" },
  { "$lzma_ret", 156, _cffi_prim_int(sizeof(lzma_ret), ((lzma_ret)-1) <= 0),
    "LZMA_OK,LZMA_STREAM_END,LZMA_NO_CHECK,LZMA_UNSUPPORTED_CHECK,LZMA_GET_CHECK,LZMA_MEM_ERROR,LZMA_MEMLIMIT_ERROR,LZMA_FORMAT_ERROR,LZMA_OPTIONS_ERROR,LZMA_DATA_ERROR,LZMA_BUF_ERROR,LZMA_PROG_ERROR" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "lzma_action", 145 },
  { "lzma_allocator", 146 },
  { "lzma_block", 147 },
  { "lzma_check", 148 },
  { "lzma_filter", 149 },
  { "lzma_index", 150 },
  { "lzma_index_iter", 151 },
  { "lzma_index_iter_mode", 152 },
  { "lzma_options_bcj", 153 },
  { "lzma_options_delta", 154 },
  { "lzma_options_lzma", 155 },
  { "lzma_ret", 156 },
  { "lzma_stream", 157 },
  { "lzma_stream_flags", 158 },
  { "lzma_vli", 10 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  90,  /* num_globals */
  12,  /* num_struct_unions */
  4,  /* num_enums */
  15,  /* num_typenames */
  NULL,  /* no includes */
  166,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__lzma_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__lzma_cffi(void) { return NULL; }
#  else
     init_lzma_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__lzma_cffi(void)
{
  return _cffi_init("_lzma_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_lzma_cffi(void)
{
  _cffi_init("_lzma_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
