/*
 * $Id: parsecl.c,v 1.1 2001/03/15 22:16:13 jpormann Exp jpormann $
 *
 * procstatd - Copyright (c) 1999 by Robert G. Brown, rgb@phy.duke.edu
 *         GPL version 2b (b for beverage) granted.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * procstatd - A daemon to extract statistics from /proc/stat and publish them
 *         on demand via a socket connection or broadcast.
 */

#include "procstatd.h"

/*
 *========================================================================
 * parsecl() is a "reusable" command line parser designed to parse global
 * variables.  There should be an include file with these globals and the
 * required standard includes (including getopt stuff) above.
 *========================================================================
 */

void Usage();

void parsecl(argc, argv)
char **argv;
int argc;
{			/* Start of parsecl() */

 int imax,i,c,errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;

/*
 if (argc > 2) {
   printf("argc = %d\n",argc);
   Usage();
   exit(0);
 }
*/

/*
 *========================================================================
 * Set globals from command line or defaults.
 *
 * There MUST be a one-to-one correspondance between every global
 * variable given a default.
 *========================================================================
 */
 verbose = 0;		/* default is quiet */
 daemonmode = FORK;	/* default is run as a forking user daemon */
 port = 7881;		/* with port 7881 -- this is legacy */

 while ((c = getopt(argc,argv,"d:hi:mv")) != EOF){
   switch (c){
     case 'd':
       daemonmode = FORK;
       port = atoi(optarg);
       break;
     case 'h':
       Usage();
       exit(0);
       break;
     case 'i':
       daemonmode = INETD;
       port = atoi(optarg);
       break;
     case 'm':
       daemonmode = MCAST;
       port = 0;
       break;
     case 'v':
       verbose = 1;
       break;
     case '?':
       errflg++;
   }
 }

 if(errflg || (argc - optind != 0)) {
   Usage();
   exit(0);
 }

 /* 
  * C'mon, dummy!  As an inetd or mcast daemon we cannot be verbose!   
  * At least not until I install logger calls to use syslog.  Save me
  * from myself!
  */
 if(daemonmode != FORK) verbose = 0;

}


void Usage()
{

/*
 *==========================================================================
 * Usage message describes command.  Can be called on flag or error.
 *==========================================================================
 */
 fprintf(stderr,"Usage:\n");
 fprintf(stderr,"  procd  [-i [port]] [-d port] [-m] [-v]\n");
 fprintf(stderr,"Options:\n");
 fprintf(stderr,"  -i: run procstatd as inetd daemon on port (default, port 7885)\n");
 fprintf(stderr,"  -d: run procstatd as forking daemon on port\n");
 fprintf(stderr,"  -m: run procstatd as multicast daemon (no port)\n");
 fprintf(stderr,"  -v: make procstatd verbose for debugging (forking mode only) \n");
 fprintf(stderr,"\n");

}
