/* desktop-integration.c generated by valac 0.56.17, the Vala compiler
 * generated from desktop-integration.vala, do not modify */

/*
Peek Copyright (c) 2015-2017 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _PeekParamSpecDesktopIntegration PeekParamSpecDesktopIntegration;

struct _PeekParamSpecDesktopIntegration {
	GParamSpec parent_instance;
};

static gpointer peek_desktop_integration_parent_class = NULL;
static FreedesktopFileManager1* peek_desktop_integration__file_manager_service;
static FreedesktopFileManager1* peek_desktop_integration__file_manager_service = NULL;
static gboolean peek_desktop_integration__file_manager_dbus_initialized;
static gboolean peek_desktop_integration__file_manager_dbus_initialized = FALSE;

static FreedesktopFileManager1* peek_desktop_integration_get_file_manager_service (void);
static gboolean peek_desktop_integration_file_manager_highlights_file (GAppInfo* app_info);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static gboolean peek_desktop_integration_xdg_current_desktop_contains (const gchar* text);
static gchar* peek_desktop_integration_get_theme_name_from_settings_file (void);
static void peek_desktop_integration_finalize (PeekDesktopIntegration * obj);
static GType peek_desktop_integration_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

gboolean
peek_desktop_integration_launch_file_manager (GFile* file)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	FreedesktopFileManager1* _tmp2_;
	FreedesktopFileManager1* _tmp3_;
	GFile* parent = NULL;
	GFile* _tmp15_;
	gboolean _tmp63_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	g_debug ("desktop-integration.vala:39: File URI: %s\n", _tmp1_);
	_tmp2_ = peek_desktop_integration_get_file_manager_service ();
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		{
			const gchar* _tmp4_;
			FreedesktopFileManager1* _tmp5_;
			FreedesktopFileManager1* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp4_ = uri;
			g_debug ("desktop-integration.vala:44: Launching org.freedesktop.FileManager1 fo" \
"r URI: %s\n", _tmp4_);
			_tmp5_ = peek_desktop_integration_get_file_manager_service ();
			_tmp6_ = _tmp5_;
			_tmp7_ = uri;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = g_new0 (gchar*, 1 + 1);
			_tmp9_[0] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 1;
			freedesktop_file_manager1_show_items (_tmp6_, _tmp10_, (gint) 1, "", &_inner_error0_);
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_free0 (uri);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = stderr;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			fprintf (_tmp11_, "Unable to call org.freedesktop.FileManager1: %s\n", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp14_ = FALSE;
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp14_;
		}
	}
	_tmp15_ = g_file_get_parent (file);
	parent = _tmp15_;
	{
		GAppInfo* app_info = NULL;
		gboolean _tmp17_ = FALSE;
		GAppInfo* _tmp18_;
		GAppInfo* _tmp28_;
		GFile* _tmp51_;
		const gchar* _tmp54_;
		gchar** args = NULL;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar** _tmp58_;
		gint args_length1;
		gint _args_size_;
		gchar** _tmp59_;
		gint _tmp59__length1;
		app_info = NULL;
		if (g_file_has_uri_scheme (file, "file")) {
			GAppInfo* _tmp16_;
			_tmp16_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
			_g_object_unref0 (app_info);
			app_info = _tmp16_;
		}
		_tmp18_ = app_info;
		if (_tmp18_ == NULL) {
			GFile* _tmp19_;
			_tmp19_ = parent;
			_tmp17_ = _tmp19_ != NULL;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			{
				GAppInfo* _tmp20_ = NULL;
				GFile* _tmp21_;
				GAppInfo* _tmp22_;
				GAppInfo* _tmp23_;
				_tmp21_ = parent;
				_tmp22_ = g_file_query_default_handler (_tmp21_, NULL, &_inner_error0_);
				_tmp20_ = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				_tmp23_ = _tmp20_;
				_tmp20_ = NULL;
				_g_object_unref0 (app_info);
				app_info = _tmp23_;
				_g_object_unref0 (_tmp20_);
			}
			goto __finally2;
			__catch2_g_error:
			{
				FILE* _tmp24_;
				GFile* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				g_clear_error (&_inner_error0_);
				_tmp24_ = stderr;
				_tmp25_ = parent;
				_tmp26_ = g_file_get_uri (_tmp25_);
				_tmp27_ = _tmp26_;
				fprintf (_tmp24_, "Unable to get AppInfo for parent folder: %s\n", _tmp27_);
				_g_free0 (_tmp27_);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (app_info);
				goto __catch1_g_error;
			}
		}
		_tmp28_ = app_info;
		if (_tmp28_ != NULL) {
			GAppInfo* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			GAppInfo* _tmp32_;
			const gchar* _tmp33_;
			_tmp29_ = app_info;
			_tmp30_ = g_app_info_get_executable (_tmp29_);
			_tmp31_ = uri;
			g_debug ("desktop-integration.vala:72: Launching \"%s\" for URI: %s\n", _tmp30_, _tmp31_);
			_tmp32_ = app_info;
			_tmp33_ = g_app_info_get_executable (_tmp32_);
			if (g_strcmp0 (_tmp33_, "dolphin") == 0) {
				gchar** args = NULL;
				GAppInfo* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar** _tmp40_;
				gint args_length1;
				gint _args_size_;
				gchar** _tmp41_;
				gint _tmp41__length1;
				_tmp34_ = app_info;
				_tmp35_ = g_app_info_get_executable (_tmp34_);
				_tmp36_ = g_strdup (_tmp35_);
				_tmp37_ = g_strdup ("--select");
				_tmp38_ = uri;
				_tmp39_ = g_strdup (_tmp38_);
				_tmp40_ = g_new0 (gchar*, 3 + 1);
				_tmp40_[0] = _tmp36_;
				_tmp40_[1] = _tmp37_;
				_tmp40_[2] = _tmp39_;
				args = _tmp40_;
				args_length1 = 3;
				_args_size_ = args_length1;
				_tmp41_ = args;
				_tmp41__length1 = args_length1;
				g_spawn_sync (NULL, _tmp41_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (app_info);
					goto __catch1_g_error;
				}
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			} else {
				gboolean _tmp42_ = FALSE;
				GFile* _tmp43_;
				GList* uri_list = NULL;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				GAppInfo* _tmp49_;
				GList* _tmp50_;
				_tmp43_ = parent;
				if (_tmp43_ != NULL) {
					GAppInfo* _tmp44_;
					_tmp44_ = app_info;
					_tmp42_ = !peek_desktop_integration_file_manager_highlights_file (_tmp44_);
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					GFile* _tmp45_;
					gchar* _tmp46_;
					_tmp45_ = parent;
					_tmp46_ = g_file_get_uri (_tmp45_);
					_g_free0 (uri);
					uri = _tmp46_;
				}
				uri_list = NULL;
				_tmp47_ = uri;
				_tmp48_ = g_strdup (_tmp47_);
				uri_list = g_list_append (uri_list, _tmp48_);
				_tmp49_ = app_info;
				_tmp50_ = uri_list;
				g_app_info_launch_uris (_tmp49_, _tmp50_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					(uri_list == NULL) ? NULL : (uri_list = (_g_list_free__g_free0_ (uri_list), NULL));
					_g_object_unref0 (app_info);
					goto __catch1_g_error;
				}
				(uri_list == NULL) ? NULL : (uri_list = (_g_list_free__g_free0_ (uri_list), NULL));
			}
			result = TRUE;
			_g_object_unref0 (app_info);
			_g_object_unref0 (parent);
			_g_free0 (uri);
			return result;
		}
		_tmp51_ = parent;
		if (_tmp51_ != NULL) {
			GFile* _tmp52_;
			gchar* _tmp53_;
			_tmp52_ = parent;
			_tmp53_ = g_file_get_uri (_tmp52_);
			_g_free0 (uri);
			uri = _tmp53_;
		}
		_tmp54_ = uri;
		g_debug ("desktop-integration.vala:100: Launching xdg-open for URI: %s\n", _tmp54_);
		_tmp55_ = g_strdup ("xdg-open");
		_tmp56_ = uri;
		_tmp57_ = g_strdup (_tmp56_);
		_tmp58_ = g_new0 (gchar*, 2 + 1);
		_tmp58_[0] = _tmp55_;
		_tmp58_[1] = _tmp57_;
		args = _tmp58_;
		args_length1 = 2;
		_args_size_ = args_length1;
		_tmp59_ = args;
		_tmp59__length1 = args_length1;
		g_spawn_sync (NULL, _tmp59_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (app_info);
			goto __catch1_g_error;
		}
		result = TRUE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app_info);
		_g_object_unref0 (parent);
		_g_free0 (uri);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp60_;
		GError* _tmp61_;
		const gchar* _tmp62_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp60_ = stderr;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->message;
		fprintf (_tmp60_, "Launching file manager failed: %s\n", _tmp62_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parent);
		_g_free0 (uri);
		return result;
	}
	__finally1:
	_g_object_unref0 (parent);
	_g_free0 (uri);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp63_;
}

gchar*
peek_desktop_integration_get_video_folder (void)
{
	gchar* folder = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* result;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (folder);
	folder = _tmp1_;
	_tmp2_ = folder;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (folder);
		folder = _tmp4_;
	}
	_tmp5_ = folder;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_get_home_dir ();
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (folder);
		folder = _tmp7_;
	}
	result = folder;
	return result;
}

gboolean
peek_desktop_integration_is_unity (void)
{
	gboolean result;
	result = peek_desktop_integration_xdg_current_desktop_contains ("Unity");
	return result;
}

gboolean
peek_desktop_integration_is_gnome (void)
{
	gboolean result;
	result = peek_desktop_integration_xdg_current_desktop_contains ("GNOME");
	return result;
}

gboolean
peek_desktop_integration_is_cinnamon (void)
{
	gboolean result;
	result = peek_desktop_integration_xdg_current_desktop_contains ("X-Cinnamon");
	return result;
}

gboolean
peek_desktop_integration_is_xfce (void)
{
	gboolean result;
	result = peek_desktop_integration_xdg_current_desktop_contains ("XFCE");
	return result;
}

gboolean
peek_desktop_integration_is_plasma (void)
{
	gboolean result;
	result = peek_desktop_integration_xdg_current_desktop_contains ("KDE");
	return result;
}

gboolean
peek_desktop_integration_is_wayland (void)
{
	gchar* wayland_display = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = g_getenv ("WAYLAND_DISPLAY");
	_tmp1_ = g_strdup (_tmp0_);
	wayland_display = _tmp1_;
	_tmp3_ = wayland_display;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = wayland_display;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (wayland_display);
	return result;
}

gboolean
peek_desktop_integration_is_x11_backend (void)
{
	GType window_type = 0UL;
	GdkDisplayManager* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = gdk_display_manager_get ();
	_tmp1_ = gdk_display_manager_get_default_display (_tmp0_);
	_tmp2_ = _tmp1_;
	window_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_);
	_tmp3_ = g_type_name (window_type);
	result = g_strcmp0 (_tmp3_, "GdkX11Display") == 0;
	return result;
}

gboolean
peek_desktop_integration_is_wayland_backend (void)
{
	GType window_type = 0UL;
	GdkDisplayManager* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = gdk_display_manager_get ();
	_tmp1_ = gdk_display_manager_get_default_display (_tmp0_);
	_tmp2_ = _tmp1_;
	window_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_);
	_tmp3_ = g_type_name (window_type);
	result = g_strcmp0 (_tmp3_, "GdkWaylandDisplay") == 0;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
peek_desktop_integration_xdg_current_desktop_contains (const gchar* text)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* desktop = NULL;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp1_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup (_tmp0_);
	desktop = _tmp2_;
	g_debug ("desktop-integration.vala:168: Desktop: %s", desktop);
	result = string_contains (desktop, text);
	_g_free0 (desktop);
	return result;
}

gchar*
peek_desktop_integration_get_theme_name (void)
{
	gchar* theme_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	theme_name = _tmp0_;
	if (peek_desktop_integration_is_plasma ()) {
		gchar* _tmp1_;
		_tmp1_ = peek_desktop_integration_get_theme_name_from_settings_file ();
		_g_free0 (theme_name);
		theme_name = _tmp1_;
	}
	_tmp2_ = theme_name;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		GSettings* settings = NULL;
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = g_settings_new ("org.gnome.desktop.interface");
		settings = _tmp3_;
		_tmp4_ = settings;
		_tmp5_ = g_settings_get_string (_tmp4_, "gtk-theme");
		_g_free0 (theme_name);
		theme_name = _tmp5_;
		_g_object_unref0 (settings);
	}
	result = theme_name;
	return result;
}

static gchar*
peek_desktop_integration_get_theme_name_from_settings_file (void)
{
	gchar* gtk3_settings_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* contents = NULL;
	gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ".config/gtk-3.0/settings.ini", NULL);
	gtk3_settings_file = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp3_ = gtk3_settings_file;
		_tmp5_ = g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp4_;
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (contents);
			_g_free0 (gtk3_settings_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (_tmp2_) {
			GMatchInfo* match = NULL;
			GRegex* regex = NULL;
			GRegex* _tmp6_;
			GRegex* _tmp7_;
			const gchar* _tmp8_;
			GMatchInfo* _tmp9_ = NULL;
			gboolean _tmp10_;
			_tmp6_ = g_regex_new ("^gtk-theme-name=(.*)$", G_REGEX_MULTILINE, 0, &_inner_error0_);
			regex = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_match_info_unref0 (match);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_free0 (contents);
				_g_free0 (gtk3_settings_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp7_ = regex;
			_tmp8_ = contents;
			_tmp10_ = g_regex_match (_tmp7_, _tmp8_, 0, &_tmp9_);
			_g_match_info_unref0 (match);
			match = _tmp9_;
			if (_tmp10_) {
				GMatchInfo* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = match;
				_tmp12_ = g_match_info_fetch (_tmp11_, 1);
				result = _tmp12_;
				_g_regex_unref0 (regex);
				_g_match_info_unref0 (match);
				_g_free0 (contents);
				_g_free0 (gtk3_settings_file);
				return result;
			}
			_g_regex_unref0 (regex);
			_g_match_info_unref0 (match);
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = stderr;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "Error: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = stderr;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "Error: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_free0 (gtk3_settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (contents);
	_g_free0 (gtk3_settings_file);
	return result;
}

static gboolean
peek_desktop_integration_file_manager_highlights_file (GAppInfo* app_info)
{
	gchar* exe = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (app_info != NULL, FALSE);
	_tmp0_ = g_app_info_get_executable (app_info);
	_tmp1_ = g_strdup (_tmp0_);
	exe = _tmp1_;
	_tmp3_ = exe;
	if (g_strcmp0 (_tmp3_, "nautilus") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = exe;
		_tmp2_ = g_strcmp0 (_tmp4_, "nemo") == 0;
	}
	result = _tmp2_;
	_g_free0 (exe);
	return result;
}

PeekDesktopIntegration*
peek_desktop_integration_construct (GType object_type)
{
	PeekDesktopIntegration* self = NULL;
	self = (PeekDesktopIntegration*) g_type_create_instance (object_type);
	return self;
}

PeekDesktopIntegration*
peek_desktop_integration_new (void)
{
	return peek_desktop_integration_construct (PEEK_TYPE_DESKTOP_INTEGRATION);
}

static FreedesktopFileManager1*
peek_desktop_integration_get_file_manager_service (void)
{
	FreedesktopFileManager1* result;
	FreedesktopFileManager1* _tmp5_;
	GError* _inner_error0_ = NULL;
	if (!peek_desktop_integration__file_manager_dbus_initialized) {
		{
			FreedesktopFileManager1* _tmp0_ = NULL;
			FreedesktopFileManager1* _tmp1_;
			FreedesktopFileManager1* _tmp2_;
			_tmp1_ = (FreedesktopFileManager1*) g_initable_new (FREEDESKTOP_TYPE_FILE_MANAGER1_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.FileManager1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/FileManager1", "g-interface-name", "org.freedesktop.FileManager1", NULL);
			_tmp0_ = (FreedesktopFileManager1*) _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (peek_desktop_integration__file_manager_service);
			peek_desktop_integration__file_manager_service = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_debug ("desktop-integration.vala:26: DBus service org.freedesktop.FileManager1" \
" not available: %s\n", _tmp4_);
			_g_object_unref0 (peek_desktop_integration__file_manager_service);
			peek_desktop_integration__file_manager_service = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			peek_desktop_integration__file_manager_dbus_initialized = TRUE;
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = peek_desktop_integration__file_manager_service;
	result = _tmp5_;
	return result;
}

static void
peek_value_desktop_integration_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
peek_value_desktop_integration_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		peek_desktop_integration_unref (value->data[0].v_pointer);
	}
}

static void
peek_value_desktop_integration_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = peek_desktop_integration_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
peek_value_desktop_integration_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
peek_value_desktop_integration_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PeekDesktopIntegration * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = peek_desktop_integration_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
peek_value_desktop_integration_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	PeekDesktopIntegration ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = peek_desktop_integration_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
peek_param_spec_desktop_integration (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	PeekParamSpecDesktopIntegration* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PEEK_TYPE_DESKTOP_INTEGRATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
peek_value_get_desktop_integration (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_TYPE_DESKTOP_INTEGRATION), NULL);
	return value->data[0].v_pointer;
}

void
peek_value_set_desktop_integration (GValue* value,
                                    gpointer v_object)
{
	PeekDesktopIntegration * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_TYPE_DESKTOP_INTEGRATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PEEK_TYPE_DESKTOP_INTEGRATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		peek_desktop_integration_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		peek_desktop_integration_unref (old);
	}
}

void
peek_value_take_desktop_integration (GValue* value,
                                     gpointer v_object)
{
	PeekDesktopIntegration * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_TYPE_DESKTOP_INTEGRATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PEEK_TYPE_DESKTOP_INTEGRATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		peek_desktop_integration_unref (old);
	}
}

static void
peek_desktop_integration_class_init (PeekDesktopIntegrationClass * klass,
                                     gpointer klass_data)
{
	peek_desktop_integration_parent_class = g_type_class_peek_parent (klass);
	((PeekDesktopIntegrationClass *) klass)->finalize = peek_desktop_integration_finalize;
}

static void
peek_desktop_integration_instance_init (PeekDesktopIntegration * self,
                                        gpointer klass)
{
	self->ref_count = 1;
}

static void
peek_desktop_integration_finalize (PeekDesktopIntegration * obj)
{
	PeekDesktopIntegration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_TYPE_DESKTOP_INTEGRATION, PeekDesktopIntegration);
	g_signal_handlers_destroy (self);
}

static GType
peek_desktop_integration_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { peek_value_desktop_integration_init, peek_value_desktop_integration_free_value, peek_value_desktop_integration_copy_value, peek_value_desktop_integration_peek_pointer, "p", peek_value_desktop_integration_collect_value, "p", peek_value_desktop_integration_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PeekDesktopIntegrationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_desktop_integration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekDesktopIntegration), 0, (GInstanceInitFunc) peek_desktop_integration_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType peek_desktop_integration_type_id;
	peek_desktop_integration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PeekDesktopIntegration", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return peek_desktop_integration_type_id;
}

GType
peek_desktop_integration_get_type (void)
{
	static volatile gsize peek_desktop_integration_type_id__once = 0;
	if (g_once_init_enter (&peek_desktop_integration_type_id__once)) {
		GType peek_desktop_integration_type_id;
		peek_desktop_integration_type_id = peek_desktop_integration_get_type_once ();
		g_once_init_leave (&peek_desktop_integration_type_id__once, peek_desktop_integration_type_id);
	}
	return peek_desktop_integration_type_id__once;
}

gpointer
peek_desktop_integration_ref (gpointer instance)
{
	PeekDesktopIntegration * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
peek_desktop_integration_unref (gpointer instance)
{
	PeekDesktopIntegration * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PEEK_DESKTOP_INTEGRATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

