/* application.c generated by valac 0.56.17, the Vala compiler
 * generated from application.vala, do not modify */

/*
Peek Copyright (c) 2015-2020 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <keybinder-3.0/keybinder.h>
#include <gdk/gdk.h>

#define PEEK_APPLICATION_GTK_STYLE_PROVIDER_PRIORITY_APPLICATION ((guint) 600)
#define PEEK_APP_ID "com.uploadedlobster.peek"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PEEK_UI_TYPE_APPLICATION_WINDOW (peek_ui_application_window_get_type ())
#define PEEK_UI_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindow))
#define PEEK_UI_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindowClass))
#define PEEK_UI_IS_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PEEK_UI_TYPE_APPLICATION_WINDOW))
#define PEEK_UI_IS_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PEEK_UI_TYPE_APPLICATION_WINDOW))
#define PEEK_UI_APPLICATION_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindowClass))

typedef struct _PeekUiApplicationWindow PeekUiApplicationWindow;
typedef struct _PeekUiApplicationWindowClass PeekUiApplicationWindowClass;
enum  {
	PEEK_APPLICATION_0_PROPERTY,
	PEEK_APPLICATION_KEYBINDING_TOGGLE_RECORDING_PROPERTY,
	PEEK_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* peek_application_properties[PEEK_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PEEK_APPLICATION_TOGGLE_RECORDING_SIGNAL,
	PEEK_APPLICATION_START_RECORDING_SIGNAL,
	PEEK_APPLICATION_STOP_RECORDING_SIGNAL,
	PEEK_APPLICATION_NUM_SIGNALS
};
static guint peek_application_signals[PEEK_APPLICATION_NUM_SIGNALS] = {0};

struct _PeekApplicationPrivate {
	PeekUiApplicationWindow* main_window;
	gchar* _keybinding_toggle_recording;
};

static gint PeekApplication_private_offset;
static gpointer peek_application_parent_class = NULL;
static GSettings* peek_application_settings;
static GSettings* peek_application_settings = NULL;
static gboolean peek_application__keybindings_paused;
static gboolean peek_application__keybindings_paused = FALSE;

VALA_EXTERN GType peek_ui_application_window_get_type (void) G_GNUC_CONST ;
static void peek_application_real_activate (GApplication* base);
static void peek_application_new_window (PeekApplication* self);
static void peek_application_real_startup (GApplication* base);
static void peek_application_load_stylesheets (void);
static void peek_application_register_actions (PeekApplication* self);
static void peek_application_register_key_bindings (PeekApplication* self);
static void peek_application_real_shutdown (GApplication* base);
VALA_EXTERN PeekRecordingScreenRecorder* peek_ui_application_window_get_recorder (PeekUiApplicationWindow* self);
static void peek_application_unregister_key_bindings (PeekApplication* self);
static gint peek_application_real_handle_local_options (GApplication* base,
                                                 GVariantDict* options);
static gint peek_application_real_command_line (GApplication* base,
                                         GApplicationCommandLine* command_line);
VALA_EXTERN void peek_ui_application_window_hide_headerbar (PeekUiApplicationWindow* self);
static void _peek_application_new_window_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static void peek_application_new_window_with_backend (PeekApplication* self,
                                               GVariant* backend);
static void _peek_application_new_window_with_backend_g_simple_action_activate (GSimpleAction* _sender,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void peek_application_set_window_size (PeekApplication* self);
static void _peek_application_set_window_size_g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void peek_application_show_preferences (PeekApplication* self);
static void _peek_application_show_preferences_g_simple_action_activate (GSimpleAction* _sender,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void peek_application_show_about (PeekApplication* self);
static void _peek_application_show_about_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static void _peek_application_request_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self);
static void peek_application_show_file (PeekApplication* self,
                                 GVariant* uri);
static void _peek_application_show_file_g_simple_action_activate (GSimpleAction* _sender,
                                                           GVariant* parameter,
                                                           gpointer self);
static void peek_application_handle_keybinding_toggle_recording (PeekApplication* self,
                                                          const gchar* keystring);
static void peek_application_show_window (PeekApplication* self,
                                   PeekRecordingScreenRecorder* recorder);
static void peek_application_show_recording_backend_warning (PeekApplication* self,
                                                      const gchar* msg);
VALA_EXTERN GtkDialog* peek_ui_set_window_size_dialog_present_single_instance (PeekUiApplicationWindow* main_window);
static void peek_application_show_wayland_warning (PeekApplication* self);
VALA_EXTERN PeekUiApplicationWindow* peek_ui_application_window_new (PeekApplication* application,
                                                         PeekRecordingScreenRecorder* recorder);
VALA_EXTERN PeekUiApplicationWindow* peek_ui_application_window_construct (GType object_type,
                                                               PeekApplication* application,
                                                               PeekRecordingScreenRecorder* recorder);
VALA_EXTERN GtkWindow* peek_ui_preferences_dialog_present_single_instance (GtkWindow* main_window);
VALA_EXTERN GtkDialog* peek_ui_about_dialog_present_single_instance (GtkWindow* main_window);
static void peek_application_load_stylesheet_by_name (const gchar* name);
static void peek_application_load_stylesheet_from_uri (const gchar* uri);
static void peek_application_show_startup_warning (PeekApplication* self,
                                            const gchar* title,
                                            const gchar* text);
static void _peek_application_handle_keybinding_toggle_recording_keybinder_handler (const gchar* keystring,
                                                                             gpointer self);
static void peek_application_finalize (GObject * obj);
static GType peek_application_get_type_once (void);
static void _vala_peek_application_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_peek_application_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
peek_application_get_instance_private (PeekApplication* self)
{
	return G_STRUCT_MEMBER_P (self, PeekApplication_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GSettings*
peek_application_get_app_settings (void)
{
	GSettings* _tmp0_;
	GSettings* _tmp3_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* result;
	_tmp0_ = peek_application_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		_tmp1_ = peek_application_settings;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = peek_application_settings;
	if (_tmp3_ == NULL) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new (PEEK_APP_ID);
		_g_object_unref0 (peek_application_settings);
		peek_application_settings = _tmp4_;
	}
	_tmp5_ = peek_application_settings;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

PeekApplication*
peek_application_construct (GType object_type)
{
	PeekApplication * self = NULL;
	self = (PeekApplication*) g_object_new (object_type, "application-id", PEEK_APP_ID, "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_add_main_option ((GApplication*) self, "version", 'v', G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, _ ("Show the version of the program and exit"), NULL);
	g_application_add_main_option ((GApplication*) self, "backend", 'b', G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_STRING, _ ("Select the recording backend (gnome-shell, ffmpeg)"), _ ("BACKEND"));
	g_application_add_main_option ((GApplication*) self, "start", 's', G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, _ ("Start recording in all running Peek instances"), NULL);
	g_application_add_main_option ((GApplication*) self, "stop", 'p', G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, _ ("Stop recording in all running Peek instances"), NULL);
	g_application_add_main_option ((GApplication*) self, "toggle", 't', G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, _ ("Toggle recording in all running Peek instances"), NULL);
	g_application_add_main_option ((GApplication*) self, "no-headerbar", (gchar) 0, G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, _ ("Start Peek without the header bar"), NULL);
	return self;
}

PeekApplication*
peek_application_new (void)
{
	return peek_application_construct (PEEK_TYPE_APPLICATION);
}

static void
peek_application_real_activate (GApplication* base)
{
	PeekApplication * self;
	self = (PeekApplication*) base;
	peek_application_new_window (self);
}

static void
peek_application_real_startup (GApplication* base)
{
	PeekApplication * self;
	self = (PeekApplication*) base;
	G_APPLICATION_CLASS (peek_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	peek_application_load_stylesheets ();
	g_set_application_name (_ ("Peek"));
	peek_application_register_actions (self);
	if (peek_desktop_integration_is_x11_backend ()) {
		peek_application_register_key_bindings (self);
	}
}

void
peek_application_request_quit (PeekApplication* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_debug ("application.vala:105: Application was requested to quit");
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp1_;
			GtkWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp1_;
			{
				GtkWindow* _tmp2_;
				_tmp2_ = window;
				gtk_window_close (_tmp2_);
				_g_object_unref0 (window);
			}
		}
	}
}

static void
peek_application_real_shutdown (GApplication* base)
{
	PeekApplication * self;
	GList* _tmp0_;
	self = (PeekApplication*) base;
	g_debug ("application.vala:112: Application got shutdown signal");
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp1_;
			GtkWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp1_;
			{
				PeekRecordingScreenRecorder* recorder = NULL;
				GtkWindow* _tmp2_;
				PeekRecordingScreenRecorder* _tmp3_;
				PeekRecordingScreenRecorder* _tmp4_;
				PeekRecordingScreenRecorder* _tmp5_;
				PeekRecordingScreenRecorder* _tmp6_;
				_tmp2_ = window;
				_tmp3_ = peek_ui_application_window_get_recorder (PEEK_UI_IS_APPLICATION_WINDOW (_tmp2_) ? ((PeekUiApplicationWindow*) _tmp2_) : NULL);
				_tmp4_ = _tmp3_;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				recorder = _tmp5_;
				_tmp6_ = recorder;
				peek_recording_screen_recorder_cancel (_tmp6_);
				_g_object_unref0 (recorder);
				_g_object_unref0 (window);
			}
		}
	}
	peek_application_unregister_key_bindings (self);
	G_APPLICATION_CLASS (peek_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static gint
peek_application_real_handle_local_options (GApplication* base,
                                            GVariantDict* options)
{
	PeekApplication * self;
	gint result;
	self = (PeekApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "%1$s %2$s\n", "Peek", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
peek_application_real_command_line (GApplication* base,
                                    GApplicationCommandLine* command_line)
{
	PeekApplication * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	GVariantDict* _tmp3_;
	GVariantDict* _tmp4_;
	GVariantDict* _tmp5_;
	gboolean _tmp10_ = FALSE;
	GVariantDict* _tmp11_;
	gint result;
	self = (PeekApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, "start")) {
		g_signal_emit (self, peek_application_signals[PEEK_APPLICATION_START_RECORDING_SIGNAL], 0);
		result = EXIT_SUCCESS;
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp3_ = options;
	if (g_variant_dict_contains (_tmp3_, "stop")) {
		g_signal_emit (self, peek_application_signals[PEEK_APPLICATION_STOP_RECORDING_SIGNAL], 0);
		result = EXIT_SUCCESS;
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp4_ = options;
	if (g_variant_dict_contains (_tmp4_, "toggle")) {
		g_signal_emit (self, peek_application_signals[PEEK_APPLICATION_TOGGLE_RECORDING_SIGNAL], 0);
		result = EXIT_SUCCESS;
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp5_ = options;
	if (g_variant_dict_contains (_tmp5_, "backend")) {
		GVariant* backend = NULL;
		GVariantDict* _tmp6_;
		const GVariantType* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp6_ = options;
		_tmp7_ = G_VARIANT_TYPE_STRING;
		_tmp8_ = g_variant_dict_lookup_value (_tmp6_, "backend", _tmp7_);
		backend = _tmp8_;
		_tmp9_ = backend;
		g_action_group_activate_action ((GActionGroup*) self, "new-window-with-backend", _tmp9_);
		_g_variant_unref0 (backend);
	} else {
		g_action_group_activate_action ((GActionGroup*) self, "new-window", NULL);
	}
	_tmp11_ = options;
	if (g_variant_dict_contains (_tmp11_, "no-headerbar")) {
		PeekUiApplicationWindow* _tmp12_;
		_tmp12_ = self->priv->main_window;
		_tmp10_ = _tmp12_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		PeekUiApplicationWindow* _tmp13_;
		_tmp13_ = self->priv->main_window;
		peek_ui_application_window_hide_headerbar (_tmp13_);
	}
	result = EXIT_SUCCESS;
	_g_variant_dict_unref0 (options);
	return result;
}

static void
_peek_application_new_window_g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	peek_application_new_window ((PeekApplication*) self);
}

static void
_peek_application_new_window_with_backend_g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	peek_application_new_window_with_backend ((PeekApplication*) self, parameter);
}

static void
_peek_application_set_window_size_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	peek_application_set_window_size ((PeekApplication*) self);
}

static void
_peek_application_show_preferences_g_simple_action_activate (GSimpleAction* _sender,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	peek_application_show_preferences ((PeekApplication*) self);
}

static void
_peek_application_show_about_g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	peek_application_show_about ((PeekApplication*) self);
}

static void
_peek_application_request_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	peek_application_request_quit ((PeekApplication*) self);
}

static void
_peek_application_show_file_g_simple_action_activate (GSimpleAction* _sender,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	peek_application_show_file ((PeekApplication*) self, parameter);
}

static void
peek_application_register_actions (PeekApplication* self)
{
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	const GVariantType* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	const GVariantType* _tmp19_;
	GSimpleAction* _tmp20_;
	GSimpleAction* _tmp21_;
	GSimpleAction* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_new ("new-window", NULL);
	_g_object_unref0 (action);
	action = _tmp0_;
	_tmp1_ = action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) _peek_application_new_window_g_simple_action_activate, self, 0);
	_tmp2_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = G_VARIANT_TYPE_STRING;
	_tmp4_ = g_simple_action_new ("new-window-with-backend", _tmp3_);
	_g_object_unref0 (action);
	action = _tmp4_;
	_tmp5_ = action;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) _peek_application_new_window_with_backend_g_simple_action_activate, self, 0);
	_tmp6_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp6_);
	_tmp7_ = g_simple_action_new ("set-window-size", NULL);
	_g_object_unref0 (action);
	action = _tmp7_;
	_tmp8_ = action;
	g_signal_connect_object (_tmp8_, "activate", (GCallback) _peek_application_set_window_size_g_simple_action_activate, self, 0);
	_tmp9_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp9_);
	_tmp10_ = g_simple_action_new ("preferences", NULL);
	_g_object_unref0 (action);
	action = _tmp10_;
	_tmp11_ = action;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) _peek_application_show_preferences_g_simple_action_activate, self, 0);
	_tmp12_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp12_);
	_tmp13_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp13_;
	_tmp14_ = action;
	g_signal_connect_object (_tmp14_, "activate", (GCallback) _peek_application_show_about_g_simple_action_activate, self, 0);
	_tmp15_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp15_);
	_tmp16_ = g_simple_action_new ("quit", NULL);
	_g_object_unref0 (action);
	action = _tmp16_;
	_tmp17_ = action;
	g_signal_connect_object (_tmp17_, "activate", (GCallback) _peek_application_request_quit_g_simple_action_activate, self, 0);
	_tmp18_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp18_);
	_tmp19_ = G_VARIANT_TYPE_STRING;
	_tmp20_ = g_simple_action_new ("show-file", _tmp19_);
	_g_object_unref0 (action);
	action = _tmp20_;
	_tmp21_ = action;
	g_signal_connect_object (_tmp21_, "activate", (GCallback) _peek_application_show_file_g_simple_action_activate, self, 0);
	_tmp22_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp22_);
	_g_object_unref0 (action);
}

static void
peek_application_register_key_bindings (PeekApplication* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = peek_application_get_app_settings ();
	settings = _tmp0_;
	keybinder_init ();
	keybinder_set_use_cooked_accelerators (FALSE);
	g_settings_bind (settings, "keybinding-toggle-recording", (GObject*) self, "keybinding_toggle_recording", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (settings);
}

static void
peek_application_unregister_key_bindings (PeekApplication* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = peek_application_get_keybinding_toggle_recording (self);
	_tmp1_ = _tmp0_;
	keybinder_unbind_all (_tmp1_);
}

static void
peek_application_handle_keybinding_toggle_recording (PeekApplication* self,
                                                     const gchar* keystring)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keystring != NULL);
	_tmp0_ = peek_application_get_keybindings_paused ();
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		g_debug ("application.vala:237: Global keybinding %s\n", keystring);
		g_signal_emit (self, peek_application_signals[PEEK_APPLICATION_TOGGLE_RECORDING_SIGNAL], 0);
	}
}

static void
peek_application_new_window (PeekApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PeekRecordingScreenRecorder* recorder = NULL;
		PeekRecordingScreenRecorder* _tmp0_;
		_tmp0_ = peek_recording_screen_recorder_factory_create_default_screen_recorder (&_inner_error0_);
		recorder = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
				goto __catch0_peek_peek_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		peek_application_show_window (self, recorder);
		_g_object_unref0 (recorder);
	}
	goto __finally0;
	__catch0_peek_peek_error:
	{
		GError* e = NULL;
		gchar* msg = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		FILE* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_strdup_printf (_ ("Unable to initialize default recording backend: %s"), _tmp2_);
		msg = _tmp3_;
		_tmp4_ = stderr;
		_tmp5_ = msg;
		fprintf (_tmp4_, "%s\n", _tmp5_);
		_tmp6_ = msg;
		peek_application_show_recording_backend_warning (self, _tmp6_);
		_g_free0 (msg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
peek_application_new_window_with_backend (PeekApplication* self,
                                          GVariant* backend)
{
	gsize length = 0UL;
	gchar* backend_name = NULL;
	gsize _tmp0_ = 0UL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_variant_get_string (backend, &_tmp0_);
	length = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	backend_name = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Requested screen recording backend %s\n", backend_name);
	{
		PeekRecordingScreenRecorder* recorder = NULL;
		PeekRecordingScreenRecorder* _tmp4_;
		_tmp4_ = peek_recording_screen_recorder_factory_create_screen_recorder (backend_name, &_inner_error0_);
		recorder = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
				goto __catch0_peek_peek_error;
			}
			_g_free0 (backend_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		peek_application_show_window (self, recorder);
		_g_object_unref0 (recorder);
	}
	goto __finally0;
	__catch0_peek_peek_error:
	{
		GError* e = NULL;
		gchar* msg = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strdup_printf (_ ("Unable to initialize recording backend %s: %s"), backend_name, _tmp6_);
		msg = _tmp7_;
		_tmp8_ = stderr;
		_tmp9_ = msg;
		fprintf (_tmp8_, "%s\n", _tmp9_);
		_tmp10_ = msg;
		peek_application_show_recording_backend_warning (self, _tmp10_);
		_g_free0 (msg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (backend_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (backend_name);
}

static void
peek_application_set_window_size (PeekApplication* self)
{
	PeekUiApplicationWindow* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = peek_ui_set_window_size_dialog_present_single_instance (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}

static void
peek_application_show_window (PeekApplication* self,
                              PeekRecordingScreenRecorder* recorder)
{
	PeekUiApplicationWindow* _tmp0_;
	PeekUiApplicationWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recorder != NULL);
	if (peek_desktop_integration_is_wayland_backend ()) {
		peek_application_show_wayland_warning (self);
		return;
	}
	_tmp0_ = peek_ui_application_window_new (self, recorder);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp0_;
	_tmp1_ = self->priv->main_window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static void
peek_application_show_preferences (PeekApplication* self)
{
	PeekUiApplicationWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = peek_ui_preferences_dialog_present_single_instance ((GtkWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}

static void
peek_application_show_about (PeekApplication* self)
{
	PeekUiApplicationWindow* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = peek_ui_about_dialog_present_single_instance ((GtkWindow*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}

static void
peek_application_load_stylesheets (void)
{
	gchar* theme = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	peek_application_load_stylesheet_by_name ("peek");
	_tmp0_ = peek_desktop_integration_get_theme_name ();
	theme = _tmp0_;
	_tmp1_ = theme;
	g_debug ("application.vala:296: GTK theme: %s", _tmp1_);
	_tmp4_ = theme;
	if (g_strcmp0 (_tmp4_, "Ambiance") == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = theme;
		_tmp3_ = g_strcmp0 (_tmp5_, "Breeze") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = theme;
		_tmp2_ = g_strcmp0 (_tmp6_, "Breeze-Dark") == 0;
	}
	if (_tmp2_) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = theme;
		_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
		_tmp9_ = _tmp8_;
		peek_application_load_stylesheet_by_name (_tmp9_);
		_g_free0 (_tmp9_);
	}
	if (peek_desktop_integration_is_unity ()) {
		peek_application_load_stylesheet_by_name ("unity");
	}
	_g_free0 (theme);
}

static void
peek_application_load_stylesheet_by_name (const gchar* name)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("resource:///com/uploadedlobster/peek/css/%s.css", name);
	uri = _tmp0_;
	peek_application_load_stylesheet_from_uri (uri);
	_g_free0 (uri);
}

static void
peek_application_load_stylesheet_from_uri (const gchar* uri)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		GFile* file = NULL;
		GFile* _tmp1_;
		GdkScreen* screen = NULL;
		GdkScreen* _tmp2_;
		GdkScreen* _tmp3_;
		GdkScreen* _tmp4_;
		_tmp1_ = g_file_new_for_uri (uri);
		file = _tmp1_;
		gtk_css_provider_load_from_file (provider, file, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp2_ = gdk_screen_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		screen = _tmp3_;
		_tmp4_ = screen;
		gtk_style_context_add_provider_for_screen (_tmp4_, (GtkStyleProvider*) provider, PEEK_APPLICATION_GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (screen);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Loading application stylesheet %s failed: %s", uri, _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (provider);
}

static void
peek_application_show_file (PeekApplication* self,
                            GVariant* uri)
{
	gchar* uri_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* file = NULL;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_variant_get_string (uri, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	uri_str = _tmp1_;
	g_debug ("application.vala:328: Action show-file called with URI %s", uri_str);
	_tmp2_ = g_file_new_for_uri (uri_str);
	file = _tmp2_;
	peek_desktop_integration_launch_file_manager (file);
	_g_object_unref0 (file);
	_g_free0 (uri_str);
}

static void
peek_application_show_recording_backend_warning (PeekApplication* self,
                                                 const gchar* msg)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	peek_application_show_startup_warning (self, _ ("Recording backend unavailable"), msg);
}

static void
peek_application_show_wayland_warning (PeekApplication* self)
{
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Native Wayland backend is unsupported"));
	title = _tmp0_;
	_tmp1_ = g_strdup (_ ("You are running Peek natively on Wayland, this is currently unsupporte" \
"d. Please start Peek using XWayland by setting <tt>GDK_BACKEND=x11</tt" \
">.\n" \
"\n" \
"For Details see the Peek <a href='https://github.com/phw/peek#why-no-n" \
"ative-wayland-support'>FAQ about Wayland support</a>."));
	text = _tmp1_;
	peek_application_show_startup_warning (self, title, text);
	_g_free0 (text);
	_g_free0 (title);
}

static void
peek_application_show_startup_warning (PeekApplication* self,
                                       const gchar* title,
                                       const gchar* text)
{
	GtkMessageDialog* msg = NULL;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, "%s", "");
	g_object_ref_sink (_tmp0_);
	msg = _tmp0_;
	g_object_set (msg, "text", title, NULL);
	g_object_set (msg, "secondary-use-markup", TRUE, NULL);
	g_object_set (msg, "secondary-text", text, NULL);
	gtk_dialog_run ((GtkDialog*) msg);
	_g_object_unref0 (msg);
}

gboolean
peek_application_get_keybindings_paused (void)
{
	gboolean result;
	result = peek_application__keybindings_paused;
	return result;
}

void
peek_application_set_keybindings_paused (gboolean value)
{
	peek_application__keybindings_paused = value;
}

const gchar*
peek_application_get_keybinding_toggle_recording (PeekApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keybinding_toggle_recording;
	result = _tmp0_;
	return result;
}

static void
_peek_application_handle_keybinding_toggle_recording_keybinder_handler (const gchar* keystring,
                                                                        gpointer self)
{
	peek_application_handle_keybinding_toggle_recording ((PeekApplication*) self, keystring);
}

void
peek_application_set_keybinding_toggle_recording (PeekApplication* self,
                                                  const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_keybinding_toggle_recording;
	g_debug ("application.vala:221: Changed keybinding_toggle_recording %s => %s\n", _tmp0_, value);
	_tmp1_ = self->priv->_keybinding_toggle_recording;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_keybinding_toggle_recording;
		keybinder_unbind_all (_tmp2_);
	}
	if (g_strcmp0 (value, "") != 0) {
		keybinder_bind_full (value, _peek_application_handle_keybinding_toggle_recording_keybinder_handler, g_object_ref (self), g_object_unref);
	}
	_tmp3_ = g_strdup (value);
	_g_free0 (self->priv->_keybinding_toggle_recording);
	self->priv->_keybinding_toggle_recording = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, peek_application_properties[PEEK_APPLICATION_KEYBINDING_TOGGLE_RECORDING_PROPERTY]);
}

static void
peek_application_class_init (PeekApplicationClass * klass,
                             gpointer klass_data)
{
	peek_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PeekApplication_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) peek_application_real_activate;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) peek_application_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) peek_application_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) peek_application_real_handle_local_options;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) peek_application_real_command_line;
	G_OBJECT_CLASS (klass)->get_property = _vala_peek_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_peek_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = peek_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_APPLICATION_KEYBINDING_TOGGLE_RECORDING_PROPERTY, peek_application_properties[PEEK_APPLICATION_KEYBINDING_TOGGLE_RECORDING_PROPERTY] = g_param_spec_string ("keybinding-toggle-recording", "keybinding-toggle-recording", "keybinding-toggle-recording", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	peek_application_signals[PEEK_APPLICATION_TOGGLE_RECORDING_SIGNAL] = g_signal_new ("toggle-recording", PEEK_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	peek_application_signals[PEEK_APPLICATION_START_RECORDING_SIGNAL] = g_signal_new ("start-recording", PEEK_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	peek_application_signals[PEEK_APPLICATION_STOP_RECORDING_SIGNAL] = g_signal_new ("stop-recording", PEEK_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
peek_application_instance_init (PeekApplication * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	self->priv = peek_application_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_keybinding_toggle_recording = _tmp0_;
}

static void
peek_application_finalize (GObject * obj)
{
	PeekApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_TYPE_APPLICATION, PeekApplication);
	_g_object_unref0 (self->priv->main_window);
	_g_free0 (self->priv->_keybinding_toggle_recording);
	G_OBJECT_CLASS (peek_application_parent_class)->finalize (obj);
}

static GType
peek_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekApplication), 0, (GInstanceInitFunc) peek_application_instance_init, NULL };
	GType peek_application_type_id;
	peek_application_type_id = g_type_register_static (gtk_application_get_type (), "PeekApplication", &g_define_type_info, 0);
	PeekApplication_private_offset = g_type_add_instance_private (peek_application_type_id, sizeof (PeekApplicationPrivate));
	return peek_application_type_id;
}

GType
peek_application_get_type (void)
{
	static volatile gsize peek_application_type_id__once = 0;
	if (g_once_init_enter (&peek_application_type_id__once)) {
		GType peek_application_type_id;
		peek_application_type_id = peek_application_get_type_once ();
		g_once_init_leave (&peek_application_type_id__once, peek_application_type_id);
	}
	return peek_application_type_id__once;
}

static void
_vala_peek_application_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PeekApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_TYPE_APPLICATION, PeekApplication);
	switch (property_id) {
		case PEEK_APPLICATION_KEYBINDING_TOGGLE_RECORDING_PROPERTY:
		g_value_set_string (value, peek_application_get_keybinding_toggle_recording (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_peek_application_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	PeekApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_TYPE_APPLICATION, PeekApplication);
	switch (property_id) {
		case PEEK_APPLICATION_KEYBINDING_TOGGLE_RECORDING_PROPERTY:
		peek_application_set_keybinding_toggle_recording (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

