// python wrapper for vtkPointGaussianRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPointGaussianRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPointGaussianRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPointGaussianRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataRepresentation_ClassNew
extern "C" { PyObject *PyvtkPVDataRepresentation_ClassNew(); }
#define DECLARED_PyvtkPVDataRepresentation_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPointGaussianRepresentation_ShaderPresets_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPointGaussianRepresentation.ShaderPresets", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPointGaussianRepresentation_ShaderPresets_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPointGaussianRepresentation_ShaderPresets_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPointGaussianRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPointGaussianRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPointGaussianRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPointGaussianRepresentation *tempr = vtkPointGaussianRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPointGaussianRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPointGaussianRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPointGaussianRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPointGaussianRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkPointGaussianRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetLookupTable(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetLookupTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetEmissive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEmissive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEmissive(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetEmissive(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMapScalars(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetMapScalars(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetOrientation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetOrientation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrigin(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetOrigin(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetPickable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPickable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPickable(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetPickable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetPosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetCoordinateSystem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoordinateSystem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoordinateSystem(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetCoordinateSystem(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetAmbientColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbientColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAmbientColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetAmbientColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetDiffuseColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDiffuseColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDiffuseColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetDiffuseColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetEdgeColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEdgeColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetEdgeColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetInterpolation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolation(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetInterpolation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetLineWidth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLineWidth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLineWidth(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetLineWidth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOpacity(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetPointSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointSize(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetPointSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetSpecularColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSpecularColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetSpecularColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetSpecularPower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularPower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecularPower(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetSpecularPower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetSplatSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSplatSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSplatSize(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetSplatSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SelectShaderPreset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectShaderPreset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectShaderPreset(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SelectShaderPreset(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetCustomShader(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomShader");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCustomShader(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetCustomShader(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetCustomTriangleScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomTriangleScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCustomTriangleScale(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetCustomTriangleScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SelectScaleArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectScaleArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SelectScaleArray(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SelectScaleArray(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SelectScaleArrayComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectScaleArrayComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectScaleArrayComponent(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SelectScaleArrayComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetUseScaleFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseScaleFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseScaleFunction(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetUseScaleFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetScaleTransferFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScaleTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  vtkPiecewiseFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPiecewiseFunction"))
  {
    if (ap.IsBound())
    {
      op->SetScaleTransferFunction(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetScaleTransferFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetOpacityTransferFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacityTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  vtkPiecewiseFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPiecewiseFunction"))
  {
    if (ap.IsBound())
    {
      op->SetOpacityTransferFunction(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetOpacityTransferFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SelectOpacityArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectOpacityArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SelectOpacityArray(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SelectOpacityArray(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SelectOpacityArrayComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectOpacityArrayComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectOpacityArrayComponent(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SelectOpacityArrayComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetOpacityByArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacityByArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOpacityByArray(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetOpacityByArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_GetOpacityByArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOpacityByArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOpacityByArray() :
      op->vtkPointGaussianRepresentation::GetOpacityByArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_OpacityByArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OpacityByArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OpacityByArrayOn();
    }
    else
    {
      op->vtkPointGaussianRepresentation::OpacityByArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_OpacityByArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OpacityByArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OpacityByArrayOff();
    }
    else
    {
      op->vtkPointGaussianRepresentation::OpacityByArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_SetScaleByArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScaleByArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScaleByArray(temp0);
    }
    else
    {
      op->vtkPointGaussianRepresentation::SetScaleByArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_GetScaleByArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScaleByArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetScaleByArray() :
      op->vtkPointGaussianRepresentation::GetScaleByArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_ScaleByArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ScaleByArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ScaleByArrayOn();
    }
    else
    {
      op->vtkPointGaussianRepresentation::ScaleByArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPointGaussianRepresentation_ScaleByArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ScaleByArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPointGaussianRepresentation *op = static_cast<vtkPointGaussianRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ScaleByArrayOff();
    }
    else
    {
      op->vtkPointGaussianRepresentation::ScaleByArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPointGaussianRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkPointGaussianRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPointGaussianRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPointGaussianRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPointGaussianRepresentation\nC++: static vtkPointGaussianRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPointGaussianRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPointGaussianRepresentation\nC++: vtkPointGaussianRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPointGaussianRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPointGaussianRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessViewRequest", PyvtkPointGaussianRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n\note Starting with ParaView 5.8, this method is no longer called\nfor hidden representation i.e. representations for which\n`vtkDataRepresentation::GetVisibility()` returns false.\n"},
  {"SetLookupTable", PyvtkPointGaussianRepresentation_SetLookupTable, METH_VARARGS,
   "SetLookupTable(self, lut:vtkScalarsToColors) -> None\nC++: void SetLookupTable(vtkScalarsToColors *lut)\n\nUse to set the color map for the data in this representation\n"},
  {"SetVisibility", PyvtkPointGaussianRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, val:bool) -> None\nC++: void SetVisibility(bool val) override;\n\nUse to set whether the data in this representation is visible or\nnot\n"},
  {"SetEmissive", PyvtkPointGaussianRepresentation_SetEmissive, METH_VARARGS,
   "SetEmissive(self, val:bool) -> None\nC++: virtual void SetEmissive(bool val)\n\nUse to set whether the splat emits light\n"},
  {"SetMapScalars", PyvtkPointGaussianRepresentation_SetMapScalars, METH_VARARGS,
   "SetMapScalars(self, val:int) -> None\nC++: virtual void SetMapScalars(int val)\n\nUse to make sure scalars will be mapped through lookup table, and\nnot inadvertently used as colors by themselves.\n"},
  {"SetOrientation", PyvtkPointGaussianRepresentation_SetOrientation, METH_VARARGS,
   "SetOrientation(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetOrientation(double, double, double)\n\n"},
  {"SetOrigin", PyvtkPointGaussianRepresentation_SetOrigin, METH_VARARGS,
   "SetOrigin(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetOrigin(double, double, double)\n\n"},
  {"SetPickable", PyvtkPointGaussianRepresentation_SetPickable, METH_VARARGS,
   "SetPickable(self, val:int) -> None\nC++: virtual void SetPickable(int val)\n\n"},
  {"SetPosition", PyvtkPointGaussianRepresentation_SetPosition, METH_VARARGS,
   "SetPosition(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetPosition(double, double, double)\n\n"},
  {"SetScale", PyvtkPointGaussianRepresentation_SetScale, METH_VARARGS,
   "SetScale(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetScale(double, double, double)\n\n"},
  {"SetCoordinateSystem", PyvtkPointGaussianRepresentation_SetCoordinateSystem, METH_VARARGS,
   "SetCoordinateSystem(self, __a:int) -> None\nC++: virtual void SetCoordinateSystem(int)\n\n"},
  {"SetAmbientColor", PyvtkPointGaussianRepresentation_SetAmbientColor, METH_VARARGS,
   "SetAmbientColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetAmbientColor(double r, double g, double b)\n\n"},
  {"SetDiffuseColor", PyvtkPointGaussianRepresentation_SetDiffuseColor, METH_VARARGS,
   "SetDiffuseColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetDiffuseColor(double r, double g, double b)\n\n"},
  {"SetEdgeColor", PyvtkPointGaussianRepresentation_SetEdgeColor, METH_VARARGS,
   "SetEdgeColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetEdgeColor(double r, double g, double b)\n\n"},
  {"SetInterpolation", PyvtkPointGaussianRepresentation_SetInterpolation, METH_VARARGS,
   "SetInterpolation(self, val:int) -> None\nC++: virtual void SetInterpolation(int val)\n\n"},
  {"SetLineWidth", PyvtkPointGaussianRepresentation_SetLineWidth, METH_VARARGS,
   "SetLineWidth(self, val:float) -> None\nC++: virtual void SetLineWidth(double val)\n\n"},
  {"SetOpacity", PyvtkPointGaussianRepresentation_SetOpacity, METH_VARARGS,
   "SetOpacity(self, val:float) -> None\nC++: virtual void SetOpacity(double val)\n\n"},
  {"SetPointSize", PyvtkPointGaussianRepresentation_SetPointSize, METH_VARARGS,
   "SetPointSize(self, val:float) -> None\nC++: virtual void SetPointSize(double val)\n\n"},
  {"SetSpecularColor", PyvtkPointGaussianRepresentation_SetSpecularColor, METH_VARARGS,
   "SetSpecularColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetSpecularColor(double r, double g, double b)\n\n"},
  {"SetSpecularPower", PyvtkPointGaussianRepresentation_SetSpecularPower, METH_VARARGS,
   "SetSpecularPower(self, val:float) -> None\nC++: virtual void SetSpecularPower(double val)\n\n"},
  {"SetSplatSize", PyvtkPointGaussianRepresentation_SetSplatSize, METH_VARARGS,
   "SetSplatSize(self, radius:float) -> None\nC++: virtual void SetSplatSize(double radius)\n\nSets the radius of the gaussian splats if there is no scale array\nor if the scale array is disabled.  Defaults to 1.\n"},
  {"SelectShaderPreset", PyvtkPointGaussianRepresentation_SelectShaderPreset, METH_VARARGS,
   "SelectShaderPreset(self, preset:int) -> None\nC++: void SelectShaderPreset(int preset)\n\nAllows to select one of several preset options for shading the\npoints\n"},
  {"SetCustomShader", PyvtkPointGaussianRepresentation_SetCustomShader, METH_VARARGS,
   "SetCustomShader(self, shaderString:str) -> None\nC++: void SetCustomShader(const char *shaderString)\n\nSets the snippet of fragment shader code used to color the\nsprites.\n"},
  {"SetCustomTriangleScale", PyvtkPointGaussianRepresentation_SetCustomTriangleScale, METH_VARARGS,
   "SetCustomTriangleScale(self, scale:float) -> None\nC++: void SetCustomTriangleScale(double scale)\n\nSets the scale of the triangle geometry drawn for the custom\nshader\n"},
  {"SelectScaleArray", PyvtkPointGaussianRepresentation_SelectScaleArray, METH_VARARGS,
   "SelectScaleArray(self, __a:int, __b:int, __c:int, __d:int,\n    name:str) -> None\nC++: void SelectScaleArray(int, int, int, int, const char *name)\n\nSets the point array to scale the guassians by.  The array should\nbe a float array.  The first four parameters are unused and only\nneeded for the ParaView GUI's signature recognition.\n"},
  {"SelectScaleArrayComponent", PyvtkPointGaussianRepresentation_SelectScaleArrayComponent, METH_VARARGS,
   "SelectScaleArrayComponent(self, component:int) -> None\nC++: void SelectScaleArrayComponent(int component)\n\nSets the point array component to scale the gaussians by.\n"},
  {"SetUseScaleFunction", PyvtkPointGaussianRepresentation_SetUseScaleFunction, METH_VARARGS,
   "SetUseScaleFunction(self, enable:bool) -> None\nC++: void SetUseScaleFunction(bool enable)\n\nUse scale transfer function. If false, no mapping is done.\n"},
  {"SetScaleTransferFunction", PyvtkPointGaussianRepresentation_SetScaleTransferFunction, METH_VARARGS,
   "SetScaleTransferFunction(self, pwf:vtkPiecewiseFunction) -> None\nC++: void SetScaleTransferFunction(vtkPiecewiseFunction *pwf)\n\nSets a vtkPiecewiseFunction to use in mapping array values to\nsprite sizes.  Performance decreases (along with\nunderstandability) when large values are used for sprite sizes. \nThis is only used when \"SetScaleArray\" is also set.\n"},
  {"SetOpacityTransferFunction", PyvtkPointGaussianRepresentation_SetOpacityTransferFunction, METH_VARARGS,
   "SetOpacityTransferFunction(self, pwf:vtkPiecewiseFunction) -> None\nC++: void SetOpacityTransferFunction(vtkPiecewiseFunction *pwf)\n\nSets a vtkPiecewiseFunction to use in mapping array values to\nsprite opacities.  Only used when \"Opacity Array\" is set.\n"},
  {"SelectOpacityArray", PyvtkPointGaussianRepresentation_SelectOpacityArray, METH_VARARGS,
   "SelectOpacityArray(self, __a:int, __b:int, __c:int, __d:int,\n    name:str) -> None\nC++: void SelectOpacityArray(int, int, int, int, const char *name)\n\nSets the point array to use in calculating point sprite\nopacities. The array should be a float or double array.  The\nfirst four parameters are unused and only needed for the ParaView\nGUI's signature recognition.\n"},
  {"SelectOpacityArrayComponent", PyvtkPointGaussianRepresentation_SelectOpacityArrayComponent, METH_VARARGS,
   "SelectOpacityArrayComponent(self, component:int) -> None\nC++: void SelectOpacityArrayComponent(int component)\n\nSets the point array component to opacify the gaussians with.\n"},
  {"SetOpacityByArray", PyvtkPointGaussianRepresentation_SetOpacityByArray, METH_VARARGS,
   "SetOpacityByArray(self, newVal:bool) -> None\nC++: void SetOpacityByArray(bool newVal)\n\nEnables or disables setting opacity by an array.  Set which array\nshould be used for opacity with SelectOpacityArray, and set an\nopacity transfer function with SetOpacityTransferFunction.\n"},
  {"GetOpacityByArray", PyvtkPointGaussianRepresentation_GetOpacityByArray, METH_VARARGS,
   "GetOpacityByArray(self) -> bool\nC++: virtual bool GetOpacityByArray()\n\n"},
  {"OpacityByArrayOn", PyvtkPointGaussianRepresentation_OpacityByArrayOn, METH_VARARGS,
   "OpacityByArrayOn(self) -> None\nC++: virtual void OpacityByArrayOn()\n\n"},
  {"OpacityByArrayOff", PyvtkPointGaussianRepresentation_OpacityByArrayOff, METH_VARARGS,
   "OpacityByArrayOff(self) -> None\nC++: virtual void OpacityByArrayOff()\n\n"},
  {"SetScaleByArray", PyvtkPointGaussianRepresentation_SetScaleByArray, METH_VARARGS,
   "SetScaleByArray(self, newVal:bool) -> None\nC++: void SetScaleByArray(bool newVal)\n\nEnables or disables scaling by a data array vs. a constant\nfactor.  Set which data array with SelectScaleArray and\nSetSplatSize.\n"},
  {"GetScaleByArray", PyvtkPointGaussianRepresentation_GetScaleByArray, METH_VARARGS,
   "GetScaleByArray(self) -> bool\nC++: virtual bool GetScaleByArray()\n\n"},
  {"ScaleByArrayOn", PyvtkPointGaussianRepresentation_ScaleByArrayOn, METH_VARARGS,
   "ScaleByArrayOn(self) -> None\nC++: virtual void ScaleByArrayOn()\n\n"},
  {"ScaleByArrayOff", PyvtkPointGaussianRepresentation_ScaleByArrayOff, METH_VARARGS,
   "ScaleByArrayOff(self) -> None\nC++: virtual void ScaleByArrayOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPointGaussianRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("lookup_table"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetLookupTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetLookupTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLookupTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("emissive"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetEmissive(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetEmissive(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEmissive\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("map_scalars"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetMapScalars(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetMapScalars(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMapScalars\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetOrientation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetOrientation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetOrigin(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetOrigin(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrigin\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pickable"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetPickable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetPickable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPickable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coordinate_system"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetCoordinateSystem(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetCoordinateSystem(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoordinateSystem\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ambient_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetAmbientColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetAmbientColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAmbientColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("diffuse_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetDiffuseColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetDiffuseColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDiffuseColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetEdgeColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetEdgeColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEdgeColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpolation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetInterpolation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetInterpolation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInterpolation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("line_width"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetLineWidth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetLineWidth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLineWidth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetPointSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetPointSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetSpecularColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetSpecularColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_power"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetSpecularPower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetSpecularPower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularPower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("splat_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetSplatSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetSplatSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSplatSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_shader"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetCustomShader(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetCustomShader(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCustomShader\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_triangle_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetCustomTriangleScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetCustomTriangleScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCustomTriangleScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_scale_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetUseScaleFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetUseScaleFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseScaleFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale_transfer_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetScaleTransferFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetScaleTransferFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScaleTransferFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity_transfer_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetOpacityTransferFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetOpacityTransferFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOpacityTransferFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity_by_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPointGaussianRepresentation_GetOpacityByArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetOpacityByArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetOpacityByArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOpacityByArray/SetOpacityByArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale_by_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPointGaussianRepresentation_GetScaleByArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPointGaussianRepresentation_SetScaleByArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPointGaussianRepresentation_SetScaleByArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetScaleByArray/SetScaleByArray\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPointGaussianRepresentation_Doc =
  "vtkPointGaussianRepresentation - Representation for showing point\ndata as sprites, including gaussian splats, spheres, or some custom\nshaded representation.\n\n"
  "Superclass: vtkPVDataRepresentation\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPointGaussianRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPointGaussianRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPointGaussianRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPointGaussianRepresentation_StaticNew()
{
  return vtkPointGaussianRepresentation::New();
}

PyObject *PyvtkPointGaussianRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPointGaussianRepresentation_Type, PyvtkPointGaussianRepresentation_Methods,
    "vtkPointGaussianRepresentation",
 &PyvtkPointGaussianRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataRepresentation_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPointGaussianRepresentation_ShaderPresets_Type);
  PyVTKEnum_Add(&PyvtkPointGaussianRepresentation_ShaderPresets_Type, "vtkPointGaussianRepresentation.ShaderPresets");

  o = (PyObject *)&PyvtkPointGaussianRepresentation_ShaderPresets_Type;
  if (PyDict_SetItemString(d, "ShaderPresets", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 8; c++)
  {
    typedef vtkPointGaussianRepresentation::ShaderPresets cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[8] = {
        { "GAUSSIAN_BLUR", vtkPointGaussianRepresentation::GAUSSIAN_BLUR },
        { "SPHERE", vtkPointGaussianRepresentation::SPHERE },
        { "BLACK_EDGED_CIRCLE", vtkPointGaussianRepresentation::BLACK_EDGED_CIRCLE },
        { "PLAIN_CIRCLE", vtkPointGaussianRepresentation::PLAIN_CIRCLE },
        { "TRIANGLE", vtkPointGaussianRepresentation::TRIANGLE },
        { "SQUARE_OUTLINE", vtkPointGaussianRepresentation::SQUARE_OUTLINE },
        { "CUSTOM", vtkPointGaussianRepresentation::CUSTOM },
        { "NUMBER_OF_PRESETS", vtkPointGaussianRepresentation::NUMBER_OF_PRESETS },
      };

    o = PyvtkPointGaussianRepresentation_ShaderPresets_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPointGaussianRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPointGaussianRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPointGaussianRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPointGaussianRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

