// python wrapper for vtkPVTransferFunction2D
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkPVTransferFunction2D.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVTransferFunction2D(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVTransferFunction2D_ClassNew(); }


static PyObject *
PyvtkPVTransferFunction2D_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVTransferFunction2D::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVTransferFunction2D::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVTransferFunction2D *tempr = vtkPVTransferFunction2D::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVTransferFunction2D *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVTransferFunction2D::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVTransferFunction2D::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVTransferFunction2D::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_Build(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Build");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Build();
    }
    else
    {
      op->vtkPVTransferFunction2D::Build();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_SetOutputDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetOutputDimensions(temp0, temp1);
    }
    else
    {
      op->vtkPVTransferFunction2D::SetOutputDimensions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_SetOutputDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetOutputDimensions(temp0);
    }
    else
    {
      op->vtkPVTransferFunction2D::SetOutputDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_SetOutputDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVTransferFunction2D_SetOutputDimensions_s1(self, args);
    case 1:
      return PyvtkPVTransferFunction2D_SetOutputDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOutputDimensions");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2D_GetOutputDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetOutputDimensions() :
      op->vtkPVTransferFunction2D::GetOutputDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_AddControlBox_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  double temp6;
  double temp7;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(8) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5) &&
      ap.GetValue(temp6) &&
      ap.GetValue(temp7))
  {
    int tempr = (ap.IsBound() ?
      op->AddControlBox(temp0, temp1, temp2, temp3, temp4, temp5, temp6, temp7) :
      op->vtkPVTransferFunction2D::AddControlBox(temp0, temp1, temp2, temp3, temp4, temp5, temp6, temp7));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_AddControlBox_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  size_t size4 = ap.GetArgSize(4);
  vtkPythonArgs::Array<double> store4(2*size4);
  double *temp4 = store4.Data();
  double *save4 = (size4 == 0 ? nullptr : temp4 + size4);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetArray(temp4, size4))
  {
    vtkPythonArgs::Save(temp4, save4, size4);

    int tempr = (ap.IsBound() ?
      op->AddControlBox(temp0, temp1, temp2, temp3, temp4) :
      op->vtkPVTransferFunction2D::AddControlBox(temp0, temp1, temp2, temp3, temp4));

    if (vtkPythonArgs::HasChanged(temp4, save4, size4) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(4, temp4, size4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_AddControlBox_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  vtkRectd *temp0 = nullptr;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, "vtkRectd") &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    int tempr = (ap.IsBound() ?
      op->AddControlBox(*temp0, temp1) :
      op->vtkPVTransferFunction2D::AddControlBox(*temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_AddControlBox_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  vtkSmartPointer<vtkPVTransferFunction2DBox> temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVTransferFunction2DBox"))
  {
    int tempr = (ap.IsBound() ?
      op->AddControlBox(temp0) :
      op->vtkPVTransferFunction2D::AddControlBox(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_AddControlBox(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 8:
      return PyvtkPVTransferFunction2D_AddControlBox_s1(self, args);
    case 5:
      return PyvtkPVTransferFunction2D_AddControlBox_s2(self, args);
    case 2:
      return PyvtkPVTransferFunction2D_AddControlBox_s3(self, args);
    case 1:
      return PyvtkPVTransferFunction2D_AddControlBox_s4(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddControlBox");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2D_SetControlBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  int temp0;
  vtkSmartPointer<vtkPVTransferFunction2DBox> temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkPVTransferFunction2DBox"))
  {
    int tempr = (ap.IsBound() ?
      op->SetControlBox(temp0, temp1) :
      op->vtkPVTransferFunction2D::SetControlBox(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_RemoveControlBox_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->RemoveControlBox(temp0) :
      op->vtkPVTransferFunction2D::RemoveControlBox(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_RemoveControlBox_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveControlBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  vtkSmartPointer<vtkPVTransferFunction2DBox> temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVTransferFunction2DBox"))
  {
    int tempr = (ap.IsBound() ?
      op->RemoveControlBox(temp0) :
      op->vtkPVTransferFunction2D::RemoveControlBox(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVTransferFunction2D_RemoveControlBox_Methods[] = {
  {"RemoveControlBox", PyvtkPVTransferFunction2D_RemoveControlBox_s1, METH_VARARGS,
   "@i"},
  {"RemoveControlBox", PyvtkPVTransferFunction2D_RemoveControlBox_s2, METH_VARARGS,
   "@V *vtkPVTransferFunction2DBox"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVTransferFunction2D_RemoveControlBox(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVTransferFunction2D_RemoveControlBox_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RemoveControlBox");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2D_GetBoxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::vector<vtkSmartPointer<vtkPVTransferFunction2DBox>> tempr = (ap.IsBound() ?
      op->GetBoxes() :
      op->vtkPVTransferFunction2D::GetBoxes());

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_RemoveAllBoxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBoxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBoxes();
    }
    else
    {
      op->vtkPVTransferFunction2D::RemoveAllBoxes();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_SetRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetRange(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVTransferFunction2D::SetRange(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_SetRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetRange(temp0);
    }
    else
    {
      op->vtkPVTransferFunction2D::SetRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransferFunction2D_SetRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkPVTransferFunction2D_SetRange_s1(self, args);
    case 1:
      return PyvtkPVTransferFunction2D_SetRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetRange");
  return nullptr;
}


static PyObject *
PyvtkPVTransferFunction2D_GetRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  size_t sizer = 4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetRange() :
      op->vtkPVTransferFunction2D::GetRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransferFunction2D_GetFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransferFunction2D *op = static_cast<vtkPVTransferFunction2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageData *tempr = (ap.IsBound() ?
      op->GetFunction() :
      op->vtkPVTransferFunction2D::GetFunction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVTransferFunction2D_Methods[] = {
  {"IsTypeOf", PyvtkPVTransferFunction2D_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVTransferFunction2D_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVTransferFunction2D_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVTransferFunction2D\nC++: static vtkPVTransferFunction2D *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVTransferFunction2D_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVTransferFunction2D\nC++: vtkPVTransferFunction2D *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVTransferFunction2D_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVTransferFunction2D_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Build", PyvtkPVTransferFunction2D_Build, METH_VARARGS,
   "Build(self) -> None\nC++: virtual void Build()\n\nGenerate the transfer function image data\n"},
  {"SetOutputDimensions", PyvtkPVTransferFunction2D_SetOutputDimensions, METH_VARARGS,
   "SetOutputDimensions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetOutputDimensions(int _arg1, int _arg2)\nSetOutputDimensions(self, _arg:(int, int)) -> None\nC++: void SetOutputDimensions(const int _arg[2])\n\nSet/Get the output dimensions of the image data that is the\ntransfer function. By default, this is (10, 10).\n"},
  {"GetOutputDimensions", PyvtkPVTransferFunction2D_GetOutputDimensions, METH_VARARGS,
   "GetOutputDimensions(self) -> (int, int)\nC++: virtual int *GetOutputDimensions()\n\n"},
  {"AddControlBox", PyvtkPVTransferFunction2D_AddControlBox, METH_VARARGS,
   "AddControlBox(self, x:float, y:float, width:float, height:float,\n    r:float, g:float, b:float, a:float) -> int\nC++: int AddControlBox(double x, double y, double width,\n    double height, double r, double g, double b, double a)\nAddControlBox(self, x:float, y:float, width:float, height:float,\n    color:[float, ...]) -> int\nC++: int AddControlBox(double x, double y, double width,\n    double height, double *color)\nAddControlBox(self, box:vtkRectd, color:[float, ...]) -> int\nC++: int AddControlBox(vtkRectd &box, double *color)\nAddControlBox(self, box:vtkPVTransferFunction2DBox) -> int\nC++: int AddControlBox(\n    vtkSmartPointer<vtkPVTransferFunction2DBox> box)\n\nAdd/Remove a control box to/from the 2D transfer function.\nReturns the index of the added box or -1 on error.\n\note This function does not check to see if the box already exists\nin the function before adding it. Adding an existing box would\nadd a duplicate control to the transfer function.\n"},
  {"SetControlBox", PyvtkPVTransferFunction2D_SetControlBox, METH_VARARGS,
   "SetControlBox(self, id:int, box:vtkPVTransferFunction2DBox) -> int\nC++: int SetControlBox(int id,\n    vtkSmartPointer<vtkPVTransferFunction2DBox> box)\n\n"},
  {"RemoveControlBox", PyvtkPVTransferFunction2D_RemoveControlBox, METH_VARARGS,
   "RemoveControlBox(self, id:int) -> int\nC++: int RemoveControlBox(int id)\nRemoveControlBox(self, box:vtkPVTransferFunction2DBox) -> int\nC++: int RemoveControlBox(\n    vtkSmartPointer<vtkPVTransferFunction2DBox> box)\n\n"},
  {"GetBoxes", PyvtkPVTransferFunction2D_GetBoxes, METH_VARARGS,
   "GetBoxes(self) -> (vtkPVTransferFunction2DBox, ...)\nC++: std::vector<vtkSmartPointer<vtkPVTransferFunction2DBox> > GetBoxes(\n    )\n\nGet the control boxes defined on the function.\n"},
  {"RemoveAllBoxes", PyvtkPVTransferFunction2D_RemoveAllBoxes, METH_VARARGS,
   "RemoveAllBoxes(self) -> None\nC++: void RemoveAllBoxes()\n\nRemove all control boxes from the transfer function.\n"},
  {"SetRange", PyvtkPVTransferFunction2D_SetRange, METH_VARARGS,
   "SetRange(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float)\n     -> None\nC++: virtual void SetRange(double _arg1, double _arg2,\n    double _arg3, double _arg4)\nSetRange(self, _arg:(float, float, float, float)) -> None\nC++: virtual void SetRange(const double _arg[4])\n\nSet/Get the range of the function. Set/Get the (minX, maxX, minY,\nmaxY) for the 2D transfer function.\n"},
  {"GetRange", PyvtkPVTransferFunction2D_GetRange, METH_VARARGS,
   "GetRange(self) -> (float, float, float, float)\nC++: virtual double *GetRange()\n\n"},
  {"GetFunction", PyvtkPVTransferFunction2D_GetFunction, METH_VARARGS,
   "GetFunction(self) -> vtkImageData\nC++: vtkImageData *GetFunction()\n\nGet the 2D transfer function.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVTransferFunction2D_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("output_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2D_GetOutputDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2D_SetOutputDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2D_SetOutputDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputDimensions/SetOutputDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2D_GetRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransferFunction2D_SetRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransferFunction2D_SetRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRange/SetRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("boxes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2D_GetBoxes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBoxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("function"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransferFunction2D_GetFunction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFunction\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVTransferFunction2D_Doc =
  "vtkPVTransferFunction2D - Defines a 2D transfer function for mapping\nto RGBA values for volume rendering.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVTransferFunction2D is a color mapping in RGBA space that uses 2D\n"
  "functions to allow interpolation along both the X and Y axes of the\n"
  "function.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVTransferFunction2D_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVTransferFunction2D", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVTransferFunction2D_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVTransferFunction2D_StaticNew()
{
  return vtkPVTransferFunction2D::New();
}

PyObject *PyvtkPVTransferFunction2D_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVTransferFunction2D_Type, PyvtkPVTransferFunction2D_Methods,
    "vtkPVTransferFunction2D",
 &PyvtkPVTransferFunction2D_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVTransferFunction2D_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVTransferFunction2D(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVTransferFunction2D_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVTransferFunction2D", o) != 0)
  {
    Py_DECREF(o);
  }

}

