// python wrapper for vtkSMUndoStackBuilder
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMUndoStackBuilder.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMUndoStackBuilder(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMUndoStackBuilder_ClassNew(); }

#ifndef DECLARED_PyvtkSMObject_ClassNew
extern "C" { PyObject *PyvtkSMObject_ClassNew(); }
#define DECLARED_PyvtkSMObject_ClassNew
#endif

static PyObject *
PyvtkSMUndoStackBuilder_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMUndoStackBuilder::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMUndoStackBuilder::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMUndoStackBuilder *tempr = vtkSMUndoStackBuilder::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMUndoStackBuilder *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMUndoStackBuilder::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMUndoStackBuilder::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMUndoStackBuilder::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_Begin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Begin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Begin(temp0);
    }
    else
    {
      op->vtkSMUndoStackBuilder::Begin(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_End(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "End");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->End();
    }
    else
    {
      op->vtkSMUndoStackBuilder::End();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_EndAndPushToStack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndAndPushToStack");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EndAndPushToStack();
    }
    else
    {
      op->vtkSMUndoStackBuilder::EndAndPushToStack();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_PushToStack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PushToStack");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PushToStack();
    }
    else
    {
      op->vtkSMUndoStackBuilder::PushToStack();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Clear();
    }
    else
    {
      op->vtkSMUndoStackBuilder::Clear();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_Add(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Add");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  vtkUndoElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkUndoElement"))
  {
    bool tempr = (ap.IsBound() ?
      op->Add(temp0) :
      op->vtkSMUndoStackBuilder::Add(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_GetUndoStack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUndoStack");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMUndoStack *tempr = (ap.IsBound() ?
      op->GetUndoStack() :
      op->vtkSMUndoStackBuilder::GetUndoStack());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_SetUndoStack(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUndoStack");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  vtkSMUndoStack *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMUndoStack"))
  {
    if (ap.IsBound())
    {
      op->SetUndoStack(temp0);
    }
    else
    {
      op->vtkSMUndoStackBuilder::SetUndoStack(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_SetIgnoreAllChanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIgnoreAllChanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIgnoreAllChanges(temp0);
    }
    else
    {
      op->vtkSMUndoStackBuilder::SetIgnoreAllChanges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMUndoStackBuilder_GetIgnoreAllChanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIgnoreAllChanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMUndoStackBuilder *op = static_cast<vtkSMUndoStackBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIgnoreAllChanges() :
      op->vtkSMUndoStackBuilder::GetIgnoreAllChanges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMUndoStackBuilder_Methods[] = {
  {"IsTypeOf", PyvtkSMUndoStackBuilder_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMUndoStackBuilder_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMUndoStackBuilder_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMUndoStackBuilder\nC++: static vtkSMUndoStackBuilder *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMUndoStackBuilder_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMUndoStackBuilder\nC++: vtkSMUndoStackBuilder *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMUndoStackBuilder_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMUndoStackBuilder_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Begin", PyvtkSMUndoStackBuilder_Begin, METH_VARARGS,
   "Begin(self, label:str) -> None\nC++: virtual void Begin(const char *label)\n\nBegins monitoring of the vtkSMProxyManager for undoable\noperations. All noted actions are converted to UndoElements and\ncollected. One vtkUndoElement is created per action. All undo\nelements become a part of a vtkUndoSet which is pushed on to the\nUndo Stack on PushToStack().label is a suggestion for the UndoSet\nthat will be built. If the UndoSet already has elements implying\nit hasn't been pushed to the stack then the label is ignored.\n"},
  {"End", PyvtkSMUndoStackBuilder_End, METH_VARARGS,
   "End(self) -> None\nC++: virtual void End()\n\nStops monitoring of the vtkSMProxyManager for undoable\noperations. Any changes made to the proxy manager will not be\nconverted to UndoElements. This method does not push the\nvtkUndoSet of undo elements built. One must call PushToStack() to\npush the UndoSet to the Undo stack. Alternatively, one can use\nthe EndAndPushToStack() method which combines End() and\nPushToStack().\n"},
  {"EndAndPushToStack", PyvtkSMUndoStackBuilder_EndAndPushToStack, METH_VARARGS,
   "EndAndPushToStack(self) -> None\nC++: void EndAndPushToStack()\n\nConvenience method call End(); PushToStack(); in that order.\n"},
  {"PushToStack", PyvtkSMUndoStackBuilder_PushToStack, METH_VARARGS,
   "PushToStack(self) -> None\nC++: virtual void PushToStack()\n\nIf any undoable changes were recorded by the builder, this will\npush the vtkUndoSet formed on to the UndoStack. The UndoStack\nwhich the builder is building must be set by using\nSetUndoStack(). If the UndoSet is empty, it is not pushed on the\nstack. After pushing, the UndoSet is cleared so the builder is\nready to collect new modifications.\n"},
  {"Clear", PyvtkSMUndoStackBuilder_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: virtual void Clear()\n\nDiscard all recorded changes that haven't been pushed on the\nUndoStack.\n"},
  {"Add", PyvtkSMUndoStackBuilder_Add, METH_VARARGS,
   "Add(self, element:vtkUndoElement) -> bool\nC++: virtual bool Add(vtkUndoElement *element)\n\nOne can add arbitrary elements to the active undo set. It is\nessential that the StateLoader on the UndoStack can handle the\narbitrary undo elements. If that element has been escaped for any\nreason, the method will return false;\n"},
  {"GetUndoStack", PyvtkSMUndoStackBuilder_GetUndoStack, METH_VARARGS,
   "GetUndoStack(self) -> vtkSMUndoStack\nC++: virtual vtkSMUndoStack *GetUndoStack()\n\nGet/Set the undo stack that this builder will build.\n"},
  {"SetUndoStack", PyvtkSMUndoStackBuilder_SetUndoStack, METH_VARARGS,
   "SetUndoStack(self, __a:vtkSMUndoStack) -> None\nC++: virtual void SetUndoStack(vtkSMUndoStack *)\n\n"},
  {"SetIgnoreAllChanges", PyvtkSMUndoStackBuilder_SetIgnoreAllChanges, METH_VARARGS,
   "SetIgnoreAllChanges(self, _arg:bool) -> None\nC++: virtual void SetIgnoreAllChanges(bool _arg)\n\nIf IgnoreAllChanges is true, any server manager changes will be\nignored even if the changes happened within a Begin()-End() call.\nThis provides a mechanism for the application to perform\nnon-undoable operations irrespective of whether a undo set if\nbeing built. By default, it is set to false.\n"},
  {"GetIgnoreAllChanges", PyvtkSMUndoStackBuilder_GetIgnoreAllChanges, METH_VARARGS,
   "GetIgnoreAllChanges(self) -> bool\nC++: virtual bool GetIgnoreAllChanges()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMUndoStackBuilder_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("undo_stack"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMUndoStackBuilder_GetUndoStack(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMUndoStackBuilder_SetUndoStack(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMUndoStackBuilder_SetUndoStack(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUndoStack/SetUndoStack\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ignore_all_changes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMUndoStackBuilder_GetIgnoreAllChanges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMUndoStackBuilder_SetIgnoreAllChanges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMUndoStackBuilder_SetIgnoreAllChanges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIgnoreAllChanges/SetIgnoreAllChanges\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMUndoStackBuilder_Doc =
  "vtkSMUndoStackBuilder - builds server manager undo sets and pushes\nthem on the undo stack.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMUndoStackBuilder records Server Manager changes that are\n"
  "undo/redo able and collects them. To begin recording such changes one\n"
  "must call Begin(). To end recording use End(). One can have multiple\n"
  "blocks of Begin-End before pushing the changes on the Undo Stack. To\n"
  "push all collected changes onto the Undo Stack as a single undoable\n"
  "step, use PushToStack(). Applications can subclass\n"
  "vtkSMUndoStackBuilder to record GUI related changes and add them to\n"
  "the undo stack.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMUndoStackBuilder_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMUndoStackBuilder", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMUndoStackBuilder_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMUndoStackBuilder_StaticNew()
{
  return vtkSMUndoStackBuilder::New();
}

PyObject *PyvtkSMUndoStackBuilder_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMUndoStackBuilder_Type, PyvtkSMUndoStackBuilder_Methods,
    "vtkSMUndoStackBuilder",
 &PyvtkSMUndoStackBuilder_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMObject_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMUndoStackBuilder_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMUndoStackBuilder(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMUndoStackBuilder_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMUndoStackBuilder", o) != 0)
  {
    Py_DECREF(o);
  }

}

