// python wrapper for vtkPVGL2PSExporter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVGL2PSExporter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVGL2PSExporter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVGL2PSExporter_ClassNew(); }


static PyObject *
PyvtkPVGL2PSExporter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVGL2PSExporter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVGL2PSExporter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVGL2PSExporter *tempr = vtkPVGL2PSExporter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVGL2PSExporter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVGL2PSExporter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVGL2PSExporter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVGL2PSExporter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkPVGL2PSExporter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkPVGL2PSExporter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_SetExcludeCubeAxesActorsFromRasterization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeCubeAxesActorsFromRasterization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeCubeAxesActorsFromRasterization(temp0);
    }
    else
    {
      op->vtkPVGL2PSExporter::SetExcludeCubeAxesActorsFromRasterization(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_GetExcludeCubeAxesActorsFromRasterization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeCubeAxesActorsFromRasterization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetExcludeCubeAxesActorsFromRasterization() :
      op->vtkPVGL2PSExporter::GetExcludeCubeAxesActorsFromRasterization());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_ExcludeCubeAxesActorsFromRasterizationOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExcludeCubeAxesActorsFromRasterizationOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExcludeCubeAxesActorsFromRasterizationOn();
    }
    else
    {
      op->vtkPVGL2PSExporter::ExcludeCubeAxesActorsFromRasterizationOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGL2PSExporter_ExcludeCubeAxesActorsFromRasterizationOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExcludeCubeAxesActorsFromRasterizationOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGL2PSExporter *op = static_cast<vtkPVGL2PSExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExcludeCubeAxesActorsFromRasterizationOff();
    }
    else
    {
      op->vtkPVGL2PSExporter::ExcludeCubeAxesActorsFromRasterizationOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVGL2PSExporter_Methods[] = {
  {"IsTypeOf", PyvtkPVGL2PSExporter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVGL2PSExporter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVGL2PSExporter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVGL2PSExporter\nC++: static vtkPVGL2PSExporter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVGL2PSExporter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVGL2PSExporter\nC++: vtkPVGL2PSExporter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVGL2PSExporter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVGL2PSExporter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkPVGL2PSExporter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nSet/Get the name of the output file.\n"},
  {"GetFileName", PyvtkPVGL2PSExporter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: const char *GetFileName()\n\n"},
  {"SetExcludeCubeAxesActorsFromRasterization", PyvtkPVGL2PSExporter_SetExcludeCubeAxesActorsFromRasterization, METH_VARARGS,
   "SetExcludeCubeAxesActorsFromRasterization(self, _arg:int) -> None\nC++: virtual void SetExcludeCubeAxesActorsFromRasterization(\n    int _arg)\n\nIf Write3DPropsAsRasterImage is true, add all instances of\nvtkCubeAxesActors to the RenderExclusions.\n"},
  {"GetExcludeCubeAxesActorsFromRasterization", PyvtkPVGL2PSExporter_GetExcludeCubeAxesActorsFromRasterization, METH_VARARGS,
   "GetExcludeCubeAxesActorsFromRasterization(self) -> int\nC++: virtual int GetExcludeCubeAxesActorsFromRasterization()\n\n"},
  {"ExcludeCubeAxesActorsFromRasterizationOn", PyvtkPVGL2PSExporter_ExcludeCubeAxesActorsFromRasterizationOn, METH_VARARGS,
   "ExcludeCubeAxesActorsFromRasterizationOn(self) -> None\nC++: virtual void ExcludeCubeAxesActorsFromRasterizationOn()\n\n"},
  {"ExcludeCubeAxesActorsFromRasterizationOff", PyvtkPVGL2PSExporter_ExcludeCubeAxesActorsFromRasterizationOff, METH_VARARGS,
   "ExcludeCubeAxesActorsFromRasterizationOff(self) -> None\nC++: virtual void ExcludeCubeAxesActorsFromRasterizationOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVGL2PSExporter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGL2PSExporter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGL2PSExporter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGL2PSExporter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_cube_axes_actors_from_rasterization"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGL2PSExporter_GetExcludeCubeAxesActorsFromRasterization(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGL2PSExporter_SetExcludeCubeAxesActorsFromRasterization(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGL2PSExporter_SetExcludeCubeAxesActorsFromRasterization(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeCubeAxesActorsFromRasterization/SetExcludeCubeAxesActorsFromRasterization\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVGL2PSExporter_Doc =
  "vtkPVGL2PSExporter - ParaView wrapper for vtkGL2PS exporter.\n\n"
  "Superclass: vtkOpenGLGL2PSExporter\n\n"
  "This is used to export ParaView renderings to a variety of vector\n"
  "graphics formats.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGL2PSExporter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingExport.vtkPVGL2PSExporter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVGL2PSExporter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVGL2PSExporter_StaticNew()
{
  return vtkPVGL2PSExporter::New();
}

PyObject *PyvtkPVGL2PSExporter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVGL2PSExporter_Type, PyvtkPVGL2PSExporter_Methods,
    "vtkPVGL2PSExporter",
 &PyvtkPVGL2PSExporter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkOpenGLGL2PSExporter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVGL2PSExporter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVGL2PSExporter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVGL2PSExporter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVGL2PSExporter", o) != 0)
  {
    Py_DECREF(o);
  }

}

