// python wrapper for vtkLegacyParticleTracerBase
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkLegacyParticleTracerBase.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkLegacyParticleTracerBase(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkLegacyParticleTracerBase_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkLegacyParticleTracerBase_Solvers_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneralMPI.vtkLegacyParticleTracerBase.Solvers", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkLegacyParticleTracerBase_Solvers_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkLegacyParticleTracerBase_Solvers_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneralMPI.vtkLegacyParticleTracerBase.MeshOverTimeTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkLegacyParticleTracerBase_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkLegacyParticleTracerBase::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkLegacyParticleTracerBase::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkLegacyParticleTracerBase *tempr = vtkLegacyParticleTracerBase::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkLegacyParticleTracerBase *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkLegacyParticleTracerBase::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkLegacyParticleTracerBase::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkLegacyParticleTracerBase::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_PrintParticleHistories(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrintParticleHistories");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrintParticleHistories();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::PrintParticleHistories();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetComputeVorticity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeVorticity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeVorticity() :
      op->vtkLegacyParticleTracerBase::GetComputeVorticity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetComputeVorticity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeVorticity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeVorticity(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetComputeVorticity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetTerminalSpeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTerminalSpeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTerminalSpeed() :
      op->vtkLegacyParticleTracerBase::GetTerminalSpeed());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetTerminalSpeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTerminalSpeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTerminalSpeed(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetTerminalSpeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetRotationScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRotationScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRotationScale() :
      op->vtkLegacyParticleTracerBase::GetRotationScale());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetRotationScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRotationScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRotationScale(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetRotationScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetIgnorePipelineTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIgnorePipelineTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIgnorePipelineTime(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetIgnorePipelineTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetIgnorePipelineTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIgnorePipelineTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIgnorePipelineTime() :
      op->vtkLegacyParticleTracerBase::GetIgnorePipelineTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_IgnorePipelineTimeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IgnorePipelineTimeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IgnorePipelineTimeOn();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::IgnorePipelineTimeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_IgnorePipelineTimeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IgnorePipelineTimeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IgnorePipelineTimeOff();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::IgnorePipelineTimeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetForceReinjectionEveryNSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceReinjectionEveryNSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetForceReinjectionEveryNSteps() :
      op->vtkLegacyParticleTracerBase::GetForceReinjectionEveryNSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetForceReinjectionEveryNSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceReinjectionEveryNSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceReinjectionEveryNSteps(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetForceReinjectionEveryNSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetTerminationTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTerminationTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTerminationTime(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetTerminationTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetTerminationTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTerminationTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTerminationTime() :
      op->vtkLegacyParticleTracerBase::GetTerminationTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetIntegrator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIntegrator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  vtkInitialValueProblemSolver *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkInitialValueProblemSolver"))
  {
    if (ap.IsBound())
    {
      op->SetIntegrator(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetIntegrator(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetIntegrator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIntegrator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkInitialValueProblemSolver *tempr = (ap.IsBound() ?
      op->GetIntegrator() :
      op->vtkLegacyParticleTracerBase::GetIntegrator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetIntegratorType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIntegratorType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIntegratorType(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetIntegratorType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetIntegratorType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIntegratorType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIntegratorType() :
      op->vtkLegacyParticleTracerBase::GetIntegratorType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetStartTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStartTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetStartTime() :
      op->vtkLegacyParticleTracerBase::GetStartTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetStartTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStartTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStartTime(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetStartTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetStaticSeeds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStaticSeeds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStaticSeeds(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetStaticSeeds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetStaticSeeds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStaticSeeds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStaticSeeds() :
      op->vtkLegacyParticleTracerBase::GetStaticSeeds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetMeshOverTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMeshOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMeshOverTime(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetMeshOverTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetMeshOverTimeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMeshOverTimeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMeshOverTimeMinValue() :
      op->vtkLegacyParticleTracerBase::GetMeshOverTimeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetMeshOverTimeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMeshOverTimeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMeshOverTimeMaxValue() :
      op->vtkLegacyParticleTracerBase::GetMeshOverTimeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetMeshOverTimeToDifferent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMeshOverTimeToDifferent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMeshOverTimeToDifferent();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetMeshOverTimeToDifferent();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetMeshOverTimeToStatic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMeshOverTimeToStatic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMeshOverTimeToStatic();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetMeshOverTimeToStatic();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetMeshOverTimeToLinearTransformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMeshOverTimeToLinearTransformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMeshOverTimeToLinearTransformation();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetMeshOverTimeToLinearTransformation();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetMeshOverTimeToSameTopology(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMeshOverTimeToSameTopology");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMeshOverTimeToSameTopology();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetMeshOverTimeToSameTopology();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetMeshOverTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMeshOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMeshOverTime() :
      op->vtkLegacyParticleTracerBase::GetMeshOverTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetStaticMesh(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method SetStaticMesh."
    " (" "Use SetMeshOverTime instead" ")"
    " -- Deprecated since version " "9.2.0" ".", 1);

  vtkPythonArgs ap(self, args, "SetStaticMesh");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStaticMesh(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetStaticMesh(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetStaticMesh(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method GetStaticMesh."
    " (" "Use GetMeshOverTime instead" ")"
    " -- Deprecated since version " "9.2.0" ".", 1);

  vtkPythonArgs ap(self, args, "GetStaticMesh");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStaticMesh() :
      op->vtkLegacyParticleTracerBase::GetStaticMesh());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetInterpolatorType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolatorType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolatorType(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetInterpolatorType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetInterpolatorTypeToDataSetPointLocator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolatorTypeToDataSetPointLocator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolatorTypeToDataSetPointLocator();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetInterpolatorTypeToDataSetPointLocator();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetInterpolatorTypeToCellLocator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolatorTypeToCellLocator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolatorTypeToCellLocator();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetInterpolatorTypeToCellLocator();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetParticleWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParticleWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  vtkAbstractParticleWriter *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAbstractParticleWriter"))
  {
    if (ap.IsBound())
    {
      op->SetParticleWriter(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetParticleWriter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetParticleWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParticleWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAbstractParticleWriter *tempr = (ap.IsBound() ?
      op->GetParticleWriter() :
      op->vtkLegacyParticleTracerBase::GetParticleWriter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetParticleFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParticleFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetParticleFileName(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetParticleFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetParticleFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParticleFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetParticleFileName() :
      op->vtkLegacyParticleTracerBase::GetParticleFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetEnableParticleWriting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableParticleWriting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableParticleWriting(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetEnableParticleWriting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetEnableParticleWriting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableParticleWriting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEnableParticleWriting() :
      op->vtkLegacyParticleTracerBase::GetEnableParticleWriting());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_EnableParticleWritingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableParticleWritingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableParticleWritingOn();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::EnableParticleWritingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_EnableParticleWritingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableParticleWritingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableParticleWritingOff();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::EnableParticleWritingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetDisableResetCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisableResetCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisableResetCache(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetDisableResetCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetDisableResetCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableResetCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDisableResetCache() :
      op->vtkLegacyParticleTracerBase::GetDisableResetCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_DisableResetCacheOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableResetCacheOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableResetCacheOn();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::DisableResetCacheOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_DisableResetCacheOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableResetCacheOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableResetCacheOff();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::DisableResetCacheOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_AddSourceConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddSourceConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddSourceConnection(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::AddSourceConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_RemoveAllSources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllSources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllSources();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::RemoveAllSources();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_GetForceSerialExecution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceSerialExecution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceSerialExecution() :
      op->vtkLegacyParticleTracerBase::GetForceSerialExecution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_SetForceSerialExecution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceSerialExecution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceSerialExecution(temp0);
    }
    else
    {
      op->vtkLegacyParticleTracerBase::SetForceSerialExecution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_ForceSerialExecutionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ForceSerialExecutionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ForceSerialExecutionOn();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::ForceSerialExecutionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLegacyParticleTracerBase_ForceSerialExecutionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ForceSerialExecutionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLegacyParticleTracerBase *op = static_cast<vtkLegacyParticleTracerBase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ForceSerialExecutionOff();
    }
    else
    {
      op->vtkLegacyParticleTracerBase::ForceSerialExecutionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkLegacyParticleTracerBase_Methods[] = {
  {"IsTypeOf", PyvtkLegacyParticleTracerBase_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkLegacyParticleTracerBase_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkLegacyParticleTracerBase_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkLegacyParticleTracerBase\nC++: static vtkLegacyParticleTracerBase *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkLegacyParticleTracerBase_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkLegacyParticleTracerBase\nC++: vtkLegacyParticleTracerBase *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkLegacyParticleTracerBase_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkLegacyParticleTracerBase_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"PrintParticleHistories", PyvtkLegacyParticleTracerBase_PrintParticleHistories, METH_VARARGS,
   "PrintParticleHistories(self) -> None\nC++: void PrintParticleHistories()\n\n"},
  {"GetComputeVorticity", PyvtkLegacyParticleTracerBase_GetComputeVorticity, METH_VARARGS,
   "GetComputeVorticity(self) -> bool\nC++: virtual bool GetComputeVorticity()\n\nTurn on/off vorticity computation at streamline points (necessary\nfor generating proper stream-ribbons using the vtkRibbonFilter.\n"},
  {"SetComputeVorticity", PyvtkLegacyParticleTracerBase_SetComputeVorticity, METH_VARARGS,
   "SetComputeVorticity(self, __a:bool) -> None\nC++: void SetComputeVorticity(bool)\n\n"},
  {"GetTerminalSpeed", PyvtkLegacyParticleTracerBase_GetTerminalSpeed, METH_VARARGS,
   "GetTerminalSpeed(self) -> float\nC++: virtual double GetTerminalSpeed()\n\nSpecify the terminal speed value, below which integration is\nterminated.\n"},
  {"SetTerminalSpeed", PyvtkLegacyParticleTracerBase_SetTerminalSpeed, METH_VARARGS,
   "SetTerminalSpeed(self, __a:float) -> None\nC++: void SetTerminalSpeed(double)\n\n"},
  {"GetRotationScale", PyvtkLegacyParticleTracerBase_GetRotationScale, METH_VARARGS,
   "GetRotationScale(self) -> float\nC++: virtual double GetRotationScale()\n\nThis can be used to scale the rate with which the streamribbons\ntwist. The default is 1.\n"},
  {"SetRotationScale", PyvtkLegacyParticleTracerBase_SetRotationScale, METH_VARARGS,
   "SetRotationScale(self, __a:float) -> None\nC++: void SetRotationScale(double)\n\n"},
  {"SetIgnorePipelineTime", PyvtkLegacyParticleTracerBase_SetIgnorePipelineTime, METH_VARARGS,
   "SetIgnorePipelineTime(self, _arg:int) -> None\nC++: virtual void SetIgnorePipelineTime(vtkTypeBool _arg)\n\nTo get around problems with the Paraview Animation controls we\ncan just animate the time step and ignore the TIME_ requests\n"},
  {"GetIgnorePipelineTime", PyvtkLegacyParticleTracerBase_GetIgnorePipelineTime, METH_VARARGS,
   "GetIgnorePipelineTime(self) -> int\nC++: virtual vtkTypeBool GetIgnorePipelineTime()\n\n"},
  {"IgnorePipelineTimeOn", PyvtkLegacyParticleTracerBase_IgnorePipelineTimeOn, METH_VARARGS,
   "IgnorePipelineTimeOn(self) -> None\nC++: virtual void IgnorePipelineTimeOn()\n\n"},
  {"IgnorePipelineTimeOff", PyvtkLegacyParticleTracerBase_IgnorePipelineTimeOff, METH_VARARGS,
   "IgnorePipelineTimeOff(self) -> None\nC++: virtual void IgnorePipelineTimeOff()\n\n"},
  {"GetForceReinjectionEveryNSteps", PyvtkLegacyParticleTracerBase_GetForceReinjectionEveryNSteps, METH_VARARGS,
   "GetForceReinjectionEveryNSteps(self) -> int\nC++: virtual int GetForceReinjectionEveryNSteps()\n\nWhen animating particles, it is nice to inject new ones every Nth\nstep to produce a continuous flow. Setting\nForceReinjectionEveryNSteps to a non zero value will cause the\nparticle source to reinject particles every Nth step even if it\nis otherwise unchanged. Note that if the particle source is also\nanimated, this flag will be redundant as the particles will be\nreinjected whenever the source changes anyway\n"},
  {"SetForceReinjectionEveryNSteps", PyvtkLegacyParticleTracerBase_SetForceReinjectionEveryNSteps, METH_VARARGS,
   "SetForceReinjectionEveryNSteps(self, __a:int) -> None\nC++: void SetForceReinjectionEveryNSteps(int)\n\n"},
  {"SetTerminationTime", PyvtkLegacyParticleTracerBase_SetTerminationTime, METH_VARARGS,
   "SetTerminationTime(self, t:float) -> None\nC++: void SetTerminationTime(double t)\n\nSetting TerminationTime to a positive value will cause particles\nto terminate when the time is reached. Use a vlue of zero to\ndisable termination. The units of time should be consistent with\nthe primary time variable.\n"},
  {"GetTerminationTime", PyvtkLegacyParticleTracerBase_GetTerminationTime, METH_VARARGS,
   "GetTerminationTime(self) -> float\nC++: virtual double GetTerminationTime()\n\n"},
  {"SetIntegrator", PyvtkLegacyParticleTracerBase_SetIntegrator, METH_VARARGS,
   "SetIntegrator(self, __a:vtkInitialValueProblemSolver) -> None\nC++: void SetIntegrator(vtkInitialValueProblemSolver *)\n\n"},
  {"GetIntegrator", PyvtkLegacyParticleTracerBase_GetIntegrator, METH_VARARGS,
   "GetIntegrator(self) -> vtkInitialValueProblemSolver\nC++: virtual vtkInitialValueProblemSolver *GetIntegrator()\n\n"},
  {"SetIntegratorType", PyvtkLegacyParticleTracerBase_SetIntegratorType, METH_VARARGS,
   "SetIntegratorType(self, type:int) -> None\nC++: void SetIntegratorType(int type)\n\n"},
  {"GetIntegratorType", PyvtkLegacyParticleTracerBase_GetIntegratorType, METH_VARARGS,
   "GetIntegratorType(self) -> int\nC++: int GetIntegratorType()\n\n"},
  {"GetStartTime", PyvtkLegacyParticleTracerBase_GetStartTime, METH_VARARGS,
   "GetStartTime(self) -> float\nC++: virtual double GetStartTime()\n\nSet the time value for particle tracing to begin. The units of\ntime should be consistent with the primary time variable.\n"},
  {"SetStartTime", PyvtkLegacyParticleTracerBase_SetStartTime, METH_VARARGS,
   "SetStartTime(self, t:float) -> None\nC++: void SetStartTime(double t)\n\n"},
  {"SetStaticSeeds", PyvtkLegacyParticleTracerBase_SetStaticSeeds, METH_VARARGS,
   "SetStaticSeeds(self, _arg:int) -> None\nC++: virtual void SetStaticSeeds(vtkTypeBool _arg)\n\nif StaticSeeds is set and the mesh is static, then every time\nparticles are injected we can re-use the same injection\ninformation. We classify particles according to processor just\nonce before start. If StaticSeeds is set and a moving seed source\nis specified the motion will be ignored and results will not be\nas expected. The default is that StaticSeeds is 0.\n"},
  {"GetStaticSeeds", PyvtkLegacyParticleTracerBase_GetStaticSeeds, METH_VARARGS,
   "GetStaticSeeds(self) -> int\nC++: virtual vtkTypeBool GetStaticSeeds()\n\n"},
  {"SetMeshOverTime", PyvtkLegacyParticleTracerBase_SetMeshOverTime, METH_VARARGS,
   "SetMeshOverTime(self, meshOverTime:int) -> None\nC++: virtual void SetMeshOverTime(int meshOverTime)\n\n"},
  {"GetMeshOverTimeMinValue", PyvtkLegacyParticleTracerBase_GetMeshOverTimeMinValue, METH_VARARGS,
   "GetMeshOverTimeMinValue(self) -> int\nC++: virtual int GetMeshOverTimeMinValue()\n\n"},
  {"GetMeshOverTimeMaxValue", PyvtkLegacyParticleTracerBase_GetMeshOverTimeMaxValue, METH_VARARGS,
   "GetMeshOverTimeMaxValue(self) -> int\nC++: virtual int GetMeshOverTimeMaxValue()\n\n"},
  {"SetMeshOverTimeToDifferent", PyvtkLegacyParticleTracerBase_SetMeshOverTimeToDifferent, METH_VARARGS,
   "SetMeshOverTimeToDifferent(self) -> None\nC++: void SetMeshOverTimeToDifferent()\n\n"},
  {"SetMeshOverTimeToStatic", PyvtkLegacyParticleTracerBase_SetMeshOverTimeToStatic, METH_VARARGS,
   "SetMeshOverTimeToStatic(self) -> None\nC++: void SetMeshOverTimeToStatic()\n\n"},
  {"SetMeshOverTimeToLinearTransformation", PyvtkLegacyParticleTracerBase_SetMeshOverTimeToLinearTransformation, METH_VARARGS,
   "SetMeshOverTimeToLinearTransformation(self) -> None\nC++: void SetMeshOverTimeToLinearTransformation()\n\n"},
  {"SetMeshOverTimeToSameTopology", PyvtkLegacyParticleTracerBase_SetMeshOverTimeToSameTopology, METH_VARARGS,
   "SetMeshOverTimeToSameTopology(self) -> None\nC++: void SetMeshOverTimeToSameTopology()\n\n"},
  {"GetMeshOverTime", PyvtkLegacyParticleTracerBase_GetMeshOverTime, METH_VARARGS,
   "GetMeshOverTime(self) -> int\nC++: virtual int GetMeshOverTime()\n\n"},
  {"SetStaticMesh", PyvtkLegacyParticleTracerBase_SetStaticMesh, METH_VARARGS,
   "SetStaticMesh(self, staticMesh:int) -> None\nC++: virtual void SetStaticMesh(vtkTypeBool staticMesh)\n\nif StaticMesh is set, many optimizations for cell caching can be\nassumed. if StaticMesh is not set, the algorithm will attempt to\nfind out if optimizations can be used, but setting it to true\nwill force all optimizations. Do not Set StaticMesh to true if a\ndynamic mesh is being used as this will invalidate all results.\nThe default is that StaticMesh is 0.\n"},
  {"GetStaticMesh", PyvtkLegacyParticleTracerBase_GetStaticMesh, METH_VARARGS,
   "GetStaticMesh(self) -> int\nC++: virtual vtkTypeBool GetStaticMesh()\n\n"},
  {"SetInterpolatorType", PyvtkLegacyParticleTracerBase_SetInterpolatorType, METH_VARARGS,
   "SetInterpolatorType(self, interpolatorType:int) -> None\nC++: void SetInterpolatorType(int interpolatorType)\n\nSet the type of the velocity field interpolator to determine\nwhether INTERPOLATOR_WITH_DATASET_POINT_LOCATOR or\nINTERPOLATOR_WITH_CELL_LOCATOR is employed for locating cells\nduring streamline integration. The latter (adopting\nvtkAbstractCellLocator sub-classes such as vtkCellLocator and\nvtkModifiedBSPTree) is more robust than the former (through\nvtkDataSet / vtkPointSet::FindCell() coupled with\nvtkPointLocator). However the former can be much faster and\nproduce adequate results.\n\nDefault is INTERPOLATOR_WITH_CELL_LOCATOR (to maintain backwards\ncompatibility).\n"},
  {"SetInterpolatorTypeToDataSetPointLocator", PyvtkLegacyParticleTracerBase_SetInterpolatorTypeToDataSetPointLocator, METH_VARARGS,
   "SetInterpolatorTypeToDataSetPointLocator(self) -> None\nC++: void SetInterpolatorTypeToDataSetPointLocator()\n\nSet the velocity field interpolator type to one that uses a point\nlocator to perform local spatial searching. Typically a point\nlocator is faster than searches with a cell locator, but it may\nnot always find the correct cells enclosing a point. This is\nparticularly true with meshes that are disjoint at seams, or abut\nmeshes in an incompatible manner.\n"},
  {"SetInterpolatorTypeToCellLocator", PyvtkLegacyParticleTracerBase_SetInterpolatorTypeToCellLocator, METH_VARARGS,
   "SetInterpolatorTypeToCellLocator(self) -> None\nC++: void SetInterpolatorTypeToCellLocator()\n\nSet the velocity field interpolator type to one that uses a cell\nlocator to perform spatial searching. Using a cell locator should\nalways return the correct results, but it can be much slower that\npoint locator-based searches. * By default a cell locator is\nused.\n"},
  {"SetParticleWriter", PyvtkLegacyParticleTracerBase_SetParticleWriter, METH_VARARGS,
   "SetParticleWriter(self, pw:vtkAbstractParticleWriter) -> None\nC++: virtual void SetParticleWriter(vtkAbstractParticleWriter *pw)\n\nSet/Get the Writer associated with this Particle Tracer Ideally a\nparallel IO capable vtkH5PartWriter should be used which will\ncollect particles from all parallel processes and write them to a\nsingle HDF5 file.\n"},
  {"GetParticleWriter", PyvtkLegacyParticleTracerBase_GetParticleWriter, METH_VARARGS,
   "GetParticleWriter(self) -> vtkAbstractParticleWriter\nC++: virtual vtkAbstractParticleWriter *GetParticleWriter()\n\n"},
  {"SetParticleFileName", PyvtkLegacyParticleTracerBase_SetParticleFileName, METH_VARARGS,
   "SetParticleFileName(self, _arg:str) -> None\nC++: virtual void SetParticleFileName(const char *_arg)\n\nSet/Get the filename to be used with the particle writer when\ndumping particles to disk\n"},
  {"GetParticleFileName", PyvtkLegacyParticleTracerBase_GetParticleFileName, METH_VARARGS,
   "GetParticleFileName(self) -> str\nC++: virtual char *GetParticleFileName()\n\n"},
  {"SetEnableParticleWriting", PyvtkLegacyParticleTracerBase_SetEnableParticleWriting, METH_VARARGS,
   "SetEnableParticleWriting(self, _arg:int) -> None\nC++: virtual void SetEnableParticleWriting(vtkTypeBool _arg)\n\nSet/Get the filename to be used with the particle writer when\ndumping particles to disk\n"},
  {"GetEnableParticleWriting", PyvtkLegacyParticleTracerBase_GetEnableParticleWriting, METH_VARARGS,
   "GetEnableParticleWriting(self) -> int\nC++: virtual vtkTypeBool GetEnableParticleWriting()\n\n"},
  {"EnableParticleWritingOn", PyvtkLegacyParticleTracerBase_EnableParticleWritingOn, METH_VARARGS,
   "EnableParticleWritingOn(self) -> None\nC++: virtual void EnableParticleWritingOn()\n\n"},
  {"EnableParticleWritingOff", PyvtkLegacyParticleTracerBase_EnableParticleWritingOff, METH_VARARGS,
   "EnableParticleWritingOff(self) -> None\nC++: virtual void EnableParticleWritingOff()\n\n"},
  {"SetDisableResetCache", PyvtkLegacyParticleTracerBase_SetDisableResetCache, METH_VARARGS,
   "SetDisableResetCache(self, _arg:int) -> None\nC++: virtual void SetDisableResetCache(vtkTypeBool _arg)\n\nSet/Get the flag to disable cache This is off by default and\nturned on in special circumstances such as in a coprocessing\nworkflow\n"},
  {"GetDisableResetCache", PyvtkLegacyParticleTracerBase_GetDisableResetCache, METH_VARARGS,
   "GetDisableResetCache(self) -> int\nC++: virtual vtkTypeBool GetDisableResetCache()\n\n"},
  {"DisableResetCacheOn", PyvtkLegacyParticleTracerBase_DisableResetCacheOn, METH_VARARGS,
   "DisableResetCacheOn(self) -> None\nC++: virtual void DisableResetCacheOn()\n\n"},
  {"DisableResetCacheOff", PyvtkLegacyParticleTracerBase_DisableResetCacheOff, METH_VARARGS,
   "DisableResetCacheOff(self) -> None\nC++: virtual void DisableResetCacheOff()\n\n"},
  {"AddSourceConnection", PyvtkLegacyParticleTracerBase_AddSourceConnection, METH_VARARGS,
   "AddSourceConnection(self, input:vtkAlgorithmOutput) -> None\nC++: void AddSourceConnection(vtkAlgorithmOutput *input)\n\nProvide support for multiple seed sources\n"},
  {"RemoveAllSources", PyvtkLegacyParticleTracerBase_RemoveAllSources, METH_VARARGS,
   "RemoveAllSources(self) -> None\nC++: void RemoveAllSources()\n\n"},
  {"GetForceSerialExecution", PyvtkLegacyParticleTracerBase_GetForceSerialExecution, METH_VARARGS,
   "GetForceSerialExecution(self) -> bool\nC++: virtual bool GetForceSerialExecution()\n\nForce the filter to run particle tracer in serial. This affects\nthe filter only if more than 100 particles is to be generated.\n"},
  {"SetForceSerialExecution", PyvtkLegacyParticleTracerBase_SetForceSerialExecution, METH_VARARGS,
   "SetForceSerialExecution(self, _arg:bool) -> None\nC++: virtual void SetForceSerialExecution(bool _arg)\n\n"},
  {"ForceSerialExecutionOn", PyvtkLegacyParticleTracerBase_ForceSerialExecutionOn, METH_VARARGS,
   "ForceSerialExecutionOn(self) -> None\nC++: virtual void ForceSerialExecutionOn()\n\n"},
  {"ForceSerialExecutionOff", PyvtkLegacyParticleTracerBase_ForceSerialExecutionOff, METH_VARARGS,
   "ForceSerialExecutionOff(self) -> None\nC++: virtual void ForceSerialExecutionOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkLegacyParticleTracerBase_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("compute_vorticity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetComputeVorticity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetComputeVorticity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetComputeVorticity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeVorticity/SetComputeVorticity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("terminal_speed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetTerminalSpeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetTerminalSpeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetTerminalSpeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTerminalSpeed/SetTerminalSpeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rotation_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetRotationScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetRotationScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetRotationScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRotationScale/SetRotationScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ignore_pipeline_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetIgnorePipelineTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetIgnorePipelineTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetIgnorePipelineTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIgnorePipelineTime/SetIgnorePipelineTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_reinjection_every_n_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetForceReinjectionEveryNSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetForceReinjectionEveryNSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetForceReinjectionEveryNSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceReinjectionEveryNSteps/SetForceReinjectionEveryNSteps\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("termination_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetTerminationTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetTerminationTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetTerminationTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTerminationTime/SetTerminationTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("integrator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetIntegrator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetIntegrator(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetIntegrator(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIntegrator/SetIntegrator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("integrator_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetIntegratorType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetIntegratorType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetIntegratorType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIntegratorType/SetIntegratorType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("start_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetStartTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetStartTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetStartTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStartTime/SetStartTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("static_seeds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetStaticSeeds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetStaticSeeds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetStaticSeeds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStaticSeeds/SetStaticSeeds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mesh_over_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetMeshOverTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetMeshOverTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetMeshOverTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMeshOverTime/SetMeshOverTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("static_mesh"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetStaticMesh(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetStaticMesh(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetStaticMesh(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStaticMesh/SetStaticMesh\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpolator_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetInterpolatorType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetInterpolatorType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInterpolatorType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("particle_writer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetParticleWriter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetParticleWriter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetParticleWriter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParticleWriter/SetParticleWriter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("particle_file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetParticleFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetParticleFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetParticleFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParticleFileName/SetParticleFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_particle_writing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetEnableParticleWriting(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetEnableParticleWriting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetEnableParticleWriting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableParticleWriting/SetEnableParticleWriting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_reset_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetDisableResetCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetDisableResetCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetDisableResetCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisableResetCache/SetDisableResetCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_serial_execution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLegacyParticleTracerBase_GetForceSerialExecution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLegacyParticleTracerBase_SetForceSerialExecution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLegacyParticleTracerBase_SetForceSerialExecution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceSerialExecution/SetForceSerialExecution\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkLegacyParticleTracerBase_Doc =
  "vtkLegacyParticleTracerBase - A particle tracer for vector fields\n\n"
  "Superclass: vtkPolyDataAlgorithm\n\n"
  "vtkLegacyParticleTracerBase is the base class for filters that advect\n"
  "particles in a vector field. Note that the input vtkPointData\n"
  "structure must be identical on all datasets.\n\n"
  "@sa\n"
  "vtkRibbonFilter vtkRuledSurfaceFilter vtkInitialValueProblemSolver\n"
  "vtkRungeKutta2 vtkRungeKutta4 vtkRungeKutta45 vtkStreamTracer\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkLegacyParticleTracerBase_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneralMPI.vtkLegacyParticleTracerBase", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkLegacyParticleTracerBase_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkLegacyParticleTracerBase_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkLegacyParticleTracerBase_Type, PyvtkLegacyParticleTracerBase_Methods,
    "vtkLegacyParticleTracerBase",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPolyDataAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkLegacyParticleTracerBase_Solvers_Type);
  PyVTKEnum_Add(&PyvtkLegacyParticleTracerBase_Solvers_Type, "vtkLegacyParticleTracerBase.Solvers");

  o = (PyObject *)&PyvtkLegacyParticleTracerBase_Solvers_Type;
  if (PyDict_SetItemString(d, "Solvers", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_Type);
  PyVTKEnum_Add(&PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_Type, "vtkLegacyParticleTracerBase.MeshOverTimeTypes");

  o = (PyObject *)&PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_Type;
  if (PyDict_SetItemString(d, "MeshOverTimeTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 5; c++)
  {
    typedef vtkLegacyParticleTracerBase::Solvers cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[5] = {
        { "RUNGE_KUTTA2", vtkLegacyParticleTracerBase::RUNGE_KUTTA2 },
        { "RUNGE_KUTTA4", vtkLegacyParticleTracerBase::RUNGE_KUTTA4 },
        { "RUNGE_KUTTA45", vtkLegacyParticleTracerBase::RUNGE_KUTTA45 },
        { "NONE", vtkLegacyParticleTracerBase::NONE },
        { "UNKNOWN", vtkLegacyParticleTracerBase::UNKNOWN },
      };

    o = PyvtkLegacyParticleTracerBase_Solvers_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 4; c++)
  {
    typedef vtkLegacyParticleTracerBase::MeshOverTimeTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[4] = {
        { "DIFFERENT", vtkLegacyParticleTracerBase::DIFFERENT },
        { "STATIC", vtkLegacyParticleTracerBase::STATIC },
        { "LINEAR_TRANSFORMATION", vtkLegacyParticleTracerBase::LINEAR_TRANSFORMATION },
        { "SAME_TOPOLOGY", vtkLegacyParticleTracerBase::SAME_TOPOLOGY },
      };

    o = PyvtkLegacyParticleTracerBase_MeshOverTimeTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "INTERPOLATOR_WITH_DATASET_POINT_LOCATOR", vtkLegacyParticleTracerBase::INTERPOLATOR_WITH_DATASET_POINT_LOCATOR },
        { "INTERPOLATOR_WITH_CELL_LOCATOR", vtkLegacyParticleTracerBase::INTERPOLATOR_WITH_CELL_LOCATOR },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkLegacyParticleTracerBase_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkLegacyParticleTracerBase(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkLegacyParticleTracerBase_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkLegacyParticleTracerBase", o) != 0)
  {
    Py_DECREF(o);
  }

}

