#pragma once
#include "libnewsboat-ffi/src/filepath.rs.h"
#include <cstdint>
#include <string>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__

namespace newsboat {
  namespace logger {
    enum class Level : ::std::uint8_t;
  }
}

namespace newsboat {
namespace logger {
#ifndef CXXBRIDGE1_ENUM_newsboat$logger$Level
#define CXXBRIDGE1_ENUM_newsboat$logger$Level
enum class Level : ::std::uint8_t {
  USERERROR = 1,
  CRITICAL = 2,
  ERROR = 3,
  WARN = 4,
  INFO = 5,
  DEBUG = 6,
};
#endif // CXXBRIDGE1_ENUM_newsboat$logger$Level

void unset_loglevel() noexcept;

void set_logfile(::newsboat::filepath::bridged::PathBuf const &logfile) noexcept;

::std::int64_t get_loglevel() noexcept;

void set_loglevel(::newsboat::logger::Level level) noexcept;

void log_internal(::newsboat::logger::Level level, ::std::string const &message) noexcept;

void set_user_error_logfile(::newsboat::filepath::bridged::PathBuf const &user_error_logfile) noexcept;
} // namespace logger
} // namespace newsboat

#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
