// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExemplar = sync.Pool{
		New: func() any {
			return &otlpmetrics.Exemplar{}
		},
	}

	ProtoPoolExemplar_AsDouble = sync.Pool{
		New: func() any {
			return &otlpmetrics.Exemplar_AsDouble{}
		},
	}

	ProtoPoolExemplar_AsInt = sync.Pool{
		New: func() any {
			return &otlpmetrics.Exemplar_AsInt{}
		},
	}
)

func NewOrigExemplar() *otlpmetrics.Exemplar {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.Exemplar{}
	}
	return protoPoolExemplar.Get().(*otlpmetrics.Exemplar)
}

func DeleteOrigExemplar(orig *otlpmetrics.Exemplar, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.FilteredAttributes {
		DeleteOrigKeyValue(&orig.FilteredAttributes[i], false)
	}
	switch ov := orig.Value.(type) {
	case *otlpmetrics.Exemplar_AsDouble:
		if UseProtoPooling.IsEnabled() {
			ov.AsDouble = float64(0)
			ProtoPoolExemplar_AsDouble.Put(ov)
		}
	case *otlpmetrics.Exemplar_AsInt:
		if UseProtoPooling.IsEnabled() {
			ov.AsInt = int64(0)
			ProtoPoolExemplar_AsInt.Put(ov)
		}

	}
	DeleteOrigSpanID(&orig.SpanId, false)
	DeleteOrigTraceID(&orig.TraceId, false)

	orig.Reset()
	if nullable {
		protoPoolExemplar.Put(orig)
	}
}

func CopyOrigExemplar(dest, src *otlpmetrics.Exemplar) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.FilteredAttributes = CopyOrigKeyValueSlice(dest.FilteredAttributes, src.FilteredAttributes)
	dest.TimeUnixNano = src.TimeUnixNano
	switch t := src.Value.(type) {
	case *otlpmetrics.Exemplar_AsDouble:
		var ov *otlpmetrics.Exemplar_AsDouble
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpmetrics.Exemplar_AsDouble{}
		} else {
			ov = ProtoPoolExemplar_AsDouble.Get().(*otlpmetrics.Exemplar_AsDouble)
		}
		ov.AsDouble = t.AsDouble
		dest.Value = ov
	case *otlpmetrics.Exemplar_AsInt:
		var ov *otlpmetrics.Exemplar_AsInt
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpmetrics.Exemplar_AsInt{}
		} else {
			ov = ProtoPoolExemplar_AsInt.Get().(*otlpmetrics.Exemplar_AsInt)
		}
		ov.AsInt = t.AsInt
		dest.Value = ov
	}
	dest.SpanId = src.SpanId
	dest.TraceId = src.TraceId
}

func GenTestOrigExemplar() *otlpmetrics.Exemplar {
	orig := NewOrigExemplar()
	orig.FilteredAttributes = GenerateOrigTestKeyValueSlice()
	orig.TimeUnixNano = 1234567890
	orig.Value = &otlpmetrics.Exemplar_AsInt{AsInt: int64(13)}
	orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExemplar(orig *otlpmetrics.Exemplar, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.FilteredAttributes) > 0 {
		dest.WriteObjectField("filteredAttributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.FilteredAttributes[0], dest)
		for i := 1; i < len(orig.FilteredAttributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.FilteredAttributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	switch orig := orig.Value.(type) {
	case *otlpmetrics.Exemplar_AsDouble:
		dest.WriteObjectField("asDouble")
		dest.WriteFloat64(orig.AsDouble)
	case *otlpmetrics.Exemplar_AsInt:
		dest.WriteObjectField("asInt")
		dest.WriteInt64(orig.AsInt)
	}
	if orig.SpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("spanId")
		MarshalJSONOrigSpanID(&orig.SpanId, dest)
	}
	if orig.TraceId != data.TraceID([16]byte{}) {
		dest.WriteObjectField("traceId")
		MarshalJSONOrigTraceID(&orig.TraceId, dest)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExemplar unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExemplar(orig *otlpmetrics.Exemplar, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "filteredAttributes", "filtered_attributes":
			for iter.ReadArray() {
				orig.FilteredAttributes = append(orig.FilteredAttributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.FilteredAttributes[len(orig.FilteredAttributes)-1], iter)
			}

		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()

		case "asDouble", "as_double":
			{
				var ov *otlpmetrics.Exemplar_AsDouble
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.Exemplar_AsDouble{}
				} else {
					ov = ProtoPoolExemplar_AsDouble.Get().(*otlpmetrics.Exemplar_AsDouble)
				}
				ov.AsDouble = iter.ReadFloat64()
				orig.Value = ov
			}

		case "asInt", "as_int":
			{
				var ov *otlpmetrics.Exemplar_AsInt
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.Exemplar_AsInt{}
				} else {
					ov = ProtoPoolExemplar_AsInt.Get().(*otlpmetrics.Exemplar_AsInt)
				}
				ov.AsInt = iter.ReadInt64()
				orig.Value = ov
			}

		case "spanId", "span_id":
			UnmarshalJSONOrigSpanID(&orig.SpanId, iter)
		case "traceId", "trace_id":
			UnmarshalJSONOrigTraceID(&orig.TraceId, iter)
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExemplar(orig *otlpmetrics.Exemplar) int {
	var n int
	var l int
	_ = l
	for i := range orig.FilteredAttributes {
		l = SizeProtoOrigKeyValue(&orig.FilteredAttributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	switch orig := orig.Value.(type) {
	case nil:
		_ = orig
		break
	case *otlpmetrics.Exemplar_AsDouble:
		n += 9
	case *otlpmetrics.Exemplar_AsInt:
		n += 9
	}
	l = SizeProtoOrigSpanID(&orig.SpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigTraceID(&orig.TraceId)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExemplar(orig *otlpmetrics.Exemplar, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.FilteredAttributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.FilteredAttributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	switch orig := orig.Value.(type) {
	case *otlpmetrics.Exemplar_AsDouble:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.AsDouble))
		pos--
		buf[pos] = 0x19

	case *otlpmetrics.Exemplar_AsInt:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.AsInt))
		pos--
		buf[pos] = 0x31

	}

	l = MarshalProtoOrigSpanID(&orig.SpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x22

	l = MarshalProtoOrigTraceID(&orig.TraceId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	return len(buf) - pos
}

func UnmarshalProtoOrigExemplar(orig *otlpmetrics.Exemplar, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field FilteredAttributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.FilteredAttributes = append(orig.FilteredAttributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.FilteredAttributes[len(orig.FilteredAttributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.Exemplar_AsDouble
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.Exemplar_AsDouble{}
			} else {
				ov = ProtoPoolExemplar_AsDouble.Get().(*otlpmetrics.Exemplar_AsDouble)
			}
			ov.AsDouble = math.Float64frombits(num)
			orig.Value = ov

		case 6:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.Exemplar_AsInt
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.Exemplar_AsInt{}
			} else {
				ov = ProtoPoolExemplar_AsInt.Get().(*otlpmetrics.Exemplar_AsInt)
			}
			ov.AsInt = int64(num)
			orig.Value = ov

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigSpanID(&orig.SpanId, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigTraceID(&orig.TraceId, buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
