// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/profiles/v1development/profiles.proto

package v1development

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	go_opentelemetry_io_collector_pdata_internal_data "go.opentelemetry.io/collector/pdata/internal/data"
	v11 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Specifies the method of aggregating metric values, either DELTA (change since last report)
// or CUMULATIVE (total since a fixed start time).
type AggregationTemporality int32

const (
	// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
	AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED AggregationTemporality = 0
	//* DELTA is an AggregationTemporality for a profiler which reports
	//changes since last report time. Successive metrics contain aggregation of
	//values from continuous and non-overlapping intervals.
	//
	//The values for a DELTA metric are based only on the time interval
	//associated with one measurement cycle. There is no dependency on
	//previous measurements like is the case for CUMULATIVE metrics.
	//
	//For example, consider a system measuring the number of requests that
	//it receives and reports the sum of these requests every second as a
	//DELTA metric:
	//
	//1. The system starts receiving at time=t_0.
	//2. A request is received, the system measures 1 request.
	//3. A request is received, the system measures 1 request.
	//4. A request is received, the system measures 1 request.
	//5. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+1 with a value of 3.
	//6. A request is received, the system measures 1 request.
	//7. A request is received, the system measures 1 request.
	//8. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0+1 to
	//t_0+2 with a value of 2.
	AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA AggregationTemporality = 1
	//* CUMULATIVE is an AggregationTemporality for a profiler which
	//reports changes since a fixed start time. This means that current values
	//of a CUMULATIVE metric depend on all previous measurements since the
	//start time. Because of this, the sender is required to retain this state
	//in some form. If this state is lost or invalidated, the CUMULATIVE metric
	//values MUST be reset and a new fixed start time following the last
	//reported measurement time sent MUST be used.
	//
	//For example, consider a system measuring the number of requests that
	//it receives and reports the sum of these requests every second as a
	//CUMULATIVE metric:
	//
	//1. The system starts receiving at time=t_0.
	//2. A request is received, the system measures 1 request.
	//3. A request is received, the system measures 1 request.
	//4. A request is received, the system measures 1 request.
	//5. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+1 with a value of 3.
	//6. A request is received, the system measures 1 request.
	//7. A request is received, the system measures 1 request.
	//8. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+2 with a value of 5.
	//9. The system experiences a fault and loses state.
	//10. The system recovers and resumes receiving at time=t_1.
	//11. A request is received, the system measures 1 request.
	//12. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_1 to
	//t_1+1 with a value of 1.
	//
	//Note: Even though, when reporting changes since last report time, using
	//CUMULATIVE is valid, it is not recommended.
	AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE AggregationTemporality = 2
)

var AggregationTemporality_name = map[int32]string{
	0: "AGGREGATION_TEMPORALITY_UNSPECIFIED",
	1: "AGGREGATION_TEMPORALITY_DELTA",
	2: "AGGREGATION_TEMPORALITY_CUMULATIVE",
}

var AggregationTemporality_value = map[string]int32{
	"AGGREGATION_TEMPORALITY_UNSPECIFIED": 0,
	"AGGREGATION_TEMPORALITY_DELTA":       1,
	"AGGREGATION_TEMPORALITY_CUMULATIVE":  2,
}

func (x AggregationTemporality) String() string {
	return proto.EnumName(AggregationTemporality_name, int32(x))
}

func (AggregationTemporality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{0}
}

// ProfilesDictionary represents the profiles data shared across the
// entire message being sent.
//
// Note that all fields in this message MUST have a zero value encoded as the first element.
// This allows for _index fields pointing into the dictionary to use a 0 pointer value
// to indicate 'null' / 'not set'. Unless otherwise defined, a 'zero value' message value
// is one with all default field values, so as to minimize wire encoded size.
type ProfilesDictionary struct {
	// Mappings from address ranges to the image/binary/library mapped
	// into that address range referenced by locations via Location.mapping_index.
	MappingTable []*Mapping `protobuf:"bytes,1,rep,name=mapping_table,json=mappingTable,proto3" json:"mapping_table,omitempty"`
	// Locations referenced by samples via Stack.location_indices.
	LocationTable []*Location `protobuf:"bytes,2,rep,name=location_table,json=locationTable,proto3" json:"location_table,omitempty"`
	// Functions referenced by locations via Line.function_index.
	FunctionTable []*Function `protobuf:"bytes,3,rep,name=function_table,json=functionTable,proto3" json:"function_table,omitempty"`
	// Links referenced by samples via Sample.link_index.
	LinkTable []*Link `protobuf:"bytes,4,rep,name=link_table,json=linkTable,proto3" json:"link_table,omitempty"`
	// A common table for strings referenced by various messages.
	// string_table[0] must always be "".
	StringTable []string `protobuf:"bytes,5,rep,name=string_table,json=stringTable,proto3" json:"string_table,omitempty"`
	// A common table for attributes referenced by various messages.
	// It is a collection of key/value pairs. Note, global attributes
	// like server name can be set using the resource API. Examples of attributes:
	//
	//     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	//     "abc.com/score": 10.239
	//
	// The attribute values SHOULD NOT contain empty values.
	// The attribute values SHOULD NOT contain bytes values.
	// The attribute values SHOULD NOT contain array values different than array of string values, bool values, int values,
	// double values.
	// The attribute values SHOULD NOT contain kvlist values.
	// The behavior of software that receives attributes containing such values can be unpredictable.
	// These restrictions can change in a minor release.
	// The restrictions take origin from the OpenTelemetry specification:
	// https://github.com/open-telemetry/opentelemetry-specification/blob/v1.47.0/specification/common/README.md#attribute.
	AttributeTable []*KeyValueAndUnit `protobuf:"bytes,6,rep,name=attribute_table,json=attributeTable,proto3" json:"attribute_table,omitempty"`
	// Stacks referenced by samples via Sample.stack_index.
	StackTable []*Stack `protobuf:"bytes,7,rep,name=stack_table,json=stackTable,proto3" json:"stack_table,omitempty"`
}

func (m *ProfilesDictionary) Reset()         { *m = ProfilesDictionary{} }
func (m *ProfilesDictionary) String() string { return proto.CompactTextString(m) }
func (*ProfilesDictionary) ProtoMessage()    {}
func (*ProfilesDictionary) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{0}
}
func (m *ProfilesDictionary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProfilesDictionary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProfilesDictionary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProfilesDictionary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfilesDictionary.Merge(m, src)
}
func (m *ProfilesDictionary) XXX_Size() int {
	return m.Size()
}
func (m *ProfilesDictionary) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfilesDictionary.DiscardUnknown(m)
}

var xxx_messageInfo_ProfilesDictionary proto.InternalMessageInfo

func (m *ProfilesDictionary) GetMappingTable() []*Mapping {
	if m != nil {
		return m.MappingTable
	}
	return nil
}

func (m *ProfilesDictionary) GetLocationTable() []*Location {
	if m != nil {
		return m.LocationTable
	}
	return nil
}

func (m *ProfilesDictionary) GetFunctionTable() []*Function {
	if m != nil {
		return m.FunctionTable
	}
	return nil
}

func (m *ProfilesDictionary) GetLinkTable() []*Link {
	if m != nil {
		return m.LinkTable
	}
	return nil
}

func (m *ProfilesDictionary) GetStringTable() []string {
	if m != nil {
		return m.StringTable
	}
	return nil
}

func (m *ProfilesDictionary) GetAttributeTable() []*KeyValueAndUnit {
	if m != nil {
		return m.AttributeTable
	}
	return nil
}

func (m *ProfilesDictionary) GetStackTable() []*Stack {
	if m != nil {
		return m.StackTable
	}
	return nil
}

// ProfilesData represents the profiles data that can be stored in persistent storage,
// OR can be embedded by other protocols that transfer OTLP profiles data but do not
// implement the OTLP protocol.
//
// The main difference between this message and collector protocol is that
// in this message there will not be any "control" or "metadata" specific to
// OTLP protocol.
//
// When new fields are added into this message, the OTLP request MUST be updated
// as well.
type ProfilesData struct {
	// An array of ResourceProfiles.
	// For data coming from an SDK profiler, this array will typically contain one
	// element. Host-level profilers will usually create one ResourceProfile per
	// container, as well as one additional ResourceProfile grouping all samples
	// from non-containerized processes.
	// Other resource groupings are possible as well and clarified via
	// Resource.attributes and semantic conventions.
	// Tools that visualize profiles should prefer displaying
	// resources_profiles[0].scope_profiles[0].profiles[0] by default.
	ResourceProfiles []*ResourceProfiles `protobuf:"bytes,1,rep,name=resource_profiles,json=resourceProfiles,proto3" json:"resource_profiles,omitempty"`
	// One instance of ProfilesDictionary
	Dictionary ProfilesDictionary `protobuf:"bytes,2,opt,name=dictionary,proto3" json:"dictionary"`
}

func (m *ProfilesData) Reset()         { *m = ProfilesData{} }
func (m *ProfilesData) String() string { return proto.CompactTextString(m) }
func (*ProfilesData) ProtoMessage()    {}
func (*ProfilesData) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{1}
}
func (m *ProfilesData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProfilesData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProfilesData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProfilesData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfilesData.Merge(m, src)
}
func (m *ProfilesData) XXX_Size() int {
	return m.Size()
}
func (m *ProfilesData) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfilesData.DiscardUnknown(m)
}

var xxx_messageInfo_ProfilesData proto.InternalMessageInfo

func (m *ProfilesData) GetResourceProfiles() []*ResourceProfiles {
	if m != nil {
		return m.ResourceProfiles
	}
	return nil
}

func (m *ProfilesData) GetDictionary() ProfilesDictionary {
	if m != nil {
		return m.Dictionary
	}
	return ProfilesDictionary{}
}

// A collection of ScopeProfiles from a Resource.
type ResourceProfiles struct {
	// The resource for the profiles in this message.
	// If this field is not set then no resource info is known.
	Resource v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource"`
	// A list of ScopeProfiles that originate from a resource.
	ScopeProfiles []*ScopeProfiles `protobuf:"bytes,2,rep,name=scope_profiles,json=scopeProfiles,proto3" json:"scope_profiles,omitempty"`
	// The Schema URL, if known. This is the identifier of the Schema that the resource data
	// is recorded in. Notably, the last part of the URL path is the version number of the
	// schema: http[s]://server[:port]/path/<version>. To learn more about Schema URL see
	// https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "scope_profiles" field which have their own schema_url field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ResourceProfiles) Reset()         { *m = ResourceProfiles{} }
func (m *ResourceProfiles) String() string { return proto.CompactTextString(m) }
func (*ResourceProfiles) ProtoMessage()    {}
func (*ResourceProfiles) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{2}
}
func (m *ResourceProfiles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceProfiles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceProfiles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceProfiles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceProfiles.Merge(m, src)
}
func (m *ResourceProfiles) XXX_Size() int {
	return m.Size()
}
func (m *ResourceProfiles) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceProfiles.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceProfiles proto.InternalMessageInfo

func (m *ResourceProfiles) GetResource() v1.Resource {
	if m != nil {
		return m.Resource
	}
	return v1.Resource{}
}

func (m *ResourceProfiles) GetScopeProfiles() []*ScopeProfiles {
	if m != nil {
		return m.ScopeProfiles
	}
	return nil
}

func (m *ResourceProfiles) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Profiles produced by an InstrumentationScope.
type ScopeProfiles struct {
	// The instrumentation scope information for the profiles in this message.
	// Semantically when InstrumentationScope isn't set, it is equivalent with
	// an empty instrumentation scope name (unknown).
	Scope v11.InstrumentationScope `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope"`
	// A list of Profiles that originate from an instrumentation scope.
	Profiles []*Profile `protobuf:"bytes,2,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// The Schema URL, if known. This is the identifier of the Schema that the profile data
	// is recorded in. Notably, the last part of the URL path is the version number of the
	// schema: http[s]://server[:port]/path/<version>. To learn more about Schema URL see
	// https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
	// This schema_url applies to all profiles in the "profiles" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ScopeProfiles) Reset()         { *m = ScopeProfiles{} }
func (m *ScopeProfiles) String() string { return proto.CompactTextString(m) }
func (*ScopeProfiles) ProtoMessage()    {}
func (*ScopeProfiles) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{3}
}
func (m *ScopeProfiles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopeProfiles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopeProfiles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopeProfiles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopeProfiles.Merge(m, src)
}
func (m *ScopeProfiles) XXX_Size() int {
	return m.Size()
}
func (m *ScopeProfiles) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopeProfiles.DiscardUnknown(m)
}

var xxx_messageInfo_ScopeProfiles proto.InternalMessageInfo

func (m *ScopeProfiles) GetScope() v11.InstrumentationScope {
	if m != nil {
		return m.Scope
	}
	return v11.InstrumentationScope{}
}

func (m *ScopeProfiles) GetProfiles() []*Profile {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *ScopeProfiles) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// Represents a complete profile, including sample types, samples, mappings to
// binaries, stacks, locations, functions, string table, and additional
// metadata. It modifies and annotates pprof Profile with OpenTelemetry
// specific fields.
//
// Note that whilst fields in this message retain the name and field id from pprof in most cases
// for ease of understanding data migration, it is not intended that pprof:Profile and
// OpenTelemetry:Profile encoding be wire compatible.
type Profile struct {
	// The type and unit of all Sample.values in this profile.
	// For a cpu or off-cpu profile this might be:
	//   ["cpu","nanoseconds"] or ["off_cpu","nanoseconds"]
	// For a heap profile, this might be:
	//   ["allocated_objects","count"] or ["allocated_space","bytes"],
	SampleType ValueType `protobuf:"bytes,1,opt,name=sample_type,json=sampleType,proto3" json:"sample_type"`
	// The set of samples recorded in this profile.
	Sample []*Sample `protobuf:"bytes,2,rep,name=sample,proto3" json:"sample,omitempty"`
	// Time of collection (UTC) represented as nanoseconds past the epoch.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// Duration of the profile, if a duration makes sense.
	DurationNano uint64 `protobuf:"varint,4,opt,name=duration_nano,json=durationNano,proto3" json:"duration_nano,omitempty"`
	// The kind of events between sampled occurrences.
	// e.g [ "cpu","cycles" ] or [ "heap","bytes" ]
	PeriodType ValueType `protobuf:"bytes,5,opt,name=period_type,json=periodType,proto3" json:"period_type"`
	// The number of events between sampled occurrences.
	Period int64 `protobuf:"varint,6,opt,name=period,proto3" json:"period,omitempty"`
	// Free-form text associated with the profile. The text is displayed as is
	// to the user by the tools that read profiles (e.g. by pprof). This field
	// should not be used to store any machine-readable information, it is only
	// for human-friendly content. The profile must stay functional if this field
	// is cleaned.
	CommentStrindices []int32 `protobuf:"varint,7,rep,packed,name=comment_strindices,json=commentStrindices,proto3" json:"comment_strindices,omitempty"`
	// A globally unique identifier for a profile. The ID is a 16-byte array. An ID with
	// all zeroes is considered invalid. It may be used for deduplication and signal
	// correlation purposes. It is acceptable to treat two profiles with different values
	// in this field as not equal, even if they represented the same object at an earlier
	// time.
	// This field is optional; an ID may be assigned to an ID-less profile in a later step.
	ProfileId go_opentelemetry_io_collector_pdata_internal_data.ProfileID `protobuf:"bytes,8,opt,name=profile_id,json=profileId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.ProfileID" json:"profile_id"`
	// dropped_attributes_count is the number of attributes that were discarded. Attributes
	// can be discarded because their keys are too long or because there are too many
	// attributes. If this value is 0, then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,9,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	// Specifies format of the original payload. Common values are defined in semantic conventions. [required if original_payload is present]
	OriginalPayloadFormat string `protobuf:"bytes,10,opt,name=original_payload_format,json=originalPayloadFormat,proto3" json:"original_payload_format,omitempty"`
	// Original payload can be stored in this field. This can be useful for users who want to get the original payload.
	// Formats such as JFR are highly extensible and can contain more information than what is defined in this spec.
	// Inclusion of original payload should be configurable by the user. Default behavior should be to not include the original payload.
	// If the original payload is in pprof format, it SHOULD not be included in this field.
	// The field is optional, however if it is present then equivalent converted data should be populated in other fields
	// of this message as far as is practicable.
	OriginalPayload []byte `protobuf:"bytes,11,opt,name=original_payload,json=originalPayload,proto3" json:"original_payload,omitempty"`
	// References to attributes in attribute_table. [optional]
	AttributeIndices []int32 `protobuf:"varint,12,rep,packed,name=attribute_indices,json=attributeIndices,proto3" json:"attribute_indices,omitempty"`
}

func (m *Profile) Reset()         { *m = Profile{} }
func (m *Profile) String() string { return proto.CompactTextString(m) }
func (*Profile) ProtoMessage()    {}
func (*Profile) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{4}
}
func (m *Profile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Profile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Profile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Profile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Profile.Merge(m, src)
}
func (m *Profile) XXX_Size() int {
	return m.Size()
}
func (m *Profile) XXX_DiscardUnknown() {
	xxx_messageInfo_Profile.DiscardUnknown(m)
}

var xxx_messageInfo_Profile proto.InternalMessageInfo

func (m *Profile) GetSampleType() ValueType {
	if m != nil {
		return m.SampleType
	}
	return ValueType{}
}

func (m *Profile) GetSample() []*Sample {
	if m != nil {
		return m.Sample
	}
	return nil
}

func (m *Profile) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Profile) GetDurationNano() uint64 {
	if m != nil {
		return m.DurationNano
	}
	return 0
}

func (m *Profile) GetPeriodType() ValueType {
	if m != nil {
		return m.PeriodType
	}
	return ValueType{}
}

func (m *Profile) GetPeriod() int64 {
	if m != nil {
		return m.Period
	}
	return 0
}

func (m *Profile) GetCommentStrindices() []int32 {
	if m != nil {
		return m.CommentStrindices
	}
	return nil
}

func (m *Profile) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func (m *Profile) GetOriginalPayloadFormat() string {
	if m != nil {
		return m.OriginalPayloadFormat
	}
	return ""
}

func (m *Profile) GetOriginalPayload() []byte {
	if m != nil {
		return m.OriginalPayload
	}
	return nil
}

func (m *Profile) GetAttributeIndices() []int32 {
	if m != nil {
		return m.AttributeIndices
	}
	return nil
}

// A pointer from a profile Sample to a trace Span.
// Connects a profile sample to a trace span, identified by unique trace and span IDs.
type Link struct {
	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId go_opentelemetry_io_collector_pdata_internal_data.TraceID `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.TraceID" json:"trace_id"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId go_opentelemetry_io_collector_pdata_internal_data.SpanID `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.SpanID" json:"span_id"`
}

func (m *Link) Reset()         { *m = Link{} }
func (m *Link) String() string { return proto.CompactTextString(m) }
func (*Link) ProtoMessage()    {}
func (*Link) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{5}
}
func (m *Link) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Link) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Link.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Link) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Link.Merge(m, src)
}
func (m *Link) XXX_Size() int {
	return m.Size()
}
func (m *Link) XXX_DiscardUnknown() {
	xxx_messageInfo_Link.DiscardUnknown(m)
}

var xxx_messageInfo_Link proto.InternalMessageInfo

// ValueType describes the type and units of a value, with an optional aggregation temporality.
type ValueType struct {
	TypeStrindex           int32                  `protobuf:"varint,1,opt,name=type_strindex,json=typeStrindex,proto3" json:"type_strindex,omitempty"`
	UnitStrindex           int32                  `protobuf:"varint,2,opt,name=unit_strindex,json=unitStrindex,proto3" json:"unit_strindex,omitempty"`
	AggregationTemporality AggregationTemporality `protobuf:"varint,3,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.profiles.v1development.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *ValueType) Reset()         { *m = ValueType{} }
func (m *ValueType) String() string { return proto.CompactTextString(m) }
func (*ValueType) ProtoMessage()    {}
func (*ValueType) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{6}
}
func (m *ValueType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValueType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValueType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValueType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueType.Merge(m, src)
}
func (m *ValueType) XXX_Size() int {
	return m.Size()
}
func (m *ValueType) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueType.DiscardUnknown(m)
}

var xxx_messageInfo_ValueType proto.InternalMessageInfo

func (m *ValueType) GetTypeStrindex() int32 {
	if m != nil {
		return m.TypeStrindex
	}
	return 0
}

func (m *ValueType) GetUnitStrindex() int32 {
	if m != nil {
		return m.UnitStrindex
	}
	return 0
}

func (m *ValueType) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// Each Sample records values encountered in some program context. The program
// context is typically a stack trace, perhaps augmented with auxiliary
// information like the thread-id, some indicator of a higher level request
// being handled etc.
//
// A Sample MUST have have at least one values or timestamps_unix_nano entry. If
// both fields are populated, they MUST contain the same number of elements, and
// the elements at the same index MUST refer to the same event.
//
// Examples of different ways of representing a sample with the total value of 10:
//
// Report of a stacktrace at 10 timestamps (consumers must assume the value is 1 for each point):
//
//	values: []
//	timestamps_unix_nano: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
//
// Report of a stacktrace with an aggregated value without timestamps:
//
//	values: [10]
//	 timestamps_unix_nano: []
//
// Report of a stacktrace at 4 timestamps where each point records a specific value:
//
//	values: [2, 2, 3, 3]
//	timestamps_unix_nano: [1, 2, 3, 4]
type Sample struct {
	// Reference to stack in ProfilesDictionary.stack_table.
	StackIndex int32 `protobuf:"varint,1,opt,name=stack_index,json=stackIndex,proto3" json:"stack_index,omitempty"`
	// The type and unit of each value is defined by Profile.sample_type.
	Values []int64 `protobuf:"varint,2,rep,packed,name=values,proto3" json:"values,omitempty"`
	// References to attributes in ProfilesDictionary.attribute_table. [optional]
	AttributeIndices []int32 `protobuf:"varint,3,rep,packed,name=attribute_indices,json=attributeIndices,proto3" json:"attribute_indices,omitempty"`
	// Reference to link in ProfilesDictionary.link_table. [optional]
	// It can be unset / set to 0 if no link exists, as link_table[0] is always a 'null' default value.
	LinkIndex int32 `protobuf:"varint,4,opt,name=link_index,json=linkIndex,proto3" json:"link_index,omitempty"`
	// Timestamps associated with Sample represented in nanoseconds. These
	// timestamps should fall within the Profile's time range.
	TimestampsUnixNano []uint64 `protobuf:"fixed64,5,rep,packed,name=timestamps_unix_nano,json=timestampsUnixNano,proto3" json:"timestamps_unix_nano,omitempty"`
}

func (m *Sample) Reset()         { *m = Sample{} }
func (m *Sample) String() string { return proto.CompactTextString(m) }
func (*Sample) ProtoMessage()    {}
func (*Sample) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{7}
}
func (m *Sample) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Sample) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Sample.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Sample) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sample.Merge(m, src)
}
func (m *Sample) XXX_Size() int {
	return m.Size()
}
func (m *Sample) XXX_DiscardUnknown() {
	xxx_messageInfo_Sample.DiscardUnknown(m)
}

var xxx_messageInfo_Sample proto.InternalMessageInfo

func (m *Sample) GetStackIndex() int32 {
	if m != nil {
		return m.StackIndex
	}
	return 0
}

func (m *Sample) GetValues() []int64 {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Sample) GetAttributeIndices() []int32 {
	if m != nil {
		return m.AttributeIndices
	}
	return nil
}

func (m *Sample) GetLinkIndex() int32 {
	if m != nil {
		return m.LinkIndex
	}
	return 0
}

func (m *Sample) GetTimestampsUnixNano() []uint64 {
	if m != nil {
		return m.TimestampsUnixNano
	}
	return nil
}

// Describes the mapping of a binary in memory, including its address range,
// file offset, and metadata like build ID
type Mapping struct {
	// Address at which the binary (or DLL) is loaded into memory.
	MemoryStart uint64 `protobuf:"varint,1,opt,name=memory_start,json=memoryStart,proto3" json:"memory_start,omitempty"`
	// The limit of the address range occupied by this mapping.
	MemoryLimit uint64 `protobuf:"varint,2,opt,name=memory_limit,json=memoryLimit,proto3" json:"memory_limit,omitempty"`
	// Offset in the binary that corresponds to the first mapped address.
	FileOffset uint64 `protobuf:"varint,3,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
	// The object this entry is loaded from.  This can be a filename on
	// disk for the main binary and shared libraries, or virtual
	// abstractions like "[vdso]".
	FilenameStrindex int32 `protobuf:"varint,4,opt,name=filename_strindex,json=filenameStrindex,proto3" json:"filename_strindex,omitempty"`
	// References to attributes in ProfilesDictionary.attribute_table. [optional]
	AttributeIndices []int32 `protobuf:"varint,5,rep,packed,name=attribute_indices,json=attributeIndices,proto3" json:"attribute_indices,omitempty"`
}

func (m *Mapping) Reset()         { *m = Mapping{} }
func (m *Mapping) String() string { return proto.CompactTextString(m) }
func (*Mapping) ProtoMessage()    {}
func (*Mapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{8}
}
func (m *Mapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mapping.Merge(m, src)
}
func (m *Mapping) XXX_Size() int {
	return m.Size()
}
func (m *Mapping) XXX_DiscardUnknown() {
	xxx_messageInfo_Mapping.DiscardUnknown(m)
}

var xxx_messageInfo_Mapping proto.InternalMessageInfo

func (m *Mapping) GetMemoryStart() uint64 {
	if m != nil {
		return m.MemoryStart
	}
	return 0
}

func (m *Mapping) GetMemoryLimit() uint64 {
	if m != nil {
		return m.MemoryLimit
	}
	return 0
}

func (m *Mapping) GetFileOffset() uint64 {
	if m != nil {
		return m.FileOffset
	}
	return 0
}

func (m *Mapping) GetFilenameStrindex() int32 {
	if m != nil {
		return m.FilenameStrindex
	}
	return 0
}

func (m *Mapping) GetAttributeIndices() []int32 {
	if m != nil {
		return m.AttributeIndices
	}
	return nil
}

// A Stack represents a stack trace as a list of locations.
type Stack struct {
	// References to locations in ProfilesDictionary.location_table.
	// The first location is the leaf frame.
	LocationIndices []int32 `protobuf:"varint,1,rep,packed,name=location_indices,json=locationIndices,proto3" json:"location_indices,omitempty"`
}

func (m *Stack) Reset()         { *m = Stack{} }
func (m *Stack) String() string { return proto.CompactTextString(m) }
func (*Stack) ProtoMessage()    {}
func (*Stack) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{9}
}
func (m *Stack) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stack) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stack.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stack) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stack.Merge(m, src)
}
func (m *Stack) XXX_Size() int {
	return m.Size()
}
func (m *Stack) XXX_DiscardUnknown() {
	xxx_messageInfo_Stack.DiscardUnknown(m)
}

var xxx_messageInfo_Stack proto.InternalMessageInfo

func (m *Stack) GetLocationIndices() []int32 {
	if m != nil {
		return m.LocationIndices
	}
	return nil
}

// Describes function and line table debug information.
type Location struct {
	// Reference to mapping in ProfilesDictionary.mapping_table.
	// It can be unset / set to 0 if the mapping is unknown or not applicable for
	// this profile type, as mapping_table[0] is always a 'null' default mapping.
	MappingIndex int32 `protobuf:"varint,1,opt,name=mapping_index,json=mappingIndex,proto3" json:"mapping_index,omitempty"`
	// The instruction address for this location, if available.  It
	// should be within [Mapping.memory_start...Mapping.memory_limit]
	// for the corresponding mapping. A non-leaf address may be in the
	// middle of a call instruction. It is up to display tools to find
	// the beginning of the instruction if necessary.
	Address uint64 `protobuf:"varint,2,opt,name=address,proto3" json:"address,omitempty"`
	// Multiple line indicates this location has inlined functions,
	// where the last entry represents the caller into which the
	// preceding entries were inlined.
	//
	// E.g., if memcpy() is inlined into printf:
	//    line[0].function_name == "memcpy"
	//    line[1].function_name == "printf"
	Line []*Line `protobuf:"bytes,3,rep,name=line,proto3" json:"line,omitempty"`
	// References to attributes in ProfilesDictionary.attribute_table. [optional]
	AttributeIndices []int32 `protobuf:"varint,4,rep,packed,name=attribute_indices,json=attributeIndices,proto3" json:"attribute_indices,omitempty"`
}

func (m *Location) Reset()         { *m = Location{} }
func (m *Location) String() string { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()    {}
func (*Location) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{10}
}
func (m *Location) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Location) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Location.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Location) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Location.Merge(m, src)
}
func (m *Location) XXX_Size() int {
	return m.Size()
}
func (m *Location) XXX_DiscardUnknown() {
	xxx_messageInfo_Location.DiscardUnknown(m)
}

var xxx_messageInfo_Location proto.InternalMessageInfo

func (m *Location) GetMappingIndex() int32 {
	if m != nil {
		return m.MappingIndex
	}
	return 0
}

func (m *Location) GetAddress() uint64 {
	if m != nil {
		return m.Address
	}
	return 0
}

func (m *Location) GetLine() []*Line {
	if m != nil {
		return m.Line
	}
	return nil
}

func (m *Location) GetAttributeIndices() []int32 {
	if m != nil {
		return m.AttributeIndices
	}
	return nil
}

// Details a specific line in a source code, linked to a function.
type Line struct {
	// Reference to function in ProfilesDictionary.function_table.
	FunctionIndex int32 `protobuf:"varint,1,opt,name=function_index,json=functionIndex,proto3" json:"function_index,omitempty"`
	// Line number in source code. 0 means unset.
	Line int64 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	// Column number in source code. 0 means unset.
	Column int64 `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
}

func (m *Line) Reset()         { *m = Line{} }
func (m *Line) String() string { return proto.CompactTextString(m) }
func (*Line) ProtoMessage()    {}
func (*Line) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{11}
}
func (m *Line) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Line) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Line.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Line) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Line.Merge(m, src)
}
func (m *Line) XXX_Size() int {
	return m.Size()
}
func (m *Line) XXX_DiscardUnknown() {
	xxx_messageInfo_Line.DiscardUnknown(m)
}

var xxx_messageInfo_Line proto.InternalMessageInfo

func (m *Line) GetFunctionIndex() int32 {
	if m != nil {
		return m.FunctionIndex
	}
	return 0
}

func (m *Line) GetLine() int64 {
	if m != nil {
		return m.Line
	}
	return 0
}

func (m *Line) GetColumn() int64 {
	if m != nil {
		return m.Column
	}
	return 0
}

// Describes a function, including its human-readable name, system name,
// source file, and starting line number in the source.
type Function struct {
	// Function name. Empty string if not available.
	NameStrindex int32 `protobuf:"varint,1,opt,name=name_strindex,json=nameStrindex,proto3" json:"name_strindex,omitempty"`
	// Function name, as identified by the system. For instance,
	// it can be a C++ mangled name. Empty string if not available.
	SystemNameStrindex int32 `protobuf:"varint,2,opt,name=system_name_strindex,json=systemNameStrindex,proto3" json:"system_name_strindex,omitempty"`
	// Source file containing the function. Empty string if not available.
	FilenameStrindex int32 `protobuf:"varint,3,opt,name=filename_strindex,json=filenameStrindex,proto3" json:"filename_strindex,omitempty"`
	// Line number in source file. 0 means unset.
	StartLine int64 `protobuf:"varint,4,opt,name=start_line,json=startLine,proto3" json:"start_line,omitempty"`
}

func (m *Function) Reset()         { *m = Function{} }
func (m *Function) String() string { return proto.CompactTextString(m) }
func (*Function) ProtoMessage()    {}
func (*Function) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{12}
}
func (m *Function) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Function) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Function.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Function) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Function.Merge(m, src)
}
func (m *Function) XXX_Size() int {
	return m.Size()
}
func (m *Function) XXX_DiscardUnknown() {
	xxx_messageInfo_Function.DiscardUnknown(m)
}

var xxx_messageInfo_Function proto.InternalMessageInfo

func (m *Function) GetNameStrindex() int32 {
	if m != nil {
		return m.NameStrindex
	}
	return 0
}

func (m *Function) GetSystemNameStrindex() int32 {
	if m != nil {
		return m.SystemNameStrindex
	}
	return 0
}

func (m *Function) GetFilenameStrindex() int32 {
	if m != nil {
		return m.FilenameStrindex
	}
	return 0
}

func (m *Function) GetStartLine() int64 {
	if m != nil {
		return m.StartLine
	}
	return 0
}

// A custom 'dictionary native' style of encoding attributes which is more convenient
// for profiles than opentelemetry.proto.common.v1.KeyValue
// Specifically, uses the string table for keys and allows optional unit information.
type KeyValueAndUnit struct {
	KeyStrindex  int32        `protobuf:"varint,1,opt,name=key_strindex,json=keyStrindex,proto3" json:"key_strindex,omitempty"`
	Value        v11.AnyValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	UnitStrindex int32        `protobuf:"varint,3,opt,name=unit_strindex,json=unitStrindex,proto3" json:"unit_strindex,omitempty"`
}

func (m *KeyValueAndUnit) Reset()         { *m = KeyValueAndUnit{} }
func (m *KeyValueAndUnit) String() string { return proto.CompactTextString(m) }
func (*KeyValueAndUnit) ProtoMessage()    {}
func (*KeyValueAndUnit) Descriptor() ([]byte, []int) {
	return fileDescriptor_ddd0cf081a2fe76f, []int{13}
}
func (m *KeyValueAndUnit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyValueAndUnit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyValueAndUnit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyValueAndUnit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyValueAndUnit.Merge(m, src)
}
func (m *KeyValueAndUnit) XXX_Size() int {
	return m.Size()
}
func (m *KeyValueAndUnit) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyValueAndUnit.DiscardUnknown(m)
}

var xxx_messageInfo_KeyValueAndUnit proto.InternalMessageInfo

func (m *KeyValueAndUnit) GetKeyStrindex() int32 {
	if m != nil {
		return m.KeyStrindex
	}
	return 0
}

func (m *KeyValueAndUnit) GetValue() v11.AnyValue {
	if m != nil {
		return m.Value
	}
	return v11.AnyValue{}
}

func (m *KeyValueAndUnit) GetUnitStrindex() int32 {
	if m != nil {
		return m.UnitStrindex
	}
	return 0
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.profiles.v1development.AggregationTemporality", AggregationTemporality_name, AggregationTemporality_value)
	proto.RegisterType((*ProfilesDictionary)(nil), "opentelemetry.proto.profiles.v1development.ProfilesDictionary")
	proto.RegisterType((*ProfilesData)(nil), "opentelemetry.proto.profiles.v1development.ProfilesData")
	proto.RegisterType((*ResourceProfiles)(nil), "opentelemetry.proto.profiles.v1development.ResourceProfiles")
	proto.RegisterType((*ScopeProfiles)(nil), "opentelemetry.proto.profiles.v1development.ScopeProfiles")
	proto.RegisterType((*Profile)(nil), "opentelemetry.proto.profiles.v1development.Profile")
	proto.RegisterType((*Link)(nil), "opentelemetry.proto.profiles.v1development.Link")
	proto.RegisterType((*ValueType)(nil), "opentelemetry.proto.profiles.v1development.ValueType")
	proto.RegisterType((*Sample)(nil), "opentelemetry.proto.profiles.v1development.Sample")
	proto.RegisterType((*Mapping)(nil), "opentelemetry.proto.profiles.v1development.Mapping")
	proto.RegisterType((*Stack)(nil), "opentelemetry.proto.profiles.v1development.Stack")
	proto.RegisterType((*Location)(nil), "opentelemetry.proto.profiles.v1development.Location")
	proto.RegisterType((*Line)(nil), "opentelemetry.proto.profiles.v1development.Line")
	proto.RegisterType((*Function)(nil), "opentelemetry.proto.profiles.v1development.Function")
	proto.RegisterType((*KeyValueAndUnit)(nil), "opentelemetry.proto.profiles.v1development.KeyValueAndUnit")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/profiles/v1development/profiles.proto", fileDescriptor_ddd0cf081a2fe76f)
}

var fileDescriptor_ddd0cf081a2fe76f = []byte{
	// 1475 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x97, 0x5f, 0x6f, 0x13, 0xc7,
	0x16, 0xc0, 0xb3, 0xf1, 0xbf, 0xf8, 0xd8, 0x4e, 0xcc, 0x88, 0x1b, 0x2c, 0x24, 0x82, 0x31, 0xf7,
	0x5e, 0x4c, 0xae, 0x48, 0x48, 0xb8, 0xad, 0x40, 0x54, 0x55, 0x9d, 0x38, 0xa0, 0x85, 0x90, 0xa4,
	0x13, 0x07, 0x95, 0x16, 0x69, 0x3b, 0xf1, 0x4e, 0xdc, 0x55, 0x76, 0x67, 0x57, 0xbb, 0xe3, 0x08,
	0xab, 0x5f, 0xa1, 0x0f, 0xfd, 0x04, 0xfd, 0x00, 0x95, 0xfa, 0x0d, 0x2a, 0xf5, 0x15, 0xf5, 0x89,
	0xf6, 0xa1, 0x42, 0x7d, 0xa0, 0x15, 0xbc, 0xd0, 0x6f, 0x51, 0xcd, 0x9f, 0x5d, 0xff, 0x89, 0x23,
	0xba, 0x55, 0x5f, 0xac, 0x9d, 0x33, 0x67, 0x7e, 0x67, 0xce, 0x99, 0x33, 0x67, 0x8e, 0xe1, 0x8e,
	0x1f, 0x50, 0xc6, 0xa9, 0x4b, 0x3d, 0xca, 0xc3, 0xc1, 0x6a, 0x10, 0xfa, 0xdc, 0x17, 0xbf, 0x47,
	0x8e, 0x4b, 0xa3, 0xd5, 0x93, 0x35, 0x9b, 0x9e, 0x50, 0xd7, 0x0f, 0x3c, 0xca, 0x78, 0x22, 0x5e,
	0x91, 0x5a, 0x68, 0x79, 0x6c, 0xa9, 0x12, 0xae, 0x24, 0x3a, 0x63, 0x4b, 0x2f, 0x9e, 0xef, 0xf9,
	0x3d, 0x5f, 0xc1, 0xc5, 0x97, 0x52, 0xbe, 0xb8, 0x3c, 0xcd, 0x78, 0xd7, 0xf7, 0x3c, 0x9f, 0xad,
	0x9e, 0xac, 0xe9, 0x2f, 0xad, 0xbb, 0x32, 0x4d, 0x37, 0xa4, 0x91, 0xdf, 0x0f, 0xbb, 0x54, 0x68,
	0xc7, 0xdf, 0x4a, 0xbf, 0xf1, 0x4b, 0x16, 0xd0, 0x9e, 0xde, 0x4c, 0xdb, 0xe9, 0x72, 0xc7, 0x67,
	0x24, 0x1c, 0xa0, 0x4f, 0xa0, 0xe2, 0x91, 0x20, 0x70, 0x58, 0xcf, 0xe2, 0xe4, 0xd0, 0xa5, 0x35,
	0xa3, 0x9e, 0x69, 0x96, 0xd6, 0x6f, 0xad, 0xfc, 0x75, 0x67, 0x56, 0x1e, 0x29, 0x00, 0x2e, 0x6b,
	0x52, 0x47, 0x80, 0xd0, 0x67, 0x30, 0xef, 0xfa, 0x5d, 0x22, 0x0c, 0x69, 0xf4, 0xac, 0x44, 0xff,
	0x3f, 0x0d, 0x7a, 0x5b, 0x13, 0x70, 0x25, 0x66, 0x25, 0xf0, 0xa3, 0x3e, 0xeb, 0x8e, 0xc0, 0x33,
	0xe9, 0xe1, 0xf7, 0x34, 0x01, 0x57, 0x62, 0x96, 0x82, 0xef, 0x02, 0xb8, 0x0e, 0x3b, 0xd6, 0xe0,
	0xac, 0x04, 0xdf, 0x4c, 0xb5, 0x6b, 0x87, 0x1d, 0xe3, 0xa2, 0x60, 0x28, 0xe0, 0x15, 0x28, 0x47,
	0x3c, 0x1c, 0xc6, 0x38, 0x57, 0xcf, 0x34, 0x8b, 0xb8, 0xa4, 0x64, 0x4a, 0xc5, 0x86, 0x05, 0xc2,
	0x79, 0xe8, 0x1c, 0xf6, 0x39, 0xd5, 0x5a, 0x79, 0x69, 0xf8, 0x6e, 0x1a, 0xc3, 0x0f, 0xe9, 0xe0,
	0x31, 0x71, 0xfb, 0xb4, 0xc5, 0xec, 0x03, 0xe6, 0x70, 0x3c, 0x9f, 0x30, 0x95, 0x15, 0x0c, 0xa5,
	0x88, 0x93, 0x6e, 0xec, 0x5a, 0x41, 0x5a, 0x58, 0x4b, 0x63, 0x61, 0x5f, 0x2c, 0xc7, 0x20, 0x29,
	0x92, 0xd9, 0xf8, 0xcd, 0x80, 0x72, 0x92, 0x58, 0x84, 0x13, 0xe4, 0xc0, 0xb9, 0x38, 0xf7, 0xac,
	0x98, 0xa2, 0xd3, 0xea, 0x83, 0x34, 0xa6, 0xb0, 0x86, 0xc4, 0x70, 0x5c, 0x0d, 0x27, 0x24, 0xc8,
	0x06, 0xb0, 0x93, 0x5c, 0xae, 0xcd, 0xd6, 0x8d, 0x66, 0x69, 0xfd, 0xc3, 0x34, 0x36, 0x4e, 0xdf,
	0x88, 0x8d, 0xec, 0xf3, 0x57, 0x97, 0x67, 0xf0, 0x08, 0xb7, 0xf1, 0xd6, 0x80, 0xea, 0xe4, 0x66,
	0xd0, 0x43, 0x98, 0x8b, 0xb7, 0x53, 0x33, 0xa4, 0xe1, 0xeb, 0x53, 0x0d, 0x27, 0xd7, 0xf0, 0x64,
	0x2d, 0xf1, 0x48, 0xdb, 0x48, 0x00, 0xe8, 0x73, 0x98, 0x8f, 0xba, 0x7e, 0x30, 0x12, 0x2f, 0x75,
	0x57, 0xee, 0xa4, 0x3a, 0x1a, 0x41, 0x48, 0x82, 0x55, 0x89, 0x46, 0x87, 0xe8, 0x12, 0x40, 0xd4,
	0xfd, 0x82, 0x7a, 0xc4, 0xea, 0x87, 0x6e, 0x2d, 0x53, 0x37, 0x9a, 0x45, 0x5c, 0x54, 0x92, 0x83,
	0xd0, 0x7d, 0x90, 0x9f, 0x7b, 0x5b, 0xa8, 0xfe, 0x51, 0x68, 0xbc, 0x30, 0xa0, 0x32, 0xc6, 0x41,
	0xbb, 0x90, 0x93, 0x24, 0xed, 0xe4, 0xf4, 0xc2, 0xa0, 0x2b, 0xd3, 0xc9, 0xda, 0x8a, 0xc9, 0x22,
	0x1e, 0xf6, 0xc5, 0x7e, 0xe4, 0x6d, 0x95, 0x2c, 0xed, 0xae, 0xe2, 0xa0, 0x5d, 0x98, 0x9b, 0xf0,
	0xf2, 0xd6, 0xdf, 0x38, 0x31, 0x9c, 0x40, 0xde, 0xe1, 0x5a, 0xe3, 0xa7, 0x1c, 0x14, 0xf4, 0x22,
	0xf4, 0x14, 0x4a, 0x11, 0xf1, 0x02, 0x97, 0x5a, 0x7c, 0x90, 0xb8, 0xf4, 0x5e, 0x1a, 0xf3, 0xf2,
	0x7a, 0x75, 0x06, 0x89, 0x53, 0xa0, 0x78, 0x42, 0x82, 0x1e, 0x40, 0x5e, 0x8d, 0xb4, 0x5f, 0xeb,
	0xa9, 0x4e, 0x4f, 0xae, 0xc4, 0x9a, 0x80, 0xfe, 0x0d, 0xf3, 0xdc, 0xf1, 0xa8, 0xd5, 0x67, 0xce,
	0x33, 0x8b, 0x11, 0xe6, 0x4b, 0xc7, 0xf2, 0xb8, 0x2c, 0xa4, 0x07, 0xcc, 0x79, 0xb6, 0x43, 0x98,
	0x8f, 0xae, 0x42, 0xc5, 0xee, 0x87, 0xaa, 0xc6, 0x4a, 0xa5, 0x6c, 0xdd, 0x68, 0x66, 0x71, 0x39,
	0x16, 0x4a, 0xa5, 0xa7, 0x50, 0x0a, 0x68, 0xe8, 0xf8, 0xb6, 0x72, 0x3a, 0xf7, 0x0f, 0x38, 0xad,
	0x78, 0xd2, 0xe9, 0x45, 0xc8, 0xab, 0x51, 0x2d, 0x5f, 0x37, 0x9a, 0x19, 0xac, 0x47, 0xe8, 0x06,
	0x20, 0x91, 0x15, 0x94, 0x71, 0x4b, 0xd6, 0x39, 0xdb, 0xe9, 0xd2, 0x48, 0x56, 0x9c, 0x1c, 0x3e,
	0xa7, 0x67, 0xf6, 0x93, 0x09, 0x74, 0x08, 0xa0, 0x8d, 0x5b, 0x8e, 0x5d, 0x9b, 0xab, 0x1b, 0xcd,
	0xf2, 0xc6, 0xa6, 0x30, 0xf6, 0xeb, 0xab, 0xcb, 0x77, 0x7b, 0xfe, 0xc4, 0x6e, 0x1d, 0xf1, 0x2c,
	0xba, 0x2e, 0xed, 0x72, 0x3f, 0x5c, 0x0d, 0x6c, 0xc2, 0xc9, 0xaa, 0xc3, 0x38, 0x0d, 0x19, 0x71,
	0x57, 0xc5, 0x28, 0xce, 0x12, 0xb3, 0x8d, 0x8b, 0x1a, 0x6b, 0xda, 0xe8, 0x36, 0xd4, 0xec, 0xd0,
	0x0f, 0x02, 0x6a, 0x5b, 0x49, 0x5d, 0x8c, 0xac, 0xae, 0xdf, 0x67, 0xbc, 0x56, 0xac, 0x1b, 0xcd,
	0x0a, 0x5e, 0xd4, 0xf3, 0xad, 0x64, 0x7a, 0x53, 0xcc, 0xa2, 0xf7, 0xe1, 0x82, 0x1f, 0x3a, 0x3d,
	0x87, 0x11, 0xd7, 0x0a, 0xc8, 0xc0, 0xf5, 0x89, 0x6d, 0x1d, 0xf9, 0xa1, 0x47, 0x78, 0x0d, 0x64,
	0xbe, 0xfd, 0x2b, 0x9e, 0xde, 0x53, 0xb3, 0xf7, 0xe4, 0x24, 0xba, 0x0e, 0xd5, 0xc9, 0x75, 0xb5,
	0x92, 0xf0, 0x0d, 0x2f, 0x4c, 0x2c, 0x40, 0xff, 0x83, 0x73, 0xc3, 0x07, 0x20, 0x0e, 0x57, 0x59,
	0x86, 0xab, 0x9a, 0x4c, 0x98, 0x4a, 0xde, 0xf8, 0xc1, 0x80, 0xac, 0x78, 0x64, 0xd0, 0x53, 0x98,
	0xe3, 0x21, 0xe9, 0xca, 0xa0, 0x19, 0x32, 0x68, 0x2d, 0x1d, 0xb4, 0x3b, 0xe9, 0x83, 0xd6, 0x11,
	0x24, 0xb3, 0x8d, 0x0b, 0x12, 0x69, 0xda, 0xe8, 0x09, 0x14, 0xa2, 0x80, 0x30, 0x01, 0x9f, 0x95,
	0xf0, 0x8f, 0x34, 0xfc, 0x76, 0x7a, 0xf8, 0x7e, 0x40, 0x98, 0xd9, 0xc6, 0x79, 0x01, 0x34, 0xed,
	0xc6, 0xcf, 0x06, 0x14, 0x93, 0xb4, 0x12, 0x79, 0x2c, 0x72, 0x53, 0x67, 0x0a, 0x7d, 0x26, 0x7d,
	0xc9, 0xe1, 0xb2, 0x10, 0xee, 0x6b, 0x99, 0x50, 0xea, 0x33, 0x87, 0x0f, 0x95, 0x66, 0x95, 0x92,
	0x10, 0x26, 0x4a, 0x5f, 0xc2, 0x05, 0xd2, 0xeb, 0x85, 0xb4, 0xa7, 0x1b, 0x0f, 0xea, 0x05, 0x7e,
	0x48, 0x5c, 0x87, 0x0f, 0xe4, 0x05, 0x9a, 0x5f, 0xdf, 0x48, 0x93, 0xf8, 0xad, 0x21, 0xaa, 0x33,
	0x24, 0xe1, 0x45, 0x32, 0x55, 0x2e, 0x8e, 0x25, 0xaf, 0xee, 0x31, 0xba, 0x1c, 0xbf, 0xb4, 0xa3,
	0xfe, 0xa8, 0x67, 0xd3, 0x94, 0x1b, 0x5d, 0x84, 0xfc, 0x89, 0xf0, 0x5f, 0x15, 0xc1, 0x0c, 0xd6,
	0xa3, 0xe9, 0x79, 0x90, 0x99, 0x9e, 0x07, 0xa2, 0xf4, 0xc9, 0x4e, 0x45, 0x19, 0xc9, 0x4a, 0x23,
	0xb2, 0xef, 0x50, 0x36, 0x6e, 0xc2, 0x79, 0x51, 0x2e, 0x22, 0x4e, 0xbc, 0x20, 0x1a, 0x29, 0x25,
	0xa2, 0xff, 0xc8, 0x63, 0x34, 0x9c, 0x8b, 0x0b, 0x4a, 0xe3, 0x47, 0x03, 0x0a, 0xba, 0x9d, 0x13,
	0x5d, 0x8b, 0x47, 0x3d, 0x3f, 0x1c, 0x58, 0x11, 0x27, 0x21, 0x97, 0x3e, 0x64, 0x71, 0x49, 0xc9,
	0xf6, 0x85, 0x68, 0x44, 0xc5, 0x75, 0x3c, 0x87, 0xcb, 0x13, 0x49, 0x54, 0xb6, 0x85, 0x48, 0x04,
	0x42, 0xde, 0x6a, 0xff, 0xe8, 0x28, 0xa2, 0x5c, 0x1e, 0x42, 0x16, 0x83, 0x10, 0xed, 0x4a, 0x89,
	0x70, 0x58, 0x8c, 0x18, 0xf1, 0x46, 0xce, 0x5f, 0xb9, 0x52, 0x8d, 0x27, 0x92, 0xe3, 0x9d, 0x1a,
	0x9d, 0xdc, 0x19, 0xb7, 0x64, 0x1d, 0x72, 0xb2, 0x5d, 0x11, 0xd7, 0x30, 0x69, 0x45, 0xe3, 0x45,
	0x86, 0x5c, 0xb4, 0x10, 0xcb, 0xe3, 0x35, 0xdf, 0x1b, 0x30, 0x17, 0x37, 0x9d, 0x22, 0xe3, 0xe2,
	0xe6, 0x78, 0x2c, 0x2d, 0xb5, 0x50, 0x05, 0xb9, 0x06, 0x05, 0x62, 0xdb, 0x21, 0x8d, 0x22, 0xed,
	0x7e, 0x3c, 0x44, 0x6d, 0xc8, 0xba, 0x0e, 0x8b, 0x5b, 0xd3, 0xb4, 0x1d, 0x24, 0xc5, 0x72, 0xf5,
	0x74, 0x97, 0xb3, 0x67, 0xb8, 0xfc, 0x44, 0xd6, 0x05, 0x8a, 0xfe, 0x33, 0xd2, 0x1f, 0x8f, 0x6e,
	0x3d, 0xe9, 0x74, 0xd5, 0xde, 0x91, 0xde, 0xe1, 0xac, 0x2c, 0xdd, 0xca, 0xde, 0x22, 0xe4, 0xbb,
	0xbe, 0xdb, 0xf7, 0x98, 0x3c, 0xab, 0x0c, 0xd6, 0xa3, 0xc6, 0x77, 0x06, 0xcc, 0xc5, 0x1d, 0xb3,
	0x88, 0xcc, 0xf8, 0x81, 0xe9, 0xc8, 0x8c, 0x1d, 0xd6, 0x4d, 0x38, 0x1f, 0x0d, 0x22, 0x4e, 0x3d,
	0x6b, 0x5c, 0x57, 0xdd, 0x5b, 0xa4, 0xe6, 0x76, 0x26, 0x8e, 0xf7, 0x74, 0x2e, 0x64, 0xce, 0xc8,
	0x05, 0xf1, 0xee, 0x8b, 0x2c, 0xb4, 0xa4, 0x0b, 0x59, 0xb9, 0xd9, 0xa2, 0x94, 0x88, 0x10, 0x34,
	0xbe, 0x31, 0x60, 0x61, 0xa2, 0x1f, 0x16, 0xf9, 0x7a, 0x4c, 0x07, 0x93, 0xbb, 0x2e, 0x1d, 0xd3,
	0x41, 0x42, 0xdd, 0x84, 0x9c, 0xbc, 0x89, 0xba, 0x9b, 0xbc, 0xf6, 0x8e, 0x7e, 0xa7, 0xc5, 0x94,
	0x85, 0xb8, 0xc7, 0x91, 0x6b, 0x4f, 0x97, 0xaa, 0xcc, 0xe9, 0x52, 0xb5, 0xfc, 0x95, 0x01, 0x8b,
	0xd3, 0x0b, 0x0c, 0xba, 0x06, 0x57, 0x5b, 0xf7, 0xef, 0xe3, 0xad, 0xfb, 0xad, 0x8e, 0xb9, 0xbb,
	0x63, 0x75, 0xb6, 0x1e, 0xed, 0xed, 0xe2, 0xd6, 0xb6, 0xd9, 0x79, 0x62, 0x1d, 0xec, 0xec, 0xef,
	0x6d, 0x6d, 0x9a, 0xf7, 0xcc, 0xad, 0x76, 0x75, 0x06, 0x5d, 0x81, 0x4b, 0x67, 0x29, 0xb6, 0xb7,
	0xb6, 0x3b, 0xad, 0xaa, 0x81, 0xfe, 0x0b, 0x8d, 0xb3, 0x54, 0x36, 0x0f, 0x1e, 0x1d, 0x6c, 0xb7,
	0x3a, 0xe6, 0xe3, 0xad, 0xea, 0xec, 0xc6, 0x4b, 0xe3, 0xf9, 0xeb, 0x25, 0xe3, 0xc5, 0xeb, 0x25,
	0xe3, 0xf7, 0xd7, 0x4b, 0xc6, 0xd7, 0x6f, 0x96, 0x66, 0x5e, 0xbc, 0x59, 0x9a, 0x79, 0xf9, 0x66,
	0x69, 0x06, 0x6e, 0x38, 0x7e, 0x8a, 0xe4, 0xdd, 0xa8, 0xc4, 0xcd, 0xe3, 0x9e, 0xd0, 0xda, 0x33,
	0x3e, 0xfd, 0x38, 0xf5, 0x73, 0xa1, 0xfe, 0xcf, 0xf6, 0x28, 0x3b, 0xe3, 0xbf, 0xf7, 0xb7, 0xb3,
	0xcb, 0xbb, 0x01, 0x65, 0x9d, 0x04, 0x28, 0x4d, 0x25, 0xed, 0xfc, 0xca, 0xe3, 0xb5, 0xf6, 0x50,
	0xf9, 0x30, 0x2f, 0x69, 0xb7, 0xfe, 0x0c, 0x00, 0x00, 0xff, 0xff, 0x93, 0x0f, 0x25, 0xda, 0xdd,
	0x0f, 0x00, 0x00,
}

func (m *ProfilesDictionary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProfilesDictionary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProfilesDictionary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.StackTable) > 0 {
		for iNdEx := len(m.StackTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StackTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.AttributeTable) > 0 {
		for iNdEx := len(m.AttributeTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AttributeTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.StringTable) > 0 {
		for iNdEx := len(m.StringTable) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.StringTable[iNdEx])
			copy(dAtA[i:], m.StringTable[iNdEx])
			i = encodeVarintProfiles(dAtA, i, uint64(len(m.StringTable[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.LinkTable) > 0 {
		for iNdEx := len(m.LinkTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LinkTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.FunctionTable) > 0 {
		for iNdEx := len(m.FunctionTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FunctionTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.LocationTable) > 0 {
		for iNdEx := len(m.LocationTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LocationTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.MappingTable) > 0 {
		for iNdEx := len(m.MappingTable) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MappingTable[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProfilesData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProfilesData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProfilesData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Dictionary.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if len(m.ResourceProfiles) > 0 {
		for iNdEx := len(m.ResourceProfiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceProfiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceProfiles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceProfiles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceProfiles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ScopeProfiles) > 0 {
		for iNdEx := len(m.ScopeProfiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ScopeProfiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ScopeProfiles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScopeProfiles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScopeProfiles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Profiles) > 0 {
		for iNdEx := len(m.Profiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Profiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Profile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Profile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Profile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AttributeIndices) > 0 {
		dAtA5 := make([]byte, len(m.AttributeIndices)*10)
		var j4 int
		for _, num1 := range m.AttributeIndices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		i -= j4
		copy(dAtA[i:], dAtA5[:j4])
		i = encodeVarintProfiles(dAtA, i, uint64(j4))
		i--
		dAtA[i] = 0x62
	}
	if len(m.OriginalPayload) > 0 {
		i -= len(m.OriginalPayload)
		copy(dAtA[i:], m.OriginalPayload)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.OriginalPayload)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.OriginalPayloadFormat) > 0 {
		i -= len(m.OriginalPayloadFormat)
		copy(dAtA[i:], m.OriginalPayloadFormat)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.OriginalPayloadFormat)))
		i--
		dAtA[i] = 0x52
	}
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x48
	}
	{
		size := m.ProfileId.Size()
		i -= size
		if _, err := m.ProfileId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if len(m.CommentStrindices) > 0 {
		dAtA7 := make([]byte, len(m.CommentStrindices)*10)
		var j6 int
		for _, num1 := range m.CommentStrindices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintProfiles(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x3a
	}
	if m.Period != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.Period))
		i--
		dAtA[i] = 0x30
	}
	{
		size, err := m.PeriodType.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if m.DurationNano != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.DurationNano))
		i--
		dAtA[i] = 0x20
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if len(m.Sample) > 0 {
		for iNdEx := len(m.Sample) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Sample[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.SampleType.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Link) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Link) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Link) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ValueType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValueType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValueType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x18
	}
	if m.UnitStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.UnitStrindex))
		i--
		dAtA[i] = 0x10
	}
	if m.TypeStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.TypeStrindex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Sample) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sample) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Sample) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TimestampsUnixNano) > 0 {
		for iNdEx := len(m.TimestampsUnixNano) - 1; iNdEx >= 0; iNdEx-- {
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimestampsUnixNano[iNdEx]))
		}
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.TimestampsUnixNano)*8))
		i--
		dAtA[i] = 0x2a
	}
	if m.LinkIndex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.LinkIndex))
		i--
		dAtA[i] = 0x20
	}
	if len(m.AttributeIndices) > 0 {
		dAtA11 := make([]byte, len(m.AttributeIndices)*10)
		var j10 int
		for _, num1 := range m.AttributeIndices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			dAtA11[j10] = uint8(num)
			j10++
		}
		i -= j10
		copy(dAtA[i:], dAtA11[:j10])
		i = encodeVarintProfiles(dAtA, i, uint64(j10))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Values) > 0 {
		dAtA13 := make([]byte, len(m.Values)*10)
		var j12 int
		for _, num1 := range m.Values {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA13[j12] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j12++
			}
			dAtA13[j12] = uint8(num)
			j12++
		}
		i -= j12
		copy(dAtA[i:], dAtA13[:j12])
		i = encodeVarintProfiles(dAtA, i, uint64(j12))
		i--
		dAtA[i] = 0x12
	}
	if m.StackIndex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.StackIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Mapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Mapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AttributeIndices) > 0 {
		dAtA15 := make([]byte, len(m.AttributeIndices)*10)
		var j14 int
		for _, num1 := range m.AttributeIndices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			dAtA15[j14] = uint8(num)
			j14++
		}
		i -= j14
		copy(dAtA[i:], dAtA15[:j14])
		i = encodeVarintProfiles(dAtA, i, uint64(j14))
		i--
		dAtA[i] = 0x2a
	}
	if m.FilenameStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.FilenameStrindex))
		i--
		dAtA[i] = 0x20
	}
	if m.FileOffset != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.FileOffset))
		i--
		dAtA[i] = 0x18
	}
	if m.MemoryLimit != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.MemoryLimit))
		i--
		dAtA[i] = 0x10
	}
	if m.MemoryStart != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.MemoryStart))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Stack) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stack) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stack) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LocationIndices) > 0 {
		dAtA17 := make([]byte, len(m.LocationIndices)*10)
		var j16 int
		for _, num1 := range m.LocationIndices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA17[j16] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j16++
			}
			dAtA17[j16] = uint8(num)
			j16++
		}
		i -= j16
		copy(dAtA[i:], dAtA17[:j16])
		i = encodeVarintProfiles(dAtA, i, uint64(j16))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Location) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Location) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Location) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AttributeIndices) > 0 {
		dAtA19 := make([]byte, len(m.AttributeIndices)*10)
		var j18 int
		for _, num1 := range m.AttributeIndices {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA19[j18] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j18++
			}
			dAtA19[j18] = uint8(num)
			j18++
		}
		i -= j18
		copy(dAtA[i:], dAtA19[:j18])
		i = encodeVarintProfiles(dAtA, i, uint64(j18))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Line) > 0 {
		for iNdEx := len(m.Line) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Line[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Address != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.Address))
		i--
		dAtA[i] = 0x10
	}
	if m.MappingIndex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.MappingIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Line) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Line) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Line) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Column != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.Column))
		i--
		dAtA[i] = 0x18
	}
	if m.Line != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.Line))
		i--
		dAtA[i] = 0x10
	}
	if m.FunctionIndex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.FunctionIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Function) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Function) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Function) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StartLine != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.StartLine))
		i--
		dAtA[i] = 0x20
	}
	if m.FilenameStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.FilenameStrindex))
		i--
		dAtA[i] = 0x18
	}
	if m.SystemNameStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.SystemNameStrindex))
		i--
		dAtA[i] = 0x10
	}
	if m.NameStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.NameStrindex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *KeyValueAndUnit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValueAndUnit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyValueAndUnit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UnitStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.UnitStrindex))
		i--
		dAtA[i] = 0x18
	}
	{
		size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if m.KeyStrindex != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.KeyStrindex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintProfiles(dAtA []byte, offset int, v uint64) int {
	offset -= sovProfiles(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ProfilesDictionary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.MappingTable) > 0 {
		for _, e := range m.MappingTable {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.LocationTable) > 0 {
		for _, e := range m.LocationTable {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.FunctionTable) > 0 {
		for _, e := range m.FunctionTable {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.LinkTable) > 0 {
		for _, e := range m.LinkTable {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.StringTable) > 0 {
		for _, s := range m.StringTable {
			l = len(s)
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.AttributeTable) > 0 {
		for _, e := range m.AttributeTable {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.StackTable) > 0 {
		for _, e := range m.StackTable {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	return n
}

func (m *ProfilesData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceProfiles) > 0 {
		for _, e := range m.ResourceProfiles {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	l = m.Dictionary.Size()
	n += 1 + l + sovProfiles(uint64(l))
	return n
}

func (m *ResourceProfiles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if len(m.ScopeProfiles) > 0 {
		for _, e := range m.ScopeProfiles {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	return n
}

func (m *ScopeProfiles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Scope.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if len(m.Profiles) > 0 {
		for _, e := range m.Profiles {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	return n
}

func (m *Profile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.SampleType.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if len(m.Sample) > 0 {
		for _, e := range m.Sample {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.DurationNano != 0 {
		n += 1 + sovProfiles(uint64(m.DurationNano))
	}
	l = m.PeriodType.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if m.Period != 0 {
		n += 1 + sovProfiles(uint64(m.Period))
	}
	if len(m.CommentStrindices) > 0 {
		l = 0
		for _, e := range m.CommentStrindices {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	l = m.ProfileId.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovProfiles(uint64(m.DroppedAttributesCount))
	}
	l = len(m.OriginalPayloadFormat)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	l = len(m.OriginalPayload)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	if len(m.AttributeIndices) > 0 {
		l = 0
		for _, e := range m.AttributeIndices {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	return n
}

func (m *Link) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TraceId.Size()
	n += 1 + l + sovProfiles(uint64(l))
	l = m.SpanId.Size()
	n += 1 + l + sovProfiles(uint64(l))
	return n
}

func (m *ValueType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypeStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.TypeStrindex))
	}
	if m.UnitStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.UnitStrindex))
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovProfiles(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *Sample) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StackIndex != 0 {
		n += 1 + sovProfiles(uint64(m.StackIndex))
	}
	if len(m.Values) > 0 {
		l = 0
		for _, e := range m.Values {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	if len(m.AttributeIndices) > 0 {
		l = 0
		for _, e := range m.AttributeIndices {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	if m.LinkIndex != 0 {
		n += 1 + sovProfiles(uint64(m.LinkIndex))
	}
	if len(m.TimestampsUnixNano) > 0 {
		n += 1 + sovProfiles(uint64(len(m.TimestampsUnixNano)*8)) + len(m.TimestampsUnixNano)*8
	}
	return n
}

func (m *Mapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemoryStart != 0 {
		n += 1 + sovProfiles(uint64(m.MemoryStart))
	}
	if m.MemoryLimit != 0 {
		n += 1 + sovProfiles(uint64(m.MemoryLimit))
	}
	if m.FileOffset != 0 {
		n += 1 + sovProfiles(uint64(m.FileOffset))
	}
	if m.FilenameStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.FilenameStrindex))
	}
	if len(m.AttributeIndices) > 0 {
		l = 0
		for _, e := range m.AttributeIndices {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	return n
}

func (m *Stack) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.LocationIndices) > 0 {
		l = 0
		for _, e := range m.LocationIndices {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	return n
}

func (m *Location) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MappingIndex != 0 {
		n += 1 + sovProfiles(uint64(m.MappingIndex))
	}
	if m.Address != 0 {
		n += 1 + sovProfiles(uint64(m.Address))
	}
	if len(m.Line) > 0 {
		for _, e := range m.Line {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if len(m.AttributeIndices) > 0 {
		l = 0
		for _, e := range m.AttributeIndices {
			l += sovProfiles(uint64(e))
		}
		n += 1 + sovProfiles(uint64(l)) + l
	}
	return n
}

func (m *Line) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FunctionIndex != 0 {
		n += 1 + sovProfiles(uint64(m.FunctionIndex))
	}
	if m.Line != 0 {
		n += 1 + sovProfiles(uint64(m.Line))
	}
	if m.Column != 0 {
		n += 1 + sovProfiles(uint64(m.Column))
	}
	return n
}

func (m *Function) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NameStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.NameStrindex))
	}
	if m.SystemNameStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.SystemNameStrindex))
	}
	if m.FilenameStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.FilenameStrindex))
	}
	if m.StartLine != 0 {
		n += 1 + sovProfiles(uint64(m.StartLine))
	}
	return n
}

func (m *KeyValueAndUnit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeyStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.KeyStrindex))
	}
	l = m.Value.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if m.UnitStrindex != 0 {
		n += 1 + sovProfiles(uint64(m.UnitStrindex))
	}
	return n
}

func sovProfiles(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProfiles(x uint64) (n int) {
	return sovProfiles(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ProfilesDictionary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProfilesDictionary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProfilesDictionary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MappingTable = append(m.MappingTable, &Mapping{})
			if err := m.MappingTable[len(m.MappingTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocationTable = append(m.LocationTable, &Location{})
			if err := m.LocationTable[len(m.LocationTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FunctionTable = append(m.FunctionTable, &Function{})
			if err := m.FunctionTable[len(m.FunctionTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LinkTable = append(m.LinkTable, &Link{})
			if err := m.LinkTable[len(m.LinkTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringTable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StringTable = append(m.StringTable, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttributeTable = append(m.AttributeTable, &KeyValueAndUnit{})
			if err := m.AttributeTable[len(m.AttributeTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StackTable = append(m.StackTable, &Stack{})
			if err := m.StackTable[len(m.StackTable)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProfilesData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProfilesData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProfilesData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProfiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceProfiles = append(m.ResourceProfiles, &ResourceProfiles{})
			if err := m.ResourceProfiles[len(m.ResourceProfiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dictionary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dictionary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceProfiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceProfiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceProfiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeProfiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopeProfiles = append(m.ScopeProfiles, &ScopeProfiles{})
			if err := m.ScopeProfiles[len(m.ScopeProfiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScopeProfiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScopeProfiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScopeProfiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Profiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Profiles = append(m.Profiles, &Profile{})
			if err := m.Profiles[len(m.Profiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Profile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Profile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Profile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SampleType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sample", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sample = append(m.Sample, &Sample{})
			if err := m.Sample[len(m.Sample)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationNano", wireType)
			}
			m.DurationNano = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DurationNano |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeriodType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PeriodType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			m.Period = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Period |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.CommentStrindices = append(m.CommentStrindices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.CommentStrindices) == 0 {
					m.CommentStrindices = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.CommentStrindices = append(m.CommentStrindices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field CommentStrindices", wireType)
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfileId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProfileId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayloadFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginalPayloadFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginalPayload = append(m.OriginalPayload[:0], dAtA[iNdEx:postIndex]...)
			if m.OriginalPayload == nil {
				m.OriginalPayload = []byte{}
			}
			iNdEx = postIndex
		case 12:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AttributeIndices = append(m.AttributeIndices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AttributeIndices) == 0 {
					m.AttributeIndices = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AttributeIndices = append(m.AttributeIndices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Link) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Link: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Link: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValueType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeStrindex", wireType)
			}
			m.TypeStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TypeStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnitStrindex", wireType)
			}
			m.UnitStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UnitStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sample) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sample: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sample: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackIndex", wireType)
			}
			m.StackIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StackIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Values) == 0 {
					m.Values = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		case 3:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AttributeIndices = append(m.AttributeIndices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AttributeIndices) == 0 {
					m.AttributeIndices = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AttributeIndices = append(m.AttributeIndices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkIndex", wireType)
			}
			m.LinkIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LinkIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.TimestampsUnixNano = append(m.TimestampsUnixNano, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.TimestampsUnixNano) == 0 {
					m.TimestampsUnixNano = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.TimestampsUnixNano = append(m.TimestampsUnixNano, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampsUnixNano", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryStart", wireType)
			}
			m.MemoryStart = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryStart |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryLimit", wireType)
			}
			m.MemoryLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryLimit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileOffset", wireType)
			}
			m.FileOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileOffset |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilenameStrindex", wireType)
			}
			m.FilenameStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilenameStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AttributeIndices = append(m.AttributeIndices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AttributeIndices) == 0 {
					m.AttributeIndices = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AttributeIndices = append(m.AttributeIndices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Stack) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stack: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stack: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LocationIndices = append(m.LocationIndices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.LocationIndices) == 0 {
					m.LocationIndices = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LocationIndices = append(m.LocationIndices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationIndices", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Location) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Location: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Location: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingIndex", wireType)
			}
			m.MappingIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MappingIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			m.Address = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Address |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Line = append(m.Line, &Line{})
			if err := m.Line[len(m.Line)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AttributeIndices = append(m.AttributeIndices, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProfiles
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProfiles
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthProfiles
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AttributeIndices) == 0 {
					m.AttributeIndices = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProfiles
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AttributeIndices = append(m.AttributeIndices, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Line) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Line: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Line: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionIndex", wireType)
			}
			m.FunctionIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FunctionIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			m.Line = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Line |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			m.Column = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Column |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Function) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Function: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Function: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NameStrindex", wireType)
			}
			m.NameStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NameStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemNameStrindex", wireType)
			}
			m.SystemNameStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SystemNameStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilenameStrindex", wireType)
			}
			m.FilenameStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilenameStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartLine", wireType)
			}
			m.StartLine = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartLine |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValueAndUnit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValueAndUnit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValueAndUnit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyStrindex", wireType)
			}
			m.KeyStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnitStrindex", wireType)
			}
			m.UnitStrindex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UnitStrindex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProfiles(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProfiles
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupProfiles
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthProfiles
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthProfiles        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProfiles          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupProfiles = fmt.Errorf("proto: unexpected end of group")
)
