#ifdef GET_AMDGPUImageDMaskIntrinsicTable_DECL
const AMDGPUImageDMaskIntrinsic *getAMDGPUImageDMaskIntrinsic(unsigned Intr);
#endif

#ifdef GET_AMDGPUImageDMaskIntrinsicTable_IMPL
constexpr AMDGPUImageDMaskIntrinsic AMDGPUImageDMaskIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_getlod_1d }, // 0
  { Intrinsic::amdgcn_image_getlod_1darray }, // 1
  { Intrinsic::amdgcn_image_getlod_2d }, // 2
  { Intrinsic::amdgcn_image_getlod_2darray }, // 3
  { Intrinsic::amdgcn_image_getlod_3d }, // 4
  { Intrinsic::amdgcn_image_getlod_cube }, // 5
  { Intrinsic::amdgcn_image_getresinfo_1d }, // 6
  { Intrinsic::amdgcn_image_getresinfo_1darray }, // 7
  { Intrinsic::amdgcn_image_getresinfo_2d }, // 8
  { Intrinsic::amdgcn_image_getresinfo_2darray }, // 9
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa }, // 10
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa }, // 11
  { Intrinsic::amdgcn_image_getresinfo_3d }, // 12
  { Intrinsic::amdgcn_image_getresinfo_cube }, // 13
  { Intrinsic::amdgcn_image_load_1d }, // 14
  { Intrinsic::amdgcn_image_load_1darray }, // 15
  { Intrinsic::amdgcn_image_load_2d }, // 16
  { Intrinsic::amdgcn_image_load_2darray }, // 17
  { Intrinsic::amdgcn_image_load_2darraymsaa }, // 18
  { Intrinsic::amdgcn_image_load_2dmsaa }, // 19
  { Intrinsic::amdgcn_image_load_3d }, // 20
  { Intrinsic::amdgcn_image_load_cube }, // 21
  { Intrinsic::amdgcn_image_load_mip_1d }, // 22
  { Intrinsic::amdgcn_image_load_mip_1darray }, // 23
  { Intrinsic::amdgcn_image_load_mip_2d }, // 24
  { Intrinsic::amdgcn_image_load_mip_2darray }, // 25
  { Intrinsic::amdgcn_image_load_mip_3d }, // 26
  { Intrinsic::amdgcn_image_load_mip_cube }, // 27
  { Intrinsic::amdgcn_image_sample_1d }, // 28
  { Intrinsic::amdgcn_image_sample_1d_nortn }, // 29
  { Intrinsic::amdgcn_image_sample_1darray }, // 30
  { Intrinsic::amdgcn_image_sample_1darray_nortn }, // 31
  { Intrinsic::amdgcn_image_sample_2d }, // 32
  { Intrinsic::amdgcn_image_sample_2d_nortn }, // 33
  { Intrinsic::amdgcn_image_sample_2darray }, // 34
  { Intrinsic::amdgcn_image_sample_2darray_nortn }, // 35
  { Intrinsic::amdgcn_image_sample_3d }, // 36
  { Intrinsic::amdgcn_image_sample_3d_nortn }, // 37
  { Intrinsic::amdgcn_image_sample_b_1d }, // 38
  { Intrinsic::amdgcn_image_sample_b_1d_nortn }, // 39
  { Intrinsic::amdgcn_image_sample_b_1darray }, // 40
  { Intrinsic::amdgcn_image_sample_b_1darray_nortn }, // 41
  { Intrinsic::amdgcn_image_sample_b_2d }, // 42
  { Intrinsic::amdgcn_image_sample_b_2d_nortn }, // 43
  { Intrinsic::amdgcn_image_sample_b_2darray }, // 44
  { Intrinsic::amdgcn_image_sample_b_2darray_nortn }, // 45
  { Intrinsic::amdgcn_image_sample_b_3d }, // 46
  { Intrinsic::amdgcn_image_sample_b_3d_nortn }, // 47
  { Intrinsic::amdgcn_image_sample_b_cl_1d }, // 48
  { Intrinsic::amdgcn_image_sample_b_cl_1d_nortn }, // 49
  { Intrinsic::amdgcn_image_sample_b_cl_1darray }, // 50
  { Intrinsic::amdgcn_image_sample_b_cl_1darray_nortn }, // 51
  { Intrinsic::amdgcn_image_sample_b_cl_2d }, // 52
  { Intrinsic::amdgcn_image_sample_b_cl_2d_nortn }, // 53
  { Intrinsic::amdgcn_image_sample_b_cl_2darray }, // 54
  { Intrinsic::amdgcn_image_sample_b_cl_2darray_nortn }, // 55
  { Intrinsic::amdgcn_image_sample_b_cl_3d }, // 56
  { Intrinsic::amdgcn_image_sample_b_cl_3d_nortn }, // 57
  { Intrinsic::amdgcn_image_sample_b_cl_cube }, // 58
  { Intrinsic::amdgcn_image_sample_b_cl_cube_nortn }, // 59
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d }, // 60
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d_nortn }, // 61
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray }, // 62
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray_nortn }, // 63
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d }, // 64
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d_nortn }, // 65
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray }, // 66
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray_nortn }, // 67
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d }, // 68
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d_nortn }, // 69
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube }, // 70
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube_nortn }, // 71
  { Intrinsic::amdgcn_image_sample_b_cube }, // 72
  { Intrinsic::amdgcn_image_sample_b_cube_nortn }, // 73
  { Intrinsic::amdgcn_image_sample_b_o_1d }, // 74
  { Intrinsic::amdgcn_image_sample_b_o_1d_nortn }, // 75
  { Intrinsic::amdgcn_image_sample_b_o_1darray }, // 76
  { Intrinsic::amdgcn_image_sample_b_o_1darray_nortn }, // 77
  { Intrinsic::amdgcn_image_sample_b_o_2d }, // 78
  { Intrinsic::amdgcn_image_sample_b_o_2d_nortn }, // 79
  { Intrinsic::amdgcn_image_sample_b_o_2darray }, // 80
  { Intrinsic::amdgcn_image_sample_b_o_2darray_nortn }, // 81
  { Intrinsic::amdgcn_image_sample_b_o_3d }, // 82
  { Intrinsic::amdgcn_image_sample_b_o_3d_nortn }, // 83
  { Intrinsic::amdgcn_image_sample_b_o_cube }, // 84
  { Intrinsic::amdgcn_image_sample_b_o_cube_nortn }, // 85
  { Intrinsic::amdgcn_image_sample_c_1d }, // 86
  { Intrinsic::amdgcn_image_sample_c_1d_nortn }, // 87
  { Intrinsic::amdgcn_image_sample_c_1darray }, // 88
  { Intrinsic::amdgcn_image_sample_c_1darray_nortn }, // 89
  { Intrinsic::amdgcn_image_sample_c_2d }, // 90
  { Intrinsic::amdgcn_image_sample_c_2d_nortn }, // 91
  { Intrinsic::amdgcn_image_sample_c_2darray }, // 92
  { Intrinsic::amdgcn_image_sample_c_2darray_nortn }, // 93
  { Intrinsic::amdgcn_image_sample_c_3d }, // 94
  { Intrinsic::amdgcn_image_sample_c_3d_nortn }, // 95
  { Intrinsic::amdgcn_image_sample_c_b_1d }, // 96
  { Intrinsic::amdgcn_image_sample_c_b_1d_nortn }, // 97
  { Intrinsic::amdgcn_image_sample_c_b_1darray }, // 98
  { Intrinsic::amdgcn_image_sample_c_b_1darray_nortn }, // 99
  { Intrinsic::amdgcn_image_sample_c_b_2d }, // 100
  { Intrinsic::amdgcn_image_sample_c_b_2d_nortn }, // 101
  { Intrinsic::amdgcn_image_sample_c_b_2darray }, // 102
  { Intrinsic::amdgcn_image_sample_c_b_2darray_nortn }, // 103
  { Intrinsic::amdgcn_image_sample_c_b_3d }, // 104
  { Intrinsic::amdgcn_image_sample_c_b_3d_nortn }, // 105
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d }, // 106
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d_nortn }, // 107
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray }, // 108
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray_nortn }, // 109
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d }, // 110
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d_nortn }, // 111
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray }, // 112
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray_nortn }, // 113
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d }, // 114
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d_nortn }, // 115
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube }, // 116
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube_nortn }, // 117
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d }, // 118
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d_nortn }, // 119
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray }, // 120
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray_nortn }, // 121
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d }, // 122
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d_nortn }, // 123
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray }, // 124
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray_nortn }, // 125
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d }, // 126
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d_nortn }, // 127
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube }, // 128
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube_nortn }, // 129
  { Intrinsic::amdgcn_image_sample_c_b_cube }, // 130
  { Intrinsic::amdgcn_image_sample_c_b_cube_nortn }, // 131
  { Intrinsic::amdgcn_image_sample_c_b_o_1d }, // 132
  { Intrinsic::amdgcn_image_sample_c_b_o_1d_nortn }, // 133
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray }, // 134
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray_nortn }, // 135
  { Intrinsic::amdgcn_image_sample_c_b_o_2d }, // 136
  { Intrinsic::amdgcn_image_sample_c_b_o_2d_nortn }, // 137
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray }, // 138
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray_nortn }, // 139
  { Intrinsic::amdgcn_image_sample_c_b_o_3d }, // 140
  { Intrinsic::amdgcn_image_sample_c_b_o_3d_nortn }, // 141
  { Intrinsic::amdgcn_image_sample_c_b_o_cube }, // 142
  { Intrinsic::amdgcn_image_sample_c_b_o_cube_nortn }, // 143
  { Intrinsic::amdgcn_image_sample_c_cd_1d }, // 144
  { Intrinsic::amdgcn_image_sample_c_cd_1d_nortn }, // 145
  { Intrinsic::amdgcn_image_sample_c_cd_1darray }, // 146
  { Intrinsic::amdgcn_image_sample_c_cd_1darray_nortn }, // 147
  { Intrinsic::amdgcn_image_sample_c_cd_2d }, // 148
  { Intrinsic::amdgcn_image_sample_c_cd_2d_nortn }, // 149
  { Intrinsic::amdgcn_image_sample_c_cd_2darray }, // 150
  { Intrinsic::amdgcn_image_sample_c_cd_2darray_nortn }, // 151
  { Intrinsic::amdgcn_image_sample_c_cd_3d }, // 152
  { Intrinsic::amdgcn_image_sample_c_cd_3d_nortn }, // 153
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d }, // 154
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d_nortn }, // 155
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray }, // 156
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray_nortn }, // 157
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d }, // 158
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d_nortn }, // 159
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray }, // 160
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray_nortn }, // 161
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d }, // 162
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d_nortn }, // 163
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube }, // 164
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube_nortn }, // 165
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d }, // 166
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d_nortn }, // 167
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray }, // 168
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray_nortn }, // 169
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d }, // 170
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d_nortn }, // 171
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray }, // 172
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray_nortn }, // 173
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d }, // 174
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d_nortn }, // 175
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube }, // 176
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube_nortn }, // 177
  { Intrinsic::amdgcn_image_sample_c_cd_cube }, // 178
  { Intrinsic::amdgcn_image_sample_c_cd_cube_nortn }, // 179
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d }, // 180
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d_nortn }, // 181
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray }, // 182
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray_nortn }, // 183
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d }, // 184
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d_nortn }, // 185
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray }, // 186
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray_nortn }, // 187
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d }, // 188
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d_nortn }, // 189
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube }, // 190
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube_nortn }, // 191
  { Intrinsic::amdgcn_image_sample_c_cl_1d }, // 192
  { Intrinsic::amdgcn_image_sample_c_cl_1d_nortn }, // 193
  { Intrinsic::amdgcn_image_sample_c_cl_1darray }, // 194
  { Intrinsic::amdgcn_image_sample_c_cl_1darray_nortn }, // 195
  { Intrinsic::amdgcn_image_sample_c_cl_2d }, // 196
  { Intrinsic::amdgcn_image_sample_c_cl_2d_nortn }, // 197
  { Intrinsic::amdgcn_image_sample_c_cl_2darray }, // 198
  { Intrinsic::amdgcn_image_sample_c_cl_2darray_nortn }, // 199
  { Intrinsic::amdgcn_image_sample_c_cl_3d }, // 200
  { Intrinsic::amdgcn_image_sample_c_cl_3d_nortn }, // 201
  { Intrinsic::amdgcn_image_sample_c_cl_cube }, // 202
  { Intrinsic::amdgcn_image_sample_c_cl_cube_nortn }, // 203
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d }, // 204
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d_nortn }, // 205
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray }, // 206
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray_nortn }, // 207
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d }, // 208
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d_nortn }, // 209
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray }, // 210
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray_nortn }, // 211
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d }, // 212
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d_nortn }, // 213
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube }, // 214
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube_nortn }, // 215
  { Intrinsic::amdgcn_image_sample_c_cube }, // 216
  { Intrinsic::amdgcn_image_sample_c_cube_nortn }, // 217
  { Intrinsic::amdgcn_image_sample_c_d_1d }, // 218
  { Intrinsic::amdgcn_image_sample_c_d_1d_nortn }, // 219
  { Intrinsic::amdgcn_image_sample_c_d_1darray }, // 220
  { Intrinsic::amdgcn_image_sample_c_d_1darray_nortn }, // 221
  { Intrinsic::amdgcn_image_sample_c_d_2d }, // 222
  { Intrinsic::amdgcn_image_sample_c_d_2d_nortn }, // 223
  { Intrinsic::amdgcn_image_sample_c_d_2darray }, // 224
  { Intrinsic::amdgcn_image_sample_c_d_2darray_nortn }, // 225
  { Intrinsic::amdgcn_image_sample_c_d_3d }, // 226
  { Intrinsic::amdgcn_image_sample_c_d_3d_nortn }, // 227
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d }, // 228
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d_nortn }, // 229
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray }, // 230
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray_nortn }, // 231
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d }, // 232
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d_nortn }, // 233
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray }, // 234
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray_nortn }, // 235
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d }, // 236
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d_nortn }, // 237
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube }, // 238
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube_nortn }, // 239
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d }, // 240
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d_nortn }, // 241
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray }, // 242
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray_nortn }, // 243
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d }, // 244
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d_nortn }, // 245
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray }, // 246
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray_nortn }, // 247
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d }, // 248
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d_nortn }, // 249
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube }, // 250
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube_nortn }, // 251
  { Intrinsic::amdgcn_image_sample_c_d_cube }, // 252
  { Intrinsic::amdgcn_image_sample_c_d_cube_nortn }, // 253
  { Intrinsic::amdgcn_image_sample_c_d_o_1d }, // 254
  { Intrinsic::amdgcn_image_sample_c_d_o_1d_nortn }, // 255
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray }, // 256
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray_nortn }, // 257
  { Intrinsic::amdgcn_image_sample_c_d_o_2d }, // 258
  { Intrinsic::amdgcn_image_sample_c_d_o_2d_nortn }, // 259
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray }, // 260
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray_nortn }, // 261
  { Intrinsic::amdgcn_image_sample_c_d_o_3d }, // 262
  { Intrinsic::amdgcn_image_sample_c_d_o_3d_nortn }, // 263
  { Intrinsic::amdgcn_image_sample_c_d_o_cube }, // 264
  { Intrinsic::amdgcn_image_sample_c_d_o_cube_nortn }, // 265
  { Intrinsic::amdgcn_image_sample_c_l_1d }, // 266
  { Intrinsic::amdgcn_image_sample_c_l_1d_nortn }, // 267
  { Intrinsic::amdgcn_image_sample_c_l_1darray }, // 268
  { Intrinsic::amdgcn_image_sample_c_l_1darray_nortn }, // 269
  { Intrinsic::amdgcn_image_sample_c_l_2d }, // 270
  { Intrinsic::amdgcn_image_sample_c_l_2d_nortn }, // 271
  { Intrinsic::amdgcn_image_sample_c_l_2darray }, // 272
  { Intrinsic::amdgcn_image_sample_c_l_2darray_nortn }, // 273
  { Intrinsic::amdgcn_image_sample_c_l_3d }, // 274
  { Intrinsic::amdgcn_image_sample_c_l_3d_nortn }, // 275
  { Intrinsic::amdgcn_image_sample_c_l_cube }, // 276
  { Intrinsic::amdgcn_image_sample_c_l_cube_nortn }, // 277
  { Intrinsic::amdgcn_image_sample_c_l_o_1d }, // 278
  { Intrinsic::amdgcn_image_sample_c_l_o_1d_nortn }, // 279
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray }, // 280
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray_nortn }, // 281
  { Intrinsic::amdgcn_image_sample_c_l_o_2d }, // 282
  { Intrinsic::amdgcn_image_sample_c_l_o_2d_nortn }, // 283
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray }, // 284
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray_nortn }, // 285
  { Intrinsic::amdgcn_image_sample_c_l_o_3d }, // 286
  { Intrinsic::amdgcn_image_sample_c_l_o_3d_nortn }, // 287
  { Intrinsic::amdgcn_image_sample_c_l_o_cube }, // 288
  { Intrinsic::amdgcn_image_sample_c_l_o_cube_nortn }, // 289
  { Intrinsic::amdgcn_image_sample_c_lz_1d }, // 290
  { Intrinsic::amdgcn_image_sample_c_lz_1d_nortn }, // 291
  { Intrinsic::amdgcn_image_sample_c_lz_1darray }, // 292
  { Intrinsic::amdgcn_image_sample_c_lz_1darray_nortn }, // 293
  { Intrinsic::amdgcn_image_sample_c_lz_2d }, // 294
  { Intrinsic::amdgcn_image_sample_c_lz_2d_nortn }, // 295
  { Intrinsic::amdgcn_image_sample_c_lz_2darray }, // 296
  { Intrinsic::amdgcn_image_sample_c_lz_2darray_nortn }, // 297
  { Intrinsic::amdgcn_image_sample_c_lz_3d }, // 298
  { Intrinsic::amdgcn_image_sample_c_lz_3d_nortn }, // 299
  { Intrinsic::amdgcn_image_sample_c_lz_cube }, // 300
  { Intrinsic::amdgcn_image_sample_c_lz_cube_nortn }, // 301
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d }, // 302
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d_nortn }, // 303
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray }, // 304
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray_nortn }, // 305
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d }, // 306
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d_nortn }, // 307
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray }, // 308
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray_nortn }, // 309
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d }, // 310
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d_nortn }, // 311
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube }, // 312
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube_nortn }, // 313
  { Intrinsic::amdgcn_image_sample_c_o_1d }, // 314
  { Intrinsic::amdgcn_image_sample_c_o_1d_nortn }, // 315
  { Intrinsic::amdgcn_image_sample_c_o_1darray }, // 316
  { Intrinsic::amdgcn_image_sample_c_o_1darray_nortn }, // 317
  { Intrinsic::amdgcn_image_sample_c_o_2d }, // 318
  { Intrinsic::amdgcn_image_sample_c_o_2d_nortn }, // 319
  { Intrinsic::amdgcn_image_sample_c_o_2darray }, // 320
  { Intrinsic::amdgcn_image_sample_c_o_2darray_nortn }, // 321
  { Intrinsic::amdgcn_image_sample_c_o_3d }, // 322
  { Intrinsic::amdgcn_image_sample_c_o_3d_nortn }, // 323
  { Intrinsic::amdgcn_image_sample_c_o_cube }, // 324
  { Intrinsic::amdgcn_image_sample_c_o_cube_nortn }, // 325
  { Intrinsic::amdgcn_image_sample_cd_1d }, // 326
  { Intrinsic::amdgcn_image_sample_cd_1d_nortn }, // 327
  { Intrinsic::amdgcn_image_sample_cd_1darray }, // 328
  { Intrinsic::amdgcn_image_sample_cd_1darray_nortn }, // 329
  { Intrinsic::amdgcn_image_sample_cd_2d }, // 330
  { Intrinsic::amdgcn_image_sample_cd_2d_nortn }, // 331
  { Intrinsic::amdgcn_image_sample_cd_2darray }, // 332
  { Intrinsic::amdgcn_image_sample_cd_2darray_nortn }, // 333
  { Intrinsic::amdgcn_image_sample_cd_3d }, // 334
  { Intrinsic::amdgcn_image_sample_cd_3d_nortn }, // 335
  { Intrinsic::amdgcn_image_sample_cd_cl_1d }, // 336
  { Intrinsic::amdgcn_image_sample_cd_cl_1d_nortn }, // 337
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray }, // 338
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray_nortn }, // 339
  { Intrinsic::amdgcn_image_sample_cd_cl_2d }, // 340
  { Intrinsic::amdgcn_image_sample_cd_cl_2d_nortn }, // 341
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray }, // 342
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray_nortn }, // 343
  { Intrinsic::amdgcn_image_sample_cd_cl_3d }, // 344
  { Intrinsic::amdgcn_image_sample_cd_cl_3d_nortn }, // 345
  { Intrinsic::amdgcn_image_sample_cd_cl_cube }, // 346
  { Intrinsic::amdgcn_image_sample_cd_cl_cube_nortn }, // 347
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d }, // 348
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d_nortn }, // 349
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray }, // 350
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray_nortn }, // 351
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d }, // 352
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d_nortn }, // 353
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray }, // 354
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray_nortn }, // 355
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d }, // 356
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d_nortn }, // 357
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube }, // 358
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube_nortn }, // 359
  { Intrinsic::amdgcn_image_sample_cd_cube }, // 360
  { Intrinsic::amdgcn_image_sample_cd_cube_nortn }, // 361
  { Intrinsic::amdgcn_image_sample_cd_o_1d }, // 362
  { Intrinsic::amdgcn_image_sample_cd_o_1d_nortn }, // 363
  { Intrinsic::amdgcn_image_sample_cd_o_1darray }, // 364
  { Intrinsic::amdgcn_image_sample_cd_o_1darray_nortn }, // 365
  { Intrinsic::amdgcn_image_sample_cd_o_2d }, // 366
  { Intrinsic::amdgcn_image_sample_cd_o_2d_nortn }, // 367
  { Intrinsic::amdgcn_image_sample_cd_o_2darray }, // 368
  { Intrinsic::amdgcn_image_sample_cd_o_2darray_nortn }, // 369
  { Intrinsic::amdgcn_image_sample_cd_o_3d }, // 370
  { Intrinsic::amdgcn_image_sample_cd_o_3d_nortn }, // 371
  { Intrinsic::amdgcn_image_sample_cd_o_cube }, // 372
  { Intrinsic::amdgcn_image_sample_cd_o_cube_nortn }, // 373
  { Intrinsic::amdgcn_image_sample_cl_1d }, // 374
  { Intrinsic::amdgcn_image_sample_cl_1d_nortn }, // 375
  { Intrinsic::amdgcn_image_sample_cl_1darray }, // 376
  { Intrinsic::amdgcn_image_sample_cl_1darray_nortn }, // 377
  { Intrinsic::amdgcn_image_sample_cl_2d }, // 378
  { Intrinsic::amdgcn_image_sample_cl_2d_nortn }, // 379
  { Intrinsic::amdgcn_image_sample_cl_2darray }, // 380
  { Intrinsic::amdgcn_image_sample_cl_2darray_nortn }, // 381
  { Intrinsic::amdgcn_image_sample_cl_3d }, // 382
  { Intrinsic::amdgcn_image_sample_cl_3d_nortn }, // 383
  { Intrinsic::amdgcn_image_sample_cl_cube }, // 384
  { Intrinsic::amdgcn_image_sample_cl_cube_nortn }, // 385
  { Intrinsic::amdgcn_image_sample_cl_o_1d }, // 386
  { Intrinsic::amdgcn_image_sample_cl_o_1d_nortn }, // 387
  { Intrinsic::amdgcn_image_sample_cl_o_1darray }, // 388
  { Intrinsic::amdgcn_image_sample_cl_o_1darray_nortn }, // 389
  { Intrinsic::amdgcn_image_sample_cl_o_2d }, // 390
  { Intrinsic::amdgcn_image_sample_cl_o_2d_nortn }, // 391
  { Intrinsic::amdgcn_image_sample_cl_o_2darray }, // 392
  { Intrinsic::amdgcn_image_sample_cl_o_2darray_nortn }, // 393
  { Intrinsic::amdgcn_image_sample_cl_o_3d }, // 394
  { Intrinsic::amdgcn_image_sample_cl_o_3d_nortn }, // 395
  { Intrinsic::amdgcn_image_sample_cl_o_cube }, // 396
  { Intrinsic::amdgcn_image_sample_cl_o_cube_nortn }, // 397
  { Intrinsic::amdgcn_image_sample_cube }, // 398
  { Intrinsic::amdgcn_image_sample_cube_nortn }, // 399
  { Intrinsic::amdgcn_image_sample_d_1d }, // 400
  { Intrinsic::amdgcn_image_sample_d_1d_nortn }, // 401
  { Intrinsic::amdgcn_image_sample_d_1darray }, // 402
  { Intrinsic::amdgcn_image_sample_d_1darray_nortn }, // 403
  { Intrinsic::amdgcn_image_sample_d_2d }, // 404
  { Intrinsic::amdgcn_image_sample_d_2d_nortn }, // 405
  { Intrinsic::amdgcn_image_sample_d_2darray }, // 406
  { Intrinsic::amdgcn_image_sample_d_2darray_nortn }, // 407
  { Intrinsic::amdgcn_image_sample_d_3d }, // 408
  { Intrinsic::amdgcn_image_sample_d_3d_nortn }, // 409
  { Intrinsic::amdgcn_image_sample_d_cl_1d }, // 410
  { Intrinsic::amdgcn_image_sample_d_cl_1d_nortn }, // 411
  { Intrinsic::amdgcn_image_sample_d_cl_1darray }, // 412
  { Intrinsic::amdgcn_image_sample_d_cl_1darray_nortn }, // 413
  { Intrinsic::amdgcn_image_sample_d_cl_2d }, // 414
  { Intrinsic::amdgcn_image_sample_d_cl_2d_nortn }, // 415
  { Intrinsic::amdgcn_image_sample_d_cl_2darray }, // 416
  { Intrinsic::amdgcn_image_sample_d_cl_2darray_nortn }, // 417
  { Intrinsic::amdgcn_image_sample_d_cl_3d }, // 418
  { Intrinsic::amdgcn_image_sample_d_cl_3d_nortn }, // 419
  { Intrinsic::amdgcn_image_sample_d_cl_cube }, // 420
  { Intrinsic::amdgcn_image_sample_d_cl_cube_nortn }, // 421
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d }, // 422
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d_nortn }, // 423
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray }, // 424
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray_nortn }, // 425
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d }, // 426
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d_nortn }, // 427
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray }, // 428
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray_nortn }, // 429
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d }, // 430
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d_nortn }, // 431
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube }, // 432
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube_nortn }, // 433
  { Intrinsic::amdgcn_image_sample_d_cube }, // 434
  { Intrinsic::amdgcn_image_sample_d_cube_nortn }, // 435
  { Intrinsic::amdgcn_image_sample_d_o_1d }, // 436
  { Intrinsic::amdgcn_image_sample_d_o_1d_nortn }, // 437
  { Intrinsic::amdgcn_image_sample_d_o_1darray }, // 438
  { Intrinsic::amdgcn_image_sample_d_o_1darray_nortn }, // 439
  { Intrinsic::amdgcn_image_sample_d_o_2d }, // 440
  { Intrinsic::amdgcn_image_sample_d_o_2d_nortn }, // 441
  { Intrinsic::amdgcn_image_sample_d_o_2darray }, // 442
  { Intrinsic::amdgcn_image_sample_d_o_2darray_nortn }, // 443
  { Intrinsic::amdgcn_image_sample_d_o_3d }, // 444
  { Intrinsic::amdgcn_image_sample_d_o_3d_nortn }, // 445
  { Intrinsic::amdgcn_image_sample_d_o_cube }, // 446
  { Intrinsic::amdgcn_image_sample_d_o_cube_nortn }, // 447
  { Intrinsic::amdgcn_image_sample_l_1d }, // 448
  { Intrinsic::amdgcn_image_sample_l_1d_nortn }, // 449
  { Intrinsic::amdgcn_image_sample_l_1darray }, // 450
  { Intrinsic::amdgcn_image_sample_l_1darray_nortn }, // 451
  { Intrinsic::amdgcn_image_sample_l_2d }, // 452
  { Intrinsic::amdgcn_image_sample_l_2d_nortn }, // 453
  { Intrinsic::amdgcn_image_sample_l_2darray }, // 454
  { Intrinsic::amdgcn_image_sample_l_2darray_nortn }, // 455
  { Intrinsic::amdgcn_image_sample_l_3d }, // 456
  { Intrinsic::amdgcn_image_sample_l_3d_nortn }, // 457
  { Intrinsic::amdgcn_image_sample_l_cube }, // 458
  { Intrinsic::amdgcn_image_sample_l_cube_nortn }, // 459
  { Intrinsic::amdgcn_image_sample_l_o_1d }, // 460
  { Intrinsic::amdgcn_image_sample_l_o_1d_nortn }, // 461
  { Intrinsic::amdgcn_image_sample_l_o_1darray }, // 462
  { Intrinsic::amdgcn_image_sample_l_o_1darray_nortn }, // 463
  { Intrinsic::amdgcn_image_sample_l_o_2d }, // 464
  { Intrinsic::amdgcn_image_sample_l_o_2d_nortn }, // 465
  { Intrinsic::amdgcn_image_sample_l_o_2darray }, // 466
  { Intrinsic::amdgcn_image_sample_l_o_2darray_nortn }, // 467
  { Intrinsic::amdgcn_image_sample_l_o_3d }, // 468
  { Intrinsic::amdgcn_image_sample_l_o_3d_nortn }, // 469
  { Intrinsic::amdgcn_image_sample_l_o_cube }, // 470
  { Intrinsic::amdgcn_image_sample_l_o_cube_nortn }, // 471
  { Intrinsic::amdgcn_image_sample_lz_1d }, // 472
  { Intrinsic::amdgcn_image_sample_lz_1d_nortn }, // 473
  { Intrinsic::amdgcn_image_sample_lz_1darray }, // 474
  { Intrinsic::amdgcn_image_sample_lz_1darray_nortn }, // 475
  { Intrinsic::amdgcn_image_sample_lz_2d }, // 476
  { Intrinsic::amdgcn_image_sample_lz_2d_nortn }, // 477
  { Intrinsic::amdgcn_image_sample_lz_2darray }, // 478
  { Intrinsic::amdgcn_image_sample_lz_2darray_nortn }, // 479
  { Intrinsic::amdgcn_image_sample_lz_3d }, // 480
  { Intrinsic::amdgcn_image_sample_lz_3d_nortn }, // 481
  { Intrinsic::amdgcn_image_sample_lz_cube }, // 482
  { Intrinsic::amdgcn_image_sample_lz_cube_nortn }, // 483
  { Intrinsic::amdgcn_image_sample_lz_o_1d }, // 484
  { Intrinsic::amdgcn_image_sample_lz_o_1d_nortn }, // 485
  { Intrinsic::amdgcn_image_sample_lz_o_1darray }, // 486
  { Intrinsic::amdgcn_image_sample_lz_o_1darray_nortn }, // 487
  { Intrinsic::amdgcn_image_sample_lz_o_2d }, // 488
  { Intrinsic::amdgcn_image_sample_lz_o_2d_nortn }, // 489
  { Intrinsic::amdgcn_image_sample_lz_o_2darray }, // 490
  { Intrinsic::amdgcn_image_sample_lz_o_2darray_nortn }, // 491
  { Intrinsic::amdgcn_image_sample_lz_o_3d }, // 492
  { Intrinsic::amdgcn_image_sample_lz_o_3d_nortn }, // 493
  { Intrinsic::amdgcn_image_sample_lz_o_cube }, // 494
  { Intrinsic::amdgcn_image_sample_lz_o_cube_nortn }, // 495
  { Intrinsic::amdgcn_image_sample_o_1d }, // 496
  { Intrinsic::amdgcn_image_sample_o_1d_nortn }, // 497
  { Intrinsic::amdgcn_image_sample_o_1darray }, // 498
  { Intrinsic::amdgcn_image_sample_o_1darray_nortn }, // 499
  { Intrinsic::amdgcn_image_sample_o_2d }, // 500
  { Intrinsic::amdgcn_image_sample_o_2d_nortn }, // 501
  { Intrinsic::amdgcn_image_sample_o_2darray }, // 502
  { Intrinsic::amdgcn_image_sample_o_2darray_nortn }, // 503
  { Intrinsic::amdgcn_image_sample_o_3d }, // 504
  { Intrinsic::amdgcn_image_sample_o_3d_nortn }, // 505
  { Intrinsic::amdgcn_image_sample_o_cube }, // 506
  { Intrinsic::amdgcn_image_sample_o_cube_nortn }, // 507
  { Intrinsic::amdgcn_image_store_1d }, // 508
  { Intrinsic::amdgcn_image_store_1darray }, // 509
  { Intrinsic::amdgcn_image_store_2d }, // 510
  { Intrinsic::amdgcn_image_store_2darray }, // 511
  { Intrinsic::amdgcn_image_store_2darraymsaa }, // 512
  { Intrinsic::amdgcn_image_store_2dmsaa }, // 513
  { Intrinsic::amdgcn_image_store_3d }, // 514
  { Intrinsic::amdgcn_image_store_cube }, // 515
  { Intrinsic::amdgcn_image_store_mip_1d }, // 516
  { Intrinsic::amdgcn_image_store_mip_1darray }, // 517
  { Intrinsic::amdgcn_image_store_mip_2d }, // 518
  { Intrinsic::amdgcn_image_store_mip_2darray }, // 519
  { Intrinsic::amdgcn_image_store_mip_3d }, // 520
  { Intrinsic::amdgcn_image_store_mip_cube }, // 521
 };

const AMDGPUImageDMaskIntrinsic *getAMDGPUImageDMaskIntrinsic(unsigned Intr) {
  if ((Intr < Intrinsic::amdgcn_image_getlod_1d) ||
      (Intr > Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  struct Comp {
    bool operator()(const AMDGPUImageDMaskIntrinsic &LHS, const KeyType &RHS) const {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(AMDGPUImageDMaskIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;

  return &*Idx;
}
#endif

#undef GET_AMDGPUImageDMaskIntrinsicTable_DECL
#undef GET_AMDGPUImageDMaskIntrinsicTable_IMPL
