/* XmlElement.c generated by valac 0.56.14, the Vala compiler
 * generated from XmlElement.vala, do not modify */

/*
Copyright (C) 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "xmlbird.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#define B_TYPE_ELEMENTS (b_elements_get_type ())
#define B_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), B_TYPE_ELEMENTS, BElements))
#define B_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), B_TYPE_ELEMENTS, BElementsClass))
#define B_IS_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), B_TYPE_ELEMENTS))
#define B_IS_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), B_TYPE_ELEMENTS))
#define B_ELEMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), B_TYPE_ELEMENTS, BElementsClass))

typedef struct _BElements BElements;
typedef struct _BElementsClass BElementsClass;
enum  {
	B_XML_ELEMENT_0_PROPERTY,
	B_XML_ELEMENT_NUM_PROPERTIES
};
static GParamSpec* b_xml_element_properties[B_XML_ELEMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BElementsPrivate BElementsPrivate;
enum  {
	B_XML_ELEMENT_ITERATOR_0_PROPERTY,
	B_XML_ELEMENT_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* b_xml_element_iterator_properties[B_XML_ELEMENT_ITERATOR_NUM_PROPERTIES];

struct _BXmlElementPrivate {
	gchar* name;
	gchar* xml_namespace;
	gchar* content;
	gboolean leaf;
	BXmlElement* parent;
	BElements* children;
	BElements* attributes;
};

struct _BElements {
	GObject parent_instance;
	BElementsPrivate * priv;
	gint size;
};

struct _BElementsClass {
	GObjectClass parent_class;
};

struct _BXmlElementIteratorPrivate {
	gint index;
	BElements* xml_elements;
};

static gint BXmlElement_private_offset;
static gpointer b_xml_element_parent_class = NULL;
static gint BXmlElementIterator_private_offset;
static gpointer b_xml_element_iterator_parent_class = NULL;

VALA_EXTERN GType b_elements_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void b_xml_element_remove_parent (BXmlElement* self);
VALA_EXTERN BXmlElement* b_xml_element_new (BXmlElement* parent,
                                BTag* tag);
VALA_EXTERN BXmlElement* b_xml_element_construct (GType object_type,
                                      BXmlElement* parent,
                                      BTag* tag);
VALA_EXTERN BElements* b_xml_element_parse_tags (BXmlElement* self,
                                     BTag* tag);
VALA_EXTERN BElements* b_xml_element_parse_attributes (BXmlElement* self,
                                           BTag* tag);
VALA_EXTERN BXmlElement* b_xml_element_new_attribute (BAttribute* attribute);
VALA_EXTERN BXmlElement* b_xml_element_construct_attribute (GType object_type,
                                                BAttribute* attribute);
VALA_EXTERN BElements* b_elements_new (void);
VALA_EXTERN BElements* b_elements_construct (GType object_type);
VALA_EXTERN BAttributes* b_attributes_new_for_element (BElements* elements);
VALA_EXTERN BAttributes* b_attributes_construct_for_element (GType object_type,
                                                 BElements* elements);
VALA_EXTERN void b_elements_add (BElements* self,
                     BXmlElement* element);
VALA_EXTERN BXmlElementIterator* b_xml_element_iterator_new (BElements* xml_elements);
VALA_EXTERN BXmlElementIterator* b_xml_element_iterator_construct (GType object_type,
                                                       BElements* xml_elements);
VALA_EXTERN void b_xml_parser_warning (const gchar* message);
VALA_EXTERN BXmlElement* b_elements_get_element (BElements* self,
                                     gint index);
static void b_xml_element_iterator_finalize (GObject * obj);
static GType b_xml_element_iterator_get_type_once (void);
static void b_xml_element_finalize (GObject * obj);
static GType b_xml_element_get_type_once (void);

static inline gpointer
b_xml_element_get_instance_private (BXmlElement* self)
{
	return G_STRUCT_MEMBER_P (self, BXmlElement_private_offset);
}

BXmlElement*
b_xml_element_construct_empty (GType object_type)
{
	BXmlElement * self = NULL;
	self = (BXmlElement*) g_object_new (object_type, NULL);
	return self;
}

BXmlElement*
b_xml_element_new_empty (void)
{
	return b_xml_element_construct_empty (B_TYPE_XML_ELEMENT);
}

BXmlElement*
b_xml_element_construct (GType object_type,
                         BXmlElement* parent,
                         BTag* tag)
{
	BXmlElement * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BElements* _tmp2_;
	BElements* _tmp3_;
	BElements* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (tag != NULL, NULL);
	self = (BXmlElement*) g_object_new (object_type, NULL);
	_tmp0_ = b_tag_get_name (tag);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = b_tag_get_namespace (tag);
	_g_free0 (self->priv->xml_namespace);
	self->priv->xml_namespace = _tmp1_;
	self->priv->parent = parent;
	_tmp2_ = b_xml_element_parse_tags (self, tag);
	_g_object_unref0 (self->priv->children);
	self->priv->children = _tmp2_;
	_tmp3_ = b_xml_element_parse_attributes (self, tag);
	_g_object_unref0 (self->priv->attributes);
	self->priv->attributes = _tmp3_;
	_tmp4_ = self->priv->children;
	self->priv->leaf = _tmp4_ == NULL;
	_tmp5_ = b_tag_get_content (tag);
	_g_free0 (self->priv->content);
	self->priv->content = _tmp5_;
	return self;
}

BXmlElement*
b_xml_element_new (BXmlElement* parent,
                   BTag* tag)
{
	return b_xml_element_construct (B_TYPE_XML_ELEMENT, parent, tag);
}

BXmlElement*
b_xml_element_construct_attribute (GType object_type,
                                   BAttribute* attribute)
{
	BXmlElement * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (attribute != NULL, NULL);
	self = (BXmlElement*) g_object_new (object_type, NULL);
	_tmp0_ = b_attribute_get_name (attribute);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = b_attribute_get_namespace (attribute);
	_g_free0 (self->priv->xml_namespace);
	self->priv->xml_namespace = _tmp1_;
	_tmp2_ = b_attribute_get_content (attribute);
	_g_free0 (self->priv->content);
	self->priv->content = _tmp2_;
	return self;
}

BXmlElement*
b_xml_element_new_attribute (BAttribute* attribute)
{
	return b_xml_element_construct_attribute (B_TYPE_XML_ELEMENT, attribute);
}

BAttributes*
b_xml_element_get_attributes (BXmlElement* self)
{
	BElements* _tmp0_;
	BElements* _tmp5_;
	BAttributes* _tmp6_;
	BAttributes* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->attributes;
	if (_tmp0_ == NULL) {
		BElements* _tmp1_;
		BElements* _tmp2_;
		BAttributes* _tmp3_;
		BAttributes* _tmp4_;
		_tmp1_ = b_elements_new ();
		_tmp2_ = _tmp1_;
		_tmp3_ = b_attributes_new_for_element (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->attributes;
	_tmp6_ = b_attributes_new_for_element (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, B_TYPE_ELEMENTS, BElements));
	result = _tmp6_;
	return result;
}

void
b_xml_element_remove_parent (BXmlElement* self)
{
	g_return_if_fail (self != NULL);
	self->priv->parent = NULL;
}

BElements*
b_xml_element_parse_tags (BXmlElement* self,
                          BTag* tag)
{
	BElements* elements = NULL;
	BElements* _tmp0_;
	BElements* _tmp9_;
	BElements* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = b_elements_new ();
	elements = _tmp0_;
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp1_;
		_tmp1_ = b_tag_iterator (tag);
		_t_it = _tmp1_;
		while (TRUE) {
			BTagIterator* _tmp2_;
			BTag* t = NULL;
			BTagIterator* _tmp3_;
			BTag* _tmp4_;
			BElements* _tmp5_;
			BTag* _tmp6_;
			BXmlElement* _tmp7_;
			BXmlElement* _tmp8_;
			_tmp2_ = _t_it;
			if (!b_tag_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _t_it;
			_tmp4_ = b_tag_iterator_get (_tmp3_);
			t = _tmp4_;
			_tmp5_ = elements;
			_tmp6_ = t;
			_tmp7_ = b_xml_element_new (self, _tmp6_);
			_tmp8_ = _tmp7_;
			b_elements_add (_tmp5_, _tmp8_);
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_tmp9_ = elements;
	if (_tmp9_->size == 0) {
		result = NULL;
		_g_object_unref0 (elements);
		return result;
	}
	result = elements;
	return result;
}

BElements*
b_xml_element_parse_attributes (BXmlElement* self,
                                BTag* tag)
{
	BAttributes* tag_attributes = NULL;
	BAttributes* _tmp0_;
	BElements* elements = NULL;
	BElements* _tmp1_;
	BElements* _tmp11_;
	BElements* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = b_tag_get_attributes (tag);
	tag_attributes = _tmp0_;
	_tmp1_ = b_elements_new ();
	elements = _tmp1_;
	{
		BAttributesIterator* _a_it = NULL;
		BAttributes* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp2_ = tag_attributes;
		_tmp3_ = b_attributes_iterator (_tmp2_);
		_a_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* a = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			BElements* _tmp7_;
			BAttribute* _tmp8_;
			BXmlElement* _tmp9_;
			BXmlElement* _tmp10_;
			_tmp4_ = _a_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _a_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			a = _tmp6_;
			_tmp7_ = elements;
			_tmp8_ = a;
			_tmp9_ = b_xml_element_new_attribute (_tmp8_);
			_tmp10_ = _tmp9_;
			b_elements_add (_tmp7_, _tmp10_);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	_tmp11_ = elements;
	if (_tmp11_->size == 0) {
		result = NULL;
		_g_object_unref0 (elements);
		_g_object_unref0 (tag_attributes);
		return result;
	}
	result = elements;
	_g_object_unref0 (tag_attributes);
	return result;
}

/** Get a reference to the parent element. This method will return 
 * null if the parent element has been deleted, if the method is called
 * on the root element or if the method is called on an attribute.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BXmlElement*
b_xml_element_get_parent (BXmlElement* self)
{
	BXmlElement* _tmp0_;
	BXmlElement* e = NULL;
	BXmlElement* _tmp1_;
	BXmlElement* _tmp2_;
	BXmlElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parent;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->parent;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, B_TYPE_XML_ELEMENT, BXmlElement));
	e = _tmp2_;
	result = e;
	return result;
}

gboolean
b_xml_element_is_leaf (BXmlElement* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->leaf;
	return result;
}

gchar*
b_xml_element_get_name (BXmlElement* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
b_xml_element_get_namespace (BXmlElement* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->xml_namespace;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
b_xml_element_get_content (BXmlElement* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->content;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

BXmlElementIterator*
b_xml_element_iterator (BXmlElement* self)
{
	BElements* _tmp0_;
	BXmlElementIterator* _tmp1_;
	BXmlElementIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->children;
	_tmp1_ = b_xml_element_iterator_new (_tmp0_);
	result = _tmp1_;
	return result;
}

static inline gpointer
b_xml_element_iterator_get_instance_private (BXmlElementIterator* self)
{
	return G_STRUCT_MEMBER_P (self, BXmlElementIterator_private_offset);
}

BXmlElementIterator*
b_xml_element_iterator_construct (GType object_type,
                                  BElements* xml_elements)
{
	BXmlElementIterator * self = NULL;
	BElements* _tmp0_;
	self = (BXmlElementIterator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (xml_elements);
	_g_object_unref0 (self->priv->xml_elements);
	self->priv->xml_elements = _tmp0_;
	return self;
}

BXmlElementIterator*
b_xml_element_iterator_new (BElements* xml_elements)
{
	return b_xml_element_iterator_construct (B_XML_ELEMENT_TYPE_ITERATOR, xml_elements);
}

gboolean
b_xml_element_iterator_next (BXmlElementIterator* self)
{
	BElements* _tmp0_;
	BElements* e = NULL;
	BElements* _tmp1_;
	BElements* _tmp2_;
	gint _tmp3_;
	BElements* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->xml_elements;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->xml_elements;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, B_TYPE_ELEMENTS, BElements));
	e = _tmp2_;
	_tmp3_ = self->priv->index;
	self->priv->index = _tmp3_ + 1;
	_tmp4_ = e;
	result = self->priv->index < _tmp4_->size;
	_g_object_unref0 (e);
	return result;
}

BXmlElement*
b_xml_element_iterator_get (BXmlElementIterator* self)
{
	BElements* _tmp0_;
	BElements* e = NULL;
	BElements* _tmp2_;
	BElements* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BElements* _tmp5_;
	BXmlElement* element = NULL;
	BElements* _tmp14_;
	BXmlElement* _tmp15_;
	BXmlElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->xml_elements;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		BXmlElement* _tmp1_;
		b_xml_parser_warning ("No elements available.");
		_tmp1_ = b_xml_element_new_empty ();
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->xml_elements;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, B_TYPE_ELEMENTS, BElements));
	e = _tmp3_;
	_tmp5_ = e;
	if (self->priv->index >= _tmp5_->size) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = self->priv->index < 0;
	}
	if (G_UNLIKELY (_tmp4_)) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		BElements* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		BXmlElement* _tmp13_;
		_tmp6_ = g_strdup_printf ("%i", self->priv->index);
		_tmp7_ = _tmp6_;
		_tmp8_ = e;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_->size);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Element index out of bounds (", _tmp7_, " >= ", _tmp10_, ").", NULL);
		_tmp12_ = _tmp11_;
		b_xml_parser_warning (_tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		_tmp13_ = b_xml_element_new_empty ();
		result = _tmp13_;
		_g_object_unref0 (e);
		return result;
	}
	_tmp14_ = e;
	_tmp15_ = b_elements_get_element (_tmp14_, self->priv->index);
	element = _tmp15_;
	result = element;
	_g_object_unref0 (e);
	return result;
}

static void
b_xml_element_iterator_class_init (BXmlElementIteratorClass * klass,
                                   gpointer klass_data)
{
	b_xml_element_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BXmlElementIterator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = b_xml_element_iterator_finalize;
}

static void
b_xml_element_iterator_instance_init (BXmlElementIterator * self,
                                      gpointer klass)
{
	self->priv = b_xml_element_iterator_get_instance_private (self);
	self->priv->index = -1;
}

static void
b_xml_element_iterator_finalize (GObject * obj)
{
	BXmlElementIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, B_XML_ELEMENT_TYPE_ITERATOR, BXmlElementIterator);
	_g_object_unref0 (self->priv->xml_elements);
	G_OBJECT_CLASS (b_xml_element_iterator_parent_class)->finalize (obj);
}

static GType
b_xml_element_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BXmlElementIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) b_xml_element_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BXmlElementIterator), 0, (GInstanceInitFunc) b_xml_element_iterator_instance_init, NULL };
	GType b_xml_element_iterator_type_id;
	b_xml_element_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "BXmlElementIterator", &g_define_type_info, 0);
	BXmlElementIterator_private_offset = g_type_add_instance_private (b_xml_element_iterator_type_id, sizeof (BXmlElementIteratorPrivate));
	return b_xml_element_iterator_type_id;
}

GType
b_xml_element_iterator_get_type (void)
{
	static volatile gsize b_xml_element_iterator_type_id__once = 0;
	if (g_once_init_enter (&b_xml_element_iterator_type_id__once)) {
		GType b_xml_element_iterator_type_id;
		b_xml_element_iterator_type_id = b_xml_element_iterator_get_type_once ();
		g_once_init_leave (&b_xml_element_iterator_type_id__once, b_xml_element_iterator_type_id);
	}
	return b_xml_element_iterator_type_id__once;
}

static void
b_xml_element_class_init (BXmlElementClass * klass,
                          gpointer klass_data)
{
	b_xml_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BXmlElement_private_offset);
	G_OBJECT_CLASS (klass)->finalize = b_xml_element_finalize;
}

static void
b_xml_element_instance_init (BXmlElement * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = b_xml_element_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->xml_namespace = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->content = _tmp2_;
	self->priv->leaf = TRUE;
	self->priv->parent = NULL;
	self->priv->children = NULL;
	self->priv->attributes = NULL;
}

static void
b_xml_element_finalize (GObject * obj)
{
	BXmlElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, B_TYPE_XML_ELEMENT, BXmlElement);
	{
		BXmlElementIterator* _child_it = NULL;
		BXmlElementIterator* _tmp0_;
		_tmp0_ = b_xml_element_iterator (self);
		_child_it = _tmp0_;
		while (TRUE) {
			BXmlElementIterator* _tmp1_;
			BXmlElement* child = NULL;
			BXmlElementIterator* _tmp2_;
			BXmlElement* _tmp3_;
			BXmlElement* _tmp4_;
			_tmp1_ = _child_it;
			if (!b_xml_element_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _child_it;
			_tmp3_ = b_xml_element_iterator_get (_tmp2_);
			child = _tmp3_;
			_tmp4_ = child;
			b_xml_element_remove_parent (_tmp4_);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->xml_namespace);
	_g_free0 (self->priv->content);
	_g_object_unref0 (self->priv->children);
	_g_object_unref0 (self->priv->attributes);
	G_OBJECT_CLASS (b_xml_element_parent_class)->finalize (obj);
}

/**
 * Representation of tags and content in an XML document.
 */
static GType
b_xml_element_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BXmlElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) b_xml_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BXmlElement), 0, (GInstanceInitFunc) b_xml_element_instance_init, NULL };
	GType b_xml_element_type_id;
	b_xml_element_type_id = g_type_register_static (G_TYPE_OBJECT, "BXmlElement", &g_define_type_info, 0);
	BXmlElement_private_offset = g_type_add_instance_private (b_xml_element_type_id, sizeof (BXmlElementPrivate));
	return b_xml_element_type_id;
}

GType
b_xml_element_get_type (void)
{
	static volatile gsize b_xml_element_type_id__once = 0;
	if (g_once_init_enter (&b_xml_element_type_id__once)) {
		GType b_xml_element_type_id;
		b_xml_element_type_id = b_xml_element_get_type_once ();
		g_once_init_leave (&b_xml_element_type_id__once, b_xml_element_type_id);
	}
	return b_xml_element_type_id__once;
}

