
/* GENERATED CODE... DO NOT EDIT */

/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "mbim-google.h"
#include "mbim-message-private.h"
#include "mbim-tlv-private.h"
#include "mbim-enum-types.h"
#include "mbim-flag-types.h"
#include "mbim-error-types.h"
#include "mbim-device.h"
#include "mbim-utils.h"

/*****************************************************************************/
/* Message (Query): MBIM Message Google Carrier Lock */

MbimMessage *
mbim_message_google_carrier_lock_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_GOOGLE,
                                                 MBIM_CID_GOOGLE_CARRIER_LOCK,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_google_carrier_lock_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Google Carrier Lock */

MbimMessage *
mbim_message_google_carrier_lock_set_new (
    const guint32 data_size,
    const guint8 *data,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_GOOGLE,
                                                 MBIM_CID_GOOGLE_CARRIER_LOCK,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_byte_array (builder, FALSE, TRUE, TRUE, data, data_size, FALSE);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_google_carrier_lock_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Data = ", line_prefix);
    {
        guint i;
        const guint8 *tmp;
        guint32 tmpsize;

        if (!_mbim_message_read_byte_array (message, 0, offset, FALSE, TRUE, 0, &tmp, &tmpsize, &inner_error, FALSE))
            goto out;
        offset += 4;
        {
            g_string_append (str, "'");
            for (i = 0; i  < tmpsize; i++)
                g_string_append_printf (str, "%02x%s", tmp[i], (i == (tmpsize - 1)) ? "" : ":" );
            g_string_append (str, "'");
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Google Carrier Lock */

gboolean
mbim_message_google_carrier_lock_response_parse (
    const MbimMessage *message,
    MbimCarrierLockStatus *out_carrier_lock_status,
    MbimCarrierLockModemState *out_carrier_lock_modem_state,
    MbimCarrierLockCause *out_carrier_lock_cause,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'CarrierLockStatus' variable */
    {
        if (out_carrier_lock_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_carrier_lock_status = (MbimCarrierLockStatus)aux;
        }
        offset += 4;
    }

    /* Read the 'CarrierLockModemState' variable */
    {
        if (out_carrier_lock_modem_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_carrier_lock_modem_state = (MbimCarrierLockModemState)aux;
        }
        offset += 4;
    }

    /* Read the 'CarrierLockCause' variable */
    {
        if (out_carrier_lock_cause != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_carrier_lock_cause = (MbimCarrierLockCause)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_google_carrier_lock_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  CarrierLockStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CARRIER_LOCK_STATUS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_carrier_lock_status_get_string ((MbimCarrierLockStatus)tmp));
#elif defined __MBIM_CARRIER_LOCK_STATUS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_carrier_lock_status_build_string_from_mask ((MbimCarrierLockStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CarrierLockModemState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CARRIER_LOCK_MODEM_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_carrier_lock_modem_state_get_string ((MbimCarrierLockModemState)tmp));
#elif defined __MBIM_CARRIER_LOCK_MODEM_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_carrier_lock_modem_state_build_string_from_mask ((MbimCarrierLockModemState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CarrierLockCause = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CARRIER_LOCK_CAUSE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_carrier_lock_cause_get_string ((MbimCarrierLockCause)tmp));
#elif defined __MBIM_CARRIER_LOCK_CAUSE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_carrier_lock_cause_build_string_from_mask ((MbimCarrierLockCause)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Google Carrier Lock */

gboolean
mbim_message_google_carrier_lock_notification_parse (
    const MbimMessage *message,
    MbimCarrierLockStatus *out_carrier_lock_status,
    MbimCarrierLockModemState *out_carrier_lock_modem_state,
    MbimCarrierLockCause *out_carrier_lock_cause,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'CarrierLockStatus' variable */
    {
        if (out_carrier_lock_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_carrier_lock_status = (MbimCarrierLockStatus)aux;
        }
        offset += 4;
    }

    /* Read the 'CarrierLockModemState' variable */
    {
        if (out_carrier_lock_modem_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_carrier_lock_modem_state = (MbimCarrierLockModemState)aux;
        }
        offset += 4;
    }

    /* Read the 'CarrierLockCause' variable */
    {
        if (out_carrier_lock_cause != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_carrier_lock_cause = (MbimCarrierLockCause)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_google_carrier_lock_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  CarrierLockStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CARRIER_LOCK_STATUS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_carrier_lock_status_get_string ((MbimCarrierLockStatus)tmp));
#elif defined __MBIM_CARRIER_LOCK_STATUS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_carrier_lock_status_build_string_from_mask ((MbimCarrierLockStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CarrierLockModemState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CARRIER_LOCK_MODEM_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_carrier_lock_modem_state_get_string ((MbimCarrierLockModemState)tmp));
#elif defined __MBIM_CARRIER_LOCK_MODEM_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_carrier_lock_modem_state_build_string_from_mask ((MbimCarrierLockModemState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CarrierLockCause = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CARRIER_LOCK_CAUSE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_carrier_lock_cause_get_string ((MbimCarrierLockCause)tmp));
#elif defined __MBIM_CARRIER_LOCK_CAUSE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_carrier_lock_cause_build_string_from_mask ((MbimCarrierLockCause)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

typedef struct {
  gchar * (* query_cb)        (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* set_cb)          (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* response_cb)     (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* notification_cb) (const MbimMessage *message, const gchar *line_prefix, GError **error);
} GetPrintableCallbacks;

static const GetPrintableCallbacks google_get_printable_callbacks[] = {
    [MBIM_CID_GOOGLE_CARRIER_LOCK] = {
        .query_cb = mbim_message_google_carrier_lock_query_get_printable,
        .set_cb = mbim_message_google_carrier_lock_set_get_printable,
        .response_cb = mbim_message_google_carrier_lock_response_get_printable,
        .notification_cb = mbim_message_google_carrier_lock_notification_get_printable,
    },
};

gchar *
__mbim_message_google_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (google_get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (google_get_printable_callbacks[cid].query_cb)
                            return google_get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (google_get_printable_callbacks[cid].set_cb)
                            return google_get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (google_get_printable_callbacks)) {
                if (google_get_printable_callbacks[cid].response_cb)
                    return google_get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (google_get_printable_callbacks)) {
                if (google_get_printable_callbacks[cid].notification_cb)
                    return google_get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_UNSUPPORTED,
                 "Unsupported message");
    return NULL;
}
