//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdns

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ResourceReferenceClient contains the methods for the DNSResourceReference group.
// Don't use this type directly, use NewResourceReferenceClient() instead.
type ResourceReferenceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewResourceReferenceClient creates a new instance of ResourceReferenceClient with the specified values.
//   - subscriptionID - Specifies the Azure subscription ID, which uniquely identifies the Microsoft Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewResourceReferenceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ResourceReferenceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ResourceReferenceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// GetByTargetResources - Returns the DNS records specified by the referencing targetResourceIds.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-05-01
//   - parameters - Properties for dns resource reference request.
//   - options - ResourceReferenceClientGetByTargetResourcesOptions contains the optional parameters for the ResourceReferenceClient.GetByTargetResources
//     method.
func (client *ResourceReferenceClient) GetByTargetResources(ctx context.Context, parameters ResourceReferenceRequest, options *ResourceReferenceClientGetByTargetResourcesOptions) (ResourceReferenceClientGetByTargetResourcesResponse, error) {
	var err error
	const operationName = "ResourceReferenceClient.GetByTargetResources"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getByTargetResourcesCreateRequest(ctx, parameters, options)
	if err != nil {
		return ResourceReferenceClientGetByTargetResourcesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceReferenceClientGetByTargetResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceReferenceClientGetByTargetResourcesResponse{}, err
	}
	resp, err := client.getByTargetResourcesHandleResponse(httpResp)
	return resp, err
}

// getByTargetResourcesCreateRequest creates the GetByTargetResources request.
func (client *ResourceReferenceClient) getByTargetResourcesCreateRequest(ctx context.Context, parameters ResourceReferenceRequest, options *ResourceReferenceClientGetByTargetResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Network/getDnsResourceReference"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// getByTargetResourcesHandleResponse handles the GetByTargetResources response.
func (client *ResourceReferenceClient) getByTargetResourcesHandleResponse(resp *http.Response) (ResourceReferenceClientGetByTargetResourcesResponse, error) {
	result := ResourceReferenceClientGetByTargetResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceReferenceResult); err != nil {
		return ResourceReferenceClientGetByTargetResourcesResponse{}, err
	}
	return result, nil
}
