#ifndef SBK_KACTIONCATEGORYWRAPPER_H
#define SBK_KACTIONCATEGORYWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kactioncategory.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KActionCategoryWrapper : public KActionCategory
{
public:
    KActionCategoryWrapper(const ::QString & text, ::KActionCollection * parent = nullptr);
    KActionCategoryWrapper(const KActionCategoryWrapper &) = delete;
    KActionCategoryWrapper& operator=(const KActionCategoryWrapper &) = delete;
    KActionCategoryWrapper(KActionCategoryWrapper &&) = delete;
    KActionCategoryWrapper& operator=(KActionCategoryWrapper &&) = delete;
    ~KActionCategoryWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KACTIONCATEGORYWRAPPER_H
