
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kshortcutwidget_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <QList>
#include <kactioncollection.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qkeysequence.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KShortcutWidget_Type = nullptr;
static PyTypeObject *Sbk_KShortcutWidget_TypeF(void)
{
    return _Sbk_KShortcutWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KShortcutWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KShortcutWidgetWrapper::KShortcutWidgetWrapper(::QWidget * parent) : KShortcutWidget(parent)
{
}

void KShortcutWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KToolBarWrapper::sbk_o_closeEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KShortcutWidget", funcName, gil, pyOverride, signal);
}

void KShortcutWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

int KShortcutWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KShortcutWidget", funcName, gil, pyOverride);
}

void KShortcutWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KShortcutWidget", funcName, gil, pyOverride, signal);
}

void KShortcutWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

bool KShortcutWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KShortcutWidget", funcName, gil, pyOverride, event);
}

bool KShortcutWidgetWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KShortcutWidget", funcName, gil, pyOverride, watched, event);
}

void KShortcutWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

bool KShortcutWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KShortcutWidget", funcName, gil, pyOverride, next);
}

void KShortcutWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

bool KShortcutWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KShortcutWidget", funcName, gil, pyOverride);
}

int KShortcutWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KShortcutWidget", funcName, gil, pyOverride, arg__1);
}

void KShortcutWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KShortcutWidget", funcName, gil, pyOverride, painter);
}

void KShortcutWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

::QVariant KShortcutWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KShortcutWidget", funcName, gil, pyOverride, arg__1);
}

void KShortcutWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

int KShortcutWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KShortcutWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KShortcutWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KShortcutWidget", funcName, gil, pyOverride);
}

void KShortcutWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

bool KShortcutWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KShortcutWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KShortcutWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KShortcutWidget", funcName, gil, pyOverride);
}

void KShortcutWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * KShortcutWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KShortcutWidget", funcName, gil, pyOverride, offset);
}

void KShortcutWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KShortcutWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KShortcutWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KShortcutWidget", funcName, gil, pyOverride);
}

void KShortcutWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KToolBarWrapper::sbk_o_showEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

::QSize KShortcutWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KShortcutWidget", funcName, gil, pyOverride);
}

void KShortcutWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

void KShortcutWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KShortcutWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KShortcutWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KShortcutWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KShortcutWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KShortcutWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KShortcutWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KShortcutWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KShortcutWidgetWrapper *>(this));
    }
    return KShortcutWidget::qt_metacast(_clname);
}

KShortcutWidgetWrapper::~KShortcutWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KShortcutWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KShortcutWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KShortcutWidget >()))
        return -1;

    KShortcutWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KShortcutWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KShortcutWidget::KShortcutWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KShortcutWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KShortcutWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KShortcutWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KShortcutWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KShortcutWidgetWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KShortcutWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KShortcutWidgetFunc_applyStealShortcut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // applyStealShortcut()
        cppSelf->applyStealShortcut();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutWidgetFunc_clearShortcut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearShortcut()
        cppSelf->clearShortcut();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutWidgetFunc_isModifierlessAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isModifierlessAllowed()
        bool cppResult = cppSelf->isModifierlessAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KShortcutWidgetFunc_setCheckActionCollections(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutWidget::setCheckActionCollections(QList<KActionCollection*>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX], (pyArg)))) {
        overloadId = 0; // setCheckActionCollections(QList<KActionCollection*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCheckActionCollections", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);

    // Call function/method
    {
        ::QList<KActionCollection*> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCheckActionCollections(QList<KActionCollection*>)
            cppSelf->setCheckActionCollections(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutWidgetFunc_setClearButtonsShown(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutWidget::setClearButtonsShown(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setClearButtonsShown(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setClearButtonsShown", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setClearButtonsShown(bool)
            cppSelf->setClearButtonsShown(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutWidgetFunc_setModifierlessAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutWidget::setModifierlessAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setModifierlessAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModifierlessAllowed", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModifierlessAllowed(bool)
            cppSelf->setModifierlessAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutWidgetFunc_setShortcut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KShortcutWidget::setShortcut(QList<QKeySequence>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX], (pyArg)))) {
        overloadId = 0; // setShortcut(QList<QKeySequence>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShortcut", errInfo, SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);

    // Call function/method
    {
        ::QList<QKeySequence> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShortcut(QList<QKeySequence>)
            cppSelf->setShortcut(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KShortcutWidgetFunc_shortcut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // shortcut()const
        QList<QKeySequence> cppResult = const_cast<const ::KShortcutWidget *>(cppSelf)->shortcut();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KShortcutWidget_PropertyStrings[] = {
    "modifierlessAllowed:isModifierlessAllowed:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KShortcutWidget_methods[] = {
    {"applyStealShortcut", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_applyStealShortcut), METH_NOARGS, nullptr},
    {"clearShortcut", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_clearShortcut), METH_NOARGS, nullptr},
    {"isModifierlessAllowed", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_isModifierlessAllowed), METH_NOARGS, nullptr},
    {"setCheckActionCollections", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_setCheckActionCollections), METH_O, nullptr},
    {"setClearButtonsShown", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_setClearButtonsShown), METH_O, nullptr},
    {"setModifierlessAllowed", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_setModifierlessAllowed), METH_O, nullptr},
    {"setShortcut", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_setShortcut), METH_O, nullptr},
    {"shortcut", reinterpret_cast<PyCFunction>(Sbk_KShortcutWidgetFunc_shortcut), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KShortcutWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KShortcutWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KShortcutWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KShortcutWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KShortcutWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KShortcutWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KShortcutWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KShortcutWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KShortcutWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KShortcutWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KShortcutWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KShortcutWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KShortcutWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KShortcutWidget_spec = {
    "1:KXmlGui.KShortcutWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KShortcutWidget_slots
};

} //extern "C"

static void *Sbk_KShortcutWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KShortcutWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KShortcutWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KShortcutWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KShortcutWidget_PythonToCpp_KShortcutWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KShortcutWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KShortcutWidget_PythonToCpp_KShortcutWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KShortcutWidget_TypeF()))
        return KShortcutWidget_PythonToCpp_KShortcutWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KShortcutWidget_PTR_CppToPython_KShortcutWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KShortcutWidget *>(const_cast<void *>(cppIn)), Sbk_KShortcutWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KShortcutWidget_SignatureStrings[] = {
    "KXmlGui.KShortcutWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,modifierlessAllowed:bool=None)",
    "KXmlGui.KShortcutWidget.applyStealShortcut(self)",
    "KXmlGui.KShortcutWidget.clearShortcut(self)",
    "KXmlGui.KShortcutWidget.isModifierlessAllowed(self)->bool",
    "KXmlGui.KShortcutWidget.setCheckActionCollections(self,actionCollections:QList[KXmlGui.KActionCollection])",
    "KXmlGui.KShortcutWidget.setClearButtonsShown(self,show:bool)",
    "KXmlGui.KShortcutWidget.setModifierlessAllowed(self,allow:bool)",
    "KXmlGui.KShortcutWidget.setShortcut(self,cut:QList[PySide6.QtGui.QKeySequence])",
    "KXmlGui.KShortcutWidget.shortcut(self)->QList[PySide6.QtGui.QKeySequence]",
    nullptr}; // Sentinel
#else
static constexpr size_t KShortcutWidget_SignatureByteSize = 247;
static constexpr uint8_t KShortcutWidget_SignatureBytes[247] = {
    0x78, 0xda, 0x8d, 0x52, 0xb1, 0x6e, 0xc2, 0x30, 0x10, 0xdd, 0xf9, 0x92, 0x82, 0x4c, 0xc6, 0x0e,
    0x91, 0x40, 0xa2, 0x0c, 0x1d, 0x52, 0xa0, 0x51, 0x86, 0x56, 0xaa, 0x3a, 0x18, 0xfb, 0x28, 0x56,
    0x0f, 0x5f, 0x6a, 0x9f, 0x15, 0xe5, 0xef, 0xeb, 0x24, 0xb4, 0x15, 0xd0, 0x04, 0xb6, 0x67, 0x3f,
    0xbf, 0x7b, 0xf7, 0xee, 0x9c, 0xbd, 0x1e, 0xf0, 0x31, 0x98, 0x24, 0x2b, 0xf6, 0xe4, 0x58, 0x05,
    0x7e, 0x31, 0xfa, 0x03, 0xf8, 0xce, 0x03, 0xee, 0x44, 0x29, 0x1d, 0x58, 0x4e, 0x9f, 0xeb, 0xc2,
    0x68, 0xb8, 0x4f, 0xf2, 0x23, 0xe9, 0x93, 0xbc, 0x03, 0x33, 0x1b, 0x10, 0x4b, 0x76, 0x62, 0x92,
    0x66, 0x50, 0x57, 0xe4, 0xf4, 0xc6, 0x62, 0x3d, 0x5b, 0x93, 0x05, 0x71, 0x20, 0x6d, 0x76, 0x06,
    0x1c, 0x82, 0xf7, 0x0b, 0x44, 0xaa, 0x40, 0xa7, 0x5b, 0x22, 0x6c, 0xd9, 0xf1, 0x28, 0xfb, 0xdf,
    0x37, 0x91, 0x65, 0x89, 0x75, 0xc1, 0x20, 0xf1, 0x87, 0x68, 0x5b, 0xe9, 0x17, 0x28, 0x04, 0xe9,
    0x6e, 0x7c, 0x6b, 0xfc, 0xea, 0xb2, 0xab, 0x4e, 0x33, 0x9d, 0x37, 0xcd, 0xf5, 0x2a, 0x3d, 0xf0,
    0x72, 0x0f, 0xea, 0x73, 0xa1, 0xd8, 0x90, 0x5d, 0x12, 0x22, 0xb4, 0xc8, 0x77, 0x83, 0x92, 0xe7,
    0xd7, 0x69, 0xfe, 0x64, 0x3c, 0xbf, 0xfd, 0x96, 0x3b, 0xd7, 0xbd, 0x8f, 0x07, 0xad, 0x9a, 0x4c,
    0x0f, 0x81, 0x39, 0x56, 0x8a, 0x6c, 0x65, 0x3b, 0x17, 0x1f, 0x61, 0x3b, 0xc3, 0x41, 0x71, 0x5f,
    0x44, 0x21, 0x9b, 0xc3, 0x75, 0xfd, 0xc9, 0x2c, 0x45, 0x04, 0xc7, 0x2c, 0x7f, 0xbf, 0xa0, 0x11,
    0xe6, 0x71, 0xe1, 0x05, 0x7c, 0x05, 0xb0, 0x0a, 0x86, 0xc2, 0x9c, 0x2c, 0x66, 0x3a, 0xbf, 0x5a,
    0x6a, 0xf4, 0x0d, 0xa9, 0xb5, 0xf6, 0x0e
};
#endif

PyTypeObject *init_KShortcutWidget(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KShortcutWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KShortcutWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KShortcutWidget",
        "KShortcutWidget*",
        &Sbk_KShortcutWidget_spec,
        &Shiboken::callCppDestructor< KShortcutWidget >,
        Sbk_KShortcutWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KShortcutWidget_TypeF(); // references _Sbk_KShortcutWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KShortcutWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KShortcutWidget_SignatureBytes, KShortcutWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KShortcutWidget_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KShortcutWidget_PythonToCpp_KShortcutWidget_PTR,
        is_KShortcutWidget_PythonToCpp_KShortcutWidget_PTR_Convertible,
        KShortcutWidget_PTR_CppToPython_KShortcutWidget);

    Shiboken::Conversions::registerConverterName(converter, "KShortcutWidget");
    Shiboken::Conversions::registerConverterName(converter, "KShortcutWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KShortcutWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KShortcutWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KShortcutWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KShortcutWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KShortcutWidget_TypeF(), &Sbk_KShortcutWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KShortcutWidget_TypeF(), &Sbk_KShortcutWidget_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KShortcutWidget::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KShortcutWidget::staticMetaObject, sizeof(KShortcutWidgetWrapper));

    return pyType;
}
