
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kactioncategory_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kactioncollection.h>
#include <qaction.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KActionCategory_Type = nullptr;
static PyTypeObject *Sbk_KActionCategory_TypeF(void)
{
    return _Sbk_KActionCategory_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KActionCategoryWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KActionCategoryWrapper::KActionCategoryWrapper(const ::QString & text, ::KActionCollection * parent) : KActionCategory(text, parent)
{
}

void KActionCategoryWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KActionCategory", funcName, gil, pyOverride, event);
}

void KActionCategoryWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KActionCategory", funcName, gil, pyOverride, signal);
}

void KActionCategoryWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KActionCategory", funcName, gil, pyOverride, event);
}

void KActionCategoryWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KActionCategory", funcName, gil, pyOverride, signal);
}

bool KActionCategoryWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KActionCategory", funcName, gil, pyOverride, event);
}

bool KActionCategoryWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KActionCategory", funcName, gil, pyOverride, watched, event);
}

void KActionCategoryWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCategory_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KActionCategory", funcName, gil, pyOverride, event);
}

const QMetaObject *KActionCategoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KActionCategory::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KActionCategoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KActionCategory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KActionCategoryWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KActionCategoryWrapper *>(this));
    }
    return KActionCategory::qt_metacast(_clname);
}

KActionCategoryWrapper::~KActionCategoryWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KActionCategory_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KActionCategory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KActionCategory >()))
        return -1;

    KActionCategoryWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KActionCategory", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KActionCategory::KActionCategory(QString,KActionCollection*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KActionCategory(QString,KActionCollection*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), (pyArgs[1])))) {
            overloadId = 0; // KActionCategory(QString,KActionCollection*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::KActionCollection *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KActionCategory(QString,KActionCollection*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KActionCategoryWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KActionCategoryWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KActionCategory >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KActionCategoryFunc_actions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actions()const
        const QList<QAction*> cppResult = const_cast<const ::KActionCategory *>(cppSelf)->actions();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCategoryFunc_addAction(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:addAction", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionCategory::addAction(QString,QAction*)->QAction*
    // 1: KActionCategory::addAction(QString,const QObject*=,const char*=)->QAction*
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // addAction(QString,const QObject*,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addAction(QString,QAction*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // addAction(QString,const QObject*,const char*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
                overloadId = 1; // addAction(QString,const QObject*,const char*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addAction(const QString &name, QAction *action)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QAction *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QString,QAction*)
                QAction * cppResult = cppSelf->addAction(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
        case 1: // addAction(const QString &name, const QObject *receiver, const char *member)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"receiver", 1}, {"member", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            const char* cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QString,const QObject*,const char*)
                QAction * cppResult = cppSelf->addAction(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCategoryFunc_collection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // collection()const
        KActionCollection * cppResult = const_cast<const ::KActionCategory *>(cppSelf)->collection();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCategoryFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCategory::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCategoryFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KActionCategory *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KActionCategory_PropertyStrings[] = {
    "text::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KActionCategory_methods[] = {
    {"actions", reinterpret_cast<PyCFunction>(Sbk_KActionCategoryFunc_actions), METH_NOARGS, nullptr},
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KActionCategoryFunc_addAction), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"collection", reinterpret_cast<PyCFunction>(Sbk_KActionCategoryFunc_collection), METH_NOARGS, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KActionCategoryFunc_setText), METH_O, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KActionCategoryFunc_text), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KActionCategory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KActionCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KActionCategoryWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KActionCategory_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KActionCategory_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KActionCategory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KActionCategory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KActionCategory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KActionCategory_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KActionCategory_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KActionCategory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KActionCategory_spec = {
    "1:KXmlGui.KActionCategory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KActionCategory_slots
};

} //extern "C"

static void *Sbk_KActionCategory_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KActionCategory *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KActionCategory_PythonToCpp_KActionCategory_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KActionCategory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KActionCategory_PythonToCpp_KActionCategory_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KActionCategory_TypeF()))
        return KActionCategory_PythonToCpp_KActionCategory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KActionCategory_PTR_CppToPython_KActionCategory(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KActionCategory *>(const_cast<void *>(cppIn)), Sbk_KActionCategory_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KActionCategory_SignatureStrings[] = {
    "KXmlGui.KActionCategory(self,text:QString,parent:KXmlGui.KActionCollection=nullptr,*:KeywordOnly=None,text:QString=None)",
    "KXmlGui.KActionCategory.actions(self)->QList[PySide6.QtGui.QAction]",
    "1:KXmlGui.KActionCategory.addAction(self,name:QString,action:PySide6.QtGui.QAction)->PySide6.QtGui.QAction",
    "0:KXmlGui.KActionCategory.addAction(self,name:QString,receiver:PySide6.QtCore.QObject=nullptr,member:char*=nullptr)->PySide6.QtGui.QAction",
    "KXmlGui.KActionCategory.collection(self)->KXmlGui.KActionCollection",
    "KXmlGui.KActionCategory.setText(self,text:QString)",
    "KXmlGui.KActionCategory.text(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KActionCategory_SignatureByteSize = 226;
static constexpr uint8_t KActionCategory_SignatureBytes[226] = {
    0x78, 0xda, 0x9d, 0x51, 0xcb, 0x0a, 0xc2, 0x30, 0x10, 0xbc, 0xf7, 0x4b, 0x54, 0x6a, 0xd1, 0x8b,
    0x87, 0x80, 0x82, 0x78, 0xf0, 0x10, 0x51, 0x83, 0x1e, 0x04, 0xf1, 0x10, 0xdb, 0x55, 0x23, 0x69,
    0x22, 0xdb, 0xf5, 0xd1, 0xbf, 0xb7, 0x36, 0xb4, 0xf8, 0x68, 0x2e, 0xde, 0x92, 0x61, 0x67, 0x66,
    0x77, 0x86, 0x6f, 0x52, 0x3d, 0xbd, 0xaa, 0x88, 0x8f, 0x63, 0x52, 0xd6, 0x4c, 0x24, 0xc1, 0xd1,
    0x62, 0xde, 0xca, 0x40, 0x1f, 0x42, 0x82, 0x07, 0x31, 0xb1, 0x22, 0x54, 0xe6, 0x18, 0x5e, 0x24,
    0x82, 0x21, 0xc6, 0xbf, 0x08, 0x56, 0x6b, 0x28, 0x5f, 0x43, 0x73, 0xd5, 0xfa, 0x42, 0x18, 0x76,
    0x18, 0x87, 0xfc, 0x6e, 0x31, 0x59, 0x18, 0x9d, 0x0f, 0xe7, 0xd6, 0xc0, 0x87, 0x50, 0x89, 0xb4,
    0x03, 0xde, 0x6c, 0x1c, 0xc9, 0xf2, 0x9b, 0x95, 0x0b, 0xb4, 0xbb, 0x23, 0x31, 0x53, 0x19, 0x6d,
    0x97, 0xf9, 0x4a, 0x25, 0x30, 0x88, 0x04, 0xbd, 0x28, 0xc2, 0x51, 0x76, 0x41, 0x9f, 0x79, 0x55,
    0x92, 0xc4, 0x21, 0xee, 0x10, 0x23, 0x53, 0xa8, 0x0f, 0x71, 0x0e, 0xac, 0x51, 0xb3, 0x70, 0x6c,
    0xc4, 0x83, 0xde, 0x5f, 0x56, 0x08, 0x31, 0xa8, 0x1b, 0xe0, 0x9b, 0xd9, 0xc4, 0x22, 0x44, 0x62,
    0xb1, 0x3f, 0x17, 0xa9, 0xd5, 0x91, 0xa5, 0x90, 0xee, 0x8b, 0xa9, 0xf8, 0x24, 0xb1, 0x53, 0x81,
    0xde, 0x55, 0x7c, 0x8b, 0xc4, 0x75, 0x15, 0x55, 0x78, 0xde, 0xae, 0xbc, 0x1a, 0x19, 0xd0, 0xba,
    0xe8, 0xea, 0xb7, 0x7e, 0x7f, 0x61, 0x54, 0xcd, 0xbf, 0xda, 0x72, 0xc3, 0xc1, 0x13, 0x3d, 0x27,
    0xd9, 0x75
};
#endif

PyTypeObject *init_KActionCategory(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX].type;

    Shiboken::AutoDecRef Sbk_KActionCategory_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KActionCategory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KActionCategory",
        "KActionCategory*",
        &Sbk_KActionCategory_spec,
        &Shiboken::callCppDestructor< KActionCategory >,
        Sbk_KActionCategory_Type_bases.object(),
        0);
    auto *pyType = Sbk_KActionCategory_TypeF(); // references _Sbk_KActionCategory_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KActionCategory_SignatureStrings);
#else
    InitSignatureBytes(pyType, KActionCategory_SignatureBytes, KActionCategory_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KActionCategory_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KActionCategory_PythonToCpp_KActionCategory_PTR,
        is_KActionCategory_PythonToCpp_KActionCategory_PTR_Convertible,
        KActionCategory_PTR_CppToPython_KActionCategory);

    Shiboken::Conversions::registerConverterName(converter, "KActionCategory");
    Shiboken::Conversions::registerConverterName(converter, "KActionCategory*");
    Shiboken::Conversions::registerConverterName(converter, "KActionCategory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KActionCategory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KActionCategoryWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KActionCategory_TypeF(), &Sbk_KActionCategory_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KActionCategory::staticMetaObject, sizeof(KActionCategoryWrapper));

    return pyType;
}
