// This file is generated by kconfig_compiler_kf5 from ktikz.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

#include <QFontDatabase>

class Settings : public KConfigSkeleton
{
  public:
    class EnumCustomize
    {
      public:
      enum type { Standard, Custom, COUNT };
    };

    static Settings *self();
    ~Settings() override;

    /**
      Set Whether the TikZ commands should be listed in a dock widget instead of in a menu.
    */
    static
    void setCommandsInDock( bool v )
    {
      if (!self()->isCommandsInDockImmutable())
        self()->mCommandsInDock = v;
    }

    /**
      Get Whether the TikZ commands should be listed in a dock widget instead of in a menu.
    */
    static
    bool commandsInDock()
    {
      return self()->mCommandsInDock;
    }

    /**
      Is Whether the TikZ commands should be listed in a dock widget instead of in a menu. Immutable
    */
    static
    bool isCommandsInDockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "CommandsInDock" ) );
    }

    /**
      Set Whether the preview is generated automatically while editing instead of only when pressing a button.
    */
    static
    void setBuildAutomatically( bool v )
    {
      if (!self()->isBuildAutomaticallyImmutable())
        self()->mBuildAutomatically = v;
    }

    /**
      Get Whether the preview is generated automatically while editing instead of only when pressing a button.
    */
    static
    bool buildAutomatically()
    {
      return self()->mBuildAutomatically;
    }

    /**
      Is Whether the preview is generated automatically while editing instead of only when pressing a button. Immutable
    */
    static
    bool isBuildAutomaticallyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "BuildAutomatically" ) );
    }

    /**
      Set Whether to reload the TikZ image each time that the file is modified by another program.
    */
    static
    void setWatchFile( bool v )
    {
      if (!self()->isWatchFileImmutable())
        self()->mWatchFile = v;
    }

    /**
      Get Whether to reload the TikZ image each time that the file is modified by another program.
    */
    static
    bool watchFile()
    {
      return self()->mWatchFile;
    }

    /**
      Is Whether to reload the TikZ image each time that the file is modified by another program. Immutable
    */
    static
    bool isWatchFileImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WatchFile" ) );
    }

    /**
      Set The path to the pdflatex command.
    */
    static
    void setLatexCommand( const QString & v )
    {
      if (!self()->isLatexCommandImmutable())
        self()->mLatexCommand = v;
    }

    /**
      Get The path to the pdflatex command.
    */
    static
    QString latexCommand()
    {
      return self()->mLatexCommand;
    }

    /**
      Is The path to the pdflatex command. Immutable
    */
    static
    bool isLatexCommandImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LatexCommand" ) );
    }

    /**
      Set The path to the pdftops command.
    */
    static
    void setPdftopsCommand( const QString & v )
    {
      if (!self()->isPdftopsCommandImmutable())
        self()->mPdftopsCommand = v;
    }

    /**
      Get The path to the pdftops command.
    */
    static
    QString pdftopsCommand()
    {
      return self()->mPdftopsCommand;
    }

    /**
      Is The path to the pdftops command. Immutable
    */
    static
    bool isPdftopsCommandImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PdftopsCommand" ) );
    }

    /**
      Set The path to the TikZ documentation file.
    */
    static
    void setTikzDocumentation( const QString & v )
    {
      if (!self()->isTikzDocumentationImmutable())
        self()->mTikzDocumentation = v;
    }

    /**
      Get The path to the TikZ documentation file.
    */
    static
    QString tikzDocumentation()
    {
      return self()->mTikzDocumentation;
    }

    /**
      Is The path to the TikZ documentation file. Immutable
    */
    static
    bool isTikzDocumentationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TikzDocumentation" ) );
    }

    /**
      Set Whether to run pdflatex with the --shell-escape option.
    */
    static
    void setUseShellEscaping( bool v )
    {
      if (!self()->isUseShellEscapingImmutable())
        self()->mUseShellEscaping = v;
    }

    /**
      Get Whether to run pdflatex with the --shell-escape option.
    */
    static
    bool useShellEscaping()
    {
      return self()->mUseShellEscaping;
    }

    /**
      Is Whether to run pdflatex with the --shell-escape option. Immutable
    */
    static
    bool isUseShellEscapingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseShellEscaping" ) );
    }

    /**
      Set The file name of the currently used template.
    */
    static
    void setTemplateFile( const QString & v )
    {
      if (!self()->isTemplateFileImmutable())
        self()->mTemplateFile = v;
    }

    /**
      Get The file name of the currently used template.
    */
    static
    QString templateFile()
    {
      return self()->mTemplateFile;
    }

    /**
      Is The file name of the currently used template. Immutable
    */
    static
    bool isTemplateFileImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TemplateFile" ) );
    }

    /**
      Set The list of file names of the previously used templates.
    */
    static
    void setTemplateRecent( const QStringList & v )
    {
      if (!self()->isTemplateRecentImmutable())
        self()->mTemplateRecent = v;
    }

    /**
      Get The list of file names of the previously used templates.
    */
    static
    QStringList templateRecent()
    {
      return self()->mTemplateRecent;
    }

    /**
      Is The list of file names of the previously used templates. Immutable
    */
    static
    bool isTemplateRecentImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TemplateRecent" ) );
    }

    /**
      Set The text in the template file which is replaced by the TikZ code before typesetting.
    */
    static
    void setTemplateReplaceText( const QString & v )
    {
      if (!self()->isTemplateReplaceTextImmutable())
        self()->mTemplateReplaceText = v;
    }

    /**
      Get The text in the template file which is replaced by the TikZ code before typesetting.
    */
    static
    QString templateReplaceText()
    {
      return self()->mTemplateReplaceText;
    }

    /**
      Is The text in the template file which is replaced by the TikZ code before typesetting. Immutable
    */
    static
    bool isTemplateReplaceTextImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TemplateReplaceText" ) );
    }

    /**
      Set The path to the editor command used for editing templates.
    */
    static
    void setTemplateEditor( const QString & v )
    {
      if (!self()->isTemplateEditorImmutable())
        self()->mTemplateEditor = v;
    }

    /**
      Get The path to the editor command used for editing templates.
    */
    static
    QString templateEditor()
    {
      return self()->mTemplateEditor;
    }

    /**
      Is The path to the editor command used for editing templates. Immutable
    */
    static
    bool isTemplateEditorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TemplateEditor" ) );
    }

    /**
      Set The font of the main text in the editor.
    */
    static
    void setGeneralFont( const QFont & v )
    {
      if (!self()->isGeneralFontImmutable())
        self()->mGeneralFont = v;
    }

    /**
      Get The font of the main text in the editor.
    */
    static
    QFont generalFont()
    {
      return self()->mGeneralFont;
    }

    /**
      Is The font of the main text in the editor. Immutable
    */
    static
    bool isGeneralFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "GeneralFont" ) );
    }

    /**
      Set Whether to show white spaces.
    */
    static
    void setShowWhiteSpaces( bool v )
    {
      if (!self()->isShowWhiteSpacesImmutable())
        self()->mShowWhiteSpaces = v;
    }

    /**
      Get Whether to show white spaces.
    */
    static
    bool showWhiteSpaces()
    {
      return self()->mShowWhiteSpaces;
    }

    /**
      Is Whether to show white spaces. Immutable
    */
    static
    bool isShowWhiteSpacesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowWhiteSpaces" ) );
    }

    /**
      Set Whether to show tabulators.
    */
    static
    void setShowTabulators( bool v )
    {
      if (!self()->isShowTabulatorsImmutable())
        self()->mShowTabulators = v;
    }

    /**
      Get Whether to show tabulators.
    */
    static
    bool showTabulators()
    {
      return self()->mShowTabulators;
    }

    /**
      Is Whether to show tabulators. Immutable
    */
    static
    bool isShowTabulatorsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowTabulators" ) );
    }

    /**
      Set Whether to highlight matching brackets.
    */
    static
    void setShowMatchingBrackets( bool v )
    {
      if (!self()->isShowMatchingBracketsImmutable())
        self()->mShowMatchingBrackets = v;
    }

    /**
      Get Whether to highlight matching brackets.
    */
    static
    bool showMatchingBrackets()
    {
      return self()->mShowMatchingBrackets;
    }

    /**
      Is Whether to highlight matching brackets. Immutable
    */
    static
    bool isShowMatchingBracketsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowMatchingBrackets" ) );
    }

    /**
      Set The color used to highlight white spaces.
    */
    static
    void setColorWhiteSpaces( const QColor & v )
    {
      if (!self()->isColorWhiteSpacesImmutable())
        self()->mColorWhiteSpaces = v;
    }

    /**
      Get The color used to highlight white spaces.
    */
    static
    QColor colorWhiteSpaces()
    {
      return self()->mColorWhiteSpaces;
    }

    /**
      Is The color used to highlight white spaces. Immutable
    */
    static
    bool isColorWhiteSpacesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ColorWhiteSpaces" ) );
    }

    /**
      Set The color used to highlight tabulators.
    */
    static
    void setColorTabulators( const QColor & v )
    {
      if (!self()->isColorTabulatorsImmutable())
        self()->mColorTabulators = v;
    }

    /**
      Get The color used to highlight tabulators.
    */
    static
    QColor colorTabulators()
    {
      return self()->mColorTabulators;
    }

    /**
      Is The color used to highlight tabulators. Immutable
    */
    static
    bool isColorTabulatorsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ColorTabulators" ) );
    }

    /**
      Set The color used to highlight matching brackets.
    */
    static
    void setColorMatchingBrackets( const QColor & v )
    {
      if (!self()->isColorMatchingBracketsImmutable())
        self()->mColorMatchingBrackets = v;
    }

    /**
      Get The color used to highlight matching brackets.
    */
    static
    QColor colorMatchingBrackets()
    {
      return self()->mColorMatchingBrackets;
    }

    /**
      Is The color used to highlight matching brackets. Immutable
    */
    static
    bool isColorMatchingBracketsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ColorMatchingBrackets" ) );
    }

    /**
      Set Whether to use TikZ code completion.
    */
    static
    void setUseCompletion( bool v )
    {
      if (!self()->isUseCompletionImmutable())
        self()->mUseCompletion = v;
    }

    /**
      Get Whether to use TikZ code completion.
    */
    static
    bool useCompletion()
    {
      return self()->mUseCompletion;
    }

    /**
      Is Whether to use TikZ code completion. Immutable
    */
    static
    bool isUseCompletionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseCompletion" ) );
    }

    /**
      Set The type of syntax highlighting.
    */
    static
    void setCustomize( int v )
    {
      if (!self()->isCustomizeImmutable())
        self()->mCustomize = v;
    }

    /**
      Get The type of syntax highlighting.
    */
    static
    int customize()
    {
      return self()->mCustomize;
    }

    /**
      Is The type of syntax highlighting. Immutable
    */
    static
    bool isCustomizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Customize" ) );
    }

    /**
      Set The factor by which the preview is zoomed.
    */
    static
    void setZoomFactor( double v )
    {
      if (v < 0.1)
      {
        qDebug() << "setZoomFactor: value " << v << " is less than the minimum value of 0.1";
        v = 0.1;
      }

      if (v > 6.0)
      {
        qDebug() << "setZoomFactor: value " << v << " is greater than the maximum value of 6.0";
        v = 6.0;
      }

      if (!self()->isZoomFactorImmutable())
        self()->mZoomFactor = v;
    }

    /**
      Get The factor by which the preview is zoomed.
    */
    static
    double zoomFactor()
    {
      return self()->mZoomFactor;
    }

    /**
      Is The factor by which the preview is zoomed. Immutable
    */
    static
    bool isZoomFactorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ZoomFactor" ) );
    }

  protected:
    Settings();
    friend class SettingsHelper;


    // General Options
    bool mCommandsInDock;
    bool mBuildAutomatically;
    bool mWatchFile;
    QString mLatexCommand;
    QString mPdftopsCommand;
    QString mTikzDocumentation;
    bool mUseShellEscaping;
    QString mTemplateFile;
    QStringList mTemplateRecent;
    QString mTemplateReplaceText;
    QString mTemplateEditor;

    // Editor
    QFont mGeneralFont;
    bool mShowWhiteSpaces;
    bool mShowTabulators;
    bool mShowMatchingBrackets;
    QColor mColorWhiteSpaces;
    QColor mColorTabulators;
    QColor mColorMatchingBrackets;
    bool mUseCompletion;

    // Highlighting
    int mCustomize;

    // Preview
    double mZoomFactor;

  private:
};

#endif

