
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kgroupid_wrapper.h"

// Argument includes
#include <QString>
#include <kuser.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KGroupId_Type = nullptr;
static PyTypeObject *Sbk_KGroupId_TypeF(void)
{
    return _Sbk_KGroupId_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KGroupId_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KGroupId >()))
        return -1;

    ::KGroupId *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KGroupId", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KGroupId::KGroupId()
    // 1: KGroupId::KGroupId(KGroupId)
    // 2: KGroupId::KGroupId(uint)
    if (numArgs == 0) {
        overloadId = 0; // KGroupId()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 2; // KGroupId(uint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KGroupId(KGroupId)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KGroupId()
        {

            // KGroupId()
            cptr = new ::KGroupId();
            break;
        }
        case 1: // KGroupId(const KGroupId &KGroupId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KGroupId cppArg0_local;
            ::KGroupId *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KGroupId(KGroupId)
                cptr = new ::KGroupId(*cppArg0);
            }
            break;
        }
        case 2: // KGroupId(unsigned int gid)
        {
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KGroupId(uint)
                cptr = new ::KGroupId(cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KGroupId >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KGroupIdFunc_currentEffectiveGroupId(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentEffectiveGroupId()
        KGroupId cppResult = ::KGroupId::currentEffectiveGroupId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGroupIdFunc_currentGroupId(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentGroupId()
        KGroupId cppResult = ::KGroupId::currentGroupId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGroupIdFunc_fromName(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KGroupId::fromName(QString)->KGroupId
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // fromName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromName(QString)
            KGroupId cppResult = ::KGroupId::fromName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGroupId__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KGroupId *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KGroupId_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KGroupId_methods[] = {
    {"currentEffectiveGroupId", reinterpret_cast<PyCFunction>(Sbk_KGroupIdFunc_currentEffectiveGroupId), METH_NOARGS|METH_STATIC, nullptr},
    {"currentGroupId", reinterpret_cast<PyCFunction>(Sbk_KGroupIdFunc_currentGroupId), METH_NOARGS|METH_STATIC, nullptr},
    {"fromName", reinterpret_cast<PyCFunction>(Sbk_KGroupIdFunc_fromName), METH_O|METH_STATIC, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KGroupId__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static Py_hash_t Sbk_KGroupId_HashFunc(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGroupId *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(qHash(*cppSelf));
}

static int Sbk_KGroupId_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KGroupId_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KGroupId_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_KGroupId_HashFunc)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KGroupId_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KGroupId_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KGroupId_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KGroupId_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KGroupId_spec = {
    "1:KCoreAddons.KGroupId",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KGroupId_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KGroupId_PythonToCpp_KGroupId_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KGroupId_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KGroupId_PythonToCpp_KGroupId_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KGroupId_TypeF()))
        return KGroupId_PythonToCpp_KGroupId_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KGroupId_PTR_CppToPython_KGroupId(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KGroupId_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KGroupId_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KGroupId_COPY_CppToPython_KGroupId(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KGroupId *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KGroupId_TypeF(), new ::KGroupId(*source), true, true);
}

// Python to C++ copy conversion.
static void KGroupId_PythonToCpp_KGroupId_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KGroupId *>(cppOut) = *reinterpret_cast< ::KGroupId *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KGroupId_PythonToCpp_KGroupId_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KGroupId_TypeF()))
        return KGroupId_PythonToCpp_KGroupId_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGroupId_SignatureStrings[] = {
    "2:KCoreAddons.KGroupId(self)",
    "1:KCoreAddons.KGroupId(self,KGroupId:KCoreAddons.KGroupId)",
    "0:KCoreAddons.KGroupId(self,gid:unsigned int)",
    "KCoreAddons.KGroupId.currentEffectiveGroupId()->KCoreAddons.KGroupId",
    "KCoreAddons.KGroupId.currentGroupId()->KCoreAddons.KGroupId",
    "KCoreAddons.KGroupId.fromName(name:QString)->KCoreAddons.KGroupId",
    "KCoreAddons.KGroupId.__copy__(self)->typing._Self",
    "KCoreAddons.KGroupId.__hash__(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KGroupId_SignatureByteSize = 155;
static constexpr uint8_t KGroupId_SignatureBytes[155] = {
    0x78, 0xda, 0x33, 0xb2, 0xf2, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6,
    0xf3, 0x76, 0x2f, 0xca, 0x2f, 0x2d, 0xf0, 0x4c, 0xd1, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32,
    0xc4, 0x2d, 0xa9, 0x03, 0xe3, 0x61, 0x55, 0xa2, 0xc9, 0x65, 0x80, 0x47, 0x6b, 0x7a, 0x66, 0x8a,
    0x55, 0x69, 0x5e, 0x71, 0x66, 0x7a, 0x5e, 0x6a, 0x8a, 0x42, 0x66, 0x5e, 0x89, 0x26, 0x17, 0x36,
    0xb5, 0x7a, 0xc9, 0xa5, 0x45, 0x45, 0xa9, 0x79, 0x25, 0xae, 0x69, 0x69, 0xa9, 0xc9, 0x25, 0x99,
    0x65, 0xa9, 0x30, 0x33, 0x34, 0x75, 0xed, 0xb0, 0xa9, 0xc7, 0x6b, 0x08, 0x59, 0x7a, 0xd3, 0x8a,
    0xf2, 0x73, 0xfd, 0x12, 0x73, 0x53, 0x35, 0xf2, 0x80, 0x84, 0x55, 0x60, 0x70, 0x49, 0x51, 0x66,
    0x5e, 0x3a, 0x49, 0x26, 0xc4, 0xc7, 0x27, 0xe7, 0x17, 0x54, 0xc6, 0xc7, 0x43, 0xc2, 0x53, 0xd7,
    0xae, 0xa4, 0xb2, 0x00, 0x68, 0x84, 0x5e, 0x7c, 0x30, 0x90, 0x8b, 0x4b, 0x47, 0x46, 0x62, 0x71,
    0x06, 0x42, 0x07, 0x30, 0x78, 0xb8, 0x00, 0x29, 0xb7, 0x94, 0xed
};
#endif

PyTypeObject *init_KGroupId(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX].type;

    Shiboken::AutoDecRef Sbk_KGroupId_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KGroupId_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KGroupId",
        "KGroupId",
        &Sbk_KGroupId_spec,
        &Shiboken::callCppDestructor< ::KGroupId >,
        Sbk_KGroupId_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KGroupId_Type; // references _Sbk_KGroupId_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGroupId_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGroupId_SignatureBytes, KGroupId_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KGroupId_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KGroupId_PythonToCpp_KGroupId_PTR,
        is_KGroupId_PythonToCpp_KGroupId_PTR_Convertible,
        KGroupId_PTR_CppToPython_KGroupId,
        KGroupId_COPY_CppToPython_KGroupId);

    Shiboken::Conversions::registerConverterName(converter, "KGroupId");
    Shiboken::Conversions::registerConverterName(converter, "KGroupId*");
    Shiboken::Conversions::registerConverterName(converter, "KGroupId&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KGroupId).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KGroupId_PythonToCpp_KGroupId_COPY,
        is_KGroupId_PythonToCpp_KGroupId_COPY_Convertible);

    qRegisterMetaType< ::KGroupId >("KGroupId");

    return pyType;
}
