{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrColor@ structure is used to represent attributes that
-- are colors.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrColor
    ( 

-- * Exported types
    AttrColor(..)                           ,
    newZeroAttrColor                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrColorMethod                  ,
#endif



 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrColor_attr                          ,
#endif
    getAttrColorAttr                        ,


-- ** color #attr:color#
-- | the @PangoColor@ which is the value of the attribute

#if defined(ENABLE_OVERLOADING)
    attrColor_color                         ,
#endif
    getAttrColorColor                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color

#endif

-- | Memory-managed wrapper type.
newtype AttrColor = AttrColor (SP.ManagedPtr AttrColor)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrColor where
    toManagedPtr (AttrColor p) = p

instance BoxedPtr AttrColor where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrColor)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrColor where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrColor' struct initialized to zero.
newZeroAttrColor :: MonadIO m => m AttrColor
newZeroAttrColor = liftIO $ boxedPtrCalloc >>= wrapPtr AttrColor

instance tag ~ 'AttrSet => Constructible AttrColor tag where
    new _ attrs = do
        o <- newZeroAttrColor
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrColor #attr
-- @
getAttrColorAttr :: MonadIO m => AttrColor -> m Pango.Attribute.Attribute
getAttrColorAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrColorAttrFieldInfo
instance AttrInfo AttrColorAttrFieldInfo where
    type AttrBaseTypeConstraint AttrColorAttrFieldInfo = (~) AttrColor
    type AttrAllowedOps AttrColorAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrColorAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrColorAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrColorAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrColorAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrColorAttrFieldInfo = "attr"
    type AttrOrigin AttrColorAttrFieldInfo = AttrColor
    attrGet = getAttrColorAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrColor.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrColor.html#g:attr:attr"
        })

attrColor_attr :: AttrLabelProxy "attr"
attrColor_attr = AttrLabelProxy

#endif


-- | Get the value of the “@color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrColor #color
-- @
getAttrColorColor :: MonadIO m => AttrColor -> m Pango.Color.Color
getAttrColorColor s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 16 :: (Ptr Pango.Color.Color)
    val' <- (newBoxed Pango.Color.Color) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrColorColorFieldInfo
instance AttrInfo AttrColorColorFieldInfo where
    type AttrBaseTypeConstraint AttrColorColorFieldInfo = (~) AttrColor
    type AttrAllowedOps AttrColorColorFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrColorColorFieldInfo = (~) (Ptr Pango.Color.Color)
    type AttrTransferTypeConstraint AttrColorColorFieldInfo = (~)(Ptr Pango.Color.Color)
    type AttrTransferType AttrColorColorFieldInfo = (Ptr Pango.Color.Color)
    type AttrGetType AttrColorColorFieldInfo = Pango.Color.Color
    type AttrLabel AttrColorColorFieldInfo = "color"
    type AttrOrigin AttrColorColorFieldInfo = AttrColor
    attrGet = getAttrColorColor
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrColor.color"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrColor.html#g:attr:color"
        })

attrColor_color :: AttrLabelProxy "color"
attrColor_color = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrColor
type instance O.AttributeList AttrColor = AttrColorAttributeList
type AttrColorAttributeList = ('[ '("attr", AttrColorAttrFieldInfo), '("color", AttrColorColorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrColorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrColorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrColorMethod t AttrColor, O.OverloadedMethod info AttrColor p) => OL.IsLabel t (AttrColor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrColorMethod t AttrColor, O.OverloadedMethod info AttrColor p, R.HasField t AttrColor p) => R.HasField t AttrColor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrColorMethod t AttrColor, O.OverloadedMethodInfo info AttrColor) => OL.IsLabel t (O.MethodProxy info AttrColor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


