{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A sphere, represented by its center and radius.
-- 
-- /Since: 1.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Sphere
    ( 

-- * Exported types
    Sphere(..)                              ,
    newZeroSphere                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [containsPoint]("GI.Graphene.Structs.Sphere#g:method:containsPoint"), [distance]("GI.Graphene.Structs.Sphere#g:method:distance"), [equal]("GI.Graphene.Structs.Sphere#g:method:equal"), [free]("GI.Graphene.Structs.Sphere#g:method:free"), [init]("GI.Graphene.Structs.Sphere#g:method:init"), [initFromPoints]("GI.Graphene.Structs.Sphere#g:method:initFromPoints"), [initFromVectors]("GI.Graphene.Structs.Sphere#g:method:initFromVectors"), [isEmpty]("GI.Graphene.Structs.Sphere#g:method:isEmpty"), [translate]("GI.Graphene.Structs.Sphere#g:method:translate").
-- 
-- ==== Getters
-- [getBoundingBox]("GI.Graphene.Structs.Sphere#g:method:getBoundingBox"), [getCenter]("GI.Graphene.Structs.Sphere#g:method:getCenter"), [getRadius]("GI.Graphene.Structs.Sphere#g:method:getRadius").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSphereMethod                     ,
#endif

-- ** alloc #method:alloc#

    sphereAlloc                             ,


-- ** containsPoint #method:containsPoint#

#if defined(ENABLE_OVERLOADING)
    SphereContainsPointMethodInfo           ,
#endif
    sphereContainsPoint                     ,


-- ** distance #method:distance#

#if defined(ENABLE_OVERLOADING)
    SphereDistanceMethodInfo                ,
#endif
    sphereDistance                          ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    SphereEqualMethodInfo                   ,
#endif
    sphereEqual                             ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    SphereFreeMethodInfo                    ,
#endif
    sphereFree                              ,


-- ** getBoundingBox #method:getBoundingBox#

#if defined(ENABLE_OVERLOADING)
    SphereGetBoundingBoxMethodInfo          ,
#endif
    sphereGetBoundingBox                    ,


-- ** getCenter #method:getCenter#

#if defined(ENABLE_OVERLOADING)
    SphereGetCenterMethodInfo               ,
#endif
    sphereGetCenter                         ,


-- ** getRadius #method:getRadius#

#if defined(ENABLE_OVERLOADING)
    SphereGetRadiusMethodInfo               ,
#endif
    sphereGetRadius                         ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    SphereInitMethodInfo                    ,
#endif
    sphereInit                              ,


-- ** initFromPoints #method:initFromPoints#

#if defined(ENABLE_OVERLOADING)
    SphereInitFromPointsMethodInfo          ,
#endif
    sphereInitFromPoints                    ,


-- ** initFromVectors #method:initFromVectors#

#if defined(ENABLE_OVERLOADING)
    SphereInitFromVectorsMethodInfo         ,
#endif
    sphereInitFromVectors                   ,


-- ** isEmpty #method:isEmpty#

#if defined(ENABLE_OVERLOADING)
    SphereIsEmptyMethodInfo                 ,
#endif
    sphereIsEmpty                           ,


-- ** translate #method:translate#

#if defined(ENABLE_OVERLOADING)
    SphereTranslateMethodInfo               ,
#endif
    sphereTranslate                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3

#endif

-- | Memory-managed wrapper type.
newtype Sphere = Sphere (SP.ManagedPtr Sphere)
    deriving (Eq)

instance SP.ManagedPtrNewtype Sphere where
    toManagedPtr (Sphere p) = p

foreign import ccall "graphene_sphere_get_type" c_graphene_sphere_get_type :: 
    IO GType

type instance O.ParentTypes Sphere = '[]
instance O.HasParentTypes Sphere

instance B.Types.TypedObject Sphere where
    glibType = c_graphene_sphere_get_type

instance B.Types.GBoxed Sphere

-- | Convert t'Sphere' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Sphere) where
    gvalueGType_ = c_graphene_sphere_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Sphere)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Sphere)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Sphere ptr
        else return P.Nothing
        
    

-- | Construct a t'Sphere' struct initialized to zero.
newZeroSphere :: MonadIO m => m Sphere
newZeroSphere = liftIO $ callocBoxedBytes 20 >>= wrapBoxed Sphere

instance tag ~ 'AttrSet => Constructible Sphere tag where
    new _ attrs = do
        o <- newZeroSphere
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Sphere
type instance O.AttributeList Sphere = SphereAttributeList
type SphereAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Sphere::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Sphere" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_alloc" graphene_sphere_alloc :: 
    IO (Ptr Sphere)

-- | Allocates a new t'GI.Graphene.Structs.Sphere.Sphere'.
-- 
-- The contents of the newly allocated structure are undefined.
-- 
-- /Since: 1.2/
sphereAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Sphere
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Sphere.Sphere'. Use
    --   'GI.Graphene.Structs.Sphere.sphereFree' to free the resources allocated by this function
sphereAlloc  = liftIO $ do
    result <- graphene_sphere_alloc
    checkUnexpectedReturnNULL "sphereAlloc" result
    result' <- (wrapBoxed Sphere) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sphere::contains_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_contains_point" graphene_sphere_contains_point :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CInt

-- | Checks whether the given /@point@/ is contained in the volume
-- of a t'GI.Graphene.Structs.Sphere.Sphere'.
-- 
-- /Since: 1.2/
sphereContainsPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Bool
    -- ^ __Returns:__ @true@ if the sphere contains the point
sphereContainsPoint s point = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    point' <- unsafeManagedPtrGetPtr point
    result <- graphene_sphere_contains_point s' point'
    let result' = (/= 0) result
    touchManagedPtr s
    touchManagedPtr point
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereContainsPointMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m Bool), MonadIO m) => O.OverloadedMethod SphereContainsPointMethodInfo Sphere signature where
    overloadedMethod = sphereContainsPoint

instance O.OverloadedMethodInfo SphereContainsPointMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereContainsPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereContainsPoint"
        })


#endif

-- method Sphere::distance
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_distance" graphene_sphere_distance :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CFloat

-- | Computes the distance of the given /@point@/ from the surface of
-- a t'GI.Graphene.Structs.Sphere.Sphere'.
-- 
-- /Since: 1.2/
sphereDistance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Float
    -- ^ __Returns:__ the distance of the point
sphereDistance s point = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    point' <- unsafeManagedPtrGetPtr point
    result <- graphene_sphere_distance s' point'
    let result' = realToFrac result
    touchManagedPtr s
    touchManagedPtr point
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereDistanceMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m Float), MonadIO m) => O.OverloadedMethod SphereDistanceMethodInfo Sphere signature where
    overloadedMethod = sphereDistance

instance O.OverloadedMethodInfo SphereDistanceMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereDistance",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereDistance"
        })


#endif

-- method Sphere::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_equal" graphene_sphere_equal :: 
    Ptr Sphere ->                           -- a : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Sphere ->                           -- b : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO CInt

-- | Checks whether two t'GI.Graphene.Structs.Sphere.Sphere' are equal.
-- 
-- /Since: 1.2/
sphereEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@a@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> Sphere
    -- ^ /@b@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m Bool
    -- ^ __Returns:__ @true@ if the spheres are equal
sphereEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_sphere_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereEqualMethodInfo
instance (signature ~ (Sphere -> m Bool), MonadIO m) => O.OverloadedMethod SphereEqualMethodInfo Sphere signature where
    overloadedMethod = sphereEqual

instance O.OverloadedMethodInfo SphereEqualMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereEqual"
        })


#endif

-- method Sphere::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_free" graphene_sphere_free :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Sphere.sphereAlloc'.
-- 
-- /Since: 1.2/
sphereFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m ()
sphereFree s = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    graphene_sphere_free s'
    touchManagedPtr s
    return ()

#if defined(ENABLE_OVERLOADING)
data SphereFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SphereFreeMethodInfo Sphere signature where
    overloadedMethod = sphereFree

instance O.OverloadedMethodInfo SphereFreeMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereFree"
        })


#endif

-- method Sphere::get_bounding_box
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the bounding box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_get_bounding_box" graphene_sphere_get_bounding_box :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Graphene.Box.Box ->                 -- box : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Computes the bounding box capable of containing the
-- given t'GI.Graphene.Structs.Sphere.Sphere'.
-- 
-- /Since: 1.2/
sphereGetBoundingBox ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m (Graphene.Box.Box)
sphereGetBoundingBox s = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    box <- SP.callocBoxedBytes 32 :: IO (Ptr Graphene.Box.Box)
    graphene_sphere_get_bounding_box s' box
    box' <- (wrapBoxed Graphene.Box.Box) box
    touchManagedPtr s
    return box'

#if defined(ENABLE_OVERLOADING)
data SphereGetBoundingBoxMethodInfo
instance (signature ~ (m (Graphene.Box.Box)), MonadIO m) => O.OverloadedMethod SphereGetBoundingBoxMethodInfo Sphere signature where
    overloadedMethod = sphereGetBoundingBox

instance O.OverloadedMethodInfo SphereGetBoundingBoxMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereGetBoundingBox",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereGetBoundingBox"
        })


#endif

-- method Sphere::get_center
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the coordinates of\n  the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_get_center" graphene_sphere_get_center :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Graphene.Point3D.Point3D ->         -- center : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the coordinates of the center of a t'GI.Graphene.Structs.Sphere.Sphere'.
-- 
-- /Since: 1.2/
sphereGetCenter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m (Graphene.Point3D.Point3D)
sphereGetCenter s = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    center <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_sphere_get_center s' center
    center' <- (wrapBoxed Graphene.Point3D.Point3D) center
    touchManagedPtr s
    return center'

#if defined(ENABLE_OVERLOADING)
data SphereGetCenterMethodInfo
instance (signature ~ (m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod SphereGetCenterMethodInfo Sphere signature where
    overloadedMethod = sphereGetCenter

instance O.OverloadedMethodInfo SphereGetCenterMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereGetCenter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereGetCenter"
        })


#endif

-- method Sphere::get_radius
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_get_radius" graphene_sphere_get_radius :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO CFloat

-- | Retrieves the radius of a t'GI.Graphene.Structs.Sphere.Sphere'.
-- 
-- /Since: 1.2/
sphereGetRadius ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m Float
sphereGetRadius s = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    result <- graphene_sphere_get_radius s'
    let result' = realToFrac result
    touchManagedPtr s
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereGetRadiusMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod SphereGetRadiusMethodInfo Sphere signature where
    overloadedMethod = sphereGetRadius

instance O.OverloadedMethodInfo SphereGetRadiusMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereGetRadius",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereGetRadius"
        })


#endif

-- method Sphere::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_sphere_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the coordinates of the center of the sphere, or %NULL\n  for a center in (0, 0, 0)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "radius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the radius of the sphere"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Sphere" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_init" graphene_sphere_init :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Graphene.Point3D.Point3D ->         -- center : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    CFloat ->                               -- radius : TBasicType TFloat
    IO (Ptr Sphere)

-- | Initializes the given t'GI.Graphene.Structs.Sphere.Sphere' with the given /@center@/ and /@radius@/.
-- 
-- /Since: 1.2/
sphereInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: the t'GI.Graphene.Structs.Sphere.Sphere' to initialize
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@center@/: the coordinates of the center of the sphere, or 'P.Nothing'
    --   for a center in (0, 0, 0)
    -> Float
    -- ^ /@radius@/: the radius of the sphere
    -> m Sphere
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Sphere.Sphere'
sphereInit s center radius = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    maybeCenter <- case center of
        Nothing -> return FP.nullPtr
        Just jCenter -> do
            jCenter' <- unsafeManagedPtrGetPtr jCenter
            return jCenter'
    let radius' = realToFrac radius
    result <- graphene_sphere_init s' maybeCenter radius'
    checkUnexpectedReturnNULL "sphereInit" result
    result' <- (newBoxed Sphere) result
    touchManagedPtr s
    whenJust center touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereInitMethodInfo
instance (signature ~ (Maybe (Graphene.Point3D.Point3D) -> Float -> m Sphere), MonadIO m) => O.OverloadedMethod SphereInitMethodInfo Sphere signature where
    overloadedMethod = sphereInit

instance O.OverloadedMethodInfo SphereInitMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereInit"
        })


#endif

-- method Sphere::init_from_points
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_sphere_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_points"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of #graphene_point3d_t in the @points array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "points"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Graphene" , name = "Point3D" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the center of the sphere"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_points"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of #graphene_point3d_t in the @points array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Sphere" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_init_from_points" graphene_sphere_init_from_points :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Word32 ->                               -- n_points : TBasicType TUInt
    Ptr Graphene.Point3D.Point3D ->         -- points : TCArray False (-1) 1 (TInterface (Name {namespace = "Graphene", name = "Point3D"}))
    Ptr Graphene.Point3D.Point3D ->         -- center : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Sphere)

-- | Initializes the given t'GI.Graphene.Structs.Sphere.Sphere' using the given array
-- of 3D coordinates so that the sphere includes them.
-- 
-- The center of the sphere can either be specified, or will be center
-- of the 3D volume that encompasses all /@points@/.
-- 
-- /Since: 1.2/
sphereInitFromPoints ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: the t'GI.Graphene.Structs.Sphere.Sphere' to initialize
    -> [Graphene.Point3D.Point3D]
    -- ^ /@points@/: an array of t'GI.Graphene.Structs.Point3D.Point3D'
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@center@/: the center of the sphere
    -> m Sphere
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Sphere.Sphere'
sphereInitFromPoints s points center = liftIO $ do
    let nPoints = fromIntegral $ P.length points
    s' <- unsafeManagedPtrGetPtr s
    points' <- mapM unsafeManagedPtrGetPtr points
    points'' <- packBlockArray 12 points'
    maybeCenter <- case center of
        Nothing -> return FP.nullPtr
        Just jCenter -> do
            jCenter' <- unsafeManagedPtrGetPtr jCenter
            return jCenter'
    result <- graphene_sphere_init_from_points s' nPoints points'' maybeCenter
    checkUnexpectedReturnNULL "sphereInitFromPoints" result
    result' <- (newBoxed Sphere) result
    touchManagedPtr s
    mapM_ touchManagedPtr points
    whenJust center touchManagedPtr
    freeMem points''
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereInitFromPointsMethodInfo
instance (signature ~ ([Graphene.Point3D.Point3D] -> Maybe (Graphene.Point3D.Point3D) -> m Sphere), MonadIO m) => O.OverloadedMethod SphereInitFromPointsMethodInfo Sphere signature where
    overloadedMethod = sphereInitFromPoints

instance O.OverloadedMethodInfo SphereInitFromPointsMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereInitFromPoints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereInitFromPoints"
        })


#endif

-- method Sphere::init_from_vectors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_sphere_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_vectors"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of #graphene_vec3_t in the @vectors array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vectors"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Graphene" , name = "Vec3" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of #graphene_vec3_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the center of the sphere"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_vectors"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of #graphene_vec3_t in the @vectors array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Sphere" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_init_from_vectors" graphene_sphere_init_from_vectors :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Word32 ->                               -- n_vectors : TBasicType TUInt
    Ptr Graphene.Vec3.Vec3 ->               -- vectors : TCArray False (-1) 1 (TInterface (Name {namespace = "Graphene", name = "Vec3"}))
    Ptr Graphene.Point3D.Point3D ->         -- center : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Sphere)

-- | Initializes the given t'GI.Graphene.Structs.Sphere.Sphere' using the given array
-- of 3D coordinates so that the sphere includes them.
-- 
-- The center of the sphere can either be specified, or will be center
-- of the 3D volume that encompasses all /@vectors@/.
-- 
-- /Since: 1.2/
sphereInitFromVectors ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: the t'GI.Graphene.Structs.Sphere.Sphere' to initialize
    -> [Graphene.Vec3.Vec3]
    -- ^ /@vectors@/: an array of t'GI.Graphene.Structs.Vec3.Vec3'
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@center@/: the center of the sphere
    -> m Sphere
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Sphere.Sphere'
sphereInitFromVectors s vectors center = liftIO $ do
    let nVectors = fromIntegral $ P.length vectors
    s' <- unsafeManagedPtrGetPtr s
    vectors' <- mapM unsafeManagedPtrGetPtr vectors
    vectors'' <- packBlockArray 16 vectors'
    maybeCenter <- case center of
        Nothing -> return FP.nullPtr
        Just jCenter -> do
            jCenter' <- unsafeManagedPtrGetPtr jCenter
            return jCenter'
    result <- graphene_sphere_init_from_vectors s' nVectors vectors'' maybeCenter
    checkUnexpectedReturnNULL "sphereInitFromVectors" result
    result' <- (newBoxed Sphere) result
    touchManagedPtr s
    mapM_ touchManagedPtr vectors
    whenJust center touchManagedPtr
    freeMem vectors''
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereInitFromVectorsMethodInfo
instance (signature ~ ([Graphene.Vec3.Vec3] -> Maybe (Graphene.Point3D.Point3D) -> m Sphere), MonadIO m) => O.OverloadedMethod SphereInitFromVectorsMethodInfo Sphere signature where
    overloadedMethod = sphereInitFromVectors

instance O.OverloadedMethodInfo SphereInitFromVectorsMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereInitFromVectors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereInitFromVectors"
        })


#endif

-- method Sphere::is_empty
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_is_empty" graphene_sphere_is_empty :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO CInt

-- | Checks whether the sphere has a zero radius.
-- 
-- /Since: 1.2/
sphereIsEmpty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> m Bool
    -- ^ __Returns:__ @true@ if the sphere is empty
sphereIsEmpty s = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    result <- graphene_sphere_is_empty s'
    let result' = (/= 0) result
    touchManagedPtr s
    return result'

#if defined(ENABLE_OVERLOADING)
data SphereIsEmptyMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod SphereIsEmptyMethodInfo Sphere signature where
    overloadedMethod = sphereIsEmpty

instance O.OverloadedMethodInfo SphereIsEmptyMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereIsEmpty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereIsEmpty"
        })


#endif

-- method Sphere::translate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "s"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_sphere_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "point"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the coordinates of the translation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Sphere" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the translated sphere"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_sphere_translate" graphene_sphere_translate :: 
    Ptr Sphere ->                           -- s : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    Ptr Graphene.Point3D.Point3D ->         -- point : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Sphere ->                           -- res : TInterface (Name {namespace = "Graphene", name = "Sphere"})
    IO ()

-- | Translates the center of the given t'GI.Graphene.Structs.Sphere.Sphere' using the /@point@/
-- coordinates as the delta of the translation.
-- 
-- /Since: 1.2/
sphereTranslate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sphere
    -- ^ /@s@/: a t'GI.Graphene.Structs.Sphere.Sphere'
    -> Graphene.Point3D.Point3D
    -- ^ /@point@/: the coordinates of the translation
    -> m (Sphere)
sphereTranslate s point = liftIO $ do
    s' <- unsafeManagedPtrGetPtr s
    point' <- unsafeManagedPtrGetPtr point
    res <- SP.callocBoxedBytes 20 :: IO (Ptr Sphere)
    graphene_sphere_translate s' point' res
    res' <- (wrapBoxed Sphere) res
    touchManagedPtr s
    touchManagedPtr point
    return res'

#if defined(ENABLE_OVERLOADING)
data SphereTranslateMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m (Sphere)), MonadIO m) => O.OverloadedMethod SphereTranslateMethodInfo Sphere signature where
    overloadedMethod = sphereTranslate

instance O.OverloadedMethodInfo SphereTranslateMethodInfo Sphere where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Sphere.sphereTranslate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Sphere.html#v:sphereTranslate"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSphereMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSphereMethod "containsPoint" o = SphereContainsPointMethodInfo
    ResolveSphereMethod "distance" o = SphereDistanceMethodInfo
    ResolveSphereMethod "equal" o = SphereEqualMethodInfo
    ResolveSphereMethod "free" o = SphereFreeMethodInfo
    ResolveSphereMethod "init" o = SphereInitMethodInfo
    ResolveSphereMethod "initFromPoints" o = SphereInitFromPointsMethodInfo
    ResolveSphereMethod "initFromVectors" o = SphereInitFromVectorsMethodInfo
    ResolveSphereMethod "isEmpty" o = SphereIsEmptyMethodInfo
    ResolveSphereMethod "translate" o = SphereTranslateMethodInfo
    ResolveSphereMethod "getBoundingBox" o = SphereGetBoundingBoxMethodInfo
    ResolveSphereMethod "getCenter" o = SphereGetCenterMethodInfo
    ResolveSphereMethod "getRadius" o = SphereGetRadiusMethodInfo
    ResolveSphereMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSphereMethod t Sphere, O.OverloadedMethod info Sphere p) => OL.IsLabel t (Sphere -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSphereMethod t Sphere, O.OverloadedMethod info Sphere p, R.HasField t Sphere p) => R.HasField t Sphere p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSphereMethod t Sphere, O.OverloadedMethodInfo info Sphere) => OL.IsLabel t (O.MethodProxy info Sphere) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


