{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure that provides information to the type system which is
-- used specifically for managing interface types.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.InterfaceInfo
    ( 

-- * Exported types
    InterfaceInfo(..)                       ,
    newZeroInterfaceInfo                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveInterfaceInfoMethod              ,
#endif



 -- * Properties


-- ** interfaceData #attr:interfaceData#
-- | user-supplied data passed to the interface init\/finalize functions

    clearInterfaceInfoInterfaceData         ,
    getInterfaceInfoInterfaceData           ,
#if defined(ENABLE_OVERLOADING)
    interfaceInfo_interfaceData             ,
#endif
    setInterfaceInfoInterfaceData           ,


-- ** interfaceFinalize #attr:interfaceFinalize#
-- | location of the interface finalization function

    clearInterfaceInfoInterfaceFinalize     ,
    getInterfaceInfoInterfaceFinalize       ,
#if defined(ENABLE_OVERLOADING)
    interfaceInfo_interfaceFinalize         ,
#endif
    setInterfaceInfoInterfaceFinalize       ,


-- ** interfaceInit #attr:interfaceInit#
-- | location of the interface initialization function

    clearInterfaceInfoInterfaceInit         ,
    getInterfaceInfoInterfaceInit           ,
#if defined(ENABLE_OVERLOADING)
    interfaceInfo_interfaceInit             ,
#endif
    setInterfaceInfoInterfaceInit           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype InterfaceInfo = InterfaceInfo (SP.ManagedPtr InterfaceInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype InterfaceInfo where
    toManagedPtr (InterfaceInfo p) = p

instance BoxedPtr InterfaceInfo where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr InterfaceInfo)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr InterfaceInfo where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'InterfaceInfo' struct initialized to zero.
newZeroInterfaceInfo :: MonadIO m => m InterfaceInfo
newZeroInterfaceInfo = liftIO $ boxedPtrCalloc >>= wrapPtr InterfaceInfo

instance tag ~ 'AttrSet => Constructible InterfaceInfo tag where
    new _ attrs = do
        o <- newZeroInterfaceInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@interface_init@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' interfaceInfo #interfaceInit
-- @
getInterfaceInfoInterfaceInit :: MonadIO m => InterfaceInfo -> m (Maybe GObject.Callbacks.InterfaceInitFunc)
getInterfaceInfoInterfaceInit s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr GObject.Callbacks.C_InterfaceInitFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InterfaceInitFunc val'
        return val''
    return result

-- | Set the value of the “@interface_init@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' interfaceInfo [ #interfaceInit 'Data.GI.Base.Attributes.:=' value ]
-- @
setInterfaceInfoInterfaceInit :: MonadIO m => InterfaceInfo -> FunPtr GObject.Callbacks.C_InterfaceInitFunc -> m ()
setInterfaceInfoInterfaceInit s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr GObject.Callbacks.C_InterfaceInitFunc)

-- | Set the value of the “@interface_init@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #interfaceInit
-- @
clearInterfaceInfoInterfaceInit :: MonadIO m => InterfaceInfo -> m ()
clearInterfaceInfoInterfaceInit s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InterfaceInitFunc)

#if defined(ENABLE_OVERLOADING)
data InterfaceInfoInterfaceInitFieldInfo
instance AttrInfo InterfaceInfoInterfaceInitFieldInfo where
    type AttrBaseTypeConstraint InterfaceInfoInterfaceInitFieldInfo = (~) InterfaceInfo
    type AttrAllowedOps InterfaceInfoInterfaceInitFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InterfaceInfoInterfaceInitFieldInfo = (~) (FunPtr GObject.Callbacks.C_InterfaceInitFunc)
    type AttrTransferTypeConstraint InterfaceInfoInterfaceInitFieldInfo = (~)GObject.Callbacks.InterfaceInitFunc
    type AttrTransferType InterfaceInfoInterfaceInitFieldInfo = (FunPtr GObject.Callbacks.C_InterfaceInitFunc)
    type AttrGetType InterfaceInfoInterfaceInitFieldInfo = Maybe GObject.Callbacks.InterfaceInitFunc
    type AttrLabel InterfaceInfoInterfaceInitFieldInfo = "interface_init"
    type AttrOrigin InterfaceInfoInterfaceInitFieldInfo = InterfaceInfo
    attrGet = getInterfaceInfoInterfaceInit
    attrSet = setInterfaceInfoInterfaceInit
    attrConstruct = undefined
    attrClear = clearInterfaceInfoInterfaceInit
    attrTransfer _ v = do
        GObject.Callbacks.mk_InterfaceInitFunc (GObject.Callbacks.wrap_InterfaceInitFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InterfaceInfo.interfaceInit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-InterfaceInfo.html#g:attr:interfaceInit"
        })

interfaceInfo_interfaceInit :: AttrLabelProxy "interfaceInit"
interfaceInfo_interfaceInit = AttrLabelProxy

#endif


-- | Get the value of the “@interface_finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' interfaceInfo #interfaceFinalize
-- @
getInterfaceInfoInterfaceFinalize :: MonadIO m => InterfaceInfo -> m (Maybe GObject.Callbacks.InterfaceFinalizeFunc)
getInterfaceInfoInterfaceFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GObject.Callbacks.C_InterfaceFinalizeFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InterfaceFinalizeFunc val'
        return val''
    return result

-- | Set the value of the “@interface_finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' interfaceInfo [ #interfaceFinalize 'Data.GI.Base.Attributes.:=' value ]
-- @
setInterfaceInfoInterfaceFinalize :: MonadIO m => InterfaceInfo -> FunPtr GObject.Callbacks.C_InterfaceFinalizeFunc -> m ()
setInterfaceInfoInterfaceFinalize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GObject.Callbacks.C_InterfaceFinalizeFunc)

-- | Set the value of the “@interface_finalize@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #interfaceFinalize
-- @
clearInterfaceInfoInterfaceFinalize :: MonadIO m => InterfaceInfo -> m ()
clearInterfaceInfoInterfaceFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InterfaceFinalizeFunc)

#if defined(ENABLE_OVERLOADING)
data InterfaceInfoInterfaceFinalizeFieldInfo
instance AttrInfo InterfaceInfoInterfaceFinalizeFieldInfo where
    type AttrBaseTypeConstraint InterfaceInfoInterfaceFinalizeFieldInfo = (~) InterfaceInfo
    type AttrAllowedOps InterfaceInfoInterfaceFinalizeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InterfaceInfoInterfaceFinalizeFieldInfo = (~) (FunPtr GObject.Callbacks.C_InterfaceFinalizeFunc)
    type AttrTransferTypeConstraint InterfaceInfoInterfaceFinalizeFieldInfo = (~)GObject.Callbacks.InterfaceFinalizeFunc
    type AttrTransferType InterfaceInfoInterfaceFinalizeFieldInfo = (FunPtr GObject.Callbacks.C_InterfaceFinalizeFunc)
    type AttrGetType InterfaceInfoInterfaceFinalizeFieldInfo = Maybe GObject.Callbacks.InterfaceFinalizeFunc
    type AttrLabel InterfaceInfoInterfaceFinalizeFieldInfo = "interface_finalize"
    type AttrOrigin InterfaceInfoInterfaceFinalizeFieldInfo = InterfaceInfo
    attrGet = getInterfaceInfoInterfaceFinalize
    attrSet = setInterfaceInfoInterfaceFinalize
    attrConstruct = undefined
    attrClear = clearInterfaceInfoInterfaceFinalize
    attrTransfer _ v = do
        GObject.Callbacks.mk_InterfaceFinalizeFunc (GObject.Callbacks.wrap_InterfaceFinalizeFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InterfaceInfo.interfaceFinalize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-InterfaceInfo.html#g:attr:interfaceFinalize"
        })

interfaceInfo_interfaceFinalize :: AttrLabelProxy "interfaceFinalize"
interfaceInfo_interfaceFinalize = AttrLabelProxy

#endif


-- | Get the value of the “@interface_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' interfaceInfo #interfaceData
-- @
getInterfaceInfoInterfaceData :: MonadIO m => InterfaceInfo -> m (Ptr ())
getInterfaceInfoInterfaceData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr ())
    return val

-- | Set the value of the “@interface_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' interfaceInfo [ #interfaceData 'Data.GI.Base.Attributes.:=' value ]
-- @
setInterfaceInfoInterfaceData :: MonadIO m => InterfaceInfo -> Ptr () -> m ()
setInterfaceInfoInterfaceData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr ())

-- | Set the value of the “@interface_data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #interfaceData
-- @
clearInterfaceInfoInterfaceData :: MonadIO m => InterfaceInfo -> m ()
clearInterfaceInfoInterfaceData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data InterfaceInfoInterfaceDataFieldInfo
instance AttrInfo InterfaceInfoInterfaceDataFieldInfo where
    type AttrBaseTypeConstraint InterfaceInfoInterfaceDataFieldInfo = (~) InterfaceInfo
    type AttrAllowedOps InterfaceInfoInterfaceDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InterfaceInfoInterfaceDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint InterfaceInfoInterfaceDataFieldInfo = (~)(Ptr ())
    type AttrTransferType InterfaceInfoInterfaceDataFieldInfo = (Ptr ())
    type AttrGetType InterfaceInfoInterfaceDataFieldInfo = Ptr ()
    type AttrLabel InterfaceInfoInterfaceDataFieldInfo = "interface_data"
    type AttrOrigin InterfaceInfoInterfaceDataFieldInfo = InterfaceInfo
    attrGet = getInterfaceInfoInterfaceData
    attrSet = setInterfaceInfoInterfaceData
    attrConstruct = undefined
    attrClear = clearInterfaceInfoInterfaceData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InterfaceInfo.interfaceData"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-InterfaceInfo.html#g:attr:interfaceData"
        })

interfaceInfo_interfaceData :: AttrLabelProxy "interfaceData"
interfaceInfo_interfaceData = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InterfaceInfo
type instance O.AttributeList InterfaceInfo = InterfaceInfoAttributeList
type InterfaceInfoAttributeList = ('[ '("interfaceInit", InterfaceInfoInterfaceInitFieldInfo), '("interfaceFinalize", InterfaceInfoInterfaceFinalizeFieldInfo), '("interfaceData", InterfaceInfoInterfaceDataFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveInterfaceInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInterfaceInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInterfaceInfoMethod t InterfaceInfo, O.OverloadedMethod info InterfaceInfo p) => OL.IsLabel t (InterfaceInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInterfaceInfoMethod t InterfaceInfo, O.OverloadedMethod info InterfaceInfo p, R.HasField t InterfaceInfo p) => R.HasField t InterfaceInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInterfaceInfoMethod t InterfaceInfo, O.OverloadedMethodInfo info InterfaceInfo) => OL.IsLabel t (O.MethodProxy info InterfaceInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


