/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 29 "../gobject-introspection/giscanner/scannerparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "sourcescanner.h"
#include "scannerparser.h"

#ifdef G_OS_WIN32
#include <io.h>
#endif

extern FILE *yyin;
extern int lineno;
extern char linebuf[2000];
extern char *yytext;

extern int yylex (GISourceScanner *scanner);
static void yyerror (GISourceScanner *scanner, const char *str);

extern void ctype_free (GISourceType * type);

static int last_enum_value = -1;
static gboolean is_bitfield;

/**
 * parse_c_string_literal:
 * @str: A string containing a C string literal
 *
 * Based on g_strcompress(), but also handles
 * hexadecimal escapes.
 */
static char *
parse_c_string_literal (const char *str)
{
  const gchar *p = str, *num;
  gchar *dest = g_malloc (strlen (str) + 1);
  gchar *q = dest;

  while (*p)
    {
      if (*p == '\\')
        {
          p++;
          switch (*p)
            {
            case '\0':
              g_warning ("parse_c_string_literal: trailing \\");
              goto out;
            case '0':  case '1':  case '2':  case '3':  case '4':
            case '5':  case '6':  case '7':
              *q = 0;
              num = p;
              while ((p < num + 3) && (*p >= '0') && (*p <= '7'))
                {
                  *q = (*q * 8) + (*p - '0');
                  p++;
                }
              q++;
              p--;
              break;
	    case 'x':
	      *q = 0;
	      p++;
	      num = p;
	      while ((p < num + 2) && (g_ascii_isxdigit(*p)))
		{
		  *q = (*q * 16) + g_ascii_xdigit_value(*p);
		  p++;
		}
              q++;
              p--;
	      break;
            case 'b':
              *q++ = '\b';
              break;
            case 'f':
              *q++ = '\f';
              break;
            case 'n':
              *q++ = '\n';
              break;
            case 'r':
              *q++ = '\r';
              break;
            case 't':
              *q++ = '\t';
              break;
            default:            /* Also handles \" and \\ */
              *q++ = *p;
              break;
            }
        }
      else
        *q++ = *p;
      p++;
    }
out:
  *q = 0;

  return dest;
}

enum {
  IRRELEVANT = 1,
  NOT_GI_SCANNER = 2,
  FOR_GI_SCANNER = 3,
};

static void
update_skipping (GISourceScanner *scanner)
{
  GList *l;
  for (l = scanner->conditionals.head; l != NULL; l = g_list_next (l))
    {
      if (GPOINTER_TO_INT (l->data) == NOT_GI_SCANNER)
        {
           scanner->skipping = TRUE;
           return;
        }
    }

  scanner->skipping = FALSE;
}

static void
push_conditional (GISourceScanner *scanner,
                  gint type)
{
  g_assert (type != 0);
  g_queue_push_head (&scanner->conditionals, GINT_TO_POINTER (type));
}

static gint
pop_conditional (GISourceScanner *scanner)
{
  gint type = GPOINTER_TO_INT (g_queue_pop_head (&scanner->conditionals));

  if (type == 0)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: mismatched %s", filename, lineno, yytext);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }

  return type;
}

static void
warn_if_cond_has_gi_scanner (GISourceScanner *scanner,
                             const gchar *text)
{
  /* Some other conditional that is not __GI_SCANNER__ */
  if (strstr (text, "__GI_SCANNER__"))
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: the __GI_SCANNER__ constant should only be used with simple #ifdef or #endif: %s",
               filename, lineno, text);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }
}

static void
toggle_conditional (GISourceScanner *scanner)
{
  switch (pop_conditional (scanner))
    {
    case FOR_GI_SCANNER:
      push_conditional (scanner, NOT_GI_SCANNER);
      break;
    case NOT_GI_SCANNER:
      push_conditional (scanner, FOR_GI_SCANNER);
      break;
    case 0:
      break;
    default:
      push_conditional (scanner, IRRELEVANT);
      break;
    }
}

static void
set_or_merge_base_type (GISourceType *type,
                        GISourceType *base)
{
  /* combine basic types like unsigned int and long long */
  if (base->type == CTYPE_BASIC_TYPE && type->type == CTYPE_BASIC_TYPE)
    {
      char *name = g_strdup_printf ("%s %s", type->name, base->name);
      g_free (type->name);
      type->name = name;

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else if (base->type == CTYPE_INVALID)
    {
      g_assert (base->base_type == NULL);

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else
    {
      g_assert (type->base_type == NULL);

      type->base_type = base;
    }
}


#line 295 "giscanner/scannerparser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "scannerparser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_BASIC_TYPE = 3,                 /* BASIC_TYPE  */
  YYSYMBOL_IDENTIFIER = 4,                 /* "identifier"  */
  YYSYMBOL_TYPEDEF_NAME = 5,               /* "typedef-name"  */
  YYSYMBOL_INTEGER = 6,                    /* INTEGER  */
  YYSYMBOL_FLOATING = 7,                   /* FLOATING  */
  YYSYMBOL_BOOLEAN = 8,                    /* BOOLEAN  */
  YYSYMBOL_CHARACTER = 9,                  /* CHARACTER  */
  YYSYMBOL_STRING = 10,                    /* STRING  */
  YYSYMBOL_INTL_CONST = 11,                /* INTL_CONST  */
  YYSYMBOL_INTUL_CONST = 12,               /* INTUL_CONST  */
  YYSYMBOL_ELLIPSIS = 13,                  /* ELLIPSIS  */
  YYSYMBOL_ADDEQ = 14,                     /* ADDEQ  */
  YYSYMBOL_SUBEQ = 15,                     /* SUBEQ  */
  YYSYMBOL_MULEQ = 16,                     /* MULEQ  */
  YYSYMBOL_DIVEQ = 17,                     /* DIVEQ  */
  YYSYMBOL_MODEQ = 18,                     /* MODEQ  */
  YYSYMBOL_XOREQ = 19,                     /* XOREQ  */
  YYSYMBOL_ANDEQ = 20,                     /* ANDEQ  */
  YYSYMBOL_OREQ = 21,                      /* OREQ  */
  YYSYMBOL_SL = 22,                        /* SL  */
  YYSYMBOL_SR = 23,                        /* SR  */
  YYSYMBOL_SLEQ = 24,                      /* SLEQ  */
  YYSYMBOL_SREQ = 25,                      /* SREQ  */
  YYSYMBOL_EQ = 26,                        /* EQ  */
  YYSYMBOL_NOTEQ = 27,                     /* NOTEQ  */
  YYSYMBOL_LTEQ = 28,                      /* LTEQ  */
  YYSYMBOL_GTEQ = 29,                      /* GTEQ  */
  YYSYMBOL_ANDAND = 30,                    /* ANDAND  */
  YYSYMBOL_OROR = 31,                      /* OROR  */
  YYSYMBOL_PLUSPLUS = 32,                  /* PLUSPLUS  */
  YYSYMBOL_MINUSMINUS = 33,                /* MINUSMINUS  */
  YYSYMBOL_ARROW = 34,                     /* ARROW  */
  YYSYMBOL_AUTO = 35,                      /* AUTO  */
  YYSYMBOL_ALIGNOF = 36,                   /* ALIGNOF  */
  YYSYMBOL_BREAK = 37,                     /* BREAK  */
  YYSYMBOL_CASE = 38,                      /* CASE  */
  YYSYMBOL_COMPLEX = 39,                   /* COMPLEX  */
  YYSYMBOL_CONST = 40,                     /* CONST  */
  YYSYMBOL_CONTINUE = 41,                  /* CONTINUE  */
  YYSYMBOL_DEFAULT = 42,                   /* DEFAULT  */
  YYSYMBOL_DO = 43,                        /* DO  */
  YYSYMBOL_ELSE = 44,                      /* ELSE  */
  YYSYMBOL_ENUM = 45,                      /* ENUM  */
  YYSYMBOL_EXTENSION = 46,                 /* EXTENSION  */
  YYSYMBOL_EXTERN = 47,                    /* EXTERN  */
  YYSYMBOL_FOR = 48,                       /* FOR  */
  YYSYMBOL_GOTO = 49,                      /* GOTO  */
  YYSYMBOL_IF = 50,                        /* IF  */
  YYSYMBOL_INLINE = 51,                    /* INLINE  */
  YYSYMBOL_REGISTER = 52,                  /* REGISTER  */
  YYSYMBOL_RESTRICT = 53,                  /* RESTRICT  */
  YYSYMBOL_RETURN = 54,                    /* RETURN  */
  YYSYMBOL_SHORT = 55,                     /* SHORT  */
  YYSYMBOL_SIGNED = 56,                    /* SIGNED  */
  YYSYMBOL_SIZEOF = 57,                    /* SIZEOF  */
  YYSYMBOL_STATIC = 58,                    /* STATIC  */
  YYSYMBOL_STRUCT = 59,                    /* STRUCT  */
  YYSYMBOL_SWITCH = 60,                    /* SWITCH  */
  YYSYMBOL_THREAD_LOCAL = 61,              /* THREAD_LOCAL  */
  YYSYMBOL_TYPEDEF = 62,                   /* TYPEDEF  */
  YYSYMBOL_UNION = 63,                     /* UNION  */
  YYSYMBOL_UNSIGNED = 64,                  /* UNSIGNED  */
  YYSYMBOL_VOID = 65,                      /* VOID  */
  YYSYMBOL_VOLATILE = 66,                  /* VOLATILE  */
  YYSYMBOL_WHILE = 67,                     /* WHILE  */
  YYSYMBOL_FUNCTION_MACRO = 68,            /* FUNCTION_MACRO  */
  YYSYMBOL_OBJECT_MACRO = 69,              /* OBJECT_MACRO  */
  YYSYMBOL_IFDEF_GI_SCANNER = 70,          /* IFDEF_GI_SCANNER  */
  YYSYMBOL_IFNDEF_GI_SCANNER = 71,         /* IFNDEF_GI_SCANNER  */
  YYSYMBOL_IFDEF_COND = 72,                /* IFDEF_COND  */
  YYSYMBOL_IFNDEF_COND = 73,               /* IFNDEF_COND  */
  YYSYMBOL_IF_COND = 74,                   /* IF_COND  */
  YYSYMBOL_ELIF_COND = 75,                 /* ELIF_COND  */
  YYSYMBOL_ELSE_COND = 76,                 /* ELSE_COND  */
  YYSYMBOL_ENDIF_COND = 77,                /* ENDIF_COND  */
  YYSYMBOL_78_ = 78,                       /* '('  */
  YYSYMBOL_79_ = 79,                       /* ')'  */
  YYSYMBOL_80_ = 80,                       /* '{'  */
  YYSYMBOL_81_ = 81,                       /* '}'  */
  YYSYMBOL_82_ = 82,                       /* '['  */
  YYSYMBOL_83_ = 83,                       /* ']'  */
  YYSYMBOL_84_ = 84,                       /* '.'  */
  YYSYMBOL_85_ = 85,                       /* ','  */
  YYSYMBOL_86_ = 86,                       /* '&'  */
  YYSYMBOL_87_ = 87,                       /* '*'  */
  YYSYMBOL_88_ = 88,                       /* '+'  */
  YYSYMBOL_89_ = 89,                       /* '-'  */
  YYSYMBOL_90_ = 90,                       /* '~'  */
  YYSYMBOL_91_ = 91,                       /* '!'  */
  YYSYMBOL_92_ = 92,                       /* '/'  */
  YYSYMBOL_93_ = 93,                       /* '%'  */
  YYSYMBOL_94_ = 94,                       /* '<'  */
  YYSYMBOL_95_ = 95,                       /* '>'  */
  YYSYMBOL_96_ = 96,                       /* '^'  */
  YYSYMBOL_97_ = 97,                       /* '|'  */
  YYSYMBOL_98_ = 98,                       /* '?'  */
  YYSYMBOL_99_ = 99,                       /* ':'  */
  YYSYMBOL_100_ = 100,                     /* '='  */
  YYSYMBOL_101_ = 101,                     /* ';'  */
  YYSYMBOL_YYACCEPT = 102,                 /* $accept  */
  YYSYMBOL_primary_expression = 103,       /* primary_expression  */
  YYSYMBOL_strings = 104,                  /* strings  */
  YYSYMBOL_identifier = 105,               /* identifier  */
  YYSYMBOL_identifier_or_typedef_name = 106, /* identifier_or_typedef_name  */
  YYSYMBOL_postfix_expression = 107,       /* postfix_expression  */
  YYSYMBOL_argument_expression_list = 108, /* argument_expression_list  */
  YYSYMBOL_unary_expression = 109,         /* unary_expression  */
  YYSYMBOL_unary_operator = 110,           /* unary_operator  */
  YYSYMBOL_cast_expression = 111,          /* cast_expression  */
  YYSYMBOL_multiplicative_expression = 112, /* multiplicative_expression  */
  YYSYMBOL_additive_expression = 113,      /* additive_expression  */
  YYSYMBOL_shift_expression = 114,         /* shift_expression  */
  YYSYMBOL_relational_expression = 115,    /* relational_expression  */
  YYSYMBOL_equality_expression = 116,      /* equality_expression  */
  YYSYMBOL_and_expression = 117,           /* and_expression  */
  YYSYMBOL_exclusive_or_expression = 118,  /* exclusive_or_expression  */
  YYSYMBOL_inclusive_or_expression = 119,  /* inclusive_or_expression  */
  YYSYMBOL_logical_and_expression = 120,   /* logical_and_expression  */
  YYSYMBOL_logical_or_expression = 121,    /* logical_or_expression  */
  YYSYMBOL_conditional_expression = 122,   /* conditional_expression  */
  YYSYMBOL_assignment_expression = 123,    /* assignment_expression  */
  YYSYMBOL_assignment_operator = 124,      /* assignment_operator  */
  YYSYMBOL_expression = 125,               /* expression  */
  YYSYMBOL_constant_expression = 126,      /* constant_expression  */
  YYSYMBOL_declaration = 127,              /* declaration  */
  YYSYMBOL_empty_declaration = 128,        /* empty_declaration  */
  YYSYMBOL_declaration_specifiers = 129,   /* declaration_specifiers  */
  YYSYMBOL_init_declarator_list = 130,     /* init_declarator_list  */
  YYSYMBOL_init_declarator = 131,          /* init_declarator  */
  YYSYMBOL_storage_class_specifier = 132,  /* storage_class_specifier  */
  YYSYMBOL_basic_type = 133,               /* basic_type  */
  YYSYMBOL_type_specifier = 134,           /* type_specifier  */
  YYSYMBOL_struct_or_union_specifier = 135, /* struct_or_union_specifier  */
  YYSYMBOL_struct_or_union = 136,          /* struct_or_union  */
  YYSYMBOL_struct_declaration_list = 137,  /* struct_declaration_list  */
  YYSYMBOL_struct_declaration = 138,       /* struct_declaration  */
  YYSYMBOL_specifier_qualifier_list = 139, /* specifier_qualifier_list  */
  YYSYMBOL_struct_declarator_list = 140,   /* struct_declarator_list  */
  YYSYMBOL_struct_declarator = 141,        /* struct_declarator  */
  YYSYMBOL_enum_specifier = 142,           /* enum_specifier  */
  YYSYMBOL_enum_keyword = 143,             /* enum_keyword  */
  YYSYMBOL_static_keyword = 144,           /* static_keyword  */
  YYSYMBOL_enumerator_list = 145,          /* enumerator_list  */
  YYSYMBOL_146_1 = 146,                    /* $@1  */
  YYSYMBOL_enumerator = 147,               /* enumerator  */
  YYSYMBOL_type_qualifier = 148,           /* type_qualifier  */
  YYSYMBOL_function_specifier = 149,       /* function_specifier  */
  YYSYMBOL_declarator = 150,               /* declarator  */
  YYSYMBOL_direct_declarator = 151,        /* direct_declarator  */
  YYSYMBOL_pointer = 152,                  /* pointer  */
  YYSYMBOL_type_qualifier_list = 153,      /* type_qualifier_list  */
  YYSYMBOL_parameter_list = 154,           /* parameter_list  */
  YYSYMBOL_parameter_declaration = 155,    /* parameter_declaration  */
  YYSYMBOL_identifier_list = 156,          /* identifier_list  */
  YYSYMBOL_type_name = 157,                /* type_name  */
  YYSYMBOL_abstract_declarator = 158,      /* abstract_declarator  */
  YYSYMBOL_direct_abstract_declarator = 159, /* direct_abstract_declarator  */
  YYSYMBOL_typedef_name = 160,             /* typedef_name  */
  YYSYMBOL_initializer = 161,              /* initializer  */
  YYSYMBOL_initializer_list = 162,         /* initializer_list  */
  YYSYMBOL_initializer_list_item = 163,    /* initializer_list_item  */
  YYSYMBOL_designator_list = 164,          /* designator_list  */
  YYSYMBOL_designator = 165,               /* designator  */
  YYSYMBOL_statement = 166,                /* statement  */
  YYSYMBOL_labeled_statement = 167,        /* labeled_statement  */
  YYSYMBOL_compound_statement = 168,       /* compound_statement  */
  YYSYMBOL_block_item_list = 169,          /* block_item_list  */
  YYSYMBOL_block_item = 170,               /* block_item  */
  YYSYMBOL_expression_statement = 171,     /* expression_statement  */
  YYSYMBOL_selection_statement = 172,      /* selection_statement  */
  YYSYMBOL_iteration_statement = 173,      /* iteration_statement  */
  YYSYMBOL_jump_statement = 174,           /* jump_statement  */
  YYSYMBOL_translation_unit = 175,         /* translation_unit  */
  YYSYMBOL_external_declaration = 176,     /* external_declaration  */
  YYSYMBOL_function_definition = 177,      /* function_definition  */
  YYSYMBOL_declaration_list = 178,         /* declaration_list  */
  YYSYMBOL_function_macro = 179,           /* function_macro  */
  YYSYMBOL_object_macro = 180,             /* object_macro  */
  YYSYMBOL_function_macro_argument_list = 181, /* function_macro_argument_list  */
  YYSYMBOL_function_macro_define = 182,    /* function_macro_define  */
  YYSYMBOL_object_macro_define = 183,      /* object_macro_define  */
  YYSYMBOL_preproc_conditional = 184,      /* preproc_conditional  */
  YYSYMBOL_macro = 185                     /* macro  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  75
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2883

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  102
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  84
/* YYNRULES -- Number of rules.  */
#define YYNRULES  269
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  450

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   332


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    91,     2,     2,     2,    93,    86,     2,
      78,    79,    87,    88,    85,    89,    84,    92,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    99,   101,
      94,   100,    95,    98,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    82,     2,    83,    96,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    80,    97,    81,    90,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   349,   349,   358,   374,   380,   386,   393,   394,   398,
     406,   421,   435,   442,   443,   447,   448,   452,   456,   460,
     464,   468,   472,   479,   480,   484,   485,   489,   493,   516,
     523,   530,   534,   539,   543,   551,   555,   559,   563,   567,
     571,   578,   579,   591,   592,   598,   606,   617,   618,   624,
     633,   634,   646,   655,   656,   662,   668,   674,   683,   684,
     690,   699,   700,   709,   710,   719,   720,   729,   730,   741,
     742,   753,   754,   761,   762,   769,   770,   771,   772,   773,
     774,   775,   776,   777,   778,   779,   783,   784,   785,   792,
     798,   816,   823,   826,   831,   836,   841,   842,   847,   852,
     857,   865,   869,   876,   877,   881,   885,   889,   893,   897,
     901,   908,   915,   919,   923,   927,   931,   936,   937,   938,
     946,   966,   971,   979,   984,   992,   993,  1000,  1020,  1025,
    1026,  1031,  1039,  1043,  1051,  1054,  1055,  1059,  1070,  1077,
    1084,  1091,  1098,  1105,  1113,  1120,  1120,  1129,  1137,  1145,
    1157,  1161,  1165,  1169,  1176,  1183,  1188,  1192,  1197,  1201,
    1206,  1211,  1216,  1226,  1233,  1242,  1247,  1251,  1262,  1275,
    1276,  1283,  1287,  1294,  1299,  1304,  1309,  1316,  1322,  1331,
    1332,  1336,  1341,  1342,  1350,  1354,  1359,  1364,  1369,  1374,
    1380,  1390,  1396,  1409,  1416,  1417,  1418,  1422,  1423,  1427,
    1428,  1432,  1433,  1437,  1438,  1444,  1445,  1446,  1447,  1448,
    1449,  1453,  1454,  1455,  1459,  1460,  1464,  1465,  1469,  1470,
    1474,  1475,  1479,  1480,  1481,  1485,  1486,  1487,  1488,  1489,
    1490,  1491,  1492,  1493,  1494,  1498,  1499,  1500,  1501,  1502,
    1508,  1509,  1513,  1514,  1515,  1516,  1520,  1521,  1525,  1526,
    1532,  1539,  1546,  1552,  1557,  1566,  1576,  1589,  1606,  1611,
    1616,  1621,  1626,  1631,  1638,  1643,  1651,  1652,  1653,  1654
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "BASIC_TYPE",
  "\"identifier\"", "\"typedef-name\"", "INTEGER", "FLOATING", "BOOLEAN",
  "CHARACTER", "STRING", "INTL_CONST", "INTUL_CONST", "ELLIPSIS", "ADDEQ",
  "SUBEQ", "MULEQ", "DIVEQ", "MODEQ", "XOREQ", "ANDEQ", "OREQ", "SL", "SR",
  "SLEQ", "SREQ", "EQ", "NOTEQ", "LTEQ", "GTEQ", "ANDAND", "OROR",
  "PLUSPLUS", "MINUSMINUS", "ARROW", "AUTO", "ALIGNOF", "BREAK", "CASE",
  "COMPLEX", "CONST", "CONTINUE", "DEFAULT", "DO", "ELSE", "ENUM",
  "EXTENSION", "EXTERN", "FOR", "GOTO", "IF", "INLINE", "REGISTER",
  "RESTRICT", "RETURN", "SHORT", "SIGNED", "SIZEOF", "STATIC", "STRUCT",
  "SWITCH", "THREAD_LOCAL", "TYPEDEF", "UNION", "UNSIGNED", "VOID",
  "VOLATILE", "WHILE", "FUNCTION_MACRO", "OBJECT_MACRO",
  "IFDEF_GI_SCANNER", "IFNDEF_GI_SCANNER", "IFDEF_COND", "IFNDEF_COND",
  "IF_COND", "ELIF_COND", "ELSE_COND", "ENDIF_COND", "'('", "')'", "'{'",
  "'}'", "'['", "']'", "'.'", "','", "'&'", "'*'", "'+'", "'-'", "'~'",
  "'!'", "'/'", "'%'", "'<'", "'>'", "'^'", "'|'", "'?'", "':'", "'='",
  "';'", "$accept", "primary_expression", "strings", "identifier",
  "identifier_or_typedef_name", "postfix_expression",
  "argument_expression_list", "unary_expression", "unary_operator",
  "cast_expression", "multiplicative_expression", "additive_expression",
  "shift_expression", "relational_expression", "equality_expression",
  "and_expression", "exclusive_or_expression", "inclusive_or_expression",
  "logical_and_expression", "logical_or_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration", "empty_declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "storage_class_specifier", "basic_type", "type_specifier",
  "struct_or_union_specifier", "struct_or_union",
  "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enum_keyword", "static_keyword",
  "enumerator_list", "$@1", "enumerator", "type_qualifier",
  "function_specifier", "declarator", "direct_declarator", "pointer",
  "type_qualifier_list", "parameter_list", "parameter_declaration",
  "identifier_list", "type_name", "abstract_declarator",
  "direct_abstract_declarator", "typedef_name", "initializer",
  "initializer_list", "initializer_list_item", "designator_list",
  "designator", "statement", "labeled_statement", "compound_statement",
  "block_item_list", "block_item", "expression_statement",
  "selection_statement", "iteration_statement", "jump_statement",
  "translation_unit", "external_declaration", "function_definition",
  "declaration_list", "function_macro", "object_macro",
  "function_macro_argument_list", "function_macro_define",
  "object_macro_define", "preproc_conditional", "macro", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-259)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-15)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     539,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,  -259,  -259,    26,  2817,  -259,  2817,  -259,
      27,  -259,   177,  2817,  2817,  -259,   462,  -259,  -259,   -56,
    2126,  -259,  -259,  -259,  -259,  -259,    39,   190,  -259,  -259,
     -65,  -259,  1057,   -59,    47,  -259,  -259,  1317,  -259,   -46,
    -259,  -259,   -21,  -259,  -259,  -259,  -259,    13,  -259,  -259,
    -259,  -259,  -259,     0,    28,  2186,  2186,  2246,    45,  2306,
    1403,  -259,  -259,  -259,  -259,  -259,  -259,  -259,   155,  -259,
     201,  -259,  2126,  -259,   135,   143,    32,   146,   305,   166,
     162,   164,   256,    38,  -259,  -259,   210,  -259,  -259,   190,
      39,  -259,   614,  1646,  -259,    26,  -259,  2592,  2656,  1586,
     -59,  1317,  1521,  -259,    90,  1317,  1317,    -6,   290,  -259,
    -259,  -259,   216,   234,  2186,  2186,  2366,  -259,  -259,  1403,
    -259,   241,  1403,  -259,  2426,   188,  -259,  -259,    -3,   173,
     245,  -259,  -259,  -259,   332,  1706,  2366,   332,  -259,  2126,
    2126,  2126,  2126,  2126,  2126,  2126,  2126,  2126,  2126,  2126,
    2126,  2126,  2126,  2126,  2126,  2126,  2126,  2366,  -259,  -259,
    -259,  -259,   240,   232,  2126,   243,   247,   999,   270,   332,
     274,  1120,   279,   281,  -259,  -259,   261,   264,   -57,  -259,
     266,  -259,  -259,  -259,   713,  -259,  -259,  -259,  -259,  -259,
    1526,  -259,  -259,  -259,  -259,  -259,  -259,  -259,    46,   106,
    -259,   140,  -259,  -259,   284,  2126,  -259,  -259,  -259,  2126,
     -33,  -259,   271,  -259,  1701,  -259,    31,   269,  -259,   189,
     130,  -259,   292,   293,  2426,   298,   911,   299,  1339,   294,
    -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,  -259,
    -259,  2126,  -259,  2126,  2547,  1766,   193,  -259,   233,  2126,
    -259,  -259,   163,  -259,   113,  -259,  -259,  -259,  -259,   135,
     135,   143,   143,    32,    32,    32,    32,   146,   146,   305,
     166,   162,   164,   256,    98,  -259,   286,  -259,   999,   313,
    1136,   285,  2366,  -259,   -28,  2366,  2366,   999,  -259,  -259,
    -259,  2126,   290,  -259,   238,  -259,   -19,  -259,  2483,  -259,
      85,  -259,  -259,  2784,  -259,   290,  -259,   304,  -259,    90,
    -259,  2126,  -259,  -259,  -259,  2126,  -259,    33,  -259,  -259,
    -259,  -259,   812,  -259,  -259,  -259,  -259,   168,   310,  -259,
     307,   233,  2720,  1826,  -259,  -259,  2126,  -259,  2366,   999,
    -259,   315,  1224,    93,  -259,   180,  -259,   183,   184,  -259,
     308,  -259,  -259,  1466,  1646,  -259,  -259,  -259,  -259,  -259,
    -259,  -259,  -259,   317,  -259,  -259,  -259,  -259,   187,  -259,
     318,  -259,   294,  -259,  2366,  1886,    99,  1240,   999,   999,
     999,  -259,  -259,  -259,  -259,  -259,  -259,  -259,   199,   999,
     212,  1946,  2006,   138,   344,  -259,  -259,   297,  -259,   999,
     999,   220,   999,   224,  2066,   999,  -259,  -259,  -259,   999,
    -259,   999,   999,   229,  -259,  -259,  -259,  -259,   999,  -259
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,   269,   111,   193,   108,   113,   150,   143,   152,   106,
     154,   109,   151,   114,   107,   123,   110,   105,   124,   115,
     112,   153,   250,   251,   258,   259,   260,   261,   262,   263,
     264,   265,    92,   243,   244,     0,    94,   116,    96,   117,
       0,   118,     0,    98,   100,   119,     0,   240,   242,     0,
       0,   266,   267,   268,   245,    12,     0,   166,    91,   157,
       0,   101,   103,   156,     0,    93,    95,     0,    13,   122,
      14,   145,   142,    97,    99,     1,   241,     0,     3,     6,
       4,     5,    10,     0,     0,     0,     0,     0,     0,     0,
       0,    35,    36,    37,    38,    39,    40,    15,     7,     2,
      25,    41,     0,    43,    47,    50,    53,    58,    61,    63,
      65,    67,    69,    71,    89,   257,     0,   169,   168,   165,
       0,    90,     0,     0,   248,     0,   247,     0,     0,     0,
     155,   129,     0,   125,   134,   131,     0,     0,     0,   145,
     253,   256,   252,     0,     0,     0,     0,    26,    27,     0,
      31,     0,     0,    33,   152,    41,    73,    86,     0,   179,
       0,    11,    21,    22,     0,     0,     0,     0,    28,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   158,   170,
     167,   102,   103,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   214,   220,     2,     0,     0,   218,
     119,   219,   205,   206,     0,   216,   207,   208,   209,   210,
       0,   194,   104,   249,   246,   176,   164,   177,   175,     0,
     171,     0,   144,   161,     0,     0,   128,   121,   126,     0,
       0,   132,   135,   130,     0,   139,     0,   148,   146,     0,
       0,   255,     0,     0,     0,     0,     0,     0,     0,    88,
      79,    80,    76,    77,    78,    84,    83,    85,    81,    82,
      75,     0,     8,     0,     0,     0,   181,   180,   182,     0,
      20,    18,     0,    23,     0,    19,    44,    45,    46,    48,
      49,    51,    52,    56,    57,    54,    55,    59,    60,    62,
      64,    66,    68,    70,     0,   237,     0,   236,     0,     0,
       0,     0,     0,   238,     0,     0,     0,     0,   221,   215,
     217,     0,     0,   200,     0,   197,     0,   201,     0,   173,
     181,   174,   162,     0,   163,     0,   160,     0,   136,   134,
     127,     0,   120,   141,   147,     0,   138,     0,   254,    29,
      30,    32,     0,    34,    74,    87,   189,     0,     0,   185,
       0,   183,     0,     0,    42,    17,     0,    16,     0,     0,
     213,     0,     0,     0,   235,     0,   239,     0,     0,   211,
       0,   204,   195,     0,     0,   202,   172,   178,   159,   133,
     137,   149,   140,     0,   190,   184,   186,   191,     0,   187,
       0,    24,    72,   212,     0,     0,     0,     0,     0,     0,
       0,   203,   196,   198,   199,     9,   192,   188,     0,     0,
       0,     0,     0,     0,   222,   224,   225,     0,   227,     0,
       0,     0,     0,     0,     0,     0,   226,   231,   229,     0,
     228,     0,     0,     0,   223,   233,   232,   230,     0,   234
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -259,  -259,  -259,   -35,   -26,  -259,  -259,   -25,  -259,   -61,
     178,   179,   150,   181,   227,   228,   235,   231,   236,  -259,
     -23,    72,  -259,   -66,  -155,    12,  -259,     2,  -259,   300,
    -259,  -259,   -34,  -259,  -259,   282,  -122,   -82,  -259,    78,
    -259,  -259,  -259,   287,  -259,   289,   309,  -259,   -29,   -63,
     -48,  -259,  -117,    91,  -259,    68,  -112,  -258,   -27,  -120,
    -259,    40,  -259,   103,    41,  -259,     4,   169,  -210,  -259,
    -259,  -259,  -259,  -259,   384,  -259,  -259,  -259,  -259,   182,
    -259,  -259,  -259,  -259
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    97,    98,    99,   207,   100,   282,   155,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     156,   157,   271,   208,   115,   209,    34,   125,    60,    61,
      36,    37,    38,    39,    40,   132,   133,   134,   240,   241,
      41,    42,   235,   137,   138,   344,    43,    44,   116,    63,
      64,   119,   357,   230,   231,   160,   358,   278,    45,   323,
     324,   325,   326,   327,   211,   212,   213,   214,   215,   216,
     217,   218,   219,    46,    47,    48,   127,    49,    50,   143,
      51,    52,    53,    54
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      59,   130,    35,   222,   320,    68,    62,    68,   159,   118,
     238,   229,    33,    70,    69,    70,    72,    55,   361,   128,
     120,    59,    77,   129,   158,   101,   140,   114,   273,    59,
      55,    55,     3,   131,   136,    55,   121,    55,    65,   306,
      66,   168,   142,    55,   318,    73,    74,   277,    35,   236,
      55,    55,   339,   243,   174,   175,   131,   273,    33,   139,
     147,   148,   150,   321,   153,   322,   126,   159,   340,   186,
     159,   190,   361,   376,   124,   245,   272,   101,   144,   246,
     158,   384,   273,   158,   338,    59,   158,   206,   259,    55,
      59,   192,   141,   227,    55,   210,   192,   131,   131,    59,
     284,   131,   131,   247,    56,   242,   145,    67,   286,   287,
     288,   276,   343,    57,   392,   131,   331,    56,   131,   252,
     253,   304,   238,   151,   328,    56,    57,    58,   275,    68,
     228,   224,    68,    57,    55,   314,   187,    70,   280,   223,
      70,   285,   320,   140,   101,   101,   101,   101,   101,   101,
     101,   101,   101,   101,   101,   101,   101,   101,   101,   101,
     101,   101,   206,   328,    68,   161,   380,   275,    56,   101,
      70,   114,    70,   311,   176,   177,   159,    57,   273,   206,
     330,    55,     3,   273,   273,   332,   390,   210,   259,   239,
     391,   333,   158,    59,   407,   221,   367,   368,   273,   329,
     421,   234,   260,   261,   262,   263,   264,   265,   266,   267,
     131,   247,   268,   269,   101,   142,   114,   255,   364,   334,
     257,   206,   169,   273,   131,   335,   276,   170,   171,   210,
       6,   172,   173,   162,   163,   164,     8,   283,   309,   434,
     178,   179,   365,    12,   373,   398,   375,   394,   366,   377,
     378,   274,   182,   333,   101,   275,    21,    71,   183,   408,
      57,   184,   409,   410,   414,   273,   416,   130,   273,   273,
     346,   274,   333,   206,   347,   275,   228,    57,   427,   165,
     330,    70,   206,   166,   273,   167,   185,   381,   270,   188,
      70,   429,   221,    59,    55,    59,   101,   273,   114,   439,
     387,   250,   402,   441,    59,   273,   406,   337,   448,   273,
     242,   362,   247,   251,   273,   363,   101,   206,   114,   382,
     101,   256,   114,   383,   279,   210,   293,   294,   295,   296,
     228,   180,   181,   305,   206,   228,    55,     3,   418,   420,
     123,   423,    70,   354,   307,   355,   308,   360,   310,   370,
     289,   290,   312,   291,   292,   431,   433,   315,   379,   316,
     -13,   297,   298,   317,   228,   -14,   117,   336,   443,   345,
     341,   349,   350,   206,   206,   206,   135,   351,   353,   273,
     371,    70,    70,    70,   206,   369,   374,   388,   435,   395,
     396,   411,    70,   404,   206,   206,   415,   206,   436,   135,
     206,   417,    70,    70,   206,    70,   206,   206,    70,   299,
     403,   300,    70,   206,    70,    70,   302,   389,   244,   301,
     191,    70,   303,   413,   386,   352,   249,   248,   189,   385,
      76,     0,   348,     0,     0,   400,     0,     0,   401,     0,
     135,   135,     0,     0,   135,   135,     0,     0,     0,   424,
     425,   426,     0,     0,     0,   221,   221,     0,   135,     0,
     428,   135,    75,     1,     0,     2,     0,     3,     0,     0,
     437,   438,     0,   440,     0,     0,   444,     0,     0,     0,
     445,     0,   446,   447,     0,     0,     0,     0,     0,   449,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     5,     6,     0,     0,     0,     0,     7,     8,     9,
       0,     0,     0,    10,    11,    12,     0,     0,    13,     0,
      14,    15,     0,    16,    17,    18,    19,    20,    21,     0,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
       1,     0,     2,     0,     3,     0,     0,     0,     0,     0,
       0,     0,     0,   135,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    32,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     5,     6,
       0,     0,     0,     0,     7,     8,     9,     0,     0,     0,
      10,    11,    12,     0,     0,    13,     0,    14,    15,     0,
      16,    17,    18,    19,    20,    21,     0,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,     2,    55,     3,
      78,    79,    80,    81,    82,    83,    84,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      32,     0,     0,     0,     0,     0,    85,    86,     0,     4,
      87,   193,   194,     5,     6,   195,   196,   197,     0,     7,
     154,     9,   198,   199,   200,    10,    11,    12,   201,     0,
      13,    89,    14,    15,   202,    16,    17,    18,    19,    20,
      21,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    90,     0,   122,   204,     0,     0,     0,     0,
      91,    92,    93,    94,    95,    96,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,     2,    55,     3,    78,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    85,    86,     0,     4,    87,
     193,   194,     5,     6,   195,   196,   197,     0,     7,   154,
       9,   198,   199,   200,    10,    11,    12,   201,     0,    13,
      89,    14,    15,   202,    16,    17,    18,    19,    20,    21,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    90,     0,   122,   319,     0,     0,     0,     0,    91,
      92,    93,    94,    95,    96,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     2,    55,     3,    78,    79,
      80,    81,    82,    83,    84,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    85,    86,     0,     4,    87,   193,
     194,     5,     6,   195,   196,   197,     0,     7,   154,     9,
     198,   199,   200,    10,    11,    12,   201,     0,    13,    89,
      14,    15,   202,    16,    17,    18,    19,    20,    21,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      90,     0,   122,   393,     0,     0,     0,     0,    91,    92,
      93,    94,    95,    96,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     2,    55,     3,    78,    79,    80,
      81,    82,    83,    84,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    85,    86,     0,     4,    87,   193,   194,
       5,     6,   195,   196,   197,     0,     7,   154,     9,   198,
     199,   200,    10,    11,    12,   201,     0,    13,    89,    14,
      15,   202,    16,    17,    18,    19,    20,    21,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    90,
       0,   122,     0,     0,     0,     0,     0,    91,    92,    93,
      94,    95,    96,    55,     3,    78,    79,    80,    81,    82,
      83,    84,   205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    85,    86,     0,     0,    87,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   254,     0,   198,   199,   200,
       0,     0,     0,   201,     0,     0,    89,     0,     0,   202,
       2,     0,     3,     0,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    90,     0,   122,
       0,     0,     0,     0,     0,    91,    92,    93,    94,    95,
      96,     0,     4,     0,     0,     0,     5,     6,     0,     0,
     205,     0,     7,     8,     9,     0,     0,     0,    10,    11,
      12,     0,     0,    13,     0,    14,    15,     0,    16,    17,
      18,    19,    20,    21,    55,     0,    78,    79,    80,    81,
      82,    83,    84,     0,     0,     0,     0,   122,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,    85,    86,     0,     0,    87,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   254,     0,    85,    86,
       0,     0,    87,     0,     0,     0,     0,    89,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,    90,     0,
       0,     0,     0,     0,     0,     0,    91,    92,    93,    94,
      95,    96,     0,     0,    90,     0,     0,     0,     0,     0,
       0,   313,    91,    92,    93,    94,    95,    96,    55,     0,
      78,    79,    80,    81,    82,    83,    84,   372,     0,     0,
       0,     0,     0,     0,    55,     0,    78,    79,    80,    81,
      82,    83,    84,     0,     0,     0,    85,    86,     0,     0,
      87,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     254,     0,    85,    86,     0,     0,    87,     0,     0,     0,
       0,    89,     0,     0,     0,     0,   254,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,     0,     0,
       0,     0,    90,     0,     0,     0,     0,     0,     0,     0,
      91,    92,    93,    94,    95,    96,     0,     0,    90,     0,
       2,     0,     3,     0,     0,   405,    91,    92,    93,    94,
      95,    96,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   422,     2,    55,     3,    78,    79,    80,    81,    82,
      83,    84,     0,     0,     0,     0,     5,     6,     0,     0,
       0,     0,     7,     8,     0,     0,     0,     0,     0,     0,
      12,    85,    86,    13,     0,    87,    15,     0,     5,     6,
      18,    19,    20,    21,     7,   154,     0,     0,     0,     0,
       0,     0,    12,     0,     0,    13,    89,     0,    15,     0,
       0,     0,    18,    19,    20,    21,     2,    55,     3,    78,
      79,    80,    81,    82,    83,    84,     0,    90,     0,   256,
       0,     0,     0,     0,     0,    91,    92,    93,    94,    95,
      96,     0,     0,     0,     0,    85,    86,     0,     0,    87,
       0,     0,     5,     6,     0,     0,     0,     0,     7,   154,
       0,     0,     0,     0,     0,     0,    12,     0,     0,    13,
      89,     0,    15,     0,     0,     0,    18,    19,    20,    21,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,    90,     0,     0,     0,     0,     0,     0,     0,    91,
      92,    93,    94,    95,    96,     0,     0,     0,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     2,     0,     3,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,   220,   412,   321,     0,
     322,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       5,     6,    87,     0,     0,     0,     7,     8,     0,     0,
       0,     0,    88,     0,    12,     0,     0,    13,     0,     0,
      15,     0,     0,    89,    18,    19,    20,    21,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,   237,     0,    90,     0,   220,     0,   321,     0,
     322,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,   232,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,     0,     0,     0,   233,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     2,     0,     3,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,   220,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       5,     6,    87,     0,     0,     0,     7,     8,     0,     0,
       0,     0,    88,     0,    12,     0,     0,    13,     0,     0,
      15,     0,     0,    89,    18,    19,    20,    21,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,   342,     0,    90,   281,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,     0,     0,     0,   359,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,     0,     0,     0,   399,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,   419,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,   430,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,   432,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,   442,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,   149,     0,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
      55,     0,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,    90,     0,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,    85,    86,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     2,    55,     3,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,     0,
       0,     0,     0,     0,   258,     0,     0,     0,     0,     0,
       0,     0,    91,    92,    93,    94,    95,    96,     4,     0,
       0,     0,     5,     6,     0,     0,     0,     0,     7,     8,
       9,     0,     0,     0,    10,    11,    12,     0,     0,    13,
       0,    14,    15,     0,    16,    17,    18,    19,    20,    21,
       2,     0,     3,     0,     0,     0,     0,     0,     0,     0,
     225,   328,   356,     0,     0,   275,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     5,     6,     0,     0,
       0,     0,     7,     8,     9,     2,     0,     3,    10,    11,
      12,     0,     0,    13,     0,    14,    15,     0,    16,    17,
      18,    19,    20,    21,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   274,   356,     4,     0,   275,
       0,     5,     6,     0,    57,     0,     0,     7,     8,     9,
       0,     0,     0,    10,    11,    12,     0,     0,    13,     0,
      14,    15,     0,    16,    17,    18,    19,    20,    21,     2,
      55,     3,     0,     0,     0,     0,     0,     0,     0,   225,
       0,     0,   122,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     5,     6,     0,     0,     0,
       0,     7,     8,     9,     0,     0,     0,    10,    11,    12,
       0,     0,    13,     0,    14,    15,     0,    16,    17,    18,
      19,    20,    21,     2,     0,     3,     0,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     5,
       6,     0,     0,     0,     0,     7,     8,     9,     0,     0,
       0,    10,    11,    12,     0,     0,    13,     0,    14,    15,
       0,    16,    17,    18,    19,    20,    21,     2,     0,     3,
       0,     0,     0,     0,     0,     0,     0,   225,     0,   397,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     4,
       2,     0,     3,     5,     6,     0,     0,     0,     0,     7,
       8,     9,     0,     0,     0,    10,    11,    12,     0,     0,
      13,     0,    14,    15,     0,    16,    17,    18,    19,    20,
      21,     0,     4,     0,     0,     0,     5,     6,     0,     0,
       0,     0,     7,     8,     9,     0,     0,     0,    10,    11,
      12,     0,     0,    13,     0,    14,    15,     0,    16,    17,
      18,    19,    20,    21
};

static const yytype_int16 yycheck[] =
{
      35,    64,     0,   123,   214,    40,    35,    42,    90,    57,
     132,   128,     0,    40,    40,    42,    42,     4,   276,    78,
      85,    56,    78,    82,    90,    50,    13,    50,    85,    64,
       4,     4,     5,    67,    80,     4,   101,     4,    36,   194,
      38,   102,    77,     4,   101,    43,    44,   159,    46,   131,
       4,     4,    85,   135,    22,    23,    90,    85,    46,    80,
      85,    86,    87,    82,    89,    84,    62,   149,   101,    31,
     152,   119,   330,   101,    62,    81,    79,   102,    78,    85,
     146,   100,    85,   149,   239,   120,   152,   122,   154,     4,
     125,   120,    79,   128,     4,   122,   125,   131,   132,   134,
     166,   135,   136,   138,    78,   134,    78,    80,   169,   170,
     171,   159,    81,    87,    81,   149,   228,    78,   152,   144,
     145,   187,   244,    78,    78,    78,    87,   101,    82,   164,
     128,   127,   167,    87,     4,   201,    98,   164,   164,   127,
     167,   167,   352,    13,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   197,    78,   199,    10,   321,    82,    78,   194,
     197,   194,   199,   199,    28,    29,   258,    87,    85,   214,
     228,     4,     5,    85,    85,    79,   341,   214,   254,    99,
     345,    85,   258,   228,   101,   123,    83,    99,    85,   228,
     101,   129,    14,    15,    16,    17,    18,    19,    20,    21,
     244,   246,    24,    25,   239,   250,   239,   149,   279,    79,
     152,   256,    87,    85,   258,    85,   274,    92,    93,   256,
      40,    88,    89,    32,    33,    34,    46,   165,   197,   101,
      94,    95,    79,    53,   310,   362,   312,    79,    85,   315,
     316,    78,    86,    85,   279,    82,    66,    80,    96,    79,
      87,    97,    79,    79,   384,    85,    79,   330,    85,    85,
      81,    78,    85,   308,    85,    82,   274,    87,    79,    78,
     328,   308,   317,    82,    85,    84,    30,   322,   100,    79,
     317,    79,   220,   328,     4,   330,   321,    85,   321,    79,
     335,    85,   368,    79,   339,    85,   372,   235,    79,    85,
     339,    78,   347,    79,    85,    82,   341,   352,   341,    81,
     345,    80,   345,    85,    79,   352,   176,   177,   178,   179,
     328,    26,    27,   101,   369,   333,     4,     5,   404,   405,
     100,   407,   369,   271,   101,   273,    99,   275,    78,   308,
     172,   173,    78,   174,   175,   421,   422,    78,   317,    78,
      99,   180,   181,    99,   362,    99,    57,    83,   434,   100,
      99,    79,    79,   408,   409,   410,    67,    79,    79,    85,
      67,   408,   409,   410,   419,    99,   101,    83,    44,    79,
      83,    83,   419,    78,   429,   430,    79,   432,   101,    90,
     435,    83,   429,   430,   439,   432,   441,   442,   435,   182,
     369,   183,   439,   448,   441,   442,   185,   339,   136,   184,
     120,   448,   186,   383,   333,   256,   139,   138,   119,   326,
      46,    -1,   250,    -1,    -1,   363,    -1,    -1,   366,    -1,
     131,   132,    -1,    -1,   135,   136,    -1,    -1,    -1,   408,
     409,   410,    -1,    -1,    -1,   383,   384,    -1,   149,    -1,
     419,   152,     0,     1,    -1,     3,    -1,     5,    -1,    -1,
     429,   430,    -1,   432,    -1,    -1,   435,    -1,    -1,    -1,
     439,    -1,   441,   442,    -1,    -1,    -1,    -1,    -1,   448,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    40,    -1,    -1,    -1,    -1,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    53,    -1,    -1,    56,    -1,
      58,    59,    -1,    61,    62,    63,    64,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
       1,    -1,     3,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,    -1,    -1,    -1,   258,    -1,    -1,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    40,
      -1,    -1,    -1,    -1,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    53,    -1,    -1,    56,    -1,    58,    59,    -1,
      61,    62,    63,    64,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,    -1,    -1,    -1,    -1,    -1,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    -1,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    87,    88,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   101,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    -1,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      87,    88,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    -1,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    87,
      88,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      -1,    80,    -1,    -1,    -1,    -1,    -1,    86,    87,    88,
      89,    90,    91,     4,     5,     6,     7,     8,     9,    10,
      11,    12,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    32,    33,    -1,    -1,    36,    37,    38,    -1,    -1,
      41,    42,    43,    -1,    -1,    46,    -1,    48,    49,    50,
      -1,    -1,    -1,    54,    -1,    -1,    57,    -1,    -1,    60,
       3,    -1,     5,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    -1,    80,
      -1,    -1,    -1,    -1,    -1,    86,    87,    88,    89,    90,
      91,    -1,    35,    -1,    -1,    -1,    39,    40,    -1,    -1,
     101,    -1,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      53,    -1,    -1,    56,    -1,    58,    59,    -1,    61,    62,
      63,    64,    65,    66,     4,    -1,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    80,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    32,    33,    -1,    -1,    36,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    78,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    87,    88,    89,
      90,    91,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,   101,    86,    87,    88,    89,    90,    91,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,   101,    -1,    -1,
      -1,    -1,    -1,    -1,     4,    -1,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    32,    33,    -1,    -1,
      36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    32,    33,    -1,    -1,    36,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    46,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    87,    88,    89,    90,    91,    -1,    -1,    78,    -1,
       3,    -1,     5,    -1,    -1,   101,    86,    87,    88,    89,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    39,    40,    -1,    -1,
      -1,    -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,
      53,    32,    33,    56,    -1,    36,    59,    -1,    39,    40,
      63,    64,    65,    66,    45,    46,    -1,    -1,    -1,    -1,
      -1,    -1,    53,    -1,    -1,    56,    57,    -1,    59,    -1,
      -1,    -1,    63,    64,    65,    66,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    78,    -1,    80,
      -1,    -1,    -1,    -1,    -1,    86,    87,    88,    89,    90,
      91,    -1,    -1,    -1,    -1,    32,    33,    -1,    -1,    36,
      -1,    -1,    39,    40,    -1,    -1,    -1,    -1,    45,    46,
      -1,    -1,    -1,    -1,    -1,    -1,    53,    -1,    -1,    56,
      57,    -1,    59,    -1,    -1,    -1,    63,    64,    65,    66,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      87,    88,    89,    90,    91,    -1,    -1,    -1,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,     3,    -1,     5,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    80,    81,    82,    -1,
      84,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      39,    40,    36,    -1,    -1,    -1,    45,    46,    -1,    -1,
      -1,    -1,    46,    -1,    53,    -1,    -1,    56,    -1,    -1,
      59,    -1,    -1,    57,    63,    64,    65,    66,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    81,    -1,    78,    -1,    80,    -1,    82,    -1,
      84,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,     3,    -1,     5,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    80,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      39,    40,    36,    -1,    -1,    -1,    45,    46,    -1,    -1,
      -1,    -1,    46,    -1,    53,    -1,    -1,    56,    -1,    -1,
      59,    -1,    -1,    57,    63,    64,    65,    66,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    81,    -1,    78,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    32,    33,
      -1,    -1,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,     3,     4,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    87,    88,    89,    90,    91,    35,    -1,
      -1,    -1,    39,    40,    -1,    -1,    -1,    -1,    45,    46,
      47,    -1,    -1,    -1,    51,    52,    53,    -1,    -1,    56,
      -1,    58,    59,    -1,    61,    62,    63,    64,    65,    66,
       3,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    78,    79,    -1,    -1,    82,    -1,    -1,    -1,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    40,    -1,    -1,
      -1,    -1,    45,    46,    47,     3,    -1,     5,    51,    52,
      53,    -1,    -1,    56,    -1,    58,    59,    -1,    61,    62,
      63,    64,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    79,    35,    -1,    82,
      -1,    39,    40,    -1,    87,    -1,    -1,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    53,    -1,    -1,    56,    -1,
      58,    59,    -1,    61,    62,    63,    64,    65,    66,     3,
       4,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,
      -1,    -1,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    39,    40,    -1,    -1,    -1,
      -1,    45,    46,    47,    -1,    -1,    -1,    51,    52,    53,
      -1,    -1,    56,    -1,    58,    59,    -1,    61,    62,    63,
      64,    65,    66,     3,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    13,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,
      40,    -1,    -1,    -1,    -1,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    53,    -1,    -1,    56,    -1,    58,    59,
      -1,    61,    62,    63,    64,    65,    66,     3,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,
       3,    -1,     5,    39,    40,    -1,    -1,    -1,    -1,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    53,    -1,    -1,
      56,    -1,    58,    59,    -1,    61,    62,    63,    64,    65,
      66,    -1,    35,    -1,    -1,    -1,    39,    40,    -1,    -1,
      -1,    -1,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      53,    -1,    -1,    56,    -1,    58,    59,    -1,    61,    62,
      63,    64,    65,    66
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,    35,    39,    40,    45,    46,    47,
      51,    52,    53,    56,    58,    59,    61,    62,    63,    64,
      65,    66,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,   101,   127,   128,   129,   132,   133,   134,   135,
     136,   142,   143,   148,   149,   160,   175,   176,   177,   179,
     180,   182,   183,   184,   185,     4,    78,    87,   101,   105,
     130,   131,   150,   151,   152,   129,   129,    80,   105,   106,
     160,    80,   106,   129,   129,     0,   176,    78,     6,     7,
       8,     9,    10,    11,    12,    32,    33,    36,    46,    57,
      78,    86,    87,    88,    89,    90,    91,   103,   104,   105,
     107,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   126,   150,   148,   152,   153,
      85,   101,    80,   100,   127,   129,   168,   178,    78,    82,
     151,   134,   137,   138,   139,   148,    80,   145,   146,    80,
      13,    79,   105,   181,    78,    78,    78,   109,   109,    78,
     109,    78,    78,   109,    46,   109,   122,   123,   125,   139,
     157,    10,    32,    33,    34,    78,    82,    84,   111,    87,
      92,    93,    88,    89,    22,    23,    28,    29,    94,    95,
      26,    27,    86,    96,    97,    30,    31,    98,    79,   148,
     152,   131,   150,    37,    38,    41,    42,    43,    48,    49,
      50,    54,    60,    67,    81,   101,   105,   106,   125,   127,
     160,   166,   167,   168,   169,   170,   171,   172,   173,   174,
      80,   123,   161,   127,   168,    13,    79,   105,   129,   154,
     155,   156,    58,    83,   123,   144,   139,    81,   138,    99,
     140,   141,   150,   139,   137,    81,    85,   105,   147,   145,
      85,    79,   109,   109,    46,   157,    80,   157,    78,   125,
      14,    15,    16,    17,    18,    19,    20,    21,    24,    25,
     100,   124,    79,    85,    78,    82,   152,   158,   159,    79,
     106,    79,   108,   123,   125,   106,   111,   111,   111,   112,
     112,   113,   113,   114,   114,   114,   114,   115,   115,   116,
     117,   118,   119,   120,   125,   101,   126,   101,    99,   166,
      78,   106,    78,   101,   125,    78,    78,    99,   101,    81,
     170,    82,    84,   161,   162,   163,   164,   165,    78,   150,
     152,   158,    79,    85,    79,    85,    83,   123,   126,    85,
     101,    99,    81,    81,   147,   100,    81,    85,   181,    79,
      79,    79,   169,    79,   123,   123,    79,   154,   158,    83,
     123,   159,    78,    82,   111,    79,    85,    83,    99,    99,
     166,    67,   101,   125,   101,   125,   101,   125,   125,   166,
     126,   105,    81,    85,   100,   165,   155,   105,    83,   141,
     126,   126,    81,    81,    79,    79,    83,    79,   154,    83,
     123,   123,   125,   166,    78,   101,   125,   101,    79,    79,
      79,    83,    81,   163,   161,    79,    79,    83,   125,    79,
     125,   101,   101,   125,   166,   166,   166,    79,   166,    79,
      79,   125,    79,   125,   101,    44,   101,   166,   166,    79,
     166,    79,    79,   125,   166,   166,   166,   166,    79,   166
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   102,   103,   103,   103,   103,   103,   103,   103,   103,
     104,   104,   105,   106,   106,   107,   107,   107,   107,   107,
     107,   107,   107,   108,   108,   109,   109,   109,   109,   109,
     109,   109,   109,   109,   109,   110,   110,   110,   110,   110,
     110,   111,   111,   112,   112,   112,   112,   113,   113,   113,
     114,   114,   114,   115,   115,   115,   115,   115,   116,   116,
     116,   117,   117,   118,   118,   119,   119,   120,   120,   121,
     121,   122,   122,   123,   123,   124,   124,   124,   124,   124,
     124,   124,   124,   124,   124,   124,   125,   125,   125,   126,
     127,   127,   128,   129,   129,   129,   129,   129,   129,   129,
     129,   130,   130,   131,   131,   132,   132,   132,   132,   132,
     132,   133,   134,   134,   134,   134,   134,   134,   134,   134,
     135,   135,   135,   136,   136,   137,   137,   138,   139,   139,
     139,   139,   140,   140,   141,   141,   141,   141,   142,   142,
     142,   142,   142,   143,   144,   146,   145,   145,   147,   147,
     148,   148,   148,   148,   149,   150,   150,   151,   151,   151,
     151,   151,   151,   151,   151,   152,   152,   152,   152,   153,
     153,   154,   154,   155,   155,   155,   155,   156,   156,   157,
     157,   158,   158,   158,   159,   159,   159,   159,   159,   159,
     159,   159,   159,   160,   161,   161,   161,   162,   162,   163,
     163,   164,   164,   165,   165,   166,   166,   166,   166,   166,
     166,   167,   167,   167,   168,   168,   169,   169,   170,   170,
     171,   171,   172,   172,   172,   173,   173,   173,   173,   173,
     173,   173,   173,   173,   173,   174,   174,   174,   174,   174,
     175,   175,   176,   176,   176,   176,   177,   177,   178,   178,
     179,   180,   181,   181,   181,   182,   182,   183,   184,   184,
     184,   184,   184,   184,   184,   184,   185,   185,   185,   185
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     2,     1,     1,     1,     1,     4,     4,     3,     3,
       3,     2,     2,     1,     3,     1,     2,     2,     2,     4,
       4,     2,     4,     2,     4,     1,     1,     1,     1,     1,
       1,     1,     4,     1,     3,     3,     3,     1,     3,     3,
       1,     3,     3,     1,     3,     3,     3,     3,     1,     3,
       3,     1,     3,     1,     3,     1,     3,     1,     3,     1,
       3,     1,     5,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     1,
       3,     2,     1,     2,     1,     2,     1,     2,     1,     2,
       1,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     4,     2,     1,     1,     1,     2,     3,     2,     1,
       2,     1,     1,     3,     0,     1,     2,     3,     5,     4,
       6,     5,     2,     1,     1,     0,     2,     3,     1,     3,
       1,     1,     1,     1,     1,     2,     1,     1,     3,     5,
       4,     3,     4,     4,     3,     2,     1,     3,     2,     1,
       2,     1,     3,     2,     2,     1,     1,     1,     3,     1,
       2,     1,     1,     2,     3,     2,     3,     3,     4,     2,
       3,     3,     4,     1,     1,     3,     4,     1,     3,     3,
       1,     1,     2,     3,     2,     1,     1,     1,     1,     1,
       1,     3,     4,     3,     2,     3,     1,     2,     1,     1,
       1,     2,     5,     7,     5,     5,     7,     6,     7,     7,
       8,     7,     8,     8,     9,     3,     2,     2,     2,     3,
       1,     2,     1,     1,     1,     1,     4,     3,     1,     2,
       1,     1,     1,     1,     3,     4,     3,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, GISourceScanner* scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, GISourceScanner* scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (GISourceScanner* scanner)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* primary_expression: identifier  */
#line 350 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = g_hash_table_lookup (scanner->const_table, (yyvsp[0].str));
		if ((yyval.symbol) == NULL) {
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		} else {
			(yyval.symbol) = gi_source_symbol_ref ((yyval.symbol));
		}
	  }
#line 2583 "giscanner/scannerparser.c"
    break;

  case 3: /* primary_expression: INTEGER  */
#line 359 "../gobject-introspection/giscanner/scannerparser.y"
          {
		char *rest;
		guint64 value;
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if (g_str_has_prefix (yytext, "0x") && strlen (yytext) > 2) {
			value = g_ascii_strtoull (yytext + 2, &rest, 16);
		} else if (g_str_has_prefix (yytext, "0") && strlen (yytext) > 1) {
			value = g_ascii_strtoull (yytext + 1, &rest, 8);
		} else {
			value = g_ascii_strtoull (yytext, &rest, 10);
		}
		(yyval.symbol)->const_int = value;
		(yyval.symbol)->const_int_is_unsigned = (rest && (rest[0] == 'U'));
	  }
#line 2603 "giscanner/scannerparser.c"
    break;

  case 4: /* primary_expression: BOOLEAN  */
#line 375 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_boolean_set = TRUE;
		(yyval.symbol)->const_boolean = g_ascii_strcasecmp (yytext, "true") == 0 ? TRUE : FALSE;
	  }
#line 2613 "giscanner/scannerparser.c"
    break;

  case 5: /* primary_expression: CHARACTER  */
#line 381 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = g_utf8_get_char(yytext + 1);
	  }
#line 2623 "giscanner/scannerparser.c"
    break;

  case 6: /* primary_expression: FLOATING  */
#line 387 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_double_set = TRUE;
		(yyval.symbol)->const_double = 0.0;
        sscanf (yytext, "%lf", &((yyval.symbol)->const_double));
	  }
#line 2634 "giscanner/scannerparser.c"
    break;

  case 8: /* primary_expression: '(' expression ')'  */
#line 395 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 2642 "giscanner/scannerparser.c"
    break;

  case 9: /* primary_expression: EXTENSION '(' '{' block_item_list '}' ')'  */
#line 399 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2650 "giscanner/scannerparser.c"
    break;

  case 10: /* strings: STRING  */
#line 407 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		yytext[strlen (yytext) - 1] = '\0';
		(yyval.symbol)->const_string = parse_c_string_literal (yytext + 1);
                if (!g_utf8_validate ((yyval.symbol)->const_string, -1, NULL))
                  {
#if 0
                    g_warning ("Ignoring non-UTF-8 constant string \"%s\"", yytext + 1);
#endif
                    g_free((yyval.symbol)->const_string);
                    (yyval.symbol)->const_string = NULL;
                  }

	  }
#line 2669 "giscanner/scannerparser.c"
    break;

  case 11: /* strings: strings STRING  */
#line 422 "../gobject-introspection/giscanner/scannerparser.y"
          {
		char *strings, *string2;
		(yyval.symbol) = (yyvsp[-1].symbol);
		yytext[strlen (yytext) - 1] = '\0';
		string2 = parse_c_string_literal (yytext + 1);
		strings = g_strconcat ((yyval.symbol)->const_string, string2, NULL);
		g_free ((yyval.symbol)->const_string);
		g_free (string2);
		(yyval.symbol)->const_string = strings;
	  }
#line 2684 "giscanner/scannerparser.c"
    break;

  case 12: /* identifier: "identifier"  */
#line 436 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 2692 "giscanner/scannerparser.c"
    break;

  case 16: /* postfix_expression: postfix_expression '[' expression ']'  */
#line 449 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2700 "giscanner/scannerparser.c"
    break;

  case 17: /* postfix_expression: postfix_expression '(' argument_expression_list ')'  */
#line 453 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2708 "giscanner/scannerparser.c"
    break;

  case 18: /* postfix_expression: postfix_expression '(' ')'  */
#line 457 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2716 "giscanner/scannerparser.c"
    break;

  case 19: /* postfix_expression: postfix_expression '.' identifier_or_typedef_name  */
#line 461 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2724 "giscanner/scannerparser.c"
    break;

  case 20: /* postfix_expression: postfix_expression ARROW identifier_or_typedef_name  */
#line 465 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2732 "giscanner/scannerparser.c"
    break;

  case 21: /* postfix_expression: postfix_expression PLUSPLUS  */
#line 469 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2740 "giscanner/scannerparser.c"
    break;

  case 22: /* postfix_expression: postfix_expression MINUSMINUS  */
#line 473 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2748 "giscanner/scannerparser.c"
    break;

  case 26: /* unary_expression: PLUSPLUS unary_expression  */
#line 486 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2756 "giscanner/scannerparser.c"
    break;

  case 27: /* unary_expression: MINUSMINUS unary_expression  */
#line 490 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2764 "giscanner/scannerparser.c"
    break;

  case 28: /* unary_expression: unary_operator cast_expression  */
#line 494 "../gobject-introspection/giscanner/scannerparser.y"
          {
		switch ((yyvsp[-1].unary_operator)) {
		case UNARY_PLUS:
			(yyval.symbol) = (yyvsp[0].symbol);
			break;
		case UNARY_MINUS:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = -(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_BITWISE_COMPLEMENT:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = ~(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_LOGICAL_NEGATION:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = !gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
			break;
		default:
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
			break;
		}
	  }
#line 2791 "giscanner/scannerparser.c"
    break;

  case 29: /* unary_expression: INTL_CONST '(' unary_expression ')'  */
#line 517 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ((yyval.symbol)->const_int_is_unsigned ? "guint64" : "gint64");
		}
	  }
#line 2802 "giscanner/scannerparser.c"
    break;

  case 30: /* unary_expression: INTUL_CONST '(' unary_expression ')'  */
#line 524 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ("guint64");
		}
	  }
#line 2813 "giscanner/scannerparser.c"
    break;

  case 31: /* unary_expression: ALIGNOF unary_expression  */
#line 531 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2821 "giscanner/scannerparser.c"
    break;

  case 32: /* unary_expression: ALIGNOF '(' type_name ')'  */
#line 535 "../gobject-introspection/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2830 "giscanner/scannerparser.c"
    break;

  case 33: /* unary_expression: SIZEOF unary_expression  */
#line 540 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2838 "giscanner/scannerparser.c"
    break;

  case 34: /* unary_expression: SIZEOF '(' type_name ')'  */
#line 544 "../gobject-introspection/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2847 "giscanner/scannerparser.c"
    break;

  case 35: /* unary_operator: '&'  */
#line 552 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_ADDRESS_OF;
	  }
#line 2855 "giscanner/scannerparser.c"
    break;

  case 36: /* unary_operator: '*'  */
#line 556 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_POINTER_INDIRECTION;
	  }
#line 2863 "giscanner/scannerparser.c"
    break;

  case 37: /* unary_operator: '+'  */
#line 560 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_PLUS;
	  }
#line 2871 "giscanner/scannerparser.c"
    break;

  case 38: /* unary_operator: '-'  */
#line 564 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_MINUS;
	  }
#line 2879 "giscanner/scannerparser.c"
    break;

  case 39: /* unary_operator: '~'  */
#line 568 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_BITWISE_COMPLEMENT;
	  }
#line 2887 "giscanner/scannerparser.c"
    break;

  case 40: /* unary_operator: '!'  */
#line 572 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_LOGICAL_NEGATION;
	  }
#line 2895 "giscanner/scannerparser.c"
    break;

  case 42: /* cast_expression: '(' type_name ')' cast_expression  */
#line 580 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		if ((yyval.symbol)->const_int_set || (yyval.symbol)->const_double_set || (yyval.symbol)->const_string != NULL) {
			(yyval.symbol)->base_type = (yyvsp[-2].ctype);
		} else {
			ctype_free ((yyvsp[-2].ctype));
		}
	  }
#line 2908 "giscanner/scannerparser.c"
    break;

  case 44: /* multiplicative_expression: multiplicative_expression '*' cast_expression  */
#line 593 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int * (yyvsp[0].symbol)->const_int;
	  }
#line 2918 "giscanner/scannerparser.c"
    break;

  case 45: /* multiplicative_expression: multiplicative_expression '/' cast_expression  */
#line 599 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int / (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2930 "giscanner/scannerparser.c"
    break;

  case 46: /* multiplicative_expression: multiplicative_expression '%' cast_expression  */
#line 607 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int % (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2942 "giscanner/scannerparser.c"
    break;

  case 48: /* additive_expression: additive_expression '+' multiplicative_expression  */
#line 619 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int + (yyvsp[0].symbol)->const_int;
	  }
#line 2952 "giscanner/scannerparser.c"
    break;

  case 49: /* additive_expression: additive_expression '-' multiplicative_expression  */
#line 625 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int - (yyvsp[0].symbol)->const_int;
	  }
#line 2962 "giscanner/scannerparser.c"
    break;

  case 51: /* shift_expression: shift_expression SL additive_expression  */
#line 635 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int << (yyvsp[0].symbol)->const_int;

		/* assume this is a bitfield/flags declaration
		 * if a left shift operator is sued in an enum value
                 * This mimics the glib-mkenum behavior.
		 */
		is_bitfield = TRUE;
	  }
#line 2978 "giscanner/scannerparser.c"
    break;

  case 52: /* shift_expression: shift_expression SR additive_expression  */
#line 647 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >> (yyvsp[0].symbol)->const_int;
	  }
#line 2988 "giscanner/scannerparser.c"
    break;

  case 54: /* relational_expression: relational_expression '<' shift_expression  */
#line 657 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int < (yyvsp[0].symbol)->const_int;
	  }
#line 2998 "giscanner/scannerparser.c"
    break;

  case 55: /* relational_expression: relational_expression '>' shift_expression  */
#line 663 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int > (yyvsp[0].symbol)->const_int;
	  }
#line 3008 "giscanner/scannerparser.c"
    break;

  case 56: /* relational_expression: relational_expression LTEQ shift_expression  */
#line 669 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int <= (yyvsp[0].symbol)->const_int;
	  }
#line 3018 "giscanner/scannerparser.c"
    break;

  case 57: /* relational_expression: relational_expression GTEQ shift_expression  */
#line 675 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >= (yyvsp[0].symbol)->const_int;
	  }
#line 3028 "giscanner/scannerparser.c"
    break;

  case 59: /* equality_expression: equality_expression EQ relational_expression  */
#line 685 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int == (yyvsp[0].symbol)->const_int;
	  }
#line 3038 "giscanner/scannerparser.c"
    break;

  case 60: /* equality_expression: equality_expression NOTEQ relational_expression  */
#line 691 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int != (yyvsp[0].symbol)->const_int;
	  }
#line 3048 "giscanner/scannerparser.c"
    break;

  case 62: /* and_expression: and_expression '&' equality_expression  */
#line 701 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int & (yyvsp[0].symbol)->const_int;
	  }
#line 3058 "giscanner/scannerparser.c"
    break;

  case 64: /* exclusive_or_expression: exclusive_or_expression '^' and_expression  */
#line 711 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int ^ (yyvsp[0].symbol)->const_int;
	  }
#line 3068 "giscanner/scannerparser.c"
    break;

  case 66: /* inclusive_or_expression: inclusive_or_expression '|' exclusive_or_expression  */
#line 721 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int | (yyvsp[0].symbol)->const_int;
	  }
#line 3078 "giscanner/scannerparser.c"
    break;

  case 68: /* logical_and_expression: logical_and_expression ANDAND inclusive_or_expression  */
#line 731 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) &&
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 3090 "giscanner/scannerparser.c"
    break;

  case 70: /* logical_or_expression: logical_or_expression OROR logical_and_expression  */
#line 743 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) ||
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 3102 "giscanner/scannerparser.c"
    break;

  case 72: /* conditional_expression: logical_or_expression '?' expression ':' expression  */
#line 755 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_get_const_boolean ((yyvsp[-4].symbol)) ? (yyvsp[-2].symbol) : (yyvsp[0].symbol);
	  }
#line 3110 "giscanner/scannerparser.c"
    break;

  case 74: /* assignment_expression: unary_expression assignment_operator assignment_expression  */
#line 763 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3118 "giscanner/scannerparser.c"
    break;

  case 88: /* expression: EXTENSION expression  */
#line 786 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3126 "giscanner/scannerparser.c"
    break;

  case 90: /* declaration: declaration_specifiers init_declarator_list ';'  */
#line 799 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GList *l;
		for (l = (yyvsp[-1].list); l != NULL; l = l->next) {
			GISourceSymbol *sym = l->data;
			gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
			if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF) {
				sym->type = CSYMBOL_TYPE_TYPEDEF;
			} else if (sym->base_type->type == CTYPE_FUNCTION) {
				sym->type = CSYMBOL_TYPE_FUNCTION;
			} else {
				sym->type = CSYMBOL_TYPE_OBJECT;
			}
			gi_source_scanner_add_symbol (scanner, sym);
			gi_source_symbol_unref (sym);
		}
		ctype_free ((yyvsp[-2].ctype));
	  }
#line 3148 "giscanner/scannerparser.c"
    break;

  case 91: /* declaration: declaration_specifiers ';'  */
#line 817 "../gobject-introspection/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
	  }
#line 3156 "giscanner/scannerparser.c"
    break;

  case 93: /* declaration_specifiers: storage_class_specifier declaration_specifiers  */
#line 827 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[-1].storage_class_specifier);
	  }
#line 3165 "giscanner/scannerparser.c"
    break;

  case 94: /* declaration_specifiers: storage_class_specifier  */
#line 832 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[0].storage_class_specifier);
	  }
#line 3174 "giscanner/scannerparser.c"
    break;

  case 95: /* declaration_specifiers: type_specifier declaration_specifiers  */
#line 837 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3183 "giscanner/scannerparser.c"
    break;

  case 97: /* declaration_specifiers: type_qualifier declaration_specifiers  */
#line 843 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3192 "giscanner/scannerparser.c"
    break;

  case 98: /* declaration_specifiers: type_qualifier  */
#line 848 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3201 "giscanner/scannerparser.c"
    break;

  case 99: /* declaration_specifiers: function_specifier declaration_specifiers  */
#line 853 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->function_specifier |= (yyvsp[-1].function_specifier);
	  }
#line 3210 "giscanner/scannerparser.c"
    break;

  case 100: /* declaration_specifiers: function_specifier  */
#line 858 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->function_specifier |= (yyvsp[0].function_specifier);
	  }
#line 3219 "giscanner/scannerparser.c"
    break;

  case 101: /* init_declarator_list: init_declarator  */
#line 866 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3227 "giscanner/scannerparser.c"
    break;

  case 102: /* init_declarator_list: init_declarator_list ',' init_declarator  */
#line 870 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3235 "giscanner/scannerparser.c"
    break;

  case 105: /* storage_class_specifier: TYPEDEF  */
#line 882 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_TYPEDEF;
	  }
#line 3243 "giscanner/scannerparser.c"
    break;

  case 106: /* storage_class_specifier: EXTERN  */
#line 886 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_EXTERN;
	  }
#line 3251 "giscanner/scannerparser.c"
    break;

  case 107: /* storage_class_specifier: STATIC  */
#line 890 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_STATIC;
	  }
#line 3259 "giscanner/scannerparser.c"
    break;

  case 108: /* storage_class_specifier: AUTO  */
#line 894 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_AUTO;
	  }
#line 3267 "giscanner/scannerparser.c"
    break;

  case 109: /* storage_class_specifier: REGISTER  */
#line 898 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_REGISTER;
	  }
#line 3275 "giscanner/scannerparser.c"
    break;

  case 110: /* storage_class_specifier: THREAD_LOCAL  */
#line 902 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_THREAD_LOCAL;
	  }
#line 3283 "giscanner/scannerparser.c"
    break;

  case 111: /* basic_type: BASIC_TYPE  */
#line 909 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3291 "giscanner/scannerparser.c"
    break;

  case 112: /* type_specifier: VOID  */
#line 916 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_VOID);
	  }
#line 3299 "giscanner/scannerparser.c"
    break;

  case 113: /* type_specifier: COMPLEX  */
#line 920 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("_Complex");
	  }
#line 3307 "giscanner/scannerparser.c"
    break;

  case 114: /* type_specifier: SIGNED  */
#line 924 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("signed");
	  }
#line 3315 "giscanner/scannerparser.c"
    break;

  case 115: /* type_specifier: UNSIGNED  */
#line 928 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("unsigned");
	  }
#line 3323 "giscanner/scannerparser.c"
    break;

  case 116: /* type_specifier: basic_type  */
#line 932 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_BASIC_TYPE);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3332 "giscanner/scannerparser.c"
    break;

  case 119: /* type_specifier: typedef_name  */
#line 939 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_typedef_new ((yyvsp[0].str));
		g_free ((yyvsp[0].str));
	  }
#line 3341 "giscanner/scannerparser.c"
    break;

  case 120: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name '{' struct_declaration_list '}'  */
#line 947 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym;
		(yyval.ctype) = (yyvsp[-4].ctype);
		(yyval.ctype)->name = (yyvsp[-3].str);
		(yyval.ctype)->child_list = (yyvsp[-1].list);

		sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		if ((yyval.ctype)->type == CTYPE_STRUCT) {
			sym->type = CSYMBOL_TYPE_STRUCT;
		} else if ((yyval.ctype)->type == CTYPE_UNION) {
			sym->type = CSYMBOL_TYPE_UNION;
		} else {
			g_assert_not_reached ();
		}
		sym->ident = g_strdup ((yyval.ctype)->name);
		sym->base_type = gi_source_type_copy ((yyval.ctype));
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	  }
#line 3365 "giscanner/scannerparser.c"
    break;

  case 121: /* struct_or_union_specifier: struct_or_union '{' struct_declaration_list '}'  */
#line 967 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-3].ctype);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
	  }
#line 3374 "giscanner/scannerparser.c"
    break;

  case 122: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name  */
#line 972 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3383 "giscanner/scannerparser.c"
    break;

  case 123: /* struct_or_union: STRUCT  */
#line 980 "../gobject-introspection/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_struct_new (NULL);
	  }
#line 3392 "giscanner/scannerparser.c"
    break;

  case 124: /* struct_or_union: UNION  */
#line 985 "../gobject-introspection/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_union_new (NULL);
	  }
#line 3401 "giscanner/scannerparser.c"
    break;

  case 126: /* struct_declaration_list: struct_declaration_list struct_declaration  */
#line 994 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_concat ((yyvsp[-1].list), (yyvsp[0].list));
	  }
#line 3409 "giscanner/scannerparser.c"
    break;

  case 127: /* struct_declaration: specifier_qualifier_list struct_declarator_list ';'  */
#line 1001 "../gobject-introspection/giscanner/scannerparser.y"
          {
	    GList *l;
	    (yyval.list) = NULL;
	    for (l = (yyvsp[-1].list); l != NULL; l = l->next)
	      {
		GISourceSymbol *sym = l->data;
		if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF)
		    sym->type = CSYMBOL_TYPE_TYPEDEF;
		else
		    sym->type = CSYMBOL_TYPE_MEMBER;
		gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
                sym->private = scanner->private;
                (yyval.list) = g_list_append ((yyval.list), sym);
	      }
	    ctype_free ((yyvsp[-2].ctype));
	  }
#line 3430 "giscanner/scannerparser.c"
    break;

  case 128: /* specifier_qualifier_list: type_specifier specifier_qualifier_list  */
#line 1021 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3439 "giscanner/scannerparser.c"
    break;

  case 130: /* specifier_qualifier_list: type_qualifier specifier_qualifier_list  */
#line 1027 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3448 "giscanner/scannerparser.c"
    break;

  case 131: /* specifier_qualifier_list: type_qualifier  */
#line 1032 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3457 "giscanner/scannerparser.c"
    break;

  case 132: /* struct_declarator_list: struct_declarator  */
#line 1040 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3465 "giscanner/scannerparser.c"
    break;

  case 133: /* struct_declarator_list: struct_declarator_list ',' struct_declarator  */
#line 1044 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3473 "giscanner/scannerparser.c"
    break;

  case 134: /* struct_declarator: %empty  */
#line 1051 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3481 "giscanner/scannerparser.c"
    break;

  case 136: /* struct_declarator: ':' constant_expression  */
#line 1056 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3489 "giscanner/scannerparser.c"
    break;

  case 137: /* struct_declarator: declarator ':' constant_expression  */
#line 1060 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		if ((yyvsp[0].symbol)->const_int_set) {
		  (yyval.symbol)->const_int_set = TRUE;
		  (yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		}
	  }
#line 3501 "giscanner/scannerparser.c"
    break;

  case 138: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list '}'  */
#line 1071 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-3].str));
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3512 "giscanner/scannerparser.c"
    break;

  case 139: /* enum_specifier: enum_keyword '{' enumerator_list '}'  */
#line 1078 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3523 "giscanner/scannerparser.c"
    break;

  case 140: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list ',' '}'  */
#line 1085 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-4].str));
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3534 "giscanner/scannerparser.c"
    break;

  case 141: /* enum_specifier: enum_keyword '{' enumerator_list ',' '}'  */
#line 1092 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3545 "giscanner/scannerparser.c"
    break;

  case 142: /* enum_specifier: enum_keyword identifier_or_typedef_name  */
#line 1099 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[0].str));
	  }
#line 3553 "giscanner/scannerparser.c"
    break;

  case 143: /* enum_keyword: ENUM  */
#line 1106 "../gobject-introspection/giscanner/scannerparser.y"
          {
                scanner->flags = FALSE;
                scanner->private = FALSE;
          }
#line 3562 "giscanner/scannerparser.c"
    break;

  case 144: /* static_keyword: STATIC  */
#line 1114 "../gobject-introspection/giscanner/scannerparser.y"
          {
          }
#line 3569 "giscanner/scannerparser.c"
    break;

  case 145: /* $@1: %empty  */
#line 1120 "../gobject-introspection/giscanner/scannerparser.y"
          {
		/* reset flag before the first enum value */
		is_bitfield = FALSE;
	  }
#line 3578 "giscanner/scannerparser.c"
    break;

  case 146: /* enumerator_list: $@1 enumerator  */
#line 1125 "../gobject-introspection/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3587 "giscanner/scannerparser.c"
    break;

  case 147: /* enumerator_list: enumerator_list ',' enumerator  */
#line 1130 "../gobject-introspection/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3596 "giscanner/scannerparser.c"
    break;

  case 148: /* enumerator: identifier  */
#line 1138 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = ++last_enum_value;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3608 "giscanner/scannerparser.c"
    break;

  case 149: /* enumerator: identifier '=' constant_expression  */
#line 1146 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[-2].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		last_enum_value = (yyval.symbol)->const_int;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3621 "giscanner/scannerparser.c"
    break;

  case 150: /* type_qualifier: CONST  */
#line 1158 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_CONST;
	  }
#line 3629 "giscanner/scannerparser.c"
    break;

  case 151: /* type_qualifier: RESTRICT  */
#line 1162 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_RESTRICT;
	  }
#line 3637 "giscanner/scannerparser.c"
    break;

  case 152: /* type_qualifier: EXTENSION  */
#line 1166 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_EXTENSION;
	  }
#line 3645 "giscanner/scannerparser.c"
    break;

  case 153: /* type_qualifier: VOLATILE  */
#line 1170 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_VOLATILE;
	  }
#line 3653 "giscanner/scannerparser.c"
    break;

  case 154: /* function_specifier: INLINE  */
#line 1177 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.function_specifier) = FUNCTION_INLINE;
	  }
#line 3661 "giscanner/scannerparser.c"
    break;

  case 155: /* declarator: pointer direct_declarator  */
#line 1184 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3670 "giscanner/scannerparser.c"
    break;

  case 157: /* direct_declarator: identifier  */
#line 1193 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
	  }
#line 3679 "giscanner/scannerparser.c"
    break;

  case 158: /* direct_declarator: '(' declarator ')'  */
#line 1198 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3687 "giscanner/scannerparser.c"
    break;

  case 159: /* direct_declarator: direct_declarator '[' static_keyword assignment_expression ']'  */
#line 1202 "../gobject-introspection/giscanner/scannerparser.y"
          {
                (yyval.symbol) = (yyvsp[-4].symbol);
                gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
          }
#line 3696 "giscanner/scannerparser.c"
    break;

  case 160: /* direct_declarator: direct_declarator '[' assignment_expression ']'  */
#line 1207 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3705 "giscanner/scannerparser.c"
    break;

  case 161: /* direct_declarator: direct_declarator '[' ']'  */
#line 1212 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3714 "giscanner/scannerparser.c"
    break;

  case 162: /* direct_declarator: direct_declarator '(' parameter_list ')'  */
#line 1217 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3728 "giscanner/scannerparser.c"
    break;

  case 163: /* direct_declarator: direct_declarator '(' identifier_list ')'  */
#line 1227 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		func->child_list = (yyvsp[-1].list);
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3739 "giscanner/scannerparser.c"
    break;

  case 164: /* direct_declarator: direct_declarator '(' ')'  */
#line 1234 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3749 "giscanner/scannerparser.c"
    break;

  case 165: /* pointer: '*' type_qualifier_list  */
#line 1243 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
		(yyval.ctype)->type_qualifier = (yyvsp[0].type_qualifier);
	  }
#line 3758 "giscanner/scannerparser.c"
    break;

  case 166: /* pointer: '*'  */
#line 1248 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
	  }
#line 3766 "giscanner/scannerparser.c"
    break;

  case 167: /* pointer: '*' type_qualifier_list pointer  */
#line 1252 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(*base)->type_qualifier = (yyvsp[-1].type_qualifier);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3781 "giscanner/scannerparser.c"
    break;

  case 168: /* pointer: '*' pointer  */
#line 1263 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3795 "giscanner/scannerparser.c"
    break;

  case 170: /* type_qualifier_list: type_qualifier_list type_qualifier  */
#line 1277 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = (yyvsp[-1].type_qualifier) | (yyvsp[0].type_qualifier);
	  }
#line 3803 "giscanner/scannerparser.c"
    break;

  case 171: /* parameter_list: parameter_declaration  */
#line 1284 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3811 "giscanner/scannerparser.c"
    break;

  case 172: /* parameter_list: parameter_list ',' parameter_declaration  */
#line 1288 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3819 "giscanner/scannerparser.c"
    break;

  case 173: /* parameter_declaration: declaration_specifiers declarator  */
#line 1295 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3828 "giscanner/scannerparser.c"
    break;

  case 174: /* parameter_declaration: declaration_specifiers abstract_declarator  */
#line 1300 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3837 "giscanner/scannerparser.c"
    break;

  case 175: /* parameter_declaration: declaration_specifiers  */
#line 1305 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->base_type = (yyvsp[0].ctype);
	  }
#line 3846 "giscanner/scannerparser.c"
    break;

  case 176: /* parameter_declaration: ELLIPSIS  */
#line 1310 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
	  }
#line 3854 "giscanner/scannerparser.c"
    break;

  case 177: /* identifier_list: identifier  */
#line 1317 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3864 "giscanner/scannerparser.c"
    break;

  case 178: /* identifier_list: identifier_list ',' identifier  */
#line 1323 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append ((yyvsp[-2].list), sym);
	  }
#line 3874 "giscanner/scannerparser.c"
    break;

  case 181: /* abstract_declarator: pointer  */
#line 1337 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[0].ctype));
	  }
#line 3883 "giscanner/scannerparser.c"
    break;

  case 183: /* abstract_declarator: pointer direct_abstract_declarator  */
#line 1343 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3892 "giscanner/scannerparser.c"
    break;

  case 184: /* direct_abstract_declarator: '(' abstract_declarator ')'  */
#line 1351 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3900 "giscanner/scannerparser.c"
    break;

  case 185: /* direct_abstract_declarator: '[' ']'  */
#line 1355 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3909 "giscanner/scannerparser.c"
    break;

  case 186: /* direct_abstract_declarator: '[' assignment_expression ']'  */
#line 1360 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3918 "giscanner/scannerparser.c"
    break;

  case 187: /* direct_abstract_declarator: direct_abstract_declarator '[' ']'  */
#line 1365 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3927 "giscanner/scannerparser.c"
    break;

  case 188: /* direct_abstract_declarator: direct_abstract_declarator '[' assignment_expression ']'  */
#line 1370 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3936 "giscanner/scannerparser.c"
    break;

  case 189: /* direct_abstract_declarator: '(' ')'  */
#line 1375 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3946 "giscanner/scannerparser.c"
    break;

  case 190: /* direct_abstract_declarator: '(' parameter_list ')'  */
#line 1381 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3960 "giscanner/scannerparser.c"
    break;

  case 191: /* direct_abstract_declarator: direct_abstract_declarator '(' ')'  */
#line 1391 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3970 "giscanner/scannerparser.c"
    break;

  case 192: /* direct_abstract_declarator: direct_abstract_declarator '(' parameter_list ')'  */
#line 1397 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3984 "giscanner/scannerparser.c"
    break;

  case 193: /* typedef_name: "typedef-name"  */
#line 1410 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3992 "giscanner/scannerparser.c"
    break;

  case 250: /* function_macro: FUNCTION_MACRO  */
#line 1533 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 4000 "giscanner/scannerparser.c"
    break;

  case 251: /* object_macro: OBJECT_MACRO  */
#line 1540 "../gobject-introspection/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 4008 "giscanner/scannerparser.c"
    break;

  case 252: /* function_macro_argument_list: identifier  */
#line 1547 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 4018 "giscanner/scannerparser.c"
    break;

  case 253: /* function_macro_argument_list: ELLIPSIS  */
#line 1553 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 4027 "giscanner/scannerparser.c"
    break;

  case 254: /* function_macro_argument_list: identifier ',' function_macro_argument_list  */
#line 1558 "../gobject-introspection/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[-2].str);
		(yyval.list) = g_list_prepend ((yyvsp[0].list), sym);
	  }
#line 4037 "giscanner/scannerparser.c"
    break;

  case 255: /* function_macro_define: function_macro '(' function_macro_argument_list ')'  */
#line 1567 "../gobject-introspection/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-3].str));
		func->child_list = (yyvsp[-1].list);
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 4051 "giscanner/scannerparser.c"
    break;

  case 256: /* function_macro_define: function_macro '(' ')'  */
#line 1577 "../gobject-introspection/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-2].str));
		func->child_list = NULL;
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 4065 "giscanner/scannerparser.c"
    break;

  case 257: /* object_macro_define: object_macro constant_expression  */
#line 1590 "../gobject-introspection/giscanner/scannerparser.y"
          {
		if ((yyvsp[0].symbol)->const_int_set || (yyvsp[0].symbol)->const_boolean_set || (yyvsp[0].symbol)->const_double_set || (yyvsp[0].symbol)->const_string != NULL) {
			GISourceSymbol *macro = gi_source_symbol_copy ((yyvsp[0].symbol));
			g_free (macro->ident);
			macro->ident = (yyvsp[-1].str);
			gi_source_scanner_add_symbol (scanner, macro);
			gi_source_symbol_unref (macro);
			gi_source_symbol_unref ((yyvsp[0].symbol));
		} else {
			g_free ((yyvsp[-1].str));
			gi_source_symbol_unref ((yyvsp[0].symbol));
		}
	  }
#line 4083 "giscanner/scannerparser.c"
    break;

  case 258: /* preproc_conditional: IFDEF_GI_SCANNER  */
#line 1607 "../gobject-introspection/giscanner/scannerparser.y"
          {
		push_conditional (scanner, FOR_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 4092 "giscanner/scannerparser.c"
    break;

  case 259: /* preproc_conditional: IFNDEF_GI_SCANNER  */
#line 1612 "../gobject-introspection/giscanner/scannerparser.y"
          {
		push_conditional (scanner, NOT_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 4101 "giscanner/scannerparser.c"
    break;

  case 260: /* preproc_conditional: IFDEF_COND  */
#line 1617 "../gobject-introspection/giscanner/scannerparser.y"
          {
	 	warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4110 "giscanner/scannerparser.c"
    break;

  case 261: /* preproc_conditional: IFNDEF_COND  */
#line 1622 "../gobject-introspection/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4119 "giscanner/scannerparser.c"
    break;

  case 262: /* preproc_conditional: IF_COND  */
#line 1627 "../gobject-introspection/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4128 "giscanner/scannerparser.c"
    break;

  case 263: /* preproc_conditional: ELIF_COND  */
#line 1632 "../gobject-introspection/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		pop_conditional (scanner);
		push_conditional (scanner, IRRELEVANT);
		update_skipping (scanner);
	  }
#line 4139 "giscanner/scannerparser.c"
    break;

  case 264: /* preproc_conditional: ELSE_COND  */
#line 1639 "../gobject-introspection/giscanner/scannerparser.y"
          {
		toggle_conditional (scanner);
		update_skipping (scanner);
	  }
#line 4148 "giscanner/scannerparser.c"
    break;

  case 265: /* preproc_conditional: ENDIF_COND  */
#line 1644 "../gobject-introspection/giscanner/scannerparser.y"
          {
		pop_conditional (scanner);
		update_skipping (scanner);
	  }
#line 4157 "giscanner/scannerparser.c"
    break;


#line 4161 "giscanner/scannerparser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 1657 "../gobject-introspection/giscanner/scannerparser.y"

static void
yyerror (GISourceScanner *scanner, const char *s)
{
  /* ignore errors while doing a macro scan as not all object macros
   * have valid expressions */
  if (!scanner->macro_scan)
    {
      gchar *error = g_strdup_printf ("%s:%d: %s in '%s' at '%s'",
          g_file_get_parse_name (scanner->current_file), lineno, s, linebuf, yytext);
      g_ptr_array_add (scanner->errors, error);
    }
}

static int
eat_hspace (FILE * f)
{
  int c;
  do
    {
      c = fgetc (f);
    }
  while (c == ' ' || c == '\t');
  return c;
}

static int
pass_line (FILE * f, int c,
           FILE *out)
{
  while (c != EOF && c != '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
    }
  if (c == '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
      if (c == ' ' || c == '\t')
        {
          c = eat_hspace (f);
        }
    }
  return c;
}

static int
eat_line (FILE * f, int c)
{
  return pass_line (f, c, NULL);
}

static int
read_identifier (FILE * f, int c, char **identifier)
{
  GString *id = g_string_new ("");
  while (g_ascii_isalnum (c) || c == '_')
    {
      g_string_append_c (id, c);
      c = fgetc (f);
    }
  *identifier = g_string_free (id, FALSE);
  return c;
}

static gboolean
parse_file (GISourceScanner *scanner, FILE *file)
{
  g_return_val_if_fail (file != NULL, FALSE);

  lineno = 1;
  yyin = file;
  yyparse (scanner);
  yyin = NULL;

  return TRUE;
}

void
gi_source_scanner_parse_macros (GISourceScanner *scanner, GList *filenames)
{
  GError *error = NULL;
  char *tmp_name = NULL;
  gint tmp_fd;
  FILE *fmacros;
  GList *l;

  tmp_fd = g_file_open_tmp ("gen-introspect-XXXXXX.h", &tmp_name, &error);

  if (tmp_fd == -1)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to create temporary file '%s' while parsing macros: %s", filename, tmp_name, error->message);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      g_error_free (error);
      return;
    }

  fmacros = fdopen (tmp_fd, "w+");

  if (!fmacros)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to open temporary file '%s' while parsing macros", filename, tmp_name);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      close (tmp_fd);
      g_unlink (tmp_name);
      g_free (tmp_name);
      return;
    }

  for (l = filenames; l != NULL; l = l->next)
    {
      FILE *f = fopen (l->data, "r");
      int line = 1;

      GString *define_line;
      char *str;
      gboolean error_line = FALSE;
      gboolean end_of_word;
      int c = eat_hspace (f);
      while (c != EOF)
        {
          if (c != '#')
            {
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }

          /* print current location */
          str = g_strescape (l->data, "");
          fprintf (fmacros, "# %d \"%s\"\n", line, str);
          g_free (str);

          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          end_of_word = (c == ' ' || c == '\t' || c == '\n' || c == EOF);
          if (end_of_word &&
              (g_str_equal (str, "if") ||
               g_str_equal (str, "endif") ||
               g_str_equal (str, "ifndef") ||
               g_str_equal (str, "ifdef") ||
               g_str_equal (str, "else") ||
               g_str_equal (str, "elif")))
            {
              fprintf (fmacros, "#%s ", str);
              g_free (str);
              c = pass_line (f, c, fmacros);
              line++;
              continue;
            }
          else if (strcmp (str, "define") != 0 || !end_of_word)
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          g_free (str);
          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strlen (str) == 0 || (c != ' ' && c != '\t' && c != '('))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          define_line = g_string_new ("#define ");
          g_string_append (define_line, str);
          g_free (str);
          if (c == '(')
            {
              while (c != ')')
                {
                  g_string_append_c (define_line, c);
                  c = fgetc (f);
                  if (c == EOF || c == '\n')
                    {
                      error_line = TRUE;
                      break;
                    }
                }
              if (error_line)
                {
                  g_string_free (define_line, TRUE);
                  /* ignore line */
                  c = eat_line (f, c);
                  line++;
                  continue;
                }

              g_assert (c == ')');
              g_string_append_c (define_line, c);
              c = fgetc (f);

              /* found function-like macro */
              fprintf (fmacros, "%s\n", define_line->str);

              g_string_free (define_line, TRUE);
              /* ignore rest of line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          if (c != ' ' && c != '\t')
            {
              g_string_free (define_line, TRUE);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          while (c != EOF && c != '\n')
            {
              g_string_append_c (define_line, c);
              c = fgetc (f);
              if (c == '\\')
                {
                  c = fgetc (f);
                  if (c == '\n')
                    {
                      /* fold lines when seeing backslash new-line sequence */
                      c = fgetc (f);
                    }
                  else
                    {
                      g_string_append_c (define_line, '\\');
                    }
                }
            }

          /* found object-like macro */
          fprintf (fmacros, "%s\n", define_line->str);

          c = eat_line (f, c);
          line++;
        }

      fclose (f);
    }

  rewind (fmacros);
  parse_file (scanner, fmacros);
  fclose (fmacros);
  g_unlink (tmp_name);
  g_free (tmp_name);
}

gboolean
gi_source_scanner_parse_file (GISourceScanner *scanner, const gchar *filename)
{
  FILE *file;
  gboolean result;

  file = g_fopen (filename, "r");
  result = parse_file (scanner, file);
  fclose (file);

  return result;
}

gboolean
gi_source_scanner_lex_filename (GISourceScanner *scanner, const gchar *filename)
{
  lineno = 1;
  yyin = g_fopen (filename, "r");

  while (yylex (scanner) != YYEOF)
    ;

  fclose (yyin);

  return TRUE;
}
