/* sound.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sound.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2023 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gsound.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SOUND (sound_get_type ())
#define SOUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOUND, Sound))
#define SOUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOUND, SoundClass))
#define IS_SOUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOUND))
#define IS_SOUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOUND))
#define SOUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOUND, SoundClass))

typedef struct _Sound Sound;
typedef struct _SoundClass SoundClass;
typedef struct _SoundPrivate SoundPrivate;
enum  {
	SOUND_0_PROPERTY,
	SOUND_NUM_PROPERTIES
};
static GParamSpec* sound_properties[SOUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Sound {
	GObject parent_instance;
	SoundPrivate * priv;
};

struct _SoundClass {
	GObjectClass parent_class;
};

struct _SoundPrivate {
	gboolean is_muted;
	gboolean is_initilised;
	gboolean errored;
	GSoundContext* sound_context;
};

static gint Sound_private_offset;
static gpointer sound_parent_class = NULL;

VALA_EXTERN GType sound_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sound, g_object_unref)
VALA_EXTERN Sound* sound_new (gboolean is_muted);
VALA_EXTERN Sound* sound_construct (GType object_type,
                        gboolean is_muted);
VALA_EXTERN void sound_set_muted (Sound* self,
                      gboolean muted);
VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
VALA_EXTERN void sound_connect_signal (Sound* self,
                           NibblesGame* game);
static void sound_play_sound (Sound* self,
                       const gchar* name);
static void _sound_play_sound_nibbles_game_play_sound (NibblesGame* _sender,
                                                const gchar* sound,
                                                gpointer self);
static gboolean sound_initilise_context (Sound* self);
static void sound_finalize (GObject * obj);
static GType sound_get_type_once (void);

static inline gpointer
sound_get_instance_private (Sound* self)
{
	return G_STRUCT_MEMBER_P (self, Sound_private_offset);
}

Sound*
sound_construct (GType object_type,
                 gboolean is_muted)
{
	Sound * self = NULL;
	self = (Sound*) g_object_new (object_type, NULL);
	sound_set_muted (self, is_muted);
	return self;
}

Sound*
sound_new (gboolean is_muted)
{
	return sound_construct (TYPE_SOUND, is_muted);
}

static void
_sound_play_sound_nibbles_game_play_sound (NibblesGame* _sender,
                                           const gchar* sound,
                                           gpointer self)
{
	sound_play_sound ((Sound*) self, sound);
}

void
sound_connect_signal (Sound* self,
                      NibblesGame* game)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_connect_object (game, "play-sound", (GCallback) _sound_play_sound_nibbles_game_play_sound, self, 0);
}

void
sound_set_muted (Sound* self,
                 gboolean muted)
{
	g_return_if_fail (self != NULL);
	self->priv->is_muted = muted;
}

static gboolean
sound_initilise_context (Sound* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GSoundContext* _tmp0_ = NULL;
		GSoundContext* _tmp1_;
		GSoundContext* _tmp2_;
		_tmp1_ = gsound_context_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GSOUND_ERROR) {
				goto __catch0_gsound_error;
			}
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->sound_context);
		self->priv->sound_context = _tmp2_;
		self->priv->is_initilised = TRUE;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_gsound_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("sound.vala:75: %s", _tmp4_);
		self->priv->errored = TRUE;
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("sound.vala:80: %s", _tmp6_);
		self->priv->errored = TRUE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = self->priv->is_initilised;
	return result;
}

static void
sound_play_sound (Sound* self,
                  const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (!self->priv->is_muted) {
		_tmp0_ = !self->priv->errored;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->is_initilised) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = sound_initilise_context (self);
		}
		if (_tmp1_) {
			gchar* filename = NULL;
			gchar* _tmp2_;
			_tmp2_ = g_strconcat (name, ".ogg", NULL);
			filename = _tmp2_;
			{
				GSoundContext* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp3_ = self->priv->sound_context;
				_tmp4_ = filename;
				_tmp5_ = filename;
				_tmp6_ = g_build_filename (SOUND_DIRECTORY, _tmp5_, NULL);
				_tmp7_ = _tmp6_;
				gsound_context_play_simple (_tmp3_, NULL, &_inner_error0_, GSOUND_ATTR_MEDIA_NAME, _tmp4_, GSOUND_ATTR_MEDIA_FILENAME, _tmp7_, NULL);
				_g_free0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GSOUND_ERROR) {
						goto __catch0_gsound_error;
					}
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_gsound_error:
			{
				GError* e = NULL;
				GError* _tmp8_;
				const gchar* _tmp9_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = e;
				_tmp9_ = _tmp8_->message;
				g_warning ("sound.vala:102: %s", _tmp9_);
				_g_error_free0 (e);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp10_;
				const gchar* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = e;
				_tmp11_ = _tmp10_->message;
				g_warning ("sound.vala:106: %s", _tmp11_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (filename);
		}
	}
}

static void
sound_class_init (SoundClass * klass,
                  gpointer klass_data)
{
	sound_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Sound_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sound_finalize;
}

static void
sound_instance_init (Sound * self,
                     gpointer klass)
{
	self->priv = sound_get_instance_private (self);
	self->priv->is_initilised = FALSE;
	self->priv->errored = FALSE;
}

static void
sound_finalize (GObject * obj)
{
	Sound * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND, Sound);
	_g_object_unref0 (self->priv->sound_context);
	G_OBJECT_CLASS (sound_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sound_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sound), 0, (GInstanceInitFunc) sound_instance_init, NULL };
	GType sound_type_id;
	sound_type_id = g_type_register_static (G_TYPE_OBJECT, "Sound", &g_define_type_info, 0);
	Sound_private_offset = g_type_add_instance_private (sound_type_id, sizeof (SoundPrivate));
	return sound_type_id;
}

GType
sound_get_type (void)
{
	static gsize sound_type_id__once = 0;
	if (g_once_init_enter (&sound_type_id__once)) {
		GType sound_type_id;
		sound_type_id = sound_get_type_once ();
		g_once_init_leave (&sound_type_id__once, sound_type_id);
	}
	return sound_type_id__once;
}

