/* gitg-repository-list-box.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012-2016 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include "ide.h"
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_REPOSITORY_LIST_BOX_0_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_MODE_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_LOCATION_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_HAS_SELECTION_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_bookmark_file_free0(var) ((var == NULL) ? NULL : (var = (g_bookmark_file_free (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _GitgRepositoryListBoxSendToTrashData GitgRepositoryListBoxSendToTrashData;
typedef struct _GitgRepositoryListBoxDeleteSourceData GitgRepositoryListBoxDeleteSourceData;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_0_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_MODE_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_SELECTED_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_NUM_PROPERTIES
};
static GParamSpec* gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_NUM_PROPERTIES];
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_tree_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_tree_entry_unref (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_REQUEST_REMOVE_SIGNAL,
	GITG_REPOSITORY_LIST_BOX_ROW_REQUEST_DELETE_SOURCE_SIGNAL,
	GITG_REPOSITORY_LIST_BOX_ROW_NUM_SIGNALS
};
static guint gitg_repository_list_box_row_signals[GITG_REPOSITORY_LIST_BOX_ROW_NUM_SIGNALS] = {0};
enum  {
	GITG_REPOSITORY_LIST_BOX_REPOSITORY_ACTIVATED_SIGNAL,
	GITG_REPOSITORY_LIST_BOX_SHOW_ERROR_SIGNAL,
	GITG_REPOSITORY_LIST_BOX_NUM_SIGNALS
};
static guint gitg_repository_list_box_signals[GITG_REPOSITORY_LIST_BOX_NUM_SIGNALS] = {0};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
	GitgSelectionMode _mode;
	gboolean _bookmarks_from_recent_files;
	GFile* d_location;
	guint d_save_repository_bookmarks_id;
	GBookmarkFile* d_bookmark_file;
};

struct _Block25Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GtkMessageDialog* alert_dialog;
	GFile* workdir;
	gchar* uri;
	GitgRepositoryListBoxRow* row;
};

struct _Block26Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	gchar* uri;
	GitgRepositoryListBoxRow* row;
};

struct _GitgRepositoryListBoxSendToTrashData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRepositoryListBox* self;
	GFile* file;
	GCancellable* cancellable;
	GError* e;
	GError* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _inner_error0_;
};

struct _GitgRepositoryListBoxDeleteSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRepositoryListBox* self;
	GFile* file;
	GCancellable* cancellable;
	GFileType dtype;
	GFileEnumerator* dir_in_repository;
	GFileEnumerator* _tmp0_;
	GList* content_infos;
	GList* _tmp1_;
	GFileEnumerator* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GList* file_cinfo_collection;
	GList* file_cinfo_it;
	GFileInfo* _tmp7_;
	GFileInfo* file_cinfo;
	GFile* files;
	GFileInfo* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _vala1_e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError* _inner_error0_;
};

struct _Block27Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GFile* workdir;
	GitgRepositoryListBoxRow* row;
};

struct _Block28Data {
	int _ref_count_;
	Block27Data * _data27_;
	gchar* uri;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	GitgProgressBin* d_progress_bin;
	GtkLabel* d_repository_label;
	GtkLabel* d_description_label;
	GtkLabel* d_branch_label;
	GtkSpinner* d_spinner;
	GtkCheckButton* d_remove_check_button;
	GtkRevealer* d_remove_revealer;
	GtkBox* d_languages_box;
	GitgSelectionMode d_mode;
	gchar* d_dirname;
	gchar* d_branch_name;
	gboolean _selected;
};

static gint GitgRepositoryListBox_private_offset;
static gpointer gitg_repository_list_box_parent_class = NULL;
static gint GitgRepositoryListBoxRow_private_offset;
static gpointer gitg_repository_list_box_row_parent_class = NULL;

static gboolean gitg_repository_list_box_save_repository_bookmarks (GitgRepositoryListBox* self);
static void gitg_repository_list_box_copy_bookmarks_from_recent_files (GitgRepositoryListBox* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static inline void _g_list_free__gtk_recent_info_unref0_ (GList* self);
static void gitg_repository_list_box_save_repository_bookmarks_timeout (GitgRepositoryListBox* self);
static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base,
                                                           GdkEventButton* event);
static void gitg_repository_list_box_real_row_activated (GtkListBox* base,
                                                  GtkListBoxRow* row);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self,
                                             GtkListBoxRow* row,
                                             GtkListBoxRow* before);
static gchar* gitg_repository_list_box_normalize (GitgRepositoryListBox* self,
                                           const gchar* s);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self,
                                          GtkListBoxRow* row);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self,
                                               GtkListBoxRow* a,
                                               GtkListBoxRow* b);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self,
                                                                           GitgRepository* repository);
static void gitg_repository_list_box_add_repository_to_bookmarks (GitgRepositoryListBox* self,
                                                           const gchar* uri,
                                                           GDateTime* visited);
static gboolean _gitg_repository_list_box_save_repository_bookmarks_gsource_func (gpointer self);
static void gitg_repository_list_box_connect_repository_row (GitgRepositoryListBox* self,
                                                      GitgRepositoryListBoxRow* row);
static void gitg_repository_list_box_delete_source_clicked (GitgRepositoryListBox* self,
                                                     GFile* workdir,
                                                     const gchar* uri,
                                                     GitgRepositoryListBoxRow* row);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda89_ (Block25Data* _data25_,
                  gint id);
static void gitg_repository_list_box_handle_delete_source_response (GitgRepositoryListBox* self,
                                                             gint id,
                                                             GFile* workdir,
                                                             const gchar* uri,
                                                             GitgRepositoryListBoxRow* row);
static void ___lambda89__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void gitg_repository_list_box_delete_source (GitgRepositoryListBox* self,
                                             GFile* file,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void gitg_repository_list_box_delete_source_finish (GitgRepositoryListBox* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ___lambda90_ (Block26Data* _data26_,
                   GObject* obj,
                   GAsyncResult* res);
static void gitg_repository_list_box_remove_row (GitgRepositoryListBox* self,
                                          const gchar* uri,
                                          GitgRepositoryListBoxRow* row);
static void ____lambda90__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void gitg_repository_list_box_send_to_trash (GitgRepositoryListBox* self,
                                             GFile* file,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void gitg_repository_list_box_send_to_trash_finish (GitgRepositoryListBox* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ____lambda91_ (Block26Data* _data26_,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda91__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void gitg_repository_list_box_send_to_trash_data_free (gpointer _data);
static gboolean gitg_repository_list_box_send_to_trash_co (GitgRepositoryListBoxSendToTrashData* _data_);
static void gitg_repository_list_box_send_to_trash_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void gitg_repository_list_box_delete_source_data_free (gpointer _data);
static gboolean gitg_repository_list_box_delete_source_co (GitgRepositoryListBoxDeleteSourceData* _data_);
static void gitg_repository_list_box_delete_source_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void ___lambda86_ (GitgRepositoryListBox* self);
static void ____lambda86__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda87_ (Block28Data* _data28_);
static void ____lambda87__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender,
                                                                gpointer self);
static void ___lambda88_ (Block28Data* _data28_);
static void ____lambda88__gitg_repository_list_box_row_request_delete_source (GitgRepositoryListBoxRow* _sender,
                                                                       gpointer self);
static void _vala_array_add14 (GitgRepositoryListBoxRow** * array,
                        gint* length,
                        gint* size,
                        GitgRepositoryListBoxRow* value);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_row_update_repository_data (GitgRepositoryListBoxRow* self);
static void _vala_GgitOId_free (GgitOId* self);
static GObject * gitg_repository_list_box_row_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void gitg_repository_list_box_row_finalize (GObject * obj);
static GType gitg_repository_list_box_row_get_type_once (void);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static GObject * gitg_repository_list_box_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                              GtkListBoxRow* before,
                                                                              gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                    gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                       GtkListBoxRow* row2,
                                                                       gpointer self);
static void gitg_repository_list_box_finalize (GObject * obj);
static GType gitg_repository_list_box_get_type_once (void);
static void _vala_gitg_repository_list_box_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gitg_repository_list_box_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

 G_GNUC_NO_INLINE static GType
gitg_selection_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_SELECTION_MODE_NORMAL, "GITG_SELECTION_MODE_NORMAL", "normal"}, {GITG_SELECTION_MODE_SELECTION, "GITG_SELECTION_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
	GType gitg_selection_mode_type_id;
	gitg_selection_mode_type_id = g_enum_register_static ("GitgSelectionMode", values);
	return gitg_selection_mode_type_id;
}

GType
gitg_selection_mode_get_type (void)
{
	static gsize gitg_selection_mode_type_id__once = 0;
	if (g_once_init_enter (&gitg_selection_mode_type_id__once)) {
		GType gitg_selection_mode_type_id;
		gitg_selection_mode_type_id = gitg_selection_mode_get_type_once ();
		g_once_init_leave (&gitg_selection_mode_type_id__once, gitg_selection_mode_type_id);
	}
	return gitg_selection_mode_type_id__once;
}

 G_GNUC_NO_INLINE static GType
gitg_delete_sources_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_DELETE_SOURCES_CANCEL, "GITG_DELETE_SOURCES_CANCEL", "cancel"}, {GITG_DELETE_SOURCES_TRASH, "GITG_DELETE_SOURCES_TRASH", "trash"}, {GITG_DELETE_SOURCES_DELETE, "GITG_DELETE_SOURCES_DELETE", "delete"}, {0, NULL, NULL}};
	GType gitg_delete_sources_type_id;
	gitg_delete_sources_type_id = g_enum_register_static ("GitgDeleteSources", values);
	return gitg_delete_sources_type_id;
}

GType
gitg_delete_sources_get_type (void)
{
	static gsize gitg_delete_sources_type_id__once = 0;
	if (g_once_init_enter (&gitg_delete_sources_type_id__once)) {
		GType gitg_delete_sources_type_id;
		gitg_delete_sources_type_id = gitg_delete_sources_get_type_once ();
		g_once_init_leave (&gitg_delete_sources_type_id__once, gitg_delete_sources_type_id);
	}
	return gitg_delete_sources_type_id__once;
}

static inline gpointer
gitg_repository_list_box_get_instance_private (GitgRepositoryListBox* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRepositoryListBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_gtk_recent_info_ref0 (gpointer self)
{
	return self ? gtk_recent_info_ref (self) : NULL;
}

static void
_gtk_recent_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}

static inline void
_g_list_free__gtk_recent_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gtk_recent_info_unref0_);
}

static void
gitg_repository_list_box_copy_bookmarks_from_recent_files (GitgRepositoryListBox* self)
{
	GtkRecentManager* manager = NULL;
	GtkRecentManager* _tmp0_;
	GtkRecentManager* _tmp1_;
	GList* items = NULL;
	GtkRecentManager* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_recent_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
	items = _tmp3_;
	_tmp4_ = items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp4_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkRecentInfo* _tmp5_;
			GtkRecentInfo* item = NULL;
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
			item = _tmp5_;
			{
				GtkRecentInfo* _tmp6_;
				gchar* uri = NULL;
				GtkRecentInfo* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				GBookmarkFile* _tmp10_;
				const gchar* _tmp11_;
				GtkRecentInfo* _tmp12_;
				const gchar* _tmp13_;
				GBookmarkFile* _tmp14_;
				const gchar* _tmp15_;
				GtkRecentInfo* _tmp16_;
				gsize _tmp17_ = 0;
				gchar** _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				GBookmarkFile* _tmp20_;
				const gchar* _tmp21_;
				GtkRecentInfo* _tmp22_;
				GDateTime* _tmp23_;
				GDateTime* _tmp24_;
				gchar* app_name = NULL;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* app_exec = NULL;
				gchar* _tmp27_;
				_tmp6_ = item;
				if (!gtk_recent_info_has_group (_tmp6_, "gitg")) {
					_gtk_recent_info_unref0 (item);
					continue;
				}
				_tmp7_ = item;
				_tmp8_ = gtk_recent_info_get_uri (_tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				uri = _tmp9_;
				_tmp10_ = self->priv->d_bookmark_file;
				_tmp11_ = uri;
				_tmp12_ = item;
				_tmp13_ = gtk_recent_info_get_mime_type (_tmp12_);
				g_bookmark_file_set_mime_type (_tmp10_, _tmp11_, _tmp13_);
				_tmp14_ = self->priv->d_bookmark_file;
				_tmp15_ = uri;
				_tmp16_ = item;
				_tmp18_ = gtk_recent_info_get_groups (_tmp16_, &_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp19__length1 = _tmp17_;
				g_bookmark_file_set_groups (_tmp14_, _tmp15_, _tmp19_, (gint) _tmp17_);
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
				_tmp20_ = self->priv->d_bookmark_file;
				_tmp21_ = uri;
				_tmp22_ = item;
				_tmp23_ = g_date_time_new_from_unix_utc ((gint64) gtk_recent_info_get_modified (_tmp22_));
				_tmp24_ = _tmp23_;
				g_bookmark_file_set_visited_date_time (_tmp20_, _tmp21_, _tmp24_);
				_g_date_time_unref0 (_tmp24_);
				_tmp25_ = g_get_application_name ();
				_tmp26_ = g_strdup (_tmp25_);
				app_name = _tmp26_;
				_tmp27_ = g_strdup ("gitg %f");
				app_exec = _tmp27_;
				{
					GBookmarkFile* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GTimeZone* _tmp32_;
					GTimeZone* _tmp33_;
					GDateTime* _tmp34_;
					GDateTime* _tmp35_;
					_tmp28_ = self->priv->d_bookmark_file;
					_tmp29_ = uri;
					_tmp30_ = app_name;
					_tmp31_ = app_exec;
					_tmp32_ = g_time_zone_new_local ();
					_tmp33_ = _tmp32_;
					_tmp34_ = g_date_time_new_now (_tmp33_);
					_tmp35_ = _tmp34_;
					g_bookmark_file_set_application_info (_tmp28_, _tmp29_, _tmp30_, _tmp31_, 1, _tmp35_, &_inner_error0_);
					_g_date_time_unref0 (_tmp35_);
					_g_time_zone_unref0 (_tmp33_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (app_exec);
					_g_free0 (app_name);
					_g_free0 (uri);
					_gtk_recent_info_unref0 (item);
					(items == NULL) ? NULL : (items = (_g_list_free__gtk_recent_info_unref0_ (items), NULL));
					_g_object_unref0 (manager);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (app_exec);
				_g_free0 (app_name);
				_g_free0 (uri);
				_gtk_recent_info_unref0 (item);
			}
		}
	}
	gitg_repository_list_box_save_repository_bookmarks_timeout (self);
	(items == NULL) ? NULL : (items = (_g_list_free__gtk_recent_info_unref0_ (items), NULL));
	_g_object_unref0 (manager);
}

static gboolean
gitg_repository_list_box_real_button_press_event (GtkWidget* base,
                                                  GdkEventButton* event)
{
	GitgRepositoryListBox * self;
	GdkEvent* ev = NULL;
	gboolean _tmp0_ = FALSE;
	GdkEvent* _tmp1_;
	gboolean result;
	self = (GitgRepositoryListBox*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	ev = (GdkEvent*) event;
	_tmp1_ = ev;
	if (gdk_event_triggers_context_menu (_tmp1_)) {
		GitgSelectionMode _tmp2_;
		_tmp2_ = self->priv->_mode;
		_tmp0_ = _tmp2_ == GITG_SELECTION_MODE_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GitgRepositoryListBoxRow* row = NULL;
		GtkListBoxRow* _tmp3_;
		GitgRepositoryListBoxRow* _tmp4_;
		GitgRepositoryListBoxRow* _tmp5_;
		gitg_repository_list_box_set_mode (self, GITG_SELECTION_MODE_SELECTION);
		_tmp3_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) event->y);
		_tmp4_ = _g_object_ref0 (GITG_REPOSITORY_LIST_BOX_IS_ROW (_tmp3_) ? ((GitgRepositoryListBoxRow*) _tmp3_) : NULL);
		row = _tmp4_;
		_tmp5_ = row;
		if (_tmp5_ != NULL) {
			GitgRepositoryListBoxRow* _tmp6_;
			_tmp6_ = row;
			gitg_repository_list_box_row_set_selected (_tmp6_, TRUE);
		}
		result = TRUE;
		_g_object_unref0 (row);
		return result;
	}
	result = GTK_WIDGET_CLASS (gitg_repository_list_box_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), event);
	return result;
}

static void
gitg_repository_list_box_real_row_activated (GtkListBox* base,
                                             GtkListBoxRow* row)
{
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GitgRepositoryListBoxRow* _tmp0_;
	GitgSelectionMode _tmp1_;
	GitgRepositoryListBoxRow* _tmp6_;
	GitgRepository* _tmp7_;
	GitgRepository* _tmp8_;
	self = (GitgRepositoryListBox*) base;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
	r = _tmp0_;
	_tmp1_ = self->priv->_mode;
	if (_tmp1_ == GITG_SELECTION_MODE_SELECTION) {
		GitgRepositoryListBoxRow* _tmp2_;
		GitgRepositoryListBoxRow* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = r;
		_tmp3_ = r;
		_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
		_tmp5_ = _tmp4_;
		gitg_repository_list_box_row_set_selected (_tmp2_, !_tmp5_);
		_g_object_unref0 (r);
		return;
	}
	_tmp6_ = r;
	_tmp7_ = gitg_repository_list_box_row_get_repository (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		GitgRepositoryListBoxRow* _tmp9_;
		GitgRepository* _tmp10_;
		GitgRepository* _tmp11_;
		_tmp9_ = r;
		_tmp10_ = gitg_repository_list_box_row_get_repository (_tmp9_);
		_tmp11_ = _tmp10_;
		g_signal_emit (self, gitg_repository_list_box_signals[GITG_REPOSITORY_LIST_BOX_REPOSITORY_ACTIVATED_SIGNAL], 0, _tmp11_);
	}
	_g_object_unref0 (r);
}

static void
gitg_repository_list_box_update_header (GitgRepositoryListBox* self,
                                        GtkListBoxRow* row,
                                        GtkListBoxRow* before)
{
	GtkSeparator* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	if (before != NULL) {
		GtkSeparator* _tmp1_;
		_tmp1_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp0_);
	_g_object_unref0 (_tmp0_);
}

static gchar*
gitg_repository_list_box_normalize (GitgRepositoryListBox* self,
                                    const gchar* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_utf8_normalize (s, (gssize) -1, G_NORMALIZE_ALL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
gitg_repository_list_box_filter (GitgRepositoryListBox* self,
                                 GtkListBoxRow* row)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp1_ = self->priv->d_filter_text;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (row, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
		_tmp3_ = _tmp2_;
		_tmp4_ = gitg_repository_list_box_normalize (self, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->d_filter_text;
		_tmp7_ = gitg_repository_list_box_normalize (self, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = string_contains (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

static gint
gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self,
                                          GtkListBoxRow* a,
                                          GtkListBoxRow* b)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (b, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (a, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
	_tmp3_ = _tmp2_;
	result = g_date_time_compare (_tmp1_, _tmp3_);
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
gitg_repository_list_box_populate_bookmarks (GitgRepositoryListBox* self)
{
	gchar** uris = NULL;
	GBookmarkFile* _tmp0_;
	gsize _tmp1_ = 0;
	gchar** _tmp2_;
	gint uris_length1;
	gint _uris_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_bookmark_file;
	_tmp2_ = g_bookmark_file_get_uris (_tmp0_, &_tmp1_);
	uris = _tmp2_;
	uris_length1 = _tmp1_;
	_uris_size_ = uris_length1;
	_tmp3_ = uris;
	_tmp3__length1 = uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp3_;
		uri_collection_length1 = _tmp3__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp4_;
			gchar* uri = NULL;
			_tmp4_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp4_;
			{
				GFile* repo_file = NULL;
				const gchar* _tmp8_;
				GFile* _tmp9_;
				GitgRepository* repo = NULL;
				GDateTime* visited = NULL;
				GitgRepository* _tmp21_;
				GDateTime* _tmp22_;
				GitgRepositoryListBoxRow* _tmp23_;
				GitgRepositoryListBoxRow* _tmp24_;
				{
					gboolean _tmp5_ = FALSE;
					GBookmarkFile* _tmp6_;
					const gchar* _tmp7_;
					_tmp6_ = self->priv->d_bookmark_file;
					_tmp7_ = uri;
					_tmp5_ = g_bookmark_file_has_group (_tmp6_, _tmp7_, "gitg", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					if (!_tmp5_) {
						_g_free0 (uri);
						continue;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
					_g_free0 (uri);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (uri);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp8_ = uri;
				_tmp9_ = g_file_new_for_uri (_tmp8_);
				repo_file = _tmp9_;
				{
					GitgRepository* _tmp10_ = NULL;
					GFile* _tmp11_;
					GitgRepository* _tmp12_;
					GitgRepository* _tmp13_;
					_tmp11_ = repo_file;
					_tmp12_ = gitg_repository_new (_tmp11_, NULL, &_inner_error0_);
					_tmp10_ = _tmp12_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp13_ = _tmp10_;
					_tmp10_ = NULL;
					_g_object_unref0 (repo);
					repo = _tmp13_;
					_g_object_unref0 (_tmp10_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
					{
						GBookmarkFile* _tmp14_;
						const gchar* _tmp15_;
						_tmp14_ = self->priv->d_bookmark_file;
						_tmp15_ = uri;
						g_bookmark_file_remove_item (_tmp14_, _tmp15_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
					}
					goto __finally2;
					__catch2_g_error:
					{
						g_clear_error (&_inner_error0_);
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (repo);
						_g_object_unref0 (repo_file);
						_g_free0 (uri);
						uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_object_unref0 (repo);
					_g_object_unref0 (repo_file);
					_g_free0 (uri);
					continue;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (repo);
					_g_object_unref0 (repo_file);
					_g_free0 (uri);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				visited = NULL;
				{
					GDateTime* _tmp16_ = NULL;
					GBookmarkFile* _tmp17_;
					const gchar* _tmp18_;
					GDateTime* _tmp19_;
					GDateTime* _tmp20_;
					_tmp17_ = self->priv->d_bookmark_file;
					_tmp18_ = uri;
					_tmp19_ = g_bookmark_file_get_visited_date_time (_tmp17_, _tmp18_, &_inner_error0_);
					_tmp16_ = _tmp19_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch3_g_error;
					}
					_tmp20_ = _g_date_time_ref0 (_tmp16_);
					_g_date_time_unref0 (visited);
					visited = _tmp20_;
				}
				goto __finally3;
				__catch3_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally3:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_date_time_unref0 (visited);
					_g_object_unref0 (repo);
					_g_object_unref0 (repo_file);
					_g_free0 (uri);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp21_ = repo;
				_tmp22_ = visited;
				_tmp23_ = gitg_repository_list_box_add_repository (self, _tmp21_, _tmp22_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
				_g_date_time_unref0 (visited);
				_g_object_unref0 (repo);
				_g_object_unref0 (repo_file);
				_g_free0 (uri);
			}
		}
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}

static GitgRepositoryListBoxRow*
gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self,
                                                 GitgRepository* repository)
{
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_;
	GitgRepositoryListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (repository != NULL, NULL);
	row = NULL;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_;
				GitgRepositoryListBoxRow* _tmp2_;
				GitgRepositoryListBoxRow* _tmp3_;
				GitgRepository* _tmp4_;
				GitgRepository* _tmp5_;
				GFile* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				gboolean _tmp10_;
				_tmp1_ = child;
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
				d = _tmp2_;
				_tmp3_ = d;
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = ggit_repository_get_location ((GgitRepository*) repository);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_file_equal (_tmp7_, _tmp9_);
				_g_object_unref0 (_tmp9_);
				_g_object_unref0 (_tmp7_);
				if (_tmp10_) {
					GitgRepositoryListBoxRow* _tmp11_;
					GitgRepositoryListBoxRow* _tmp12_;
					_tmp11_ = d;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (row);
					row = _tmp12_;
					_g_object_unref0 (d);
					break;
				}
				_g_object_unref0 (d);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = row;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
gitg_repository_list_box_save_repository_bookmarks (GitgRepositoryListBox* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->d_save_repository_bookmarks_id = (guint) 0;
	_tmp0_ = gitg_repository_list_box_get_location (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	{
		GFile* dir = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp2_ = gitg_repository_list_box_get_location (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_parent (_tmp3_);
		dir = _tmp4_;
		_tmp5_ = dir;
		g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	{
		GBookmarkFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = self->priv->d_bookmark_file;
		_tmp8_ = gitg_repository_list_box_get_location (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		g_bookmark_file_to_file (_tmp7_, _tmp11_, &_inner_error0_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("Failed to save repository bookmarks: ", _tmp15_, "\n", NULL);
		_tmp17_ = _tmp16_;
		fprintf (_tmp12_, "%s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	result = FALSE;
	return result;
}

static void
gitg_repository_list_box_add_repository_to_bookmarks (GitgRepositoryListBox* self,
                                                      const gchar* uri,
                                                      GDateTime* visited)
{
	GBookmarkFile* _tmp0_;
	GBookmarkFile* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GDateTime* _tmp5_ = NULL;
	GBookmarkFile* _tmp10_;
	gchar* app_name = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* app_exec = NULL;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->d_bookmark_file;
	g_bookmark_file_set_mime_type (_tmp0_, uri, "inode/directory");
	_tmp1_ = self->priv->d_bookmark_file;
	_tmp2_ = g_strdup ("gitg");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	g_bookmark_file_set_groups (_tmp1_, uri, _tmp4_, (gint) 1);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (visited == NULL) {
		GTimeZone* _tmp6_;
		GTimeZone* _tmp7_;
		GDateTime* _tmp8_;
		_tmp6_ = g_time_zone_new_local ();
		_tmp7_ = _tmp6_;
		_tmp8_ = g_date_time_new_now (_tmp7_);
		_g_date_time_unref0 (_tmp5_);
		_tmp5_ = _tmp8_;
		_g_time_zone_unref0 (_tmp7_);
	} else {
		GDateTime* _tmp9_;
		_tmp9_ = _g_date_time_ref0 (visited);
		_g_date_time_unref0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = self->priv->d_bookmark_file;
	g_bookmark_file_set_visited_date_time (_tmp10_, uri, _tmp5_);
	_tmp11_ = g_get_application_name ();
	_tmp12_ = g_strdup (_tmp11_);
	app_name = _tmp12_;
	_tmp13_ = g_strdup ("gitg %f");
	app_exec = _tmp13_;
	{
		GBookmarkFile* _tmp14_;
		GTimeZone* _tmp15_;
		GTimeZone* _tmp16_;
		GDateTime* _tmp17_;
		GDateTime* _tmp18_;
		_tmp14_ = self->priv->d_bookmark_file;
		_tmp15_ = g_time_zone_new_local ();
		_tmp16_ = _tmp15_;
		_tmp17_ = g_date_time_new_now (_tmp16_);
		_tmp18_ = _tmp17_;
		g_bookmark_file_set_application_info (_tmp14_, uri, app_name, app_exec, 1, _tmp18_, &_inner_error0_);
		_g_date_time_unref0 (_tmp18_);
		_g_time_zone_unref0 (_tmp16_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (app_exec);
		_g_free0 (app_name);
		_g_date_time_unref0 (_tmp5_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gitg_repository_list_box_save_repository_bookmarks_timeout (self);
	_g_free0 (app_exec);
	_g_free0 (app_name);
	_g_date_time_unref0 (_tmp5_);
}

static gboolean
_gitg_repository_list_box_save_repository_bookmarks_gsource_func (gpointer self)
{
	gboolean result;
	result = gitg_repository_list_box_save_repository_bookmarks ((GitgRepositoryListBox*) self);
	return result;
}

static void
gitg_repository_list_box_save_repository_bookmarks_timeout (GitgRepositoryListBox* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_save_repository_bookmarks_id != ((guint) 0)) {
		return;
	}
	self->priv->d_save_repository_bookmarks_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _gitg_repository_list_box_save_repository_bookmarks_gsource_func, g_object_ref (self), g_object_unref);
}

void
gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self,
                                      GitgRepositoryListBoxRow* row,
                                      GitgRepository* repository)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	if (repository != NULL) {
		GFile* workdir = NULL;
		GFile* _tmp0_;
		GFile* repo_file = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		GFile* _tmp3_;
		gchar* uri = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp0_ = ggit_repository_get_workdir ((GgitRepository*) repository);
		workdir = _tmp0_;
		_tmp1_ = ggit_repository_get_location ((GgitRepository*) repository);
		repo_file = _tmp1_;
		_tmp3_ = workdir;
		if (_tmp3_ != NULL) {
			GFile* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = workdir;
			_tmp5_ = g_file_get_uri (_tmp4_);
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp5_;
		} else {
			GFile* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = repo_file;
			_tmp7_ = g_file_get_uri (_tmp6_);
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp7_;
		}
		_tmp8_ = g_strdup (_tmp2_);
		uri = _tmp8_;
		_tmp9_ = uri;
		gitg_repository_list_box_add_repository_to_bookmarks (self, _tmp9_, NULL);
		gitg_repository_list_box_row_set_repository (row, repository);
		gitg_repository_list_box_row_set_loading (row, FALSE);
		gitg_repository_list_box_connect_repository_row (self, row);
		_g_free0 (uri);
		_g_free0 (_tmp2_);
		_g_object_unref0 (repo_file);
		_g_object_unref0 (workdir);
	} else {
		gtk_container_remove ((GtkContainer*) self, (GtkWidget*) row);
	}
}

GitgRepositoryListBoxRow*
gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self,
                                        GFile* location)
{
	GitgRepositoryListBoxRow* row = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GitgRepositoryListBoxRow* _tmp4_;
	GitgRepositoryListBoxRow* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GitgRepositoryListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = g_file_get_parent (location);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_utils_replace_home_dir_with_tilde (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_repository_list_box_row_new (NULL, _tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	row = _tmp5_;
	_tmp6_ = g_file_get_basename (location);
	_tmp7_ = _tmp6_;
	gitg_repository_list_box_row_set_repository_name (row, _tmp7_);
	_g_free0 (_tmp7_);
	gitg_repository_list_box_row_set_branch_name (row, _ ("Cloning…"));
	gitg_repository_list_box_row_set_loading (row, TRUE);
	gtk_widget_show ((GtkWidget*) row);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) row);
	result = row;
	return result;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		GitgRepositoryListBox* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->alert_dialog);
		_g_object_unref0 (_data25_->workdir);
		_g_free0 (_data25_->uri);
		_g_object_unref0 (_data25_->row);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda89_ (Block25Data* _data25_,
             gint id)
{
	GitgRepositoryListBox* self;
	self = _data25_->self;
	gitg_repository_list_box_handle_delete_source_response (self, id, _data25_->workdir, _data25_->uri, _data25_->row);
	gtk_widget_destroy ((GtkWidget*) _data25_->alert_dialog);
}

static void
___lambda89__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda89_ (self, response_id);
}

static void
gitg_repository_list_box_delete_source_clicked (GitgRepositoryListBox* self,
                                                GFile* workdir,
                                                const gchar* uri,
                                                GitgRepositoryListBoxRow* row)
{
	Block25Data* _data25_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	GitgRepositoryListBoxRow* _tmp2_;
	GtkWidget* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkWidget* delete_button = NULL;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkStyleContext* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (workdir != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (row != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (workdir);
	_g_object_unref0 (_data25_->workdir);
	_data25_->workdir = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data25_->uri);
	_data25_->uri = _tmp1_;
	_tmp2_ = _g_object_ref0 (row);
	_g_object_unref0 (_data25_->row);
	_data25_->row = _tmp2_;
	_tmp3_ = gtk_widget_get_toplevel ((GtkWidget*) _data25_->row);
	_tmp4_ = g_strdup_printf (_ ("Deleting repository source files “%s” will delete them from disk and c" \
"annot be undone. Are you sure?"), _data25_->uri);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _tmp5_, NULL);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_data25_->alert_dialog = _tmp7_;
	gtk_dialog_add_button ((GtkDialog*) _data25_->alert_dialog, _ ("Cancel"), (gint) GITG_DELETE_SOURCES_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) _data25_->alert_dialog, _ ("Move to trash"), (gint) GITG_DELETE_SOURCES_TRASH);
	gtk_dialog_add_button ((GtkDialog*) _data25_->alert_dialog, _ ("Delete permanently"), (gint) GITG_DELETE_SOURCES_DELETE);
	_tmp8_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data25_->alert_dialog, (gint) GITG_DELETE_SOURCES_DELETE);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	delete_button = _tmp9_;
	_tmp10_ = gtk_widget_get_style_context (delete_button);
	gtk_style_context_add_class (_tmp10_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_data ((GtkDialog*) _data25_->alert_dialog, "response", (GCallback) ___lambda89__gtk_dialog_response, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	gtk_dialog_run ((GtkDialog*) _data25_->alert_dialog);
	_g_object_unref0 (delete_button);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		GitgRepositoryListBox* self;
		self = _data26_->self;
		_g_free0 (_data26_->uri);
		_g_object_unref0 (_data26_->row);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
___lambda90_ (Block26Data* _data26_,
              GObject* obj,
              GAsyncResult* res)
{
	GitgRepositoryListBox* self;
	GError* _inner_error0_ = NULL;
	self = _data26_->self;
	g_return_if_fail (res != NULL);
	{
		gitg_repository_list_box_delete_source_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gitg_repository_list_box_remove_row (self, _data26_->uri, _data26_->row);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("gitg-repository-list-box.vala:592: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda90__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda90_ (self, source_object, res);
	block26_data_unref (self);
}

static void
____lambda91_ (Block26Data* _data26_,
               GObject* obj,
               GAsyncResult* res)
{
	GitgRepositoryListBox* self;
	GError* _inner_error0_ = NULL;
	self = _data26_->self;
	g_return_if_fail (res != NULL);
	{
		gitg_repository_list_box_send_to_trash_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gitg_repository_list_box_remove_row (self, _data26_->uri, _data26_->row);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("gitg-repository-list-box.vala:601: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda91__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda91_ (self, source_object, res);
	block26_data_unref (self);
}

static void
gitg_repository_list_box_handle_delete_source_response (GitgRepositoryListBox* self,
                                                        gint id,
                                                        GFile* workdir,
                                                        const gchar* uri,
                                                        GitgRepositoryListBoxRow* row)
{
	Block26Data* _data26_;
	gchar* _tmp0_;
	GitgRepositoryListBoxRow* _tmp1_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (workdir != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (row != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = g_strdup (uri);
	_g_free0 (_data26_->uri);
	_data26_->uri = _tmp0_;
	_tmp1_ = _g_object_ref0 (row);
	_g_object_unref0 (_data26_->row);
	_data26_->row = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	cancellable = _tmp2_;
	if (id == ((gint) GITG_DELETE_SOURCES_DELETE)) {
		GCancellable* _tmp3_;
		_tmp3_ = cancellable;
		gitg_repository_list_box_delete_source (self, workdir, _tmp3_, ____lambda90__gasync_ready_callback, block26_data_ref (_data26_));
	} else {
		if (id == ((gint) GITG_DELETE_SOURCES_TRASH)) {
			GCancellable* _tmp4_;
			_tmp4_ = cancellable;
			gitg_repository_list_box_send_to_trash (self, workdir, _tmp4_, _____lambda91__gasync_ready_callback, block26_data_ref (_data26_));
		}
	}
	_g_object_unref0 (cancellable);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}

static void
gitg_repository_list_box_send_to_trash_data_free (gpointer _data)
{
	GitgRepositoryListBoxSendToTrashData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRepositoryListBoxSendToTrashData, _data_);
}

static void
gitg_repository_list_box_send_to_trash (GitgRepositoryListBox* self,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GitgRepositoryListBoxSendToTrashData* _data_;
	GitgRepositoryListBox* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (GitgRepositoryListBoxSendToTrashData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_repository_list_box_send_to_trash_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gitg_repository_list_box_send_to_trash_co (_data_);
}

static void
gitg_repository_list_box_send_to_trash_finish (GitgRepositoryListBox* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GitgRepositoryListBoxSendToTrashData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
gitg_repository_list_box_send_to_trash_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GitgRepositoryListBoxSendToTrashData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_repository_list_box_send_to_trash_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
gitg_repository_list_box_send_to_trash_co (GitgRepositoryListBoxSendToTrashData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		g_file_trash_async (_data_->file, G_PRIORITY_DEFAULT, NULL, gitg_repository_list_box_send_to_trash_ready, _data_);
		return FALSE;
		_state_1:
		g_file_trash_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->e;
		_data_->_tmp1_ = _data_->_tmp0_->message;
		g_warning ("gitg-repository-list-box.vala:616: %s", _data_->_tmp1_);
		g_cancellable_cancel (_data_->cancellable);
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_repository_list_box_delete_source_data_free (gpointer _data)
{
	GitgRepositoryListBoxDeleteSourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRepositoryListBoxDeleteSourceData, _data_);
}

static void
gitg_repository_list_box_delete_source (GitgRepositoryListBox* self,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GitgRepositoryListBoxDeleteSourceData* _data_;
	GitgRepositoryListBox* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (GitgRepositoryListBoxDeleteSourceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_repository_list_box_delete_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gitg_repository_list_box_delete_source_co (_data_);
}

static void
gitg_repository_list_box_delete_source_finish (GitgRepositoryListBox* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GitgRepositoryListBoxDeleteSourceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
gitg_repository_list_box_delete_source_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GitgRepositoryListBoxDeleteSourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_repository_list_box_delete_source_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
gitg_repository_list_box_delete_source_co (GitgRepositoryListBoxDeleteSourceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->dtype = g_file_query_file_type (_data_->file, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	if (_data_->dtype == G_FILE_TYPE_DIRECTORY) {
		{
			_data_->_state_ = 1;
			g_file_enumerate_children_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, gitg_repository_list_box_delete_source_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp0_ = g_file_enumerate_children_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
			_data_->dir_in_repository = _data_->_tmp0_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			while (TRUE) {
				_data_->_tmp2_ = _data_->dir_in_repository;
				_data_->_state_ = 2;
				g_file_enumerator_next_files_async (_data_->_tmp2_, 20, G_PRIORITY_DEFAULT, NULL, gitg_repository_list_box_delete_source_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp3_ = g_file_enumerator_next_files_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp1_ = _data_->_tmp3_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					(_data_->content_infos == NULL) ? NULL : (_data_->content_infos = (_g_list_free__g_object_unref0_ (_data_->content_infos), NULL));
					_g_object_unref0 (_data_->dir_in_repository);
					goto __catch0_g_error;
				}
				_data_->_tmp4_ = _data_->_tmp1_;
				_data_->_tmp1_ = NULL;
				(_data_->content_infos == NULL) ? NULL : (_data_->content_infos = (_g_list_free__g_object_unref0_ (_data_->content_infos), NULL));
				_data_->content_infos = _data_->_tmp4_;
				_data_->_tmp5_ = _data_->content_infos;
				if (!(_data_->_tmp5_ != NULL)) {
					(_data_->_tmp1_ == NULL) ? NULL : (_data_->_tmp1_ = (_g_list_free__g_object_unref0_ (_data_->_tmp1_), NULL));
					break;
				}
				_data_->_tmp6_ = _data_->content_infos;
				{
					_data_->file_cinfo_collection = _data_->_tmp6_;
					for (_data_->file_cinfo_it = _data_->file_cinfo_collection; _data_->file_cinfo_it != NULL; _data_->file_cinfo_it = _data_->file_cinfo_it->next) {
						_data_->_tmp7_ = _g_object_ref0 ((GFileInfo*) _data_->file_cinfo_it->data);
						_data_->file_cinfo = _data_->_tmp7_;
						{
							_data_->_tmp8_ = _data_->file_cinfo;
							_data_->_tmp9_ = g_file_info_get_name (_data_->_tmp8_);
							_data_->_tmp10_ = g_file_get_child (_data_->file, _data_->_tmp9_);
							_data_->files = _data_->_tmp10_;
							_data_->_tmp11_ = _data_->files;
							_data_->_state_ = 3;
							gitg_repository_list_box_delete_source (_data_->self, _data_->_tmp11_, _data_->cancellable, gitg_repository_list_box_delete_source_ready, _data_);
							return FALSE;
							_state_3:
							gitg_repository_list_box_delete_source_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								_g_object_unref0 (_data_->files);
								_g_object_unref0 (_data_->file_cinfo);
								(_data_->_tmp1_ == NULL) ? NULL : (_data_->_tmp1_ = (_g_list_free__g_object_unref0_ (_data_->_tmp1_), NULL));
								(_data_->content_infos == NULL) ? NULL : (_data_->content_infos = (_g_list_free__g_object_unref0_ (_data_->content_infos), NULL));
								_g_object_unref0 (_data_->dir_in_repository);
								goto __catch0_g_error;
							}
							_g_object_unref0 (_data_->files);
							_g_object_unref0 (_data_->file_cinfo);
						}
					}
				}
				(_data_->_tmp1_ == NULL) ? NULL : (_data_->_tmp1_ = (_g_list_free__g_object_unref0_ (_data_->_tmp1_), NULL));
			}
			(_data_->content_infos == NULL) ? NULL : (_data_->content_infos = (_g_list_free__g_object_unref0_ (_data_->content_infos), NULL));
			_g_object_unref0 (_data_->dir_in_repository);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->e;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			g_warning ("gitg-repository-list-box.vala:641: Warning: %s\n", _data_->_tmp13_);
			g_cancellable_cancel (_data_->cancellable);
			_data_->_tmp14_ = _data_->e;
			_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
			_data_->_inner_error0_ = _data_->_tmp15_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_state_ = 4;
		g_file_delete_async (_data_->file, G_PRIORITY_DEFAULT, NULL, gitg_repository_list_box_delete_source_ready, _data_);
		return FALSE;
		_state_4:
		g_file_delete_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->_vala1_e;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("gitg-repository-list-box.vala:650: %s", _data_->_tmp17_);
		g_cancellable_cancel (_data_->cancellable);
		_data_->_tmp18_ = _data_->_vala1_e;
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
		_data_->_inner_error0_ = _data_->_tmp19_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_repository_list_box_remove_row (GitgRepositoryListBox* self,
                                     const gchar* uri,
                                     GitgRepositoryListBoxRow* row)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (row != NULL);
	{
		GBookmarkFile* _tmp0_;
		_tmp0_ = self->priv->d_bookmark_file;
		g_bookmark_file_remove_item (_tmp0_, uri, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) row);
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		GitgRepositoryListBox* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->workdir);
		_g_object_unref0 (_data27_->row);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		GitgRepositoryListBox* self;
		self = _data28_->_data27_->self;
		_g_free0 (_data28_->uri);
		block27_data_unref (_data28_->_data27_);
		_data28_->_data27_ = NULL;
		g_slice_free (Block28Data, _data28_);
	}
}

static void
___lambda86_ (GitgRepositoryListBox* self)
{
	g_object_notify ((GObject*) self, "has-selection");
}

static void
____lambda86__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda86_ ((GitgRepositoryListBox*) self);
}

static void
___lambda87_ (Block28Data* _data28_)
{
	Block27Data* _data27_;
	GitgRepositoryListBox* self;
	const gchar* _tmp0_;
	_data27_ = _data28_->_data27_;
	self = _data27_->self;
	_tmp0_ = _data28_->uri;
	gitg_repository_list_box_remove_row (self, _tmp0_, _data27_->row);
}

static void
____lambda87__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender,
                                                           gpointer self)
{
	___lambda87_ (self);
}

static void
___lambda88_ (Block28Data* _data28_)
{
	Block27Data* _data27_;
	GitgRepositoryListBox* self;
	GFile* _tmp0_;
	const gchar* _tmp1_;
	_data27_ = _data28_->_data27_;
	self = _data27_->self;
	_tmp0_ = _data27_->workdir;
	_tmp1_ = _data28_->uri;
	gitg_repository_list_box_delete_source_clicked (self, _tmp0_, _tmp1_, _data27_->row);
}

static void
____lambda88__gitg_repository_list_box_row_request_delete_source (GitgRepositoryListBoxRow* _sender,
                                                                  gpointer self)
{
	___lambda88_ (self);
}

static void
gitg_repository_list_box_connect_repository_row (GitgRepositoryListBox* self,
                                                 GitgRepositoryListBoxRow* row)
{
	Block27Data* _data27_;
	GitgRepositoryListBoxRow* _tmp0_;
	GitgRepository* repository = NULL;
	GitgRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GitgRepository* _tmp3_;
	GFile* _tmp4_ = NULL;
	GitgRepository* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (_data27_->row);
	_data27_->row = _tmp0_;
	_tmp1_ = gitg_repository_list_box_row_get_repository (_data27_->row);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	repository = _tmp3_;
	_tmp5_ = repository;
	g_object_get ((GgitRepository*) _tmp5_, "workdir", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_object_unref0 (_tmp8_);
	if (_tmp9_) {
		GitgRepository* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp10_ = repository;
		g_object_get ((GgitRepository*) _tmp10_, "workdir", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp12_;
	} else {
		GitgRepository* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		_tmp13_ = repository;
		_tmp14_ = ggit_repository_get_location ((GgitRepository*) _tmp13_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp15_;
	}
	_tmp16_ = _g_object_ref0 (_tmp4_);
	_data27_->workdir = _tmp16_;
	_tmp17_ = _data27_->workdir;
	if (_tmp17_ != NULL) {
		Block28Data* _data28_;
		GFile* _tmp18_;
		gchar* _tmp19_;
		_data28_ = g_slice_new0 (Block28Data);
		_data28_->_ref_count_ = 1;
		_data28_->_data27_ = block27_data_ref (_data27_);
		_tmp18_ = _data27_->workdir;
		_tmp19_ = g_file_get_uri (_tmp18_);
		_data28_->uri = _tmp19_;
		g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _data27_->row, "mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		g_signal_connect_object ((GObject*) _data27_->row, "notify::selected", (GCallback) ____lambda86__g_object_notify, self, 0);
		g_signal_connect_data (_data27_->row, "request-remove", (GCallback) ____lambda87__gitg_repository_list_box_row_request_remove, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
		g_signal_connect_data (_data27_->row, "request-delete-source", (GCallback) ____lambda88__gitg_repository_list_box_row_request_delete_source, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
		gitg_repository_list_box_row_set_can_remove (_data27_->row, TRUE);
		block28_data_unref (_data28_);
		_data28_ = NULL;
	} else {
		gitg_repository_list_box_row_set_can_remove (_data27_->row, FALSE);
	}
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (repository);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}

GitgRepositoryListBoxRow*
gitg_repository_list_box_add_repository (GitgRepositoryListBox* self,
                                         GitgRepository* repository,
                                         GDateTime* visited)
{
	GitgRepositoryListBoxRow* row = NULL;
	GitgRepositoryListBoxRow* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_;
	GFile* f = NULL;
	GFile* _tmp10_;
	GitgRepositoryListBoxRow* _tmp11_;
	GDateTime* _tmp30_ = NULL;
	GitgRepositoryListBoxRow* _tmp33_;
	GFile* _tmp34_;
	GitgRepositoryListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (repository != NULL, NULL);
	_tmp0_ = gitg_repository_list_box_get_row_for_repository (self, repository);
	row = _tmp0_;
	g_object_get ((GgitRepository*) repository, "workdir", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		GFile* _tmp6_;
		GFile* _tmp7_;
		g_object_get ((GgitRepository*) repository, "workdir", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp7_;
	} else {
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp8_ = ggit_repository_get_location ((GgitRepository*) repository);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp9_;
	}
	_tmp10_ = _g_object_ref0 (_tmp1_);
	f = _tmp10_;
	_tmp11_ = row;
	if (_tmp11_ == NULL) {
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		gboolean _tmp16_;
		gchar* dirname = NULL;
		GFile* _tmp21_;
		GFile* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		GitgRepositoryListBoxRow* _tmp26_;
		GitgRepositoryListBoxRow* _tmp27_;
		GitgRepositoryListBoxRow* _tmp28_;
		GitgRepositoryListBoxRow* _tmp29_;
		g_object_get ((GgitRepository*) repository, "workdir", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_ != NULL;
		_g_object_unref0 (_tmp15_);
		if (_tmp16_) {
			GFile* _tmp17_;
			GFile* _tmp18_;
			g_object_get ((GgitRepository*) repository, "workdir", &_tmp17_, NULL);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp12_);
			_tmp12_ = _tmp18_;
		} else {
			GFile* _tmp19_;
			GFile* _tmp20_;
			_tmp19_ = ggit_repository_get_location ((GgitRepository*) repository);
			_tmp20_ = _tmp19_;
			_g_object_unref0 (_tmp12_);
			_tmp12_ = _tmp20_;
		}
		_tmp21_ = g_file_get_parent (_tmp12_);
		_tmp22_ = _tmp21_;
		_tmp23_ = gitg_utils_replace_home_dir_with_tilde (_tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		dirname = _tmp24_;
		_tmp25_ = dirname;
		_tmp26_ = gitg_repository_list_box_row_new (repository, _tmp25_);
		g_object_ref_sink (_tmp26_);
		_g_object_unref0 (row);
		row = _tmp26_;
		_tmp27_ = row;
		gtk_widget_show ((GtkWidget*) _tmp27_);
		_tmp28_ = row;
		gitg_repository_list_box_connect_repository_row (self, _tmp28_);
		_tmp29_ = row;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
		_g_free0 (dirname);
		_g_object_unref0 (_tmp12_);
	}
	if (visited != NULL) {
		GDateTime* _tmp31_;
		_tmp31_ = _g_date_time_ref0 (visited);
		_g_date_time_unref0 (_tmp30_);
		_tmp30_ = _tmp31_;
	} else {
		GDateTime* _tmp32_;
		_tmp32_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (_tmp30_);
		_tmp30_ = _tmp32_;
	}
	_tmp33_ = row;
	gitg_repository_list_box_row_set_time (_tmp33_, _tmp30_);
	gtk_list_box_invalidate_sort ((GtkListBox*) self);
	_tmp34_ = f;
	if (_tmp34_ != NULL) {
		GFile* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp35_ = f;
		_tmp36_ = g_file_get_uri (_tmp35_);
		_tmp37_ = _tmp36_;
		gitg_repository_list_box_add_repository_to_bookmarks (self, _tmp37_, visited);
		_g_free0 (_tmp37_);
	}
	result = row;
	_g_date_time_unref0 (_tmp30_);
	_g_object_unref0 (f);
	_g_object_unref0 (_tmp1_);
	return result;
}

static void
_vala_array_add14 (GitgRepositoryListBoxRow** * array,
                   gint* length,
                   gint* size,
                   GitgRepositoryListBoxRow* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRepositoryListBoxRow*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GitgRepositoryListBoxRow**
gitg_repository_list_box_get_selection (GitgRepositoryListBox* self,
                                        gint* result_length1)
{
	GitgRepositoryListBoxRow** ret = NULL;
	GitgRepositoryListBoxRow** _tmp0_;
	gint ret_length1;
	gint _ret_size_;
	GList* _tmp1_;
	GitgRepositoryListBoxRow** _tmp9_;
	gint _tmp9__length1;
	GitgRepositoryListBoxRow** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GitgRepositoryListBoxRow*, 0 + 1);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp2_;
				GitgRepositoryListBoxRow* _tmp3_;
				GitgRepositoryListBoxRow* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp2_ = row;
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
				r = _tmp3_;
				_tmp4_ = r;
				_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					GitgRepositoryListBoxRow* _tmp7_;
					GitgRepositoryListBoxRow* _tmp8_;
					_tmp7_ = r;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_vala_array_add14 (&ret, &ret_length1, &_ret_size_, _tmp8_);
				}
				_g_object_unref0 (r);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	_tmp9_ = ret;
	_tmp9__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

void
gitg_repository_list_box_filter_text (GitgRepositoryListBox* self,
                                      const gchar* text)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->d_filter_text);
	self->priv->d_filter_text = _tmp0_;
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
}

GitgRepositoryListBox*
gitg_repository_list_box_construct (GType object_type)
{
	GitgRepositoryListBox * self = NULL;
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
	return self;
}

GitgRepositoryListBox*
gitg_repository_list_box_new (void)
{
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
}

GitgSelectionMode
gitg_repository_list_box_get_mode (GitgRepositoryListBox* self)
{
	GitgSelectionMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
gitg_repository_list_box_set_mode (GitgRepositoryListBox* self,
                                   GitgSelectionMode value)
{
	GitgSelectionMode old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_repository_list_box_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_MODE_PROPERTY]);
	}
}

gboolean
gitg_repository_list_box_get_bookmarks_from_recent_files (GitgRepositoryListBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bookmarks_from_recent_files;
	return result;
}

void
gitg_repository_list_box_set_bookmarks_from_recent_files (GitgRepositoryListBox* self,
                                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_repository_list_box_get_bookmarks_from_recent_files (self);
	if (old_value != value) {
		self->priv->_bookmarks_from_recent_files = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES_PROPERTY]);
	}
}

GFile*
gitg_repository_list_box_get_location (GitgRepositoryListBox* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	result = _tmp0_;
	return result;
}

void
gitg_repository_list_box_set_location (GitgRepositoryListBox* self,
                                       GFile* value)
{
	GFile* _tmp0_;
	GBookmarkFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->d_save_repository_bookmarks_id != ((guint) 0)) {
		g_source_remove (self->priv->d_save_repository_bookmarks_id);
		gitg_repository_list_box_save_repository_bookmarks (self);
	}
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = _tmp0_;
	_tmp1_ = g_bookmark_file_new ();
	_g_bookmark_file_free0 (self->priv->d_bookmark_file);
	self->priv->d_bookmark_file = _tmp1_;
	{
		GBookmarkFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->d_bookmark_file;
		_tmp3_ = g_file_get_path (value);
		_tmp4_ = _tmp3_;
		g_bookmark_file_load_from_file (_tmp2_, _tmp4_, &_inner_error0_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		gboolean _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = self->priv->_bookmarks_from_recent_files;
		if (_tmp5_) {
			gitg_repository_list_box_copy_bookmarks_from_recent_files (self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Failed to read repository bookmarks: ", _tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		fprintf (_tmp6_, "%s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_LOCATION_PROPERTY]);
}

gboolean
gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self)
{
	gboolean result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp0_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp1_;
				GitgRepositoryListBoxRow* _tmp2_;
				GitgRepositoryListBoxRow* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				_tmp1_ = row;
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
				r = _tmp2_;
				_tmp3_ = r;
				_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_) {
					result = TRUE;
					_g_object_unref0 (r);
					(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
					return result;
				}
				_g_object_unref0 (r);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	result = FALSE;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static inline gpointer
gitg_repository_list_box_row_get_instance_private (GitgRepositoryListBoxRow* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRepositoryListBoxRow_private_offset);
}

static void
gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->d_branch_name;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->d_branch_name;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		GtkLabel* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->priv->d_branch_label;
		_tmp4_ = self->priv->d_dirname;
		_tmp5_ = g_strdup_printf (_ ("at %s"), _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp3_, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp8_ = self->priv->d_dirname;
		if (_tmp8_ == NULL) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = self->priv->d_dirname;
			_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
		}
		if (_tmp7_) {
			GtkLabel* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->priv->d_branch_label;
			_tmp11_ = self->priv->d_branch_name;
			gtk_label_set_label (_tmp10_, _tmp11_);
		} else {
			GtkLabel* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = self->priv->d_branch_label;
			_tmp13_ = self->priv->d_branch_name;
			_tmp14_ = self->priv->d_dirname;
			_tmp15_ = g_strdup_printf (_ ("%s at %s"), _tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			gtk_label_set_label (_tmp12_, _tmp16_);
			_g_free0 (_tmp16_);
		}
	}
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
gitg_repository_list_box_row_update_repository_data (GitgRepositoryListBoxRow* self)
{
	gchar* head_name = NULL;
	gchar* _tmp0_;
	gchar* head_description = NULL;
	gchar* _tmp1_;
	GitgRepository* _tmp2_;
	gchar* _tmp64_ = NULL;
	GitgRepository* _tmp65_;
	GtkLabel* _tmp70_;
	const gchar* _tmp71_;
	GtkLabel* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	head_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	head_description = _tmp1_;
	_tmp2_ = self->priv->d_repository;
	if (_tmp2_ != NULL) {
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp3_;
			GitgRef* _tmp4_;
			GitgRef* _tmp5_;
			GitgParsedRefName* _tmp6_;
			GitgParsedRefName* _tmp7_;
			GitgParsedRefName* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GgitObject* _tmp11_ = NULL;
			GitgRef* _tmp12_;
			GgitObject* _tmp13_;
			GgitCommit* commit = NULL;
			GgitCommit* _tmp14_;
			GgitTree* tree = NULL;
			GgitCommit* _tmp15_;
			GgitTree* _tmp16_;
			GgitOId* entry_id = NULL;
			GgitOId* _tmp30_;
			_tmp3_ = self->priv->d_repository;
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error0_);
			head = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = head;
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (head_name);
			head_name = _tmp10_;
			_g_object_unref0 (_tmp8_);
			_tmp12_ = head;
			_tmp13_ = ggit_ref_lookup ((GgitRef*) _tmp12_, &_inner_error0_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (head);
				goto __catch0_g_error;
			}
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, ggit_commit_get_type (), GgitCommit));
			commit = _tmp14_;
			_tmp15_ = commit;
			_tmp16_ = ggit_commit_get_tree (_tmp15_);
			tree = _tmp16_;
			entry_id = NULL;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						GgitTree* _tmp19_;
						GgitTreeEntry* entry = NULL;
						GgitTree* _tmp20_;
						GgitTreeEntry* _tmp21_;
						gchar* name = NULL;
						GgitTreeEntry* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_ = FALSE;
						const gchar* _tmp26_;
						if (!_tmp17_) {
							gint _tmp18_;
							_tmp18_ = i;
							i = _tmp18_ + 1;
						}
						_tmp17_ = FALSE;
						_tmp19_ = tree;
						if (!(((guint) i) < ggit_tree_size (_tmp19_))) {
							break;
						}
						_tmp20_ = tree;
						_tmp21_ = ggit_tree_get (_tmp20_, (guint) i);
						entry = _tmp21_;
						_tmp22_ = entry;
						_tmp23_ = ggit_tree_entry_get_name (_tmp22_);
						_tmp24_ = g_strdup (_tmp23_);
						name = _tmp24_;
						_tmp26_ = name;
						if (_tmp26_ != NULL) {
							const gchar* _tmp27_;
							_tmp27_ = name;
							_tmp25_ = g_str_has_suffix (_tmp27_, ".doap");
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							GgitTreeEntry* _tmp28_;
							GgitOId* _tmp29_;
							_tmp28_ = entry;
							_tmp29_ = ggit_tree_entry_get_id (_tmp28_);
							__vala_GgitOId_free0 (entry_id);
							entry_id = _tmp29_;
							_g_free0 (name);
							_ggit_tree_entry_unref0 (entry);
							break;
						}
						_g_free0 (name);
						_ggit_tree_entry_unref0 (entry);
					}
				}
			}
			_tmp30_ = entry_id;
			if (_tmp30_ != NULL) {
				GgitBlob* blob = NULL;
				GitgRepository* _tmp31_;
				GgitOId* _tmp32_;
				gpointer _tmp33_;
				guint8* content = NULL;
				GgitBlob* _tmp34_;
				gsize _tmp35_ = 0;
				guint8* _tmp36_;
				gint content_length1;
				gint _content_size_;
				IdeDoap* doap = NULL;
				IdeDoap* _tmp37_;
				IdeDoap* _tmp38_;
				guint8* _tmp39_;
				gint _tmp39__length1;
				IdeDoap* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				IdeDoap* _tmp43_;
				gchar** _tmp44_;
				gchar** _tmp45_;
				_tmp31_ = self->priv->d_repository;
				_tmp32_ = entry_id;
				_tmp33_ = gitg_repository_lookup (_tmp31_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp32_, &_inner_error0_);
				blob = (GgitBlob*) _tmp33_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_GgitOId_free0 (entry_id);
					_g_object_unref0 (tree);
					_g_object_unref0 (commit);
					_g_object_unref0 (_tmp11_);
					_g_object_unref0 (head);
					goto __catch0_g_error;
				}
				_tmp34_ = blob;
				_tmp36_ = ggit_blob_get_raw_content (_tmp34_, &_tmp35_);
				content = _tmp36_;
				content_length1 = _tmp35_;
				_content_size_ = content_length1;
				_tmp37_ = ide_doap_new ();
				doap = _tmp37_;
				_tmp38_ = doap;
				_tmp39_ = content;
				_tmp39__length1 = content_length1;
				ide_doap_load_from_data (_tmp38_, (const gchar*) _tmp39_, (gsize) -1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (doap);
					_g_object_unref0 (blob);
					__vala_GgitOId_free0 (entry_id);
					_g_object_unref0 (tree);
					_g_object_unref0 (commit);
					_g_object_unref0 (_tmp11_);
					_g_object_unref0 (head);
					goto __catch0_g_error;
				}
				_tmp40_ = doap;
				_tmp41_ = ide_doap_get_shortdesc (_tmp40_);
				_tmp42_ = g_strdup (_tmp41_);
				_g_free0 (head_description);
				head_description = _tmp42_;
				_tmp43_ = doap;
				_tmp45_ = _tmp44_ = ide_doap_get_languages (_tmp43_);
				{
					gchar** lang_collection = NULL;
					gint lang_collection_length1 = 0;
					gint _lang_collection_size_ = 0;
					gint lang_it = 0;
					lang_collection = _tmp45_;
					lang_collection_length1 = _vala_array_length (_tmp44_);
					for (lang_it = 0; lang_it < lang_collection_length1; lang_it = lang_it + 1) {
						gchar* _tmp46_;
						gchar* lang = NULL;
						_tmp46_ = g_strdup (lang_collection[lang_it]);
						lang = _tmp46_;
						{
							GtkFrame* frame = NULL;
							GtkFrame* _tmp47_;
							GtkFrame* _tmp48_;
							GtkFrame* _tmp49_;
							GtkStyleContext* _tmp50_;
							GtkFrame* _tmp51_;
							GtkLabel* label = NULL;
							const gchar* _tmp52_;
							GtkLabel* _tmp53_;
							PangoAttrList* attr_list = NULL;
							PangoAttrList* _tmp54_;
							PangoAttrList* _tmp55_;
							PangoAttribute* _tmp56_;
							GtkLabel* _tmp57_;
							PangoAttrList* _tmp58_;
							GtkLabel* _tmp59_;
							GtkFrame* _tmp60_;
							GtkLabel* _tmp61_;
							GtkBox* _tmp62_;
							GtkFrame* _tmp63_;
							_tmp47_ = (GtkFrame*) gtk_frame_new (NULL);
							g_object_ref_sink (_tmp47_);
							frame = _tmp47_;
							_tmp48_ = frame;
							gtk_frame_set_shadow_type (_tmp48_, GTK_SHADOW_NONE);
							_tmp49_ = frame;
							_tmp50_ = gtk_widget_get_style_context ((GtkWidget*) _tmp49_);
							gtk_style_context_add_class (_tmp50_, "language-frame");
							_tmp51_ = frame;
							gtk_widget_show ((GtkWidget*) _tmp51_);
							_tmp52_ = lang;
							_tmp53_ = (GtkLabel*) gtk_label_new (_tmp52_);
							g_object_ref_sink (_tmp53_);
							label = _tmp53_;
							_tmp54_ = pango_attr_list_new ();
							attr_list = _tmp54_;
							_tmp55_ = attr_list;
							_tmp56_ = pango_attr_scale_new (PANGO_SCALE_SMALL);
							pango_attr_list_insert (_tmp55_, _tmp56_);
							_tmp57_ = label;
							_tmp58_ = attr_list;
							gtk_label_set_attributes (_tmp57_, _tmp58_);
							_tmp59_ = label;
							gtk_widget_show ((GtkWidget*) _tmp59_);
							_tmp60_ = frame;
							_tmp61_ = label;
							gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
							_tmp62_ = self->priv->d_languages_box;
							_tmp63_ = frame;
							gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
							_pango_attr_list_unref0 (attr_list);
							_g_object_unref0 (label);
							_g_object_unref0 (frame);
							_g_free0 (lang);
						}
					}
				}
				_g_object_unref0 (doap);
				_g_object_unref0 (blob);
			}
			__vala_GgitOId_free0 (entry_id);
			_g_object_unref0 (tree);
			_g_object_unref0 (commit);
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (head);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (head_description);
			_g_free0 (head_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp65_ = self->priv->d_repository;
	if (_tmp65_ != NULL) {
		GitgRepository* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp66_ = self->priv->d_repository;
		_tmp67_ = gitg_repository_get_name (_tmp66_);
		_tmp68_ = _tmp67_;
		_g_free0 (_tmp64_);
		_tmp64_ = _tmp68_;
	} else {
		gchar* _tmp69_;
		_tmp69_ = g_strdup ("");
		_g_free0 (_tmp64_);
		_tmp64_ = _tmp69_;
	}
	gitg_repository_list_box_row_set_repository_name (self, _tmp64_);
	_tmp70_ = self->priv->d_description_label;
	_tmp71_ = head_description;
	gtk_label_set_label (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->d_description_label;
	_tmp73_ = head_description;
	gtk_widget_set_visible ((GtkWidget*) _tmp72_, g_strcmp0 (_tmp73_, "") != 0);
	_tmp74_ = head_name;
	gitg_repository_list_box_row_set_branch_name (self, _tmp74_);
	_g_free0 (_tmp64_);
	_g_free0 (head_description);
	_g_free0 (head_name);
}

GitgRepositoryListBoxRow*
gitg_repository_list_box_row_construct (GType object_type,
                                        GitgRepository* repository,
                                        const gchar* dirname)
{
	GitgRepositoryListBoxRow * self = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository", repository, "dirname", dirname, NULL);
	return self;
}

GitgRepositoryListBoxRow*
gitg_repository_list_box_row_new (GitgRepository* repository,
                                  const gchar* dirname)
{
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, repository, dirname);
}

GitgSelectionMode
gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self)
{
	GitgSelectionMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_mode;
	return result;
}

void
gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self,
                                       GitgSelectionMode value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_mode != value) {
		GtkRevealer* _tmp0_;
		GtkCheckButton* _tmp1_;
		self->priv->d_mode = value;
		_tmp0_ = self->priv->d_remove_revealer;
		gtk_revealer_set_reveal_child (_tmp0_, self->priv->d_mode == GITG_SELECTION_MODE_SELECTION);
		_tmp1_ = self->priv->d_remove_check_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_MODE_PROPERTY]);
}

gboolean
gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_repository_list_box_row_get_selected (self);
	if (old_value != value) {
		self->priv->_selected = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_SELECTED_PROPERTY]);
	}
}

GitgRepository*
gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_repository;
	result = _tmp0_;
	return result;
}

void
gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self,
                                             GitgRepository* value)
{
	GitgRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_repository);
	self->priv->d_repository = _tmp0_;
	gitg_repository_list_box_row_update_repository_data (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_PROPERTY]);
}

gboolean
gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_remove_check_button;
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self,
                                             gboolean value)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_remove_check_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE_PROPERTY]);
}

GDateTime*
gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_time;
	result = _tmp0_;
	return result;
}

void
gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self,
                                       GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->d_time);
	self->priv->d_time = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_TIME_PROPERTY]);
}

void
gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self,
                                           gdouble value)
{
	GitgProgressBin* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_progress_bin;
	gitg_progress_bin_set_fraction (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_FRACTION_PROPERTY]);
}

const gchar*
gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_repository_label;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self,
                                                  const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_repository_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME_PROPERTY]);
}

const gchar*
gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_dirname;
	result = _tmp0_;
	return result;
}

void
gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->d_dirname);
	self->priv->d_dirname = _tmp0_;
	gitg_repository_list_box_row_update_branch_label (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME_PROPERTY]);
}

const gchar*
gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_branch_name;
	result = _tmp0_;
	return result;
}

void
gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self,
                                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->d_branch_name);
	self->priv->d_branch_name = _tmp0_;
	gitg_repository_list_box_row_update_branch_label (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME_PROPERTY]);
}

gboolean
gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_loading;
	return result;
}

void
gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_loading = value;
	if (!self->priv->d_loading) {
		GtkSpinner* _tmp0_;
		GtkSpinner* _tmp1_;
		GitgProgressBin* _tmp2_;
		_tmp0_ = self->priv->d_spinner;
		gtk_spinner_stop (_tmp0_);
		_tmp1_ = self->priv->d_spinner;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->d_progress_bin;
		gitg_progress_bin_set_fraction (_tmp2_, (gdouble) 0);
	} else {
		GtkSpinner* _tmp3_;
		GtkSpinner* _tmp4_;
		_tmp3_ = self->priv->d_spinner;
		gtk_widget_show ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->d_spinner;
		gtk_spinner_start (_tmp4_);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_LOADING_PROPERTY]);
}

static GObject *
gitg_repository_list_box_row_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBoxRow * self;
	GtkCheckButton* _tmp0_;
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
	_tmp0_ = self->priv->d_remove_check_button;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) self, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass,
                                         gpointer klass_data)
{
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRepositoryListBoxRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_MODE_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_SELECTED_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE_PROPERTY] = g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_TIME_PROPERTY] = g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_FRACTION_PROPERTY] = g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME_PROPERTY] = g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME_PROPERTY] = g_param_spec_string ("dirname", "dirname", "dirname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME_PROPERTY] = g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING_PROPERTY, gitg_repository_list_box_row_properties[GITG_REPOSITORY_LIST_BOX_ROW_LOADING_PROPERTY] = g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-repository-list-box-row.ui");
	gitg_repository_list_box_row_signals[GITG_REPOSITORY_LIST_BOX_ROW_REQUEST_REMOVE_SIGNAL] = g_signal_new ("request-remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gitg_repository_list_box_row_signals[GITG_REPOSITORY_LIST_BOX_ROW_REQUEST_DELETE_SOURCE_SIGNAL] = g_signal_new ("request-delete-source", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_description_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_check_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_check_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_revealer", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_languages_box", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_languages_box));
}

static void
gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self,
                                            gpointer klass)
{
	GDateTime* _tmp0_;
	self->priv = gitg_repository_list_box_row_get_instance_private (self);
	_tmp0_ = g_date_time_new_now_local ();
	self->priv->d_time = _tmp0_;
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_repository_list_box_row_finalize (GObject * obj)
{
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
	_g_object_unref0 (self->priv->d_repository);
	_g_date_time_unref0 (self->priv->d_time);
	_g_free0 (self->priv->d_dirname);
	_g_free0 (self->priv->d_branch_name);
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_repository_list_box_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
	GType gitg_repository_list_box_row_type_id;
	gitg_repository_list_box_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgRepositoryListBoxRow", &g_define_type_info, 0);
	GitgRepositoryListBoxRow_private_offset = g_type_add_instance_private (gitg_repository_list_box_row_type_id, sizeof (GitgRepositoryListBoxRowPrivate));
	return gitg_repository_list_box_row_type_id;
}

GType
gitg_repository_list_box_row_get_type (void)
{
	static gsize gitg_repository_list_box_row_type_id__once = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__once)) {
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = gitg_repository_list_box_row_get_type_once ();
		g_once_init_leave (&gitg_repository_list_box_row_type_id__once, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__once;
}

static void
_vala_gitg_repository_list_box_row_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
	switch (property_id) {
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE_PROPERTY:
		g_value_set_enum (value, gitg_repository_list_box_row_get_mode (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED_PROPERTY:
		g_value_set_boolean (value, gitg_repository_list_box_row_get_selected (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_PROPERTY:
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE_PROPERTY:
		g_value_set_boolean (value, gitg_repository_list_box_row_get_can_remove (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME_PROPERTY:
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME_PROPERTY:
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME_PROPERTY:
		g_value_set_string (value, gitg_repository_list_box_row_get_dirname (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME_PROPERTY:
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING_PROPERTY:
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_repository_list_box_row_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
	switch (property_id) {
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE_PROPERTY:
		gitg_repository_list_box_row_set_mode (self, g_value_get_enum (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED_PROPERTY:
		gitg_repository_list_box_row_set_selected (self, g_value_get_boolean (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_PROPERTY:
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE_PROPERTY:
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME_PROPERTY:
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION_PROPERTY:
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME_PROPERTY:
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME_PROPERTY:
		gitg_repository_list_box_row_set_dirname (self, g_value_get_string (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME_PROPERTY:
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING_PROPERTY:
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                         GtkListBoxRow* before,
                                                                         gpointer self)
{
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
}

static gboolean
_gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                           gpointer self)
{
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
	return result;
}

static gint
_gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                  GtkListBoxRow* row2,
                                                                  gpointer self)
{
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
	return result;
}

static GObject *
gitg_repository_list_box_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
	GBookmarkFile* _tmp0_;
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	gtk_widget_show ((GtkWidget*) self);
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
	_tmp0_ = g_bookmark_file_new ();
	_g_bookmark_file_free0 (self->priv->d_bookmark_file);
	self->priv->d_bookmark_file = _tmp0_;
	return obj;
}

static void
gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass,
                                     gpointer klass_data)
{
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRepositoryListBox_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) gitg_repository_list_box_real_button_press_event;
	((GtkListBoxClass *) klass)->row_activated = (void (*) (GtkListBox*, GtkListBoxRow*)) gitg_repository_list_box_real_row_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_MODE_PROPERTY, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES_PROPERTY, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES_PROPERTY] = g_param_spec_boolean ("bookmarks-from-recent-files", "bookmarks-from-recent-files", "bookmarks-from-recent-files", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_LOCATION_PROPERTY, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_HAS_SELECTION_PROPERTY, gitg_repository_list_box_properties[GITG_REPOSITORY_LIST_BOX_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gitg_repository_list_box_signals[GITG_REPOSITORY_LIST_BOX_REPOSITORY_ACTIVATED_SIGNAL] = g_signal_new ("repository-activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
	gitg_repository_list_box_signals[GITG_REPOSITORY_LIST_BOX_SHOW_ERROR_SIGNAL] = g_signal_new ("show-error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}

static void
gitg_repository_list_box_instance_init (GitgRepositoryListBox * self,
                                        gpointer klass)
{
	self->priv = gitg_repository_list_box_get_instance_private (self);
	self->priv->_bookmarks_from_recent_files = TRUE;
}

static void
gitg_repository_list_box_finalize (GObject * obj)
{
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
	if (self->priv->d_save_repository_bookmarks_id != ((guint) 0)) {
		g_source_remove (self->priv->d_save_repository_bookmarks_id);
		gitg_repository_list_box_save_repository_bookmarks (self);
	}
	_g_free0 (self->priv->d_filter_text);
	_g_object_unref0 (self->priv->d_location);
	_g_bookmark_file_free0 (self->priv->d_bookmark_file);
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_repository_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
	GType gitg_repository_list_box_type_id;
	gitg_repository_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgRepositoryListBox", &g_define_type_info, 0);
	GitgRepositoryListBox_private_offset = g_type_add_instance_private (gitg_repository_list_box_type_id, sizeof (GitgRepositoryListBoxPrivate));
	return gitg_repository_list_box_type_id;
}

GType
gitg_repository_list_box_get_type (void)
{
	static gsize gitg_repository_list_box_type_id__once = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__once)) {
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = gitg_repository_list_box_get_type_once ();
		g_once_init_leave (&gitg_repository_list_box_type_id__once, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__once;
}

static void
_vala_gitg_repository_list_box_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
	switch (property_id) {
		case GITG_REPOSITORY_LIST_BOX_MODE_PROPERTY:
		g_value_set_enum (value, gitg_repository_list_box_get_mode (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES_PROPERTY:
		g_value_set_boolean (value, gitg_repository_list_box_get_bookmarks_from_recent_files (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_LOCATION_PROPERTY:
		g_value_set_object (value, gitg_repository_list_box_get_location (self));
		break;
		case GITG_REPOSITORY_LIST_BOX_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, gitg_repository_list_box_get_has_selection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_repository_list_box_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
	switch (property_id) {
		case GITG_REPOSITORY_LIST_BOX_MODE_PROPERTY:
		gitg_repository_list_box_set_mode (self, g_value_get_enum (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES_PROPERTY:
		gitg_repository_list_box_set_bookmarks_from_recent_files (self, g_value_get_boolean (value));
		break;
		case GITG_REPOSITORY_LIST_BOX_LOCATION_PROPERTY:
		gitg_repository_list_box_set_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

