/* gitg-animated-paned.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-animated-paned.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GITG_SLIDE_DIRECTION_IN,
	GITG_SLIDE_DIRECTION_OUT
} GitgSlideDirection;

#define GITG_TYPE_SLIDE_DIRECTION (gitg_slide_direction_get_type ())
typedef enum  {
	GITG_SLIDE_PANED_CHILD_FIRST,
	GITG_SLIDE_PANED_CHILD_SECOND
} GitgSlidePanedChild;

#define GITG_TYPE_SLIDE_PANED_CHILD (gitg_slide_paned_child_get_type ())

#define GITG_TYPE_ANIMATED_PANED (gitg_animated_paned_get_type ())
#define GITG_ANIMATED_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_ANIMATED_PANED, GitgAnimatedPaned))
#define GITG_ANIMATED_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_ANIMATED_PANED, GitgAnimatedPanedClass))
#define GITG_IS_ANIMATED_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_ANIMATED_PANED))
#define GITG_IS_ANIMATED_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_ANIMATED_PANED))
#define GITG_ANIMATED_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_ANIMATED_PANED, GitgAnimatedPanedClass))

typedef struct _GitgAnimatedPaned GitgAnimatedPaned;
typedef struct _GitgAnimatedPanedClass GitgAnimatedPanedClass;
typedef struct _GitgAnimatedPanedPrivate GitgAnimatedPanedPrivate;
enum  {
	GITG_ANIMATED_PANED_0_PROPERTY,
	GITG_ANIMATED_PANED_TRANSITION_DURATION_PROPERTY,
	GITG_ANIMATED_PANED_IS_ANIMATING_PROPERTY,
	GITG_ANIMATED_PANED_NUM_PROPERTIES
};
static GParamSpec* gitg_animated_paned_properties[GITG_ANIMATED_PANED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GitgAnimatedPanedSlideAsyncData GitgAnimatedPanedSlideAsyncData;

struct _GitgAnimatedPaned {
	GtkPaned parent_instance;
	GitgAnimatedPanedPrivate * priv;
};

struct _GitgAnimatedPanedClass {
	GtkPanedClass parent_class;
};

struct _GitgAnimatedPanedPrivate {
	gint d_target_pos;
	gint d_original_pos;
	gint d_start_pos;
	gint64 d_slide_start;
	gint64 d_slide_duration;
	guint d_tick_id;
	GSourceFunc d_async_callback;
	gpointer d_async_callback_target;
	GDestroyNotify d_async_callback_target_destroy_notify;
	GitgSlideDirection d_direction;
	GitgSlidePanedChild d_child;
	guint _transition_duration;
};

struct _GitgAnimatedPanedSlideAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgAnimatedPaned* self;
	GitgSlidePanedChild child;
	GitgSlideDirection direction;
	gboolean should_animate;
	GtkSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GdkFrameClock* _tmp4_;
	gdouble factor;
	gint w;
	GtkOrientation _tmp5_;
	GtkOrientation _tmp6_;
	gdouble div;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	guint _tmp9_;
};

static gint GitgAnimatedPaned_private_offset;
static gpointer gitg_animated_paned_parent_class = NULL;

VALA_EXTERN GType gitg_slide_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_slide_paned_child_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_animated_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgAnimatedPaned, g_object_unref)
static gboolean gitg_animated_paned_update_position (GitgAnimatedPaned* self,
                                              gdouble factor);
static gboolean gitg_animated_paned_on_animate_step (GitgAnimatedPaned* self,
                                              GtkWidget* widget,
                                              GdkFrameClock* clock);
static void gitg_animated_paned_real_dispose (GObject* base);
VALA_EXTERN void gitg_animated_paned_slide (GitgAnimatedPaned* self,
                                GitgSlidePanedChild child,
                                GitgSlideDirection direction);
static void gitg_animated_paned_slide_async (GitgAnimatedPaned* self,
                                      GitgSlidePanedChild child,
                                      GitgSlideDirection direction,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void gitg_animated_paned_slide_finish (GitgAnimatedPaned* self,
                                       GAsyncResult* _res_);
static void __lambda106_ (GitgAnimatedPaned* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda106__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void gitg_animated_paned_slide_async_data_free (gpointer _data);
static gboolean gitg_animated_paned_slide_async_co (GitgAnimatedPanedSlideAsyncData* _data_);
static gboolean _gitg_animated_paned_on_animate_step_gtk_tick_callback (GtkWidget* widget,
                                                                 GdkFrameClock* frame_clock,
                                                                 gpointer self);
static gboolean _gitg_animated_paned_slide_async_co_gsource_func (gpointer self);
VALA_EXTERN guint gitg_animated_paned_get_transition_duration (GitgAnimatedPaned* self);
static gboolean ___lambda105_ (GitgAnimatedPaned* self);
static gboolean ____lambda105__gsource_func (gpointer self);
VALA_EXTERN GitgAnimatedPaned* gitg_animated_paned_new (void);
VALA_EXTERN GitgAnimatedPaned* gitg_animated_paned_construct (GType object_type);
VALA_EXTERN void gitg_animated_paned_set_transition_duration (GitgAnimatedPaned* self,
                                                  guint value);
VALA_EXTERN gboolean gitg_animated_paned_get_is_animating (GitgAnimatedPaned* self);
static void gitg_animated_paned_finalize (GObject * obj);
static GType gitg_animated_paned_get_type_once (void);
static void _vala_gitg_animated_paned_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gitg_animated_paned_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
gitg_slide_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_SLIDE_DIRECTION_IN, "GITG_SLIDE_DIRECTION_IN", "in"}, {GITG_SLIDE_DIRECTION_OUT, "GITG_SLIDE_DIRECTION_OUT", "out"}, {0, NULL, NULL}};
	GType gitg_slide_direction_type_id;
	gitg_slide_direction_type_id = g_enum_register_static ("GitgSlideDirection", values);
	return gitg_slide_direction_type_id;
}

GType
gitg_slide_direction_get_type (void)
{
	static gsize gitg_slide_direction_type_id__once = 0;
	if (g_once_init_enter (&gitg_slide_direction_type_id__once)) {
		GType gitg_slide_direction_type_id;
		gitg_slide_direction_type_id = gitg_slide_direction_get_type_once ();
		g_once_init_leave (&gitg_slide_direction_type_id__once, gitg_slide_direction_type_id);
	}
	return gitg_slide_direction_type_id__once;
}

 G_GNUC_NO_INLINE static GType
gitg_slide_paned_child_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_SLIDE_PANED_CHILD_FIRST, "GITG_SLIDE_PANED_CHILD_FIRST", "first"}, {GITG_SLIDE_PANED_CHILD_SECOND, "GITG_SLIDE_PANED_CHILD_SECOND", "second"}, {0, NULL, NULL}};
	GType gitg_slide_paned_child_type_id;
	gitg_slide_paned_child_type_id = g_enum_register_static ("GitgSlidePanedChild", values);
	return gitg_slide_paned_child_type_id;
}

GType
gitg_slide_paned_child_get_type (void)
{
	static gsize gitg_slide_paned_child_type_id__once = 0;
	if (g_once_init_enter (&gitg_slide_paned_child_type_id__once)) {
		GType gitg_slide_paned_child_type_id;
		gitg_slide_paned_child_type_id = gitg_slide_paned_child_get_type_once ();
		g_once_init_leave (&gitg_slide_paned_child_type_id__once, gitg_slide_paned_child_type_id);
	}
	return gitg_slide_paned_child_type_id__once;
}

static inline gpointer
gitg_animated_paned_get_instance_private (GitgAnimatedPaned* self)
{
	return G_STRUCT_MEMBER_P (self, GitgAnimatedPaned_private_offset);
}

static gboolean
gitg_animated_paned_update_position (GitgAnimatedPaned* self,
                                     gdouble factor)
{
	gint pos = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	pos = ((gint) round ((self->priv->d_target_pos - self->priv->d_start_pos) * factor)) + self->priv->d_start_pos;
	gtk_paned_set_position ((GtkPaned*) self, pos);
	gtk_widget_queue_draw ((GtkWidget*) self);
	if (pos == self->priv->d_target_pos) {
		GSourceFunc _tmp0_;
		gpointer _tmp0__target;
		self->priv->d_tick_id = (guint) 0;
		_tmp0_ = self->priv->d_async_callback;
		_tmp0__target = self->priv->d_async_callback_target;
		if (_tmp0_ != NULL) {
			GSourceFunc _tmp1_;
			gpointer _tmp1__target;
			_tmp1_ = self->priv->d_async_callback;
			_tmp1__target = self->priv->d_async_callback_target;
			_tmp1_ (_tmp1__target);
		}
		if (self->priv->d_direction == GITG_SLIDE_DIRECTION_OUT) {
			if (self->priv->d_child == GITG_SLIDE_PANED_CHILD_FIRST) {
				GtkWidget* _tmp2_;
				_tmp2_ = gtk_paned_get_child1 ((GtkPaned*) self);
				gtk_widget_hide (_tmp2_);
			} else {
				GtkWidget* _tmp3_;
				_tmp3_ = gtk_paned_get_child2 ((GtkPaned*) self);
				gtk_widget_hide (_tmp3_);
			}
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
gitg_animated_paned_on_animate_step (GitgAnimatedPaned* self,
                                     GtkWidget* widget,
                                     GdkFrameClock* clock)
{
	gint64 elapsed = 0LL;
	gdouble factor = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (clock != NULL, FALSE);
	elapsed = gdk_frame_clock_get_frame_time (clock) - self->priv->d_slide_start;
	factor = ((gdouble) elapsed) / ((gdouble) self->priv->d_slide_duration);
	if (!gitg_animated_paned_update_position (self, fmin (factor, (gdouble) 1))) {
		self->priv->d_tick_id = (guint) 0;
		g_object_notify ((GObject*) self, "is-animating");
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
gitg_animated_paned_real_dispose (GObject* base)
{
	GitgAnimatedPaned * self;
	self = (GitgAnimatedPaned*) base;
	if (self->priv->d_tick_id != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->d_tick_id);
		self->priv->d_tick_id = (guint) 0;
	}
	G_OBJECT_CLASS (gitg_animated_paned_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_paned_get_type (), GtkPaned));
}

static void
__lambda106_ (GitgAnimatedPaned* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	gitg_animated_paned_slide_finish (self, res);
}

static void
___lambda106__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda106_ ((GitgAnimatedPaned*) self, source_object, res);
	g_object_unref (self);
}

void
gitg_animated_paned_slide (GitgAnimatedPaned* self,
                           GitgSlidePanedChild child,
                           GitgSlideDirection direction)
{
	g_return_if_fail (self != NULL);
	gitg_animated_paned_slide_async (self, child, direction, ___lambda106__gasync_ready_callback, g_object_ref (self));
}

static void
gitg_animated_paned_slide_async_data_free (gpointer _data)
{
	GitgAnimatedPanedSlideAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgAnimatedPanedSlideAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_animated_paned_slide_async (GitgAnimatedPaned* self,
                                 GitgSlidePanedChild child,
                                 GitgSlideDirection direction,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GitgAnimatedPanedSlideAsyncData* _data_;
	GitgAnimatedPaned* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgAnimatedPanedSlideAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_animated_paned_slide_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->child = child;
	_data_->direction = direction;
	gitg_animated_paned_slide_async_co (_data_);
}

static void
gitg_animated_paned_slide_finish (GitgAnimatedPaned* self,
                                  GAsyncResult* _res_)
{
	GitgAnimatedPanedSlideAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_gitg_animated_paned_on_animate_step_gtk_tick_callback (GtkWidget* widget,
                                                        GdkFrameClock* frame_clock,
                                                        gpointer self)
{
	gboolean result;
	result = gitg_animated_paned_on_animate_step ((GitgAnimatedPaned*) self, widget, frame_clock);
	return result;
}

static gboolean
_gitg_animated_paned_slide_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = gitg_animated_paned_slide_async_co (self);
	return result;
}

static gboolean
___lambda105_ (GitgAnimatedPaned* self)
{
	gboolean result;
	gitg_animated_paned_update_position (self, (gdouble) 1);
	result = FALSE;
	return result;
}

static gboolean
____lambda105__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda105_ ((GitgAnimatedPaned*) self);
	return result;
}

static gboolean
gitg_animated_paned_slide_async_co (GitgAnimatedPanedSlideAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_widget_get_settings ((GtkWidget*) _data_->self);
	g_object_get (_data_->_tmp0_, "gtk-enable-animations", &_data_->_tmp1_, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->should_animate = _data_->_tmp2_;
	if (_data_->self->priv->d_tick_id == ((guint) 0)) {
		if (_data_->direction == GITG_SLIDE_DIRECTION_OUT) {
			_data_->self->priv->d_original_pos = gtk_paned_get_position ((GtkPaned*) _data_->self);
		}
		if (_data_->should_animate) {
			_data_->self->priv->d_tick_id = gtk_widget_add_tick_callback ((GtkWidget*) _data_->self, _gitg_animated_paned_on_animate_step_gtk_tick_callback, g_object_ref (_data_->self), g_object_unref);
			g_object_notify ((GObject*) _data_->self, "is-animating");
		}
	} else {
		if (_data_->self->priv->d_tick_id != ((guint) 0)) {
			_data_->_tmp3_ = !_data_->should_animate;
		} else {
			_data_->_tmp3_ = FALSE;
		}
		if (_data_->_tmp3_) {
			gtk_widget_remove_tick_callback ((GtkWidget*) _data_->self, _data_->self->priv->d_tick_id);
			_data_->self->priv->d_tick_id = (guint) 0;
			g_object_notify ((GObject*) _data_->self, "is-animating");
		}
	}
	_data_->_tmp4_ = gtk_widget_get_frame_clock ((GtkWidget*) _data_->self);
	_data_->self->priv->d_slide_start = gdk_frame_clock_get_frame_time (_data_->_tmp4_);
	_data_->self->priv->d_start_pos = gtk_paned_get_position ((GtkPaned*) _data_->self);
	_data_->self->priv->d_direction = _data_->direction;
	_data_->self->priv->d_child = _data_->child;
	_data_->_tmp5_ = gtk_orientable_get_orientation ((GtkOrientable*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_ == GTK_ORIENTATION_VERTICAL) {
		_data_->w = gtk_widget_get_allocated_height ((GtkWidget*) _data_->self);
	} else {
		_data_->w = gtk_widget_get_allocated_width ((GtkWidget*) _data_->self);
	}
	if (_data_->direction == GITG_SLIDE_DIRECTION_OUT) {
		if (_data_->child == GITG_SLIDE_PANED_CHILD_FIRST) {
			_data_->self->priv->d_target_pos = 0;
		} else {
			_data_->self->priv->d_target_pos = _data_->w;
		}
		_data_->factor = (((gdouble) _data_->self->priv->d_target_pos) - ((gdouble) _data_->self->priv->d_start_pos)) / (((gdouble) _data_->self->priv->d_target_pos) - ((gdouble) _data_->self->priv->d_original_pos));
	} else {
		_data_->self->priv->d_target_pos = _data_->self->priv->d_original_pos;
		if (_data_->child == GITG_SLIDE_PANED_CHILD_FIRST) {
			_data_->div = (gdouble) _data_->self->priv->d_original_pos;
			_data_->_tmp7_ = gtk_paned_get_child1 ((GtkPaned*) _data_->self);
			gtk_widget_show (_data_->_tmp7_);
		} else {
			_data_->div = (gdouble) (_data_->self->priv->d_original_pos - _data_->w);
			_data_->_tmp8_ = gtk_paned_get_child2 ((GtkPaned*) _data_->self);
			gtk_widget_show (_data_->_tmp8_);
		}
		_data_->factor = (((gdouble) _data_->self->priv->d_target_pos) - ((gdouble) _data_->self->priv->d_start_pos)) / _data_->div;
	}
	(_data_->self->priv->d_async_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->d_async_callback_target_destroy_notify (_data_->self->priv->d_async_callback_target), NULL);
	_data_->self->priv->d_async_callback = NULL;
	_data_->self->priv->d_async_callback_target = NULL;
	_data_->self->priv->d_async_callback_target_destroy_notify = NULL;
	_data_->self->priv->d_async_callback = _gitg_animated_paned_slide_async_co_gsource_func;
	_data_->self->priv->d_async_callback_target = _data_;
	_data_->self->priv->d_async_callback_target_destroy_notify = NULL;
	if (_data_->should_animate) {
		_data_->_tmp9_ = _data_->self->priv->_transition_duration;
		_data_->self->priv->d_slide_duration = ((gint64) (_data_->factor * _data_->_tmp9_)) * 1000;
	} else {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda105__gsource_func, g_object_ref (_data_->self), g_object_unref);
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GitgAnimatedPaned*
gitg_animated_paned_construct (GType object_type)
{
	GitgAnimatedPaned * self = NULL;
	self = (GitgAnimatedPaned*) g_object_new (object_type, NULL);
	return self;
}

GitgAnimatedPaned*
gitg_animated_paned_new (void)
{
	return gitg_animated_paned_construct (GITG_TYPE_ANIMATED_PANED);
}

guint
gitg_animated_paned_get_transition_duration (GitgAnimatedPaned* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_transition_duration;
	return result;
}

void
gitg_animated_paned_set_transition_duration (GitgAnimatedPaned* self,
                                             guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_animated_paned_get_transition_duration (self);
	if (old_value != value) {
		self->priv->_transition_duration = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_animated_paned_properties[GITG_ANIMATED_PANED_TRANSITION_DURATION_PROPERTY]);
	}
}

gboolean
gitg_animated_paned_get_is_animating (GitgAnimatedPaned* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_tick_id != ((guint) 0);
	return result;
}

static void
gitg_animated_paned_class_init (GitgAnimatedPanedClass * klass,
                                gpointer klass_data)
{
	gitg_animated_paned_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgAnimatedPaned_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_animated_paned_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_animated_paned_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_animated_paned_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_animated_paned_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ANIMATED_PANED_TRANSITION_DURATION_PROPERTY, gitg_animated_paned_properties[GITG_ANIMATED_PANED_TRANSITION_DURATION_PROPERTY] = g_param_spec_uint ("transition-duration", "transition-duration", "transition-duration", 0, G_MAXUINT, (guint) 250, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ANIMATED_PANED_IS_ANIMATING_PROPERTY, gitg_animated_paned_properties[GITG_ANIMATED_PANED_IS_ANIMATING_PROPERTY] = g_param_spec_boolean ("is-animating", "is-animating", "is-animating", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_animated_paned_instance_init (GitgAnimatedPaned * self,
                                   gpointer klass)
{
	self->priv = gitg_animated_paned_get_instance_private (self);
	self->priv->_transition_duration = (guint) 250;
}

static void
gitg_animated_paned_finalize (GObject * obj)
{
	GitgAnimatedPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_ANIMATED_PANED, GitgAnimatedPaned);
	(self->priv->d_async_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_async_callback_target_destroy_notify (self->priv->d_async_callback_target), NULL);
	self->priv->d_async_callback = NULL;
	self->priv->d_async_callback_target = NULL;
	self->priv->d_async_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gitg_animated_paned_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_animated_paned_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgAnimatedPanedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_animated_paned_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgAnimatedPaned), 0, (GInstanceInitFunc) gitg_animated_paned_instance_init, NULL };
	GType gitg_animated_paned_type_id;
	gitg_animated_paned_type_id = g_type_register_static (gtk_paned_get_type (), "GitgAnimatedPaned", &g_define_type_info, 0);
	GitgAnimatedPaned_private_offset = g_type_add_instance_private (gitg_animated_paned_type_id, sizeof (GitgAnimatedPanedPrivate));
	return gitg_animated_paned_type_id;
}

GType
gitg_animated_paned_get_type (void)
{
	static gsize gitg_animated_paned_type_id__once = 0;
	if (g_once_init_enter (&gitg_animated_paned_type_id__once)) {
		GType gitg_animated_paned_type_id;
		gitg_animated_paned_type_id = gitg_animated_paned_get_type_once ();
		g_once_init_leave (&gitg_animated_paned_type_id__once, gitg_animated_paned_type_id);
	}
	return gitg_animated_paned_type_id__once;
}

static void
_vala_gitg_animated_paned_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GitgAnimatedPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_ANIMATED_PANED, GitgAnimatedPaned);
	switch (property_id) {
		case GITG_ANIMATED_PANED_TRANSITION_DURATION_PROPERTY:
		g_value_set_uint (value, gitg_animated_paned_get_transition_duration (self));
		break;
		case GITG_ANIMATED_PANED_IS_ANIMATING_PROPERTY:
		g_value_set_boolean (value, gitg_animated_paned_get_is_animating (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_animated_paned_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GitgAnimatedPaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_ANIMATED_PANED, GitgAnimatedPaned);
	switch (property_id) {
		case GITG_ANIMATED_PANED_TRANSITION_DURATION_PROPERTY:
		gitg_animated_paned_set_transition_duration (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

