/* gitg-stage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-stage.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>

#define GITG_STAGE_CONFIG_USER_SIGNINGKEY "user.signingkey"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GitgParamSpecPatchSet GitgParamSpecPatchSet;
enum  {
	GITG_STAGE_0_PROPERTY,
	GITG_STAGE_NUM_PROPERTIES
};
static GParamSpec* gitg_stage_properties[GITG_STAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*GitgStageWithIndexFunc) (GgitIndex* index, gpointer user_data, GError** error);
typedef struct _GitgStageRefreshData GitgStageRefreshData;
typedef struct _Block32Data Block32Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgStageGetHeadTreeData GitgStageGetHeadTreeData;
typedef struct _Block33Data Block33Data;
typedef struct _GitgStageThreadIndexData GitgStageThreadIndexData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
typedef struct _Block34Data Block34Data;
typedef struct _GitgStagePreCommitHookData GitgStagePreCommitHookData;
typedef struct _Block35Data Block35Data;
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
typedef struct _Block36Data Block36Data;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
typedef struct _Block37Data Block37Data;
typedef struct _GitgStageCommitIndexData GitgStageCommitIndexData;
typedef struct _Block38Data Block38Data;
#define _ggit_reflog_unref0(var) ((var == NULL) ? NULL : (var = (ggit_reflog_unref (var), NULL)))
typedef struct _GitgStageCommitTreeData GitgStageCommitTreeData;
typedef struct _Block39Data Block39Data;
typedef struct _GitgStageCommitData GitgStageCommitData;
typedef struct _Block40Data Block40Data;
#define _ggit_tree_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_tree_entry_unref (var), NULL)))
typedef struct _GitgStageRevertData GitgStageRevertData;
typedef struct _GitgStageRevertPathData GitgStageRevertPathData;
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))
typedef struct _Block41Data Block41Data;
#define _ggit_index_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entry_unref (var), NULL)))
#define _ggit_index_entries_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entries_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _GitgStageRevertPatchData GitgStageRevertPatchData;
typedef struct _Block42Data Block42Data;
typedef struct _GitgStageDeleteData GitgStageDeleteData;
typedef struct _GitgStageDeletePathData GitgStageDeletePathData;
typedef struct _Block43Data Block43Data;
typedef struct _GitgStageStageData GitgStageStageData;
typedef struct _GitgStageStagePathData GitgStageStagePathData;
typedef struct _Block44Data Block44Data;
typedef struct _GitgStageStageCommitData GitgStageStageCommitData;
typedef struct _Block45Data Block45Data;
typedef struct _GitgStageStagePatchData GitgStageStagePatchData;
typedef struct _Block46Data Block46Data;
typedef struct _GitgStageUnstageData GitgStageUnstageData;
typedef struct _GitgStageUnstagePathData GitgStageUnstagePathData;
typedef struct _Block47Data Block47Data;
typedef struct _Block48Data Block48Data;
typedef struct _GitgStageUnstagePatchData GitgStageUnstagePatchData;
typedef struct _GitgStageDiffIndexAllData GitgStageDiffIndexAllData;
typedef struct _GitgStageDiffIndexData GitgStageDiffIndexData;
typedef struct _GitgStageDiffWorkdirAllData GitgStageDiffWorkdirAllData;
typedef struct _GitgStageDiffWorkdirData GitgStageDiffWorkdirData;

struct _GitgParamSpecPatchSet {
	GParamSpec parent_instance;
};

struct _GitgStagePrivate {
	GitgRepository* d_repository;
	GMutex d_index_mutex;
	GRecMutex __lock_d_index_mutex;
	GgitTree* d_head_tree;
};

struct _GitgStageRefreshData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GError* _inner_error0_;
};

struct _Block32Data {
	int _ref_count_;
	GitgStage* self;
	GError* e;
	gpointer _async_data_;
};

struct _GitgStageGetHeadTreeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GgitTree* result;
	Block32Data* _data32_;
	GgitTree* _tmp0_;
	GgitTree* _tmp1_;
	GgitTree* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GgitTree* _tmp6_;
	GgitTree* _tmp7_;
	GError* _inner_error0_;
};

struct _Block33Data {
	int _ref_count_;
	GitgStage* self;
	GitgStageWithIndexFunc func;
	gpointer func_target;
	gpointer _async_data_;
};

struct _GitgStageThreadIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgStageWithIndexFunc func;
	gpointer func_target;
	Block33Data* _data33_;
	GError* _inner_error0_;
};

struct _Block34Data {
	int _ref_count_;
	GitgStage* self;
	gchar* errormsg;
	GgitSignature* author;
	gpointer _async_data_;
};

struct _GitgStagePreCommitHookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GgitSignature* author;
	Block34Data* _data34_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_;
};

struct _Block35Data {
	int _ref_count_;
	GitgStage* self;
	gboolean has_changes;
};

struct _Block36Data {
	int _ref_count_;
	GitgStage* self;
	GitgHook* hook;
};

struct _Block37Data {
	int _ref_count_;
	GitgStage* self;
	GgitOId* treeoid;
	GgitIndex* index;
	gpointer _async_data_;
};

struct _GitgStageCommitIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GgitIndex* index;
	GgitRef* reference;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GgitOId** parents;
	gint parents_length1;
	GitgStageCommitOptions options;
	GgitOId* result;
	Block37Data* _data37_;
	GgitOId* _tmp0_;
	GgitOId* _tmp1_;
	GgitOId* _tmp2_;
	GgitOId* _tmp3_;
	GError* _inner_error0_;
};

struct _Block38Data {
	int _ref_count_;
	GitgStage* self;
	GgitOId* ret;
	GgitOId* treeoid;
	GgitRef* reference;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GgitOId** parents;
	gint parents_length1;
	GitgStageCommitOptions options;
	gpointer _async_data_;
};

struct _GitgStageCommitTreeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GgitOId* treeoid;
	GgitRef* reference;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GgitOId** parents;
	gint parents_length1;
	GitgStageCommitOptions options;
	GgitOId* result;
	Block38Data* _data38_;
	GgitOId* _tmp0_;
	GError* _inner_error0_;
};

struct _Block39Data {
	int _ref_count_;
	GitgStage* self;
	GgitIndex* index;
};

struct _GitgStageCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	gchar* message;
	GgitSignature* author;
	GgitSignature* committer;
	GitgStageCommitOptions options;
	GgitOId* result;
	gboolean amend;
	GgitOId* ret;
	Block39Data* _data39_;
	gboolean _tmp0_;
	GError* _tmp1_;
	GitgRef* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRef* _tmp4_;
	GgitOId* _tmp5_;
	GgitIndex* _tmp6_;
	GgitOId* _tmp7_;
	GgitOId* _tmp8_;
	GError* _lock_error_;
	GError* _tmp9_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _Block40Data {
	int _ref_count_;
	GitgStage* self;
	GgitTree* tree;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageRevertData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GFile* file;
	Block40Data* _data40_;
	GgitTree* _tmp0_;
	GError* _inner_error0_;
};

struct _GitgStageRevertPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_;
};

struct _Block41Data {
	int _ref_count_;
	GitgStage* self;
	GFile* workdirf;
	GFileInputStream* workdirf_stream;
	GitgPatchSet* patch;
	gpointer _async_data_;
};

struct _GitgStageRevertPatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgPatchSet* patch;
	Block41Data* _data41_;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFileInputStream* _tmp7_;
	GError* _inner_error0_;
};

struct _Block42Data {
	int _ref_count_;
	GitgStage* self;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GFile* file;
	Block42Data* _data42_;
	GError* _inner_error0_;
};

struct _GitgStageDeletePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_;
};

struct _Block43Data {
	int _ref_count_;
	GitgStage* self;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageStageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GFile* file;
	Block43Data* _data43_;
	GError* _inner_error0_;
};

struct _GitgStageStagePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_;
};

struct _Block44Data {
	int _ref_count_;
	GitgStage* self;
	gchar* path;
	GgitCommit* commit;
	gpointer _async_data_;
};

struct _GitgStageStageCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	gchar* path;
	GgitCommit* commit;
	Block44Data* _data44_;
	GError* _inner_error0_;
};

struct _Block45Data {
	int _ref_count_;
	GitgStage* self;
	GFile* newf;
	GFileInputStream* new_stream;
	GitgPatchSet* patch;
	gpointer _async_data_;
};

struct _GitgStageStagePatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgPatchSet* patch;
	Block45Data* _data45_;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFileInputStream* _tmp7_;
	GError* _inner_error0_;
};

struct _Block46Data {
	int _ref_count_;
	GitgStage* self;
	GgitTree* tree;
	GFile* file;
	gpointer _async_data_;
};

struct _GitgStageUnstageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GFile* file;
	Block46Data* _data46_;
	GgitTree* _tmp0_;
	GError* _inner_error0_;
};

struct _GitgStageUnstagePathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	gchar* path;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_;
};

struct _Block47Data {
	int _ref_count_;
	GitgStage* self;
	GFile* file;
	GgitTree* tree;
	GitgPatchSet* patch;
	gpointer _async_data_;
};

struct _Block48Data {
	int _ref_count_;
	Block47Data * _data47_;
	GitgStage* stage;
};

struct _GitgStageUnstagePatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgPatchSet* patch;
	Block47Data* _data47_;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GgitTree* _tmp6_;
	GError* _inner_error0_;
};

struct _GitgStageDiffIndexAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgStageStatusItem** files;
	gint files_length1;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiffOptions* opts;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	gchar** pspec;
	gchar** _tmp2_;
	gint pspec_length1;
	gint _pspec_size_;
	gint i;
	gboolean _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GitgStageStatusItem* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GgitDiffOptions* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GgitDiffOptions* _tmp11_;
	GgitDiffOptions* _tmp12_;
	GgitDiffOption _tmp13_;
	GgitDiffOption _tmp14_;
	GgitDiffOption _tmp15_;
	GgitDiffOption _tmp16_;
	GgitDiffOptions* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GgitDiffOptions* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GgitDiffOptions* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GgitDiffOptions* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GgitTree* tree;
	gboolean _tmp30_;
	GitgRepository* _tmp31_;
	GgitTree* _tmp32_;
	GgitTree* _tmp33_;
	GgitTree* _tmp34_;
	GgitIndex* _tmp35_;
	GitgRepository* _tmp36_;
	GgitIndex* _tmp37_;
	GgitDiff* _tmp38_;
	GitgRepository* _tmp39_;
	GgitTree* _tmp40_;
	GgitDiffOptions* _tmp41_;
	GgitDiff* _tmp42_;
	GgitDiff* _tmp43_;
	GError* _inner_error0_;
};

struct _GitgStageDiffIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgStageStatusItem* f;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiff* _tmp0_;
	GitgStageStatusItem* _tmp1_;
	GitgStageStatusItem** _tmp2_;
	GitgStageStatusItem** _tmp3_;
	gint _tmp3__length1;
	GgitDiff* _tmp4_;
	GgitDiff* _tmp5_;
	GgitDiff* _tmp6_;
	GError* _inner_error0_;
};

struct _GitgStageDiffWorkdirAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgStageStatusItem** files;
	gint files_length1;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiffOptions* opts;
	GgitDiffOptions* _tmp0_;
	GgitDiffOptions* _tmp1_;
	gchar** pspec;
	gchar** _tmp2_;
	gint pspec_length1;
	gint _pspec_size_;
	gint i;
	gboolean _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GitgStageStatusItem* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GgitDiffOptions* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GgitDiffOptions* _tmp11_;
	GgitDiffOptions* _tmp12_;
	GgitDiffOption _tmp13_;
	GgitDiffOption _tmp14_;
	GgitDiffOption _tmp15_;
	GgitDiffOption _tmp16_;
	GgitDiffOptions* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GgitDiffOptions* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GgitDiffOptions* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GgitDiffOptions* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GgitIndex* _tmp30_;
	GitgRepository* _tmp31_;
	GgitIndex* _tmp32_;
	GgitDiff* _tmp33_;
	GitgRepository* _tmp34_;
	GgitDiffOptions* _tmp35_;
	GgitDiff* _tmp36_;
	GgitDiff* _tmp37_;
	GError* _inner_error0_;
};

struct _GitgStageDiffWorkdirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgStage* self;
	GitgStageStatusItem* f;
	GgitDiffOptions* defopts;
	GgitDiff* result;
	GgitDiff* _tmp0_;
	GitgStageStatusItem* _tmp1_;
	GitgStageStatusItem** _tmp2_;
	GitgStageStatusItem** _tmp3_;
	gint _tmp3__length1;
	GgitDiff* _tmp4_;
	GgitDiff* _tmp5_;
	GgitDiff* _tmp6_;
	GError* _inner_error0_;
};

static gpointer gitg_patch_set_parent_class = NULL;
static gint GitgStage_private_offset;
static gpointer gitg_stage_parent_class = NULL;

static void gitg_patch_set_finalize (GitgPatchSet * obj);
static GType gitg_patch_set_get_type_once (void);
VALA_EXTERN GitgStage* gitg_stage_new (GitgRepository* repository);
VALA_EXTERN GitgStage* gitg_stage_construct (GType object_type,
                                 GitgRepository* repository);
static void gitg_stage_refresh_data_free (gpointer _data);
static gboolean gitg_stage_refresh_co (GitgStageRefreshData* _data_);
static void gitg_stage_thread_index (GitgStage* self,
                              GitgStageWithIndexFunc func,
                              gpointer func_target,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
static void gitg_stage_thread_index_finish (GitgStage* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static void __lambda6_ (GitgStage* self,
                 GgitIndex* index,
                 GError** error);
static void ___lambda6__gitg_stage_with_index_func (GgitIndex* index,
                                             gpointer self,
                                             GError** error);
static void gitg_stage_refresh_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_);
static void gitg_stage_get_head_tree_data_free (gpointer _data);
static gboolean gitg_stage_get_head_tree_co (GitgStageGetHeadTreeData* _data_);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda7_ (Block32Data* _data32_,
                 GError** error);
static void ___lambda7__gitg_async_thread_func (gpointer self,
                                         GError** error);
static void gitg_stage_get_head_tree_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
VALA_EXTERN GitgStageStatusEnumerator* gitg_stage_status_enumerator_new (GitgRepository* repository,
                                                             GgitStatusOptions* options);
VALA_EXTERN GitgStageStatusEnumerator* gitg_stage_status_enumerator_construct (GType object_type,
                                                                   GitgRepository* repository,
                                                                   GgitStatusOptions* options);
static void gitg_stage_with_index (GitgStage* self,
                            GitgStageWithIndexFunc func,
                            gpointer func_target,
                            GError** error);
static void gitg_stage_thread_index_data_free (gpointer _data);
static gboolean gitg_stage_thread_index_co (GitgStageThreadIndexData* _data_);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda5_ (Block33Data* _data33_,
                 GError** error);
static void ___lambda5__gitg_async_thread_func (gpointer self,
                                         GError** error);
static void gitg_stage_thread_index_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static gchar* gitg_stage_message_with_sign_off (GitgStage* self,
                                         const gchar* message,
                                         GgitSignature* committer);
static gchar* gitg_stage_convert_message_to_encoding (GitgStage* self,
                                               GgitConfig* conf,
                                               const gchar* message,
                                               gchar** encoding);
static void gitg_stage_setup_commit_hook_environment (GitgStage* self,
                                               GitgHook* hook,
                                               GgitSignature* author);
static void gitg_stage_pre_commit_hook_data_free (gpointer _data);
static gboolean gitg_stage_pre_commit_hook_co (GitgStagePreCommitHookData* _data_);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void ___lambda15_ (Block34Data* _data34_,
                   GError** error);
static void ____lambda15__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_stage_pre_commit_hook_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static gboolean gitg_stage_has_index_changes (GitgStage* self);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static gint ___lambda16_ (Block35Data* _data35_,
                   const gchar* path,
                   GgitStatusFlags flags);
static gint ____lambda16__ggit_status_callback (const gchar* path,
                                         GgitStatusFlags status_flags,
                                         gpointer self);
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
static gchar* gitg_stage_commit_msg_hook (GitgStage* self,
                                   const gchar* message,
                                   GgitSignature* author,
                                   GgitSignature* committer,
                                   GError** error);
static void gitg_stage_post_commit_hook (GitgStage* self,
                                  GgitSignature* author);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void __lambda17_ (Block36Data* _data36_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar* gitg_stage_get_subject (GitgStage* self,
                               const gchar* message);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_stage_commit_index_data_free (gpointer _data);
static gboolean gitg_stage_commit_index_co (GitgStageCommitIndexData* _data_);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static void __lambda18_ (Block37Data* _data37_,
                  GError** error);
static void ___lambda18__gitg_async_thread_func (gpointer self,
                                          GError** error);
static void gitg_stage_commit_index_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void gitg_stage_commit_tree_data_free (gpointer _data);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static gboolean gitg_stage_commit_tree_co (GitgStageCommitTreeData* _data_);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda19_ (Block38Data* _data38_,
                  GError** error);
static GgitOId** _vala_array_dup23 (GgitOId** self,
                             gssize length);
static void ___lambda19__gitg_async_thread_func (gpointer self,
                                          GError** error);
static void gitg_stage_commit_tree_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void gitg_stage_commit_data_free (gpointer _data);
static gboolean gitg_stage_commit_co (GitgStageCommitData* _data_);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void ___lambda20_ (Block39Data* _data39_,
                   GError** error);
static void ____lambda20__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_stage_commit_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_);
static void gitg_stage_revert_data_free (gpointer _data);
static gboolean gitg_stage_revert_co (GitgStageRevertData* _data_);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static void gitg_stage_revert_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_);
static void __lambda21_ (Block40Data* _data40_,
                  GgitIndex* index,
                  GError** error);
static void ___lambda21__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_revert_path_data_free (gpointer _data);
static gboolean gitg_stage_revert_path_co (GitgStageRevertPathData* _data_);
static void gitg_stage_revert_path_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void gitg_stage_revert_patch_data_free (gpointer _data);
static gboolean gitg_stage_revert_patch_co (GitgStageRevertPatchData* _data_);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void gitg_stage_revert_patch_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void __lambda22_ (Block41Data* _data41_,
                  GgitIndex* index,
                  GError** error);
static void gitg_stage_apply_patch_stream (GitgStage* self,
                                    GInputStream* old_stream,
                                    GInputStream* new_stream,
                                    GOutputStream* patched_stream,
                                    GitgPatchSet* patch,
                                    GError** error);
static void ___lambda22__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_delete_data_free (gpointer _data);
static gboolean gitg_stage_delete_co (GitgStageDeleteData* _data_);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static void __lambda23_ (Block42Data* _data42_,
                  GgitIndex* index,
                  GError** error);
static void ___lambda23__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_delete_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_);
static void gitg_stage_delete_path_data_free (gpointer _data);
static gboolean gitg_stage_delete_path_co (GitgStageDeletePathData* _data_);
static void gitg_stage_delete_path_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void gitg_stage_stage_data_free (gpointer _data);
static gboolean gitg_stage_stage_co (GitgStageStageData* _data_);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void __lambda24_ (Block43Data* _data43_,
                  GgitIndex* index,
                  GError** error);
static void ___lambda24__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_stage_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_);
static void gitg_stage_stage_path_data_free (gpointer _data);
static gboolean gitg_stage_stage_path_co (GitgStageStagePathData* _data_);
static void gitg_stage_stage_path_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
static void gitg_stage_stage_commit_data_free (gpointer _data);
static gboolean gitg_stage_stage_commit_co (GitgStageStageCommitData* _data_);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static void __lambda25_ (Block44Data* _data44_,
                  GgitIndex* index,
                  GError** error);
static void ___lambda25__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_stage_commit_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void gitg_stage_copy_stream (GitgStage* self,
                             GOutputStream* dest,
                             GInputStream* src,
                             gsize* pos,
                             gsize index,
                             gsize length,
                             GError** error);
static void gitg_stage_apply_patch (GitgStage* self,
                             GgitIndex* index,
                             guint filemode,
                             GInputStream* old_stream,
                             GInputStream* new_stream,
                             GitgPatchSet* patch,
                             GError** error);
static void gitg_stage_stage_patch_data_free (gpointer _data);
static gboolean gitg_stage_stage_patch_co (GitgStageStagePatchData* _data_);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void gitg_stage_stage_patch_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void __lambda26_ (Block45Data* _data45_,
                  GgitIndex* index,
                  GError** error);
static guchar* _vala_array_dup24 (guchar* self,
                           gssize length);
static void ___lambda26__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_unstage_data_free (gpointer _data);
static gboolean gitg_stage_unstage_co (GitgStageUnstageData* _data_);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static void gitg_stage_unstage_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_);
static void __lambda27_ (Block46Data* _data46_,
                  GgitIndex* index,
                  GError** error);
static void ___lambda27__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_unstage_path_data_free (gpointer _data);
static gboolean gitg_stage_unstage_path_co (GitgStageUnstagePathData* _data_);
static void gitg_stage_unstage_path_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void gitg_stage_unstage_patch_data_free (gpointer _data);
static gboolean gitg_stage_unstage_patch_co (GitgStageUnstagePatchData* _data_);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static void gitg_stage_unstage_patch_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void __lambda28_ (Block47Data* _data47_,
                  GgitIndex* index,
                  GError** error);
static guchar* _vala_array_dup25 (guchar* self,
                           gssize length);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void ___lambda29_ (Block48Data* _data48_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda29__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda28__gitg_stage_with_index_func (GgitIndex* index,
                                              gpointer self,
                                              GError** error);
static void gitg_stage_diff_index_all_data_free (gpointer _data);
static gboolean gitg_stage_diff_index_all_co (GitgStageDiffIndexAllData* _data_);
static void gitg_stage_diff_index_all_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void gitg_stage_diff_index_data_free (gpointer _data);
static gboolean gitg_stage_diff_index_co (GitgStageDiffIndexData* _data_);
static void gitg_stage_diff_index_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
static void gitg_stage_diff_workdir_all_data_free (gpointer _data);
static gboolean gitg_stage_diff_workdir_all_co (GitgStageDiffWorkdirAllData* _data_);
static void gitg_stage_diff_workdir_data_free (gpointer _data);
static gboolean gitg_stage_diff_workdir_co (GitgStageDiffWorkdirData* _data_);
static void gitg_stage_diff_workdir_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void gitg_stage_finalize (GObject * obj);
static GType gitg_stage_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

 G_GNUC_NO_INLINE static GType
gitg_stage_commit_options_get_type_once (void)
{
	static const GFlagsValue values[] = {{GITG_STAGE_COMMIT_OPTIONS_NONE, "GITG_STAGE_COMMIT_OPTIONS_NONE", "none"}, {GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF, "GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF", "sign-off"}, {GITG_STAGE_COMMIT_OPTIONS_AMEND, "GITG_STAGE_COMMIT_OPTIONS_AMEND", "amend"}, {GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS, "GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS", "skip-hooks"}, {GITG_STAGE_COMMIT_OPTIONS_SIGN_COMMIT, "GITG_STAGE_COMMIT_OPTIONS_SIGN_COMMIT", "sign-commit"}, {0, NULL, NULL}};
	GType gitg_stage_commit_options_type_id;
	gitg_stage_commit_options_type_id = g_flags_register_static ("GitgStageCommitOptions", values);
	return gitg_stage_commit_options_type_id;
}

GType
gitg_stage_commit_options_get_type (void)
{
	static gsize gitg_stage_commit_options_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_commit_options_type_id__once)) {
		GType gitg_stage_commit_options_type_id;
		gitg_stage_commit_options_type_id = gitg_stage_commit_options_get_type_once ();
		g_once_init_leave (&gitg_stage_commit_options_type_id__once, gitg_stage_commit_options_type_id);
	}
	return gitg_stage_commit_options_type_id__once;
}

GQuark
gitg_stage_error_quark (void)
{
	return g_quark_from_static_string ("gitg-stage-error-quark");
}

 G_GNUC_NO_INLINE static GType
gitg_stage_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED, "GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED", "pre-commit-hook-failed"}, {GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED, "GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED", "commit-msg-hook-failed"}, {GITG_STAGE_ERROR_NOTHING_TO_COMMIT, "GITG_STAGE_ERROR_NOTHING_TO_COMMIT", "nothing-to-commit"}, {GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND, "GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND", "index-entry-not-found"}, {GITG_STAGE_ERROR_SIGN_CONFIG_NOT_FOUND, "GITG_STAGE_ERROR_SIGN_CONFIG_NOT_FOUND", "sign-config-not-found"}, {GITG_STAGE_ERROR_SIGN_CONFIG_ERROR, "GITG_STAGE_ERROR_SIGN_CONFIG_ERROR", "sign-config-error"}, {GITG_STAGE_ERROR_UPDATE_REF_ERROR, "GITG_STAGE_ERROR_UPDATE_REF_ERROR", "update-ref-error"}, {0, NULL, NULL}};
	GType gitg_stage_error_type_id;
	gitg_stage_error_type_id = g_enum_register_static ("GitgStageError", values);
	return gitg_stage_error_type_id;
}

GType
gitg_stage_error_get_type (void)
{
	static gsize gitg_stage_error_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_error_type_id__once)) {
		GType gitg_stage_error_type_id;
		gitg_stage_error_type_id = gitg_stage_error_get_type_once ();
		g_once_init_leave (&gitg_stage_error_type_id__once, gitg_stage_error_type_id);
	}
	return gitg_stage_error_type_id__once;
}

 G_GNUC_NO_INLINE static GType
gitg_patch_set_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_PATCH_SET_TYPE_ADD, "GITG_PATCH_SET_TYPE_ADD", "add"}, {GITG_PATCH_SET_TYPE_REMOVE, "GITG_PATCH_SET_TYPE_REMOVE", "remove"}, {0, NULL, NULL}};
	GType gitg_patch_set_type_type_id;
	gitg_patch_set_type_type_id = g_enum_register_static ("GitgPatchSetType", values);
	return gitg_patch_set_type_type_id;
}

GType
gitg_patch_set_type_get_type (void)
{
	static gsize gitg_patch_set_type_type_id__once = 0;
	if (g_once_init_enter (&gitg_patch_set_type_type_id__once)) {
		GType gitg_patch_set_type_type_id;
		gitg_patch_set_type_type_id = gitg_patch_set_type_get_type_once ();
		g_once_init_leave (&gitg_patch_set_type_type_id__once, gitg_patch_set_type_type_id);
	}
	return gitg_patch_set_type_type_id__once;
}

GitgPatchSet*
gitg_patch_set_reversed (GitgPatchSet* self)
{
	GitgPatchSet* ret = NULL;
	GitgPatchSet* _tmp0_;
	GitgPatchSet* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GitgPatchSet* _tmp4_;
	GitgPatchSetPatch* _tmp5_;
	gint _tmp5__length1;
	GitgPatchSetPatch* _tmp6_;
	GitgPatchSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_patch_set_new ();
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = self->filename;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_tmp1_->filename);
	_tmp1_->filename = _tmp3_;
	_tmp4_ = ret;
	_tmp5_ = self->patches;
	_tmp5__length1 = self->patches_length1;
	_tmp6_ = g_new0 (GitgPatchSetPatch, _tmp5__length1);
	_tmp4_->patches = (g_free (_tmp4_->patches), NULL);
	_tmp4_->patches = _tmp6_;
	_tmp4_->patches_length1 = _tmp5__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GitgPatchSetPatch* _tmp9_;
				gint _tmp9__length1;
				GitgPatchSetPatch orig = {0};
				GitgPatchSetPatch* _tmp10_;
				gint _tmp10__length1;
				GitgPatchSetPatch _tmp11_;
				GitgPatchSetPatch p = {0};
				GitgPatchSetPatch _tmp12_;
				GitgPatchSetPatch _tmp13_;
				GitgPatchSetPatch _tmp14_;
				GitgPatchSetPatch _tmp15_ = {0};
				GitgPatchSetPatch* _tmp16_;
				gint _tmp16__length1;
				GitgPatchSetPatch _tmp17_;
				GitgPatchSet* _tmp18_;
				GitgPatchSetPatch* _tmp19_;
				gint _tmp19__length1;
				GitgPatchSetPatch _tmp20_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = self->patches;
				_tmp9__length1 = self->patches_length1;
				if (!(i < _tmp9__length1)) {
					break;
				}
				_tmp10_ = self->patches;
				_tmp10__length1 = self->patches_length1;
				_tmp11_ = _tmp10_[i];
				orig = _tmp11_;
				_tmp12_ = orig;
				_tmp13_ = orig;
				_tmp14_ = orig;
				memset (&_tmp15_, 0, sizeof (GitgPatchSetPatch));
				_tmp15_.old_offset = _tmp12_.new_offset;
				_tmp15_.new_offset = _tmp13_.old_offset;
				_tmp15_.length = _tmp14_.length;
				p = _tmp15_;
				_tmp16_ = self->patches;
				_tmp16__length1 = self->patches_length1;
				_tmp17_ = _tmp16_[i];
				switch (_tmp17_.type) {
					case GITG_PATCH_SET_TYPE_ADD:
					{
						p.type = GITG_PATCH_SET_TYPE_REMOVE;
						break;
					}
					case GITG_PATCH_SET_TYPE_REMOVE:
					{
						p.type = GITG_PATCH_SET_TYPE_ADD;
						break;
					}
					default:
					break;
				}
				_tmp18_ = ret;
				_tmp19_ = _tmp18_->patches;
				_tmp19__length1 = _tmp18_->patches_length1;
				_tmp20_ = p;
				_tmp19_[i] = _tmp20_;
			}
		}
	}
	result = ret;
	return result;
}

GitgPatchSet*
gitg_patch_set_construct (GType object_type)
{
	GitgPatchSet* self = NULL;
	self = (GitgPatchSet*) g_type_create_instance (object_type);
	return self;
}

GitgPatchSet*
gitg_patch_set_new (void)
{
	return gitg_patch_set_construct (GITG_TYPE_PATCH_SET);
}

GitgPatchSetPatch*
gitg_patch_set_patch_dup (const GitgPatchSetPatch* self)
{
	GitgPatchSetPatch* dup;
	dup = g_new0 (GitgPatchSetPatch, 1);
	memcpy (dup, self, sizeof (GitgPatchSetPatch));
	return dup;
}

void
gitg_patch_set_patch_free (GitgPatchSetPatch* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_patch_set_patch_get_type_once (void)
{
	GType gitg_patch_set_patch_type_id;
	gitg_patch_set_patch_type_id = g_boxed_type_register_static ("GitgPatchSetPatch", (GBoxedCopyFunc) gitg_patch_set_patch_dup, (GBoxedFreeFunc) gitg_patch_set_patch_free);
	return gitg_patch_set_patch_type_id;
}

GType
gitg_patch_set_patch_get_type (void)
{
	static gsize gitg_patch_set_patch_type_id__once = 0;
	if (g_once_init_enter (&gitg_patch_set_patch_type_id__once)) {
		GType gitg_patch_set_patch_type_id;
		gitg_patch_set_patch_type_id = gitg_patch_set_patch_get_type_once ();
		g_once_init_leave (&gitg_patch_set_patch_type_id__once, gitg_patch_set_patch_type_id);
	}
	return gitg_patch_set_patch_type_id__once;
}

static void
gitg_value_patch_set_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_patch_set_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_patch_set_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_patch_set_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_patch_set_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_patch_set_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_patch_set_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgPatchSet * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_patch_set_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_patch_set_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	GitgPatchSet ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_patch_set_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_patch_set (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	GitgParamSpecPatchSet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_PATCH_SET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_patch_set (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_PATCH_SET), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_patch_set (GValue* value,
                          gpointer v_object)
{
	GitgPatchSet * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_PATCH_SET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_PATCH_SET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_patch_set_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_patch_set_unref (old);
	}
}

void
gitg_value_take_patch_set (GValue* value,
                           gpointer v_object)
{
	GitgPatchSet * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_PATCH_SET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_PATCH_SET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_patch_set_unref (old);
	}
}

static void
gitg_patch_set_class_init (GitgPatchSetClass * klass,
                           gpointer klass_data)
{
	gitg_patch_set_parent_class = g_type_class_peek_parent (klass);
	((GitgPatchSetClass *) klass)->finalize = gitg_patch_set_finalize;
}

static void
gitg_patch_set_instance_init (GitgPatchSet * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_patch_set_finalize (GitgPatchSet * obj)
{
	GitgPatchSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_PATCH_SET, GitgPatchSet);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filename);
	self->patches = (g_free (self->patches), NULL);
}

 G_GNUC_NO_INLINE static GType
gitg_patch_set_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_patch_set_init, gitg_value_patch_set_free_value, gitg_value_patch_set_copy_value, gitg_value_patch_set_peek_pointer, "p", gitg_value_patch_set_collect_value, "p", gitg_value_patch_set_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgPatchSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_patch_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgPatchSet), 0, (GInstanceInitFunc) gitg_patch_set_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_patch_set_type_id;
	gitg_patch_set_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgPatchSet", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_patch_set_type_id;
}

GType
gitg_patch_set_get_type (void)
{
	static gsize gitg_patch_set_type_id__once = 0;
	if (g_once_init_enter (&gitg_patch_set_type_id__once)) {
		GType gitg_patch_set_type_id;
		gitg_patch_set_type_id = gitg_patch_set_get_type_once ();
		g_once_init_leave (&gitg_patch_set_type_id__once, gitg_patch_set_type_id);
	}
	return gitg_patch_set_type_id__once;
}

gpointer
gitg_patch_set_ref (gpointer instance)
{
	GitgPatchSet * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_patch_set_unref (gpointer instance)
{
	GitgPatchSet * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_PATCH_SET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
gitg_stage_get_instance_private (GitgStage* self)
{
	return G_STRUCT_MEMBER_P (self, GitgStage_private_offset);
}

GitgStage*
gitg_stage_construct (GType object_type,
                      GitgRepository* repository)
{
	GitgStage * self = NULL;
	g_return_val_if_fail (repository != NULL, NULL);
	self = (GitgStage*) g_object_new (object_type, NULL);
	self->priv->d_repository = repository;
	return self;
}

GitgStage*
gitg_stage_new (GitgRepository* repository)
{
	return gitg_stage_construct (GITG_TYPE_STAGE, repository);
}

static void
gitg_stage_refresh_data_free (gpointer _data)
{
	GitgStageRefreshData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageRefreshData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gitg_stage_refresh (GitgStage* self,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	GitgStageRefreshData* _data_;
	GitgStage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgStageRefreshData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_refresh_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_stage_refresh_co (_data_);
}

void
gitg_stage_refresh_finish (GitgStage* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	GitgStageRefreshData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
__lambda6_ (GitgStage* self,
            GgitIndex* index,
            GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (index != NULL);
	ggit_index_read (index, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda6__gitg_stage_with_index_func (GgitIndex* index,
                                        gpointer self,
                                        GError** error)
{
	__lambda6_ ((GitgStage*) self, index, error);
}

static void
gitg_stage_refresh_ready (GObject* source_object,
                          GAsyncResult* _res_,
                          gpointer _user_data_)
{
	GitgStageRefreshData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_refresh_co (_data_);
}

static gboolean
gitg_stage_refresh_co (GitgStageRefreshData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_object_unref0 (_data_->self->priv->d_head_tree);
	_data_->self->priv->d_head_tree = NULL;
	_data_->_state_ = 1;
	gitg_stage_thread_index (_data_->self, ___lambda6__gitg_stage_with_index_func, _data_->self, gitg_stage_refresh_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_get_head_tree_data_free (gpointer _data)
{
	GitgStageGetHeadTreeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageGetHeadTreeData, _data_);
}

void
gitg_stage_get_head_tree (GitgStage* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	GitgStageGetHeadTreeData* _data_;
	GitgStage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgStageGetHeadTreeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_get_head_tree_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_stage_get_head_tree_co (_data_);
}

GgitTree*
gitg_stage_get_head_tree_finish (GitgStage* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GgitTree* result;
	GitgStageGetHeadTreeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		GitgStage* self;
		self = _data32_->self;
		_g_error_free0 (_data32_->e);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda7_ (Block32Data* _data32_,
            GError** error)
{
	GitgStage* self;
	GError* _inner_error0_ = NULL;
	self = _data32_->self;
	{
		GitgRef* head = NULL;
		GitgRepository* _tmp0_;
		GitgRef* _tmp1_;
		GgitObject* _tmp2_ = NULL;
		GitgRef* _tmp3_;
		GgitObject* _tmp4_;
		GgitCommit* commit = NULL;
		GgitCommit* _tmp5_;
		GgitCommit* _tmp6_;
		GgitTree* _tmp7_;
		_tmp0_ = self->priv->d_repository;
		_tmp1_ = gitg_repository_get_head (_tmp0_, &_inner_error0_);
		head = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = head;
		_tmp4_ = ggit_ref_lookup ((GgitRef*) _tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (head);
			goto __catch0_g_error;
		}
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, ggit_commit_get_type (), GgitCommit));
		commit = _tmp5_;
		_tmp6_ = commit;
		_tmp7_ = ggit_commit_get_tree (_tmp6_);
		_g_object_unref0 (self->priv->d_head_tree);
		self->priv->d_head_tree = _tmp7_;
		_g_object_unref0 (commit);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (head);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_g_error_free0 (_data32_->e);
		_data32_->e = _tmp9_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda7__gitg_async_thread_func (gpointer self,
                                    GError** error)
{
	__lambda7_ (self, error);
}

static void
gitg_stage_get_head_tree_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	GitgStageGetHeadTreeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_get_head_tree_co (_data_);
}

static gboolean
gitg_stage_get_head_tree_co (GitgStageGetHeadTreeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data32_ = g_slice_new0 (Block32Data);
	_data_->_data32_->_ref_count_ = 1;
	_data_->_data32_->self = g_object_ref (_data_->self);
	_data_->_data32_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->d_head_tree;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->self->priv->d_head_tree;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->result = _data_->_tmp2_;
		block32_data_unref (_data_->_data32_);
		_data_->_data32_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data32_->e = NULL;
	_data_->_state_ = 1;
	gitg_async_thread (___lambda7__gitg_async_thread_func, _data_->_data32_, gitg_stage_get_head_tree_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block32_data_unref (_data_->_data32_);
		_data_->_data32_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_data32_->e;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->_data32_->e;
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block32_data_unref (_data_->_data32_);
		_data_->_data32_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->d_head_tree;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	block32_data_unref (_data_->_data32_);
	_data_->_data32_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GitgStageStatusEnumerator*
gitg_stage_file_status (GitgStage* self,
                        GgitStatusOptions* options)
{
	GitgRepository* _tmp0_;
	GitgStageStatusEnumerator* _tmp1_;
	GitgStageStatusEnumerator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_repository;
	_tmp1_ = gitg_stage_status_enumerator_new (_tmp0_, options);
	result = _tmp1_;
	return result;
}

static void
gitg_stage_with_index (GitgStage* self,
                       GitgStageWithIndexFunc func,
                       gpointer func_target,
                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_rec_mutex_lock (&self->priv->__lock_d_index_mutex);
		{
			GgitIndex* _tmp0_ = NULL;
			GitgRepository* _tmp1_;
			GgitIndex* _tmp2_;
			_tmp1_ = self->priv->d_repository;
			_tmp2_ = ggit_repository_get_index ((GgitRepository*) _tmp1_, &_inner_error0_);
			_tmp0_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			func (_tmp0_, func_target, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp3_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp3_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			g_rec_mutex_unlock (&self->priv->__lock_d_index_mutex);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

static void
gitg_stage_thread_index_data_free (gpointer _data)
{
	GitgStageThreadIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageThreadIndexData, _data_);
}

static void
gitg_stage_thread_index (GitgStage* self,
                         GitgStageWithIndexFunc func,
                         gpointer func_target,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgStageThreadIndexData* _data_;
	GitgStage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgStageThreadIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_thread_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->func = func;
	_data_->func_target = func_target;
	gitg_stage_thread_index_co (_data_);
}

static void
gitg_stage_thread_index_finish (GitgStage* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GitgStageThreadIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		GitgStage* self;
		self = _data33_->self;
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
__lambda5_ (Block33Data* _data33_,
            GError** error)
{
	GitgStage* self;
	GError* _inner_error0_ = NULL;
	self = _data33_->self;
	gitg_stage_with_index (self, _data33_->func, _data33_->func_target, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda5__gitg_async_thread_func (gpointer self,
                                    GError** error)
{
	__lambda5_ (self, error);
}

static void
gitg_stage_thread_index_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgStageThreadIndexData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_thread_index_co (_data_);
}

static gboolean
gitg_stage_thread_index_co (GitgStageThreadIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data33_ = g_slice_new0 (Block33Data);
	_data_->_data33_->_ref_count_ = 1;
	_data_->_data33_->self = g_object_ref (_data_->self);
	_data_->_data33_->func = _data_->func;
	_data_->_data33_->func_target = _data_->func_target;
	_data_->_data33_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_async_thread (___lambda5__gitg_async_thread_func, _data_->_data33_, gitg_stage_thread_index_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block33_data_unref (_data_->_data33_);
		_data_->_data33_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block33_data_unref (_data_->_data33_);
	_data_->_data33_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
gitg_stage_message_with_sign_off (GitgStage* self,
                                  const gchar* message,
                                  GgitSignature* committer)
{
	gchar* signed_off = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (committer != NULL, NULL);
	_tmp0_ = ggit_signature_get_name (committer);
	_tmp1_ = ggit_signature_get_email (committer);
	_tmp2_ = g_strdup_printf ("Signed-off-by: %s <%s>", _tmp0_, _tmp1_);
	signed_off = _tmp2_;
	_tmp3_ = g_utf8_strdown (message, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = signed_off;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = !string_contains (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = signed_off;
		_tmp10_ = g_strdup_printf ("%s\n%s\n", message, _tmp9_);
		result = _tmp10_;
		_g_free0 (signed_off);
		return result;
	}
	_tmp11_ = g_strdup (message);
	result = _tmp11_;
	_g_free0 (signed_off);
	return result;
}

static gchar*
gitg_stage_convert_message_to_encoding (GitgStage* self,
                                        GgitConfig* conf,
                                        const gchar* message,
                                        gchar** encoding)
{
	gchar* _vala_encoding = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (conf != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	_g_free0 (_vala_encoding);
	_vala_encoding = NULL;
	{
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = ggit_config_get_string (conf, "i18n.commitencoding", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_strdup (_tmp0_);
		_g_free0 (_vala_encoding);
		_vala_encoding = _tmp2_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_g_free0 (_vala_encoding);
		_vala_encoding = NULL;
		_tmp3_ = g_strdup (message);
		result = _tmp3_;
		if (encoding) {
			*encoding = _vala_encoding;
		} else {
			_g_free0 (_vala_encoding);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_vala_encoding);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = _vala_encoding;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = _vala_encoding;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		_tmp8_ = _vala_encoding;
		_tmp4_ = g_ascii_strcasecmp (_tmp8_, "UTF-8") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		{
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = _vala_encoding;
			_tmp11_ = g_convert (message, (gssize) -1, _tmp10_, "UTF-8", NULL, NULL, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp12_ = _tmp9_;
			_tmp9_ = NULL;
			result = _tmp12_;
			_g_free0 (_tmp9_);
			if (encoding) {
				*encoding = _vala_encoding;
			} else {
				_g_free0 (_vala_encoding);
			}
			return result;
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			_g_free0 (_vala_encoding);
			_vala_encoding = NULL;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_vala_encoding);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		_g_free0 (_vala_encoding);
		_vala_encoding = NULL;
	}
	_tmp13_ = g_strdup (message);
	result = _tmp13_;
	if (encoding) {
		*encoding = _vala_encoding;
	} else {
		_g_free0 (_vala_encoding);
	}
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_stage_setup_commit_hook_environment (GitgStage* self,
                                          GitgHook* hook,
                                          GgitSignature* author)
{
	GFile* wd = NULL;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* gd = NULL;
	GitgRepository* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* gitdir = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	const gchar* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeHashMap* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hook != NULL);
	_tmp0_ = self->priv->d_repository;
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
	wd = _tmp1_;
	_tmp2_ = self->priv->d_repository;
	_tmp3_ = ggit_repository_get_location ((GgitRepository*) _tmp2_);
	gd = _tmp3_;
	_tmp4_ = wd;
	gitg_hook_set_working_directory (hook, _tmp4_);
	_tmp5_ = wd;
	_tmp6_ = gd;
	_tmp7_ = g_file_get_relative_path (_tmp5_, _tmp6_);
	gitdir = _tmp7_;
	_tmp8_ = gitg_hook_get_environment (hook);
	_tmp9_ = _tmp8_;
	_tmp10_ = gitdir;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, "GIT_DIR", _tmp10_);
	_tmp11_ = gitg_hook_get_environment (hook);
	_tmp12_ = _tmp11_;
	_tmp13_ = gitdir;
	_tmp14_ = g_build_filename (_tmp13_, "index", NULL);
	_tmp15_ = _tmp14_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, "GIT_INDEX_FILE", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = gitg_hook_get_environment (hook);
	_tmp17_ = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, "GIT_PREFIX", ".");
	if (author != NULL) {
		GeeHashMap* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		GeeHashMap* _tmp21_;
		GeeHashMap* _tmp22_;
		const gchar* _tmp23_;
		GDateTime* date = NULL;
		GDateTime* _tmp24_;
		gint64 un = 0LL;
		GDateTime* _tmp25_;
		gchar* tz = NULL;
		GDateTime* _tmp26_;
		GTimeZone* _tmp27_;
		GTimeZone* _tmp28_;
		GDateTime* _tmp29_;
		GDateTime* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GeeHashMap* _tmp33_;
		GeeHashMap* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp18_ = gitg_hook_get_environment (hook);
		_tmp19_ = _tmp18_;
		_tmp20_ = ggit_signature_get_name (author);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "GIT_AUTHOR_NAME", _tmp20_);
		_tmp21_ = gitg_hook_get_environment (hook);
		_tmp22_ = _tmp21_;
		_tmp23_ = ggit_signature_get_email (author);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "GIT_AUTHOR_EMAIL", _tmp23_);
		_tmp24_ = ggit_signature_get_time (author);
		date = _tmp24_;
		_tmp25_ = date;
		un = g_date_time_to_unix (_tmp25_);
		_tmp26_ = date;
		_tmp27_ = ggit_signature_get_time_zone (author);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_date_time_to_timezone (_tmp26_, _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_date_time_format (_tmp30_, "%z");
		_tmp32_ = _tmp31_;
		_g_date_time_unref0 (_tmp30_);
		_g_time_zone_unref0 (_tmp28_);
		tz = _tmp32_;
		_tmp33_ = gitg_hook_get_environment (hook);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strdup_printf ("%" G_GINT64_FORMAT, un);
		_tmp36_ = _tmp35_;
		_tmp37_ = tz;
		_tmp38_ = string_to_string (_tmp37_);
		_tmp39_ = g_strconcat ("@", _tmp36_, " ", _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, "GIT_AUTHOR_DATE", _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp36_);
		_g_free0 (tz);
		_g_date_time_unref0 (date);
	}
	_g_free0 (gitdir);
	_g_object_unref0 (gd);
	_g_object_unref0 (wd);
}

static void
gitg_stage_pre_commit_hook_data_free (gpointer _data)
{
	GitgStagePreCommitHookData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStagePreCommitHookData, _data_);
}

void
gitg_stage_pre_commit_hook (GitgStage* self,
                            GgitSignature* author,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GitgStagePreCommitHookData* _data_;
	GitgStage* _tmp0_;
	GgitSignature* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (author != NULL);
	_data_ = g_slice_new0 (GitgStagePreCommitHookData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_pre_commit_hook_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (author);
	_g_object_unref0 (_data_->author);
	_data_->author = _tmp1_;
	gitg_stage_pre_commit_hook_co (_data_);
}

void
gitg_stage_pre_commit_hook_finish (GitgStage* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GitgStagePreCommitHookData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		GitgStage* self;
		self = _data34_->self;
		_g_free0 (_data34_->errormsg);
		_g_object_unref0 (_data34_->author);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
___lambda15_ (Block34Data* _data34_,
              GError** error)
{
	GitgStage* self;
	GitgHook* hook = NULL;
	GitgHook* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data34_->self;
	_tmp0_ = gitg_hook_new ("pre-commit");
	hook = _tmp0_;
	gitg_stage_setup_commit_hook_environment (self, hook, _data34_->author);
	{
		gint status = 0;
		GitgRepository* _tmp1_;
		_tmp1_ = self->priv->d_repository;
		status = gitg_hook_run_sync (hook, (GgitRepository*) _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_object_unref0 (hook);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (status != 0) {
			gchar** _tmp2_;
			gint _tmp2__length1;
			gint _tmp3_ = 0;
			gchar** _tmp4_;
			gint _tmp4__length1;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_;
			_tmp2_ = gitg_hook_get_output (hook, &_tmp3_);
			_tmp2__length1 = _tmp3_;
			_tmp4_ = _tmp2_;
			_tmp4__length1 = _tmp2__length1;
			_tmp5_ = _tmp4_;
			_tmp5__length1 = _tmp4__length1;
			_tmp6_ = _vala_g_strjoinv ("\n", _tmp5_, (gint) _tmp4__length1);
			_g_free0 (_data34_->errormsg);
			_data34_->errormsg = _tmp6_;
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (hook);
		return;
	}
	_g_object_unref0 (hook);
}

static void
____lambda15__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda15_ (self, error);
}

static void
gitg_stage_pre_commit_hook_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	GitgStagePreCommitHookData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_pre_commit_hook_co (_data_);
}

static gboolean
gitg_stage_pre_commit_hook_co (GitgStagePreCommitHookData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data34_ = g_slice_new0 (Block34Data);
	_data_->_data34_->_ref_count_ = 1;
	_data_->_data34_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data34_->author);
	_data_->_data34_->author = _data_->author;
	_data_->_data34_->_async_data_ = _data_;
	_data_->_data34_->errormsg = NULL;
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda15__gitg_async_thread_func, _data_->_data34_, gitg_stage_pre_commit_hook_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == GITG_STAGE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block34_data_unref (_data_->_data34_);
			_data_->_data34_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block34_data_unref (_data_->_data34_);
			_data_->_data34_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp0_ = _data_->_data34_->errormsg;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->_data34_->errormsg;
		_data_->_tmp2_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED, _data_->_tmp1_);
		_data_->_inner_error0_ = _data_->_tmp2_;
		if (_data_->_inner_error0_->domain == GITG_STAGE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block34_data_unref (_data_->_data34_);
			_data_->_data34_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block34_data_unref (_data_->_data34_);
			_data_->_data34_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	block34_data_unref (_data_->_data34_);
	_data_->_data34_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		GitgStage* self;
		self = _data35_->self;
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static gint
___lambda16_ (Block35Data* _data35_,
              const gchar* path,
              GgitStatusFlags flags)
{
	GitgStage* self;
	gint result;
	self = _data35_->self;
	g_return_val_if_fail (path != NULL, 0);
	_data35_->has_changes = TRUE;
	result = -1;
	return result;
}

static gint
____lambda16__ggit_status_callback (const gchar* path,
                                    GgitStatusFlags status_flags,
                                    gpointer self)
{
	gint result;
	result = ___lambda16_ (self, path, status_flags);
	return result;
}

static void
_vala_GgitStatusOptions_free (GgitStatusOptions* self)
{
	g_boxed_free (ggit_status_options_get_type (), self);
}

static gboolean
gitg_stage_has_index_changes (GitgStage* self)
{
	Block35Data* _data35_;
	GgitStatusShow show = 0;
	GgitStatusOptions* options = NULL;
	GgitStatusOptions* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	show = GGIT_STATUS_SHOW_INDEX_ONLY;
	_tmp0_ = ggit_status_options_new (0, show, NULL);
	options = _tmp0_;
	_data35_->has_changes = FALSE;
	{
		GitgRepository* _tmp1_;
		_tmp1_ = self->priv->d_repository;
		ggit_repository_file_status_foreach ((GgitRepository*) _tmp1_, options, ____lambda16__ggit_status_callback, _data35_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		__vala_GgitStatusOptions_free0 (options);
		block35_data_unref (_data35_);
		_data35_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = _data35_->has_changes;
	__vala_GgitStatusOptions_free0 (options);
	block35_data_unref (_data35_);
	_data35_ = NULL;
	return result;
}

static gchar*
gitg_stage_commit_msg_hook (GitgStage* self,
                            const gchar* message,
                            GgitSignature* author,
                            GgitSignature* committer,
                            GError** error)
{
	GitgHook* hook = NULL;
	GitgHook* _tmp0_;
	GitgHook* _tmp1_;
	GitgRepository* _tmp2_;
	GitgHook* _tmp4_;
	GFile* msgfile = NULL;
	GitgRepository* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GitgHook* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint status = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (author != NULL, NULL);
	g_return_val_if_fail (committer != NULL, NULL);
	_tmp0_ = gitg_hook_new ("commit-msg");
	hook = _tmp0_;
	_tmp1_ = hook;
	_tmp2_ = self->priv->d_repository;
	if (!gitg_hook_exists_in (_tmp1_, (GgitRepository*) _tmp2_)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (message);
		result = _tmp3_;
		_g_object_unref0 (hook);
		return result;
	}
	_tmp4_ = hook;
	gitg_stage_setup_commit_hook_environment (self, _tmp4_, author);
	_tmp5_ = self->priv->d_repository;
	_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_child (_tmp7_, "COMMIT_EDITMSG");
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	msgfile = _tmp9_;
	{
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = msgfile;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		g_file_set_contents (_tmp12_, message, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp12_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp13_;
		g_clear_error (&_inner_error0_);
		_tmp13_ = g_strdup (message);
		result = _tmp13_;
		_g_object_unref0 (msgfile);
		_g_object_unref0 (hook);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (msgfile);
		_g_object_unref0 (hook);
		return NULL;
	}
	_tmp14_ = hook;
	_tmp15_ = msgfile;
	_tmp16_ = g_file_get_path (_tmp15_);
	_tmp17_ = _tmp16_;
	gitg_hook_add_argument (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	{
		gint _tmp18_ = 0;
		GitgHook* _tmp19_;
		GitgRepository* _tmp20_;
		_tmp19_ = hook;
		_tmp20_ = self->priv->d_repository;
		_tmp18_ = gitg_hook_run_sync (_tmp19_, (GgitRepository*) _tmp20_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		status = _tmp18_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		gchar* _tmp21_;
		g_clear_error (&_inner_error0_);
		_tmp21_ = g_strdup (message);
		result = _tmp21_;
		_g_object_unref0 (msgfile);
		_g_object_unref0 (hook);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (msgfile);
		_g_object_unref0 (hook);
		return NULL;
	}
	if (status != 0) {
		GitgHook* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gint _tmp24_ = 0;
		gchar** _tmp25_;
		gint _tmp25__length1;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GError* _tmp29_;
		GError* _tmp30_;
		_tmp22_ = hook;
		_tmp23_ = gitg_hook_get_output (_tmp22_, &_tmp24_);
		_tmp23__length1 = _tmp24_;
		_tmp25_ = _tmp23_;
		_tmp25__length1 = _tmp23__length1;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = _tmp25__length1;
		_tmp27_ = _vala_g_strjoinv ("\n", _tmp26_, (gint) _tmp25__length1);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED, _tmp28_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp28_);
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		_inner_error0_ = _tmp30_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (msgfile);
		_g_object_unref0 (hook);
		return NULL;
	}
	{
		gchar* newmessage = NULL;
		GFile* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_ = NULL;
		_tmp31_ = msgfile;
		_tmp32_ = g_file_get_path (_tmp31_);
		_tmp33_ = _tmp32_;
		g_file_get_contents (_tmp33_, &_tmp34_, NULL, &_inner_error0_);
		_g_free0 (newmessage);
		newmessage = _tmp34_;
		_g_free0 (_tmp33_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (newmessage);
			goto __catch2_g_error;
		}
		result = newmessage;
		{
			GError* _inner_error0_ = NULL;
			GFile* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp35_ = msgfile;
			_tmp36_ = g_file_get_path (_tmp35_);
			_tmp37_ = _tmp36_;
			g_remove (_tmp37_);
			_g_free0 (_tmp37_);
		}
		_g_object_unref0 (msgfile);
		_g_object_unref0 (hook);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		_tmp40_ = g_strdup_printf (_ ("Could not read commit message after running commit-msg hook: %s"), _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_COMMIT_MSG_HOOK_FAILED, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_inner_error0_ = _tmp43_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	{
		GError* _inner_error1_ = NULL;
		GFile* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp44_ = msgfile;
		_tmp45_ = g_file_get_path (_tmp44_);
		_tmp46_ = _tmp45_;
		g_remove (_tmp46_);
		_g_free0 (_tmp46_);
	}
	g_propagate_error (error, _inner_error0_);
	_g_object_unref0 (msgfile);
	_g_object_unref0 (hook);
	return NULL;
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		GitgStage* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->hook);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static void
__lambda17_ (Block36Data* _data36_,
             GObject* obj,
             GAsyncResult* res)
{
	GitgStage* self;
	GError* _inner_error0_ = NULL;
	self = _data36_->self;
	g_return_if_fail (res != NULL);
	{
		gitg_hook_run_finish (_data36_->hook, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ (self, source_object, res);
	block36_data_unref (self);
}

static void
gitg_stage_post_commit_hook (GitgStage* self,
                             GgitSignature* author)
{
	Block36Data* _data36_;
	GitgHook* _tmp0_;
	GitgRepository* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (author != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = gitg_hook_new ("post-commit");
	_data36_->hook = _tmp0_;
	gitg_stage_setup_commit_hook_environment (self, _data36_->hook, author);
	_tmp1_ = self->priv->d_repository;
	gitg_hook_run (_data36_->hook, (GgitRepository*) _tmp1_, ___lambda17__gasync_ready_callback, block36_data_ref (_data36_));
	block36_data_unref (_data36_);
	_data36_ = NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
gitg_stage_get_subject (GitgStage* self,
                        const gchar* message)
{
	gint nlpos = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	nlpos = string_index_of (message, "\n", 0);
	if (nlpos == -1) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (message);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = string_slice (message, (glong) 0, (glong) nlpos);
		result = _tmp1_;
		return result;
	}
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
gitg_stage_commit_index_data_free (gpointer _data)
{
	GitgStageCommitIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->reference);
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->author);
	_g_object_unref0 (_data_->committer);
	__vala_GgitOId_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageCommitIndexData, _data_);
}

void
gitg_stage_commit_index (GitgStage* self,
                         GgitIndex* index,
                         GgitRef* reference,
                         const gchar* message,
                         GgitSignature* author,
                         GgitSignature* committer,
                         GgitOId** parents,
                         gint parents_length1,
                         GitgStageCommitOptions options,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgStageCommitIndexData* _data_;
	GitgStage* _tmp0_;
	GgitIndex* _tmp1_;
	GgitRef* _tmp2_;
	gchar* _tmp3_;
	GgitSignature* _tmp4_;
	GgitSignature* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	g_return_if_fail (reference != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (author != NULL);
	g_return_if_fail (committer != NULL);
	_data_ = g_slice_new0 (GitgStageCommitIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_commit_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (index);
	_g_object_unref0 (_data_->index);
	_data_->index = _tmp1_;
	_tmp2_ = _g_object_ref0 (reference);
	_g_object_unref0 (_data_->reference);
	_data_->reference = _tmp2_;
	_tmp3_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp3_;
	_tmp4_ = _g_object_ref0 (author);
	_g_object_unref0 (_data_->author);
	_data_->author = _tmp4_;
	_tmp5_ = _g_object_ref0 (committer);
	_g_object_unref0 (_data_->committer);
	_data_->committer = _tmp5_;
	_data_->parents = parents;
	_data_->parents_length1 = parents_length1;
	_data_->options = options;
	gitg_stage_commit_index_co (_data_);
}

GgitOId*
gitg_stage_commit_index_finish (GitgStage* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GgitOId* result;
	GitgStageCommitIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		GitgStage* self;
		self = _data37_->self;
		__vala_GgitOId_free0 (_data37_->treeoid);
		_g_object_unref0 (_data37_->index);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static void
__lambda18_ (Block37Data* _data37_,
             GError** error)
{
	GitgStage* self;
	GgitOId* _tmp0_ = NULL;
	GitgRepository* _tmp1_;
	GgitOId* _tmp2_;
	GgitOId* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data37_->self;
	_tmp1_ = self->priv->d_repository;
	_tmp2_ = ggit_index_write_tree_to (_data37_->index, (GgitRepository*) _tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	__vala_GgitOId_free0 (_data37_->treeoid);
	_data37_->treeoid = _tmp3_;
	__vala_GgitOId_free0 (_tmp0_);
}

static void
___lambda18__gitg_async_thread_func (gpointer self,
                                     GError** error)
{
	__lambda18_ (self, error);
}

static void
gitg_stage_commit_index_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgStageCommitIndexData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_commit_index_co (_data_);
}

static gboolean
gitg_stage_commit_index_co (GitgStageCommitIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data37_ = g_slice_new0 (Block37Data);
	_data_->_data37_->_ref_count_ = 1;
	_data_->_data37_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data37_->index);
	_data_->_data37_->index = _data_->index;
	_data_->_data37_->_async_data_ = _data_;
	_data_->_data37_->treeoid = NULL;
	_data_->_state_ = 1;
	gitg_async_thread (___lambda18__gitg_async_thread_func, _data_->_data37_, gitg_stage_commit_index_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block37_data_unref (_data_->_data37_);
		_data_->_data37_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->_data37_->treeoid;
	_data_->_state_ = 2;
	gitg_stage_commit_tree (_data_->self, _data_->_tmp1_, _data_->reference, _data_->message, _data_->author, _data_->committer, _data_->parents, (gint) _data_->parents_length1, _data_->options, gitg_stage_commit_index_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = gitg_stage_commit_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block37_data_unref (_data_->_data37_);
		_data_->_data37_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	__vala_GgitOId_free0 (_data_->_tmp0_);
	block37_data_unref (_data_->_data37_);
	_data_->_data37_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_commit_tree_data_free (gpointer _data)
{
	GitgStageCommitTreeData* _data_;
	_data_ = _data;
	__vala_GgitOId_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageCommitTreeData, _data_);
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static gpointer
__vala_GgitOId_copy0 (gpointer self)
{
	return self ? _vala_GgitOId_copy (self) : NULL;
}

void
gitg_stage_commit_tree (GitgStage* self,
                        GgitOId* treeoid,
                        GgitRef* reference,
                        const gchar* message,
                        GgitSignature* author,
                        GgitSignature* committer,
                        GgitOId** parents,
                        gint parents_length1,
                        GitgStageCommitOptions options,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgStageCommitTreeData* _data_;
	GitgStage* _tmp0_;
	GgitOId* _tmp1_;
	GgitRef* _tmp2_;
	gchar* _tmp3_;
	GgitSignature* _tmp4_;
	GgitSignature* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (treeoid != NULL);
	g_return_if_fail (reference != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (author != NULL);
	g_return_if_fail (committer != NULL);
	_data_ = g_slice_new0 (GitgStageCommitTreeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_commit_tree_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = __vala_GgitOId_copy0 (treeoid);
	__vala_GgitOId_free0 (_data_->treeoid);
	_data_->treeoid = _tmp1_;
	_tmp2_ = _g_object_ref0 (reference);
	_g_object_unref0 (_data_->reference);
	_data_->reference = _tmp2_;
	_tmp3_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp3_;
	_tmp4_ = _g_object_ref0 (author);
	_g_object_unref0 (_data_->author);
	_data_->author = _tmp4_;
	_tmp5_ = _g_object_ref0 (committer);
	_g_object_unref0 (_data_->committer);
	_data_->committer = _tmp5_;
	_data_->parents = parents;
	_data_->parents_length1 = parents_length1;
	_data_->options = options;
	gitg_stage_commit_tree_co (_data_);
}

GgitOId*
gitg_stage_commit_tree_finish (GitgStage* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GgitOId* result;
	GitgStageCommitTreeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		GitgStage* self;
		self = _data38_->self;
		__vala_GgitOId_free0 (_data38_->ret);
		__vala_GgitOId_free0 (_data38_->treeoid);
		_g_object_unref0 (_data38_->reference);
		_g_free0 (_data38_->message);
		_g_object_unref0 (_data38_->author);
		_g_object_unref0 (_data38_->committer);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static GgitOId**
_vala_array_dup23 (GgitOId** self,
                   gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda19_ (Block38Data* _data38_,
             GError** error)
{
	GitgStage* self;
	gboolean skip_hooks = FALSE;
	gboolean amend = FALSE;
	gboolean sign_commit = FALSE;
	GgitConfig* _tmp0_ = NULL;
	GitgRepository* _tmp1_;
	GgitConfig* _tmp2_;
	GgitConfig* conf = NULL;
	GgitConfig* _tmp3_;
	gchar* emsg = NULL;
	gchar* _tmp4_;
	gchar* encoding = NULL;
	GgitConfig* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GgitOId* refoid = NULL;
	gboolean always_update = FALSE;
	gchar* reflogmsg = NULL;
	gchar* _tmp95_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	const gchar* _tmp117_;
	GError* _inner_error0_ = NULL;
	self = _data38_->self;
	skip_hooks = (_data38_->options & GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS) != 0;
	amend = (_data38_->options & GITG_STAGE_COMMIT_OPTIONS_AMEND) != 0;
	sign_commit = (_data38_->options & GITG_STAGE_COMMIT_OPTIONS_SIGN_COMMIT) != 0;
	_tmp1_ = self->priv->d_repository;
	_tmp2_ = ggit_repository_get_config ((GgitRepository*) _tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = ggit_config_snapshot (_tmp0_, &_inner_error0_);
	conf = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_tmp4_ = g_strdup (_data38_->message);
	emsg = _tmp4_;
	if ((_data38_->options & GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF) != 0) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = emsg;
		_tmp6_ = gitg_stage_message_with_sign_off (self, _tmp5_, _data38_->committer);
		_g_free0 (emsg);
		emsg = _tmp6_;
	}
	_tmp7_ = conf;
	_tmp8_ = emsg;
	_tmp10_ = gitg_stage_convert_message_to_encoding (self, _tmp7_, _tmp8_, &_tmp9_);
	_g_free0 (encoding);
	encoding = _tmp9_;
	_g_free0 (emsg);
	emsg = _tmp10_;
	if (!skip_hooks) {
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = emsg;
		_tmp13_ = gitg_stage_commit_msg_hook (self, _tmp12_, _data38_->author, _data38_->committer, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (encoding);
			_g_free0 (emsg);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp0_);
			return;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_free0 (emsg);
		emsg = _tmp14_;
		_g_free0 (_tmp11_);
	}
	refoid = NULL;
	{
		GgitRef* _tmp15_ = NULL;
		GgitRef* _tmp16_;
		GgitOId* _tmp17_;
		_tmp16_ = ggit_ref_resolve (_data38_->reference, &_inner_error0_);
		_tmp15_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp17_ = ggit_ref_get_target (_tmp15_);
		__vala_GgitOId_free0 (refoid);
		refoid = _tmp17_;
		_g_object_unref0 (_tmp15_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitOId_free0 (refoid);
		_g_free0 (encoding);
		_g_free0 (emsg);
		_g_object_unref0 (conf);
		_g_object_unref0 (_tmp0_);
		return;
	}
	if (!amend) {
		GgitOId** pars = NULL;
		gint pars_length1 = 0;
		gint _pars_size_ = 0;
		if (_data38_->parents == NULL) {
			GgitOId* _tmp18_;
			_tmp18_ = refoid;
			if (_tmp18_ == NULL) {
				GgitOId** _tmp19_;
				_tmp19_ = g_new0 (GgitOId*, 0 + 1);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				pars = _tmp19_;
				pars_length1 = 0;
				_pars_size_ = pars_length1;
			} else {
				GgitOId* _tmp20_;
				GgitOId* _tmp21_;
				GgitOId** _tmp22_;
				_tmp20_ = refoid;
				_tmp21_ = __vala_GgitOId_copy0 (_tmp20_);
				_tmp22_ = g_new0 (GgitOId*, 1 + 1);
				_tmp22_[0] = _tmp21_;
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				pars = _tmp22_;
				pars_length1 = 1;
				_pars_size_ = pars_length1;
			}
		} else {
			GgitOId** _tmp23_;
			gint _tmp23__length1;
			_tmp23_ = (_data38_->parents != NULL) ? _vala_array_dup23 (_data38_->parents, _data38_->parents_length1) : _data38_->parents;
			_tmp23__length1 = _data38_->parents_length1;
			pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			pars = _tmp23_;
			pars_length1 = _tmp23__length1;
			_pars_size_ = pars_length1;
		}
		if (sign_commit) {
			gchar* signing_key = NULL;
			GgitCommit** parent_commits = NULL;
			GgitOId** _tmp29_;
			gint _tmp29__length1;
			GgitCommit** _tmp30_;
			gint parent_commits_length1;
			gint _parent_commits_size_;
			GgitTree* _tmp41_ = NULL;
			GitgRepository* _tmp42_;
			GgitTree* _tmp43_;
			gchar* data = NULL;
			GitgRepository* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			GgitCommit** _tmp47_;
			gint _tmp47__length1;
			gchar* _tmp48_;
			gchar* signature = NULL;
			GgitOId* _tmp57_ = NULL;
			GitgRepository* _tmp58_;
			const gchar* _tmp59_;
			const gchar* _tmp60_;
			GgitOId* _tmp61_;
			GgitOId* _tmp62_;
			GgitRef* resolved = NULL;
			GgitRef* _tmp69_;
			GgitRef* _tmp70_;
			GgitRef* _tmp71_;
			{
				const gchar* _tmp24_ = NULL;
				GgitConfig* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp25_ = conf;
				_tmp26_ = ggit_config_get_string (_tmp25_, GITG_STAGE_CONFIG_USER_SIGNINGKEY, &_inner_error0_);
				_tmp24_ = _tmp26_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp27_ = g_strdup (_tmp24_);
				_g_free0 (signing_key);
				signing_key = _tmp27_;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _tmp28_;
				g_clear_error (&_inner_error0_);
				_tmp28_ = g_error_new (GITG_STAGE_ERROR, GITG_STAGE_ERROR_SIGN_CONFIG_NOT_FOUND, _ ("setup “%s” to do a signed commit"), GITG_STAGE_CONFIG_USER_SIGNINGKEY);
				_inner_error0_ = _tmp28_;
				goto __finally1;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (signing_key);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			_tmp29_ = pars;
			_tmp29__length1 = pars_length1;
			_tmp30_ = g_new0 (GgitCommit*, _tmp29__length1 + 1);
			parent_commits = _tmp30_;
			parent_commits_length1 = _tmp29__length1;
			_parent_commits_size_ = parent_commits_length1;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp31_ = FALSE;
					_tmp31_ = TRUE;
					while (TRUE) {
						GgitOId** _tmp33_;
						gint _tmp33__length1;
						GgitCommit* commit = NULL;
						GitgRepository* _tmp34_;
						GgitOId** _tmp35_;
						gint _tmp35__length1;
						GgitOId* _tmp36_;
						gpointer _tmp37_;
						GgitCommit** _tmp38_;
						gint _tmp38__length1;
						GgitCommit* _tmp39_;
						GgitCommit* _tmp40_;
						if (!_tmp31_) {
							gint _tmp32_;
							_tmp32_ = i;
							i = _tmp32_ + 1;
						}
						_tmp31_ = FALSE;
						_tmp33_ = pars;
						_tmp33__length1 = pars_length1;
						if (!(i < _tmp33__length1)) {
							break;
						}
						_tmp34_ = self->priv->d_repository;
						_tmp35_ = pars;
						_tmp35__length1 = pars_length1;
						_tmp36_ = _tmp35_[i];
						_tmp37_ = gitg_repository_lookup (_tmp34_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp36_, &_inner_error0_);
						commit = (GgitCommit*) _tmp37_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
							_g_free0 (signing_key);
							pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
							__vala_GgitOId_free0 (refoid);
							_g_free0 (encoding);
							_g_free0 (emsg);
							_g_object_unref0 (conf);
							_g_object_unref0 (_tmp0_);
							return;
						}
						_tmp38_ = parent_commits;
						_tmp38__length1 = parent_commits_length1;
						_tmp39_ = commit;
						_tmp40_ = _g_object_ref0 (_tmp39_);
						_g_object_unref0 (_tmp38_[i]);
						_tmp38_[i] = _tmp40_;
						_g_object_unref0 (commit);
					}
				}
			}
			_tmp42_ = self->priv->d_repository;
			_tmp43_ = ggit_repository_lookup_tree ((GgitRepository*) _tmp42_, _data38_->treeoid, &_inner_error0_);
			_tmp41_ = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (signing_key);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			_tmp44_ = self->priv->d_repository;
			_tmp45_ = encoding;
			_tmp46_ = emsg;
			_tmp47_ = parent_commits;
			_tmp47__length1 = parent_commits_length1;
			_tmp48_ = ggit_repository_create_commit_buffer ((GgitRepository*) _tmp44_, _data38_->author, _data38_->committer, _tmp45_, _tmp46_, _tmp41_, _tmp47_, (gint) _tmp47__length1, &_inner_error0_);
			data = _tmp48_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp41_);
				parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (signing_key);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			{
				gchar* _tmp49_ = NULL;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp50_ = data;
				_tmp51_ = signing_key;
				_tmp52_ = gitg_gpg_utils_sign_commit_object (_tmp50_, _tmp51_, &_inner_error0_);
				_tmp49_ = _tmp52_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				_tmp53_ = _tmp49_;
				_tmp49_ = NULL;
				_g_free0 (signature);
				signature = _tmp53_;
				_g_free0 (_tmp49_);
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp54_;
				const gchar* _tmp55_;
				GError* _tmp56_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp54_ = e;
				_tmp55_ = _tmp54_->message;
				_tmp56_ = g_error_new (GITG_STAGE_ERROR, GITG_STAGE_ERROR_SIGN_CONFIG_ERROR, _ ("error signing the commit “%s”"), _tmp55_);
				_inner_error0_ = _tmp56_;
				_g_error_free0 (e);
				goto __finally2;
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (signature);
				_g_free0 (data);
				_g_object_unref0 (_tmp41_);
				parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (signing_key);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			_tmp58_ = self->priv->d_repository;
			_tmp59_ = data;
			_tmp60_ = signature;
			_tmp61_ = ggit_repository_create_commit_with_signature ((GgitRepository*) _tmp58_, _tmp59_, _tmp60_, NULL, &_inner_error0_);
			_tmp57_ = _tmp61_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (signature);
				_g_free0 (data);
				_g_object_unref0 (_tmp41_);
				parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (signing_key);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			_tmp62_ = _tmp57_;
			_tmp57_ = NULL;
			__vala_GgitOId_free0 (_data38_->ret);
			_data38_->ret = _tmp62_;
			if (ggit_ref_get_reference_type (_data38_->reference) == GGIT_REF_SYMBOLIC) {
				{
					GgitRef* _tmp63_ = NULL;
					GgitRef* _tmp64_;
					GgitRef* _tmp65_;
					_tmp64_ = ggit_ref_resolve (_data38_->reference, &_inner_error0_);
					_tmp63_ = _tmp64_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch3_g_error;
					}
					_tmp65_ = _tmp63_;
					_tmp63_ = NULL;
					_g_object_unref0 (resolved);
					resolved = _tmp65_;
					_g_object_unref0 (_tmp63_);
				}
				goto __finally3;
				__catch3_g_error:
				{
					const gchar* _tmp66_;
					GError* _tmp67_;
					g_clear_error (&_inner_error0_);
					_tmp66_ = ggit_ref_get_name (_data38_->reference);
					_tmp67_ = g_error_new (GITG_STAGE_ERROR, GITG_STAGE_ERROR_UPDATE_REF_ERROR, _ ("error updating current ref “%s”"), _tmp66_);
					_inner_error0_ = _tmp67_;
					goto __finally3;
				}
				__finally3:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (resolved);
					__vala_GgitOId_free0 (_tmp57_);
					_g_free0 (signature);
					_g_free0 (data);
					_g_object_unref0 (_tmp41_);
					parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_free0 (signing_key);
					pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
					__vala_GgitOId_free0 (refoid);
					_g_free0 (encoding);
					_g_free0 (emsg);
					_g_object_unref0 (conf);
					_g_object_unref0 (_tmp0_);
					return;
				}
			} else {
				GgitRef* _tmp68_;
				_tmp68_ = _g_object_ref0 (_data38_->reference);
				_g_object_unref0 (resolved);
				resolved = _tmp68_;
			}
			_tmp69_ = resolved;
			_tmp70_ = ggit_ref_set_target (_tmp69_, _data38_->ret, NULL, &_inner_error0_);
			_tmp71_ = _tmp70_;
			_g_object_unref0 (_tmp71_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (resolved);
				__vala_GgitOId_free0 (_tmp57_);
				_g_free0 (signature);
				_g_free0 (data);
				_g_object_unref0 (_tmp41_);
				parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_free0 (signing_key);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			_g_object_unref0 (resolved);
			__vala_GgitOId_free0 (_tmp57_);
			_g_free0 (signature);
			_g_free0 (data);
			_g_object_unref0 (_tmp41_);
			parent_commits = (_vala_array_free (parent_commits, parent_commits_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_free0 (signing_key);
		} else {
			GgitOId* _tmp72_ = NULL;
			GitgRepository* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			GgitOId** _tmp77_;
			gint _tmp77__length1;
			GgitOId* _tmp78_;
			GgitOId* _tmp79_;
			_tmp73_ = self->priv->d_repository;
			_tmp74_ = ggit_ref_get_name (_data38_->reference);
			_tmp75_ = encoding;
			_tmp76_ = emsg;
			_tmp77_ = pars;
			_tmp77__length1 = pars_length1;
			_tmp78_ = ggit_repository_create_commit_from_ids ((GgitRepository*) _tmp73_, _tmp74_, _data38_->author, _data38_->committer, _tmp75_, _tmp76_, _data38_->treeoid, _tmp77_, (gint) _tmp77__length1, &_inner_error0_);
			_tmp72_ = _tmp78_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
				__vala_GgitOId_free0 (refoid);
				_g_free0 (encoding);
				_g_free0 (emsg);
				_g_object_unref0 (conf);
				_g_object_unref0 (_tmp0_);
				return;
			}
			_tmp79_ = _tmp72_;
			_tmp72_ = NULL;
			__vala_GgitOId_free0 (_data38_->ret);
			_data38_->ret = _tmp79_;
			__vala_GgitOId_free0 (_tmp72_);
		}
		pars = (_vala_array_free (pars, pars_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	} else {
		GgitCommit* refcommit = NULL;
		GitgRepository* _tmp80_;
		GgitOId* _tmp81_;
		gpointer _tmp82_;
		GgitTree* tree = NULL;
		GitgRepository* _tmp83_;
		gpointer _tmp84_;
		GgitOId* _tmp85_ = NULL;
		GgitCommit* _tmp86_;
		const gchar* _tmp87_;
		const gchar* _tmp88_;
		const gchar* _tmp89_;
		GgitTree* _tmp90_;
		GgitOId* _tmp91_;
		GgitOId* _tmp92_;
		_tmp80_ = self->priv->d_repository;
		_tmp81_ = refoid;
		_tmp82_ = gitg_repository_lookup (_tmp80_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp81_, &_inner_error0_);
		refcommit = (GgitCommit*) _tmp82_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			__vala_GgitOId_free0 (refoid);
			_g_free0 (encoding);
			_g_free0 (emsg);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp0_);
			return;
		}
		_tmp83_ = self->priv->d_repository;
		_tmp84_ = gitg_repository_lookup (_tmp83_, ggit_tree_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data38_->treeoid, &_inner_error0_);
		tree = (GgitTree*) _tmp84_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (refcommit);
			__vala_GgitOId_free0 (refoid);
			_g_free0 (encoding);
			_g_free0 (emsg);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp0_);
			return;
		}
		_tmp86_ = refcommit;
		_tmp87_ = ggit_ref_get_name (_data38_->reference);
		_tmp88_ = encoding;
		_tmp89_ = emsg;
		_tmp90_ = tree;
		_tmp91_ = ggit_commit_amend (_tmp86_, _tmp87_, _data38_->author, _data38_->committer, _tmp88_, _tmp89_, _tmp90_, &_inner_error0_);
		_tmp85_ = _tmp91_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (tree);
			_g_object_unref0 (refcommit);
			__vala_GgitOId_free0 (refoid);
			_g_free0 (encoding);
			_g_free0 (emsg);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp0_);
			return;
		}
		_tmp92_ = _tmp85_;
		_tmp85_ = NULL;
		__vala_GgitOId_free0 (_data38_->ret);
		_data38_->ret = _tmp92_;
		__vala_GgitOId_free0 (_tmp85_);
		_g_object_unref0 (tree);
		_g_object_unref0 (refcommit);
	}
	always_update = FALSE;
	{
		gboolean _tmp93_ = FALSE;
		GgitConfig* _tmp94_;
		_tmp94_ = conf;
		_tmp93_ = ggit_config_get_bool (_tmp94_, "core.logAllRefUpdates", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		always_update = _tmp93_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitOId_free0 (refoid);
		_g_free0 (encoding);
		_g_free0 (emsg);
		_g_object_unref0 (conf);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_tmp95_ = g_strdup ("commit");
	reflogmsg = _tmp95_;
	if (amend) {
		const gchar* _tmp96_;
		gchar* _tmp97_;
		_tmp96_ = reflogmsg;
		_tmp97_ = g_strconcat (_tmp96_, " (amend)", NULL);
		_g_free0 (reflogmsg);
		reflogmsg = _tmp97_;
	}
	_tmp98_ = reflogmsg;
	_tmp99_ = gitg_stage_get_subject (self, _data38_->message);
	_tmp100_ = _tmp99_;
	_tmp101_ = g_strconcat (": ", _tmp100_, NULL);
	_tmp102_ = _tmp101_;
	_tmp103_ = g_strconcat (_tmp98_, _tmp102_, NULL);
	_g_free0 (reflogmsg);
	reflogmsg = _tmp103_;
	_g_free0 (_tmp102_);
	_g_free0 (_tmp100_);
	{
		gboolean _tmp104_ = FALSE;
		if (always_update) {
			_tmp104_ = TRUE;
		} else {
			_tmp104_ = ggit_ref_has_log (_data38_->reference);
		}
		if (_tmp104_) {
			GgitReflog* reflog = NULL;
			GgitReflog* _tmp105_;
			GgitReflog* _tmp106_;
			const gchar* _tmp107_;
			GgitReflog* _tmp108_;
			_tmp105_ = ggit_ref_get_log (_data38_->reference, &_inner_error0_);
			reflog = _tmp105_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch5_g_error;
			}
			_tmp106_ = reflog;
			_tmp107_ = reflogmsg;
			ggit_reflog_append (_tmp106_, _data38_->ret, _data38_->committer, _tmp107_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_ggit_reflog_unref0 (reflog);
				goto __catch5_g_error;
			}
			_tmp108_ = reflog;
			ggit_reflog_write (_tmp108_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_ggit_reflog_unref0 (reflog);
				goto __catch5_g_error;
			}
			_ggit_reflog_unref0 (reflog);
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (reflogmsg);
		__vala_GgitOId_free0 (refoid);
		_g_free0 (encoding);
		_g_free0 (emsg);
		_g_object_unref0 (conf);
		_g_object_unref0 (_tmp0_);
		return;
	}
	if (ggit_ref_get_reference_type (_data38_->reference) == GGIT_REF_SYMBOLIC) {
		{
			GgitRef* resolved = NULL;
			GgitRef* _tmp109_;
			gboolean _tmp110_ = FALSE;
			_tmp109_ = ggit_ref_resolve (_data38_->reference, &_inner_error0_);
			resolved = _tmp109_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch6_g_error;
			}
			if (always_update) {
				_tmp110_ = TRUE;
			} else {
				GgitRef* _tmp111_;
				_tmp111_ = resolved;
				_tmp110_ = ggit_ref_has_log (_tmp111_);
			}
			if (_tmp110_) {
				GgitReflog* reflog = NULL;
				GgitRef* _tmp112_;
				GgitReflog* _tmp113_;
				GgitReflog* _tmp114_;
				const gchar* _tmp115_;
				GgitReflog* _tmp116_;
				_tmp112_ = resolved;
				_tmp113_ = ggit_ref_get_log (_tmp112_, &_inner_error0_);
				reflog = _tmp113_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (resolved);
					goto __catch6_g_error;
				}
				_tmp114_ = reflog;
				_tmp115_ = reflogmsg;
				ggit_reflog_append (_tmp114_, _data38_->ret, _data38_->committer, _tmp115_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_ggit_reflog_unref0 (reflog);
					_g_object_unref0 (resolved);
					goto __catch6_g_error;
				}
				_tmp116_ = reflog;
				ggit_reflog_write (_tmp116_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_ggit_reflog_unref0 (reflog);
					_g_object_unref0 (resolved);
					goto __catch6_g_error;
				}
				_ggit_reflog_unref0 (reflog);
			}
			_g_object_unref0 (resolved);
		}
		goto __finally6;
		__catch6_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (reflogmsg);
			__vala_GgitOId_free0 (refoid);
			_g_free0 (encoding);
			_g_free0 (emsg);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp0_);
			return;
		}
	}
	_tmp117_ = ggit_ref_get_name (_data38_->reference);
	if (g_strcmp0 (_tmp117_, "HEAD") == 0) {
		_g_object_unref0 (self->priv->d_head_tree);
		self->priv->d_head_tree = NULL;
	}
	gitg_stage_post_commit_hook (self, _data38_->author);
	_g_free0 (reflogmsg);
	__vala_GgitOId_free0 (refoid);
	_g_free0 (encoding);
	_g_free0 (emsg);
	_g_object_unref0 (conf);
	_g_object_unref0 (_tmp0_);
}

static void
___lambda19__gitg_async_thread_func (gpointer self,
                                     GError** error)
{
	__lambda19_ (self, error);
}

static void
gitg_stage_commit_tree_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GitgStageCommitTreeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_commit_tree_co (_data_);
}

static gboolean
gitg_stage_commit_tree_co (GitgStageCommitTreeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data38_ = g_slice_new0 (Block38Data);
	_data_->_data38_->_ref_count_ = 1;
	_data_->_data38_->self = g_object_ref (_data_->self);
	__vala_GgitOId_free0 (_data_->_data38_->treeoid);
	_data_->_data38_->treeoid = _data_->treeoid;
	_g_object_unref0 (_data_->_data38_->reference);
	_data_->_data38_->reference = _data_->reference;
	_g_free0 (_data_->_data38_->message);
	_data_->_data38_->message = _data_->message;
	_g_object_unref0 (_data_->_data38_->author);
	_data_->_data38_->author = _data_->author;
	_g_object_unref0 (_data_->_data38_->committer);
	_data_->_data38_->committer = _data_->committer;
	_data_->_data38_->parents = _data_->parents;
	_data_->_data38_->parents_length1 = _data_->parents_length1;
	_data_->_data38_->options = _data_->options;
	_data_->_data38_->_async_data_ = _data_;
	_data_->_data38_->ret = NULL;
	_data_->_state_ = 1;
	gitg_async_thread (___lambda19__gitg_async_thread_func, _data_->_data38_, gitg_stage_commit_tree_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block38_data_unref (_data_->_data38_);
		_data_->_data38_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = __vala_GgitOId_copy0 (_data_->_data38_->ret);
	_data_->result = _data_->_tmp0_;
	block38_data_unref (_data_->_data38_);
	_data_->_data38_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_commit_data_free (gpointer _data)
{
	GitgStageCommitData* _data_;
	_data_ = _data;
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->author);
	_g_object_unref0 (_data_->committer);
	__vala_GgitOId_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageCommitData, _data_);
}

void
gitg_stage_commit (GitgStage* self,
                   const gchar* message,
                   GgitSignature* author,
                   GgitSignature* committer,
                   GitgStageCommitOptions options,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	GitgStageCommitData* _data_;
	GitgStage* _tmp0_;
	gchar* _tmp1_;
	GgitSignature* _tmp2_;
	GgitSignature* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (author != NULL);
	g_return_if_fail (committer != NULL);
	_data_ = g_slice_new0 (GitgStageCommitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_commit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (author);
	_g_object_unref0 (_data_->author);
	_data_->author = _tmp2_;
	_tmp3_ = _g_object_ref0 (committer);
	_g_object_unref0 (_data_->committer);
	_data_->committer = _tmp3_;
	_data_->options = options;
	gitg_stage_commit_co (_data_);
}

GgitOId*
gitg_stage_commit_finish (GitgStage* self,
                          GAsyncResult* _res_,
                          GError** error)
{
	GgitOId* result;
	GitgStageCommitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		GitgStage* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->index);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static void
___lambda20_ (Block39Data* _data39_,
              GError** error)
{
	GitgStage* self;
	GgitIndex* _tmp0_ = NULL;
	GitgRepository* _tmp1_;
	GgitIndex* _tmp2_;
	GgitIndex* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data39_->self;
	_tmp1_ = self->priv->d_repository;
	_tmp2_ = ggit_repository_get_index ((GgitRepository*) _tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (_data39_->index);
	_data39_->index = _tmp3_;
	_g_object_unref0 (_tmp0_);
}

static void
____lambda20__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda20_ (self, error);
}

static void
gitg_stage_commit_ready (GObject* source_object,
                         GAsyncResult* _res_,
                         gpointer _user_data_)
{
	GitgStageCommitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_commit_co (_data_);
}

static gboolean
gitg_stage_commit_co (GitgStageCommitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->amend = (_data_->options & GITG_STAGE_COMMIT_OPTIONS_AMEND) != 0;
	_data_->ret = NULL;
	{
		g_rec_mutex_lock (&_data_->self->priv->__lock_d_index_mutex);
		{
			_data_->_data39_ = g_slice_new0 (Block39Data);
			_data_->_data39_->_ref_count_ = 1;
			_data_->_data39_->self = g_object_ref (_data_->self);
			_data_->_data39_->index = NULL;
			_data_->_state_ = 1;
			gitg_async_thread (____lambda20__gitg_async_thread_func, _data_->_data39_, gitg_stage_commit_ready, _data_);
			return FALSE;
			_state_1:
			gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				block39_data_unref (_data_->_data39_);
				_data_->_data39_ = NULL;
				goto __catch0_g_error;
			}
			if (!_data_->amend) {
				_data_->_tmp0_ = !gitg_stage_has_index_changes (_data_->self);
			} else {
				_data_->_tmp0_ = FALSE;
			}
			if (_data_->_tmp0_) {
				_data_->_tmp1_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_NOTHING_TO_COMMIT, "Nothing to commit");
				_data_->_inner_error0_ = _data_->_tmp1_;
				block39_data_unref (_data_->_data39_);
				_data_->_data39_ = NULL;
				goto __catch0_g_error;
			}
			_data_->_tmp3_ = _data_->self->priv->d_repository;
			_data_->_tmp4_ = gitg_repository_lookup_reference (_data_->_tmp3_, "HEAD", &_data_->_inner_error0_);
			_data_->_tmp2_ = _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				block39_data_unref (_data_->_data39_);
				_data_->_data39_ = NULL;
				goto __catch0_g_error;
			}
			_data_->_tmp6_ = _data_->_data39_->index;
			_data_->_state_ = 2;
			gitg_stage_commit_index (_data_->self, _data_->_tmp6_, (GgitRef*) _data_->_tmp2_, _data_->message, _data_->author, _data_->committer, NULL, (gint) 0, _data_->options, gitg_stage_commit_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp7_ = gitg_stage_commit_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp2_);
				block39_data_unref (_data_->_data39_);
				_data_->_data39_ = NULL;
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			__vala_GgitOId_free0 (_data_->ret);
			_data_->ret = _data_->_tmp8_;
			__vala_GgitOId_free0 (_data_->_tmp5_);
			_g_object_unref0 (_data_->_tmp2_);
			block39_data_unref (_data_->_data39_);
			_data_->_data39_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_lock_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp9_ = _data_->_lock_error_;
			_data_->_lock_error_ = NULL;
			_data_->_inner_error0_ = _data_->_tmp9_;
			_g_error_free0 (_data_->_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			g_rec_mutex_unlock (&_data_->self->priv->__lock_d_index_mutex);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			__vala_GgitOId_free0 (_data_->ret);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->ret;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_revert_data_free (gpointer _data)
{
	GitgStageRevertData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageRevertData, _data_);
}

void
gitg_stage_revert (GitgStage* self,
                   GFile* file,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	GitgStageRevertData* _data_;
	GitgStage* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GitgStageRevertData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_revert_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	gitg_stage_revert_co (_data_);
}

void
gitg_stage_revert_finish (GitgStage* self,
                          GAsyncResult* _res_,
                          GError** error)
{
	GitgStageRevertData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Revert working directory changes.
 *
 * @param file the file to revert.
 *
 * Revert a file to the version currently recorded in HEAD. This will delete
 * any modifications done in the current working directory to this file,
 * so use with care! Note that this only affects the working directory,
 * not the index.
 */
static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		GitgStage* self;
		self = _data40_->self;
		_g_object_unref0 (_data40_->tree);
		_g_object_unref0 (_data40_->file);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}

static void
gitg_stage_revert_ready (GObject* source_object,
                         GAsyncResult* _res_,
                         gpointer _user_data_)
{
	GitgStageRevertData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_revert_co (_data_);
}

static void
__lambda21_ (Block40Data* _data40_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GFile* wd = NULL;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	GgitTreeEntry* entry = NULL;
	GgitTree* _tmp4_;
	const gchar* _tmp5_;
	GgitTreeEntry* _tmp6_;
	GgitOId* id = NULL;
	GgitTreeEntry* _tmp7_;
	GgitOId* _tmp8_;
	GgitBlob* blob = NULL;
	GitgRepository* _tmp9_;
	GgitOId* _tmp10_;
	gpointer _tmp11_;
	GFileOutputStream* stream = NULL;
	GFileOutputStream* _tmp12_;
	GFileOutputStream* _tmp13_;
	GgitBlob* _tmp14_;
	gsize _tmp15_ = 0;
	guint8* _tmp16_;
	GFileOutputStream* _tmp17_;
	GError* _inner_error0_ = NULL;
	self = _data40_->self;
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->d_repository;
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
	wd = _tmp1_;
	_tmp2_ = wd;
	_tmp3_ = g_file_get_relative_path (_tmp2_, _data40_->file);
	path = _tmp3_;
	_tmp4_ = _data40_->tree;
	_tmp5_ = path;
	_tmp6_ = ggit_tree_get_by_path (_tmp4_, _tmp5_, &_inner_error0_);
	entry = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_tmp7_ = entry;
	_tmp8_ = ggit_tree_entry_get_id (_tmp7_);
	id = _tmp8_;
	_tmp9_ = self->priv->d_repository;
	_tmp10_ = id;
	_tmp11_ = gitg_repository_lookup (_tmp9_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_, &_inner_error0_);
	blob = (GgitBlob*) _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_tmp12_ = g_file_replace (_data40_->file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
	stream = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_tmp13_ = stream;
	_tmp14_ = blob;
	_tmp16_ = ggit_blob_get_raw_content (_tmp14_, &_tmp15_);
	g_output_stream_write_all ((GOutputStream*) _tmp13_, _tmp16_, (gsize) _tmp15_, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_tmp17_ = stream;
	g_output_stream_close ((GOutputStream*) _tmp17_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (blob);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_g_object_unref0 (stream);
	_g_object_unref0 (blob);
	__vala_GgitOId_free0 (id);
	_ggit_tree_entry_unref0 (entry);
	_g_free0 (path);
	_g_object_unref0 (wd);
}

static void
___lambda21__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda21_ (self, index, error);
}

static gboolean
gitg_stage_revert_co (GitgStageRevertData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data40_ = g_slice_new0 (Block40Data);
	_data_->_data40_->_ref_count_ = 1;
	_data_->_data40_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data40_->file);
	_data_->_data40_->file = _data_->file;
	_data_->_data40_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_stage_get_head_tree (_data_->self, gitg_stage_revert_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_data40_->tree = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block40_data_unref (_data_->_data40_);
		_data_->_data40_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	gitg_stage_thread_index (_data_->self, ___lambda21__gitg_stage_with_index_func, _data_->_data40_, gitg_stage_revert_ready, _data_);
	return FALSE;
	_state_2:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block40_data_unref (_data_->_data40_);
		_data_->_data40_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block40_data_unref (_data_->_data40_);
	_data_->_data40_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_revert_path_data_free (gpointer _data)
{
	GitgStageRevertPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageRevertPathData, _data_);
}

void
gitg_stage_revert_path (GitgStage* self,
                        const gchar* path,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgStageRevertPathData* _data_;
	GitgStage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (GitgStageRevertPathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_revert_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	gitg_stage_revert_path_co (_data_);
}

void
gitg_stage_revert_path_finish (GitgStage* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GitgStageRevertPathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Revert working directory changes.
 *
 * @param path path relative to the working directory.
 *
 * Revert a path to the version currently recorded in HEAD. This will delete
 * any modifications done in the current working directory to this file,
 * so use with care! Note that this only affects the working directory,
 * not the index.
 */
static void
gitg_stage_revert_path_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GitgStageRevertPathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_revert_path_co (_data_);
}

static gboolean
gitg_stage_revert_path_co (GitgStageRevertPathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->path);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	gitg_stage_revert (_data_->self, _data_->_tmp4_, gitg_stage_revert_path_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_revert_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp2_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_revert_patch_data_free (gpointer _data)
{
	GitgStageRevertPatchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageRevertPatchData, _data_);
}

static gpointer
_gitg_patch_set_ref0 (gpointer self)
{
	return self ? gitg_patch_set_ref (self) : NULL;
}

void
gitg_stage_revert_patch (GitgStage* self,
                         GitgPatchSet* patch,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgStageRevertPatchData* _data_;
	GitgStage* _tmp0_;
	GitgPatchSet* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (patch != NULL);
	_data_ = g_slice_new0 (GitgStageRevertPatchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_revert_patch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _gitg_patch_set_ref0 (patch);
	_gitg_patch_set_unref0 (_data_->patch);
	_data_->patch = _tmp1_;
	gitg_stage_revert_patch_co (_data_);
}

void
gitg_stage_revert_patch_finish (GitgStage* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GitgStageRevertPatchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Revert a patch in the working directory.
 *
 * @param patch the patch to revert.
 *
 * Revert a provided patch from the working directory. The patch should
 * contain changes of the file in the current working directory to the contents
 * of the index (i.e. as obtained from diff_workdir)
 */
static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		GitgStage* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->workdirf_stream);
		_g_object_unref0 (_data41_->workdirf);
		_gitg_patch_set_unref0 (_data41_->patch);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
gitg_stage_revert_patch_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgStageRevertPatchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_revert_patch_co (_data_);
}

static void
__lambda22_ (Block41Data* _data41_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GgitIndexEntries* entries = NULL;
	GgitIndexEntries* _tmp0_;
	GgitIndexEntry* entry = NULL;
	GgitIndexEntries* _tmp1_;
	GFile* _tmp2_;
	GgitIndexEntry* _tmp3_;
	GgitIndexEntry* _tmp4_;
	GgitBlob* index_blob = NULL;
	GitgRepository* _tmp7_;
	GgitIndexEntry* _tmp8_;
	GgitOId* _tmp9_;
	GgitOId* _tmp10_;
	gpointer _tmp11_;
	GgitBlob* _tmp12_;
	guchar* index_content = NULL;
	GgitBlob* _tmp13_;
	gsize _tmp14_ = 0;
	guint8* _tmp15_;
	gint index_content_length1;
	gint _index_content_size_;
	GMemoryInputStream* index_stream = NULL;
	guchar* _tmp16_;
	gint _tmp16__length1;
	GBytes* _tmp17_;
	GBytes* _tmp18_;
	GMemoryInputStream* _tmp19_;
	GMemoryInputStream* _tmp20_;
	GitgPatchSet* reversed = NULL;
	GitgPatchSet* _tmp21_;
	GFileIOStream* out_stream = NULL;
	GFile* outf = NULL;
	GFileInputStream* _tmp38_;
	GMemoryInputStream* _tmp39_;
	GFileIOStream* _tmp40_;
	GError* _inner_error0_ = NULL;
	self = _data41_->self;
	g_return_if_fail (index != NULL);
	_tmp0_ = ggit_index_get_entries (index);
	entries = _tmp0_;
	_tmp1_ = entries;
	_tmp2_ = _data41_->workdirf;
	_tmp3_ = ggit_index_entries_get_by_path (_tmp1_, _tmp2_, 0);
	entry = _tmp3_;
	_tmp4_ = entry;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = _data41_->patch->filename;
		_tmp6_ = g_error_new_literal (GITG_STAGE_ERROR, GITG_STAGE_ERROR_INDEX_ENTRY_NOT_FOUND, _tmp5_);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp7_ = self->priv->d_repository;
	_tmp8_ = entry;
	_tmp9_ = ggit_index_entry_get_id (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gitg_repository_lookup (_tmp7_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_, &_inner_error0_);
	_tmp12_ = (GgitBlob*) _tmp11_;
	__vala_GgitOId_free0 (_tmp10_);
	index_blob = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp13_ = index_blob;
	_tmp15_ = ggit_blob_get_raw_content (_tmp13_, &_tmp14_);
	index_content = _tmp15_;
	index_content_length1 = _tmp14_;
	_index_content_size_ = index_content_length1;
	_tmp16_ = index_content;
	_tmp16__length1 = index_content_length1;
	_tmp17_ = g_bytes_new (_tmp16_, _tmp16__length1);
	_tmp18_ = _tmp17_;
	_tmp19_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp18_);
	_tmp20_ = _tmp19_;
	_g_bytes_unref0 (_tmp18_);
	index_stream = _tmp20_;
	_tmp21_ = gitg_patch_set_reversed (_data41_->patch);
	reversed = _tmp21_;
	out_stream = NULL;
	outf = NULL;
	{
		GFile* _tmp22_ = NULL;
		GFileIOStream* _tmp23_ = NULL;
		GFile* _tmp24_;
		GFile* _tmp25_;
		GFileInputStream* _tmp26_;
		GMemoryInputStream* _tmp27_;
		GFileIOStream* _tmp28_;
		GOutputStream* _tmp29_;
		GOutputStream* _tmp30_;
		GitgPatchSet* _tmp31_;
		_tmp24_ = g_file_new_tmp (NULL, &_tmp23_, &_inner_error0_);
		_g_object_unref0 (out_stream);
		out_stream = _tmp23_;
		_tmp22_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp25_ = _tmp22_;
		_tmp22_ = NULL;
		_g_object_unref0 (outf);
		outf = _tmp25_;
		_tmp26_ = _data41_->workdirf_stream;
		_tmp27_ = index_stream;
		_tmp28_ = out_stream;
		_tmp29_ = g_io_stream_get_output_stream ((GIOStream*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = reversed;
		gitg_stage_apply_patch_stream (self, (GInputStream*) _tmp26_, (GInputStream*) _tmp27_, _tmp30_, _tmp31_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp22_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp22_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GFileInputStream* _tmp32_;
		GMemoryInputStream* _tmp33_;
		GFile* _tmp34_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = _data41_->workdirf_stream;
		g_input_stream_close ((GInputStream*) _tmp32_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (e);
			goto __finally0;
		}
		_tmp33_ = index_stream;
		g_input_stream_close ((GInputStream*) _tmp33_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (e);
			goto __finally0;
		}
		_tmp34_ = outf;
		if (_tmp34_ != NULL) {
			{
				GFile* _tmp35_;
				_tmp35_ = outf;
				g_file_delete (_tmp35_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (e);
				_g_object_unref0 (outf);
				_g_object_unref0 (out_stream);
				_gitg_patch_set_unref0 (reversed);
				_g_object_unref0 (index_stream);
				_g_object_unref0 (index_blob);
				_ggit_index_entry_unref0 (entry);
				_ggit_index_entries_unref0 (entries);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp36_ = e;
		_tmp37_ = _g_error_copy0 (_tmp36_);
		_inner_error0_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (outf);
		_g_object_unref0 (out_stream);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (index_blob);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp38_ = _data41_->workdirf_stream;
	g_input_stream_close ((GInputStream*) _tmp38_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (outf);
		_g_object_unref0 (out_stream);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (index_blob);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp39_ = index_stream;
	g_input_stream_close ((GInputStream*) _tmp39_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (outf);
		_g_object_unref0 (out_stream);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (index_blob);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp40_ = out_stream;
	if (_tmp40_ != NULL) {
		GFileIOStream* _tmp41_;
		_tmp41_ = out_stream;
		g_io_stream_close ((GIOStream*) _tmp41_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (outf);
			_g_object_unref0 (out_stream);
			_gitg_patch_set_unref0 (reversed);
			_g_object_unref0 (index_stream);
			_g_object_unref0 (index_blob);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			return;
		}
	}
	{
		GFileOutputStream* repl = NULL;
		GFile* _tmp42_;
		GFileOutputStream* _tmp43_;
		GFileInputStream* _tmp44_ = NULL;
		GFile* _tmp45_;
		GFileInputStream* _tmp46_;
		GFileOutputStream* _tmp47_;
		_tmp42_ = _data41_->workdirf;
		_tmp43_ = g_file_replace (_tmp42_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		repl = _tmp43_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp45_ = outf;
		_tmp46_ = g_file_read (_tmp45_, NULL, &_inner_error0_);
		_tmp44_ = _tmp46_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repl);
			goto __catch2_g_error;
		}
		_tmp47_ = repl;
		g_output_stream_splice ((GOutputStream*) _tmp47_, (GInputStream*) _tmp44_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp44_);
			_g_object_unref0 (repl);
			goto __catch2_g_error;
		}
		_g_object_unref0 (_tmp44_);
		_g_object_unref0 (repl);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp49_;
		GError* _tmp50_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		{
			GFile* _tmp48_;
			_tmp48_ = outf;
			g_file_delete (_tmp48_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (e);
			_g_object_unref0 (outf);
			_g_object_unref0 (out_stream);
			_gitg_patch_set_unref0 (reversed);
			_g_object_unref0 (index_stream);
			_g_object_unref0 (index_blob);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp49_ = e;
		_tmp50_ = _g_error_copy0 (_tmp49_);
		_inner_error0_ = _tmp50_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (outf);
		_g_object_unref0 (out_stream);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (index_blob);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	{
		GFile* _tmp51_;
		_tmp51_ = outf;
		g_file_delete (_tmp51_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (outf);
		_g_object_unref0 (out_stream);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (index_blob);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_g_object_unref0 (outf);
	_g_object_unref0 (out_stream);
	_gitg_patch_set_unref0 (reversed);
	_g_object_unref0 (index_stream);
	_g_object_unref0 (index_blob);
	_ggit_index_entry_unref0 (entry);
	_ggit_index_entries_unref0 (entries);
}

static void
___lambda22__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda22_ (self, index, error);
}

static gboolean
gitg_stage_revert_patch_co (GitgStageRevertPatchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data41_ = g_slice_new0 (Block41Data);
	_data_->_data41_->_ref_count_ = 1;
	_data_->_data41_->self = g_object_ref (_data_->self);
	_gitg_patch_set_unref0 (_data_->_data41_->patch);
	_data_->_data41_->patch = _data_->patch;
	_data_->_data41_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_data41_->patch->filename;
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_data41_->workdirf = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->_data41_->workdirf;
	_data_->_state_ = 1;
	g_file_read_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, gitg_stage_revert_patch_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = g_file_read_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_data41_->workdirf_stream = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block41_data_unref (_data_->_data41_);
		_data_->_data41_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	gitg_stage_thread_index (_data_->self, ___lambda22__gitg_stage_with_index_func, _data_->_data41_, gitg_stage_revert_patch_ready, _data_);
	return FALSE;
	_state_2:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block41_data_unref (_data_->_data41_);
		_data_->_data41_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block41_data_unref (_data_->_data41_);
	_data_->_data41_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_delete_data_free (gpointer _data)
{
	GitgStageDeleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageDeleteData, _data_);
}

void
gitg_stage_delete (GitgStage* self,
                   GFile* file,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	GitgStageDeleteData* _data_;
	GitgStage* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GitgStageDeleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	gitg_stage_delete_co (_data_);
}

void
gitg_stage_delete_finish (GitgStage* self,
                          GAsyncResult* _res_,
                          GError** error)
{
	GitgStageDeleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Delete a file from the index.
 *
 * @param file the file to delete.
 *
 * Delete the file from the index.
 */
static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		GitgStage* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->file);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
__lambda23_ (Block42Data* _data42_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GError* _inner_error0_ = NULL;
	self = _data42_->self;
	g_return_if_fail (index != NULL);
	ggit_index_remove (index, _data42_->file, 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	ggit_index_write (index, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda23__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda23_ (self, index, error);
}

static void
gitg_stage_delete_ready (GObject* source_object,
                         GAsyncResult* _res_,
                         gpointer _user_data_)
{
	GitgStageDeleteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_delete_co (_data_);
}

static gboolean
gitg_stage_delete_co (GitgStageDeleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data42_ = g_slice_new0 (Block42Data);
	_data_->_data42_->_ref_count_ = 1;
	_data_->_data42_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data42_->file);
	_data_->_data42_->file = _data_->file;
	_data_->_data42_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_stage_thread_index (_data_->self, ___lambda23__gitg_stage_with_index_func, _data_->_data42_, gitg_stage_delete_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block42_data_unref (_data_->_data42_);
		_data_->_data42_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block42_data_unref (_data_->_data42_);
	_data_->_data42_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_delete_path_data_free (gpointer _data)
{
	GitgStageDeletePathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageDeletePathData, _data_);
}

void
gitg_stage_delete_path (GitgStage* self,
                        const gchar* path,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgStageDeletePathData* _data_;
	GitgStage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (GitgStageDeletePathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_delete_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	gitg_stage_delete_path_co (_data_);
}

void
gitg_stage_delete_path_finish (GitgStage* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GitgStageDeletePathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Delete a relative path from the index.
 *
 * @param path path relative to the working directory.
 *
 * Delete the relative path from the index.
 */
static void
gitg_stage_delete_path_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GitgStageDeletePathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_delete_path_co (_data_);
}

static gboolean
gitg_stage_delete_path_co (GitgStageDeletePathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->path);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	gitg_stage_delete (_data_->self, _data_->_tmp4_, gitg_stage_delete_path_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_delete_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp2_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_stage_data_free (gpointer _data)
{
	GitgStageStageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageStageData, _data_);
}

void
gitg_stage_stage (GitgStage* self,
                  GFile* file,
                  GAsyncReadyCallback _callback_,
                  gpointer _user_data_)
{
	GitgStageStageData* _data_;
	GitgStage* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GitgStageStageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_stage_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	gitg_stage_stage_co (_data_);
}

void
gitg_stage_stage_finish (GitgStage* self,
                         GAsyncResult* _res_,
                         GError** error)
{
	GitgStageStageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Stage a file to the index.
 *
 * @param file the file to stage.
 *
 * Stage the file to the index. This will record the state of the file in
 * the working directory to the index.
 */
static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		GitgStage* self;
		self = _data43_->self;
		_g_object_unref0 (_data43_->file);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static void
__lambda24_ (Block43Data* _data43_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GError* _inner_error0_ = NULL;
	self = _data43_->self;
	g_return_if_fail (index != NULL);
	ggit_index_add_file (index, _data43_->file, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	ggit_index_write (index, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda24__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda24_ (self, index, error);
}

static void
gitg_stage_stage_ready (GObject* source_object,
                        GAsyncResult* _res_,
                        gpointer _user_data_)
{
	GitgStageStageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_stage_co (_data_);
}

static gboolean
gitg_stage_stage_co (GitgStageStageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data43_ = g_slice_new0 (Block43Data);
	_data_->_data43_->_ref_count_ = 1;
	_data_->_data43_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data43_->file);
	_data_->_data43_->file = _data_->file;
	_data_->_data43_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_stage_thread_index (_data_->self, ___lambda24__gitg_stage_with_index_func, _data_->_data43_, gitg_stage_stage_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block43_data_unref (_data_->_data43_);
		_data_->_data43_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block43_data_unref (_data_->_data43_);
	_data_->_data43_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_stage_path_data_free (gpointer _data)
{
	GitgStageStagePathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageStagePathData, _data_);
}

void
gitg_stage_stage_path (GitgStage* self,
                       const gchar* path,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	GitgStageStagePathData* _data_;
	GitgStage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (GitgStageStagePathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_stage_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	gitg_stage_stage_path_co (_data_);
}

void
gitg_stage_stage_path_finish (GitgStage* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	GitgStageStagePathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Stage a path to the index.
 *
 * @param path path relative to the working directory.
 *
 * Stage a relative path to the index. This will record the state of the file in
 * the working directory to the index.
 */
static void
gitg_stage_stage_path_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	GitgStageStagePathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_stage_path_co (_data_);
}

static gboolean
gitg_stage_stage_path_co (GitgStageStagePathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->path);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	gitg_stage_stage (_data_->self, _data_->_tmp4_, gitg_stage_stage_path_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_stage_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp2_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_stage_commit_data_free (gpointer _data)
{
	GitgStageStageCommitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageStageCommitData, _data_);
}

void
gitg_stage_stage_commit (GitgStage* self,
                         const gchar* path,
                         GgitCommit* commit,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgStageStageCommitData* _data_;
	GitgStage* _tmp0_;
	gchar* _tmp1_;
	GgitCommit* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (commit != NULL);
	_data_ = g_slice_new0 (GitgStageStageCommitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_stage_commit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (commit);
	_g_object_unref0 (_data_->commit);
	_data_->commit = _tmp2_;
	gitg_stage_stage_commit_co (_data_);
}

void
gitg_stage_stage_commit_finish (GitgStage* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GitgStageStageCommitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Stage a commit to the index.
 *
 * @param path path relative to the working directory.
 * @param id the id of the commit object to stage at the given path.
 *
 * Stage a commit to the index with a relative path. This will record the
 * given commit id for file pointed to at path in the index.
 */
static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		GitgStage* self;
		self = _data44_->self;
		_g_free0 (_data44_->path);
		_g_object_unref0 (_data44_->commit);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static void
__lambda25_ (Block44Data* _data44_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GgitIndexEntry* entry = NULL;
	GitgRepository* _tmp0_;
	GgitOId* _tmp1_;
	GgitOId* _tmp2_;
	GgitIndexEntry* _tmp3_;
	GgitIndexEntry* _tmp4_;
	GgitIndexEntry* _tmp5_;
	GgitIndexEntry* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = _data44_->self;
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->d_repository;
	_tmp1_ = ggit_object_get_id ((GgitObject*) _data44_->commit);
	_tmp2_ = _tmp1_;
	_tmp3_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp0_, _data44_->path, _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	__vala_GgitOId_free0 (_tmp2_);
	entry = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = entry;
	ggit_index_entry_set_commit (_tmp5_, _data44_->commit);
	_tmp6_ = entry;
	ggit_index_add (index, _tmp6_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (entry);
		return;
	}
	ggit_index_write (index, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (entry);
		return;
	}
	_ggit_index_entry_unref0 (entry);
}

static void
___lambda25__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda25_ (self, index, error);
}

static void
gitg_stage_stage_commit_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgStageStageCommitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_stage_commit_co (_data_);
}

static gboolean
gitg_stage_stage_commit_co (GitgStageStageCommitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data44_ = g_slice_new0 (Block44Data);
	_data_->_data44_->_ref_count_ = 1;
	_data_->_data44_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data44_->path);
	_data_->_data44_->path = _data_->path;
	_g_object_unref0 (_data_->_data44_->commit);
	_data_->_data44_->commit = _data_->commit;
	_data_->_data44_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_stage_thread_index (_data_->self, ___lambda25__gitg_stage_with_index_func, _data_->_data44_, gitg_stage_stage_commit_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block44_data_unref (_data_->_data44_);
		_data_->_data44_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block44_data_unref (_data_->_data44_);
	_data_->_data44_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_copy_stream (GitgStage* self,
                        GOutputStream* dest,
                        GInputStream* src,
                        gsize* pos,
                        gsize index,
                        gsize length,
                        GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	g_return_if_fail (src != NULL);
	if (length == ((gsize) 0)) {
		return;
	}
	_tmp0_ = g_new0 (guint8, length);
	buf = _tmp0_;
	buf_length1 = length;
	_buf_size_ = buf_length1;
	if ((*pos) != index) {
		g_seekable_seek (G_TYPE_CHECK_INSTANCE_CAST (src, g_seekable_get_type (), GSeekable), (gint64) index, G_SEEK_SET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			buf = (g_free (buf), NULL);
			return;
		}
		*pos = index;
	}
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	g_input_stream_read_all (src, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buf = (g_free (buf), NULL);
		return;
	}
	_tmp2_ = buf;
	_tmp2__length1 = buf_length1;
	g_output_stream_write_all (dest, _tmp2_, (gsize) _tmp2__length1, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buf = (g_free (buf), NULL);
		return;
	}
	*pos = (*pos) + length;
	buf = (g_free (buf), NULL);
}

static void
gitg_stage_apply_patch (GitgStage* self,
                        GgitIndex* index,
                        guint filemode,
                        GInputStream* old_stream,
                        GInputStream* new_stream,
                        GitgPatchSet* patch,
                        GError** error)
{
	GgitBlobOutputStream* patched_stream = NULL;
	GitgRepository* _tmp0_;
	GgitBlobOutputStream* _tmp1_;
	GgitBlobOutputStream* _tmp2_;
	GgitBlobOutputStream* _tmp3_;
	GgitOId* new_id = NULL;
	GgitBlobOutputStream* _tmp4_;
	GgitOId* _tmp5_;
	GgitIndexEntry* new_entry = NULL;
	GitgRepository* _tmp6_;
	const gchar* _tmp7_;
	GgitOId* _tmp8_;
	GgitIndexEntry* _tmp9_;
	GgitIndexEntry* _tmp10_;
	GgitIndexEntry* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	g_return_if_fail (old_stream != NULL);
	g_return_if_fail (new_stream != NULL);
	g_return_if_fail (patch != NULL);
	_tmp0_ = self->priv->d_repository;
	_tmp1_ = ggit_repository_create_blob ((GgitRepository*) _tmp0_);
	patched_stream = _tmp1_;
	_tmp2_ = patched_stream;
	gitg_stage_apply_patch_stream (self, old_stream, new_stream, (GOutputStream*) _tmp2_, patch, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (patched_stream);
		return;
	}
	_tmp3_ = patched_stream;
	g_output_stream_close ((GOutputStream*) _tmp3_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (patched_stream);
		return;
	}
	_tmp4_ = patched_stream;
	_tmp5_ = ggit_blob_output_stream_get_id (_tmp4_, &_inner_error0_);
	new_id = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (patched_stream);
		return;
	}
	_tmp6_ = self->priv->d_repository;
	_tmp7_ = patch->filename;
	_tmp8_ = new_id;
	_tmp9_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp6_, _tmp7_, _tmp8_, &_inner_error0_);
	new_entry = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitOId_free0 (new_id);
		_g_object_unref0 (patched_stream);
		return;
	}
	_tmp10_ = new_entry;
	ggit_index_entry_set_mode (_tmp10_, filemode);
	_tmp11_ = new_entry;
	ggit_index_add (index, _tmp11_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (new_entry);
		__vala_GgitOId_free0 (new_id);
		_g_object_unref0 (patched_stream);
		return;
	}
	ggit_index_write (index, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (new_entry);
		__vala_GgitOId_free0 (new_id);
		_g_object_unref0 (patched_stream);
		return;
	}
	_ggit_index_entry_unref0 (new_entry);
	__vala_GgitOId_free0 (new_id);
	_g_object_unref0 (patched_stream);
}

static void
gitg_stage_apply_patch_stream (GitgStage* self,
                               GInputStream* old_stream,
                               GInputStream* new_stream,
                               GOutputStream* patched_stream,
                               GitgPatchSet* patch,
                               GError** error)
{
	gsize old_ptr = 0UL;
	gsize new_ptr = 0UL;
	GitgPatchSetPatch* _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_stream != NULL);
	g_return_if_fail (new_stream != NULL);
	g_return_if_fail (patched_stream != NULL);
	g_return_if_fail (patch != NULL);
	old_ptr = (gsize) 0;
	new_ptr = (gsize) 0;
	_tmp0_ = patch->patches;
	_tmp0__length1 = patch->patches_length1;
	{
		GitgPatchSetPatch* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp0_;
		p_collection_length1 = _tmp0__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			GitgPatchSetPatch p = {0};
			p = p_collection[p_it];
			{
				GitgPatchSetPatch _tmp1_;
				GitgPatchSetPatch _tmp2_;
				_tmp1_ = p;
				gitg_stage_copy_stream (self, patched_stream, old_stream, &old_ptr, old_ptr, _tmp1_.old_offset - old_ptr, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				_tmp2_ = p;
				if (_tmp2_.type == GITG_PATCH_SET_TYPE_REMOVE) {
					GitgPatchSetPatch _tmp3_;
					GitgPatchSetPatch _tmp4_;
					_tmp3_ = p;
					g_seekable_seek (G_TYPE_CHECK_INSTANCE_CAST (old_stream, g_seekable_get_type (), GSeekable), (gint64) _tmp3_.length, G_SEEK_CUR, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						return;
					}
					_tmp4_ = p;
					old_ptr += _tmp4_.length;
				} else {
					GitgPatchSetPatch _tmp5_;
					GitgPatchSetPatch _tmp6_;
					_tmp5_ = p;
					_tmp6_ = p;
					gitg_stage_copy_stream (self, patched_stream, new_stream, &new_ptr, _tmp5_.new_offset, _tmp6_.length, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						return;
					}
				}
			}
		}
	}
	g_output_stream_splice (patched_stream, old_stream, G_OUTPUT_STREAM_SPLICE_NONE, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
gitg_stage_stage_patch_data_free (gpointer _data)
{
	GitgStageStagePatchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageStagePatchData, _data_);
}

void
gitg_stage_stage_patch (GitgStage* self,
                        GitgPatchSet* patch,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgStageStagePatchData* _data_;
	GitgStage* _tmp0_;
	GitgPatchSet* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (patch != NULL);
	_data_ = g_slice_new0 (GitgStageStagePatchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_stage_patch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _gitg_patch_set_ref0 (patch);
	_gitg_patch_set_unref0 (_data_->patch);
	_data_->patch = _tmp1_;
	gitg_stage_stage_patch_co (_data_);
}

void
gitg_stage_stage_patch_finish (GitgStage* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GitgStageStagePatchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Stage a patch to the index.
 *
 * @param patch the patch to stage.
 *
 * Stage a provided patch to the index. The patch should contain changes
 * of the file in the current working directory to the contents of the
 * index (i.e. as obtained from diff_workdir)
 */
static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		GitgStage* self;
		self = _data45_->self;
		_g_object_unref0 (_data45_->new_stream);
		_g_object_unref0 (_data45_->newf);
		_gitg_patch_set_unref0 (_data45_->patch);
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static void
gitg_stage_stage_patch_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GitgStageStagePatchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_stage_patch_co (_data_);
}

static guchar*
_vala_array_dup24 (guchar* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guchar));
	}
	return NULL;
}

static void
__lambda26_ (Block45Data* _data45_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GgitIndexEntries* entries = NULL;
	GgitIndexEntries* _tmp0_;
	GgitIndexEntry* entry = NULL;
	GgitIndexEntries* _tmp1_;
	GFile* _tmp2_;
	GgitIndexEntry* _tmp3_;
	guchar* old_content = NULL;
	guchar* _tmp4_;
	gint old_content_length1;
	gint _old_content_size_;
	GgitIndexEntry* _tmp5_;
	GMemoryInputStream* old_stream = NULL;
	guchar* _tmp20_;
	gint _tmp20__length1;
	GBytes* _tmp21_;
	GBytes* _tmp22_;
	GMemoryInputStream* _tmp23_;
	GMemoryInputStream* _tmp24_;
	GgitIndexEntry* _tmp25_;
	GMemoryInputStream* _tmp26_;
	GFileInputStream* _tmp27_;
	GFileInputStream* _tmp28_;
	GMemoryInputStream* _tmp29_;
	GError* _inner_error0_ = NULL;
	self = _data45_->self;
	g_return_if_fail (index != NULL);
	_tmp0_ = ggit_index_get_entries (index);
	entries = _tmp0_;
	_tmp1_ = entries;
	_tmp2_ = _data45_->newf;
	_tmp3_ = ggit_index_entries_get_by_path (_tmp1_, _tmp2_, 0);
	entry = _tmp3_;
	_tmp4_ = g_new0 (guchar, 0);
	old_content = _tmp4_;
	old_content_length1 = 0;
	_old_content_size_ = old_content_length1;
	_tmp5_ = entry;
	if (_tmp5_ == NULL) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GFile* _tmp9_;
		_tmp6_ = _data45_->newf;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		g_print ("\npath not in index %s\n", _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = _data45_->newf;
		ggit_index_add_file (index, _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			old_content = (g_free (old_content), NULL);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			return;
		}
		ggit_index_write (index, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			old_content = (g_free (old_content), NULL);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			return;
		}
	} else {
		GgitBlob* old_blob = NULL;
		GitgRepository* _tmp10_;
		GgitIndexEntry* _tmp11_;
		GgitOId* _tmp12_;
		GgitOId* _tmp13_;
		gpointer _tmp14_;
		GgitBlob* _tmp15_;
		GgitBlob* _tmp16_;
		gsize _tmp17_ = 0;
		guint8* _tmp18_;
		guchar* _tmp19_;
		gint _tmp19__length1;
		_tmp10_ = self->priv->d_repository;
		_tmp11_ = entry;
		_tmp12_ = ggit_index_entry_get_id (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gitg_repository_lookup (_tmp10_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp13_, &_inner_error0_);
		_tmp15_ = (GgitBlob*) _tmp14_;
		__vala_GgitOId_free0 (_tmp13_);
		old_blob = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			old_content = (g_free (old_content), NULL);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			return;
		}
		_tmp16_ = old_blob;
		_tmp18_ = ggit_blob_get_raw_content (_tmp16_, &_tmp17_);
		_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup24 (_tmp18_, _tmp17_) : _tmp18_;
		_tmp19__length1 = _tmp17_;
		old_content = (g_free (old_content), NULL);
		old_content = _tmp19_;
		old_content_length1 = _tmp19__length1;
		_old_content_size_ = old_content_length1;
		_g_object_unref0 (old_blob);
	}
	_tmp20_ = old_content;
	_tmp20__length1 = old_content_length1;
	_tmp21_ = g_bytes_new (_tmp20_, _tmp20__length1);
	_tmp22_ = _tmp21_;
	_tmp23_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_bytes_unref0 (_tmp22_);
	old_stream = _tmp24_;
	_tmp25_ = entry;
	_tmp26_ = old_stream;
	_tmp27_ = _data45_->new_stream;
	gitg_stage_apply_patch (self, index, ggit_index_entry_get_mode (_tmp25_), (GInputStream*) _tmp26_, (GInputStream*) _tmp27_, _data45_->patch, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (old_stream);
		old_content = (g_free (old_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp28_ = _data45_->new_stream;
	g_input_stream_close ((GInputStream*) _tmp28_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (old_stream);
		old_content = (g_free (old_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp29_ = old_stream;
	g_input_stream_close ((GInputStream*) _tmp29_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (old_stream);
		old_content = (g_free (old_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_g_object_unref0 (old_stream);
	old_content = (g_free (old_content), NULL);
	_ggit_index_entry_unref0 (entry);
	_ggit_index_entries_unref0 (entries);
}

static void
___lambda26__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda26_ (self, index, error);
}

static gboolean
gitg_stage_stage_patch_co (GitgStageStagePatchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data45_ = g_slice_new0 (Block45Data);
	_data_->_data45_->_ref_count_ = 1;
	_data_->_data45_->self = g_object_ref (_data_->self);
	_gitg_patch_set_unref0 (_data_->_data45_->patch);
	_data_->_data45_->patch = _data_->patch;
	_data_->_data45_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_data45_->patch->filename;
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_data45_->newf = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->_data45_->newf;
	_data_->_state_ = 1;
	g_file_read_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, gitg_stage_stage_patch_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = g_file_read_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_data45_->new_stream = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block45_data_unref (_data_->_data45_);
		_data_->_data45_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	gitg_stage_thread_index (_data_->self, ___lambda26__gitg_stage_with_index_func, _data_->_data45_, gitg_stage_stage_patch_ready, _data_);
	return FALSE;
	_state_2:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block45_data_unref (_data_->_data45_);
		_data_->_data45_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block45_data_unref (_data_->_data45_);
	_data_->_data45_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_unstage_data_free (gpointer _data)
{
	GitgStageUnstageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageUnstageData, _data_);
}

void
gitg_stage_unstage (GitgStage* self,
                    GFile* file,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	GitgStageUnstageData* _data_;
	GitgStage* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GitgStageUnstageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_unstage_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	gitg_stage_unstage_co (_data_);
}

void
gitg_stage_unstage_finish (GitgStage* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	GitgStageUnstageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Unstage a file from the index.
 *
 * @param file the file to unstage.
 *
 * Unstage changes in the specified file from the index. This will record
 * the state of the file in HEAD to the index.
 */
static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		GitgStage* self;
		self = _data46_->self;
		_g_object_unref0 (_data46_->tree);
		_g_object_unref0 (_data46_->file);
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static void
gitg_stage_unstage_ready (GObject* source_object,
                          GAsyncResult* _res_,
                          gpointer _user_data_)
{
	GitgStageUnstageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_unstage_co (_data_);
}

static void
__lambda27_ (Block46Data* _data46_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GFile* wd = NULL;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	GgitTreeEntry* entry = NULL;
	GgitTree* _tmp4_;
	const gchar* _tmp5_;
	GgitTreeEntry* _tmp6_;
	GgitOId* id = NULL;
	GgitTreeEntry* _tmp7_;
	GgitOId* _tmp8_;
	GgitIndexEntry* ientry = NULL;
	GitgRepository* _tmp9_;
	const gchar* _tmp10_;
	GgitOId* _tmp11_;
	GgitIndexEntry* _tmp12_;
	GgitIndexEntry* _tmp13_;
	GgitTreeEntry* _tmp14_;
	GgitIndexEntry* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = _data46_->self;
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->d_repository;
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
	wd = _tmp1_;
	_tmp2_ = wd;
	_tmp3_ = g_file_get_relative_path (_tmp2_, _data46_->file);
	path = _tmp3_;
	_tmp4_ = _data46_->tree;
	_tmp5_ = path;
	_tmp6_ = ggit_tree_get_by_path (_tmp4_, _tmp5_, &_inner_error0_);
	entry = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_tmp7_ = entry;
	_tmp8_ = ggit_tree_entry_get_id (_tmp7_);
	id = _tmp8_;
	_tmp9_ = self->priv->d_repository;
	_tmp10_ = path;
	_tmp11_ = id;
	_tmp12_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp9_, _tmp10_, _tmp11_, &_inner_error0_);
	ientry = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_tmp13_ = ientry;
	_tmp14_ = entry;
	ggit_index_entry_set_mode (_tmp13_, (guint) ggit_tree_entry_get_file_mode (_tmp14_));
	_tmp15_ = ientry;
	ggit_index_add (index, _tmp15_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (ientry);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	ggit_index_write (index, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_ggit_index_entry_unref0 (ientry);
		__vala_GgitOId_free0 (id);
		_ggit_tree_entry_unref0 (entry);
		_g_free0 (path);
		_g_object_unref0 (wd);
		return;
	}
	_ggit_index_entry_unref0 (ientry);
	__vala_GgitOId_free0 (id);
	_ggit_tree_entry_unref0 (entry);
	_g_free0 (path);
	_g_object_unref0 (wd);
}

static void
___lambda27__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda27_ (self, index, error);
}

static gboolean
gitg_stage_unstage_co (GitgStageUnstageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data46_ = g_slice_new0 (Block46Data);
	_data_->_data46_->_ref_count_ = 1;
	_data_->_data46_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data46_->file);
	_data_->_data46_->file = _data_->file;
	_data_->_data46_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_stage_get_head_tree (_data_->self, gitg_stage_unstage_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_data46_->tree = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block46_data_unref (_data_->_data46_);
		_data_->_data46_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	gitg_stage_thread_index (_data_->self, ___lambda27__gitg_stage_with_index_func, _data_->_data46_, gitg_stage_unstage_ready, _data_);
	return FALSE;
	_state_2:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block46_data_unref (_data_->_data46_);
		_data_->_data46_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block46_data_unref (_data_->_data46_);
	_data_->_data46_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_unstage_path_data_free (gpointer _data)
{
	GitgStageUnstagePathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageUnstagePathData, _data_);
}

void
gitg_stage_unstage_path (GitgStage* self,
                         const gchar* path,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgStageUnstagePathData* _data_;
	GitgStage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (GitgStageUnstagePathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_unstage_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	gitg_stage_unstage_path_co (_data_);
}

void
gitg_stage_unstage_path_finish (GitgStage* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GitgStageUnstagePathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Unstage a path from the index.
 *
 * @param path path relative to the working directory.
 *
 * Unstage changes in the specified relative path from the index. This will record
 * the state of the file in HEAD to the index.
 */
static void
gitg_stage_unstage_path_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgStageUnstagePathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_unstage_path_co (_data_);
}

static gboolean
gitg_stage_unstage_path_co (GitgStageUnstagePathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->path);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	gitg_stage_unstage (_data_->self, _data_->_tmp4_, gitg_stage_unstage_path_ready, _data_);
	return FALSE;
	_state_1:
	gitg_stage_unstage_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp2_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_unstage_patch_data_free (gpointer _data)
{
	GitgStageUnstagePatchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageUnstagePatchData, _data_);
}

void
gitg_stage_unstage_patch (GitgStage* self,
                          GitgPatchSet* patch,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	GitgStageUnstagePatchData* _data_;
	GitgStage* _tmp0_;
	GitgPatchSet* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (patch != NULL);
	_data_ = g_slice_new0 (GitgStageUnstagePatchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_unstage_patch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _gitg_patch_set_ref0 (patch);
	_gitg_patch_set_unref0 (_data_->patch);
	_data_->patch = _tmp1_;
	gitg_stage_unstage_patch_co (_data_);
}

void
gitg_stage_unstage_patch_finish (GitgStage* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GitgStageUnstagePatchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
 * Unstage a patch from the index.
 *
 * @param patch the patch to unstage.
 *
 * Unstage a provided patch from the index. The patch should contain changes
 * of the file in the index to the file in HEAD.
 */
static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		GitgStage* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->tree);
		_g_object_unref0 (_data47_->file);
		_gitg_patch_set_unref0 (_data47_->patch);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static void
gitg_stage_unstage_patch_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	GitgStageUnstagePatchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_unstage_patch_co (_data_);
}

static guchar*
_vala_array_dup25 (guchar* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guchar));
	}
	return NULL;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		GitgStage* self;
		self = _data48_->_data47_->self;
		_g_object_unref0 (_data48_->stage);
		block47_data_unref (_data48_->_data47_);
		_data48_->_data47_ = NULL;
		g_slice_free (Block48Data, _data48_);
	}
}

static void
___lambda29_ (Block48Data* _data48_,
              GObject* obj,
              GAsyncResult* res)
{
	Block47Data* _data47_;
	GitgStage* self;
	GError* _inner_error0_ = NULL;
	_data47_ = _data48_->_data47_;
	self = _data47_->self;
	g_return_if_fail (res != NULL);
	{
		GitgStage* _tmp0_;
		_tmp0_ = _data48_->stage;
		gitg_stage_delete_path_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gitg-stage.vala:1054: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda29__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda29_ (self, source_object, res);
	block48_data_unref (self);
}

static void
__lambda28_ (Block47Data* _data47_,
             GgitIndex* index,
             GError** error)
{
	GitgStage* self;
	GgitIndexEntries* entries = NULL;
	GgitIndexEntries* _tmp0_;
	GgitIndexEntry* entry = NULL;
	GgitIndexEntries* _tmp1_;
	GFile* _tmp2_;
	GgitIndexEntry* _tmp3_;
	GgitIndexEntry* _tmp4_;
	guchar* head_content = NULL;
	guchar* _tmp10_;
	gint head_content_length1;
	gint _head_content_size_;
	GgitBlob* index_blob = NULL;
	GitgRepository* _tmp24_;
	GgitIndexEntry* _tmp25_;
	GgitOId* _tmp26_;
	GgitOId* _tmp27_;
	gpointer _tmp28_;
	GgitBlob* _tmp29_;
	guchar* index_content = NULL;
	GgitBlob* _tmp30_;
	gsize _tmp31_ = 0;
	guint8* _tmp32_;
	gint index_content_length1;
	gint _index_content_size_;
	GMemoryInputStream* head_stream = NULL;
	guchar* _tmp33_;
	gint _tmp33__length1;
	GBytes* _tmp34_;
	GBytes* _tmp35_;
	GMemoryInputStream* _tmp36_;
	GMemoryInputStream* _tmp37_;
	GMemoryInputStream* index_stream = NULL;
	guchar* _tmp38_;
	gint _tmp38__length1;
	GBytes* _tmp39_;
	GBytes* _tmp40_;
	GMemoryInputStream* _tmp41_;
	GMemoryInputStream* _tmp42_;
	GitgPatchSet* reversed = NULL;
	GitgPatchSet* _tmp43_;
	GMemoryInputStream* _tmp55_;
	GMemoryInputStream* _tmp56_;
	GError* _inner_error0_ = NULL;
	self = _data47_->self;
	g_return_if_fail (index != NULL);
	_tmp0_ = ggit_index_get_entries (index);
	entries = _tmp0_;
	_tmp1_ = entries;
	_tmp2_ = _data47_->file;
	_tmp3_ = ggit_index_entries_get_by_path (_tmp1_, _tmp2_, 0);
	entry = _tmp3_;
	_tmp4_ = entry;
	if (_tmp4_ == NULL) {
		GFile* _tmp5_;
		GgitIndexEntries* _tmp6_;
		GgitIndexEntries* _tmp7_;
		GFile* _tmp8_;
		GgitIndexEntry* _tmp9_;
		_tmp5_ = _data47_->file;
		ggit_index_add_file (index, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			return;
		}
		ggit_index_write (index, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_ggit_index_entry_unref0 (entry);
			_ggit_index_entries_unref0 (entries);
			return;
		}
		_tmp6_ = ggit_index_get_entries (index);
		_ggit_index_entries_unref0 (entries);
		entries = _tmp6_;
		_tmp7_ = entries;
		_tmp8_ = _data47_->file;
		_tmp9_ = ggit_index_entries_get_by_path (_tmp7_, _tmp8_, 0);
		_ggit_index_entry_unref0 (entry);
		entry = _tmp9_;
	}
	_tmp10_ = g_new0 (guchar, 0);
	head_content = _tmp10_;
	head_content_length1 = 0;
	_head_content_size_ = head_content_length1;
	{
		GgitTreeEntry* head_entry = NULL;
		GgitTree* _tmp11_;
		const gchar* _tmp12_;
		GgitTreeEntry* _tmp13_;
		GgitBlob* head_blob = NULL;
		GitgRepository* _tmp14_;
		GgitTreeEntry* _tmp15_;
		GgitOId* _tmp16_;
		GgitOId* _tmp17_;
		gpointer _tmp18_;
		GgitBlob* _tmp19_;
		GgitBlob* _tmp20_;
		gsize _tmp21_ = 0;
		guint8* _tmp22_;
		guchar* _tmp23_;
		gint _tmp23__length1;
		_tmp11_ = _data47_->tree;
		_tmp12_ = _data47_->patch->filename;
		_tmp13_ = ggit_tree_get_by_path (_tmp11_, _tmp12_, &_inner_error0_);
		head_entry = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = self->priv->d_repository;
		_tmp15_ = head_entry;
		_tmp16_ = ggit_tree_entry_get_id (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = gitg_repository_lookup (_tmp14_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp17_, &_inner_error0_);
		_tmp19_ = (GgitBlob*) _tmp18_;
		__vala_GgitOId_free0 (_tmp17_);
		head_blob = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_ggit_tree_entry_unref0 (head_entry);
			goto __catch0_g_error;
		}
		_tmp20_ = head_blob;
		_tmp22_ = ggit_blob_get_raw_content (_tmp20_, &_tmp21_);
		_tmp23_ = (_tmp22_ != NULL) ? _vala_array_dup25 (_tmp22_, _tmp21_) : _tmp22_;
		_tmp23__length1 = _tmp21_;
		head_content = (g_free (head_content), NULL);
		head_content = _tmp23_;
		head_content_length1 = _tmp23__length1;
		_head_content_size_ = head_content_length1;
		_g_object_unref0 (head_blob);
		_ggit_tree_entry_unref0 (head_entry);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		head_content = (g_free (head_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp24_ = self->priv->d_repository;
	_tmp25_ = entry;
	_tmp26_ = ggit_index_entry_get_id (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = gitg_repository_lookup (_tmp24_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp27_, &_inner_error0_);
	_tmp29_ = (GgitBlob*) _tmp28_;
	__vala_GgitOId_free0 (_tmp27_);
	index_blob = _tmp29_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		head_content = (g_free (head_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp30_ = index_blob;
	_tmp32_ = ggit_blob_get_raw_content (_tmp30_, &_tmp31_);
	index_content = _tmp32_;
	index_content_length1 = _tmp31_;
	_index_content_size_ = index_content_length1;
	_tmp33_ = head_content;
	_tmp33__length1 = head_content_length1;
	_tmp34_ = g_bytes_new (_tmp33_, _tmp33__length1);
	_tmp35_ = _tmp34_;
	_tmp36_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp35_);
	_tmp37_ = _tmp36_;
	_g_bytes_unref0 (_tmp35_);
	head_stream = _tmp37_;
	_tmp38_ = index_content;
	_tmp38__length1 = index_content_length1;
	_tmp39_ = g_bytes_new (_tmp38_, _tmp38__length1);
	_tmp40_ = _tmp39_;
	_tmp41_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp40_);
	_tmp42_ = _tmp41_;
	_g_bytes_unref0 (_tmp40_);
	index_stream = _tmp42_;
	_tmp43_ = gitg_patch_set_reversed (_data47_->patch);
	reversed = _tmp43_;
	{
		GgitIndexEntry* _tmp44_;
		GMemoryInputStream* _tmp45_;
		GMemoryInputStream* _tmp46_;
		GitgPatchSet* _tmp47_;
		_tmp44_ = entry;
		_tmp45_ = index_stream;
		_tmp46_ = head_stream;
		_tmp47_ = reversed;
		gitg_stage_apply_patch (self, index, ggit_index_entry_get_mode (_tmp44_), (GInputStream*) _tmp45_, (GInputStream*) _tmp46_, _tmp47_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		Block48Data* _data48_;
		GitgRepository* _tmp48_;
		GitgStage* _tmp49_;
		GitgStage* _tmp50_;
		GitgStage* _tmp51_;
		GFile* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		g_clear_error (&_inner_error0_);
		_data48_ = g_slice_new0 (Block48Data);
		_data48_->_ref_count_ = 1;
		_data48_->_data47_ = block47_data_ref (_data47_);
		_tmp48_ = self->priv->d_repository;
		_tmp49_ = gitg_repository_get_stage (_tmp48_);
		_tmp50_ = _tmp49_;
		_data48_->stage = _tmp50_;
		_tmp51_ = _data48_->stage;
		_tmp52_ = _data47_->file;
		_tmp53_ = g_file_get_path (_tmp52_);
		_tmp54_ = _tmp53_;
		gitg_stage_delete_path (_tmp51_, _tmp54_, ____lambda29__gasync_ready_callback, block48_data_ref (_data48_));
		_g_free0 (_tmp54_);
		block48_data_unref (_data48_);
		_data48_ = NULL;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (head_stream);
		_g_object_unref0 (index_blob);
		head_content = (g_free (head_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp55_ = head_stream;
	g_input_stream_close ((GInputStream*) _tmp55_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (head_stream);
		_g_object_unref0 (index_blob);
		head_content = (g_free (head_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_tmp56_ = index_stream;
	g_input_stream_close ((GInputStream*) _tmp56_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_gitg_patch_set_unref0 (reversed);
		_g_object_unref0 (index_stream);
		_g_object_unref0 (head_stream);
		_g_object_unref0 (index_blob);
		head_content = (g_free (head_content), NULL);
		_ggit_index_entry_unref0 (entry);
		_ggit_index_entries_unref0 (entries);
		return;
	}
	_gitg_patch_set_unref0 (reversed);
	_g_object_unref0 (index_stream);
	_g_object_unref0 (head_stream);
	_g_object_unref0 (index_blob);
	head_content = (g_free (head_content), NULL);
	_ggit_index_entry_unref0 (entry);
	_ggit_index_entries_unref0 (entries);
}

static void
___lambda28__gitg_stage_with_index_func (GgitIndex* index,
                                         gpointer self,
                                         GError** error)
{
	__lambda28_ (self, index, error);
}

static gboolean
gitg_stage_unstage_patch_co (GitgStageUnstagePatchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data47_ = g_slice_new0 (Block47Data);
	_data_->_data47_->_ref_count_ = 1;
	_data_->_data47_->self = g_object_ref (_data_->self);
	_gitg_patch_set_unref0 (_data_->_data47_->patch);
	_data_->_data47_->patch = _data_->patch;
	_data_->_data47_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->d_repository;
	_data_->_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_data47_->patch->filename;
	_data_->_tmp4_ = g_file_resolve_relative_path (_data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_data47_->file = _data_->_tmp5_;
	_data_->_state_ = 1;
	gitg_stage_get_head_tree (_data_->self, gitg_stage_unstage_patch_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_data47_->tree = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block47_data_unref (_data_->_data47_);
		_data_->_data47_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	gitg_stage_thread_index (_data_->self, ___lambda28__gitg_stage_with_index_func, _data_->_data47_, gitg_stage_unstage_patch_ready, _data_);
	return FALSE;
	_state_2:
	gitg_stage_thread_index_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block47_data_unref (_data_->_data47_);
		_data_->_data47_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block47_data_unref (_data_->_data47_);
	_data_->_data47_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_diff_index_all_data_free (gpointer _data)
{
	GitgStageDiffIndexAllData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->defopts);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageDiffIndexAllData, _data_);
}

void
gitg_stage_diff_index_all (GitgStage* self,
                           GitgStageStatusItem** files,
                           gint files_length1,
                           GgitDiffOptions* defopts,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	GitgStageDiffIndexAllData* _data_;
	GitgStage* _tmp0_;
	GgitDiffOptions* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgStageDiffIndexAllData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_diff_index_all_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->files = files;
	_data_->files_length1 = files_length1;
	_tmp1_ = _g_object_ref0 (defopts);
	_g_object_unref0 (_data_->defopts);
	_data_->defopts = _tmp1_;
	gitg_stage_diff_index_all_co (_data_);
}

GgitDiff*
gitg_stage_diff_index_all_finish (GitgStage* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	GgitDiff* result;
	GitgStageDiffIndexAllData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
gitg_stage_diff_index_all_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	GitgStageDiffIndexAllData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_diff_index_all_co (_data_);
}

static gboolean
gitg_stage_diff_index_all_co (GitgStageDiffIndexAllData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ggit_diff_options_new ();
	_data_->opts = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->opts;
	ggit_diff_options_set_flags (_data_->_tmp1_, (GGIT_DIFF_INCLUDE_UNTRACKED | GGIT_DIFF_DISABLE_PATHSPEC_MATCH) | GGIT_DIFF_RECURSE_UNTRACKED_DIRS);
	if (_data_->files != NULL) {
		_data_->_tmp2_ = g_new0 (gchar*, _data_->files_length1 + 1);
		_data_->pspec = _data_->_tmp2_;
		_data_->pspec_length1 = _data_->files_length1;
		_data_->_pspec_size_ = _data_->pspec_length1;
		{
			_data_->i = 0;
			{
				_data_->_tmp3_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp3_) {
						_data_->_tmp4_ = _data_->i;
						_data_->i = _data_->_tmp4_ + 1;
					}
					_data_->_tmp3_ = FALSE;
					if (!(_data_->i < _data_->files_length1)) {
						break;
					}
					_data_->_tmp5_ = _data_->pspec;
					_data_->_tmp5__length1 = _data_->pspec_length1;
					_data_->_tmp6_ = _data_->files[_data_->i];
					_data_->_tmp7_ = gitg_stage_status_item_get_path (_data_->_tmp6_);
					_data_->_tmp8_ = _data_->_tmp7_;
					_g_free0 (_data_->_tmp5_[_data_->i]);
					_data_->_tmp5_[_data_->i] = _data_->_tmp8_;
				}
			}
		}
		_data_->_tmp9_ = _data_->opts;
		_data_->_tmp10_ = _data_->pspec;
		_data_->_tmp10__length1 = _data_->pspec_length1;
		ggit_diff_options_set_pathspec (_data_->_tmp9_, _data_->_tmp10_);
		_data_->pspec = (_vala_array_free (_data_->pspec, _data_->pspec_length1, (GDestroyNotify) g_free), NULL);
	}
	if (_data_->defopts != NULL) {
		_data_->_tmp11_ = _data_->opts;
		_data_->_tmp12_ = _data_->opts;
		_data_->_tmp13_ = ggit_diff_options_get_flags (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = ggit_diff_options_get_flags (_data_->defopts);
		_data_->_tmp16_ = _data_->_tmp15_;
		ggit_diff_options_set_flags (_data_->_tmp12_, _data_->_tmp14_ | _data_->_tmp16_);
		_data_->_tmp17_ = _data_->opts;
		_data_->_tmp18_ = ggit_diff_options_get_n_context_lines (_data_->defopts);
		_data_->_tmp19_ = _data_->_tmp18_;
		ggit_diff_options_set_n_context_lines (_data_->_tmp17_, _data_->_tmp19_);
		_data_->_tmp20_ = _data_->opts;
		_data_->_tmp21_ = ggit_diff_options_get_n_interhunk_lines (_data_->defopts);
		_data_->_tmp22_ = _data_->_tmp21_;
		ggit_diff_options_set_n_interhunk_lines (_data_->_tmp20_, _data_->_tmp22_);
		_data_->_tmp23_ = _data_->opts;
		_data_->_tmp24_ = ggit_diff_options_get_old_prefix (_data_->defopts);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->_tmp25_;
		ggit_diff_options_set_old_prefix (_data_->_tmp23_, _data_->_tmp26_);
		_g_free0 (_data_->_tmp26_);
		_data_->_tmp27_ = _data_->opts;
		_data_->_tmp28_ = ggit_diff_options_get_new_prefix (_data_->defopts);
		_data_->_tmp29_ = _data_->_tmp28_;
		ggit_diff_options_set_new_prefix (_data_->_tmp27_, _data_->_tmp29_);
	}
	_data_->tree = NULL;
	_data_->_tmp31_ = _data_->self->priv->d_repository;
	_data_->_tmp30_ = ggit_repository_is_empty ((GgitRepository*) _data_->_tmp31_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->tree);
		_g_object_unref0 (_data_->opts);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_tmp30_) {
		_data_->_state_ = 1;
		gitg_stage_get_head_tree (_data_->self, gitg_stage_diff_index_all_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp33_ = gitg_stage_get_head_tree_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp32_ = _data_->_tmp33_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->tree);
			_g_object_unref0 (_data_->opts);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp34_ = _data_->_tmp32_;
		_data_->_tmp32_ = NULL;
		_g_object_unref0 (_data_->tree);
		_data_->tree = _data_->_tmp34_;
		_g_object_unref0 (_data_->_tmp32_);
	}
	_data_->_tmp36_ = _data_->self->priv->d_repository;
	_data_->_tmp37_ = ggit_repository_get_index ((GgitRepository*) _data_->_tmp36_, &_data_->_inner_error0_);
	_data_->_tmp35_ = _data_->_tmp37_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->tree);
		_g_object_unref0 (_data_->opts);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = _data_->self->priv->d_repository;
	_data_->_tmp40_ = _data_->tree;
	_data_->_tmp41_ = _data_->opts;
	_data_->_tmp42_ = ggit_diff_new_tree_to_index ((GgitRepository*) _data_->_tmp39_, _data_->_tmp40_, _data_->_tmp35_, _data_->_tmp41_, &_data_->_inner_error0_);
	_data_->_tmp38_ = _data_->_tmp42_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp35_);
		_g_object_unref0 (_data_->tree);
		_g_object_unref0 (_data_->opts);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp43_ = _data_->_tmp38_;
	_data_->_tmp38_ = NULL;
	_data_->result = _data_->_tmp43_;
	_g_object_unref0 (_data_->_tmp38_);
	_g_object_unref0 (_data_->_tmp35_);
	_g_object_unref0 (_data_->tree);
	_g_object_unref0 (_data_->opts);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_diff_index_data_free (gpointer _data)
{
	GitgStageDiffIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	_g_object_unref0 (_data_->defopts);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageDiffIndexData, _data_);
}

void
gitg_stage_diff_index (GitgStage* self,
                       GitgStageStatusItem* f,
                       GgitDiffOptions* defopts,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	GitgStageDiffIndexData* _data_;
	GitgStage* _tmp0_;
	GitgStageStatusItem* _tmp1_;
	GgitDiffOptions* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	_data_ = g_slice_new0 (GitgStageDiffIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_diff_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (f);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp1_;
	_tmp2_ = _g_object_ref0 (defopts);
	_g_object_unref0 (_data_->defopts);
	_data_->defopts = _tmp2_;
	gitg_stage_diff_index_co (_data_);
}

GgitDiff*
gitg_stage_diff_index_finish (GitgStage* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	GgitDiff* result;
	GitgStageDiffIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
gitg_stage_diff_index_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	GitgStageDiffIndexData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_diff_index_co (_data_);
}

static gboolean
gitg_stage_diff_index_co (GitgStageDiffIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _g_object_ref0 (_data_->f);
	_data_->_tmp2_ = g_new0 (GitgStageStatusItem*, 1 + 1);
	_data_->_tmp2_[0] = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = 1;
	_data_->_state_ = 1;
	gitg_stage_diff_index_all (_data_->self, _data_->_tmp3_, (gint) 1, _data_->defopts, gitg_stage_diff_index_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = gitg_stage_diff_index_all_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->_tmp0_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_diff_workdir_all_data_free (gpointer _data)
{
	GitgStageDiffWorkdirAllData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->defopts);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageDiffWorkdirAllData, _data_);
}

void
gitg_stage_diff_workdir_all (GitgStage* self,
                             GitgStageStatusItem** files,
                             gint files_length1,
                             GgitDiffOptions* defopts,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GitgStageDiffWorkdirAllData* _data_;
	GitgStage* _tmp0_;
	GgitDiffOptions* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgStageDiffWorkdirAllData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_diff_workdir_all_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->files = files;
	_data_->files_length1 = files_length1;
	_tmp1_ = _g_object_ref0 (defopts);
	_g_object_unref0 (_data_->defopts);
	_data_->defopts = _tmp1_;
	gitg_stage_diff_workdir_all_co (_data_);
}

GgitDiff*
gitg_stage_diff_workdir_all_finish (GitgStage* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GgitDiff* result;
	GitgStageDiffWorkdirAllData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
gitg_stage_diff_workdir_all_co (GitgStageDiffWorkdirAllData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ggit_diff_options_new ();
	_data_->opts = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->opts;
	ggit_diff_options_set_flags (_data_->_tmp1_, ((GGIT_DIFF_INCLUDE_UNTRACKED | GGIT_DIFF_DISABLE_PATHSPEC_MATCH) | GGIT_DIFF_RECURSE_UNTRACKED_DIRS) | GGIT_DIFF_SHOW_UNTRACKED_CONTENT);
	if (_data_->files != NULL) {
		_data_->_tmp2_ = g_new0 (gchar*, _data_->files_length1 + 1);
		_data_->pspec = _data_->_tmp2_;
		_data_->pspec_length1 = _data_->files_length1;
		_data_->_pspec_size_ = _data_->pspec_length1;
		{
			_data_->i = 0;
			{
				_data_->_tmp3_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp3_) {
						_data_->_tmp4_ = _data_->i;
						_data_->i = _data_->_tmp4_ + 1;
					}
					_data_->_tmp3_ = FALSE;
					if (!(_data_->i < _data_->files_length1)) {
						break;
					}
					_data_->_tmp5_ = _data_->pspec;
					_data_->_tmp5__length1 = _data_->pspec_length1;
					_data_->_tmp6_ = _data_->files[_data_->i];
					_data_->_tmp7_ = gitg_stage_status_item_get_path (_data_->_tmp6_);
					_data_->_tmp8_ = _data_->_tmp7_;
					_g_free0 (_data_->_tmp5_[_data_->i]);
					_data_->_tmp5_[_data_->i] = _data_->_tmp8_;
				}
			}
		}
		_data_->_tmp9_ = _data_->opts;
		_data_->_tmp10_ = _data_->pspec;
		_data_->_tmp10__length1 = _data_->pspec_length1;
		ggit_diff_options_set_pathspec (_data_->_tmp9_, _data_->_tmp10_);
		_data_->pspec = (_vala_array_free (_data_->pspec, _data_->pspec_length1, (GDestroyNotify) g_free), NULL);
	}
	if (_data_->defopts != NULL) {
		_data_->_tmp11_ = _data_->opts;
		_data_->_tmp12_ = _data_->opts;
		_data_->_tmp13_ = ggit_diff_options_get_flags (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = ggit_diff_options_get_flags (_data_->defopts);
		_data_->_tmp16_ = _data_->_tmp15_;
		ggit_diff_options_set_flags (_data_->_tmp12_, _data_->_tmp14_ | _data_->_tmp16_);
		_data_->_tmp17_ = _data_->opts;
		_data_->_tmp18_ = ggit_diff_options_get_n_context_lines (_data_->defopts);
		_data_->_tmp19_ = _data_->_tmp18_;
		ggit_diff_options_set_n_context_lines (_data_->_tmp17_, _data_->_tmp19_);
		_data_->_tmp20_ = _data_->opts;
		_data_->_tmp21_ = ggit_diff_options_get_n_interhunk_lines (_data_->defopts);
		_data_->_tmp22_ = _data_->_tmp21_;
		ggit_diff_options_set_n_interhunk_lines (_data_->_tmp20_, _data_->_tmp22_);
		_data_->_tmp23_ = _data_->opts;
		_data_->_tmp24_ = ggit_diff_options_get_old_prefix (_data_->defopts);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->_tmp25_;
		ggit_diff_options_set_old_prefix (_data_->_tmp23_, _data_->_tmp26_);
		_g_free0 (_data_->_tmp26_);
		_data_->_tmp27_ = _data_->opts;
		_data_->_tmp28_ = ggit_diff_options_get_new_prefix (_data_->defopts);
		_data_->_tmp29_ = _data_->_tmp28_;
		ggit_diff_options_set_new_prefix (_data_->_tmp27_, _data_->_tmp29_);
	}
	_data_->_tmp31_ = _data_->self->priv->d_repository;
	_data_->_tmp32_ = ggit_repository_get_index ((GgitRepository*) _data_->_tmp31_, &_data_->_inner_error0_);
	_data_->_tmp30_ = _data_->_tmp32_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->opts);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->self->priv->d_repository;
	_data_->_tmp35_ = _data_->opts;
	_data_->_tmp36_ = ggit_diff_new_index_to_workdir ((GgitRepository*) _data_->_tmp34_, _data_->_tmp30_, _data_->_tmp35_, &_data_->_inner_error0_);
	_data_->_tmp33_ = _data_->_tmp36_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp30_);
		_g_object_unref0 (_data_->opts);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp37_ = _data_->_tmp33_;
	_data_->_tmp33_ = NULL;
	_data_->result = _data_->_tmp37_;
	_g_object_unref0 (_data_->_tmp33_);
	_g_object_unref0 (_data_->_tmp30_);
	_g_object_unref0 (_data_->opts);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_diff_workdir_data_free (gpointer _data)
{
	GitgStageDiffWorkdirData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	_g_object_unref0 (_data_->defopts);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgStageDiffWorkdirData, _data_);
}

void
gitg_stage_diff_workdir (GitgStage* self,
                         GitgStageStatusItem* f,
                         GgitDiffOptions* defopts,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgStageDiffWorkdirData* _data_;
	GitgStage* _tmp0_;
	GitgStageStatusItem* _tmp1_;
	GgitDiffOptions* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	_data_ = g_slice_new0 (GitgStageDiffWorkdirData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_stage_diff_workdir_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (f);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp1_;
	_tmp2_ = _g_object_ref0 (defopts);
	_g_object_unref0 (_data_->defopts);
	_data_->defopts = _tmp2_;
	gitg_stage_diff_workdir_co (_data_);
}

GgitDiff*
gitg_stage_diff_workdir_finish (GitgStage* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GgitDiff* result;
	GitgStageDiffWorkdirData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
gitg_stage_diff_workdir_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgStageDiffWorkdirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_stage_diff_workdir_co (_data_);
}

static gboolean
gitg_stage_diff_workdir_co (GitgStageDiffWorkdirData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _g_object_ref0 (_data_->f);
	_data_->_tmp2_ = g_new0 (GitgStageStatusItem*, 1 + 1);
	_data_->_tmp2_[0] = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = 1;
	_data_->_state_ = 1;
	gitg_stage_diff_workdir_all (_data_->self, _data_->_tmp3_, (gint) 1, _data_->defopts, gitg_stage_diff_workdir_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = gitg_stage_diff_workdir_all_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->_tmp0_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_stage_class_init (GitgStageClass * klass,
                       gpointer klass_data)
{
	gitg_stage_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgStage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gitg_stage_finalize;
}

static void
gitg_stage_instance_init (GitgStage * self,
                          gpointer klass)
{
	self->priv = gitg_stage_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_d_index_mutex);
}

static void
gitg_stage_finalize (GObject * obj)
{
	GitgStage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_STAGE, GitgStage);
	g_rec_mutex_clear (&self->priv->__lock_d_index_mutex);
	_vala_clear_GMutex (&self->priv->d_index_mutex);
	_g_object_unref0 (self->priv->d_head_tree);
	G_OBJECT_CLASS (gitg_stage_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_stage_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgStageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_stage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgStage), 0, (GInstanceInitFunc) gitg_stage_instance_init, NULL };
	GType gitg_stage_type_id;
	gitg_stage_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgStage", &g_define_type_info, 0);
	GitgStage_private_offset = g_type_add_instance_private (gitg_stage_type_id, sizeof (GitgStagePrivate));
	return gitg_stage_type_id;
}

GType
gitg_stage_get_type (void)
{
	static gsize gitg_stage_type_id__once = 0;
	if (g_once_init_enter (&gitg_stage_type_id__once)) {
		GType gitg_stage_type_id;
		gitg_stage_type_id = gitg_stage_get_type_once ();
		g_once_init_leave (&gitg_stage_type_id__once, gitg_stage_type_id);
	}
	return gitg_stage_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

