/* gitg-gpg-utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-gpg-utils.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2022 - Alberto Fanjul
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gpgme.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _gpgme_data_release0(var) ((var == NULL) ? NULL : (var = (gpgme_data_release (var), NULL)))
#define _gpgme_release0(var) ((var == NULL) ? NULL : (var = (gpgme_release (var), NULL)))
#define _gpgme_key_unref0(var) ((var == NULL) ? NULL : (var = (gpgme_key_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _GitgParamSpecGPGUtils GitgParamSpecGPGUtils;

struct _GitgParamSpecGPGUtils {
	GParamSpec parent_instance;
};

static gpointer gitg_gpg_utils_parent_class = NULL;

static gchar* gitg_gpg_utils_get_string_from_data (struct gpgme_data* data);
static gssize* _ssize_t_dup (gssize* self);
static void gitg_gpg_utils_finalize (GitgGPGUtils * obj);
static GType gitg_gpg_utils_get_type_once (void);

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
gitg_gpg_utils_sign_commit_object (const gchar* commit_content,
                                   const gchar* signing_key,
                                   GError** error)
{
	struct gpgme_data* plain_data = NULL;
	struct gpgme_data* signed_data = NULL;
	struct gpgme_data* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	struct gpgme_data* _tmp4_ = NULL;
	struct gpgme_context* context = NULL;
	struct gpgme_context* _tmp5_ = NULL;
	struct gpgme_context* _tmp6_;
	struct _gpgme_key* key = NULL;
	struct gpgme_context* _tmp7_;
	struct _gpgme_key* _tmp8_ = NULL;
	struct _gpgme_key* _tmp9_;
	struct gpgme_context* _tmp12_;
	struct gpgme_data* _tmp13_;
	struct gpgme_data* _tmp14_;
	struct gpgme_data* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (commit_content != NULL, NULL);
	g_return_val_if_fail (signing_key != NULL, NULL);
	gpgme_check_version (NULL);
	gpgme_data_new (&_tmp0_);
	_gpgme_data_release0 (signed_data);
	signed_data = _tmp0_;
	_tmp1_ = string_get_data (commit_content, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	gpgme_data_new_from_mem (&_tmp4_, _tmp3_, (gint) _tmp3__length1, FALSE);
	_gpgme_data_release0 (plain_data);
	plain_data = _tmp4_;
	gpgme_new (&_tmp5_);
	_gpgme_release0 (context);
	context = _tmp5_;
	_tmp6_ = context;
	gpgme_set_armor (_tmp6_, TRUE);
	_tmp7_ = context;
	gpgme_get_key (_tmp7_, signing_key, &_tmp8_, TRUE);
	_gpgme_key_unref0 (key);
	key = _tmp8_;
	_tmp9_ = key;
	if (_tmp9_ != NULL) {
		struct gpgme_context* _tmp10_;
		struct _gpgme_key* _tmp11_;
		_tmp10_ = context;
		_tmp11_ = key;
		gpgme_signers_add (_tmp10_, _tmp11_);
	}
	_tmp12_ = context;
	_tmp13_ = plain_data;
	_tmp14_ = signed_data;
	gpgme_op_sign (_tmp12_, _tmp13_, _tmp14_, GPGME_SIG_MODE_DETACH);
	_tmp15_ = signed_data;
	_tmp16_ = gitg_gpg_utils_get_string_from_data (_tmp15_);
	result = _tmp16_;
	_gpgme_key_unref0 (key);
	_gpgme_release0 (context);
	_gpgme_data_release0 (signed_data);
	_gpgme_data_release0 (plain_data);
	return result;
}

static gssize*
_ssize_t_dup (gssize* self)
{
	gssize* dup;
	dup = g_new0 (gssize, 1);
	memcpy (dup, self, sizeof (gssize));
	return dup;
}

static gpointer
__ssize_t_dup0 (gpointer self)
{
	return self ? _ssize_t_dup (self) : NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
gitg_gpg_utils_get_string_from_data (struct gpgme_data* data)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	gssize* len = NULL;
	gchar* res = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (data != NULL, NULL);
	gpgme_data_seek (data, (glong) 0, 0);
	_tmp0_ = g_new0 (guint8, 256);
	buf = _tmp0_;
	buf_length1 = 256;
	_buf_size_ = buf_length1;
	len = NULL;
	_tmp1_ = g_strdup ("");
	res = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			guint8* _tmp4_;
			gint _tmp4__length1;
			gssize _tmp5_;
			gssize* _tmp6_;
			gssize* _tmp7_;
			if (!_tmp2_) {
				gssize* _tmp3_;
				_tmp3_ = len;
				if (!((*_tmp3_) > ((gssize) 0))) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = buf;
			_tmp4__length1 = buf_length1;
			_tmp5_ = gpgme_data_read (data, _tmp4_, (gint) _tmp4__length1);
			_tmp6_ = __ssize_t_dup0 (&_tmp5_);
			_g_free0 (len);
			len = _tmp6_;
			_tmp7_ = len;
			if ((*_tmp7_) > ((gssize) 0)) {
				gchar* part = NULL;
				guint8* _tmp8_;
				gint _tmp8__length1;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gssize* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp8_ = buf;
				_tmp8__length1 = buf_length1;
				_tmp9_ = g_strdup ((const gchar*) _tmp8_);
				part = _tmp9_;
				_tmp10_ = part;
				_tmp11_ = len;
				_tmp12_ = string_substring (_tmp10_, (glong) 0, (glong) (*_tmp11_));
				_g_free0 (part);
				part = _tmp12_;
				_tmp13_ = res;
				_tmp14_ = part;
				_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
				_g_free0 (res);
				res = _tmp15_;
				_g_free0 (part);
			}
		}
	}
	result = res;
	_g_free0 (len);
	buf = (g_free (buf), NULL);
	return result;
}

GitgGPGUtils*
gitg_gpg_utils_construct (GType object_type)
{
	GitgGPGUtils* self = NULL;
	self = (GitgGPGUtils*) g_type_create_instance (object_type);
	return self;
}

GitgGPGUtils*
gitg_gpg_utils_new (void)
{
	return gitg_gpg_utils_construct (GITG_TYPE_GPG_UTILS);
}

static void
gitg_value_gpg_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_gpg_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_gpg_utils_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_gpg_utils_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_gpg_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_gpg_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_gpg_utils_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgGPGUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_gpg_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_gpg_utils_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	GitgGPGUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_gpg_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_gpg_utils (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	GitgParamSpecGPGUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_GPG_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_gpg_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_GPG_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_gpg_utils (GValue* value,
                          gpointer v_object)
{
	GitgGPGUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_GPG_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_GPG_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_gpg_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_gpg_utils_unref (old);
	}
}

void
gitg_value_take_gpg_utils (GValue* value,
                           gpointer v_object)
{
	GitgGPGUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_GPG_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_GPG_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_gpg_utils_unref (old);
	}
}

static void
gitg_gpg_utils_class_init (GitgGPGUtilsClass * klass,
                           gpointer klass_data)
{
	gitg_gpg_utils_parent_class = g_type_class_peek_parent (klass);
	((GitgGPGUtilsClass *) klass)->finalize = gitg_gpg_utils_finalize;
}

static void
gitg_gpg_utils_instance_init (GitgGPGUtils * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_gpg_utils_finalize (GitgGPGUtils * obj)
{
	GitgGPGUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_GPG_UTILS, GitgGPGUtils);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gitg_gpg_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_gpg_utils_init, gitg_value_gpg_utils_free_value, gitg_value_gpg_utils_copy_value, gitg_value_gpg_utils_peek_pointer, "p", gitg_value_gpg_utils_collect_value, "p", gitg_value_gpg_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgGPGUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_gpg_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgGPGUtils), 0, (GInstanceInitFunc) gitg_gpg_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_gpg_utils_type_id;
	gitg_gpg_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgGPGUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_gpg_utils_type_id;
}

GType
gitg_gpg_utils_get_type (void)
{
	static gsize gitg_gpg_utils_type_id__once = 0;
	if (g_once_init_enter (&gitg_gpg_utils_type_id__once)) {
		GType gitg_gpg_utils_type_id;
		gitg_gpg_utils_type_id = gitg_gpg_utils_get_type_once ();
		g_once_init_leave (&gitg_gpg_utils_type_id__once, gitg_gpg_utils_type_id);
	}
	return gitg_gpg_utils_type_id__once;
}

gpointer
gitg_gpg_utils_ref (gpointer instance)
{
	GitgGPGUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_gpg_utils_unref (gpointer instance)
{
	GitgGPGUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_GPG_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

