/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 22 "parser.yy"


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <string>
#include <sstream>

#include "acceptedvalues.h"

#include "argsdef.h"

#include "gengetopt.h"
#include "errorcodes.h"
#include "ggos.h"
#include "yyerror.h"

extern int gengetopt_count_line;
extern char * gengetopt_input_filename;

static int gengetopt_package_given = 0;
static int gengetopt_version_given = 0;
static int gengetopt_purpose_given = 0;
static int gengetopt_versiontext_given = 0;
static int gengetopt_usage_given = 0;
static int gengetopt_description_given = 0;

/// the last option parsed
static gengetopt_option *current_option = 0;

extern int yylex (void) ;

//#define YYERROR_VERBOSE 1

using namespace std;

void check_result(int o, gengetopt_option *opt)
{
  if (o)
    {
        ostringstream err;

    switch (o)
    {
    case NOT_ENOUGH_MEMORY:
        yyerror (opt, "not enough memory");
    	break;
    case REQ_LONG_OPTION:
        err << "long option redefined \'" << opt->long_opt << "\'";
        yyerror (opt, err.str().c_str());
		break;
    case REQ_SHORT_OPTION:
        err << "short option redefined \'" << opt->short_opt << "\'";
        yyerror (opt, err.str().c_str());
        break;
    case FOUND_BUG:
        yyerror (opt, "bug found!!");
        break;
    case GROUP_UNDEFINED:
        yyerror (opt, "group undefined");
        break;
    case MODE_UNDEFINED:
        yyerror (opt, "mode undefined");
        break;
    case INVALID_DEFAULT_VALUE:
        yyerror (opt, "invalid default value");
        break;
    case NOT_REQUESTED_TYPE:
        yyerror (opt, "type specification not requested");
        break;
    case NOT_VALID_SPECIFICATION:
      yyerror (opt, "invalid specification for this kind of option");
      break;
    case SPECIFY_FLAG_STAT:
      yyerror (opt, "you must specify the default flag status");
      break;
    case NOT_GROUP_OPTION:
      yyerror (opt, "group specification for a non group option");
      break;
    case NOT_MODE_OPTION:
      yyerror (opt, "mode specification for an option not belonging to a mode");
      break;
    case SPECIFY_GROUP:
      yyerror (opt, "missing group specification");
      break;
    case SPECIFY_MODE:
      yyerror (opt, "missing mode specification");
      break;
    case INVALID_NUMERIC_VALUE:
        yyerror (opt, "invalid numeric value");
        break;
    case INVALID_ENUM_TYPE_USE:
    	yyerror (opt, "enum type can only be specified for options with values");
        break;
    case HELP_REDEFINED:
    	yyerror (opt, "if you want to redefine --help, please use option --no-help");
        break;
    case VERSION_REDEFINED:
    	yyerror (opt, "if you want to redefine --version, please use option --no-version");
        break;
    }
  }
}

/* the number of allowed occurrences of a multiple option */
struct multiple_size
{
    /* these strings are allocated dynamically and NOT
      automatically freed upon destruction */
    char *min;
    char *max;

    /* if no limit is specified then initialized to 0.
       if the same size is specified for min and max, it means that an exact
       number of occurrences is required*/
    multiple_size(const char *m = "0", const char *M = "0") :
        min(strdup(m)), max(strdup(M))
    {}
};

#define check_error if (o) YYERROR;


#line 199 "parser.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_PACKAGE = 3,                /* "package"  */
  YYSYMBOL_TOK_VERSION = 4,                /* "version"  */
  YYSYMBOL_TOK_OPTION = 5,                 /* "option"  */
  YYSYMBOL_TOK_DEFGROUP = 6,               /* "defgroup"  */
  YYSYMBOL_TOK_GROUPOPTION = 7,            /* "groupoption"  */
  YYSYMBOL_TOK_DEFMODE = 8,                /* "defmode"  */
  YYSYMBOL_TOK_MODEOPTION = 9,             /* "modeoption"  */
  YYSYMBOL_TOK_YES = 10,                   /* "yes"  */
  YYSYMBOL_TOK_NO = 11,                    /* "no"  */
  YYSYMBOL_TOK_ON = 12,                    /* "on"  */
  YYSYMBOL_TOK_OFF = 13,                   /* "off"  */
  YYSYMBOL_TOK_FLAG = 14,                  /* "flag"  */
  YYSYMBOL_TOK_PURPOSE = 15,               /* "purpose"  */
  YYSYMBOL_TOK_DESCRIPTION = 16,           /* "description"  */
  YYSYMBOL_TOK_USAGE = 17,                 /* "usage"  */
  YYSYMBOL_TOK_DEFAULT = 18,               /* "default"  */
  YYSYMBOL_TOK_GROUP = 19,                 /* "group"  */
  YYSYMBOL_TOK_GROUPDESC = 20,             /* "groupdesc"  */
  YYSYMBOL_TOK_MODE = 21,                  /* "mode"  */
  YYSYMBOL_TOK_MODEDESC = 22,              /* "modedesc"  */
  YYSYMBOL_TOK_MULTIPLE = 23,              /* "multiple"  */
  YYSYMBOL_TOK_ARGOPTIONAL = 24,           /* "argoptional"  */
  YYSYMBOL_TOK_TYPESTR = 25,               /* "typestr"  */
  YYSYMBOL_TOK_SECTION = 26,               /* "section"  */
  YYSYMBOL_TOK_DETAILS = 27,               /* "details"  */
  YYSYMBOL_TOK_SECTIONDESC = 28,           /* "sectiondesc"  */
  YYSYMBOL_TOK_TEXT = 29,                  /* "text"  */
  YYSYMBOL_TOK_VERSIONTEXT = 30,           /* "versiontext"  */
  YYSYMBOL_TOK_ARGS = 31,                  /* "args"  */
  YYSYMBOL_TOK_VALUES = 32,                /* "values"  */
  YYSYMBOL_TOK_HIDDEN = 33,                /* "hidden"  */
  YYSYMBOL_TOK_DEPENDON = 34,              /* "dependon"  */
  YYSYMBOL_TOK_STRING = 35,                /* TOK_STRING  */
  YYSYMBOL_TOK_CHAR = 36,                  /* TOK_CHAR  */
  YYSYMBOL_TOK_ARGTYPE = 37,               /* TOK_ARGTYPE  */
  YYSYMBOL_TOK_SIZE = 38,                  /* TOK_SIZE  */
  YYSYMBOL_39_ = 39,                       /* '='  */
  YYSYMBOL_40_ = 40,                       /* ','  */
  YYSYMBOL_41_ = 41,                       /* '('  */
  YYSYMBOL_42_ = 42,                       /* ')'  */
  YYSYMBOL_43_ = 43,                       /* '-'  */
  YYSYMBOL_YYACCEPT = 44,                  /* $accept  */
  YYSYMBOL_input = 45,                     /* input  */
  YYSYMBOL_statement = 46,                 /* statement  */
  YYSYMBOL_package = 47,                   /* package  */
  YYSYMBOL_version = 48,                   /* version  */
  YYSYMBOL_purpose = 49,                   /* purpose  */
  YYSYMBOL_description = 50,               /* description  */
  YYSYMBOL_usage = 51,                     /* usage  */
  YYSYMBOL_sectiondef = 52,                /* sectiondef  */
  YYSYMBOL_text = 53,                      /* text  */
  YYSYMBOL_versiontext = 54,               /* versiontext  */
  YYSYMBOL_args = 55,                      /* args  */
  YYSYMBOL_groupdef = 56,                  /* groupdef  */
  YYSYMBOL_modedef = 57,                   /* modedef  */
  YYSYMBOL_option = 58,                    /* option  */
  YYSYMBOL_groupoption = 59,               /* groupoption  */
  YYSYMBOL_modeoption = 60,                /* modeoption  */
  YYSYMBOL_quoted_string = 61,             /* quoted_string  */
  YYSYMBOL_option_parts = 62,              /* option_parts  */
  YYSYMBOL_req_onoff = 63,                 /* req_onoff  */
  YYSYMBOL_optional_yesno = 64,            /* optional_yesno  */
  YYSYMBOL_opt_yesno = 65,                 /* opt_yesno  */
  YYSYMBOL_opt_groupdesc = 66,             /* opt_groupdesc  */
  YYSYMBOL_opt_modedesc = 67,              /* opt_modedesc  */
  YYSYMBOL_opt_sectiondesc = 68,           /* opt_sectiondesc  */
  YYSYMBOL_listofvalues = 69,              /* listofvalues  */
  YYSYMBOL_acceptedvalue = 70,             /* acceptedvalue  */
  YYSYMBOL_multiple_size = 71              /* multiple_size  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  46
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   91

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  44
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  28
/* YYNRULES -- Number of rules.  */
#define YYNRULES  68
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  119

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   293


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      41,    42,     2,     2,    40,    43,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    39,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   213,   213,   214,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   237,   257,
     277,   297,   317,   338,   345,   362,   382,   389,   400,   411,
     431,   450,   472,   475,   481,   486,   491,   496,   501,   506,
     511,   516,   521,   526,   534,   539,   544,   549,   553,   554,
     558,   559,   560,   564,   565,   569,   570,   574,   575,   579,
     580,   584,   585,   589,   593,   594,   595,   596,   597
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"package\"",
  "\"version\"", "\"option\"", "\"defgroup\"", "\"groupoption\"",
  "\"defmode\"", "\"modeoption\"", "\"yes\"", "\"no\"", "\"on\"",
  "\"off\"", "\"flag\"", "\"purpose\"", "\"description\"", "\"usage\"",
  "\"default\"", "\"group\"", "\"groupdesc\"", "\"mode\"", "\"modedesc\"",
  "\"multiple\"", "\"argoptional\"", "\"typestr\"", "\"section\"",
  "\"details\"", "\"sectiondesc\"", "\"text\"", "\"versiontext\"",
  "\"args\"", "\"values\"", "\"hidden\"", "\"dependon\"", "TOK_STRING",
  "TOK_CHAR", "TOK_ARGTYPE", "TOK_SIZE", "'='", "','", "'('", "')'", "'-'",
  "$accept", "input", "statement", "package", "version", "purpose",
  "description", "usage", "sectiondef", "text", "versiontext", "args",
  "groupdef", "modedef", "option", "groupoption", "modeoption",
  "quoted_string", "option_parts", "req_onoff", "optional_yesno",
  "opt_yesno", "opt_groupdesc", "opt_modedesc", "opt_sectiondesc",
  "listofvalues", "acceptedvalue", "multiple_size", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-42)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
       2,   -13,    -8,    -6,    -5,    -1,     0,     1,     5,     5,
       5,     5,     5,     5,     6,    26,     2,   -42,   -42,   -42,
     -42,   -42,   -42,   -42,   -42,   -42,   -42,   -42,   -42,   -42,
     -42,   -42,   -42,     7,    17,     8,    16,    15,   -42,   -42,
     -42,   -42,    24,   -42,   -42,   -42,   -42,   -42,     5,    14,
       3,     5,    19,   -42,     5,    23,   -42,   -42,    21,   -42,
     -42,   -42,   -42,    29,   -42,    30,    36,   -42,    36,   -42,
      36,   -42,   -42,   -42,   -42,   -42,   -42,    27,    28,    32,
      31,   -42,    35,    37,    38,   -42,    39,   -42,   -42,   -42,
      40,    44,    45,   -23,   -42,    46,     5,    47,    48,   -42,
     -42,   -42,   -18,    50,   -42,   -42,   -42,    49,   -42,   -42,
     -42,   -26,    42,    47,    43,   -42,   -42,   -42,   -42
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     2,     4,     5,     7,
       8,     9,    10,    12,    13,     6,    15,    17,    11,    14,
      16,    18,    19,     0,    55,     0,    57,     0,    32,    20,
      21,    22,    59,    24,    25,    26,     1,     3,     0,     0,
      50,     0,     0,    28,     0,     0,    23,    47,     0,    51,
      52,    27,    47,     0,    47,     0,    29,    56,    30,    58,
      31,    60,    53,    54,    48,    49,    44,     0,     0,     0,
      64,    42,     0,     0,     0,    45,     0,    34,    46,    33,
       0,     0,     0,     0,    43,     0,     0,     0,     0,    38,
      39,    40,     0,     0,    35,    36,    63,    37,    61,    41,
      65,     0,     0,     0,     0,    66,    67,    62,    68
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -42,    70,   -42,   -42,   -42,   -42,   -42,   -42,   -42,   -42,
     -42,   -42,   -42,   -42,   -42,   -42,   -42,    -9,   -41,   -42,
     -42,   -42,   -42,   -42,   -42,   -42,   -22,   -42
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    39,    66,    88,
      61,    89,    50,    53,    56,   107,   108,    94
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      40,    41,    42,    43,    44,     1,     2,     3,     4,     5,
       6,     7,   114,    59,    60,   102,   115,     8,     9,    10,
     103,    68,    31,    70,   110,   111,    46,    32,    11,    33,
      34,    12,    13,    14,    35,    36,    37,    49,    52,    57,
      38,    45,    62,    48,    51,    64,    72,    73,    74,    75,
      76,    54,    55,    58,    77,    78,    67,    79,    63,    80,
      81,    82,    65,    83,    69,    71,    90,    91,    84,    85,
      86,    92,    93,    87,    95,    99,    96,    97,    98,   100,
     101,   104,   106,   109,   116,   118,    47,   105,   112,   113,
       0,   117
};

static const yytype_int8 yycheck[] =
{
       9,    10,    11,    12,    13,     3,     4,     5,     6,     7,
       8,     9,    38,    10,    11,    38,    42,    15,    16,    17,
      43,    62,    35,    64,    42,    43,     0,    35,    26,    35,
      35,    29,    30,    31,    35,    35,    35,    20,    22,    48,
      35,    35,    51,    36,    36,    54,    10,    11,    12,    13,
      14,    36,    28,    39,    18,    19,    35,    21,    39,    23,
      24,    25,    39,    27,    35,    35,    39,    39,    32,    33,
      34,    39,    41,    37,    39,    35,    39,    39,    39,    35,
      35,    35,    35,    35,    42,    42,    16,    96,    38,    40,
      -1,   113
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     4,     5,     6,     7,     8,     9,    15,    16,
      17,    26,    29,    30,    31,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    35,    35,    35,    35,    35,    35,    35,    35,    61,
      61,    61,    61,    61,    61,    35,     0,    45,    36,    20,
      66,    36,    22,    67,    36,    28,    68,    61,    39,    10,
      11,    64,    61,    39,    61,    39,    62,    35,    62,    35,
      62,    35,    10,    11,    12,    13,    14,    18,    19,    21,
      23,    24,    25,    27,    32,    33,    34,    37,    63,    65,
      39,    39,    39,    41,    71,    39,    39,    39,    39,    35,
      35,    35,    38,    43,    35,    61,    35,    69,    70,    35,
      42,    43,    38,    40,    38,    42,    42,    70,    42
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    44,    45,    45,    46,    46,    46,    46,    46,    46,
      46,    46,    46,    46,    46,    46,    46,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    62,    62,    62,    62,    62,    62,
      62,    62,    62,    62,    62,    62,    62,    62,    63,    63,
      64,    64,    64,    65,    65,    66,    66,    67,    67,    68,
      68,    69,    69,    70,    71,    71,    71,    71,    71
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     3,     2,     2,     2,     4,     3,     5,
       5,     5,     1,     2,     2,     4,     4,     4,     4,     4,
       4,     4,     2,     3,     2,     2,     2,     0,     1,     1,
       0,     1,     1,     1,     1,     0,     3,     0,     3,     0,
       3,     1,     3,     1,     0,     3,     4,     4,     5
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Location data for the lookahead symbol.  */
YYLTYPE yylloc
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 18: /* package: "package" TOK_STRING  */
#line 238 "parser.yy"
            {
	      if (gengetopt_package_given)
		{
		  yyerror ("package redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_package_given = 1;
		  if (gengetopt_define_package ((yyvsp[0].str)))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
#line 1464 "parser.cc"
    break;

  case 19: /* version: "version" TOK_STRING  */
#line 258 "parser.yy"
            {
	      if (gengetopt_version_given)
		{
		  yyerror ("version redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_version_given = 1;
		  if (gengetopt_define_version ((yyvsp[0].str)))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
#line 1485 "parser.cc"
    break;

  case 20: /* purpose: "purpose" quoted_string  */
#line 278 "parser.yy"
            {
	      if (gengetopt_purpose_given)
		{
		  yyerror ("purpose redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_purpose_given = 1;
		  if (gengetopt_define_purpose ((yyvsp[0].str)))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
#line 1506 "parser.cc"
    break;

  case 21: /* description: "description" quoted_string  */
#line 298 "parser.yy"
            {
	      if (gengetopt_description_given)
		{
		  yyerror ("description redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_description_given = 1;
		  if (gengetopt_define_description ((yyvsp[0].str)))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
#line 1527 "parser.cc"
    break;

  case 22: /* usage: "usage" quoted_string  */
#line 318 "parser.yy"
  {
      if (gengetopt_usage_given)
      {
	  yyerror ("usage redefined");
	  YYERROR;
      }
      else
      {
	  gengetopt_usage_given = 1;
	  if (gengetopt_define_usage ((yyvsp[0].str)))
          {
	      yyerror ("not enough memory");
	      YYERROR;
          }
      }
  }
#line 1548 "parser.cc"
    break;

  case 23: /* sectiondef: "section" quoted_string opt_sectiondesc  */
#line 339 "parser.yy"
              {
                gengetopt_set_section ((yyvsp[-1].str), (yyvsp[0].str));
              }
#line 1556 "parser.cc"
    break;

  case 24: /* text: "text" quoted_string  */
#line 346 "parser.yy"
            {
            	if (current_option) {
            		std::string current_option_text;
            		if (current_option->text_after) {
            			current_option_text = std::string(current_option->text_after) + (yyvsp[0].str);
            			current_option->text_after = strdup(current_option_text.c_str()); 
            		} else {
	            		current_option->text_after = strdup((yyvsp[0].str));
	            	}
            	} else {
					gengetopt_set_text((yyvsp[0].str));
  				}
            }
#line 1574 "parser.cc"
    break;

  case 25: /* versiontext: "versiontext" quoted_string  */
#line 363 "parser.yy"
            {
	    	if (gengetopt_versiontext_given)
	        {
		    yyerror ("versiontext redefined");
		    YYERROR;
		}
		else
		{
		    gengetopt_versiontext_given = 1;
		    if (gengetopt_define_versiontext ((yyvsp[0].str)))
		    {
			yyerror ("not enough memory");
			YYERROR;
		    }
		}
	    }
#line 1595 "parser.cc"
    break;

  case 26: /* args: "args" TOK_STRING  */
#line 383 "parser.yy"
            {
  gengetopt_set_args((yyvsp[0].str));
            }
#line 1603 "parser.cc"
    break;

  case 27: /* groupdef: "defgroup" TOK_STRING opt_groupdesc optional_yesno  */
#line 390 "parser.yy"
            {
              if (gengetopt_add_group ((yyvsp[-2].str), (yyvsp[-1].str), (yyvsp[0].boolean)))
                {
		  	yyerror ("group redefined");
		  	YYERROR;
		  }
	    }
#line 1615 "parser.cc"
    break;

  case 28: /* modedef: "defmode" TOK_STRING opt_modedesc  */
#line 401 "parser.yy"
            {
              if (gengetopt_add_mode ((yyvsp[-1].str), (yyvsp[0].str)))
                {
		  	yyerror ("mode redefined");
		  	YYERROR;
		  }
	    }
#line 1627 "parser.cc"
    break;

  case 29: /* option: "option" TOK_STRING TOK_CHAR quoted_string option_parts  */
#line 413 "parser.yy"
            {
          (yyvsp[0].gengetopt_option)->filename = gengetopt_input_filename;
          (yyvsp[0].gengetopt_option)->linenum = (yylsp[-4]).first_line;
	      (yyvsp[0].gengetopt_option)->long_opt = strdup((yyvsp[-3].str));
	      if ((yyvsp[-2].chr) != '-')
	      	(yyvsp[0].gengetopt_option)->short_opt = (yyvsp[-2].chr);
	      (yyvsp[0].gengetopt_option)->desc = strdup((yyvsp[-1].str));
	      int o = gengetopt_check_option ((yyvsp[0].gengetopt_option), false);
	      check_result(o, (yyvsp[0].gengetopt_option));
          check_error;
	      o = gengetopt_add_option ((yyvsp[0].gengetopt_option));
	      check_result(o, (yyvsp[0].gengetopt_option));
	      check_error;
	      current_option = (yyvsp[0].gengetopt_option);
	    }
#line 1647 "parser.cc"
    break;

  case 30: /* groupoption: "groupoption" TOK_STRING TOK_CHAR quoted_string option_parts  */
#line 433 "parser.yy"
            {
          (yyvsp[0].gengetopt_option)->filename = gengetopt_input_filename;
          (yyvsp[0].gengetopt_option)->linenum = (yylsp[-4]).first_line;
	      (yyvsp[0].gengetopt_option)->long_opt = strdup((yyvsp[-3].str));
          if ((yyvsp[-2].chr) != '-')
            (yyvsp[0].gengetopt_option)->short_opt = (yyvsp[-2].chr);
          (yyvsp[0].gengetopt_option)->desc = strdup((yyvsp[-1].str));
          int o = gengetopt_check_option ((yyvsp[0].gengetopt_option), true);
          check_result(o, (yyvsp[0].gengetopt_option));
          check_error;
          o = gengetopt_add_option ((yyvsp[0].gengetopt_option));
          check_result(o, (yyvsp[0].gengetopt_option));
          check_error;
	    }
#line 1666 "parser.cc"
    break;

  case 31: /* modeoption: "modeoption" TOK_STRING TOK_CHAR quoted_string option_parts  */
#line 452 "parser.yy"
            {
          (yyvsp[0].gengetopt_option)->filename = gengetopt_input_filename;
          (yyvsp[0].gengetopt_option)->linenum = (yylsp[-4]).first_line;
	      (yyvsp[0].gengetopt_option)->long_opt = strdup((yyvsp[-3].str));
          if ((yyvsp[-2].chr) != '-')
            (yyvsp[0].gengetopt_option)->short_opt = (yyvsp[-2].chr);
          (yyvsp[0].gengetopt_option)->desc = strdup((yyvsp[-1].str));
          int o = gengetopt_check_option ((yyvsp[0].gengetopt_option), false, true);
          check_result(o, (yyvsp[0].gengetopt_option));
          check_error;
          o = gengetopt_add_option ((yyvsp[0].gengetopt_option));
          check_result(o, (yyvsp[0].gengetopt_option));
          check_error;
	    }
#line 1685 "parser.cc"
    break;

  case 33: /* option_parts: option_parts opt_yesno  */
#line 476 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-1].gengetopt_option);
			  	(yyval.gengetopt_option)->required = (yyvsp[0].boolean);
			  	(yyval.gengetopt_option)->required_set = true;
			  }
#line 1695 "parser.cc"
    break;

  case 34: /* option_parts: option_parts TOK_ARGTYPE  */
#line 482 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-1].gengetopt_option);
			  	(yyval.gengetopt_option)->type = (yyvsp[0].argtype);
			  }
#line 1704 "parser.cc"
    break;

  case 35: /* option_parts: option_parts "typestr" '=' TOK_STRING  */
#line 487 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
			  	(yyval.gengetopt_option)->type_str = strdup((yyvsp[0].str));
			  }
#line 1713 "parser.cc"
    break;

  case 36: /* option_parts: option_parts "details" '=' quoted_string  */
#line 492 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
			  	(yyval.gengetopt_option)->details = strdup((yyvsp[0].str));
			  }
#line 1722 "parser.cc"
    break;

  case 37: /* option_parts: option_parts "values" '=' listofvalues  */
#line 497 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
			  	(yyval.gengetopt_option)->acceptedvalues = (yyvsp[0].ValueList);
			  }
#line 1731 "parser.cc"
    break;

  case 38: /* option_parts: option_parts "default" '=' TOK_STRING  */
#line 502 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
			  	(yyval.gengetopt_option)->default_string = strdup((yyvsp[0].str));
			  }
#line 1740 "parser.cc"
    break;

  case 39: /* option_parts: option_parts "group" '=' TOK_STRING  */
#line 507 "parser.yy"
              {
                (yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
                (yyval.gengetopt_option)->group_value = strdup((yyvsp[0].str));
              }
#line 1749 "parser.cc"
    break;

  case 40: /* option_parts: option_parts "mode" '=' TOK_STRING  */
#line 512 "parser.yy"
              {
                (yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
                (yyval.gengetopt_option)->mode_value = strdup((yyvsp[0].str));
              }
#line 1758 "parser.cc"
    break;

  case 41: /* option_parts: option_parts "dependon" '=' TOK_STRING  */
#line 517 "parser.yy"
              {
                (yyval.gengetopt_option) = (yyvsp[-3].gengetopt_option);
                (yyval.gengetopt_option)->dependon = strdup((yyvsp[0].str));
              }
#line 1767 "parser.cc"
    break;

  case 42: /* option_parts: option_parts "argoptional"  */
#line 522 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-1].gengetopt_option);
			  	(yyval.gengetopt_option)->arg_is_optional = true;
			  }
#line 1776 "parser.cc"
    break;

  case 43: /* option_parts: option_parts "multiple" multiple_size  */
#line 527 "parser.yy"
                          {
			  	(yyval.gengetopt_option) = (yyvsp[-2].gengetopt_option);
			  	(yyval.gengetopt_option)->multiple = true;
                (yyval.gengetopt_option)->multiple_min = (yyvsp[0].multiple_size)->min;
                (yyval.gengetopt_option)->multiple_max = (yyvsp[0].multiple_size)->max;
                delete (yyvsp[0].multiple_size);
			  }
#line 1788 "parser.cc"
    break;

  case 44: /* option_parts: option_parts "flag"  */
#line 535 "parser.yy"
        {
          (yyval.gengetopt_option) = (yyvsp[-1].gengetopt_option);
          (yyval.gengetopt_option)->type = ARG_FLAG;
        }
#line 1797 "parser.cc"
    break;

  case 45: /* option_parts: option_parts "hidden"  */
#line 540 "parser.yy"
        {
          (yyval.gengetopt_option) = (yyvsp[-1].gengetopt_option);
          (yyval.gengetopt_option)->hidden = true;
        }
#line 1806 "parser.cc"
    break;

  case 46: /* option_parts: option_parts req_onoff  */
#line 545 "parser.yy"
        {
          (yyval.gengetopt_option) = (yyvsp[-1].gengetopt_option);
          (yyval.gengetopt_option)->flagstat = (yyvsp[0].boolean);
        }
#line 1815 "parser.cc"
    break;

  case 47: /* option_parts: %empty  */
#line 549 "parser.yy"
        { (yyval.gengetopt_option) = new gengetopt_option; }
#line 1821 "parser.cc"
    break;

  case 48: /* req_onoff: "on"  */
#line 553 "parser.yy"
                        { (yyval.boolean) = 1; }
#line 1827 "parser.cc"
    break;

  case 49: /* req_onoff: "off"  */
#line 554 "parser.yy"
                        { (yyval.boolean) = 0; }
#line 1833 "parser.cc"
    break;

  case 50: /* optional_yesno: %empty  */
#line 558 "parser.yy"
                        { (yyval.boolean) = 0; }
#line 1839 "parser.cc"
    break;

  case 51: /* optional_yesno: "yes"  */
#line 559 "parser.yy"
                        { (yyval.boolean) = 1; }
#line 1845 "parser.cc"
    break;

  case 52: /* optional_yesno: "no"  */
#line 560 "parser.yy"
                        { (yyval.boolean) = 0; }
#line 1851 "parser.cc"
    break;

  case 53: /* opt_yesno: "yes"  */
#line 564 "parser.yy"
                { (yyval.boolean) = 1; }
#line 1857 "parser.cc"
    break;

  case 54: /* opt_yesno: "no"  */
#line 565 "parser.yy"
                { (yyval.boolean) = 0; }
#line 1863 "parser.cc"
    break;

  case 55: /* opt_groupdesc: %empty  */
#line 569 "parser.yy"
                                        { (yyval.str) = 0; }
#line 1869 "parser.cc"
    break;

  case 56: /* opt_groupdesc: "groupdesc" '=' TOK_STRING  */
#line 570 "parser.yy"
                                        { (yyval.str) = (yyvsp[0].str); }
#line 1875 "parser.cc"
    break;

  case 57: /* opt_modedesc: %empty  */
#line 574 "parser.yy"
                                        { (yyval.str) = 0; }
#line 1881 "parser.cc"
    break;

  case 58: /* opt_modedesc: "modedesc" '=' TOK_STRING  */
#line 575 "parser.yy"
                                        { (yyval.str) = (yyvsp[0].str); }
#line 1887 "parser.cc"
    break;

  case 59: /* opt_sectiondesc: %empty  */
#line 579 "parser.yy"
                                        { (yyval.str) = 0; }
#line 1893 "parser.cc"
    break;

  case 60: /* opt_sectiondesc: "sectiondesc" '=' TOK_STRING  */
#line 580 "parser.yy"
                                                { (yyval.str) = (yyvsp[0].str); }
#line 1899 "parser.cc"
    break;

  case 61: /* listofvalues: acceptedvalue  */
#line 584 "parser.yy"
                        { (yyval.ValueList) = new AcceptedValues; (yyval.ValueList)->insert((yyvsp[0].str)); }
#line 1905 "parser.cc"
    break;

  case 62: /* listofvalues: listofvalues ',' acceptedvalue  */
#line 585 "parser.yy"
                                         { (yyvsp[-2].ValueList)->insert((yyvsp[0].str)); (yyval.ValueList) = (yyvsp[-2].ValueList); }
#line 1911 "parser.cc"
    break;

  case 63: /* acceptedvalue: TOK_STRING  */
#line 589 "parser.yy"
                     { (yyval.str) = (yyvsp[0].str); }
#line 1917 "parser.cc"
    break;

  case 64: /* multiple_size: %empty  */
#line 593 "parser.yy"
      { (yyval.multiple_size) = new multiple_size; }
#line 1923 "parser.cc"
    break;

  case 65: /* multiple_size: '(' TOK_SIZE ')'  */
#line 594 "parser.yy"
                       { (yyval.multiple_size) = new multiple_size((yyvsp[-1].str), (yyvsp[-1].str)); }
#line 1929 "parser.cc"
    break;

  case 66: /* multiple_size: '(' TOK_SIZE '-' ')'  */
#line 595 "parser.yy"
                           { (yyval.multiple_size) = new multiple_size((yyvsp[-2].str), "0"); free((yyvsp[-2].str)); }
#line 1935 "parser.cc"
    break;

  case 67: /* multiple_size: '(' '-' TOK_SIZE ')'  */
#line 596 "parser.yy"
                            { (yyval.multiple_size) = new multiple_size("0", (yyvsp[-1].str)); free((yyvsp[-1].str)); }
#line 1941 "parser.cc"
    break;

  case 68: /* multiple_size: '(' TOK_SIZE '-' TOK_SIZE ')'  */
#line 597 "parser.yy"
                                     { (yyval.multiple_size) = new multiple_size((yyvsp[-3].str), (yyvsp[-1].str)); free((yyvsp[-3].str)); free((yyvsp[-1].str)); }
#line 1947 "parser.cc"
    break;


#line 1951 "parser.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 600 "parser.yy"

