/* Application.c generated by valac 0.56.18, the Vala compiler
 * generated from Application.vala, do not modify */

/* Application.vala */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include "font-manager.h"
#include <stdio.h>
#include <pango/pango.h>
#include "config.h"

#define DISPLAY_NAME _ ("Font Manager")
#define COMMENT _ ("Simple font management for GTK+ desktop environments")
#define COPYRIGHT "Copyright © 2009-2025 Jerry Casiano"
#define LICENSE _ ("\n" \
"    This program is free software: you can redistribute it and/or modi" \
"fy\n" \
"    it under the terms of the GNU General Public License as published " \
"by\n" \
"    the Free Software Foundation, either version 3 of the License, or\n" \
"    (at your option) any later version.\n" \
"\n" \
"    This program is distributed in the hope that it will be useful,\n" \
"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"    GNU General Public License for more details.\n" \
"\n" \
"    You should have received a copy of the GNU General Public License\n" \
"    along with this program.\n" \
"\n" \
"    If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.\n")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_APPLICATION (font_manager_application_get_type ())
#define FONT_MANAGER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication))
#define FONT_MANAGER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))
#define FONT_MANAGER_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))

typedef struct _FontManagerApplication FontManagerApplication;
typedef struct _FontManagerApplicationClass FontManagerApplicationClass;
typedef struct _FontManagerApplicationPrivate FontManagerApplicationPrivate;

#define FONT_MANAGER_TYPE_MAIN_WINDOW (font_manager_main_window_get_type ())
#define FONT_MANAGER_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindow))
#define FONT_MANAGER_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindowClass))
#define FONT_MANAGER_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_MAIN_WINDOW))
#define FONT_MANAGER_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_MAIN_WINDOW))
#define FONT_MANAGER_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindowClass))

typedef struct _FontManagerMainWindow FontManagerMainWindow;
typedef struct _FontManagerMainWindowClass FontManagerMainWindowClass;

#define FONT_MANAGER_TYPE_DATABASE_PROXY (font_manager_database_proxy_get_type ())
#define FONT_MANAGER_DATABASE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_DATABASE_PROXY, FontManagerDatabaseProxy))
#define FONT_MANAGER_DATABASE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_DATABASE_PROXY, FontManagerDatabaseProxyClass))
#define FONT_MANAGER_IS_DATABASE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_DATABASE_PROXY))
#define FONT_MANAGER_IS_DATABASE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_DATABASE_PROXY))
#define FONT_MANAGER_DATABASE_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_DATABASE_PROXY, FontManagerDatabaseProxyClass))

typedef struct _FontManagerDatabaseProxy FontManagerDatabaseProxy;
typedef struct _FontManagerDatabaseProxyClass FontManagerDatabaseProxyClass;

#define FONT_MANAGER_TYPE_SEARCH_PROVIDER (font_manager_search_provider_get_type ())
#define FONT_MANAGER_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProvider))
#define FONT_MANAGER_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProviderClass))
#define FONT_MANAGER_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_SEARCH_PROVIDER))
#define FONT_MANAGER_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_SEARCH_PROVIDER))
#define FONT_MANAGER_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProviderClass))

typedef struct _FontManagerSearchProvider FontManagerSearchProvider;
typedef struct _FontManagerSearchProviderClass FontManagerSearchProviderClass;
enum  {
	FONT_MANAGER_APPLICATION_0_PROPERTY,
	FONT_MANAGER_APPLICATION_UPDATE_IN_PROGRESS_PROPERTY,
	FONT_MANAGER_APPLICATION_SETTINGS_PROPERTY,
	FONT_MANAGER_APPLICATION_AVAILABLE_FONTS_PROPERTY,
	FONT_MANAGER_APPLICATION_MAIN_WINDOW_PROPERTY,
	FONT_MANAGER_APPLICATION_DB_PROPERTY,
	FONT_MANAGER_APPLICATION_DISABLED_FAMILIES_PROPERTY,
	FONT_MANAGER_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* font_manager_application_properties[FONT_MANAGER_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FONT_MANAGER_LIBRARY_TYPE_INSTALLER (font_manager_library_installer_get_type ())
#define FONT_MANAGER_LIBRARY_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstaller))
#define FONT_MANAGER_LIBRARY_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstallerClass))
#define FONT_MANAGER_LIBRARY_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER))
#define FONT_MANAGER_LIBRARY_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_LIBRARY_TYPE_INSTALLER))
#define FONT_MANAGER_LIBRARY_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstallerClass))

typedef struct _FontManagerLibraryInstaller FontManagerLibraryInstaller;
typedef struct _FontManagerLibraryInstallerClass FontManagerLibraryInstallerClass;
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef enum  {
	FONT_MANAGER_MODE_MANAGE,
	FONT_MANAGER_MODE_BROWSE,
	FONT_MANAGER_MODE_COMPARE,
	FONT_MANAGER_MODE_GOOGLE_FONTS,
	FONT_MANAGER_MODE_N_MODES
} FontManagerMode;

#define FONT_MANAGER_TYPE_MODE (font_manager_mode_get_type ())

#define FONT_MANAGER_TYPE_BROWSE_PANE (font_manager_browse_pane_get_type ())
#define FONT_MANAGER_BROWSE_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePane))
#define FONT_MANAGER_BROWSE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePaneClass))
#define FONT_MANAGER_IS_BROWSE_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_PANE))
#define FONT_MANAGER_IS_BROWSE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_PANE))
#define FONT_MANAGER_BROWSE_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePaneClass))

typedef struct _FontManagerBrowsePane FontManagerBrowsePane;
typedef struct _FontManagerBrowsePaneClass FontManagerBrowsePaneClass;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL (font_manager_font_list_filter_model_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModel))
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModelClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL))
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModelClass))

typedef struct _FontManagerFontListFilterModel FontManagerFontListFilterModel;
typedef struct _FontManagerFontListFilterModelClass FontManagerFontListFilterModelClass;

#define FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL (font_manager_category_list_model_get_type ())
#define FONT_MANAGER_CATEGORY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModel))
#define FONT_MANAGER_CATEGORY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModelClass))
#define FONT_MANAGER_IS_CATEGORY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL))
#define FONT_MANAGER_IS_CATEGORY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL))
#define FONT_MANAGER_CATEGORY_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModelClass))

typedef struct _FontManagerCategoryListModel FontManagerCategoryListModel;
typedef struct _FontManagerCategoryListModelClass FontManagerCategoryListModelClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerApplication {
	GtkApplication parent_instance;
	FontManagerApplicationPrivate * priv;
};

struct _FontManagerApplicationClass {
	GtkApplicationClass parent_class;
};

struct _FontManagerApplicationPrivate {
	gboolean _update_in_progress;
	GSettings* _settings;
	JsonArray* _available_fonts;
	FontManagerMainWindow* _main_window;
	FontManagerDatabaseProxy* _db;
	FontManagerReject* _disabled_families;
	guint dbus_id;
	FontManagerSearchProvider* gs_search_provider;
};

static gint FontManagerApplication_private_offset;
static gpointer font_manager_application_parent_class = NULL;

VALA_EXTERN GType font_manager_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerApplication, g_object_unref)
VALA_EXTERN guint font_manager_application_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN FontManagerApplication* font_manager_get_default_application (void);
VALA_EXTERN GType font_manager_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerMainWindow, g_object_unref)
VALA_EXTERN GType font_manager_database_proxy_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerDatabaseProxy, g_object_unref)
VALA_EXTERN GType font_manager_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerSearchProvider, g_object_unref)
VALA_EXTERN guint font_manager_search_provider_register_object (void* object,
                                                    GDBusConnection* connection,
                                                    const gchar* path,
                                                    GError** error);
VALA_EXTERN FontManagerDatabaseProxy* font_manager_database_proxy_new (void);
VALA_EXTERN FontManagerDatabaseProxy* font_manager_database_proxy_construct (GType object_type);
VALA_EXTERN FontManagerApplication* font_manager_application_new (const gchar* app_id,
                                                      GApplicationFlags app_flags);
VALA_EXTERN FontManagerApplication* font_manager_application_construct (GType object_type,
                                                            const gchar* app_id,
                                                            GApplicationFlags app_flags);
static void font_manager_application_real_startup (GApplication* base);
VALA_EXTERN FontManagerReject* font_manager_application_get_disabled_families (FontManagerApplication* self);
static void font_manager_application_set_settings (FontManagerApplication* self,
                                            GSettings* value);
VALA_EXTERN GSettings* font_manager_application_get_settings (FontManagerApplication* self);
static void font_manager_application_progress_visible (FontManagerApplication* self);
static void _font_manager_application_progress_visible_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
VALA_EXTERN FontManagerDatabaseProxy* font_manager_application_get_db (FontManagerApplication* self);
static void __lambda214_ (FontManagerApplication* self);
static void font_manager_application_set_update_in_progress (FontManagerApplication* self,
                                                      gboolean value);
static void ___lambda214__font_manager_database_proxy_update_started (FontManagerDatabaseProxy* _sender,
                                                               gpointer self);
static void __lambda215_ (FontManagerApplication* self);
static void ___lambda215__font_manager_database_proxy_update_complete (FontManagerDatabaseProxy* _sender,
                                                                gpointer self);
static void font_manager_application_real_open (GApplication* base,
                                         GFile** files,
                                         gint files_length1,
                                         const gchar* hint);
static gint font_manager_application_real_command_line (GApplication* base,
                                                 GApplicationCommandLine* cl);
VALA_EXTERN FontManagerMainWindow* font_manager_application_get_main_window (FontManagerApplication* self);
VALA_EXTERN void font_manager_main_window_install_selections (FontManagerMainWindow* self,
                                                  FontManagerStringSet* selections);
VALA_EXTERN GType font_manager_library_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLibraryInstaller, g_object_unref)
VALA_EXTERN FontManagerLibraryInstaller* font_manager_library_installer_new (void);
VALA_EXTERN FontManagerLibraryInstaller* font_manager_library_installer_construct (GType object_type);
static void _____lambda216_ (FontManagerApplication* self,
                      const gchar* m,
                      guint p,
                      guint t);
static void ______lambda216__font_manager_library_installer_progress (FontManagerLibraryInstaller* _sender,
                                                               const gchar* message,
                                                               guint processed,
                                                               guint total,
                                                               gpointer self);
VALA_EXTERN void font_manager_library_installer_process_sync (FontManagerLibraryInstaller* self,
                                                  FontManagerStringSet* filelist);
VALA_EXTERN void font_manager_application_reload (FontManagerApplication* self);
VALA_EXTERN gboolean font_manager_load_user_font_resources (void);
VALA_EXTERN JsonArray* font_manager_get_sorted_font_list (PangoContext* ctx);
VALA_EXTERN void font_manager_application_set_available_fonts (FontManagerApplication* self,
                                                   JsonArray* value);
static void ____lambda217_ (FontManagerApplication* self);
static void _____lambda217__font_manager_database_proxy_update_started (FontManagerDatabaseProxy* _sender,
                                                                 gpointer self);
static void ____lambda218_ (FontManagerApplication* self);
static void _____lambda218__font_manager_database_proxy_update_complete (FontManagerDatabaseProxy* _sender,
                                                                  gpointer self);
VALA_EXTERN void font_manager_database_proxy_set_progress_callback (FontManagerDatabaseProxy* self,
                                                        FontManagerProgressCallback progress);
static gboolean _font_manager_progress_data_print_font_manager_progress_callback (FontManagerProgressData* data);
VALA_EXTERN void font_manager_database_proxy_update (FontManagerDatabaseProxy* self,
                                         JsonArray* available_fonts);
VALA_EXTERN JsonArray* font_manager_application_get_available_fonts (FontManagerApplication* self);
VALA_EXTERN gchar* font_manager_application_list (FontManagerApplication* self,
                                      GError** error);
VALA_EXTERN gchar* font_manager_application_list_full (FontManagerApplication* self,
                                           GError** error);
VALA_EXTERN void font_manager_application_enable (FontManagerApplication* self,
                                      gchar** families,
                                      gint families_length1,
                                      GError** error);
VALA_EXTERN void font_manager_application_disable (FontManagerApplication* self,
                                       gchar** families,
                                       gint families_length1,
                                       GError** error);
VALA_EXTERN void font_manager_application_install (FontManagerApplication* self,
                                       gchar** filepaths,
                                       gint filepaths_length1,
                                       GError** error);
VALA_EXTERN void font_manager_application_search (FontManagerApplication* self,
                                      const gchar* needle,
                                      GError** error);
VALA_EXTERN void font_manager_main_window_search (FontManagerMainWindow* self,
                                      const gchar* needle);
static gint font_manager_application_real_handle_local_options (GApplication* base,
                                                         GVariantDict* options);
VALA_EXTERN FontManagerStringSet* font_manager_get_command_line_input (GVariantDict* options);
VALA_EXTERN GtkProgressBar* font_manager_main_window_get_progress (FontManagerMainWindow* self);
VALA_EXTERN gboolean font_manager_application_get_update_in_progress (FontManagerApplication* self);
static void font_manager_application_real_activate (GApplication* base);
VALA_EXTERN FontManagerMainWindow* font_manager_main_window_new (GSettings* settings);
VALA_EXTERN FontManagerMainWindow* font_manager_main_window_construct (GType object_type,
                                                           GSettings* settings);
static void font_manager_application_set_main_window (FontManagerApplication* self,
                                               FontManagerMainWindow* value);
static void __lambda219_ (FontManagerApplication* self);
VALA_EXTERN void font_manager_update_item_preview_text (JsonArray* available_fonts);
VALA_EXTERN GType font_manager_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerMode font_manager_main_window_get_mode (FontManagerMainWindow* self);
VALA_EXTERN GType font_manager_browse_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowsePane, g_object_unref)
VALA_EXTERN FontManagerBrowsePane* font_manager_main_window_get_browse_pane (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_browse_pane_queue_update (FontManagerBrowsePane* self);
static gboolean __lambda220_ (FontManagerApplication* self);
VALA_EXTERN GType font_manager_font_list_filter_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilterModel, g_object_unref)
VALA_EXTERN GType font_manager_category_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategoryListModel, g_object_unref)
VALA_EXTERN FontManagerCategoryListModel* font_manager_main_window_get_category_model (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_category_list_model_update_items (FontManagerCategoryListModel* self);
VALA_EXTERN void font_manager_main_window_select_first_font (FontManagerMainWindow* self);
static gboolean ___lambda220__gsource_func (gpointer self);
static void ___lambda219__font_manager_database_proxy_update_complete (FontManagerDatabaseProxy* _sender,
                                                                gpointer self);
static gboolean __lambda221_ (FontManagerProgressData* data);
VALA_EXTERN gboolean font_manager_main_window_progress_update (FontManagerMainWindow* self,
                                                   FontManagerProgressData* data);
static gboolean ___lambda221__font_manager_progress_callback (FontManagerProgressData* data);
static gboolean font_manager_application_real_dbus_register (GApplication* base,
                                                      GDBusConnection* conn,
                                                      const gchar* path,
                                                      GError** error);
VALA_EXTERN FontManagerSearchProvider* font_manager_search_provider_new (void);
VALA_EXTERN FontManagerSearchProvider* font_manager_search_provider_construct (GType object_type);
VALA_EXTERN void font_manager_search_provider_dbus_register (FontManagerSearchProvider* self,
                                                 GDBusConnection* conn);
static void font_manager_application_real_dbus_unregister (GApplication* base,
                                                    GDBusConnection* conn,
                                                    const gchar* path);
VALA_EXTERN void font_manager_search_provider_dbus_unregister (FontManagerSearchProvider* self,
                                                   GDBusConnection* conn);
static void font_manager_application_set_debug_level (gchar** args,
                                               gint args_length1);
static gint font_manager_application_main (gchar** args,
                                    gint args_length1);
static void font_manager_application_set_db (FontManagerApplication* self,
                                      FontManagerDatabaseProxy* value);
static void font_manager_application_set_disabled_families (FontManagerApplication* self,
                                                     FontManagerReject* value);
static void font_manager_application_finalize (GObject * obj);
static GType font_manager_application_get_type_once (void);
static void _vala_font_manager_application_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_font_manager_application_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _dbus_font_manager_application_list (FontManagerApplication* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_font_manager_application_list_full (FontManagerApplication* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_font_manager_application_enable (FontManagerApplication* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_font_manager_application_disable (FontManagerApplication* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_font_manager_application_install (FontManagerApplication* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_font_manager_application_search (FontManagerApplication* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void font_manager_application_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* font_manager_application_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static gboolean font_manager_application_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _font_manager_application_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry FONT_MANAGER_APPLICATION_options[12] = {{"about", 'a', (gint) 0, G_OPTION_ARG_NONE, NULL, "About the application", NULL}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, "Show application version", NULL}, {"debug", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, "Enable debug messages", NULL}, {"install", 'i', (gint) 0, G_OPTION_ARG_NONE, NULL, "Space separated list of files to install.", NULL}, {"enable", 'e', (gint) 0, G_OPTION_ARG_NONE, NULL, "Space separated list of font families to enable. Empty list to enable " \
"all.", NULL}, {"disable", 'd', (gint) 0, G_OPTION_ARG_NONE, NULL, "Space separated list of font families to disable", NULL}, {"keep", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, "Space separated list of font families to keep enabled, disables all ot" \
"hers.", NULL}, {"list", 'l', (gint) 0, G_OPTION_ARG_NONE, NULL, "List available font families.", NULL}, {"list-full", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, "Full listing including face information. (JSON)", NULL}, {"update", 'u', (gint) 0, G_OPTION_ARG_NONE, NULL, "Update application database", NULL}, {"", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, NULL, NULL, NULL}, {NULL}};
static const GDBusArgInfo _font_manager_application_dbus_arg_info_list_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_list_in[] = {NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_list_out[] = {&_font_manager_application_dbus_arg_info_list_result, NULL};
static const GDBusMethodInfo _font_manager_application_dbus_method_info_list = {-1, "List", (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_list_in), (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_list_out), NULL};
static const GDBusArgInfo _font_manager_application_dbus_arg_info_list_full_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_list_full_in[] = {NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_list_full_out[] = {&_font_manager_application_dbus_arg_info_list_full_result, NULL};
static const GDBusMethodInfo _font_manager_application_dbus_method_info_list_full = {-1, "ListFull", (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_list_full_in), (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_list_full_out), NULL};
static const GDBusArgInfo _font_manager_application_dbus_arg_info_enable_families = {-1, "families", "as", NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_enable_in[] = {&_font_manager_application_dbus_arg_info_enable_families, NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_enable_out[] = {NULL};
static const GDBusMethodInfo _font_manager_application_dbus_method_info_enable = {-1, "Enable", (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_enable_in), (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_enable_out), NULL};
static const GDBusArgInfo _font_manager_application_dbus_arg_info_disable_families = {-1, "families", "as", NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_disable_in[] = {&_font_manager_application_dbus_arg_info_disable_families, NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_disable_out[] = {NULL};
static const GDBusMethodInfo _font_manager_application_dbus_method_info_disable = {-1, "Disable", (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_disable_in), (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_disable_out), NULL};
static const GDBusArgInfo _font_manager_application_dbus_arg_info_install_filepaths = {-1, "filepaths", "as", NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_install_in[] = {&_font_manager_application_dbus_arg_info_install_filepaths, NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_install_out[] = {NULL};
static const GDBusMethodInfo _font_manager_application_dbus_method_info_install = {-1, "Install", (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_install_in), (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_install_out), NULL};
static const GDBusArgInfo _font_manager_application_dbus_arg_info_search_needle = {-1, "needle", "s", NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_search_in[] = {&_font_manager_application_dbus_arg_info_search_needle, NULL};
static const GDBusArgInfo * const _font_manager_application_dbus_arg_info_search_out[] = {NULL};
static const GDBusMethodInfo _font_manager_application_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_search_in), (GDBusArgInfo **) (&_font_manager_application_dbus_arg_info_search_out), NULL};
static const GDBusMethodInfo * const _font_manager_application_dbus_method_info[] = {&_font_manager_application_dbus_method_info_list, &_font_manager_application_dbus_method_info_list_full, &_font_manager_application_dbus_method_info_enable, &_font_manager_application_dbus_method_info_disable, &_font_manager_application_dbus_method_info_install, &_font_manager_application_dbus_method_info_search, NULL};
static const GDBusSignalInfo * const _font_manager_application_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _font_manager_application_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _font_manager_application_dbus_interface_info = {-1, "com.github.FontManager.FontManager", (GDBusMethodInfo **) (&_font_manager_application_dbus_method_info), (GDBusSignalInfo **) (&_font_manager_application_dbus_signal_info), (GDBusPropertyInfo **) (&_font_manager_application_dbus_property_info), NULL};
static const GDBusInterfaceVTable _font_manager_application_dbus_interface_vtable = {font_manager_application_dbus_interface_method_call, font_manager_application_dbus_interface_get_property, font_manager_application_dbus_interface_set_property};

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FontManagerApplication*
font_manager_get_default_application (void)
{
	GApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	FontManagerApplication* result;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication));
	result = _tmp1_;
	return result;
}

static inline gpointer
font_manager_application_get_instance_private (FontManagerApplication* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerApplication_private_offset);
}

FontManagerApplication*
font_manager_application_construct (GType object_type,
                                    const gchar* app_id,
                                    GApplicationFlags app_flags)
{
	FontManagerApplication * self = NULL;
	g_return_val_if_fail (app_id != NULL, NULL);
	self = (FontManagerApplication*) g_object_new (object_type, "application-id", app_id, "flags", app_flags, NULL);
	g_application_add_main_option_entries ((GApplication*) self, FONT_MANAGER_APPLICATION_options);
	return self;
}

FontManagerApplication*
font_manager_application_new (const gchar* app_id,
                              GApplicationFlags app_flags)
{
	return font_manager_application_construct (FONT_MANAGER_TYPE_APPLICATION, app_id, app_flags);
}

static void
_font_manager_application_progress_visible_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	font_manager_application_progress_visible ((FontManagerApplication*) self);
}

static void
__lambda214_ (FontManagerApplication* self)
{
	font_manager_application_set_update_in_progress (self, TRUE);
}

static void
___lambda214__font_manager_database_proxy_update_started (FontManagerDatabaseProxy* _sender,
                                                          gpointer self)
{
	__lambda214_ ((FontManagerApplication*) self);
}

static void
__lambda215_ (FontManagerApplication* self)
{
	font_manager_application_set_update_in_progress (self, FALSE);
}

static void
___lambda215__font_manager_database_proxy_update_complete (FontManagerDatabaseProxy* _sender,
                                                           gpointer self)
{
	__lambda215_ ((FontManagerApplication*) self);
}

static void
font_manager_application_real_startup (GApplication* base)
{
	FontManagerApplication * self;
	FontManagerReject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	FontManagerDatabaseProxy* _tmp12_;
	FontManagerDatabaseProxy* _tmp13_;
	self = (FontManagerApplication*) base;
	G_APPLICATION_CLASS (font_manager_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->_disabled_families;
	font_manager_selections_load ((FontManagerSelections*) _tmp0_);
	_tmp1_ = g_application_get_application_id ((GApplication*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = font_manager_get_gsettings (_tmp2_);
	_tmp4_ = _tmp3_;
	font_manager_application_set_settings (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_settings;
	if (_tmp5_ != NULL) {
		GtkSettings* gtk = NULL;
		GtkSettings* _tmp6_;
		GtkSettings* _tmp7_;
		gboolean prefer_dark_theme = FALSE;
		GSettings* _tmp8_;
		GtkSettings* _tmp9_;
		GtkSettings* _tmp10_;
		GSettings* _tmp11_;
		_tmp6_ = gtk_settings_get_default ();
		_tmp7_ = _g_object_ref0 (_tmp6_);
		gtk = _tmp7_;
		_tmp8_ = self->priv->_settings;
		prefer_dark_theme = g_settings_get_boolean (_tmp8_, "prefer-dark-theme");
		_tmp9_ = gtk;
		g_object_set (_tmp9_, "gtk-application-prefer-dark-theme", prefer_dark_theme, NULL);
		_tmp10_ = gtk;
		_tmp11_ = self->priv->_settings;
		g_object_set (_tmp10_, "gtk-enable-animations", g_settings_get_boolean (_tmp11_, "enable-animations"), NULL);
		_g_object_unref0 (gtk);
	}
	g_signal_connect_object ((GObject*) self, "notify::update-in-progress", (GCallback) _font_manager_application_progress_visible_g_object_notify, self, 0);
	_tmp12_ = self->priv->_db;
	g_signal_connect_object (_tmp12_, "update-started", (GCallback) ___lambda214__font_manager_database_proxy_update_started, self, 0);
	_tmp13_ = self->priv->_db;
	g_signal_connect_object (_tmp13_, "update-complete", (GCallback) ___lambda215__font_manager_database_proxy_update_complete, self, 0);
	return;
}

static void
font_manager_application_real_open (GApplication* base,
                                    GFile** files,
                                    gint files_length1,
                                    const gchar* hint)
{
	FontManagerApplication * self;
	gint _tmp0_ = 0;
	gint index = 0;
	GError* _inner_error0_ = NULL;
	self = (FontManagerApplication*) base;
	g_return_if_fail (hint != NULL);
	if (g_strcmp0 (hint, "") != 0) {
		_tmp0_ = atoi (hint);
	} else {
		_tmp0_ = 0;
	}
	index = _tmp0_;
	{
		GDBusConnection* conn = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		conn = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = conn;
		_tmp3_ = files[0];
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_variant_new ("(si)", _tmp5_, index, NULL);
		g_variant_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_dbus_connection_call_sync (_tmp2_, FONT_MANAGER_FONT_VIEWER_BUS_ID, FONT_MANAGER_FONT_VIEWER_BUS_PATH, FONT_MANAGER_FONT_VIEWER_BUS_ID, "ShowUri", _tmp7_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_variant_unref0 (_tmp9_);
		_g_variant_unref0 (_tmp7_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (conn);
			goto __catch0_g_error;
		}
		_g_object_unref0 (conn);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("Application.vala:112: Method call to %s failed : %s", FONT_MANAGER_FONT_VIEWER_BUS_ID, _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static void
_____lambda216_ (FontManagerApplication* self,
                 const gchar* m,
                 guint p,
                 guint t)
{
	FontManagerProgressData* data = NULL;
	FontManagerProgressData* _tmp0_;
	g_return_if_fail (m != NULL);
	_tmp0_ = font_manager_progress_data_new (m, p, t);
	data = _tmp0_;
	font_manager_progress_data_print (data);
	_g_object_unref0 (data);
}

static void
______lambda216__font_manager_library_installer_progress (FontManagerLibraryInstaller* _sender,
                                                          const gchar* message,
                                                          guint processed,
                                                          guint total,
                                                          gpointer self)
{
	_____lambda216_ ((FontManagerApplication*) self, message, processed, total);
}

static void
____lambda217_ (FontManagerApplication* self)
{
	g_application_hold ((GApplication*) self);
}

static void
_____lambda217__font_manager_database_proxy_update_started (FontManagerDatabaseProxy* _sender,
                                                            gpointer self)
{
	____lambda217_ ((FontManagerApplication*) self);
}

static void
____lambda218_ (FontManagerApplication* self)
{
	FILE* _tmp0_;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n");
	g_application_release ((GApplication*) self);
}

static void
_____lambda218__font_manager_database_proxy_update_complete (FontManagerDatabaseProxy* _sender,
                                                             gpointer self)
{
	____lambda218_ ((FontManagerApplication*) self);
}

static gboolean
_font_manager_progress_data_print_font_manager_progress_callback (FontManagerProgressData* data)
{
	gboolean result;
	result = font_manager_progress_data_print (data);
	return result;
}

static gint
font_manager_application_real_command_line (GApplication* base,
                                            GApplicationCommandLine* cl)
{
	FontManagerApplication * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	FontManagerStringSet* filelist = NULL;
	FontManagerStringSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GVariantDict* _tmp4_;
	gint result;
	self = (FontManagerApplication*) base;
	g_return_val_if_fail (cl != NULL, 0);
	g_application_hold ((GApplication*) self);
	_tmp0_ = g_application_command_line_get_options_dict (cl);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	_tmp2_ = font_manager_get_command_line_files (cl);
	filelist = _tmp2_;
	_tmp4_ = options;
	if (g_variant_dict_contains (_tmp4_, "install")) {
		_tmp3_ = TRUE;
	} else {
		GVariantDict* _tmp5_;
		_tmp5_ = options;
		_tmp3_ = g_variant_dict_contains (_tmp5_, "update");
	}
	if (_tmp3_) {
		gboolean _tmp6_ = FALSE;
		GVariantDict* _tmp7_;
		FontManagerMainWindow* _tmp18_;
		_tmp7_ = options;
		if (g_variant_dict_contains (_tmp7_, "install")) {
			FontManagerStringSet* _tmp8_;
			_tmp8_ = filelist;
			_tmp6_ = _tmp8_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			FontManagerMainWindow* _tmp9_;
			_tmp9_ = self->priv->_main_window;
			if (_tmp9_ != NULL) {
				FontManagerMainWindow* _tmp10_;
				FontManagerStringSet* _tmp11_;
				_tmp10_ = self->priv->_main_window;
				_tmp11_ = filelist;
				font_manager_main_window_install_selections (_tmp10_, _tmp11_);
			} else {
				FontManagerLibraryInstaller* installer = NULL;
				FontManagerLibraryInstaller* _tmp12_;
				FontManagerLibraryInstaller* _tmp13_;
				FILE* _tmp14_;
				FontManagerLibraryInstaller* _tmp15_;
				FontManagerStringSet* _tmp16_;
				FILE* _tmp17_;
				_tmp12_ = font_manager_library_installer_new ();
				installer = _tmp12_;
				_tmp13_ = installer;
				g_signal_connect_object (_tmp13_, "progress", (GCallback) ______lambda216__font_manager_library_installer_progress, self, 0);
				_tmp14_ = stdout;
				fprintf (_tmp14_, "%s\n", _ ("Installing Font Files…"));
				_tmp15_ = installer;
				_tmp16_ = filelist;
				font_manager_library_installer_process_sync (_tmp15_, _tmp16_);
				_tmp17_ = stdout;
				fprintf (_tmp17_, "\n");
				_g_object_unref0 (installer);
			}
		}
		_tmp18_ = self->priv->_main_window;
		if (_tmp18_ != NULL) {
			font_manager_application_reload (self);
		} else {
			JsonArray* _tmp19_;
			JsonArray* _tmp20_;
			FontManagerDatabaseProxy* _tmp21_;
			FontManagerDatabaseProxy* _tmp22_;
			FontManagerDatabaseProxy* _tmp23_;
			FILE* _tmp24_;
			FontManagerDatabaseProxy* _tmp25_;
			JsonArray* _tmp26_;
			font_manager_update_font_configuration ();
			font_manager_load_user_font_resources ();
			_tmp19_ = font_manager_get_sorted_font_list (NULL);
			_tmp20_ = _tmp19_;
			font_manager_application_set_available_fonts (self, _tmp20_);
			_json_array_unref0 (_tmp20_);
			_tmp21_ = self->priv->_db;
			g_signal_connect_object (_tmp21_, "update-started", (GCallback) _____lambda217__font_manager_database_proxy_update_started, self, 0);
			_tmp22_ = self->priv->_db;
			g_signal_connect_object (_tmp22_, "update-complete", (GCallback) _____lambda218__font_manager_database_proxy_update_complete, self, 0);
			_tmp23_ = self->priv->_db;
			font_manager_database_proxy_set_progress_callback (_tmp23_, _font_manager_progress_data_print_font_manager_progress_callback);
			_tmp24_ = stdout;
			fprintf (_tmp24_, "%s\n", _ ("Updating Database…"));
			_tmp25_ = self->priv->_db;
			_tmp26_ = self->priv->_available_fonts;
			font_manager_database_proxy_update (_tmp25_, _tmp26_);
		}
	} else {
		FontManagerStringSet* _tmp27_;
		_tmp27_ = filelist;
		if (_tmp27_ != NULL) {
			GFile** files = NULL;
			FontManagerStringSet* _tmp28_;
			const gchar* _tmp29_;
			GFile* _tmp30_;
			GFile** _tmp31_;
			gint files_length1;
			gint _files_size_;
			GFile** _tmp32_;
			gint _tmp32__length1;
			_tmp28_ = filelist;
			_tmp29_ = font_manager_string_set_get (_tmp28_, (guint) 0);
			_tmp30_ = g_file_new_for_path (_tmp29_);
			_tmp31_ = g_new0 (GFile*, 1 + 1);
			_tmp31_[0] = _tmp30_;
			files = _tmp31_;
			files_length1 = 1;
			_files_size_ = files_length1;
			_tmp32_ = files;
			_tmp32__length1 = files_length1;
			g_application_open ((GApplication*) self, _tmp32_, (gint) _tmp32__length1, "0");
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		} else {
			g_application_activate ((GApplication*) self);
		}
	}
	g_application_release ((GApplication*) self);
	result = 0;
	_g_object_unref0 (filelist);
	_g_variant_dict_unref0 (options);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
font_manager_application_list (FontManagerApplication* self,
                               GError** error)
{
	FontManagerStringSet* families = NULL;
	FontManagerStringSet* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	font_manager_update_font_configuration ();
	font_manager_load_user_font_resources ();
	_tmp0_ = font_manager_list_available_font_families ();
	families = _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	{
		FontManagerStringSet* _family_list = NULL;
		FontManagerStringSet* _tmp2_;
		guint _family_size = 0U;
		FontManagerStringSet* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		gint _family_index = 0;
		_tmp2_ = families;
		_family_list = _tmp2_;
		_tmp3_ = _family_list;
		g_object_get (_tmp3_, "size", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_family_size = _tmp5_;
		_family_index = -1;
		while (TRUE) {
			gint _tmp6_;
			guint _tmp7_;
			gchar* family = NULL;
			FontManagerStringSet* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			GString* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_family_index = _family_index + 1;
			_tmp6_ = _family_index;
			_tmp7_ = _family_size;
			if (!(((guint) _tmp6_) < _tmp7_)) {
				break;
			}
			_tmp8_ = _family_list;
			_tmp9_ = font_manager_string_set_get (_tmp8_, (guint) _family_index);
			_tmp10_ = g_strdup (_tmp9_);
			family = _tmp10_;
			_tmp11_ = builder;
			_tmp12_ = family;
			_tmp13_ = string_to_string (_tmp12_);
			_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
			_tmp15_ = _tmp14_;
			g_string_append (_tmp11_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (family);
		}
	}
	_tmp16_ = builder;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_string_free0 (builder);
	_g_object_unref0 (families);
	return result;
}

gchar*
font_manager_application_list_full (FontManagerApplication* self,
                                    GError** error)
{
	JsonObject* _fonts = NULL;
	JsonObject* _tmp0_;
	JsonArray* sorted_fonts = NULL;
	JsonArray* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	font_manager_update_font_configuration ();
	font_manager_load_user_font_resources ();
	_tmp0_ = font_manager_get_available_fonts (NULL);
	_fonts = _tmp0_;
	_tmp1_ = font_manager_sort_json_font_listing (_fonts);
	sorted_fonts = _tmp1_;
	_tmp2_ = font_manager_print_json_array (sorted_fonts, TRUE);
	result = _tmp2_;
	_json_array_unref0 (sorted_fonts);
	_json_object_unref0 (_fonts);
	return result;
}

void
font_manager_application_enable (FontManagerApplication* self,
                                 gchar** families,
                                 gint families_length1,
                                 GError** error)
{
	FontManagerReject* _tmp0_;
	FontManagerReject* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_disabled_families;
	font_manager_selections_load ((FontManagerSelections*) _tmp0_);
	{
		gchar** family_collection = NULL;
		gint family_collection_length1 = 0;
		gint _family_collection_size_ = 0;
		gint family_it = 0;
		family_collection = families;
		family_collection_length1 = families_length1;
		for (family_it = 0; family_it < family_collection_length1; family_it = family_it + 1) {
			gchar* _tmp1_;
			gchar* family = NULL;
			_tmp1_ = g_strdup (family_collection[family_it]);
			family = _tmp1_;
			{
				FontManagerReject* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = self->priv->_disabled_families;
				_tmp3_ = family;
				if (font_manager_string_set_contains ((FontManagerStringSet*) _tmp2_, _tmp3_)) {
					FontManagerReject* _tmp4_;
					const gchar* _tmp5_;
					_tmp4_ = self->priv->_disabled_families;
					_tmp5_ = family;
					font_manager_string_set_remove ((FontManagerStringSet*) _tmp4_, _tmp5_);
				}
				_g_free0 (family);
			}
		}
	}
	_tmp6_ = self->priv->_disabled_families;
	font_manager_selections_save ((FontManagerSelections*) _tmp6_);
	return;
}

void
font_manager_application_disable (FontManagerApplication* self,
                                  gchar** families,
                                  gint families_length1,
                                  GError** error)
{
	FontManagerReject* _tmp3_;
	g_return_if_fail (self != NULL);
	{
		gchar** family_collection = NULL;
		gint family_collection_length1 = 0;
		gint _family_collection_size_ = 0;
		gint family_it = 0;
		family_collection = families;
		family_collection_length1 = families_length1;
		for (family_it = 0; family_it < family_collection_length1; family_it = family_it + 1) {
			gchar* _tmp0_;
			gchar* family = NULL;
			_tmp0_ = g_strdup (family_collection[family_it]);
			family = _tmp0_;
			{
				FontManagerReject* _tmp1_;
				const gchar* _tmp2_;
				_tmp1_ = self->priv->_disabled_families;
				_tmp2_ = family;
				font_manager_string_set_add ((FontManagerStringSet*) _tmp1_, _tmp2_);
				_g_free0 (family);
			}
		}
	}
	_tmp3_ = self->priv->_disabled_families;
	font_manager_selections_save ((FontManagerSelections*) _tmp3_);
	return;
}

void
font_manager_application_install (FontManagerApplication* self,
                                  gchar** filepaths,
                                  gint filepaths_length1,
                                  GError** error)
{
	FontManagerStringSet* filelist = NULL;
	FontManagerStringSet* _tmp0_;
	FontManagerLibraryInstaller* installer = NULL;
	FontManagerLibraryInstaller* _tmp4_;
	FontManagerStringSet* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_string_set_new ();
	filelist = _tmp0_;
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = filepaths;
		path_collection_length1 = filepaths_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp1_;
			gchar* path = NULL;
			_tmp1_ = g_strdup (path_collection[path_it]);
			path = _tmp1_;
			{
				FontManagerStringSet* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = filelist;
				_tmp3_ = path;
				font_manager_string_set_add (_tmp2_, _tmp3_);
				_g_free0 (path);
			}
		}
	}
	_tmp4_ = font_manager_library_installer_new ();
	installer = _tmp4_;
	_tmp5_ = filelist;
	font_manager_library_installer_process_sync (installer, _tmp5_);
	_g_object_unref0 (installer);
	_g_object_unref0 (filelist);
	return;
}

void
font_manager_application_search (FontManagerApplication* self,
                                 const gchar* needle,
                                 GError** error)
{
	gboolean _tmp0_ = FALSE;
	FontManagerMainWindow* _tmp1_;
	FontManagerMainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (needle != NULL);
	_tmp1_ = self->priv->_main_window;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FontManagerMainWindow* _tmp2_;
		_tmp2_ = self->priv->_main_window;
		_tmp0_ = !gtk_widget_is_visible ((GtkWidget*) _tmp2_);
	}
	if (_tmp0_) {
		g_application_activate ((GApplication*) self);
	}
	_tmp3_ = self->priv->_main_window;
	font_manager_main_window_search (_tmp3_, needle);
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
font_manager_application_real_handle_local_options (GApplication* base,
                                                    GVariantDict* options)
{
	FontManagerApplication * self;
	gint exit_status = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (FontManagerApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	exit_status = -1;
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	if (g_variant_dict_contains (options, "about")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "\n    %s - %s\n\n\t\t  %s\n%s\n", PACKAGE_NAME, COMMENT, COPYRIGHT, LICENSE);
		result = 0;
		return result;
	}
	if (g_variant_dict_contains (options, "enable")) {
		FontManagerStringSet* accept = NULL;
		FontManagerStringSet* _tmp2_;
		gboolean _tmp3_ = FALSE;
		FontManagerStringSet* _tmp4_;
		_tmp2_ = font_manager_get_command_line_input (options);
		accept = _tmp2_;
		_tmp4_ = accept;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			FontManagerStringSet* _tmp5_;
			guint _tmp6_;
			guint _tmp7_;
			_tmp5_ = accept;
			g_object_get (_tmp5_, "size", &_tmp6_, NULL);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ < ((guint) 1);
		}
		if (_tmp3_) {
			FontManagerReject* _tmp8_;
			FontManagerReject* _tmp9_;
			_tmp8_ = self->priv->_disabled_families;
			font_manager_string_set_clear ((FontManagerStringSet*) _tmp8_);
			_tmp9_ = self->priv->_disabled_families;
			font_manager_selections_save ((FontManagerSelections*) _tmp9_);
			exit_status = 0;
		} else {
			{
				FontManagerStringSet* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				_tmp10_ = accept;
				_tmp12_ = _tmp11_ = font_manager_string_set_to_strv (_tmp10_);
				_tmp13_ = _tmp12_;
				_tmp13__length1 = _vala_array_length (_tmp11_);
				font_manager_application_enable (self, _tmp13_, (gint) _vala_array_length (_tmp11_), &_inner_error0_);
				_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				exit_status = 0;
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_critical ("Application.vala:236: %s", _tmp15_);
				exit_status = 1;
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp16_ = -1;
				_g_object_unref0 (accept);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp16_;
			}
		}
		_g_object_unref0 (accept);
	}
	if (g_variant_dict_contains (options, "disable")) {
		FontManagerStringSet* rejects = NULL;
		FontManagerStringSet* _tmp17_;
		gboolean _tmp18_ = FALSE;
		FontManagerStringSet* _tmp19_;
		_tmp17_ = font_manager_get_command_line_input (options);
		rejects = _tmp17_;
		_tmp19_ = rejects;
		if (_tmp19_ == NULL) {
			_tmp18_ = TRUE;
		} else {
			FontManagerStringSet* _tmp20_;
			guint _tmp21_;
			guint _tmp22_;
			_tmp20_ = rejects;
			g_object_get (_tmp20_, "size", &_tmp21_, NULL);
			_tmp22_ = _tmp21_;
			_tmp18_ = _tmp22_ < ((guint) 1);
		}
		if (_tmp18_) {
			FILE* _tmp23_;
			_tmp23_ = stdout;
			fprintf (_tmp23_, "\nGot empty list. Exiting...\n\n");
			exit_status = 1;
		} else {
			{
				FontManagerStringSet* _tmp24_;
				gchar** _tmp25_;
				gchar** _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				_tmp24_ = rejects;
				_tmp26_ = _tmp25_ = font_manager_string_set_to_strv (_tmp24_);
				_tmp27_ = _tmp26_;
				_tmp27__length1 = _vala_array_length (_tmp25_);
				font_manager_application_disable (self, _tmp27_, (gint) _vala_array_length (_tmp25_), &_inner_error0_);
				_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				exit_status = 0;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = e;
				_tmp29_ = _tmp28_->message;
				g_critical ("Application.vala:252: %s", _tmp29_);
				exit_status = 1;
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp30_ = -1;
				_g_object_unref0 (rejects);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp30_;
			}
		}
		exit_status = 0;
		_g_object_unref0 (rejects);
	}
	if (g_variant_dict_contains (options, "keep")) {
		FontManagerStringSet* keep = NULL;
		FontManagerStringSet* _tmp31_;
		gboolean _tmp32_ = FALSE;
		FontManagerStringSet* _tmp33_;
		_tmp31_ = font_manager_get_command_line_input (options);
		keep = _tmp31_;
		_tmp33_ = keep;
		if (_tmp33_ == NULL) {
			_tmp32_ = TRUE;
		} else {
			FontManagerStringSet* _tmp34_;
			guint _tmp35_;
			guint _tmp36_;
			_tmp34_ = keep;
			g_object_get (_tmp34_, "size", &_tmp35_, NULL);
			_tmp36_ = _tmp35_;
			_tmp32_ = _tmp36_ < ((guint) 1);
		}
		if (_tmp32_) {
			FILE* _tmp37_;
			_tmp37_ = stdout;
			fprintf (_tmp37_, "\n" \
"Got empty list. Disabling all installed fonts is not a good idea...\n" \
"\n");
			exit_status = 1;
		} else {
			FontManagerStringSet* families = NULL;
			FontManagerStringSet* _tmp38_;
			FontManagerStringSet* matches = NULL;
			FontManagerStringSet* _tmp39_;
			FontManagerStringSet* _tmp69_;
			guint _tmp70_;
			guint _tmp71_;
			font_manager_update_font_configuration ();
			font_manager_load_user_font_resources ();
			_tmp38_ = font_manager_list_available_font_families ();
			families = _tmp38_;
			_tmp39_ = font_manager_string_set_new ();
			matches = _tmp39_;
			{
				FontManagerStringSet* _family_list = NULL;
				FontManagerStringSet* _tmp40_;
				guint _family_size = 0U;
				FontManagerStringSet* _tmp41_;
				guint _tmp42_;
				guint _tmp43_;
				gint _family_index = 0;
				_tmp40_ = keep;
				_family_list = _tmp40_;
				_tmp41_ = _family_list;
				g_object_get (_tmp41_, "size", &_tmp42_, NULL);
				_tmp43_ = _tmp42_;
				_family_size = _tmp43_;
				_family_index = -1;
				while (TRUE) {
					gint _tmp44_;
					guint _tmp45_;
					gchar* family = NULL;
					FontManagerStringSet* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					_family_index = _family_index + 1;
					_tmp44_ = _family_index;
					_tmp45_ = _family_size;
					if (!(((guint) _tmp44_) < _tmp45_)) {
						break;
					}
					_tmp46_ = _family_list;
					_tmp47_ = font_manager_string_set_get (_tmp46_, (guint) _family_index);
					_tmp48_ = g_strdup (_tmp47_);
					family = _tmp48_;
					{
						FontManagerStringSet* _entry_list = NULL;
						FontManagerStringSet* _tmp49_;
						guint _entry_size = 0U;
						FontManagerStringSet* _tmp50_;
						guint _tmp51_;
						guint _tmp52_;
						gint _entry_index = 0;
						_tmp49_ = families;
						_entry_list = _tmp49_;
						_tmp50_ = _entry_list;
						g_object_get (_tmp50_, "size", &_tmp51_, NULL);
						_tmp52_ = _tmp51_;
						_entry_size = _tmp52_;
						_entry_index = -1;
						while (TRUE) {
							gint _tmp53_;
							guint _tmp54_;
							gchar* entry = NULL;
							FontManagerStringSet* _tmp55_;
							const gchar* _tmp56_;
							gchar* _tmp57_;
							gchar* a = NULL;
							const gchar* _tmp58_;
							gchar* _tmp59_;
							gchar* b = NULL;
							const gchar* _tmp60_;
							gchar* _tmp61_;
							gboolean _tmp62_ = FALSE;
							const gchar* _tmp63_;
							const gchar* _tmp64_;
							_entry_index = _entry_index + 1;
							_tmp53_ = _entry_index;
							_tmp54_ = _entry_size;
							if (!(((guint) _tmp53_) < _tmp54_)) {
								break;
							}
							_tmp55_ = _entry_list;
							_tmp56_ = font_manager_string_set_get (_tmp55_, (guint) _entry_index);
							_tmp57_ = g_strdup (_tmp56_);
							entry = _tmp57_;
							_tmp58_ = entry;
							_tmp59_ = g_utf8_strdown (_tmp58_, (gssize) -1);
							a = _tmp59_;
							_tmp60_ = family;
							_tmp61_ = g_utf8_strdown (_tmp60_, (gssize) -1);
							b = _tmp61_;
							_tmp63_ = a;
							_tmp64_ = b;
							if (g_strcmp0 (_tmp63_, _tmp64_) == 0) {
								_tmp62_ = TRUE;
							} else {
								const gchar* _tmp65_;
								const gchar* _tmp66_;
								_tmp65_ = a;
								_tmp66_ = b;
								_tmp62_ = string_contains (_tmp65_, _tmp66_);
							}
							if (_tmp62_) {
								FontManagerStringSet* _tmp67_;
								const gchar* _tmp68_;
								_tmp67_ = matches;
								_tmp68_ = entry;
								font_manager_string_set_add (_tmp67_, _tmp68_);
							}
							_g_free0 (b);
							_g_free0 (a);
							_g_free0 (entry);
						}
					}
					_g_free0 (family);
				}
			}
			_tmp69_ = matches;
			g_object_get (_tmp69_, "size", &_tmp70_, NULL);
			_tmp71_ = _tmp70_;
			if (_tmp71_ < ((guint) 1)) {
				FILE* _tmp72_;
				_tmp72_ = stdout;
				fprintf (_tmp72_, "\n" \
"No valid families specified. Disabling all installed fonts is not a go" \
"od idea...\n" \
"\n");
				exit_status = 1;
			} else {
				FontManagerStringSet* _tmp73_;
				FontManagerStringSet* _tmp74_;
				_tmp73_ = families;
				_tmp74_ = matches;
				font_manager_string_set_remove_all (_tmp73_, _tmp74_);
				{
					FontManagerStringSet* _tmp75_;
					gchar** _tmp76_;
					gchar** _tmp77_;
					gchar** _tmp78_;
					gint _tmp78__length1;
					_tmp75_ = families;
					_tmp77_ = _tmp76_ = font_manager_string_set_to_strv (_tmp75_);
					_tmp78_ = _tmp77_;
					_tmp78__length1 = _vala_array_length (_tmp76_);
					font_manager_application_disable (self, _tmp78_, (gint) _vala_array_length (_tmp76_), &_inner_error0_);
					_tmp78_ = (_vala_array_free (_tmp78_, _tmp78__length1, (GDestroyNotify) g_free), NULL);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					exit_status = 0;
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					GError* _tmp79_;
					const gchar* _tmp80_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp79_ = e;
					_tmp80_ = _tmp79_->message;
					g_critical ("Application.vala:285: %s", _tmp80_);
					exit_status = 1;
					_g_error_free0 (e);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint _tmp81_ = -1;
					_g_object_unref0 (matches);
					_g_object_unref0 (families);
					_g_object_unref0 (keep);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp81_;
				}
			}
			_g_object_unref0 (matches);
			_g_object_unref0 (families);
		}
		exit_status = 0;
		_g_object_unref0 (keep);
	}
	if (g_variant_dict_contains (options, "list")) {
		{
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_;
			FILE* _tmp84_;
			_tmp83_ = font_manager_application_list (self, &_inner_error0_);
			_tmp82_ = _tmp83_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp84_ = stdout;
			fprintf (_tmp84_, "%s", _tmp82_);
			_g_free0 (_tmp82_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp85_;
			const gchar* _tmp86_;
			GError* _tmp87_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp85_ = e;
			_tmp86_ = _tmp85_->message;
			g_critical ("Application.vala:297: %s", _tmp86_);
			_tmp87_ = e;
			result = _tmp87_->code;
			_g_error_free0 (e);
			return result;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp88_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp88_;
		}
		exit_status = 0;
	}
	if (g_variant_dict_contains (options, "list-full")) {
		{
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_;
			FILE* _tmp91_;
			_tmp90_ = font_manager_application_list_full (self, &_inner_error0_);
			_tmp89_ = _tmp90_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
			_tmp91_ = stdout;
			fprintf (_tmp91_, "\n%s\n\n", _tmp89_);
			_g_free0 (_tmp89_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp92_;
			const gchar* _tmp93_;
			GError* _tmp94_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp92_ = e;
			_tmp93_ = _tmp92_->message;
			g_critical ("Application.vala:307: %s", _tmp93_);
			_tmp94_ = e;
			result = _tmp94_->code;
			_g_error_free0 (e);
			return result;
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp95_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp95_;
		}
		exit_status = 0;
	}
	result = exit_status;
	return result;
}

static void
font_manager_application_progress_visible (FontManagerApplication* self)
{
	FontManagerMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	if (_tmp0_ != NULL) {
		FontManagerMainWindow* _tmp1_;
		GtkProgressBar* _tmp2_;
		GtkProgressBar* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->_main_window;
		_tmp2_ = font_manager_main_window_get_progress (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_update_in_progress;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, _tmp4_);
	}
	return;
}

void
font_manager_application_reload (FontManagerApplication* self)
{
	FontManagerMainWindow* _tmp0_;
	gboolean _tmp1_;
	PangoContext* ctx = NULL;
	FontManagerMainWindow* _tmp2_;
	PangoContext* _tmp3_;
	PangoContext* _tmp4_;
	PangoContext* _tmp5_;
	JsonArray* _tmp6_;
	JsonArray* _tmp7_;
	FontManagerMainWindow* _tmp8_;
	FontManagerDatabaseProxy* _tmp9_;
	JsonArray* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_vala_return_if_fail (_tmp0_ != NULL, "main_window != null");
	_tmp1_ = self->priv->_update_in_progress;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->_main_window;
	_tmp3_ = gtk_widget_get_pango_context ((GtkWidget*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	ctx = _tmp4_;
	_tmp5_ = ctx;
	_tmp6_ = font_manager_get_sorted_font_list (_tmp5_);
	_tmp7_ = _tmp6_;
	font_manager_application_set_available_fonts (self, _tmp7_);
	_json_array_unref0 (_tmp7_);
	_tmp8_ = self->priv->_main_window;
	gtk_window_present ((GtkWindow*) _tmp8_);
	_tmp9_ = self->priv->_db;
	_tmp10_ = self->priv->_available_fonts;
	font_manager_database_proxy_update (_tmp9_, _tmp10_);
	_g_object_unref0 (ctx);
	return;
}

static gboolean
__lambda220_ (FontManagerApplication* self)
{
	FontManagerMainWindow* _tmp0_;
	FontManagerCategoryListModel* _tmp1_;
	FontManagerCategoryListModel* _tmp2_;
	FontManagerMainWindow* _tmp3_;
	FontManagerMode _tmp4_;
	FontManagerMode _tmp5_;
	gboolean result;
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = font_manager_main_window_get_category_model (_tmp0_);
	_tmp2_ = _tmp1_;
	font_manager_category_list_model_update_items (_tmp2_);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = font_manager_main_window_get_mode (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != FONT_MANAGER_MODE_BROWSE) {
		FontManagerMainWindow* _tmp6_;
		_tmp6_ = self->priv->_main_window;
		font_manager_main_window_select_first_font (_tmp6_);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda220__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda220_ ((FontManagerApplication*) self);
	return result;
}

static void
__lambda219_ (FontManagerApplication* self)
{
	JsonArray* _tmp0_;
	FontManagerMainWindow* _tmp1_;
	FontManagerMode _tmp2_;
	FontManagerMode _tmp3_;
	_tmp0_ = self->priv->_available_fonts;
	font_manager_update_item_preview_text (_tmp0_);
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = font_manager_main_window_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == FONT_MANAGER_MODE_BROWSE) {
		FontManagerMainWindow* _tmp4_;
		FontManagerBrowsePane* _tmp5_;
		FontManagerBrowsePane* _tmp6_;
		_tmp4_ = self->priv->_main_window;
		_tmp5_ = font_manager_main_window_get_browse_pane (_tmp4_);
		_tmp6_ = _tmp5_;
		font_manager_browse_pane_queue_update (_tmp6_);
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda220__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda219__font_manager_database_proxy_update_complete (FontManagerDatabaseProxy* _sender,
                                                           gpointer self)
{
	__lambda219_ ((FontManagerApplication*) self);
}

static gboolean
__lambda221_ (FontManagerProgressData* data)
{
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	FontManagerMainWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = font_manager_get_default_application ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->priv->_main_window;
	_tmp3_ = font_manager_main_window_progress_update (_tmp2_, data);
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gboolean
___lambda221__font_manager_progress_callback (FontManagerProgressData* data)
{
	gboolean result;
	result = __lambda221_ (data);
	return result;
}

static void
font_manager_application_real_activate (GApplication* base)
{
	FontManagerApplication * self;
	FontManagerMainWindow* _tmp0_;
	FontManagerDatabaseProxy* _tmp8_;
	FontManagerDatabaseProxy* _tmp9_;
	self = (FontManagerApplication*) base;
	_tmp0_ = self->priv->_main_window;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_;
		FontManagerMainWindow* _tmp2_;
		FontManagerMainWindow* _tmp3_;
		FontManagerMainWindow* _tmp4_;
		FontManagerMainWindow* _tmp5_;
		GBindingFlags flags = 0U;
		FontManagerMainWindow* _tmp6_;
		FontManagerMainWindow* _tmp7_;
		_tmp1_ = self->priv->_settings;
		_tmp2_ = font_manager_main_window_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		font_manager_application_set_main_window (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
		_tmp4_ = self->priv->_main_window;
		gtk_window_present ((GtkWindow*) _tmp4_);
		_tmp5_ = self->priv->_main_window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp5_);
		flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
		_tmp6_ = self->priv->_main_window;
		g_object_bind_property_with_closures ((GObject*) self, "available-fonts", (GObject*) _tmp6_, "available-fonts", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp7_ = self->priv->_main_window;
		g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp7_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	}
	_tmp8_ = self->priv->_db;
	g_signal_connect_object (_tmp8_, "update-complete", (GCallback) ___lambda219__font_manager_database_proxy_update_complete, self, 0);
	_tmp9_ = self->priv->_db;
	font_manager_database_proxy_set_progress_callback (_tmp9_, ___lambda221__font_manager_progress_callback);
	font_manager_application_reload (self);
	return;
}

static gboolean
font_manager_application_real_dbus_register (GApplication* base,
                                             GDBusConnection* conn,
                                             const gchar* path,
                                             GError** error)
{
	FontManagerApplication * self;
	gboolean _result_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp2_;
	FontManagerSearchProvider* _tmp4_;
	FontManagerSearchProvider* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FontManagerApplication*) base;
	g_return_val_if_fail (conn != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_result_ = G_APPLICATION_CLASS (font_manager_application_parent_class)->dbus_register ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), conn, path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp0_;
	}
	_tmp2_ = font_manager_application_register_object (self, conn, FONT_MANAGER_BUS_PATH, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	self->priv->dbus_id = _tmp1_;
	if (self->priv->dbus_id == ((guint) 0)) {
		g_critical ("Application.vala:365: Could not register Font Manager service ");
	}
	_tmp4_ = self->priv->gs_search_provider;
	if (_tmp4_ == NULL) {
		FontManagerSearchProvider* _tmp5_;
		_tmp5_ = font_manager_search_provider_new ();
		_g_object_unref0 (self->priv->gs_search_provider);
		self->priv->gs_search_provider = _tmp5_;
	}
	_tmp6_ = self->priv->gs_search_provider;
	font_manager_search_provider_dbus_register (_tmp6_, conn);
	result = _result_;
	return result;
}

static void
font_manager_application_real_dbus_unregister (GApplication* base,
                                               GDBusConnection* conn,
                                               const gchar* path)
{
	FontManagerApplication * self;
	FontManagerSearchProvider* _tmp0_;
	self = (FontManagerApplication*) base;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (path != NULL);
	if (self->priv->dbus_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (conn, self->priv->dbus_id);
	}
	_tmp0_ = self->priv->gs_search_provider;
	font_manager_search_provider_dbus_unregister (_tmp0_, conn);
	G_APPLICATION_CLASS (font_manager_application_parent_class)->dbus_unregister ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), conn, path);
	return;
}

static void
font_manager_application_set_debug_level (gchar** args,
                                          gint args_length1)
{
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = args;
		arg_collection_length1 = args_length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			gchar* _tmp0_;
			gchar* arg = NULL;
			_tmp0_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp0_;
			{
				const gchar* _tmp1_;
				FILE* _tmp2_;
				_tmp1_ = arg;
				if (!string_contains (_tmp1_, "debug")) {
					_g_free0 (arg);
					continue;
				}
				g_setenv ("G_MESSAGES_DEBUG", "[font-manager]", TRUE);
				_tmp2_ = stdout;
				fprintf (_tmp2_, "\n%s %s\n\n", DISPLAY_NAME, PACKAGE_VERSION);
				font_manager_print_os_info ();
				font_manager_print_library_versions ();
				_g_free0 (arg);
				break;
			}
		}
	}
	return;
}

static gint
font_manager_application_main (gchar** args,
                               gint args_length1)
{
	GApplicationFlags FLAGS = 0U;
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	font_manager_setup_i18n ();
	font_manager_application_set_debug_level (args, (gint) args_length1);
	g_set_application_name (DISPLAY_NAME);
	FLAGS = G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE;
	_tmp0_ = font_manager_application_new (FONT_MANAGER_BUS_ID, FLAGS);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return font_manager_application_main (argv, argc);
}

gboolean
font_manager_application_get_update_in_progress (FontManagerApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_update_in_progress;
	return result;
}

static void
font_manager_application_set_update_in_progress (FontManagerApplication* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_application_get_update_in_progress (self);
	if (old_value != value) {
		self->priv->_update_in_progress = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_application_properties[FONT_MANAGER_APPLICATION_UPDATE_IN_PROGRESS_PROPERTY]);
	}
}

GSettings*
font_manager_application_get_settings (FontManagerApplication* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
font_manager_application_set_settings (FontManagerApplication* self,
                                       GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_application_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_application_properties[FONT_MANAGER_APPLICATION_SETTINGS_PROPERTY]);
	}
}

JsonArray*
font_manager_application_get_available_fonts (FontManagerApplication* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_fonts;
	result = _tmp0_;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

void
font_manager_application_set_available_fonts (FontManagerApplication* self,
                                              JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_application_get_available_fonts (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_available_fonts);
		self->priv->_available_fonts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_application_properties[FONT_MANAGER_APPLICATION_AVAILABLE_FONTS_PROPERTY]);
	}
}

FontManagerMainWindow*
font_manager_application_get_main_window (FontManagerApplication* self)
{
	FontManagerMainWindow* result;
	FontManagerMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}

static void
font_manager_application_set_main_window (FontManagerApplication* self,
                                          FontManagerMainWindow* value)
{
	FontManagerMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_application_get_main_window (self);
	if (old_value != value) {
		FontManagerMainWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_main_window);
		self->priv->_main_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_application_properties[FONT_MANAGER_APPLICATION_MAIN_WINDOW_PROPERTY]);
	}
}

FontManagerDatabaseProxy*
font_manager_application_get_db (FontManagerApplication* self)
{
	FontManagerDatabaseProxy* result;
	FontManagerDatabaseProxy* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_db;
	result = _tmp0_;
	return result;
}

static void
font_manager_application_set_db (FontManagerApplication* self,
                                 FontManagerDatabaseProxy* value)
{
	FontManagerDatabaseProxy* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_application_get_db (self);
	if (old_value != value) {
		FontManagerDatabaseProxy* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_db);
		self->priv->_db = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_application_properties[FONT_MANAGER_APPLICATION_DB_PROPERTY]);
	}
}

FontManagerReject*
font_manager_application_get_disabled_families (FontManagerApplication* self)
{
	FontManagerReject* result;
	FontManagerReject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_families;
	result = _tmp0_;
	return result;
}

static void
font_manager_application_set_disabled_families (FontManagerApplication* self,
                                                FontManagerReject* value)
{
	FontManagerReject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_application_get_disabled_families (self);
	if (old_value != value) {
		FontManagerReject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled_families);
		self->priv->_disabled_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_application_properties[FONT_MANAGER_APPLICATION_DISABLED_FAMILIES_PROPERTY]);
	}
}

static void
font_manager_application_class_init (FontManagerApplicationClass * klass,
                                     gpointer klass_data)
{
	font_manager_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) font_manager_application_real_startup;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) font_manager_application_real_open;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) font_manager_application_real_command_line;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) font_manager_application_real_handle_local_options;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) font_manager_application_real_activate;
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) font_manager_application_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) font_manager_application_real_dbus_unregister;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_APPLICATION_UPDATE_IN_PROGRESS_PROPERTY, font_manager_application_properties[FONT_MANAGER_APPLICATION_UPDATE_IN_PROGRESS_PROPERTY] = g_param_spec_boolean ("update-in-progress", "update-in-progress", "update-in-progress", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_APPLICATION_SETTINGS_PROPERTY, font_manager_application_properties[FONT_MANAGER_APPLICATION_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_APPLICATION_AVAILABLE_FONTS_PROPERTY, font_manager_application_properties[FONT_MANAGER_APPLICATION_AVAILABLE_FONTS_PROPERTY] = g_param_spec_boxed ("available-fonts", "available-fonts", "available-fonts", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_APPLICATION_MAIN_WINDOW_PROPERTY, font_manager_application_properties[FONT_MANAGER_APPLICATION_MAIN_WINDOW_PROPERTY] = g_param_spec_object ("main-window", "main-window", "main-window", FONT_MANAGER_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_APPLICATION_DB_PROPERTY, font_manager_application_properties[FONT_MANAGER_APPLICATION_DB_PROPERTY] = g_param_spec_object ("db", "db", "db", FONT_MANAGER_TYPE_DATABASE_PROXY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_APPLICATION_DISABLED_FAMILIES_PROPERTY, font_manager_application_properties[FONT_MANAGER_APPLICATION_DISABLED_FAMILIES_PROPERTY] = g_param_spec_object ("disabled-families", "disabled-families", "disabled-families", font_manager_reject_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_application_instance_init (FontManagerApplication * self,
                                        gpointer klass)
{
	FontManagerDatabaseProxy* _tmp0_;
	FontManagerReject* _tmp1_;
	self->priv = font_manager_application_get_instance_private (self);
	self->priv->_update_in_progress = FALSE;
	self->priv->_settings = NULL;
	self->priv->_available_fonts = NULL;
	self->priv->_main_window = NULL;
	_tmp0_ = font_manager_database_proxy_new ();
	self->priv->_db = _tmp0_;
	_tmp1_ = font_manager_reject_new ();
	self->priv->_disabled_families = _tmp1_;
	self->priv->dbus_id = (guint) 0;
	self->priv->gs_search_provider = NULL;
}

static void
font_manager_application_finalize (GObject * obj)
{
	FontManagerApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication);
	font_manager_free_gsettings ();
	_g_object_unref0 (self->priv->_settings);
	_json_array_unref0 (self->priv->_available_fonts);
	_g_object_unref0 (self->priv->_main_window);
	_g_object_unref0 (self->priv->_db);
	_g_object_unref0 (self->priv->_disabled_families);
	_g_object_unref0 (self->priv->gs_search_provider);
	G_OBJECT_CLASS (font_manager_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerApplication), 0, (GInstanceInitFunc) font_manager_application_instance_init, NULL };
	GType font_manager_application_type_id;
	font_manager_application_type_id = g_type_register_static (gtk_application_get_type (), "FontManagerApplication", &g_define_type_info, 0);
	g_type_set_qdata (font_manager_application_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) font_manager_application_register_object);
	FontManagerApplication_private_offset = g_type_add_instance_private (font_manager_application_type_id, sizeof (FontManagerApplicationPrivate));
	return font_manager_application_type_id;
}

GType
font_manager_application_get_type (void)
{
	static volatile gsize font_manager_application_type_id__once = 0;
	if (g_once_init_enter (&font_manager_application_type_id__once)) {
		GType font_manager_application_type_id;
		font_manager_application_type_id = font_manager_application_get_type_once ();
		g_once_init_leave (&font_manager_application_type_id__once, font_manager_application_type_id);
	}
	return font_manager_application_type_id__once;
}

static void
_vala_font_manager_application_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication);
	switch (property_id) {
		case FONT_MANAGER_APPLICATION_UPDATE_IN_PROGRESS_PROPERTY:
		g_value_set_boolean (value, font_manager_application_get_update_in_progress (self));
		break;
		case FONT_MANAGER_APPLICATION_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_application_get_settings (self));
		break;
		case FONT_MANAGER_APPLICATION_AVAILABLE_FONTS_PROPERTY:
		g_value_set_boxed (value, font_manager_application_get_available_fonts (self));
		break;
		case FONT_MANAGER_APPLICATION_MAIN_WINDOW_PROPERTY:
		g_value_set_object (value, font_manager_application_get_main_window (self));
		break;
		case FONT_MANAGER_APPLICATION_DB_PROPERTY:
		g_value_set_object (value, font_manager_application_get_db (self));
		break;
		case FONT_MANAGER_APPLICATION_DISABLED_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_application_get_disabled_families (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_application_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication);
	switch (property_id) {
		case FONT_MANAGER_APPLICATION_UPDATE_IN_PROGRESS_PROPERTY:
		font_manager_application_set_update_in_progress (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_APPLICATION_SETTINGS_PROPERTY:
		font_manager_application_set_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_APPLICATION_AVAILABLE_FONTS_PROPERTY:
		font_manager_application_set_available_fonts (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_APPLICATION_MAIN_WINDOW_PROPERTY:
		font_manager_application_set_main_window (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_APPLICATION_DB_PROPERTY:
		font_manager_application_set_db (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_APPLICATION_DISABLED_FAMILIES_PROPERTY:
		font_manager_application_set_disabled_families (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_font_manager_application_list (FontManagerApplication* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = font_manager_application_list (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_font_manager_application_list_full (FontManagerApplication* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = font_manager_application_list_full (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_font_manager_application_enable (FontManagerApplication* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** families = NULL;
	gint families_length1 = 0;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	families_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	families = _tmp1_;
	g_variant_unref (_tmp0_);
	font_manager_application_enable (self, families, families_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	families = (_vala_array_free (families, families_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_font_manager_application_disable (FontManagerApplication* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** families = NULL;
	gint families_length1 = 0;
	GVariant* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length;
	gint _tmp5__size;
	gint _tmp5__length1;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp5_ = g_new (gchar*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	g_variant_iter_init (&_tmp6_, _tmp4_);
	for (; (_tmp7_ = g_variant_iter_next_value (&_tmp6_)) != NULL; _tmp5__length1++) {
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (gchar*, _tmp5_, _tmp5__size + 1);
		}
		_tmp5_[_tmp5__length++] = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
	}
	families_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	families = _tmp5_;
	g_variant_unref (_tmp4_);
	font_manager_application_disable (self, families, families_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	families = (_vala_array_free (families, families_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_font_manager_application_install (FontManagerApplication* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** filepaths = NULL;
	gint filepaths_length1 = 0;
	GVariant* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length;
	gint _tmp9__size;
	gint _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (gchar*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (gchar*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_dup_string (_tmp11_, NULL);
		g_variant_unref (_tmp11_);
	}
	filepaths_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	filepaths = _tmp9_;
	g_variant_unref (_tmp8_);
	font_manager_application_install (self, filepaths, filepaths_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	filepaths = (_vala_array_free (filepaths, filepaths_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_font_manager_application_search (FontManagerApplication* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* needle = NULL;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	needle = g_variant_dup_string (_tmp12_, NULL);
	g_variant_unref (_tmp12_);
	font_manager_application_search (self, needle, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (needle);
	;
}

static void
font_manager_application_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "List") == 0) {
		_dbus_font_manager_application_list (object, parameters, invocation);
	} else if (strcmp (method_name, "ListFull") == 0) {
		_dbus_font_manager_application_list_full (object, parameters, invocation);
	} else if (strcmp (method_name, "Enable") == 0) {
		_dbus_font_manager_application_enable (object, parameters, invocation);
	} else if (strcmp (method_name, "Disable") == 0) {
		_dbus_font_manager_application_disable (object, parameters, invocation);
	} else if (strcmp (method_name, "Install") == 0) {
		_dbus_font_manager_application_install (object, parameters, invocation);
	} else if (strcmp (method_name, "Search") == 0) {
		_dbus_font_manager_application_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
font_manager_application_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
font_manager_application_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
font_manager_application_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_font_manager_application_dbus_interface_info), &_font_manager_application_dbus_interface_vtable, data, _font_manager_application_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_font_manager_application_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

