/* main_window_documents.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from main_window_documents.vala, do not modify */

/* SPDX-FileCopyrightText: 2012, 2015, 2017 Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtex.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;
typedef struct _MainWindowDocumentsPrivate MainWindowDocumentsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _ParamSpecMainWindowDocuments ParamSpecMainWindowDocuments;

struct _MainWindowDocuments {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowDocumentsPrivate * priv;
};

struct _MainWindowDocumentsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowDocuments *self);
};

struct _MainWindowDocumentsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	DocumentsPanel* _documents_panel;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _list_action_group;
	guint _list_id;
};

struct _ParamSpecMainWindowDocuments {
	GParamSpec parent_instance;
};

static gint MainWindowDocuments_private_offset;
static gpointer main_window_documents_parent_class = NULL;

VALA_EXTERN gpointer main_window_documents_ref (gpointer instance);
VALA_EXTERN void main_window_documents_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_documents (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_main_window_documents (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_main_window_documents (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_documents (const GValue* value);
VALA_EXTERN GType main_window_documents_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowDocuments, main_window_documents_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType documents_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentsPanel, g_object_unref)
VALA_EXTERN void main_window_documents_on_save_all (MainWindowDocuments* self);
static void _main_window_documents_on_save_all_gcallback (GtkAction* action,
                                                   gpointer self);
VALA_EXTERN void main_window_documents_on_close_all (MainWindowDocuments* self);
static void _main_window_documents_on_close_all_gcallback (GtkAction* action,
                                                    gpointer self);
VALA_EXTERN void main_window_documents_on_previous (MainWindowDocuments* self);
static void _main_window_documents_on_previous_gcallback (GtkAction* action,
                                                   gpointer self);
VALA_EXTERN void main_window_documents_on_next (MainWindowDocuments* self);
static void _main_window_documents_on_next_gcallback (GtkAction* action,
                                               gpointer self);
VALA_EXTERN void main_window_documents_on_move_to_new_window (MainWindowDocuments* self);
static void _main_window_documents_on_move_to_new_window_gcallback (GtkAction* action,
                                                             gpointer self);
VALA_EXTERN MainWindowDocuments* main_window_documents_new (MainWindow* main_window,
                                                GtkUIManager* ui_manager);
VALA_EXTERN MainWindowDocuments* main_window_documents_construct (GType object_type,
                                                      MainWindow* main_window,
                                                      GtkUIManager* ui_manager);
VALA_EXTERN void main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                                DocumentsPanel* documents_panel);
static void main_window_documents_connect_signals (MainWindowDocuments* self);
static void main_window_documents_update_sensitivity (MainWindowDocuments* self);
static void __lambda43_ (MainWindowDocuments* self);
static void main_window_documents_update_documents_list (MainWindowDocuments* self);
static void ___lambda43__gtk_notebook_page_reordered (GtkNotebook* _sender,
                                               GtkWidget* child,
                                               guint page_num,
                                               gpointer self);
static void __lambda44_ (MainWindowDocuments* self,
                  GtkWidget* pg,
                  guint page_num);
static void main_window_documents_set_active_document (MainWindowDocuments* self,
                                                guint doc_num);
static void ___lambda44__gtk_notebook_switch_page (GtkNotebook* _sender,
                                            GtkWidget* page,
                                            guint page_num,
                                            gpointer self);
static void __lambda45_ (MainWindowDocuments* self);
static void ___lambda45__gtk_notebook_page_removed (GtkNotebook* _sender,
                                             GtkWidget* child,
                                             guint page_num,
                                             gpointer self);
static void __lambda46_ (MainWindowDocuments* self);
static void ___lambda46__gtk_notebook_page_added (GtkNotebook* _sender,
                                           GtkWidget* child,
                                           guint page_num,
                                           gpointer self);
static void main_window_documents_list_action_activate (MainWindowDocuments* self,
                                                 GtkAction* action);
static void _main_window_documents_list_action_activate_gtk_action_activate (GtkAction* _sender,
                                                                      gpointer self);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
static gchar* main_window_documents_get_list_action_name (MainWindowDocuments* self,
                                                   guint doc_num);
VALA_EXTERN gchar* document_tab_get_menu_tip (DocumentTab* self);
VALA_EXTERN DocumentTab* main_window_get_active_tab (MainWindow* self);
VALA_EXTERN void main_window_documents_update_document_name (MainWindowDocuments* self,
                                                 DocumentTab* tab);
static void main_window_documents_update_next_prev_doc_sensitivity (MainWindowDocuments* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GeeList* main_window_get_unsaved_documents (MainWindow* self);
VALA_EXTERN void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
VALA_EXTERN gboolean main_window_close_all_documents (MainWindow* self);
VALA_EXTERN GType glatex_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
VALA_EXTERN GlatexApp* glatex_app_get_instance (void);
VALA_EXTERN MainWindow* glatex_app_create_window (GlatexApp* self);
VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
VALA_EXTERN DocumentView* document_tab_get_document_view (DocumentTab* self);
VALA_EXTERN void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
VALA_EXTERN void main_window_create_tab_with_view (MainWindow* self,
                                       DocumentView* view);
static void main_window_documents_finalize (MainWindowDocuments * obj);
static GType main_window_documents_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GtkActionEntry MAIN_WINDOW_DOCUMENTS__action_entries[6] = {{"Documents", NULL, N_ ("_Documents")}, {"DocumentsSaveAll", "document-save", N_ ("_Save All"), "<Shift><Control>L", N_ ("Save all open files"), (GCallback) _main_window_documents_on_save_all_gcallback}, {"DocumentsCloseAll", "window-close", N_ ("_Close All"), "<Shift><Control>W", N_ ("Close all open files"), (GCallback) _main_window_documents_on_close_all_gcallback}, {"DocumentsPrevious", "go-previous", N_ ("_Previous Document"), "<Control>Page_Up", N_ ("Activate previous document"), (GCallback) _main_window_documents_on_previous_gcallback}, {"DocumentsNext", "go-next", N_ ("_Next Document"), "<Control>Page_Down", N_ ("Activate next document"), (GCallback) _main_window_documents_on_next_gcallback}, {"DocumentsMoveToNewWindow", NULL, N_ ("_Move to New Window"), NULL, N_ ("Move the current document to a new window"), (GCallback) _main_window_documents_on_move_to_new_window_gcallback}};

static inline gpointer
main_window_documents_get_instance_private (MainWindowDocuments* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindowDocuments_private_offset);
}

static void
_main_window_documents_on_save_all_gcallback (GtkAction* action,
                                              gpointer self)
{
	main_window_documents_on_save_all ((MainWindowDocuments*) self);
}

static void
_main_window_documents_on_close_all_gcallback (GtkAction* action,
                                               gpointer self)
{
	main_window_documents_on_close_all ((MainWindowDocuments*) self);
}

static void
_main_window_documents_on_previous_gcallback (GtkAction* action,
                                              gpointer self)
{
	main_window_documents_on_previous ((MainWindowDocuments*) self);
}

static void
_main_window_documents_on_next_gcallback (GtkAction* action,
                                          gpointer self)
{
	main_window_documents_on_next ((MainWindowDocuments*) self);
}

static void
_main_window_documents_on_move_to_new_window_gcallback (GtkAction* action,
                                                        gpointer self)
{
	main_window_documents_on_move_to_new_window ((MainWindowDocuments*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MainWindowDocuments*
main_window_documents_construct (GType object_type,
                                 MainWindow* main_window,
                                 GtkUIManager* ui_manager)
{
	MainWindowDocuments* self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkActionGroup* _tmp6_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowDocuments*) g_type_create_instance (object_type);
	self->priv->_main_window = main_window;
	_tmp0_ = _g_object_ref0 (ui_manager);
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp0_;
	_tmp1_ = gtk_action_group_new ("DocumentsMenuActionGroup");
	_g_object_unref0 (self->priv->_static_action_group);
	self->priv->_static_action_group = _tmp1_;
	_tmp2_ = self->priv->_static_action_group;
	gtk_action_group_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
	_tmp3_ = self->priv->_static_action_group;
	gtk_action_group_add_actions (_tmp3_, MAIN_WINDOW_DOCUMENTS__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_DOCUMENTS__action_entries), self);
	_tmp4_ = self->priv->_static_action_group;
	gtk_ui_manager_insert_action_group (ui_manager, _tmp4_, 0);
	_tmp5_ = gtk_action_group_new ("DocumentsListActionGroup");
	_g_object_unref0 (self->priv->_list_action_group);
	self->priv->_list_action_group = _tmp5_;
	_tmp6_ = self->priv->_list_action_group;
	gtk_ui_manager_insert_action_group (ui_manager, _tmp6_, 0);
	return self;
}

MainWindowDocuments*
main_window_documents_new (MainWindow* main_window,
                           GtkUIManager* ui_manager)
{
	return main_window_documents_construct (TYPE_MAIN_WINDOW_DOCUMENTS, main_window, ui_manager);
}

void
main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                           DocumentsPanel* documents_panel)
{
	DocumentsPanel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (documents_panel != NULL);
	_tmp0_ = _g_object_ref0 (documents_panel);
	_g_object_unref0 (self->priv->_documents_panel);
	self->priv->_documents_panel = _tmp0_;
	main_window_documents_connect_signals (self);
	main_window_documents_update_sensitivity (self);
}

static void
__lambda43_ (MainWindowDocuments* self)
{
	main_window_documents_update_sensitivity (self);
	main_window_documents_update_documents_list (self);
}

static void
___lambda43__gtk_notebook_page_reordered (GtkNotebook* _sender,
                                          GtkWidget* child,
                                          guint page_num,
                                          gpointer self)
{
	__lambda43_ ((MainWindowDocuments*) self);
}

static void
__lambda44_ (MainWindowDocuments* self,
             GtkWidget* pg,
             guint page_num)
{
	g_return_if_fail (pg != NULL);
	main_window_documents_set_active_document (self, page_num);
	main_window_documents_update_sensitivity (self);
}

static void
___lambda44__gtk_notebook_switch_page (GtkNotebook* _sender,
                                       GtkWidget* page,
                                       guint page_num,
                                       gpointer self)
{
	__lambda44_ ((MainWindowDocuments*) self, page, page_num);
}

static void
__lambda45_ (MainWindowDocuments* self)
{
	main_window_documents_update_documents_list (self);
	main_window_documents_update_sensitivity (self);
}

static void
___lambda45__gtk_notebook_page_removed (GtkNotebook* _sender,
                                        GtkWidget* child,
                                        guint page_num,
                                        gpointer self)
{
	__lambda45_ ((MainWindowDocuments*) self);
}

static void
__lambda46_ (MainWindowDocuments* self)
{
	main_window_documents_update_documents_list (self);
	main_window_documents_update_sensitivity (self);
}

static void
___lambda46__gtk_notebook_page_added (GtkNotebook* _sender,
                                      GtkWidget* child,
                                      guint page_num,
                                      gpointer self)
{
	__lambda46_ ((MainWindowDocuments*) self);
}

static void
main_window_documents_connect_signals (MainWindowDocuments* self)
{
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	DocumentsPanel* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_documents_panel;
	g_signal_connect_after ((GtkNotebook*) _tmp1_, "page-reordered", (GCallback) ___lambda43__gtk_notebook_page_reordered, self);
	_tmp2_ = self->priv->_documents_panel;
	g_signal_connect_after ((GtkNotebook*) _tmp2_, "switch-page", (GCallback) ___lambda44__gtk_notebook_switch_page, self);
	_tmp3_ = self->priv->_documents_panel;
	g_signal_connect_after ((GtkNotebook*) _tmp3_, "page-removed", (GCallback) ___lambda45__gtk_notebook_page_removed, self);
	_tmp4_ = self->priv->_documents_panel;
	g_signal_connect_after ((GtkNotebook*) _tmp4_, "page-added", (GCallback) ___lambda46__gtk_notebook_page_added, self);
}

static void
_main_window_documents_list_action_activate_gtk_action_activate (GtkAction* _sender,
                                                                 gpointer self)
{
	main_window_documents_list_action_activate ((MainWindowDocuments*) self, _sender);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
main_window_documents_update_documents_list (MainWindowDocuments* self)
{
	GtkActionGroup* _tmp0_;
	DocumentsPanel* _tmp1_;
	GtkActionGroup* _tmp3_;
	GList* _tmp4_;
	gint nb_docs = 0;
	DocumentsPanel* _tmp10_;
	GtkUIManager* _tmp11_;
	GSList* group = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list_action_group;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp1_ != NULL);
	if (self->priv->_list_id != ((guint) 0)) {
		GtkUIManager* _tmp2_;
		_tmp2_ = self->priv->_ui_manager;
		gtk_ui_manager_remove_ui (_tmp2_, self->priv->_list_id);
	}
	_tmp3_ = self->priv->_list_action_group;
	_tmp4_ = gtk_action_group_list_actions (_tmp3_);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp4_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp5_;
			GtkAction* action = NULL;
			_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp5_;
			{
				GtkAction* _tmp6_;
				guint _tmp7_;
				GtkActionGroup* _tmp8_;
				GtkAction* _tmp9_;
				_tmp6_ = action;
				g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp7_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
				_tmp8_ = self->priv->_list_action_group;
				_tmp9_ = action;
				gtk_action_group_remove_action (_tmp8_, _tmp9_);
				_g_object_unref0 (action);
			}
		}
		(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
	}
	self->priv->_list_id = (guint) 0;
	_tmp10_ = self->priv->_documents_panel;
	nb_docs = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp10_);
	if (nb_docs == 0) {
		return;
	}
	_tmp11_ = self->priv->_ui_manager;
	self->priv->_list_id = gtk_ui_manager_new_merge_id (_tmp11_);
	group = NULL;
	{
		gint doc_num = 0;
		doc_num = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp14_;
				GtkWidget* _tmp15_;
				DocumentTab* _tmp16_;
				gchar* action_name = NULL;
				gchar* _tmp17_;
				gchar* name = NULL;
				DocumentTab* _tmp18_;
				TeplBuffer* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* tip = NULL;
				DocumentTab* _tmp24_;
				gchar* _tmp25_;
				gchar* accel = NULL;
				GtkRadioAction* action = NULL;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				GtkRadioAction* _tmp30_;
				GSList* _tmp31_;
				GtkRadioAction* _tmp34_;
				GSList* _tmp35_;
				GtkActionGroup* _tmp36_;
				GtkRadioAction* _tmp37_;
				const gchar* _tmp38_;
				GtkRadioAction* _tmp39_;
				GtkUIManager* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				DocumentTab* _tmp43_;
				MainWindow* _tmp44_;
				DocumentTab* _tmp45_;
				DocumentTab* _tmp46_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = doc_num;
					doc_num = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(doc_num < nb_docs)) {
					break;
				}
				_tmp14_ = self->priv->_documents_panel;
				_tmp15_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp14_, doc_num);
				_tmp16_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp15_) ? ((DocumentTab*) _tmp15_) : NULL);
				tab = _tmp16_;
				_tmp17_ = main_window_documents_get_list_action_name (self, (guint) doc_num);
				action_name = _tmp17_;
				_tmp18_ = tab;
				_tmp19_ = tepl_tab_get_buffer ((TeplTab*) _tmp18_);
				_tmp20_ = tepl_buffer_get_short_title (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_replace (_tmp21_, "_", "__");
				_tmp23_ = _tmp22_;
				_g_free0 (_tmp21_);
				name = _tmp23_;
				_tmp24_ = tab;
				_tmp25_ = document_tab_get_menu_tip (_tmp24_);
				tip = _tmp25_;
				accel = NULL;
				if (doc_num < 10) {
					gchar* _tmp26_;
					_tmp26_ = g_strdup_printf ("<alt>%d", (doc_num + 1) % 10);
					_g_free0 (accel);
					accel = _tmp26_;
				}
				_tmp27_ = action_name;
				_tmp28_ = name;
				_tmp29_ = tip;
				_tmp30_ = gtk_radio_action_new (_tmp27_, _tmp28_, _tmp29_, NULL, doc_num);
				action = _tmp30_;
				_tmp31_ = group;
				if (_tmp31_ != NULL) {
					GtkRadioAction* _tmp32_;
					GSList* _tmp33_;
					_tmp32_ = action;
					_tmp33_ = group;
					gtk_radio_action_set_group (_tmp32_, _tmp33_);
				}
				_tmp34_ = action;
				_tmp35_ = gtk_radio_action_get_group (_tmp34_);
				group = _tmp35_;
				_tmp36_ = self->priv->_list_action_group;
				_tmp37_ = action;
				_tmp38_ = accel;
				gtk_action_group_add_action_with_accel (_tmp36_, (GtkAction*) _tmp37_, _tmp38_);
				_tmp39_ = action;
				g_signal_connect ((GtkAction*) _tmp39_, "activate", (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
				_tmp40_ = self->priv->_ui_manager;
				_tmp41_ = action_name;
				_tmp42_ = action_name;
				gtk_ui_manager_add_ui (_tmp40_, self->priv->_list_id, "/MainMenu/DocumentsMenu/DocumentsListPlaceholder", _tmp41_, _tmp42_, GTK_UI_MANAGER_MENUITEM, FALSE);
				_tmp43_ = tab;
				_tmp44_ = self->priv->_main_window;
				_tmp45_ = main_window_get_active_tab (_tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp43_ == _tmp46_) {
					GtkRadioAction* _tmp47_;
					_tmp47_ = action;
					gtk_toggle_action_set_active ((GtkToggleAction*) _tmp47_, TRUE);
				}
				_g_object_unref0 (action);
				_g_free0 (accel);
				_g_free0 (tip);
				_g_free0 (name);
				_g_free0 (action_name);
				_g_object_unref0 (tab);
			}
		}
	}
}

static void
main_window_documents_set_active_document (MainWindowDocuments* self,
                                           guint doc_num)
{
	gchar* action_name = NULL;
	gchar* _tmp0_;
	GtkRadioAction* action = NULL;
	GtkActionGroup* _tmp1_;
	const gchar* _tmp2_;
	GtkAction* _tmp3_;
	GtkRadioAction* _tmp4_;
	GtkRadioAction* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_documents_get_list_action_name (self, doc_num);
	action_name = _tmp0_;
	_tmp1_ = self->priv->_list_action_group;
	_tmp2_ = action_name;
	_tmp3_ = gtk_action_group_get_action (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) _tmp3_) : NULL);
	action = _tmp4_;
	_tmp5_ = action;
	if (_tmp5_ != NULL) {
		GtkRadioAction* _tmp6_;
		guint _tmp7_;
		GtkRadioAction* _tmp8_;
		GtkRadioAction* _tmp9_;
		_tmp6_ = action;
		g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkAction*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
		_tmp8_ = action;
		gtk_toggle_action_set_active ((GtkToggleAction*) _tmp8_, TRUE);
		_tmp9_ = action;
		g_signal_connect ((GtkAction*) _tmp9_, "activate", (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
	}
	_g_object_unref0 (action);
	_g_free0 (action_name);
}

void
main_window_documents_update_document_name (MainWindowDocuments* self,
                                            DocumentTab* tab)
{
	DocumentsPanel* _tmp0_;
	gint doc_num = 0;
	DocumentsPanel* _tmp1_;
	gchar* action_name = NULL;
	gchar* _tmp2_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp3_;
	GtkAction* _tmp4_;
	GtkAction* _tmp5_;
	TeplBuffer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_documents_panel;
	doc_num = gtk_notebook_page_num ((GtkNotebook*) _tmp1_, (GtkWidget*) tab);
	_tmp2_ = main_window_documents_get_list_action_name (self, (guint) doc_num);
	action_name = _tmp2_;
	_tmp3_ = self->priv->_list_action_group;
	_tmp4_ = gtk_action_group_get_action (_tmp3_, action_name);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	action = _tmp5_;
	g_return_if_fail (action != NULL);
	_tmp6_ = tepl_tab_get_buffer ((TeplTab*) tab);
	_tmp7_ = tepl_buffer_get_short_title (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_replace (_tmp8_, "_", "__");
	_tmp10_ = _tmp9_;
	gtk_action_set_label (action, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = document_tab_get_menu_tip (tab);
	_tmp12_ = _tmp11_;
	gtk_action_set_tooltip (action, _tmp12_);
	_g_free0 (_tmp12_);
	_g_object_unref0 (action);
	_g_free0 (action_name);
}

static void
main_window_documents_list_action_activate (MainWindowDocuments* self,
                                            GtkAction* action)
{
	DocumentsPanel* _tmp0_;
	GtkRadioAction* radio_action = NULL;
	GtkRadioAction* _tmp1_;
	GtkRadioAction* _tmp2_;
	DocumentsPanel* _tmp3_;
	GtkRadioAction* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (action, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) action) : NULL);
	radio_action = _tmp1_;
	_tmp2_ = radio_action;
	if (!gtk_toggle_action_get_active ((GtkToggleAction*) _tmp2_)) {
		_g_object_unref0 (radio_action);
		return;
	}
	_tmp3_ = self->priv->_documents_panel;
	_tmp4_ = radio_action;
	gtk_notebook_set_current_page ((GtkNotebook*) _tmp3_, gtk_radio_action_get_current_value (_tmp4_));
	_g_object_unref0 (radio_action);
}

static gchar*
main_window_documents_get_list_action_name (MainWindowDocuments* self,
                                            guint doc_num)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%u", doc_num);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Tab_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
main_window_documents_update_sensitivity (MainWindowDocuments* self)
{
	gboolean sensitive = FALSE;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	gchar** action_names = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint action_names_length1;
	gint _action_names_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ != NULL;
	_tmp3_ = g_strdup ("DocumentsSaveAll");
	_tmp4_ = g_strdup ("DocumentsCloseAll");
	_tmp5_ = g_strdup ("DocumentsMoveToNewWindow");
	_tmp6_ = g_new0 (gchar*, 3 + 1);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	action_names = _tmp6_;
	action_names_length1 = 3;
	_action_names_size_ = action_names_length1;
	_tmp7_ = action_names;
	_tmp7__length1 = action_names_length1;
	{
		gchar** action_name_collection = NULL;
		gint action_name_collection_length1 = 0;
		gint _action_name_collection_size_ = 0;
		gint action_name_it = 0;
		action_name_collection = _tmp7_;
		action_name_collection_length1 = _tmp7__length1;
		for (action_name_it = 0; action_name_it < action_name_collection_length1; action_name_it = action_name_it + 1) {
			gchar* _tmp8_;
			gchar* action_name = NULL;
			_tmp8_ = g_strdup (action_name_collection[action_name_it]);
			action_name = _tmp8_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp9_;
				const gchar* _tmp10_;
				GtkAction* _tmp11_;
				GtkAction* _tmp12_;
				GtkAction* _tmp13_;
				_tmp9_ = self->priv->_static_action_group;
				_tmp10_ = action_name;
				_tmp11_ = gtk_action_group_get_action (_tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				action = _tmp12_;
				_tmp13_ = action;
				gtk_action_set_sensitive (_tmp13_, sensitive);
				_g_object_unref0 (action);
				_g_free0 (action_name);
			}
		}
	}
	main_window_documents_update_next_prev_doc_sensitivity (self);
	action_names = (_vala_array_free (action_names, action_names_length1, (GDestroyNotify) g_free), NULL);
}

static void
main_window_documents_update_next_prev_doc_sensitivity (MainWindowDocuments* self)
{
	DocumentsPanel* _tmp0_;
	GtkAction* action_prev = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* action_next = NULL;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_;
	MainWindow* _tmp7_;
	DocumentTab* _tmp8_;
	DocumentTab* _tmp9_;
	gint current_page = 0;
	DocumentsPanel* _tmp12_;
	MainWindow* _tmp13_;
	DocumentTab* _tmp14_;
	DocumentTab* _tmp15_;
	GtkAction* _tmp16_;
	gint nb_pages = 0;
	DocumentsPanel* _tmp17_;
	GtkAction* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "DocumentsPrevious");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	action_prev = _tmp3_;
	_tmp4_ = self->priv->_static_action_group;
	_tmp5_ = gtk_action_group_get_action (_tmp4_, "DocumentsNext");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	action_next = _tmp6_;
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_tab (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		GtkAction* _tmp10_;
		GtkAction* _tmp11_;
		_tmp10_ = action_prev;
		gtk_action_set_sensitive (_tmp10_, FALSE);
		_tmp11_ = action_next;
		gtk_action_set_sensitive (_tmp11_, FALSE);
		_g_object_unref0 (action_next);
		_g_object_unref0 (action_prev);
		return;
	}
	_tmp12_ = self->priv->_documents_panel;
	_tmp13_ = self->priv->_main_window;
	_tmp14_ = main_window_get_active_tab (_tmp13_);
	_tmp15_ = _tmp14_;
	current_page = gtk_notebook_page_num ((GtkNotebook*) _tmp12_, (GtkWidget*) _tmp15_);
	_tmp16_ = action_prev;
	gtk_action_set_sensitive (_tmp16_, current_page > 0);
	_tmp17_ = self->priv->_documents_panel;
	nb_pages = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp17_);
	_tmp18_ = action_next;
	gtk_action_set_sensitive (_tmp18_, current_page < (nb_pages - 1));
	_g_object_unref0 (action_next);
	_g_object_unref0 (action_prev);
}

void
main_window_documents_on_save_all (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	{
		GeeList* _doc_list = NULL;
		MainWindow* _tmp3_;
		GeeList* _tmp4_;
		gint _doc_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _doc_index = 0;
		_tmp3_ = self->priv->_main_window;
		_tmp4_ = main_window_get_unsaved_documents (_tmp3_);
		_doc_list = _tmp4_;
		_tmp5_ = _doc_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_doc_size = _tmp7_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			Document* doc = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			Document* _tmp12_;
			_doc_index = _doc_index + 1;
			_tmp8_ = _doc_index;
			_tmp9_ = _doc_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _doc_list;
			_tmp11_ = gee_list_get (_tmp10_, _doc_index);
			doc = (Document*) _tmp11_;
			_tmp12_ = doc;
			document_save (_tmp12_, TRUE, FALSE);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
}

void
main_window_documents_on_close_all (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	main_window_close_all_documents (_tmp3_);
}

void
main_window_documents_on_previous (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_documents_panel;
	gtk_notebook_prev_page ((GtkNotebook*) _tmp4_);
}

void
main_window_documents_on_next (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_documents_panel;
	gtk_notebook_next_page ((GtkNotebook*) _tmp4_);
}

void
main_window_documents_on_move_to_new_window (MainWindowDocuments* self)
{
	DocumentTab* tab = NULL;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentsPanel* _tmp5_;
	MainWindow* new_window = NULL;
	GlatexApp* _tmp6_;
	GlatexApp* _tmp7_;
	MainWindow* _tmp8_;
	MainWindow* _tmp9_;
	DocumentView* view = NULL;
	DocumentTab* _tmp10_;
	DocumentView* _tmp11_;
	DocumentView* _tmp12_;
	DocumentView* _tmp13_;
	DocumentsPanel* _tmp14_;
	DocumentTab* _tmp15_;
	GtkContainer* parent = NULL;
	DocumentView* _tmp16_;
	GtkContainer* _tmp17_;
	GtkContainer* _tmp18_;
	GtkContainer* _tmp19_;
	MainWindow* _tmp22_;
	DocumentView* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tab = _tmp3_;
	_tmp4_ = tab;
	g_return_if_fail (_tmp4_ != NULL);
	_tmp5_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp5_ != NULL);
	_tmp6_ = glatex_app_get_instance ();
	_tmp7_ = _tmp6_;
	_tmp8_ = glatex_app_create_window (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	new_window = _tmp9_;
	_tmp10_ = tab;
	_tmp11_ = document_tab_get_document_view (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	view = _tmp13_;
	_tmp14_ = self->priv->_documents_panel;
	_tmp15_ = tab;
	documents_panel_remove_tab (_tmp14_, _tmp15_);
	_tmp16_ = view;
	_tmp17_ = gtk_widget_get_parent ((GtkWidget*) _tmp16_);
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer));
	parent = _tmp18_;
	_tmp19_ = parent;
	if (_tmp19_ != NULL) {
		GtkContainer* _tmp20_;
		DocumentView* _tmp21_;
		_tmp20_ = parent;
		_tmp21_ = view;
		gtk_container_remove (_tmp20_, (GtkWidget*) _tmp21_);
	}
	_tmp22_ = new_window;
	_tmp23_ = view;
	main_window_create_tab_with_view (_tmp22_, _tmp23_);
	_g_object_unref0 (parent);
	_g_object_unref0 (view);
	_g_object_unref0 (new_window);
	_g_object_unref0 (tab);
}

static void
value_main_window_documents_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_main_window_documents_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		main_window_documents_unref (value->data[0].v_pointer);
	}
}

static void
value_main_window_documents_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_documents_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_main_window_documents_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_main_window_documents_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MainWindowDocuments * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_documents_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_main_window_documents_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	MainWindowDocuments ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_documents_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_main_window_documents (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ParamSpecMainWindowDocuments* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_DOCUMENTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_main_window_documents (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_main_window_documents (GValue* value,
                                 gpointer v_object)
{
	MainWindowDocuments * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_DOCUMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_documents_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_documents_unref (old);
	}
}

void
value_take_main_window_documents (GValue* value,
                                  gpointer v_object)
{
	MainWindowDocuments * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_DOCUMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_documents_unref (old);
	}
}

static void
main_window_documents_class_init (MainWindowDocumentsClass * klass,
                                  gpointer klass_data)
{
	main_window_documents_parent_class = g_type_class_peek_parent (klass);
	((MainWindowDocumentsClass *) klass)->finalize = main_window_documents_finalize;
	g_type_class_adjust_private_offset (klass, &MainWindowDocuments_private_offset);
}

static void
main_window_documents_instance_init (MainWindowDocuments * self,
                                     gpointer klass)
{
	self->priv = main_window_documents_get_instance_private (self);
	self->ref_count = 1;
}

static void
main_window_documents_finalize (MainWindowDocuments * obj)
{
	MainWindowDocuments * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_documents_panel);
	_g_object_unref0 (self->priv->_static_action_group);
	_g_object_unref0 (self->priv->_list_action_group);
}

 G_GNUC_NO_INLINE static GType
main_window_documents_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_main_window_documents_init, value_main_window_documents_free_value, value_main_window_documents_copy_value, value_main_window_documents_peek_pointer, "p", value_main_window_documents_collect_value, "p", value_main_window_documents_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowDocumentsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_documents_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowDocuments), 0, (GInstanceInitFunc) main_window_documents_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType main_window_documents_type_id;
	main_window_documents_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowDocuments", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MainWindowDocuments_private_offset = g_type_add_instance_private (main_window_documents_type_id, sizeof (MainWindowDocumentsPrivate));
	return main_window_documents_type_id;
}

GType
main_window_documents_get_type (void)
{
	static gsize main_window_documents_type_id__once = 0;
	if (g_once_init_enter (&main_window_documents_type_id__once)) {
		GType main_window_documents_type_id;
		main_window_documents_type_id = main_window_documents_get_type_once ();
		g_once_init_leave (&main_window_documents_type_id__once, main_window_documents_type_id);
	}
	return main_window_documents_type_id__once;
}

gpointer
main_window_documents_ref (gpointer instance)
{
	MainWindowDocuments * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
main_window_documents_unref (gpointer instance)
{
	MainWindowDocuments * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_DOCUMENTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

