// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns an aggregate summary of all log groups in the Region grouped by
// specified data source characteristics. Supports optional filtering by log group
// class, name patterns, and data sources. If you perform this action in a
// monitoring account, you can also return aggregated summaries of log groups from
// source accounts that are linked to the monitoring account. For more information
// about using cross-account observability to set up monitoring accounts and source
// accounts, see [CloudWatch cross-account observability].
//
// The operation aggregates log groups by data source name and type and optionally
// format, providing counts of log groups that share these characteristics. The
// operation paginates results. By default, it returns up to 50 results and
// includes a token to retrieve more results.
//
// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
func (c *Client) ListAggregateLogGroupSummaries(ctx context.Context, params *ListAggregateLogGroupSummariesInput, optFns ...func(*Options)) (*ListAggregateLogGroupSummariesOutput, error) {
	if params == nil {
		params = &ListAggregateLogGroupSummariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAggregateLogGroupSummaries", params, optFns, c.addOperationListAggregateLogGroupSummariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAggregateLogGroupSummariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAggregateLogGroupSummariesInput struct {

	// Specifies how to group the log groups in the summary.
	//
	// This member is required.
	GroupBy types.ListAggregateLogGroupSummariesGroupBy

	// When includeLinkedAccounts is set to true , use this parameter to specify the
	// list of accounts to search. You can specify as many as 20 account IDs in the
	// array.
	AccountIdentifiers []string

	// Filters the results by data source characteristics to include only log groups
	// associated with the specified data sources.
	DataSources []types.DataSourceFilter

	// If you are using a monitoring account, set this to true to have the operation
	// return log groups in the accounts listed in accountIdentifiers .
	//
	// If this parameter is set to true and accountIdentifiers contains a null value,
	// the operation returns all log groups in the monitoring account and all log
	// groups in all source accounts that are linked to the monitoring account.
	//
	// The default for this parameter is false .
	IncludeLinkedAccounts *bool

	// The maximum number of aggregated summaries to return. If you omit this
	// parameter, the default is up to 50 aggregated summaries.
	Limit *int32

	// Filters the results by log group class to include only log groups of the
	// specified class.
	LogGroupClass types.LogGroupClass

	// Use this parameter to limit the returned log groups to only those with names
	// that match the pattern that you specify. This parameter is a regular expression
	// that can match prefixes and substrings, and supports wildcard matching and
	// matching multiple patterns, as in the following examples.
	//
	//   - Use ^ to match log group names by prefix.
	//
	//   - For a substring match, specify the string to match. All matches are case
	//   sensitive
	//
	//   - To match multiple patterns, separate them with a | as in the example
	//   ^/aws/lambda|discovery
	//
	// You can specify as many as five different regular expression patterns in this
	// field, each of which must be between 3 and 24 characters. You can include the ^
	// symbol as many as five times, and include the | symbol as many as four times.
	LogGroupNamePattern *string

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAggregateLogGroupSummariesOutput struct {

	// The list of aggregate log group summaries grouped by the specified data source
	// characteristics.
	AggregateLogGroupSummaries []types.AggregateLogGroupSummary

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAggregateLogGroupSummariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAggregateLogGroupSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAggregateLogGroupSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAggregateLogGroupSummaries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAggregateLogGroupSummariesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAggregateLogGroupSummaries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAggregateLogGroupSummariesPaginatorOptions is the paginator options for
// ListAggregateLogGroupSummaries
type ListAggregateLogGroupSummariesPaginatorOptions struct {
	// The maximum number of aggregated summaries to return. If you omit this
	// parameter, the default is up to 50 aggregated summaries.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAggregateLogGroupSummariesPaginator is a paginator for
// ListAggregateLogGroupSummaries
type ListAggregateLogGroupSummariesPaginator struct {
	options   ListAggregateLogGroupSummariesPaginatorOptions
	client    ListAggregateLogGroupSummariesAPIClient
	params    *ListAggregateLogGroupSummariesInput
	nextToken *string
	firstPage bool
}

// NewListAggregateLogGroupSummariesPaginator returns a new
// ListAggregateLogGroupSummariesPaginator
func NewListAggregateLogGroupSummariesPaginator(client ListAggregateLogGroupSummariesAPIClient, params *ListAggregateLogGroupSummariesInput, optFns ...func(*ListAggregateLogGroupSummariesPaginatorOptions)) *ListAggregateLogGroupSummariesPaginator {
	if params == nil {
		params = &ListAggregateLogGroupSummariesInput{}
	}

	options := ListAggregateLogGroupSummariesPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAggregateLogGroupSummariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAggregateLogGroupSummariesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAggregateLogGroupSummaries page.
func (p *ListAggregateLogGroupSummariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAggregateLogGroupSummariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAggregateLogGroupSummaries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAggregateLogGroupSummariesAPIClient is a client that implements the
// ListAggregateLogGroupSummaries operation.
type ListAggregateLogGroupSummariesAPIClient interface {
	ListAggregateLogGroupSummaries(context.Context, *ListAggregateLogGroupSummariesInput, ...func(*Options)) (*ListAggregateLogGroupSummariesOutput, error)
}

var _ ListAggregateLogGroupSummariesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAggregateLogGroupSummaries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAggregateLogGroupSummaries",
	}
}
