/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#pragma once

#include <QString>

class AcntId; /* Forward declaration. */

/*!
 * @brief Contains ISDS helper code used across the application.
 */
namespace IsdsHelper {

	/*!
	  * @brief Download data about logged-in user and his data box.
	  *
	  * @param[in] acntId Account identifier.
	  * @return True on success.
	  */
	bool getOwnerInfoFromLogin(const AcntId &acntId);

	/*!
	 * @brief Download data about logged-in user.
	 *
	 * @param[in] acntId Account identifier.
	 * @return True on success.
	 */
	bool getUserInfoFromLogin(const AcntId &acntId);

	/*!
	 * @brief Download information about password expiration date.
	 *
	 * @param[in] acntId Account identifier.
	 * @return True on success.
	 */
	bool getPasswordInfoFromLogin(const AcntId &acntId);

	/*!
	 * @brief Download long term storage info.
	 *
	 * @param[in] acntId Account identifier.
	 * @param[in] dbID Data box identifier.
	 * @return True on success.
	 */
	bool getDtInfo(const AcntId &acntId, const QString &dbID);
}
