/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

import (
	apisv1alpha2 "sigs.k8s.io/network-policy-api/apis/v1alpha2"
)

// ClusterNetworkPolicySpecApplyConfiguration represents a declarative configuration of the ClusterNetworkPolicySpec type for use
// with apply.
type ClusterNetworkPolicySpecApplyConfiguration struct {
	Tier     *apisv1alpha2.Tier                                  `json:"tier,omitempty"`
	Priority *int32                                              `json:"priority,omitempty"`
	Subject  *ClusterNetworkPolicySubjectApplyConfiguration      `json:"subject,omitempty"`
	Ingress  []ClusterNetworkPolicyIngressRuleApplyConfiguration `json:"ingress,omitempty"`
	Egress   []ClusterNetworkPolicyEgressRuleApplyConfiguration  `json:"egress,omitempty"`
}

// ClusterNetworkPolicySpecApplyConfiguration constructs a declarative configuration of the ClusterNetworkPolicySpec type for use with
// apply.
func ClusterNetworkPolicySpec() *ClusterNetworkPolicySpecApplyConfiguration {
	return &ClusterNetworkPolicySpecApplyConfiguration{}
}

// WithTier sets the Tier field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Tier field is set to the value of the last call.
func (b *ClusterNetworkPolicySpecApplyConfiguration) WithTier(value apisv1alpha2.Tier) *ClusterNetworkPolicySpecApplyConfiguration {
	b.Tier = &value
	return b
}

// WithPriority sets the Priority field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Priority field is set to the value of the last call.
func (b *ClusterNetworkPolicySpecApplyConfiguration) WithPriority(value int32) *ClusterNetworkPolicySpecApplyConfiguration {
	b.Priority = &value
	return b
}

// WithSubject sets the Subject field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Subject field is set to the value of the last call.
func (b *ClusterNetworkPolicySpecApplyConfiguration) WithSubject(value *ClusterNetworkPolicySubjectApplyConfiguration) *ClusterNetworkPolicySpecApplyConfiguration {
	b.Subject = value
	return b
}

// WithIngress adds the given value to the Ingress field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Ingress field.
func (b *ClusterNetworkPolicySpecApplyConfiguration) WithIngress(values ...*ClusterNetworkPolicyIngressRuleApplyConfiguration) *ClusterNetworkPolicySpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithIngress")
		}
		b.Ingress = append(b.Ingress, *values[i])
	}
	return b
}

// WithEgress adds the given value to the Egress field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Egress field.
func (b *ClusterNetworkPolicySpecApplyConfiguration) WithEgress(values ...*ClusterNetworkPolicyEgressRuleApplyConfiguration) *ClusterNetworkPolicySpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithEgress")
		}
		b.Egress = append(b.Egress, *values[i])
	}
	return b
}
