// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum kind.yaml. DO NOT EDIT.

package presence

import (
	"fmt"
	"iter"
)

// Presence represents how a field is present in a message. This generalizes
// cardinality (viz. optional or repeated).
type Kind byte

const (
	Unknown Kind = iota

	// The field is singular and presence is a distinct state; corresponds to
	// fields marked as "optional", for example.
	Explicit

	// The field is singular and presence is equivalent to the field having its
	// zero value. This corresponds to a non-message field not marked "optional"
	// in proto3, for example.
	Implicit

	// The field is not optional; it is always serialized, and an error is raised
	// if it is missing when deserializing.
	Required

	// The field is repeated: it can occur multiple times, and semantically
	// represents a list of values.
	Repeated

	// The field is part of a oneof: it is singular, and its presence is shared
	// with the other fields in the oneof (at most one of them can be present
	// at a time).
	//
	// Notably, oneof members cannot be repeated.
	Shared
)

// String implements [fmt.Stringer].
func (v Kind) String() string {
	if int(v) < 0 || int(v) > len(_table_Kind_String) {
		return fmt.Sprintf("Kind(%v)", int(v))
	}
	return _table_Kind_String[v]
}

// GoString implements [fmt.GoStringer].
func (v Kind) GoString() string {
	if int(v) < 0 || int(v) > len(_table_Kind_GoString) {
		return fmt.Sprintf("presence.Kind(%v)", int(v))
	}
	return _table_Kind_GoString[v]
}

var _table_Kind_String = [...]string{
	Unknown:  "Unknown",
	Explicit: "Explicit",
	Implicit: "Implicit",
	Required: "Required",
	Repeated: "Repeated",
	Shared:   "Shared",
}

var _table_Kind_GoString = [...]string{
	Unknown:  "presence.Unknown",
	Explicit: "presence.Explicit",
	Implicit: "presence.Implicit",
	Required: "presence.Required",
	Repeated: "presence.Repeated",
	Shared:   "presence.Shared",
}
var _ iter.Seq[int] // Mark iter as used.
