/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions;

import groovy.lang.Script;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionDispatcher;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.groovy.actions.services.GroovyActionsService;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.services.actions.ActionExecutorDispatcher;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ActionDispatcher.class})
public class GroovyActionDispatcher
implements ActionDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GroovyActionDispatcher.class.getName());
    private static final Logger GROOVY_ACTION_LOGGER = LoggerFactory.getLogger((String)"GroovyAction");
    private static final String GROOVY_PREFIX = "groovy";
    private MetricsService metricsService;
    private GroovyActionsService groovyActionsService;
    private DefinitionsService definitionsService;
    private ActionExecutorDispatcher actionExecutorDispatcher;

    @Reference
    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    @Reference
    public void setGroovyActionsService(GroovyActionsService groovyActionsService) {
        this.groovyActionsService = groovyActionsService;
    }

    @Reference
    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    @Reference
    public void setActionExecutorDispatcher(ActionExecutorDispatcher actionExecutorDispatcher) {
        this.actionExecutorDispatcher = actionExecutorDispatcher;
    }

    public String getPrefix() {
        return GROOVY_PREFIX;
    }

    public Integer execute(Action action, Event event, String actionName) {
        Class<? extends Script> scriptClass = this.groovyActionsService.getCompiledScript(actionName);
        if (scriptClass == null) {
            LOGGER.warn("Couldn't find a Groovy action with name {}, action will not execute!", (Object)actionName);
            return 0;
        }
        try {
            final Script script = scriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setScriptVariables(script, action, event);
            return (Integer)new MetricAdapter<Integer>(this.metricsService, this.getClass().getName() + ".action.groovy." + actionName){

                public Integer execute(Object ... args) throws Exception {
                    return (Integer)script.invokeMethod("execute", null);
                }
            }.runWithTimer(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error executing Groovy action with key={}", (Object)actionName, (Object)e);
            return 0;
        }
    }

    private void setScriptVariables(Script script, Action action, Event event) {
        script.setProperty("action", (Object)action);
        script.setProperty("event", (Object)event);
        script.setProperty("actionExecutorDispatcher", (Object)this.actionExecutorDispatcher);
        script.setProperty("definitionsService", (Object)this.definitionsService);
        script.setProperty("logger", (Object)GROOVY_ACTION_LOGGER);
    }
}

