/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ReaderInputStream
extends InputStream {
    private final Charset charset;
    private final Reader reader;
    private final CharBuffer inputBuffer;
    private final ByteBuffer outputBuffer;
    private final CharsetEncoder encoder;
    private int lastRead = 0;
    private boolean finished = false;

    public ReaderInputStream(Reader reader, Charset charset) throws IOException {
        this.reader = reader;
        this.charset = charset;
        this.encoder = charset.newEncoder();
        this.inputBuffer = CharBuffer.wrap(new char[1024]);
        this.inputBuffer.flip();
        this.outputBuffer = ByteBuffer.wrap(new byte[1024 * (int)this.encoder.averageBytesPerChar()]);
        this.outputBuffer.flip();
        this.readOp();
    }

    private void encodeOp() {
        if (this.lastRead == -1) {
            this.encoder.encode(this.inputBuffer, this.outputBuffer, true);
            if (CoderResult.UNDERFLOW == this.encoder.flush(this.outputBuffer)) {
                this.finished = true;
            }
        } else {
            this.encoder.encode(this.inputBuffer, this.outputBuffer, false);
        }
        this.outputBuffer.flip();
    }

    private void readOp() throws IOException {
        if (this.inputBuffer.remaining() == 0 && this.outputBuffer.remaining() == 0) {
            this.inputBuffer.clear();
            this.outputBuffer.clear();
            this.lastRead = this.reader.read(this.inputBuffer);
            this.inputBuffer.flip();
            this.encodeOp();
            return;
        }
        if (this.inputBuffer.remaining() > 0) {
            this.outputBuffer.compact();
            this.outputBuffer.flip();
            this.encodeOp();
            return;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void ensure() throws IOException {
        if (this.outputBuffer.remaining() == 0 && !this.finished) {
            this.readOp();
        }
    }

    @Override
    public int read() throws IOException {
        this.ensure();
        if (this.outputBuffer.remaining() == 0) {
            return -1;
        }
        return this.outputBuffer.get();
    }

    @Override
    public int read(byte[] ary) throws IOException {
        return this.read(ary, 0, ary.length);
    }

    @Override
    public int read(byte[] ary, int offset, int length) throws IOException {
        this.ensure();
        if (this.outputBuffer.remaining() == 0) {
            return -1;
        }
        int total = 0;
        int index = offset;
        int leftAry = length;
        while (this.outputBuffer.remaining() > 0 && leftAry > 0) {
            int toCopy = Math.min(this.outputBuffer.remaining(), leftAry);
            this.outputBuffer.get(ary, index, toCopy);
            index += toCopy;
            total += toCopy;
            if ((leftAry -= toCopy) <= 0) continue;
            this.readOp();
        }
        return total;
    }
}

