/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherStrategy
extends ServiceSupport
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcherStrategy.class);
    private CamelContext camelContext;
    private final String directory;
    private final OnChangeEvent onChangeEvent;
    private WatchService watcher;
    private ExecutorService executorService;
    private WatchFileChangesTask task;
    private long pollTimeout = 1000L;

    public FileWatcherStrategy(String directory, OnChangeEvent onChangeEvent) {
        this.directory = directory;
        this.onChangeEvent = onChangeEvent;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    protected void doStart() throws Exception {
        if (this.directory == null) {
            return;
        }
        File dir = new File(this.directory);
        if (dir.exists() && dir.isDirectory()) {
            LOG.info("Starting ReloadStrategy to watch directory: {}", (Object)dir);
            WatchEvent.Modifier modifier = null;
            String os = ObjectHelper.getSystemProperty((String)"os.name", (String)"");
            if (os.toLowerCase(Locale.US).startsWith("mac")) {
                Class clazz = this.getCamelContext().getClassResolver().resolveClass("com.sun.nio.file.SensitivityWatchEventModifier", WatchEvent.Modifier.class);
                if (clazz != null) {
                    WatchEvent.Modifier[] modifiers;
                    for (WatchEvent.Modifier mod : modifiers = (WatchEvent.Modifier[])clazz.getEnumConstants()) {
                        if (!"HIGH".equals(mod.name())) continue;
                        modifier = mod;
                        break;
                    }
                }
                if (modifier != null) {
                    LOG.info("On Mac OS X the JDK WatchService is slow by default so enabling SensitivityWatchEventModifier.HIGH as workaround");
                } else {
                    LOG.warn("On Mac OS X the JDK WatchService is slow and it may take up till 10 seconds to notice file changes");
                }
            }
            try {
                Path path = dir.toPath();
                this.watcher = path.getFileSystem().newWatchService();
                this.registerPathToWatcher(modifier, path, this.watcher);
                this.task = new WatchFileChangesTask(this.watcher, path, this.onChangeEvent);
                this.executorService = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "FileWatcherStrategy");
                this.executorService.submit(this.task);
            }
            catch (IOException e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    private WatchKey registerPathToWatcher(WatchEvent.Modifier modifier, Path path, WatchService watcher) throws IOException {
        WatchKey key = modifier != null ? path.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY}, modifier) : path.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        return key;
    }

    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
            this.executorService = null;
        }
        if (this.watcher != null) {
            IOHelper.close((Closeable)this.watcher);
        }
    }

    protected class WatchFileChangesTask
    implements Runnable {
        private final WatchService watcher;
        private final Path folder;
        private volatile boolean running;
        private OnChangeEvent changeEvent;

        public WatchFileChangesTask(WatchService watcher, Path folder, OnChangeEvent changeEvent) {
            this.watcher = watcher;
            this.folder = folder;
            this.changeEvent = changeEvent;
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            LOG.debug("FileWatcherStrategy is starting watching folder: {}", (Object)this.folder);
            while (FileWatcherStrategy.this.isStarting() || FileWatcherStrategy.this.isRunAllowed()) {
                WatchKey key;
                this.running = true;
                try {
                    LOG.trace("FileWatcherStrategy is polling for file changes in directory: {}", (Object)this.folder);
                    key = this.watcher.poll(FileWatcherStrategy.this.pollTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    break;
                }
                if (key == null) continue;
                Path pathToReload = this.folder;
                Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                while (iterator.hasNext()) {
                    WatchEvent<?> event;
                    WatchEvent<?> we = event = iterator.next();
                    Path path = (Path)we.context();
                    File file = pathToReload.resolve(path).toFile();
                    LOG.trace("Modified/Created/Deleted file: {}", (Object)file);
                    this.changeEvent.onChange(file);
                }
                boolean valid = key.reset();
                if (valid) continue;
                break;
            }
            this.running = false;
            LOG.info("FileWatcherStrategy is stopping watching folder: {}", (Object)this.folder);
        }
    }

    @FunctionalInterface
    public static interface OnChangeEvent {
        public void onChange(File var1);
    }
}

