/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

abstract class AbstractHDRPercentilesAggregator
extends NumericMetricsAggregator.MultiValue {
    protected final double[] keys;
    protected final ValuesSource.Numeric valuesSource;
    protected final DocValueFormat format;
    protected ObjectArray<DoubleHistogram> states;
    protected final int numberOfSignificantValueDigits;
    protected final boolean keyed;

    private static int indexOfKey(double[] keys, double key) {
        return ArrayUtils.binarySearch(keys, key, 0.001);
    }

    AbstractHDRPercentilesAggregator(String name, ValuesSource.Numeric valuesSource, SearchContext context, Aggregator parent, double[] keys, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.keyed = keyed;
        this.format = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AbstractHDRPercentilesAggregator.this.states = bigArrays.grow(AbstractHDRPercentilesAggregator.this.states, bucket + 1L);
                DoubleHistogram state = AbstractHDRPercentilesAggregator.this.states.get(bucket);
                if (state == null) {
                    state = new DoubleHistogram(AbstractHDRPercentilesAggregator.this.numberOfSignificantValueDigits);
                    state.setAutoResize(true);
                    AbstractHDRPercentilesAggregator.this.states.set(bucket, state);
                }
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        state.recordValue(values.nextValue());
                    }
                }
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        return AbstractHDRPercentilesAggregator.indexOfKey(this.keys, Double.parseDouble(name)) >= 0;
    }

    protected DoubleHistogram getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        DoubleHistogram state = this.states.get(bucketOrd);
        return state;
    }

    @Override
    protected void doClose() {
        Releasables.close(this.states);
    }
}

