/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule.quantifier;

import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.quantifier.AbstractRuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MinMaxGreedy
extends AbstractRuleElementQuantifier {
    private INumberExpression min;
    private INumberExpression max;

    public MinMaxGreedy(INumberExpression min, INumberExpression max, boolean interval) {
        if (!interval) {
            this.min = min;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
            if (this.max == null) {
                this.max = new SimpleNumberExpression(Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public List<RuleElementMatch> evaluateMatches(List<RuleElementMatch> matches, MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        int matchedSize;
        boolean result;
        RuleElementMatch ruleElementMatch;
        int minValue = this.min.getIntegerValue(context, stream);
        int maxValue = this.max.getIntegerValue(context, stream);
        if (matches.size() > 0 && !(ruleElementMatch = matches.get(matches.size() - 1)).matched()) {
            matches.remove(ruleElementMatch);
            this.updateLabelAssignment(matches, context, stream);
        }
        boolean bl = result = (matchedSize = matches.size()) >= minValue && matchedSize <= maxValue;
        if (result) {
            return matches;
        }
        return null;
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    @Override
    public boolean continueMatch(boolean after, MatchContext context, AnnotationFS annotation, ComposedRuleElementMatch containerMatch, RutaStream stream, InferenceCrowd crowd) {
        if (annotation == null) {
            return false;
        }
        int minValue = this.min.getIntegerValue(context, stream);
        int maxValue = this.max.getIntegerValue(context, stream);
        List<RuleElementMatch> list = containerMatch.getInnerMatches().get(context.getElement());
        if (list == null) {
            return maxValue > 0;
        }
        int matchedSize = list.size();
        if (list == null || list.isEmpty() || matchedSize < minValue) {
            return true;
        }
        RuleElementMatch lastMatch = null;
        lastMatch = after ? list.get(list.size() - 1) : list.get(0);
        return matchedSize < maxValue || !lastMatch.matched() && matchedSize >= minValue && matchedSize <= maxValue;
    }

    @Override
    public boolean isOptional(MatchContext context, RutaStream stream) {
        int minValue = this.min.getIntegerValue(context, stream);
        return minValue == 0;
    }
}

